/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.validation;

import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.validation.RegularExpressionValidator;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class EmailValidator
extends RegularExpressionValidator {
    private static final String EMAIL_REGURAL_EXPR = "[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}");

    @Override
    public IStatus validate(Object value) {
        if (value != null && value.toString().trim().equals("")) {
            return ValidationStatus.error((String)Messages.EmailValidator_EMAIL_ADDR_REQUIRED_MESSAGE);
        }
        return super.validate(value);
    }

    @Override
    protected String getMessage() {
        return Messages.EmailValidator_INVALID_EMAIL_ADDR_MESSAGE;
    }

    @Override
    protected Pattern getPattern() {
        return EMAIL_PATTERN;
    }
}

