/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui;

import com.progress.tools.reportbug.Constants;
import com.progress.tools.reportbug.ReportGenerator;
import com.progress.tools.reportbug.model.Attachment;
import com.progress.tools.reportbug.model.BugData;
import com.progress.tools.reportbug.model.BugType;
import com.progress.tools.reportbug.model.CustomerType;
import com.progress.tools.reportbug.model.Report;
import com.progress.tools.reportbug.model.Response;
import com.progress.tools.reportbug.store.ProductRegistrationStore;
import com.progress.tools.reportbug.ui.Activator;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.dialogs.ResponseDialog;
import com.progress.tools.reportbug.ui.dialogs.ResubmitDialog;
import com.progress.tools.reportbug.ui.dialogs.SendSavedReportDialog;
import com.progress.tools.reportbug.ui.dialogs.TermsAndConditionsDialog;
import com.progress.tools.reportbug.ui.wizard.composite.AttachmentsComposite;
import com.progress.tools.reportbug.ui.wizard.composite.BasicInfoComposite;
import com.progress.tools.reportbug.ws.WSClient;
import com.progress.tools.reportbug.zipper.ZipCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ReportBugDialog
extends TitleAreaDialog {
    private static final String PRODUCT_REGISTRATION_PAGE_ID = "com.progress.tools.reportbug.ui.preference.ProductRegistrationPage";
    public static final int BUF_SIZE = 1024;
    public static final int SAVE_REPORT = 100;
    public static final int OPEN_REPORT = 101;
    private static boolean flag = false;
    private BasicInfoComposite basicInfoComposite;
    private AttachmentsComposite attachmentsComposite;
    private BugData bugData;
    private ZipCreator zipCreator;
    private Button termsAndConditions;
    protected File file;

    public ReportBugDialog() {
        this(new BugData());
    }

    public ReportBugDialog(BugData data) {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(144);
        this.bugData = data;
        this.zipCreator = new ZipCreator();
        this.init();
    }

    void init() {
        boolean openQuestion;
        String emailId = ProductRegistrationStore.getInstance().getCustomerInfo().getEmail();
        if ((emailId == null || emailId.equals("")) && (openQuestion = MessageDialog.openQuestion((Shell)this.getParentShell(), (String)Messages.ReportBugDialog_PRODUCT_DIALOG_TITLE, (String)Messages.ReportBugDialog_PRODUCT_DIALOG_DESCRIPTION))) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)PRODUCT_REGISTRATION_PAGE_ID, null, null);
            dialog.open();
        }
    }

    protected Control createContents(Composite parent) {
        this.setContextHelp();
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ReportBugDialog_reportTechnicalIssueHeader);
        this.setTitle(Messages.ReportBugDialog_reportTechnicalIssue);
        this.setMessage(Messages.ReportBugDialog_description);
        Image image = Activator.getDefault().getImageRegistry().get("icons/Report-Technical-Issue.gif");
        if (image != null) {
            this.setTitleImage(image);
        }
        return this.createUI(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 101, Messages.ReportBugDialog_openReport, true);
        this.createButton(parent, 100, Messages.ReportBugDialog_saveReport, true);
        Button submitButton = this.createButton(parent, 0, Messages.ReportBugDialog_submitReport, true);
        submitButton.setToolTipText(Messages.ReportBugDialog_submitReportTooltip);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.enableButtons(false);
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(point.x, 700);
    }

    private Composite createUI(Composite parent) {
        Composite topLevel = new Composite(parent, 4);
        topLevel.setLayout((Layout)new GridLayout(1, false));
        topLevel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.basicInfoComposite = new BasicInfoComposite(this, topLevel, 0, this.bugData);
        this.attachmentsComposite = new AttachmentsComposite(this, topLevel, 0, this.bugData);
        Composite emailSupportComposite = this.createEditContactComposite(topLevel);
        Composite termsAndConditions = this.createTermsAndConditionsComposite(topLevel);
        this.basicInfoComposite.setLayoutData(new GridData(4, 4, true, true));
        this.attachmentsComposite.setLayoutData(new GridData(4, 4, true, false));
        emailSupportComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        termsAndConditions.setLayoutData((Object)new GridData(4, 4, true, false));
        return topLevel;
    }

    private Composite createTermsAndConditionsComposite(Composite topLevel) {
        Composite parent = new Composite(topLevel, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.termsAndConditions = new Button(parent, 32);
        this.termsAndConditions.setText("");
        this.termsAndConditions.setSelection(false);
        this.termsAndConditions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportBugDialog.this.validate();
            }
        });
        this.createLink(parent, Messages.ReportBugDialog_reviewTermsAndConditions, (Dialog)new TermsAndConditionsDialog(this.getShell()));
        return parent;
    }

    private void createLink(Composite parent, String text, final Dialog dialog) {
        Link link = new Link(parent, 64);
        link.setText(text);
        link.setLayoutData((Object)new GridData(4, 4, true, false));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dialog.open();
            }
        });
    }

    private Composite createEditContactComposite(Composite topLevel) {
        Composite editContactComposite = new Composite(topLevel, 0);
        editContactComposite.setLayout((Layout)new GridLayout(1, false));
        Link link = new Link(editContactComposite, 64);
        link.setText(Messages.ReportBugDialog_editContactInformation);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)ReportBugDialog.this.getShell(), (String)ReportBugDialog.PRODUCT_REGISTRATION_PAGE_ID, null, null);
                if (dialog.open() == 0) {
                    ReportBugDialog.this.validate();
                }
            }
        });
        return editContactComposite;
    }

    protected void buttonPressed(int buttonId) {
        SendSavedReportDialog dlg;
        int ret;
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else if (100 == buttonId) {
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.zip"});
            dialog.setOverwrite(true);
            dialog.setFileName("report.zip");
            String save = dialog.open();
            if (save != null) {
                this.createZip(new File(save));
                this.close();
            }
        } else if (101 == buttonId && (ret = (dlg = new SendSavedReportDialog(this.getShell())).open()) == 0) {
            this.close();
        }
    }

    private File createZip(final File saveFile) {
        final BugData bugData = new BugData();
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.addAll(this.attachmentsComposite.getAttachments());
        attachments.addAll(this.attachmentsComposite.getLogComposite().getAttachments());
        bugData.setAttachments(attachments);
        bugData.setBugType(this.basicInfoComposite.getModel());
        final File reportBugXMLFile = ReportGenerator.getInstance().getReportAsXmlFile(this.getModel());
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

            protected void setShellStyle(int newShellStyle) {
                super.setShellStyle(4.getDefaultOrientation() | 0x800 | 0x20 | 0x10000 | 0x10 | 0x400);
            }
        };
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.AttachmentsComposite_SAVINGZIP, -1);
                    ReportBugDialog.this.file = ReportBugDialog.this.zipCreator.createZip(bugData, reportBugXMLFile, saveFile);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.file;
    }

    private BugType getModel() {
        BugType type = this.basicInfoComposite.getModel();
        return type;
    }

    protected void okPressed() {
        flag = false;
        try {
            final File file = this.createZip(null);
            final Report report = ReportGenerator.getInstance().generateReport(this.getModel());
            Job job = new Job(Messages.ReportBugDialog_PROGRESS_MONITOR_TITLE){

                public IStatus run(IProgressMonitor monitor) {
                    while (!flag) {
                        try {
                            try {
                                monitor.beginTask(Messages.ReportBugDialog_PROGRESS_MONITOR_DESCRIPTION, -1);
                                WSClient wsclient = new WSClient();
                                final Response response = wsclient.sendBugInfo(report, file);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (response != null) {
                                            if (response.isSuccessful()) {
                                                flag = true;
                                                ResponseDialog dialog = new ResponseDialog(Display.getDefault().getActiveShell(), response);
                                                dialog.open();
                                            } else {
                                                flag = false;
                                                ReportBugDialog.this.resubmitIssue();
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        e.printStackTrace();
                                        ReportBugDialog.this.resubmitIssue();
                                    }
                                });
                                monitor.done();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            throw throwable;
                        }
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    private void resubmitIssue() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell workbenchShell = workbench.getActiveWorkbenchWindow().getShell();
        ResubmitDialog resubmit = new ResubmitDialog(workbenchShell);
        int id = resubmit.open();
        if (id == 0) {
            flag = false;
        } else if (1 == id) {
            flag = true;
        } else if (7000 == id) {
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.zip"});
            dialog.setOverwrite(true);
            dialog.setFileName("report.zip");
            String save = dialog.open();
            if (save != null) {
                try {
                    ReportBugDialog.copyFile(this.file, new File(save));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            flag = true;
        }
    }

    public void validate() {
        if (this.getButton(0) == null) {
            return;
        }
        boolean enableSaveButton = false;
        boolean enableOkButton = false;
        try {
            if (this.basicInfoComposite.getSummary().trim().equals("")) {
                this.setErrorMessage(Messages.BasicInfoComposite_enterSummary);
                return;
            }
            if (this.basicInfoComposite.getDescription().trim().equals("")) {
                this.setErrorMessage(Messages.BasicInfoComposite_enterDescription);
                return;
            }
            if (this.basicInfoComposite.getPriority().equals("")) {
                this.setErrorMessage(Messages.BasicInfoComposite_selectPriority);
                return;
            }
            enableSaveButton = true;
            enableOkButton = true;
            CustomerType customerInfo = ProductRegistrationStore.getInstance().getCustomerInfo();
            if (customerInfo == null || customerInfo.getEmail() == null || "".equals(customerInfo.getEmail())) {
                this.setErrorMessage(Messages.ReportBugDialog_EnterCustomerInfo);
                enableOkButton = false;
                enableSaveButton = false;
                return;
            }
            if (!this.termsAndConditions.getSelection()) {
                enableOkButton = false;
                this.setErrorMessage(Messages.ReportBugDialog_TermsOfUseErrorMessages);
                return;
            }
            long totalSize = this.attachmentsComposite.getTotalSize();
            if (totalSize > Constants.MAX_ATTACH_SIZE) {
                enableOkButton = false;
                this.setErrorMessage(Messages.ReportBugDialog_ATTACH_SIZE_ErrorMessage);
                return;
            }
            if (enableSaveButton && enableOkButton) {
                this.setErrorMessage(null);
            }
        }
        finally {
            this.getButton(0).setEnabled(enableOkButton);
            this.getButton(100).setEnabled(enableSaveButton);
            this.getButton(101).setEnabled(this.termsAndConditions.getSelection());
        }
    }

    private void enableButtons(boolean enable) {
        this.getButton(0).setEnabled(enable);
        this.getButton(100).setEnabled(enable);
        this.getButton(101).setEnabled(enable);
    }

    void setContextHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.progress.tools.reportbug.ui.ReportBugDialog");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File in, File out) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(in);
            try {
                try (FileOutputStream fos = new FileOutputStream(out);){
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = fis.read(buf)) != -1) {
                        fos.write(buf, 0, i);
                    }
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

