/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.preference;

import com.progress.tools.installinfo.IProduct;
import com.progress.tools.installinfo.util.ProductInfoUtil;
import com.progress.tools.reportbug.store.ProductImpl;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.preference.ProductTableCellModifier;
import com.progress.tools.reportbug.ui.preference.ProductTableContentProvider;
import com.progress.tools.reportbug.ui.preference.ProductTableLableProvider;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ProductDetailsComposite
extends Composite {
    public static final String[] COLUMN_PROPERTIES = new String[]{Messages.ProductDetailsComposite_PRODUCT_COLUMN_NAME, Messages.ProductDetailsComposite_VERSION_COLUMN_NAME, Messages.ProductDetailsComposite_BUILD_COLUMN_NAME, Messages.ProductDetailsComposite_SERIAL_NUMBER_COLUMN_NAME};
    private TableViewer productTableViewer;
    private List<ProductImpl> products;

    public ProductDetailsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.createUI();
    }

    private void createUI() {
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.ProductDetailsComposite_PRODUCT_DETAILS_GROUP_NAME);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createProductListLabel(group);
        this.createProductTable(group);
    }

    private void createProductListLabel(Group group) {
        Label productInstalled = new Label((Composite)group, 0);
        productInstalled.setText(Messages.ProductDetailsComposite_PRODUCTS_INSTALLED_LABEL);
        Label listOfProducts = new Label((Composite)group, 0);
        listOfProducts.setText(this.getProductList());
    }

    private String getProductList() {
        IProduct[] products = ProductInfoUtil.getInstance().getProducts();
        if (products == null || products.length == 0) {
            return Messages.ProductDetailsComposite_NO_PRODUCTS_INSTALLED;
        }
        StringBuffer buffer = new StringBuffer();
        IProduct[] iProductArray = products;
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            IProduct product = iProductArray[n2];
            buffer.append(String.valueOf(product.getName()) + ", ");
            ++n2;
        }
        return buffer.substring(0, buffer.length() - 2).toString();
    }

    private void createProductTable(Group group) {
        Table productTable = new Table((Composite)group, 67584);
        this.setTableLayout(productTable);
        this.addTableColumns(productTable);
        this.productTableViewer = this.createTableViewer(productTable);
    }

    public void setInput(List<ProductImpl> p) {
        if (this.productTableViewer != null) {
            this.productTableViewer.setInput(p);
            this.products = p;
        }
    }

    public List<ProductImpl> getInput() {
        return this.products;
    }

    private TableViewer createTableViewer(Table productTable) {
        TableViewer productTableViewer = new TableViewer(productTable);
        productTableViewer.setCellEditors(this.getCellEditors(productTableViewer));
        productTableViewer.setCellModifier((ICellModifier)new ProductTableCellModifier(productTableViewer));
        productTableViewer.setContentProvider((IContentProvider)new ProductTableContentProvider());
        productTableViewer.setLabelProvider((IBaseLabelProvider)new ProductTableLableProvider());
        productTableViewer.setColumnProperties(COLUMN_PROPERTIES);
        return productTableViewer;
    }

    private void addTableColumns(Table productTable) {
        String[] stringArray = COLUMN_PROPERTIES;
        int n = COLUMN_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            this.createTableColumn(productTable, columnName);
            ++n2;
        }
    }

    private void setTableLayout(Table productTable) {
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        productTable.setLayoutData((Object)data);
        productTable.setHeaderVisible(true);
        productTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        productTable.setLayout((Layout)layout);
    }

    private CellEditor[] getCellEditors(TableViewer productTableViewer) {
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[3] = new TextCellEditor((Composite)productTableViewer.getTable(), 0);
        return cellEditorArray;
    }

    private TableColumn createTableColumn(Table table, String text) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(text);
        return column;
    }
}

