/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.web;

import com.atlassian.connector.eclipse.internal.jira.core.service.JiraAuthenticationException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraCaptchaRequiredException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraInvalidResponseTypeException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraRemoteMessageException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraServiceUnavailableException;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.JiraWebSessionCallback;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.xml.sax.SAXException;

public class JiraWebSession {
    private static final int MAX_REDIRECTS = 10;
    private final JiraClient client;
    private String baseUrl;
    private String characterEncoding;
    private final boolean secure;
    private boolean insecureRedirect;
    private boolean logEnabled;
    private final AbstractWebLocation location;
    protected static final String USER_AGENT = "JiraConnector";
    private static final Object SESSION_ID_COOKIE = "JSESSIONID";
    private HttpClient httpClient;
    private HostConfiguration hostConfiguration;
    private final Lock authenticationLock;
    private volatile boolean reauthenticate;

    public JiraWebSession(JiraClient client, String baseUrl) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.secure = baseUrl.startsWith("https");
        this.location = client.getLocation();
        this.authenticationLock = new ReentrantLock();
    }

    public JiraWebSession(JiraClient client) {
        this(client, client.getBaseUrl());
    }

    public void doInSession(JiraWebSessionCallback callback, IProgressMonitor monitor) throws JiraException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        boolean doLogin = this.hostConfiguration == null || this.reauthenticate;
        int MAX_RETRIES = doLogin ? 1 : 2;
        int i = 1;
        while (i <= MAX_RETRIES) {
            try {
                this.lock(monitor);
                if (this.httpClient == null) {
                    this.httpClient = new HttpClient(WebUtil.getConnectionManager());
                    WebUtil.configureHttpClient((HttpClient)this.httpClient, (String)USER_AGENT);
                    this.httpClient.getParams().setCookiePolicy("compatibility");
                    this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
                }
                if (doLogin) {
                    this.reauthenticate = false;
                    this.hostConfiguration = this.login(this.httpClient, monitor);
                }
            }
            finally {
                this.unlock(monitor);
            }
            try {
                if (doLogin || this.isAuthenticated(this.httpClient, this.hostConfiguration, monitor)) {
                    callback.configure(this.httpClient, this.hostConfiguration, this.baseUrl, this.client.getLocalConfiguration().getFollowRedirects());
                    callback.run(this.client, this.baseUrl, monitor);
                    return;
                }
                doLogin = true;
            }
            catch (IOException e) {
                throw new JiraException(e);
            }
            catch (JiraException e) {
                if (this.isXmlParseFailure(e)) {
                    String cfr_ignored_0 = "Unable to parse XML reponse from JIRA. Base URL: " + this.baseUrl + " call: " + callback + (e.getCause() == null ? "" : " caused by: " + e.getCause().getMessage());
                }
                if (this.isAuthenticationFailure(e)) {
                    doLogin = true;
                }
                throw e;
            }
            ++i;
        }
    }

    private boolean isAuthenticated(HttpClient httpClient, HostConfiguration hostConfiguration, IProgressMonitor monitor) throws JiraException {
        String url = String.valueOf(this.baseUrl) + "/secure/UpdateUserPreferences!default.jspa";
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(false);
        try {
            int statusCode = WebUtil.execute((HttpClient)httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (statusCode == 200) {
                return !method.getResponseBodyAsString().contains("/login.jsp?os_destination");
            }
        }
        catch (IOException e) {
            throw new JiraException(e);
        }
        return false;
    }

    private boolean isXmlParseFailure(JiraException e) {
        return e.getCause() != null && e.getCause() instanceof SAXException;
    }

    private boolean isAuthenticationFailure(JiraException e) {
        if (e instanceof JiraRemoteMessageException) {
            String message = ((JiraRemoteMessageException)e).getHtmlMessage();
            return message != null && message.contains("login.jsp");
        }
        return e instanceof JiraInvalidResponseTypeException;
    }

    public void doLogout(IProgressMonitor monitor) throws JiraException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            this.lock(monitor);
            if (this.hostConfiguration == null) {
                return;
            }
            this.logout(this.httpClient, this.hostConfiguration, monitor);
            this.hostConfiguration = null;
        }
        finally {
            this.unlock(monitor);
        }
    }

    private void lock(IProgressMonitor monitor) {
        while (!monitor.isCanceled()) {
            try {
                if (!this.authenticationLock.tryLock(2000L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        throw new OperationCanceledException();
    }

    private void unlock(IProgressMonitor monitor) {
        this.authenticationLock.unlock();
    }

    protected String getCharacterEncoding() {
        return this.characterEncoding;
    }

    protected String getBaseURL() {
        return this.baseUrl;
    }

    protected boolean isInsecureRedirect() {
        return this.insecureRedirect;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected boolean isLogEnabled() {
        return this.logEnabled;
    }

    protected void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    private String getContentType() {
        String characterEncoding = this.getCharacterEncoding();
        if (characterEncoding == null) {
            characterEncoding = this.client.getLocalConfiguration().getCharacterEncoding();
        }
        if (characterEncoding == null) {
            characterEncoding = this.client.getLocalConfiguration().getDefaultCharacterEncoding();
        }
        return "application/x-www-form-urlencoded; charset=" + characterEncoding;
    }

    private HostConfiguration login(HttpClient httpClient, IProgressMonitor monitor) throws JiraException {
        RedirectTracker tracker = new RedirectTracker();
        boolean jira4x = true;
        boolean externalRedirect = false;
        int i = 0;
        while (i <= 10) {
            block19: {
                AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
                if (credentials == null) {
                    credentials = new AuthenticationCredentials("", "");
                }
                String url = String.valueOf(this.baseUrl) + (jira4x ? "/rest/gadget/1.0/login" : "/secure/Dashboard.jspa");
                PostMethod login = new PostMethod(url);
                login.setFollowRedirects(false);
                login.setRequestHeader("Content-Type", this.getContentType());
                login.addParameter("os_username", credentials.getUserName());
                login.addParameter("os_password", credentials.getPassword());
                login.addParameter("os_destination", "/success");
                tracker.addUrl(url);
                try {
                    HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
                    int statusCode = WebUtil.execute((HttpClient)httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)login, (IProgressMonitor)monitor);
                    if (statusCode == 404) {
                        jira4x = false;
                        break block19;
                    }
                    if (this.needsReauthentication(httpClient, login, monitor)) {
                        break block19;
                    }
                    if (statusCode != 302 && statusCode != 301) {
                        throw new JiraServiceUnavailableException("Unexpected status code during login: " + statusCode);
                    }
                    tracker.addRedirect(url, (HttpMethodBase)login, statusCode);
                    this.characterEncoding = login.getResponseCharSet();
                    Header locationHeader = login.getResponseHeader("location");
                    if (locationHeader == null) {
                        throw new JiraServiceUnavailableException("Invalid redirect, missing location");
                    }
                    url = locationHeader.getValue();
                    tracker.checkForCircle(url);
                    if (!this.insecureRedirect && this.isSecure() && url.startsWith("http://")) {
                        tracker.log("Redirect to insecure location during login to repository: " + this.client.getBaseUrl());
                        this.insecureRedirect = true;
                    }
                    try {
                        URL base = new URL(this.baseUrl);
                        URL dest = new URL(url);
                        if (base.getHost() != null && !base.getHost().equals(dest.getHost())) {
                            externalRedirect = true;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                    if (!url.endsWith("/success")) break block19;
                    String newBaseUrl = url.substring(0, url.lastIndexOf("/success"));
                    if (this.baseUrl.equals(newBaseUrl) || !this.client.getLocalConfiguration().getFollowRedirects()) {
                        this.addAuthenticationCookie(httpClient, login);
                        HostConfiguration hostConfiguration2 = hostConfiguration;
                        return hostConfiguration2;
                    }
                    try {
                        this.baseUrl = newBaseUrl;
                    }
                    catch (IOException e) {
                        throw new JiraServiceUnavailableException(e);
                    }
                }
                finally {
                    login.releaseConnection();
                }
            }
            ++i;
        }
        tracker.log("Exceeded maximum number of allowed redirects during login to repository: " + this.client.getBaseUrl());
        String message = "Exceeded maximum number of allowed redirects during login";
        if (externalRedirect) {
            message = String.valueOf(message) + "\n Redirect to external address is not allowed";
        }
        throw new JiraServiceUnavailableException(message);
    }

    private void addAuthenticationCookie(HttpClient httpClient, PostMethod method) {
        Cookie[] cookies;
        Cookie[] cookieArray = cookies = httpClient.getState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (SESSION_ID_COOKIE.equals(cookie.getName())) {
                return;
            }
            ++n2;
        }
        cookieArray = method.getResponseHeaders();
        n = cookieArray.length;
        n2 = 0;
        while (n2 < n) {
            Cookie header = cookieArray[n2];
            if (header.getName().equalsIgnoreCase("Set-Cookie")) {
                int i;
                String cookie = header.getValue();
                int index = cookie.indexOf(59);
                if (index != -1) {
                    cookie = cookie.substring(0, index);
                }
                String key = (i = cookie.indexOf("=")) != -1 ? cookie.substring(0, i) : cookie;
                cookie = i != -1 ? cookie.substring(i + 1) : "";
                httpClient.getState().addCookie(new Cookie(WebUtil.getHost((String)this.baseUrl), key, cookie, WebUtil.getRequestPath((String)this.baseUrl), null, JiraWebSession.isSecure(this.baseUrl)));
            }
            ++n2;
        }
    }

    private static boolean isSecure(String repositoryUrl) {
        return repositoryUrl.matches("https.*");
    }

    private boolean needsReauthentication(HttpClient httpClient, PostMethod method, IProgressMonitor monitor) throws JiraAuthenticationException, IOException, JiraServiceUnavailableException {
        AuthenticationType authenticationType;
        int code = method.getStatusCode();
        if (code == 200) {
            authenticationType = AuthenticationType.REPOSITORY;
        } else if (code == 407) {
            authenticationType = AuthenticationType.PROXY;
        } else {
            return false;
        }
        if (!this.getContentType().endsWith(method.getResponseCharSet())) {
            this.characterEncoding = method.getResponseCharSet();
            return true;
        }
        if (method.getResponseHeader("Content-Type").getValue().startsWith("application/json")) {
            String json = method.getResponseBodyAsString(1024);
            if (json.contains("\"captchaFailure\":true")) {
                throw new JiraCaptchaRequiredException(null);
            }
            if (json.contains("\"loginFailedByPermissions\":true")) {
                throw new JiraServiceUnavailableException("You don't have permission to login");
            }
        }
        try {
            this.location.requestCredentials(authenticationType, null, (IProgressMonitor)(Policy.isBackgroundMonitor((IProgressMonitor)monitor) ? SubMonitor.convert((IProgressMonitor)monitor) : monitor));
        }
        catch (UnsupportedRequestException unsupportedRequestException) {
            throw new JiraAuthenticationException("Login failed.");
        }
        return true;
    }

    private void logout(HttpClient httpClient, HostConfiguration hostConfiguration, IProgressMonitor monitor) throws JiraException {
        GetMethod logout = new GetMethod(String.valueOf(this.baseUrl) + "/logout");
        logout.setFollowRedirects(false);
        try {
            try {
                WebUtil.execute((HttpClient)httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)logout, (IProgressMonitor)monitor);
                httpClient.getState().clear();
            }
            catch (IOException iOException) {
                logout.releaseConnection();
            }
        }
        finally {
            logout.releaseConnection();
        }
    }

    public void purgeSession() {
        this.reauthenticate = true;
    }

    private class RedirectInfo {
        final int statusCode;
        final String url;
        final Header[] responseHeaders;

        public RedirectInfo(String url, int statusCode, Header[] responseHeaders) {
            this.url = url;
            this.statusCode = statusCode;
            this.responseHeaders = responseHeaders;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Request: ");
            sb.append(this.url).append('\n');
            sb.append("Status: ").append(this.statusCode).append('\n');
            Header[] headerArray = this.responseHeaders;
            int n = this.responseHeaders.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                if (header.getName().equalsIgnoreCase("Server") || header.getName().equalsIgnoreCase("Location")) {
                    sb.append(header.toExternalForm());
                }
                ++n2;
            }
            return sb.toString();
        }
    }

    private class RedirectTracker {
        ArrayList<RedirectInfo> redirects = new ArrayList();
        Set<String> urls = new HashSet<String>();
        private boolean loggedCircle;

        private RedirectTracker() {
        }

        public void addUrl(String url) {
            this.urls.add(url);
        }

        public void checkForCircle(String url) {
            if (!this.loggedCircle && this.urls.contains(url)) {
                this.log("Circular redirect detected while login in to repository: " + JiraWebSession.this.client.getBaseUrl());
                this.loggedCircle = true;
            }
        }

        public void addRedirect(String url, HttpMethodBase method, int statusCode) {
            this.redirects.add(new RedirectInfo(url, statusCode, method.getResponseHeaders()));
        }

        public void log(String message) {
            if (!JiraWebSession.this.isLogEnabled()) {
                return;
            }
            MultiStatus status = new MultiStatus("com.atlassian.connector.eclipse.internal.jira.core", 0, message, null);
            for (RedirectInfo info : this.redirects) {
                status.add((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", 0, info.toString(), null));
            }
            StatusHandler.log((IStatus)status);
        }
    }
}

