/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.core.CoreMessages;
import com.atlassian.connector.eclipse.internal.jira.core.InvalidJiraQueryException;
import com.atlassian.connector.eclipse.internal.jira.core.JiraClientManager;
import com.atlassian.connector.eclipse.internal.jira.core.Messages;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraAuthenticationException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraCaptchaRequiredException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraRemoteMessageException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraServiceUnavailableException;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis.AxisProperties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class JiraCorePlugin
extends Plugin {
    public static final String ID_PLUGIN = "com.atlassian.connector.eclipse.internal.jira.core";
    private static JiraCorePlugin plugin;
    private static JiraClientManager clientManager;
    public static final String CONNECTOR_KIND = "jira";
    public static final String LABEL;
    private static boolean initialized;

    static {
        LABEL = NLS.bind((String)Messages.JiraCorePlugin_JIRA_description, (Object)"5.0");
    }

    public JiraCorePlugin() {
        plugin = this;
        AxisProperties.setProperty((String)"attachments.implementation", (String)"org.eclipse.mylyn.does.not.exist");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        File serverCache = this.getStateLocation().append("serverCache").toFile();
        JiraCorePlugin.initialize(serverCache);
    }

    public static void initialize(File serverCacheDirectory) {
        if (initialized) {
            throw new IllegalStateException("Already initialized");
        }
        initialized = true;
        Logger logger = Logger.getLogger("org.apache.axis.utils.JavaUtils");
        logger.setLevel(Level.SEVERE);
        clientManager = new JiraClientManager(serverCacheDirectory);
        clientManager.start();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (clientManager != null) {
            clientManager.stop();
        }
        plugin = null;
        clientManager = null;
    }

    public static JiraCorePlugin getDefault() {
        return plugin;
    }

    public static JiraClientManager getClientManager() {
        if (!initialized) {
            throw new IllegalStateException("Not yet initialized");
        }
        return clientManager;
    }

    public static IStatus toStatus(TaskRepository repository, Throwable e) {
        String url = repository.getRepositoryUrl();
        if (e instanceof JiraCaptchaRequiredException) {
            return new RepositoryStatus(repository.getRepositoryUrl(), 4, ID_PLUGIN, 3, CoreMessages.Captcha_authentication_required);
        }
        if (e instanceof JiraAuthenticationException) {
            return RepositoryStatus.createLoginError((String)url, (String)ID_PLUGIN);
        }
        if (e instanceof JiraServiceUnavailableException) {
            return new RepositoryStatus(url, 4, ID_PLUGIN, 5, e.getMessage(), e);
        }
        if (e instanceof JiraRemoteMessageException) {
            return RepositoryStatus.createHtmlStatus((String)url, (int)4, (String)ID_PLUGIN, (int)1, (String)e.getMessage(), (String)((JiraRemoteMessageException)e).getHtmlMessage());
        }
        if (e instanceof JiraException) {
            return new RepositoryStatus(url, 4, ID_PLUGIN, 1, e.getMessage(), e);
        }
        if (e instanceof InvalidJiraQueryException) {
            return new RepositoryStatus(url, 4, ID_PLUGIN, 1, NLS.bind((String)CoreMessages.Invalid_query, (Object)e.getMessage()), e);
        }
        return RepositoryStatus.createInternalError((String)ID_PLUGIN, (String)"Unexpected error", (Throwable)e);
    }
}

