/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.IJiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.JiraClientManager;
import com.atlassian.connector.eclipse.internal.jira.core.JiraCorePlugin;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraVersion;
import com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraLocalConfiguration;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

public class JiraClientFactory
implements IRepositoryListener,
IRepositoryChangeListener,
IJiraClientFactory {
    private static JiraClientFactory instance = null;
    private JiraClientManager clientManager = null;
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private boolean forceTaskRepositoryLocationFactory;

    private JiraClientFactory() {
        this.clientManager = JiraCorePlugin.getClientManager();
    }

    public void clearClients() {
        this.clientManager.removeAllClients(false);
    }

    public void clearClientsAndConfigurationData() {
        this.clientManager.removeAllClients(true);
    }

    @Override
    public synchronized JiraClient getJiraClient(TaskRepository repository) {
        JiraClient client = this.clientManager.getClient(repository.getRepositoryUrl());
        if (client == null) {
            AbstractWebLocation location = this.taskRepositoryLocationFactory.createWebLocation(repository);
            client = this.clientManager.addClient(location, JiraUtil.getLocalConfiguration(repository));
        }
        return client;
    }

    public static synchronized JiraClientFactory getDefault() {
        if (instance == null) {
            instance = new JiraClientFactory();
        }
        return instance;
    }

    public synchronized void logOutFromAll() {
        JiraClient[] clients;
        JiraClient[] jiraClientArray = clients = this.clientManager.getAllClients();
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            JiraClient client = jiraClientArray[n2];
            try {
                client.logout(null);
            }
            catch (JiraException jiraException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        if (repository.getConnectorKind().equals("jira")) {
            assert (this.clientManager.getClient(repository.getRepositoryUrl()) == null);
            this.getJiraClient(repository);
        }
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        JiraClient client;
        if (repository.getConnectorKind().equals("jira") && (client = this.clientManager.getClient(repository.getRepositoryUrl())) != null) {
            this.clientManager.removeClient(client, true);
        }
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
    }

    public synchronized void repositoryChanged(TaskRepositoryChangeEvent event) {
        JiraClient client;
        TaskRepository repository = event.getRepository();
        if (repository.getConnectorKind().equals("jira") && (client = this.clientManager.getClient(repository.getRepositoryUrl())) != null) {
            if (event.getDelta().getType() == TaskRepositoryDelta.Type.ALL) {
                client.purgeSession();
                this.updateClient(client, repository);
            } else if (event.getDelta().getType() == TaskRepositoryDelta.Type.CREDENTIALS || event.getDelta().getType() == TaskRepositoryDelta.Type.PROYX) {
                this.updateClient(client, repository);
                client.purgeSession();
            } else {
                this.updateClient(client, repository);
                client.purgeSession();
            }
        }
    }

    private void updateClient(JiraClient client, TaskRepository repository) {
        JiraLocalConfiguration configuration = JiraUtil.getLocalConfiguration(repository);
        if (!configuration.equals(client.getLocalConfiguration())) {
            client.setLocalConfiguration(configuration);
        }
    }

    public ServerInfo validateConnection(AbstractWebLocation location, IProgressMonitor monitor) throws JiraException {
        return this.validateConnection(location, new JiraLocalConfiguration(), monitor);
    }

    public ServerInfo validateConnection(AbstractWebLocation location, JiraLocalConfiguration configuration, IProgressMonitor monitor) throws JiraException {
        ServerInfo info = this.clientManager.validateConnection(location, configuration, monitor);
        JiraVersion serverVersion = new JiraVersion(info.getVersion());
        if (JiraVersion.MIN_VERSION.compareTo(serverVersion) > 0) {
            throw new JiraException("JIRA connector requires server " + JiraVersion.MIN_VERSION + " or later");
        }
        return info;
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory, boolean force) {
        if (this.forceTaskRepositoryLocationFactory) {
            return;
        }
        this.forceTaskRepositoryLocationFactory = force;
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }
}

