/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.model;

public class JiraVersion
implements Comparable<JiraVersion> {
    public static final JiraVersion JIRA_3_13 = new JiraVersion("3.13");
    public static final JiraVersion JIRA_4_1 = new JiraVersion("4.1");
    public static final JiraVersion JIRA_4_2 = new JiraVersion("4.2");
    public static final JiraVersion JIRA_5_0;
    public static final JiraVersion MIN_VERSION;
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    static {
        MIN_VERSION = JIRA_5_0 = new JiraVersion("5.0");
    }

    public JiraVersion(String version) {
        String[] segments = version == null ? new String[]{} : version.split("\\.");
        this.major = segments.length > 0 ? this.parse(segments[0]) : 0;
        this.minor = segments.length > 1 ? this.parse(segments[1]) : 0;
        this.micro = segments.length > 2 ? this.parse(segments[2]) : 0;
        this.qualifier = segments.length == 0 ? "" : this.getQualifier(segments[segments.length - 1]);
    }

    private int parse(String segment) {
        try {
            return segment.length() == 0 ? 0 : Integer.parseInt(this.getVersion(segment));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private String getVersion(String segment) {
        int n = segment.indexOf(45);
        return n == -1 ? segment : segment.substring(0, n);
    }

    private String getQualifier(String segment) {
        int n = segment.indexOf(45);
        return n == -1 ? "" : segment.substring(n + 1);
    }

    public boolean isSmallerOrEquals(JiraVersion v) {
        return this.compareTo(v) <= 0;
    }

    @Override
    public int compareTo(JiraVersion v) {
        if (this.major < v.major) {
            return -1;
        }
        if (this.major > v.major) {
            return 1;
        }
        if (this.minor < v.minor) {
            return -1;
        }
        if (this.minor > v.minor) {
            return 1;
        }
        if (this.micro < v.micro) {
            return -1;
        }
        if (this.micro > v.micro) {
            return 1;
        }
        return this.qualifier.compareTo(v.qualifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.major));
        sb.append(".").append(Integer.toString(this.minor));
        if (this.micro > 0) {
            sb.append(".").append(Integer.toString(this.micro));
        }
        if (this.qualifier.length() > 0) {
            sb.append("-").append(this.qualifier);
        }
        return sb.toString();
    }
}

