/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.IJavaData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.JavaData;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.access.AbstractAccessor;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.JavaEventListType;
import rabbit.data.internal.xml.schema.events.JavaEventType;

public class JavaDataAccessor
extends AbstractAccessor<IJavaData, JavaEventType, JavaEventListType> {
    @Inject
    JavaDataAccessor(@Named(value="JavaStore") IDataStore store) {
        super(store);
    }

    @Override
    protected IJavaData createDataNode(LocalDate date, WorkspaceStorage ws, JavaEventType type) throws Exception {
        Duration duration = new Duration(type.getDuration());
        IJavaElement element = JavaCore.create((String)type.getHandleIdentifier());
        return new JavaData(date, ws, duration, element);
    }

    @Override
    protected Collection<JavaEventType> getElements(JavaEventListType category) {
        return category.getJavaEvent();
    }

    @Override
    protected Collection<JavaEventListType> getCategories(EventListType doc) {
        return doc.getJavaEvents();
    }
}

