/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.ILaunchData;
import rabbit.data.access.model.LaunchConfigurationDescriptor;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.LaunchData;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.access.AbstractAccessor;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.LaunchEventListType;
import rabbit.data.internal.xml.schema.events.LaunchEventType;

public class LaunchDataAccessor
extends AbstractAccessor<ILaunchData, LaunchEventType, LaunchEventListType> {
    @Inject
    LaunchDataAccessor(@Named(value="LaunchStore") IDataStore store) {
        super(store);
    }

    @Override
    protected ILaunchData createDataNode(LocalDate date, WorkspaceStorage ws, LaunchEventType type) throws Exception {
        Duration duration = new Duration(type.getTotalDuration());
        LaunchConfigurationDescriptor config = new LaunchConfigurationDescriptor(type.getName(), type.getLaunchModeId(), type.getLaunchTypeId());
        HashSet files = Sets.newHashSet();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (String str : type.getFilePath()) {
            try {
                files.add(root.getFile((IPath)new Path(str)));
            }
            catch (Exception e) {
                System.err.println(String.valueOf(this.getClass().getSimpleName()) + " - Invalid file path: str\n\t" + e.getMessage());
            }
        }
        return new LaunchData(date, ws, config, type.getCount(), duration, files);
    }

    @Override
    protected Collection<LaunchEventListType> getCategories(EventListType doc) {
        return doc.getLaunchEvents();
    }

    @Override
    protected Collection<LaunchEventType> getElements(LaunchEventListType list) {
        return list.getLaunchEvent();
    }
}

