/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.GregorianCalendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.ITaskData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.common.TaskId;
import rabbit.data.internal.access.model.TaskData;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.access.AbstractAccessor;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.TaskFileEventListType;
import rabbit.data.internal.xml.schema.events.TaskFileEventType;

public class TaskDataAccessor
extends AbstractAccessor<ITaskData, TaskFileEventType, TaskFileEventListType> {
    @Inject
    TaskDataAccessor(@Named(value="TaskStore") IDataStore store) {
        super(store);
    }

    @Override
    protected ITaskData createDataNode(LocalDate date, WorkspaceStorage ws, TaskFileEventType t) throws Exception {
        Duration duration = new Duration(t.getDuration());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)new Path(t.getFilePath()));
        String handleId = t.getTaskId().getHandleId();
        GregorianCalendar createDate = t.getTaskId().getCreationDate().toGregorianCalendar();
        TaskId taskId = new TaskId(handleId, createDate.getTime());
        return new TaskData(date, ws, duration, file, taskId);
    }

    @Override
    protected Collection<TaskFileEventListType> getCategories(EventListType doc) {
        return doc.getTaskFileEvents();
    }

    @Override
    protected Collection<TaskFileEventType> getElements(TaskFileEventListType t) {
        return t.getTaskFileEvent();
    }
}

