/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.openedge.pdt.analytics.readers.LaunchEventReader;
import com.openedge.pdt.analytics.readers.PartEventReader;
import com.openedge.pdt.analytics.readers.PerspectiveEventReader;
import com.openedge.pdt.analytics.readers.SessionReader;
import com.openedge.pdt.core.OECommonServicesPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import rabbit.tracking.ITracker;
import rabbit.tracking.internal.IdleDetector;

public class TrackingPlugin
extends AbstractUIPlugin
implements IWorkbenchListener {
    public static final String PLUGIN_ID = "com.openedge.pdt.analytics";
    public static final String TRACKER_EXTENSION_ID = "rabbit.tracking.trackers";
    private static TrackingPlugin plugin;
    private static final String PROP_STORAGE_ROOT = "storage.root";
    private IdleDetector idleDetector;
    private ImmutableSet<ITracker<?>> trackers;
    private Properties properties = new Properties();

    public static TrackingPlugin getDefault() {
        return plugin;
    }

    public TrackingPlugin() {
        long oneSec = TimeUnit.SECONDS.toMillis(1L);
        long oneMin = TimeUnit.MINUTES.toMillis(1L);
        this.idleDetector = new IdleDetector(this.getWorkbench().getDisplay(), oneMin, oneSec);
        this.trackers = ImmutableSet.of();
    }

    public IdleDetector getIdleDetector() {
        return this.idleDetector;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        for (ITracker tracker : this.trackers) {
            tracker.setEnabled(false);
        }
        return true;
    }

    public void saveCurrentData() {
        for (ITracker tracker : this.trackers) {
            tracker.setEnabled(false);
            tracker.flushData();
            tracker.setEnabled(true);
        }
    }

    /*
     * Loose catch block
     */
    public void start(BundleContext context) throws Exception {
        block9: {
            super.start(context);
            plugin = this;
            if (this.trackers != null) {
                this.setEnableTrackers((ImmutableCollection<ITracker<?>>)this.trackers, false);
            }
            this.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
            this.trackers = this.createTrackers();
            this.setEnableTrackers((ImmutableCollection<ITracker<?>>)this.trackers, true);
            this.idleDetector.setRunning(true);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.getPropertiesFile()));
                this.properties.load(reader);
            }
            catch (FileNotFoundException e) {
                System.err.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - start: " + e.getMessage());
                IOUtils.closeQuietly((Reader)reader);
                this.checkProperties(this.properties);
                break block9;
            }
            catch (IOException e) {
                System.err.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - start: " + e.getMessage());
                IOUtils.closeQuietly((Reader)reader);
                this.checkProperties(this.properties);
                break block9;
            }
            catch (IllegalArgumentException e) {
                System.err.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - start: " + e.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        this.checkProperties(this.properties);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                this.checkProperties(this.properties);
                break block9;
            }
            IOUtils.closeQuietly((Reader)reader);
            this.checkProperties(this.properties);
        }
    }

    public void stop(BundleContext context) throws Exception {
        block5: {
            this.idleDetector.setRunning(false);
            TrackingPlugin.pushToTelerik();
            BufferedWriter writer = null;
            try {
                try {
                    this.checkProperties(this.properties);
                    writer = new BufferedWriter(new FileWriter(this.getPropertiesFile()));
                    String comment = String.format("This file contains configurations for the Rabbit Eclipse plugin.%nPlease do not delete, otherwise Rabbit will not work properly.", new Object[0]);
                    this.properties.store(writer, comment);
                }
                catch (IOException e) {
                    System.err.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - stop: " + e.getMessage());
                    IOUtils.closeQuietly((Writer)writer);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        plugin = null;
        super.stop(context);
        this.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this);
        this.setEnableTrackers((ImmutableCollection<ITracker<?>>)this.trackers, false);
        plugin = null;
        super.stop(context);
    }

    protected static void pushToTelerik() {
        SessionReader.getInstance().pushData();
        PartEventReader.getInstance().pushData();
        PerspectiveEventReader.getInstance().pushData();
        LaunchEventReader.getInstance().pushData();
    }

    private ImmutableSet<ITracker<?>> createTrackers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TRACKER_EXTENSION_ID);
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement e = iConfigurationElementArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e2) {
                    OECommonServicesPlugin.log((Throwable)e2, (String)TrackingPlugin.PLUGIN_ID, (String)e2.getMessage(), (int)4);
                }

                public void run() throws Exception {
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof ITracker) {
                        builder.add((Object)((ITracker)o));
                    } else {
                        System.err.println("Object is not a tracker: " + o);
                    }
                }
            });
            ++n2;
        }
        return builder.build();
    }

    private void setEnableTrackers(ImmutableCollection<ITracker<?>> trackers, boolean enable) {
        for (ITracker tracker : trackers) {
            tracker.setEnabled(enable);
        }
    }

    public IPath getStoragePath() {
        IPath path = TrackingPlugin.getDefault().getStateLocation().append("analytics");
        File file = path.toFile();
        if (!file.exists() && !file.mkdirs()) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Unable to create folder (" + file + ") for saving Rabbit's data!"));
        }
        return path;
    }

    private void checkProperties(Properties prop) {
        if (prop.getProperty(PROP_STORAGE_ROOT) == null) {
            prop.setProperty(this.getStoragePropertyString(this.getStoragePath()), ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        }
    }

    public String getStoragePropertyString(IPath storagePath) {
        return "_ws_" + storagePath.lastSegment();
    }

    private String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public IPath getWorkspacePath(IPath storagePath) {
        String workspacePathString = this.getProperty(this.getStoragePropertyString(storagePath));
        if (workspacePathString != null) {
            return new Path(workspacePathString);
        }
        return null;
    }

    private File getPropertiesFile() {
        String str = FilenameUtils.concat((String)System.getProperty("user.home"), (String)".rabbit.properties");
        return new File(str);
    }
}

