/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.trackers;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.joda.time.Interval;
import rabbit.data.handler.DataHandler;
import rabbit.data.store.IStorer;
import rabbit.data.store.model.SessionEvent;
import rabbit.tracking.internal.IdleDetector;
import rabbit.tracking.internal.TrackingPlugin;
import rabbit.tracking.internal.trackers.AbstractTracker;
import rabbit.tracking.internal.util.Recorder;
import rabbit.tracking.internal.util.WorkbenchUtil;

public class SessionTracker
extends AbstractTracker<SessionEvent> {
    private final Recorder<Object> recorder = new Recorder();
    private final Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (!SessionTracker.this.isEnabled()) {
                return;
            }
            if (o == TrackingPlugin.getDefault().getIdleDetector()) {
                IdleDetector dt = (IdleDetector)o;
                if (dt.isUserActive()) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(SessionTracker.this.startRecorder);
                } else {
                    SessionTracker.this.recorder.stop();
                }
            } else if (o == SessionTracker.this.recorder) {
                Recorder.Record r = SessionTracker.this.recorder.getLastRecord();
                long start = r.getStartTimeMillis();
                long end = r.getEndTimeMillis();
                SessionTracker.this.addData(new SessionEvent(new Interval(start, end)));
            }
        }
    };
    private final Runnable startRecorder = new Runnable(){

        @Override
        public void run() {
            IWorkbenchWindow win = WorkbenchUtil.getActiveWindow();
            if (WorkbenchUtil.isActiveShell(win)) {
                SessionTracker.this.recorder.start();
            }
        }
    };

    public SessionTracker() {
        this.recorder.addObserver(this.observer);
    }

    @Override
    protected IStorer<SessionEvent> createDataStorer() {
        return DataHandler.getStorer(SessionEvent.class);
    }

    @Override
    protected void doDisable() {
        TrackingPlugin.getDefault().getIdleDetector().deleteObserver(this.observer);
        this.recorder.stop();
    }

    @Override
    protected void doEnable() {
        TrackingPlugin.getDefault().getIdleDetector().addObserver(this.observer);
        PlatformUI.getWorkbench().getDisplay().syncExec(this.startRecorder);
    }
}

