/*************************************************************/
/* Copyright (c) 2010 by Progress Software Corporation       */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

/* this procedure reads the procedures from the session and returns them in string format */
DEFINE INPUT PARAMETER  input_procs AS LONGCHAR.

DEFINE VARIABLE procs AS CHARACTER NO-UNDO.
DEFINE VARIABLE superprocs_count AS INTEGER NO-UNDO.
DEFINE VARIABLE internalprocs_count AS INTEGER NO-UNDO.
DEFINE VARIABLE i AS INTEGER NO-UNDO.
DEFINE VARIABLE j AS INTEGER NO-UNDO.
DEFINE VARIABLE k AS INTEGER NO-UNDO.
DEFINE OUTPUT PARAMETER  total_procs AS LONGCHAR.

DEFINE VARIABLE proc_name AS CHARACTER NO-UNDO.
DEFINE VARIABLE internal_proc_name AS CHARACTER NO-UNDO.
DEFINE VARIABLE proc_handler AS HANDLE.
DEFINE VARIABLE proc_entries AS CHARACTER.
DEFINE VARIABLE proc_signature AS CHARACTER.
DEFINE VARIABLE signature_count AS INTEGER.

procs = SESSION:SUPER-PROCEDURES.
total_procs = ''.
superprocs_count = NUM-ENTRIES(procs, ',').                                


DEFINE VARIABLE var1 AS CHARACTER.
DEFINE VARIABLE var2 AS CHARACTER.
DEFINE VARIABLE var3 AS CHARACTER.

var1 = ''.
var2 = ''.
var3 = ''.

DO i=1 TO superprocs_count:
    proc_name = ENTRY(i,procs,',').
    proc_handler = HANDLE(proc_name).
   
    proc_entries = proc_handler:INTERNAL-ENTRIES.
    internalprocs_count = NUM-ENTRIES(proc_entries, ',').
    
    DO j=1 TO internalprocs_count:
        internal_proc_name = ENTRY(j,proc_entries,',').
        proc_signature =   proc_handler:GET-SIGNATURE(internal_proc_name).
        var1 = ENTRY(1,proc_signature,',').
        var2 = ENTRY(2,proc_signature,',').
        signature_count = NUM-ENTRIES(proc_signature, ',').
        
        var3 = ''.
        DO k=3 TO signature_count:
            IF k = signature_count THEN
                var3 = var3 + ENTRY(k,proc_signature,',').
            ELSE
                var3 = var3 + ENTRY(k,proc_signature,',') + ','.
        END.

        total_procs = total_procs + var1 + " " + var2 + " " + internal_proc_name + " (" + var3 + ")" + "$".
        
    END.    
END.
