/* ***********************************************************/
/* Copyright (c) 2009-2016 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

DEFINE VARIABLE fLoggerHandle  AS HANDLE    NO-UNDO.
DEFINE VARIABLE fContextHandle AS HANDLE    NO-UNDO.

/* This is calculated on startup from setContextHandle  */
DEFINE VARIABLE fRunDir        AS CHARACTER NO-UNDO.

fRunDir = REPLACE(THIS-PROCEDURE:FILE-NAME,"_idedbruntime.p","").

FUNCTION log RETURNS CHARACTER 
    ( INPUT msg AS CHARACTER).
	
    IF VALID-HANDLE(fLoggerHandle) THEN 
    DO:
	
        DYNAMIC-FUNCTION("log" IN fLoggerHandle, msg).
    END.
END FUNCTION.



FUNCTION getWorkDirectory RETURNS CHARACTER 
    ( ) IN fContextHandle.

/* hide as ade object in the persistent procedure viewer  */
PROCEDURE adepersistent:
END.

PROCEDURE destroyObject:
    DELETE PROCEDURE THIS-PROCEDURE.
END PROCEDURE.

PROCEDURE setLoggerHandle:
    DEFINE INPUT PARAMETER hLogger AS HANDLE NO-UNDO.
    fLoggerHandle = hLogger.
END.   

PROCEDURE setContextHandle:
    DEFINE INPUT PARAMETER hContext AS HANDLE NO-UNDO.
    fContextHandle = hContext.
END.


/* retrieve the schema for any connected database
*/
PROCEDURE getDBSchemas:
    DEFINE INPUT  PARAMETER cPrm AS CHARACTER  NO-UNDO.

    LOG( "CREATING SCHEMAS").
    RUN VALUE(fRunDir + "_dblist.p") (getWorkDirectory()).  /* Pass table name if given */	
    RETURN RETURN-VALUE.
END PROCEDURE.

procedure getNumDatabases:
    define input  parameter cPrm as character  no-undo.
    return string(num-dbs).
end procedure.


PROCEDURE generateDBSchemas:
    /*------------------------------------------------------------------
     This will get generate the schema cache for the specified schemas
    
     Input Parameters:
       p_DBNameList  A comma delimited list of the name of the databases
    ---------------------------------------------------------------------*/
    DEFINE INPUT PARAMETER  p_DBNameList  AS CHARACTER NO-UNDO.

    DEFINE VARIABLE cDB           AS CHARACTER NO-UNDO.
    DEFINE VARIABLE i1            AS INTEGER   NO-UNDO.
    DEFINE VARIABLE j             AS INTEGER   NO-UNDO.
    DEFINE VARIABLE guidEntry     AS CHARACTER NO-UNDO.
    DEFINE VARIABLE guidList      AS CHARACTER NO-UNDO.
    DEFINE VARIABLE guidDoneList  AS CHARACTER NO-UNDO.
    DEFINE VARIABLE timeStampList AS CHARACTER NO-UNDO.
    DEFINE VARIABLE DB_CACHE_VERSION AS CHARACTER INITIAL "11.5.0".

    LOG( "CREATING SCHEMAS FOR " + p_DBNameList).
    RUN getDBLocationID(p_DBNameList).
    guidList = RETURN-VALUE.
  
    RUN getDBTimeStamp(p_DBNameList).
    timeStampList = RETURN-VALUE.
    DO i1 = 1 TO NUM-ENTRIES(p_DBNameList):
        cDB = ENTRY(i1,p_DBNameList).
        guidEntry = ENTRY(i1,guidList).    
        guidEntry = REPLACE(guidEntry,"~\","-").
        guidEntry = REPLACE(guidEntry,"/","-").
        /* Skip if already created */
        IF LOOKUP(guidEntry,guidDoneList) > 0 THEN
            NEXT.
        OUTPUT TO VALUE(getWorkDirectory() + (guidEntry) + ".txt").
        /* Write out header */
        /* BIG NOTE: if you change this, make sure you change the header descriptor in DatabaseConnectionManager as well*/
        PUT UNFORMATTED  "PSC-SchemaCache|" +  ENTRY(i1,timeStampList) + "|" + DB_CACHE_VERSION  SKIP.
        RUN VALUE(fRunDir + "_idecreatealias.p") (cDB, "OEIDE_DICTDB").
        RUN VALUE(fRunDir + "_exporttables.p").
        OUTPUT CLOSE.
        guidDoneList = guidDoneList + (IF guidDoneList = "" THEN "" ELSE ",") 
            + guidEntry.
    END.
  
END PROCEDURE.


PROCEDURE getDBLocationID:
    /*------------------------------------------------------------------
     This will get the unique ID of the database (guiID). If the database
     does not contain the guid, the logical database name will be returned
    
    Input Parameters:
       p_DBName  - This is the name of the database you want to find.
    
    Returns - A delimited list of _DB._DB-guid, DBNAME if the db was not found.
    ---------------------------------------------------------------------*/
    DEFINE INPUT  PARAMETER p_DBNameList    AS CHARACTER     NO-UNDO.

    DEFINE VARIABLE dbEntry      AS CHARACTER NO-UNDO.
    DEFINE VARIABLE dbLocationID AS CHARACTER NO-UNDO.
    DEFINE VARIABLE ret-value    AS CHARACTER NO-UNDO.
    DEFINE VARIABLE i            AS INTEGER   NO-UNDO.
    DEFINE VARIABLE v_DBCount    AS INTEGER   NO-UNDO.
 
    DO i = 1 TO NUM-ENTRIES(p_DBNameList):
        dbEntry  = ENTRY(i,p_DBNameList).
    
        /* if this is a schema holder, then find it in the right progress db */
        IF NOT CONNECTED(dbEntry) OR DBTYPE(dbEntry) NE "Progress" THEN
        DO:
            DB-LOOP:
            DO v_DBCount = 1 TO NUM-DBS:
                IF DBTYPE(v_DBCount) = "PROGRESS" THEN
                DO:
                    CREATE ALIAS OEIDE_DICTDB FOR DATABASE VALUE(LDBNAME(v_DBCount)).
                    RUN VALUE(fRunDir + "_hasdbguid.p")  NO-ERROR.
                    IF RETURN-VALUE = "TRUE" THEN 
                    DO:
                        RUN VALUE(fRunDir + "_finddbguid.p")  NO-ERROR.
                        ret-value = IF RETURN-VALUE= ? THEN dbEntry ELSE RETURN-VALUE.
                    END.	
                    ELSE
                        ret-value = dbEntry.
	      
                    dbLocationID = dbLocationID + (IF dbLocationID = "" THEN "" ELSE ",")
                        + ret-value.                 
                    LEAVE DB-LOOP.                          
                END.
            END.
        END.
        ELSE /* just put the alias on this db */
        DO:
          
            /*            if LDBNAME("DICTDB") <> dbEntry then*/
            CREATE ALIAS OEIDE_DICTDB FOR DATABASE VALUE(dbEntry).
            
            RUN VALUE(fRunDir + "_hasdbguid.p")  NO-ERROR.
            IF RETURN-VALUE = "TRUE" THEN 
            DO:
                RUN VALUE(fRunDir + "_finddbguid.p") NO-ERROR.
                ret-value = IF RETURN-VALUE= ? THEN dbEntry ELSE RETURN-VALUE.
            END.	
            ELSE
                ret-value = dbEntry.
            dbLocationID = dbLocationID + (IF dbLocationID = "" THEN "" ELSE ",")
                + ret-value.                        
        END.
    END.

    RETURN dbLocationID .


END PROCEDURE.

PROCEDURE getDBTimeStamp:
    /*------------------------------------------------------------------
     This will return the timeStamp id of the schema from the specified 
     databases. If you pass the name of a gateway database, it will find 
     the associated db.
     Input Parameters:
        p_DBNameList  - A comma delimited list of the logical names of the 
                      databases you want to find.
    
     Returns: - a delimited list of the_MstrBlk._MstrBlk-timestamp
    ---------------------------------------------------------------------*/
    DEFINE INPUT PARAMETER p_DBNameList  AS CHARACTER NO-UNDO.

    DEFINE VARIABLE dbEntry         AS CHARACTER NO-UNDO.
    DEFINE VARIABLE dbTimeStampList AS CHARACTER NO-UNDO.
    DEFINE VARIABLE i               AS INTEGER   NO-UNDO.
    DEFINE VARIABLE v_DBCount       AS INTEGER   NO-UNDO.

  
    DO i = 1 TO NUM-ENTRIES(p_DBNameList):
        dbEntry  = ENTRY(i,p_DBNameList).
    
        /* if this is a schema holder, then find it in the right progress db */
        IF NOT CONNECTED(dbEntry) OR DBTYPE(dbEntry) NE "Progress" THEN
        DO:
            DB-LOOP:
            DO v_DBCount = 1 TO NUM-DBS:
                IF DBTYPE(v_DBCount) = "PROGRESS" THEN
                DO:
                    CREATE ALIAS OEIDE_DICTDB FOR DATABASE VALUE(LDBNAME(v_DBCount)).
                    RUN VALUE(fRunDir + "_finddbtimestamp.p")  NO-ERROR.
                    IF RETURN-VALUE NE ? THEN
                        dbTimeStampList = dbTimeStampList + (IF dbTimeStampList = "" THEN "" ELSE ",")
                            + RETURN-VALUE.
                    ELSE
                        dbTimeStampList = dbTimeStampList + (IF dbTimeStampList = "" THEN "" ELSE ",")
                            + "?".                        
                    LEAVE DB-LOOP.                          
                END.
            END.
        END.
        ELSE /* just put the alias on this db */
        DO:
             
            CREATE ALIAS OEIDE_DICTDB FOR DATABASE VALUE(dbEntry).
            RUN VALUE(fRunDir + "_finddbtimestamp.p") NO-ERROR.
            IF RETURN-VALUE NE ? THEN
                dbTimeStampList = dbTimeStampList + (IF dbTimeStampList = "" THEN "" ELSE ",")
                    + RETURN-VALUE.
            ELSE
                dbTimeStampList = dbTimeStampList + (IF dbTimeStampList = "" THEN "" ELSE ",")
                    + "?".                        
        END.
    END.
    RETURN dbTimeStampList .

END PROCEDURE.

/* retrieve the description for a particular field or table
*/
PROCEDURE GetDatabaseDescription:
    DEFINE INPUT  PARAMETER cPrm AS CHARACTER  NO-UNDO.
    cPrm = cPrm + "..".
    CREATE ALIAS OEIDE_DICTDB FOR DATABASE VALUE(ENTRY(1,cPrm,".")) NO-ERROR.
    IF ERROR-STATUS:ERROR OR NOT CONNECTED("OEIDE_DICTDB") THEN
        RETURN "OK:".
    ELSE 
    DO:
        RUN VALUE(fRunDir + "_dbdescription.p") (INPUT cPrm) NO-ERROR.  /* Pass table name if given */
        IF ERROR-STATUS:ERROR THEN
            RETURN "OK".
    END.
    RETURN RETURN-VALUE.
END PROCEDURE.


PROCEDURE ConnectDatabase.
    DEFINE INPUT PARAMETER cPrm AS CHARACTER NO-UNDO.
	
    RUN value(fRunDir + "_ideconnectdb.p") (INPUT cPrm) NO-ERROR.
    IF ERROR-STATUS:ERROR THEN
        RETURN ERROR-STATUS:GET-MESSAGE(1).
    RETURN RETURN-VALUE.

END PROCEDURE.

PROCEDURE ExportDatabaseSchema.
    DEFINE INPUT PARAMETER cPrm AS CHARACTER NO-UNDO.
	
    RUN value(fRunDir + "_ideschema.p") (INPUT cPrm) NO-ERROR.
    IF ERROR-STATUS:ERROR THEN
        RETURN ERROR-STATUS:GET-MESSAGE(1).
    RETURN RETURN-VALUE.

END PROCEDURE.

PROCEDURE TestDatabaseConnection.
    DEFINE INPUT PARAMETER cPrm AS CHARACTER NO-UNDO.
	
    RUN value(fRunDir + "_idetestdb.p") (INPUT cPrm) NO-ERROR.
    IF ERROR-STATUS:ERROR THEN
        RETURN ERROR-STATUS:GET-MESSAGE(1).
    RETURN RETURN-VALUE.	

END PROCEDURE.


PROCEDURE GetCRC:
    DEFINE INPUT PARAMETER cPrm AS CHARACTER NO-UNDO.
	
    RUN value(fRunDir + "_idegetcrc.p") (INPUT cPrm) NO-ERROR.
    IF ERROR-STATUS:ERROR THEN
        RETURN ERROR-STATUS:GET-MESSAGE(1).
    RETURN RETURN-VALUE.    
END PROCEDURE.