/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.java.oea.plugins.querygenerator.runtime;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.core.runtime.ProgressCommand;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProjectPlugin;
import com.openedge.pdt.text.OEutil;
import com.openedge.pdt.text.dialogs.OEProjectSelectionDialog;
import com.proalpha.java.oea.plugins.querygenerator.Activator;
import com.proalpha.java.oea.plugins.querygenerator.runtime.QueryGeneratorPrograms;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class HandlerTools {
    private static String PLUGIN_ID = Activator.getDefault().getBundle().getSymbolicName();
    public static char PARAM_SPLITTER = (char)3;
    private static HandlerTools handlerTools = null;

    private HandlerTools() {
    }

    public static HandlerTools getInstance() {
        if (handlerTools == null) {
            handlerTools = new HandlerTools();
        }
        return handlerTools;
    }

    public String getPluginFilePath(String fileName) {
        File file = OEutil.getPluginFile((String)PLUGIN_ID, (String)fileName);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    public String runProgram(IAVMClient runtime, QueryGeneratorPrograms program, String parameter, boolean expectResult) {
        String result = null;
        if (runtime != null) {
            String commandProcedure = program.getAbsoluteFilename();
            String commandParameter = String.format("%s|%s", QueryGeneratorPrograms.QUERY_GENERATOR.getAbsoluteFilename(), parameter);
            ProgressCommand progressCommand = new ProgressCommand(commandProcedure, commandParameter, "EXTERNAL", expectResult);
            runtime.runProgressCommand(progressCommand);
            if (expectResult) {
                result = progressCommand.getResult();
            }
            runtime.bringToTop();
        }
        return result;
    }

    public String runProgram(QueryGeneratorPrograms program, String parameter, boolean expectResult) {
        IAVMClient runtime = this.getRuntime();
        return this.runProgram(runtime, program, parameter, expectResult);
    }

    private Preferences getPrefs(String projectName) {
        IProject project;
        IEclipsePreferences prefs = null;
        if (projectName != null && !projectName.isEmpty() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.exists()) {
            ProjectScope projectScope = new ProjectScope(project);
            prefs = projectScope.getNode(PLUGIN_ID);
        }
        if (prefs == null) {
            prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        }
        return prefs;
    }

    public String readParamString(String paramString, String paramName) {
        if (paramString == null || paramName == null) {
            return "";
        }
        String[] parameters = paramString.split(String.valueOf(PARAM_SPLITTER));
        int i = 0;
        while (i < parameters.length) {
            String parameter = parameters[i];
            int eqPos = parameter.indexOf("=");
            if (eqPos >= 0 && parameter.substring(0, eqPos).equals(paramName)) {
                return parameter.substring(eqPos + 1);
            }
            ++i;
        }
        return "";
    }

    public boolean savePluginSetting(String projectName, String name, String value) {
        Preferences prefs = this.getPrefs(projectName);
        if (prefs == null) {
            return false;
        }
        prefs.put(name, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            return false;
        }
        return true;
    }

    public String loadPluginSetting(String projectName, String name) {
        Preferences prefs = this.getPrefs(projectName);
        if (prefs == null) {
            return "";
        }
        return prefs.get(name, "");
    }

    public IAVMClient getRuntime() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IProject project = null;
        if (window.getActivePage().getEditorReferences().length > 0) {
            project = OEutil.getProjectSelection();
        }
        if (project != null && OEutil.isOpenEdgeProject((IProject)project)) {
            OEProjectPlugin projectPlugin = OEProjectPlugin.getDefault();
            IOpenEdgeProject oeProject = projectPlugin.getOpenEdgeModel().getOpenEdgeProject(project);
            return oeProject.getRuntime();
        }
        OEProjectSelectionDialog dialog = new OEProjectSelectionDialog(window.getShell());
        if (dialog.open() == 0) {
            String projectName = dialog.getProjectName();
            OEProjectPlugin projectPlugin = OEProjectPlugin.getDefault();
            return projectPlugin.getOpenEdgeModel().getOpenEdgeProject(projectName).getRuntime();
        }
        return null;
    }
}

