&ANALYZE-SUSPEND _VERSION-NUMBER AB_v10r12 GUI
&ANALYZE-RESUME
/* Connected Databases 
*/
&Scoped-define WINDOW-NAME hQueryWindow

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DECLARATIONS hQueryWindow 
routine-level on error undo, throw.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DEFINITIONS hQueryWindow 
/******************************************************************************/
/*                                      (c) 2013   proALPHA Software AG       */
/*                                                 Auf dem Immel 8            */
/*                                                 67661  Kaiserslautern      */
/*                                                                            */
/*  erstellt am: 02.05.2013                                                   */
/*  Autor......: Manuel Thiemann                                              */
/*                                                                            */
/*  Version....: 3.11.0                                                       */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/*  AUFGABE                                                                   */
/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Ermglicht das "Zusammenklicken" einer Datenbank-Abfrage als "find first", */
/* "for each" oder "can-find".                                                */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/*  NDERUNGSPROTOKOLL                                                        */
/*----------------------------------------------------------------------------*/
/* 02.05.2013 mth Version 1.0.0                                               */
/* 02.05.2013 mth Version 1.1.0                                               */
/* 08.05.2013 mth Version 1.2.0                                               */
/* 15.05.2013 mth Version 2.0.0                                               */
/* 16.05.2013 mth Version 2.1.0                                               */
/* 23.05.2013 mth Version 2.2.0                                               */
/* 20.08.2013 mth Version 3.0.0                                               */
/* 18.09.2013 mth Version 3.1.0                                               */
/* 04.11.2013 mth Version 3.2.0                                               */
/* 03.02.2014 mth Version 3.3.0                                               */
/* 20.02.2014 mth Version 3.4.0                                               */
/* 06.03.2014 mth Version 3.5.0                                               */
/* 02.04.2014 mth Version 3.6.0                                               */
/* 15.05.2014 mth Version 3.7.0                                               */
/* 29.07.2014 mth Version 3.8.0                                               */
/* 14.11.2014 mth Version 3.9.0                                               */
/* 01.02.2015 mth Version 3.10.0                                              */
/* 03.03.2015 mth Version 3.10.1                                              */
/* 23.04.2015 mth Version 3.10.2                                              */
/* 04.08.2015 mth Version 3.11.0                                              */
/* 04.09.2015 mth Version 3.11.1                                              */
/******************************************************************************/

/*----------------------------------------------------------------------------*/
/*          This .W file was created with the Progress AppBuilder.            */
/*----------------------------------------------------------------------------*/

/* Create an unnamed pool to store all the widgets created 
     by this procedure. This is a good default which assures
     that this procedure's triggers and internal procedures 
     will execute in this procedure's storage, and that proper
     cleanup will occur on deletion of the procedure. */

create widget-pool.

/*----------------------------------------------------------------------------*/
/* Definitionen                                                               */
/*----------------------------------------------------------------------------*/

/* Globals -------------------------------------------------------------------*/


/* SCOPEDs -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Options                                                                    */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_HIDE_QUERYRANGE               yes
&SCOPED-DEFINE K_ALWAYS_USE_FIND_FIRST         no
&SCOPED-DEFINE K_ALWAYS_USE_CANFIND_FIRST      no

&SCOPED-DEFINE K_SET_SLIM_MODE_ON_STARTUP      no

&SCOPED-DEFINE K_SHOW_GRID_ON_BROWSE           no
&SCOPED-DEFINE K_TOGGLE_GRID_ON_BROWSE         no
&SCOPED-DEFINE K_SELECT_COLUMN_ON_BROWSE       yes
&SCOPED-DEFINE K_EXPORT_ON_BROWSE              yes
&SCOPED-DEFINE K_RECORD_COUNT_ON_BROWSE        yes

&SCOPED-DEFINE K_EDITMODE_ENABLED              no
&SCOPED-DEFINE K_COLORED_INDEX_USAGE           no

&SCOPED-DEFINE K_MAX_FIELD_HISTORY_ENTRIES     50

&SCOPED-DEFINE K_SESSIONTRIGGER_SHOWMESSAGE    yes
&SCOPED-DEFINE K_SESSIONTRIGGER_WRITELOG       no
&SCOPED-DEFINE K_SESSIONTRIGGER_LOGFILENAME    '':U
&SCOPED-DEFINE K_SESSIONTRIGGER_INDEXVALUES    yes
&SCOPED-DEFINE K_SESSIONTRIGGER_STACKTRACE     yes

&SCOPED-DEFINE K_AUTOFILTER_OMIT_TABLE_SUFFIX  '':U

/*----------------------------------------------------------------------------*/
/* Parameters                                                                 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Defaults                                                                   */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_DEFAULT_BUFFER_PATTERN        '&1':U
&SCOPED-DEFINE K_DEFAULT_DEFINE_BUFFER         no

&SCOPED-DEFINE K_DEFAULT_EXCLUSIVE_LOCK        no
&SCOPED-DEFINE K_DEFAULT_COMPANY_VIA_CLASS     yes
&SCOPED-DEFINE K_DEFAULT_NO_ERROR              yes
&SCOPED-DEFINE K_DEFAULT_IF_STATEMENT          yes
&SCOPED-DEFINE K_DEFAULT_NOT                   no
&SCOPED-DEFINE K_DEFAULT_DO_BLOCK              no

&SCOPED-DEFINE K_DEFAULT_ON_ERROR_PHRASE       ~{&K_ON_ERROR_PHRASE_THROW}
&SCOPED-DEFINE K_DEFAULT_BLOCK_PATTERN         '':U
&SCOPED-DEFINE K_DEFAULT_DEFINE_BLOCK          no
&SCOPED-DEFINE K_DEFAULT_RETRY_BLOCK           no
&SCOPED-DEFINE K_DEFAULT_FINALLY_BLOCK         no

&SCOPED-DEFINE K_DEFAULT_QUERY_TYPE            ~{&K_QUERYTYPE_FINDFIRST}

&SCOPED-DEFINE K_DEFAULT_INDENTATION           0

&SCOPED-DEFINE K_DEFAULT_INSERT_MODE           yes

/*----------------------------------------------------------------------------*/
/* Buffer-Buttons                                                             */
/*----------------------------------------------------------------------------*/

/* Use &1 as table name replacement and # as a counter replacement. Use ## to */
/* actually insert the # character                                            */

&SCOPED-DEFINE K_BUFFER_PATTERN_1             'b#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_1       'b#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_2             'gb#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_2       'gb#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_3             'bx#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_3       'bx#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_4             'gbx#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_4       'gbx#':U

&SCOPED-DEFINE K_NUM_BUFFER_PATTERN_INDICES   5

/*----------------------------------------------------------------------------*/
/* Block-Buttons                                                              */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_BLOCK_PATTERN_1            'FE_&1':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_1      'FE':U

&SCOPED-DEFINE K_BLOCK_PATTERN_2            'Main':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_2      'Main':U

&SCOPED-DEFINE K_BLOCK_PATTERN_3            '':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_3      '':U

&SCOPED-DEFINE K_BLOCK_PATTERN_4            '':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_4      '':U


/*----------------------------------------------------------------------------*/
/* Other constants                                                            */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_Version                           '3.11.1':U

&SCOPED-DEFINE K_COMPANY_FIELDS                    'Firma,Company':U

&SCOPED-DEFINE K_QUERYRANGE_DEFAULT                1
&SCOPED-DEFINE K_QUERYRANGE_FIRST                  2
&SCOPED-DEFINE K_QUERYRANGE_LAST                   3

&SCOPED-DEFINE K_QUERYTYPE_FINDFIRST               1
&SCOPED-DEFINE K_QUERYTYPE_FOREACH                 2
&SCOPED-DEFINE K_QUERYTYPE_CANFIND                 3

&SCOPED-DEFINE K_ON_ERROR_PHRASE_LEAVE             1
&SCOPED-DEFINE K_ON_ERROR_PHRASE_NEXT              2
&SCOPED-DEFINE K_ON_ERROR_PHRASE_RETRY             3
&SCOPED-DEFINE K_ON_ERROR_PHRASE_THROW             4

&SCOPED-DEFINE K_DISPLAYMODE_FIELD                 1
&SCOPED-DEFINE K_DISPLAYMODE_INDEX                 2

&SCOPED-DEFINE K_EDITACTION_EDIT                   1
&SCOPED-DEFINE K_EDITACTION_CREATE                 2
&SCOPED-DEFINE K_EDITACTION_DUPLICATE              3

&SCOPED-DEFINE K_WINDOW_MAXIMIZED                  1
&SCOPED-DEFINE K_WINDOW_MINIMIZED                  2
&SCOPED-DEFINE K_WINDOW_NORMAL                     3
&SCOPED-DEFINE K_WINDOW_DELAYED_MINIMIZE           4

&SCOPED-DEFINE K_WINDOW_MAXIMIZED_STR              'maximized':U
&SCOPED-DEFINE K_WINDOW_MINIMIZED_STR              'minimized':U
&SCOPED-DEFINE K_WINDOW_NORMAL_STR                 'normal':U

&SCOPED-DEFINE K_CLASS_COMPANY_STATEMENT           pACConnectionSvc:prpcCompany

&SCOPED-DEFINE K_PARAM_SPLITTER                    chr(3)

&SCOPED-DEFINE K_EDITOR_INSERT_REQUEST_HANDLER     'EditorInsertRequestId':U
&SCOPED-DEFINE K_SAVE_PLUGIN_SETTING_HANDLER       'SavePluginSettingId':U
&SCOPED-DEFINE K_LOAD_PLUGIN_SETTING_HANDLER       'LoadPluginSettingId':U

&SCOPED-DEFINE K_WINDOW_MIN_WIDTH                  210
&SCOPED-DEFINE K_WINDOW_MIN_WIDTH_SLIM             85
&SCOPED-DEFINE K_WINDOW_MIN_HEIGHT                 24
&SCOPED-DEFINE K_WINDOW_MIN_HEIGHT_SLIM            22
&SCOPED-DEFINE K_SLIM_MODE_FACTOR                  (231 / 121)

&SCOPED-DEFINE K_COLOR_DARK_RED                    4
&SCOPED-DEFINE K_COLOR_GREEN                       10
&SCOPED-DEFINE K_COLOR_RED                         12
&SCOPED-DEFINE K_COLOR_YELLOW                      14

&SCOPED-DEFINE K_WHERE_DATA_TYPE_BLACKLIST         'BLOB,CLOB':U

&SCOPED-DEFINE K_MAX_INT64_FORMAT                  '-z,zzz,zzz,zzz,zzz,zzz,zz9':U

&SCOPED-DEFINE K_PROGRESS_TTNAME                   'PROGRESST':U
&SCOPED-DEFINE K_PERSISTENT_TT_DBNAME              'Persistent':U
&SCOPED-DEFINE K_PERSISTENT_TT_PYSICALNAME         '*** Virtual persistent temp-table database ***':T
&SCOPED-DEFINE K_SNAPSHOT_DBNAME                   'Snapshots':U
&SCOPED-DEFINE K_SNAPSHOT_PYSICALNAME              '*** Virtual snapshot database ***':T

&SCOPED-DEFINE K_QUERY_SIZE_MODE_DEFAULT           0
&SCOPED-DEFINE K_QUERY_SIZE_MODE_SMALL             1
&SCOPED-DEFINE K_QUERY_SIZE_MODE_SMALLER           2
&SCOPED-DEFINE K_QUERY_SIZE_MODE_MINIMUM           3

&SCOPED-DEFINE K_VALUE_MODE_DATA_TYPE              0
&SCOPED-DEFINE K_VALUE_MODE_DEFAULT_VALUE          1

&SCOPED-DEFINE K_WIN_CONST_VK_SCROLL               145
&SCOPED-DEFINE K_WIN_CONST_VK_NUMLOCK              144
&SCOPED-DEFINE K_WIN_CONST_VK_CAPITAL              20
&SCOPED-DEFINE K_WIN_CONST_VK_CTRL                 17
&SCOPED-DEFINE K_WIN_CONST_VK_ALT                  18
&SCOPED-DEFINE K_WIN_CONST_VK_SHIFT                16

&GLOBAL-DEFINE K_WIN_CONST_HKEY_CURRENT_USER       -2147483647
&GLOBAL-DEFINE K_WIN_CONST_HKEY_LOCAL_MACHINE      -2147483646
&GLOBAL-DEFINE K_WIN_CONST_HKEY_CURRENT_CONFIG     -2147483643
&GLOBAL-DEFINE K_WIN_CONST_HKEY_CLASSES_ROOT       -2147483648

&GLOBAL-DEFINE K_WIN_CONST_KEY_QUERY_VALUE         1

&SCOPED-DEFINE K_DIRECTION_UP                      0
&SCOPED-DEFINE K_DIRECTION_DOWN                    1
&SCOPED-DEFINE K_DIRECTION_LEFT                    2
&SCOPED-DEFINE K_DIRECTION_RIGHT                   3

&SCOPED-DEFINE K_QP_TOKEN_TYPE_UNDEFINED           0
&SCOPED-DEFINE K_QP_TOKEN_TYPE_EOF                 1
&SCOPED-DEFINE K_QP_TOKEN_TYPE_KEYWORD             2
&SCOPED-DEFINE K_QP_TOKEN_TYPE_STRING              3
&SCOPED-DEFINE K_QP_TOKEN_TYPE_COMMENT             4
&SCOPED-DEFINE K_QP_TOKEN_TYPE_OPERATOR            5
&SCOPED-DEFINE K_QP_TOKEN_TYPE_NUMBER              6
&SCOPED-DEFINE K_QP_TOKEN_TYPE_DATE                7
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PUNCTUATION         8
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PREPROCESSOR        9
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACE_OPEN          10
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACE_CLOSE         11
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACKET_OPEN        12
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACKET_CLOSE       13
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PARENTHESE_OPEN     14
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PARENTHESE_CLOSE    15
&SCOPED-DEFINE K_QP_TOKEN_TYPE_IDENTIFIER          16
&SCOPED-DEFINE K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE  17

&SCOPED-DEFINE K_QP_NODE_TYPE_NODE                 0
&SCOPED-DEFINE K_QP_NODE_TYPE_TOKEN                1

&SCOPED-DEFINE K_QP_COMPARATOR_OPERATORS ~
    'EQ,LT,LE,GT,GE,NE,BEGINS,MATCHES,CONTAINS,=,<,<=,>,>=,<>':U

&SCOPED-DEFINE K_QP_CONDITION_BREAK_KEYWORDS ~
      'FOR,EACH,FIRST,LAST,BREAK,BY,COLLATE,TRANSACTION,STOP-AFTER':U ~
    + ',ON,USE-INDEX,NO-LOCK,SHARE-LOCK,EXCLUSIVE-LOCK,NO-PREFETCH':U ~
    + ',LOOKAHEAD,NO-LOOKAHEAD,DEBUG,NO-DEBUG,SEPARATE-CONNECTION':U ~
    + ',NO-SEPARATE-CONNECTION,JOIN-BY-SQLDB,NO-JOIN-BY-SQLDB,BIND-WHERE':U ~
    + ',NO-BIND-WHERE,INDEX-HINT,NO-INDEX-HINT,SKIP-GROUP-DUPLICATES':U ~
    + ',TABLE-SCAN,USING':U

&SCOPED-DEFINE K_QP_KEYWORD_FUNCTIONS ~
      'TODAY,NOW,ETIME,ALIAS,ASC,AVAILABLE,CAN-DO,CAN-FIND,CAST,COUNT-OF':U ~
    + ',CURRENT-CHANGED,CURRENT-LANGUAGE,DATASERVERS,DBCODEPAGE,DBCOLLATION':U ~
    + ',DBNAME,DBPARAM,DBRESTRICTIONS,DBTASKID,DBTYPE,DBVERSION':U ~
    + ',DYNAMIC-FUNCTION,ENCODE,ENTRY,ETIME,FILL,FIRST-OF,FRAME-COL':U ~
    + ',FRAME-DB,FRAME-DOWN,FRAME-FIELD,FRAME-FILE,FRAME-INDEX,FRAME-LINE':U ~
    + ',FRAME-NAME,FRAME-ROW,FRAME-VALUE,GET-BYTE,GET-CODEPAGES':U ~
    + ',GET-COLLATIONS,INDEX,INPUT,IS-ATTR-SPACE,KBLABEL,KEYCODE':U ~
    + ',KEYFUNCTION,KEYLABEL,KEYWORD,LAST-OF,LASTKEY,LDBNAME,LIBRARY':U ~
    + ',LINE-COUNTER,LOCKED,LOOKUP,MEMBER,MESSAGE-LINES,NEW,NUM-ALIASES':U ~
    + ',NUM-DBS,NUM-ENTRIES,OS-DRIVES,OS-ERROR,PAGE-NUMBER,PDBNAME':U ~
    + ',PROC-HANDLE,PROC-STATUS,PROGRAM-NAME,R-INDEX,RECID,RECORD-LENGTH':U ~
    + ',RETRY,RETURN-VALUE,SCREEN-LINES,SDBNAME,SEARCH,SEEK,SETUSERID,SUPER':U ~
    + ',TERMINAL,TIME,TRIM,USERID':U

/* Variables -----------------------------------------------------------------*/

define stream strExport.
define stream strClipboard.
define stream strSeTrigger.

define variable gcBufferBaseName            as character no-undo.
define variable gcBufferPattern             as character no-undo.
define variable gcBlockPattern              as character no-undo.

define variable gcStatusText60              as character no-undo format 'x(60)':U.
define variable gcStatusText120             as character no-undo format 'x(120)':U.

define variable giQuerySeq                  as integer   no-undo.

define variable gcExportFilename            as character no-undo.
define variable gcQRScenarioFileName        as character no-undo.

define variable glShowHiddenTables          as logical   no-undo.

define variable giIndentation               as integer   no-undo.

define variable gcIDEProjectName            as character no-undo.

define variable glIDECanInsert              as logical   no-undo.
define variable glIDECanSaveSetting         as logical   no-undo.
define variable glIDECanLoadSetting         as logical   no-undo.

define variable glInsertMode                as logical   no-undo.

define variable gdOriginalWidth             as decimal   no-undo.
define variable gdMinWidth                  as decimal   no-undo init {&K_WINDOW_MIN_WIDTH}.
define variable gdOriginalHeight            as decimal   no-undo.
define variable gdMinHeight                 as decimal   no-undo init {&K_WINDOW_MIN_HEIGHT}.

define variable gcFieldDatatypeFilter       as character no-undo.

define variable gcTitlePrefix               as character no-undo.
define variable gcIconDir                   as character no-undo.

define variable giRecentQueriesSeq          as integer   no-undo.

define variable glBrowseFields              as logical   no-undo init no.
define variable glRawValues                 as logical   no-undo init no.
define variable glCopyRawValues             as logical   no-undo init yes.
define variable glShowLinkedChildWindows    as logical   no-undo init yes.

define variable gcPersitentTTProcedure      as character no-undo.

define variable gcTTWidgetPool              as character no-undo.

define variable gcCursorHand                as character no-undo.

define variable giQueryParserSeq            as integer   no-undo.

define variable gcQPQueryText               as character no-undo.
define variable giQPOffset                  as integer   no-undo.
define variable giQPTokenStart              as integer   no-undo.
define variable giQPTokenEnd                as integer   no-undo.
define variable gcQPToken                   as character no-undo.
define variable giQPTokenType               as integer   no-undo.

define variable glSlimMode                  as logical   no-undo.

define variable giSessionTriggerSeq         as integer   no-undo.

define variable ghSessionTriggersWindow     as handle    no-undo.
define variable ghSessionTriggersBrowse     as handle    no-undo.
define variable ghSessionTriggerShowMessage as handle    no-undo.
define variable ghSessionTriggerWriteLog    as handle    no-undo.
define variable ghSessionTriggerLogFileName as handle    no-undo.
define variable ghSessionTriggerIndexValues as handle    no-undo.
define variable ghSessionTriggerStackTrace  as handle    no-undo.

define variable glSessionTriggerShowMessage as logical   no-undo.
define variable glSessionTriggerWriteLog    as logical   no-undo.
define variable gcSessionTriggerLogFileName as character no-undo.
define variable glSessionTriggerIndexValues as logical   no-undo.
define variable glSessionTriggerStackTrace  as logical   no-undo.


/* Work-/Temp-Tables ---------------------------------------------------------*/

define temp-table ttDatabase no-undo
  field DatabaseName as character
    format 'x(30)':U
    label 'Database':T
  field PhysicalName as character
    format 'x(255)':U
    label 'Physical name':T
  field DisplayPriority as integer
  field DirectoryName as character
  field TempDB       as logical
  field BasisDB      as logical
  field BasisDBName  as character
  field PhysicalDB   as logical
  index Main is primary unique
    DatabaseName
  index PhysicalName is unique
    PhysicalName
    DatabaseName
  index TempDB
    TempDB
    DatabaseName
  index BasisDB
    DirectoryName
    BasisDB
    DatabaseName
  index DisplayPriority
    DisplayPriority
    DatabaseName
    .

define temp-table ttTable no-undo
  field DatabaseName            as character
  field TableName               as character
    format 'x(32)':U
    label 'Table':T
  field TableFilterMatches      as logical
  field TableFieldFilterMatches as logical
  field CreateTrigger           as character
  field CreateTriggerProcName   as character
    format 'x(32)':U
    label 'Create trigger':T
  field WriteTrigger            as character
  field WriteTriggerProcName    as character
    format 'x(32)':U
    label 'Write trigger':T
  field DeleteTrigger           as character
  field DeleteTriggerProcName   as character
    format 'x(32)':U
    label 'Delete trigger':T
  field CompanyInclude          as character
    format 'x(12)':U
    label 'Company include':T
  field KeyInclude              as character
    format 'x(12)':U
    label 'Key include':T
  field FillInclude              as character
    format 'x(12)':U
    label 'Key include':T
  field InternalIdentifier      as character
  field PrimaryIndexName        as character
  field DetailsLoaded           as logical
  field PhysicalTable           as logical
  field TableHandle             as handle
  field OriginalTableHandle     as handle
  field Snapshot                as logical
  index Main is primary unique
    DatabaseName
    TableName
  index Filter
    DatabaseName
    TableFilterMatches
    TableFieldFilterMatches
    TableName
  index PhysicalTable
    PhysicalTable
    DatabaseName
    TableName
    .

define temp-table ttField no-undo
  field DatabaseName       as character
  field TableName          as character
  field FieldName          as character
    format 'x(32)':U
    label 'Field':T
  field DataType           as character
    format 'x(13)':U
    label 'Data type':T
  field FieldFormat        as character
    format 'x(30)':U
    label 'Format':T
  field FieldExtent        as integer
    format '>>>9':U
    label 'Extent':T
  field FieldDecimals      as integer
    format '>>>9':U
    label 'Decimals':T
  field FieldInitialValue  as character
    format 'x(30)':U
    label 'Initial':U
  field FieldLabel         as character
    format 'x(30)':U
    label 'Label':T
  field FieldColumnLabel   as character
    format 'x(30)':U
    label 'Column-Label':T
  field IsMandatory        as logical
    format 'yes/no':U
    label 'Mandatory':T
    view-as toggle-box
  field Domain             as character
    format 'x(40)':U
    label 'Domain':T
  field FieldViewAs        as character
    format 'x(50)':U
    label 'View as':T
  field FieldFilterMatches as logical
  index Main is primary unique
    DatabaseName
    TableName
    FieldName
  index FieldName
    DatabaseName
    FieldName
    TableName
  index FieldLabel
    DatabaseName
    FieldLabel
    TableName
    FieldName
  index Filter
    DatabaseName
    TableName
    FieldFilterMatches
    FieldName
    .

define temp-table ttIndex no-undo
  field DatabaseName            as character
  field TableName               as character
  field IndexName               as character
    format 'x(32)':U
    label 'Index':T
  field IsPrimary               as logical
    format '*/ ':U
    label 'P':T
  field IndexFields             as character
    format 'x(255)':U
    label 'Fields':T
  field IndexFieldList          as character
  field IsUnique                as logical
    format '*/ ':U
    label 'U':T
  field IndexFilterMatches      as logical
  field IndexFieldFilterMatches as logical
  index Main is primary unique
    DatabaseName
    TableName
    IndexName
  index IsPrimary
    DatabaseName
    TableName
    IsPrimary
    IndexName
  index IsUnique
    DatabaseName
    TableName
    IsUnique
    IndexName
  index Filter
    DatabaseName
    TableName
    IndexFilterMatches
    IndexFieldFilterMatches
    IndexName
    .

define temp-table ttIndexField no-undo
  field DatabaseName  as character
  field TableName     as character
  field IndexName     as character
  field IndexSequence as integer
  field FieldName     as character
  field DataType      as character
  field SortAscending as logical
  index Main is primary unique
    DatabaseName
    TableName
    IndexName
    FieldName
  index IndexSequence
    DatabaseName
    TableName
    IndexName
    IndexSequence
    FieldName 
    .

define temp-table ttRecordField no-undo
  field WindowHandle            as handle
  field FieldName               as character
    format 'x(32)':U
    label 'Field':T
  field FieldExtent             as integer
    format '>>>9':U
    label 'Idx':T
  field FieldLabel              as character
    format 'x(30)':U
    label 'Label':T
  field OldFormattedValue       as clob
  field OldUnformattedValue     as clob
  field OldDisplayValue         as character
    format 'x(255)':U
    label 'Old value':U
  field CurrentFormattedValue   as clob
  field CurrentUnformattedValue as clob
  field CurrentDisplayValue     as character
    format 'x(255)':U
    label 'Current value':U
  field Order as integer
  index Main is primary unique
    WindowHandle
    FieldName
    FieldExtent
  index Order
    WindowHandle
    Order
    FieldName
    FieldExtent
    .

define temp-table ttRecordfieldChanges no-undo like ttRecordField.

define temp-table ttQueryWindow no-undo
  field WindowHandle               as handle
  field QuerySeq                   as integer
  field QueryHandle                as handle
  field QueryTextEditorHandle      as handle
  field QueryBrowseHandle          as handle
  field FieldSelectionBrowseHandle as handle
  field WindowTitle                as character
    label 'Query window':T
    format 'x(255)':U
  field Updated                    as logical
  index Main is primary unique
    WindowHandle
  index QuerySeq is unique
    QuerySeq
    .

define temp-table ttRecordWindow no-undo
  field BufferHandle      as handle
  field WindowHandle      as handle
  field BrowseHandle      as handle
  field QueryHandle       as handle
  field DatabaseName      as character
  field FieldList         as character
  field SelectedFieldList as character
  field WindowTitle       as character
    label 'Record window':T
    format 'x(255)':U
  index Main is primary unique
    WindowHandle
    .

define temp-table ttSessionTrigger no-undo
  field Id              as integer
  field TriggerEvent    as character
    label 'Trigger-Event':T 
    format 'x(6)':U
  field DatabaseName    like ttDatabase.DatabaseName
  field TableName       like ttTable.TableName
  field FieldName       like ttField.FieldName
  field TriggerFileName as character
  field ProcedureHandle as handle
  index Main is primary unique
    Id
  index TriggerEvent
    TriggerEvent
    DatabaseName
    TableName
    FieldName
  index TriggerObject
    DatabaseName
    TableName
    FieldName
    TriggerEvent
    .

define temp-table ttRecentQueries no-undo
  field WindowHandle as handle
  field QueryText    as character
  field Order        as integer
  field OrderLabel   as integer
  field QueryLabel   as character
  index Main is primary unique
    WindowHandle
    QueryText
  index Order
    WindowHandle
    Order descending
    .

define temp-table ttQueryLink no-undo
  field SourceSeq  as integer
  field TargetSeq  as integer
  field StartPos   as integer
  field EndPos     as integer
  field BufferName as character
  field FieldName  as character
  field FieldIndex as integer
  index Main is primary unique
    TargetSeq
    SourceSeq
    StartPos
    EndPos
  index StartPos
    TargetSeq
    StartPos
    EndPos
    SourceSeq
    .

define temp-table ttQueryBuffer no-undo
  field QuerySeq       as integer
    format 'zzzzz9':U
    label 'Id':T
  field BufferName     as character
    format 'x(50)':U
    label 'Buffer name':T
  field BufferHandle   as handle
  index Main is primary unique
    QuerySeq
    BufferName
    .

define temp-table ttQueryBufferField no-undo
  field FieldHandle    as handle
  field FieldName      as character
  field FieldIndex     as integer
  field DisplayName    as character
    format 'x(32)':U
    label 'Field name':T
  index Main is primary unique
    FieldName
    FieldIndex
    .

define temp-table ttIDEHandler no-undo
  field HandlerName as character
  field HandlerId   as integer
  index Main is primary unique
    HandlerName
    .

define temp-table ttQueryWindowExport no-undo
  serialize-name 'QueryWindow':U
  field QuerySeq          as integer
    serialize-name 'QueryId':U
    column-label 'Id':T
  field WindowState       as character
  field QueryText         as character
  field BrowseColumns     as character
  field WindowWidth       as decimal
  field WindowHeight      as decimal
  field WindowColumn      as decimal
  field WindowRow         as decimal
  field HideFieldList     as logical
  field Splitter1Pos      as integer
  field NewQuerySeq       as integer
    serialize-hidden
  field WindowSelected    as logical
    initial yes
    column-label '':U
    serialize-hidden
  field BufferList        as character
    format 'x(120)':U
    column-label 'Buffers':T
    serialize-hidden
  index Main is primary unique
    QuerySeq
  index WindowSelected
    WindowSelected
    QuerySeq
    .

define temp-table ttQueryBufferExport no-undo
  serialize-name 'QueryBuffer':U
  field QuerySeq       as integer
    serialize-name 'QueryId':U
  field BufferId       as integer
  field DatabaseName   as character
  field TableName      as character
  field BufferName     as character
  index Main is primary unique
    QuerySeq
    BufferId
  index BufferName is unique
    QuerySeq
    BufferName
    .
  
define temp-table ttRecentQueryExport no-undo
  serialize-name 'QueryHistory':U
  field QuerySeq   as integer
    serialize-name 'QueryId':U
  field Order      as integer
  field QueryText  as character
  index Main is primary unique
    QuerySeq
    Order
    .

define dataset dsQueryWindowExport
  serialize-name 'QueryScenario':U
  for ttQueryWindowExport, ttQueryBufferExport, ttRecentQueryExport
  data-relation QueryBuffer for ttQueryWindowExport, ttQueryBufferExport
    relation-fields(QuerySeq, QuerySeq)
    nested
  data-relation RecentQuery for ttQueryWindowExport, ttRecentQueryExport
    relation-fields(QuerySeq, QuerySeq)
    nested
    .

define temp-table ttPersistentProcedure no-undo
  field ProcedureName as character
    format 'x(255)':U
    column-label 'Procedure':T
  index Main is primary unique
    ProcedureName
    .

define temp-table ttPersistentTempTable no-undo
  field ProcedureName like ttPersistentProcedure.ProcedureName
  field TableHandle   as handle
  field TableName     like ttTable.TableName
  index Main is primary unique
    ProcedureName
    TableHandle
  index TableName
    ProcedureName
    TableName
    .

define temp-table ttQueryAST no-undo
  field Id           as integer
  field ParentId     as integer
  field TokenStart   as integer
  field TokenEnd     as integer
  field TokenType    as integer
  field NodeType     as integer
  field TokenText    as character
    format 'x(255)':U
  field Level        as integer
  index Main is primary unique
    Id
  index ParentId
    ParentId
    TokenStart
    TokenEnd
  index TokenType
    TokenType
    TokenStart
    TokenEnd
    TokenText
  index NodeType
    NodeType
    TokenStart
    TokenEnd
    TokenText
  index TokenStart
    TokenStart
    TokenEnd
    TokenType
    TokenText
    .

define temp-table ttQueryCondition no-undo
  field StartPos           as integer
  field EndPos             as integer
  field LeftStartPos       as integer
  field LeftEndPos         as integer
  field ComparatorStartPos as integer
  field ComparatorEndPos   as integer
  field RightStartPos      as integer
  field RightEndPos        as integer
  index Main is primary unique
    StartPos
  EndPos
  index LeftStartPos
    LeftStartPos
    LeftEndPos
  index LeftEndPos
    LeftEndPos
    LeftStartPos
  index ComparatorStartPos
    ComparatorStartPos
    ComparatorEndPos
  index ComparatorEndPos
    ComparatorEndPos
    ComparatorStartPos
  index RightStartPos
    RightStartPos
    RightEndPos
  index RightEndPos
    RightEndPos
    RightStartPos
    .

define temp-table ttQueryLine no-undo
  field LineNo          as integer
  field StartPos        as integer
  field EndPos          as integer
  field ExceedingToken  as logical
  field LineLevel       as integer
  field LineIndentation as integer
  index Main is primary unique
    LineNo.

{adecomm/oeideservice.i}


procedure SetForegroundWindow external 'user32.dll':U:
  define input  parameter hwnd    as long no-undo.
end procedure.

procedure GetKeyState external 'user32.dll':U:
    define input  parameter iVirtKey as long      no-undo.
    define return parameter iResult  as short     no-undo.
end procedure.

procedure ExpandEnvironmentStringsA external "kernel32.dll":
  define input  parameter cString        as character no-undo.
  define output parameter cRetString     as character no-undo.
  define input  parameter iStringSize    as long      no-undo.
  define return parameter iRetStringSize as long      no-undo.
end procedure.

procedure RegOpenKeyExA external 'advapi32':U:
  define input  parameter iKey       as long      no-undo.
  define input  parameter cSubKey    as character no-undo.
  define input  parameter iOptions   as long      no-undo.
  define input  parameter iDesired   as long      no-undo.
  define output parameter iResult    as long      no-undo.
  define return parameter iRetResult as long      no-undo.
end procedure.

procedure RegQueryValueExA external 'advapi32':U:
  define input  parameter ikey         as long      no-undo.
  define input  parameter iPValueName  as character no-undo.
  define input  parameter iPdwReserved as long      no-undo.
  define output parameter iPdwType     as long      no-undo.
  define input  parameter iPbData      as long      no-undo.
  define output parameter iPcbData     as long      no-undo.
  define return parameter iPResult     as long      no-undo.
end procedure.

procedure RegCloseKey external 'advapi32':U:
  define input  parameter iKey     as long      no-undo.
  define return parameter iPResult as long      no-undo.
end procedure.

procedure GetParent external 'user32.dll':U:
   define input  parameter plHWND    as long      no-undo.
   define return parameter plWinLong as long      no-undo.
end procedure.

procedure GetWindowRect external 'user32.dll':U:
  define input  parameter hWnd    as long      no-undo.
  define output parameter lpRect  as memptr    no-undo.
  define return parameter iResult as long      no-undo.
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-PREPROCESSOR-BLOCK 

/* ********************  Preprocessor Definitions  ******************** */

&Scoped-define PROCEDURE-TYPE Window
&Scoped-define DB-AWARE no

/* Name of designated FRAME-NAME and/or first browse and/or first query */
&Scoped-define FRAME-NAME fQuery
&Scoped-define BROWSE-NAME brDatabase

/* Internal Tables (found by Frame, Query & Browse Queries)             */
&Scoped-define INTERNAL-TABLES ttDatabase ttField ttIndex ttTable

/* Definitions for BROWSE brDatabase                                    */
&Scoped-define FIELDS-IN-QUERY-brDatabase ttDatabase.DatabaseName ttDatabase.PhysicalName   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brDatabase   
&Scoped-define SELF-NAME brDatabase
&Scoped-define QUERY-STRING-brDatabase FOR EACH ttDatabase WHERE true   NO-LOCK   BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName
&Scoped-define OPEN-QUERY-brDatabase OPEN QUERY brDatabase FOR EACH ttDatabase WHERE true   NO-LOCK   BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName.
&Scoped-define TABLES-IN-QUERY-brDatabase ttDatabase
&Scoped-define FIRST-TABLE-IN-QUERY-brDatabase ttDatabase


/* Definitions for BROWSE brField                                       */
&Scoped-define FIELDS-IN-QUERY-brField ttField.FieldName ttField.DataType ttField.FieldExtent ttField.FieldDecimals ttField.FieldInitialValue ttField.FieldFormat ttField.FieldLabel ttField.FieldColumnLabel ttField.IsMandatory ttField.Domain   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brField   
&Scoped-define SELF-NAME brField
&Scoped-define QUERY-STRING-brField FOR EACH ttField WHERE true and ttField.DatabaseName = ttDatabase.DatabaseName and ttField.TableName = ttTable.TableName and ttField.FieldFilterMatches = yes   NO-LOCK
&Scoped-define OPEN-QUERY-brField OPEN QUERY brField FOR EACH ttField WHERE true and ttField.DatabaseName = ttDatabase.DatabaseName and ttField.TableName = ttTable.TableName and ttField.FieldFilterMatches = yes   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brField ttField
&Scoped-define FIRST-TABLE-IN-QUERY-brField ttField


/* Definitions for BROWSE brIndex                                       */
&Scoped-define FIELDS-IN-QUERY-brIndex ttIndex.IsPrimary ttIndex.IndexName ttIndex.IsUnique ttIndex.IndexFields   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brIndex   
&Scoped-define SELF-NAME brIndex
&Scoped-define QUERY-STRING-brIndex FOR EACH ttIndex WHERE true   AND ttIndex.DatabaseName = ttDatabase.DatabaseName   and ttIndex.TableName = ttTable.TableName   AND ttIndex.IndexFilterMatches = yes   AND ttIndex.IndexFieldFilterMatches = yes   NO-LOCK
&Scoped-define OPEN-QUERY-brIndex OPEN QUERY brIndex FOR EACH ttIndex WHERE true   AND ttIndex.DatabaseName = ttDatabase.DatabaseName   and ttIndex.TableName = ttTable.TableName   AND ttIndex.IndexFilterMatches = yes   AND ttIndex.IndexFieldFilterMatches = yes   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brIndex ttIndex
&Scoped-define FIRST-TABLE-IN-QUERY-brIndex ttIndex


/* Definitions for BROWSE brTable                                       */
&Scoped-define FIELDS-IN-QUERY-brTable ttTable.TableName   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brTable   
&Scoped-define SELF-NAME brTable
&Scoped-define QUERY-STRING-brTable FOR EACH ttTable WHERE true   AND ttTable.DatabaseName = ttDatabase.DatabaseName   AND ttTable.TableFilterMatches = yes   AND ttTable.TableFieldFilterMatches = yes   AND (glShowHiddenTables     OR (  not can-do('sys*':U, ~
       ttTable.TableName)       and not can-do('_*':U, ~
       ttTable.TableName)))   NO-LOCK
&Scoped-define OPEN-QUERY-brTable OPEN QUERY brTable FOR EACH ttTable WHERE true   AND ttTable.DatabaseName = ttDatabase.DatabaseName   AND ttTable.TableFilterMatches = yes   AND ttTable.TableFieldFilterMatches = yes   AND (glShowHiddenTables     OR (  not can-do('sys*':U, ~
       ttTable.TableName)       and not can-do('_*':U, ~
       ttTable.TableName)))   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brTable ttTable
&Scoped-define FIRST-TABLE-IN-QUERY-brTable ttTable


/* Definitions for FRAME fQuery                                         */

/* Standard List Definitions                                            */
&Scoped-Define ENABLED-OBJECTS gdIndexUsage btnClearFieldLabelFilter ~
gcFieldLabelFilter gcFieldDummy brDatabase btnConnectDB btnDisconnectDB ~
btnRefresh gcTableFilter btnClearTableFilter gcTableFieldFilter ~
btnClearTableFieldFilter brTable giDisplayMode gcFieldFilter ~
btnClearFieldFilter brField gcIndexFilter btnClearIndexFilter ~
gcIndexFieldFilter btnClearIndexFieldFilter brIndex gcBufferName ~
btnClearBufferPattern btnBuffer1 btnBuffer2 btnBuffer3 btnBuffer4 ~
glDefineBuffer glCompanyViaClass glExclusiveLock glNoError glIfStatement ~
glNot glDoBlock giOnErrorPhrase giQueryRange gcBlockName btnClearBlockName ~
btnBlock1 btnBlock2 btnBlock3 btnBlock4 glDefineBlock glRetryBlock ~
glFinallyBlock giQueryType btnCopyToClipboard btnExecuteQuery btnResetAll ~
btnIncreaseIndentation btnDecreaseIndentation btnResetIndentation ~
gcQueryText 
&Scoped-Define DISPLAYED-OBJECTS gdIndexUsage gcFieldLabelFilter ~
gcFieldDummy gcTableFilter gcTableFieldFilter giDisplayMode gcFieldFilter ~
gcIndexFilter gcIndexFieldFilter gcBufferName glDefineBuffer ~
glCompanyViaClass glExclusiveLock glNoError glIfStatement glNot glDoBlock ~
giOnErrorPhrase giQueryRange gcBlockName glDefineBlock glRetryBlock ~
glFinallyBlock giQueryType gcQueryText 

/* Custom List Definitions                                              */
/* List-1,List-2,List-3,List-4,List-5,List-6                            */

/* _UIB-PREPROCESSOR-BLOCK-END */
&ANALYZE-RESUME


/* ************************  Function Prototypes ********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBeautifyQueryText hQueryWindow 
FUNCTION qg_cBeautifyQueryText returns character
  ( pcQueryText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBrowseColumnList hQueryWindow 
FUNCTION qg_cBrowseColumnList returns character
  ( phBrowse             as handle,
    plIncludeBufferName  as logical,
    plListAllColumns     as logical,
    plIncludeColumnWidth as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBufferCompare hQueryWindow 
FUNCTION qg_cBufferCompare returns character
  ( phBuffer1 as handle,
    phBuffer2 as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cColumnFieldName hQueryWindow 
FUNCTION qg_cColumnFieldName returns character
  ( phColumn            as handle,
    plIncludeBufferName as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateQueryText hQueryWindow 
FUNCTION qg_cCreateQueryText returns character
  ( pcFieldList as character,
    plAddTags   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateWhereClause hQueryWindow 
FUNCTION qg_cCreateWhereClause returns character
  ( pcDatabaseName   as character,
    pcTableName      as character,
    pcBufferName     as character,
    pcFieldList      as character,
    plStartWithWhere as logical,
    piValueMode      as integer,
    plAddTags        as logical,
    piIndentBlanks   as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCurrentFieldList hQueryWindow 
FUNCTION qg_cCurrentFieldList returns character
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cExtractFieldName hQueryWindow 
FUNCTION qg_cExtractFieldName returns character
  ( pcFieldName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldAssignments hQueryWindow 
FUNCTION qg_cFieldAssignments returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldAssignStatement hQueryWindow 
FUNCTION qg_cFieldAssignStatement returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldValues hQueryWindow 
FUNCTION qg_cFieldValues returns character
  ( phBuffer    as handle,
    phOldBuffer as handle,
    pcFieldList as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFilterEntryMatchcode hQueryWindow 
FUNCTION qg_cFilterEntryMatchcode returns character
  ( pcFilterEntry as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFixQuerySeq hQueryWindow 
FUNCTION qg_cFixQuerySeq returns character
  ( pcQuerytext as character,
    piQuerySeq  as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetBufferBaseName hQueryWindow 
FUNCTION qg_cGetBufferBaseName returns character
  ( plCustomBuffer as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetCompanyInclude hQueryWindow 
FUNCTION qg_cGetCompanyInclude returns character
  ( pcTableName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetDefaultValue hQueryWindow 
FUNCTION qg_cGetDefaultValue returns character
  ( pcDatatype as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetFieldAssignmentsStatement hQueryWindow 
FUNCTION qg_cGetFieldAssignmentsStatement returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character,
    plAddTags      as logical,
    piIndentBlanks as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetPrimaryKeyValues hQueryWindow 
FUNCTION qg_cGetPrimaryKeyValues returns character
  ( phBuffer            as handle,
    pcSplitter          as character,
    plIncludeFieldNames as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetPutStatement hQueryWindow 
FUNCTION qg_cGetPutStatement returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetSelectedFields hQueryWindow 
FUNCTION qg_cGetSelectedFields returns character
  ( pcBufferName as character,
    pcSeparator  as character,
    plQuoted     as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cIndexFieldValues hQueryWindow 
FUNCTION qg_cIndexFieldValues returns character
  ( phBuffer    as handle,
    pcIndexName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListReadValue hQueryWindow 
FUNCTION qg_cParamListReadValue returns character
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteCharacter hQueryWindow 
FUNCTION qg_cParamListWriteCharacter returns character
  ( pcParamList  as character,
    pcParamName  as character,
    pcParamValue as character,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteDecimal hQueryWindow 
FUNCTION qg_cParamListWriteDecimal returns character
  ( pcParamList  as character,
    pcParamName  as character,
    pdParamValue as decimal,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteInteger hQueryWindow 
FUNCTION qg_cParamListWriteInteger returns character
  ( pcParamList  as character,
    pcParamName  as character,
    piParamValue as integer,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cPutStatement hQueryWindow 
FUNCTION qg_cPutStatement returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryIndex hQueryWindow 
FUNCTION qg_cQueryIndex returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryLabel hQueryWindow 
FUNCTION qg_cQueryLabel returns character
  ( pcQueryText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cReadRegistryValue hQueryWindow 
FUNCTION qg_cReadRegistryValue returns character
  ( piSection as integer,
    pcSubKey  as character,
    pcKeyName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSoundexCode hQueryWindow 
FUNCTION qg_cSoundexCode returns character
  ( pcText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cStacktrace hQueryWindow 
FUNCTION qg_cStacktrace returns character
  (  )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteChar hQueryWindow 
FUNCTION qg_cSubstituteChar returns character
  ( pcString   as character,
    pcFromChar as character,
    pcToChar   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteLinkTokens hQueryWindow 
FUNCTION qg_cSubstituteLinkTokens returns character
  ( pcText          as character,
    piTargetSeq     as integer,
    phLinkTempTable as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteQueryLinkTokens hQueryWindow 
FUNCTION qg_cSubstituteQueryLinkTokens returns character
  ( phWindow as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cTaggedValue hQueryWindow 
FUNCTION qg_cTaggedValue returns character
  ( pcText   as character,
    plAddTag as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cTTWidgetPool hQueryWindow 
FUNCTION qg_cTTWidgetPool returns character
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_dIndexUsage hQueryWindow 
FUNCTION qg_dIndexUsage returns decimal
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcIndexName    as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_dParamListReadValue hQueryWindow 
FUNCTION qg_dParamListReadValue returns decimal
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_hGetWidgetByName hQueryWindow 
FUNCTION qg_hGetWidgetByName returns handle
  ( phContainer  as handle,
    pcWidgetName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iExtractIndex hQueryWindow 
FUNCTION qg_iExtractIndex returns integer
  ( pcFieldName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iGetHandlerId hQueryWindow 
FUNCTION qg_iGetHandlerId returns integer
  ( pcHandlerName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iParamListReadValue hQueryWindow 
FUNCTION qg_iParamListReadValue returns integer
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lcClipboardValue hQueryWindow 
FUNCTION qg_lcClipboardValue returns longchar
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lCheckLinkReference hQueryWindow 
FUNCTION qg_lCheckLinkReference returns logical
  ( piQuerySeq     as integer,
    pcQuerySeqList as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lParamListReadValue hQueryWindow 
FUNCTION qg_lParamListReadValue returns logical
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lQueryOpen hQueryWindow 
FUNCTION qg_lQueryOpen returns logical
  ( phQuery        as handle,
    pcQueryText    as character,
    phParentWindow as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lSelectNextQueryCondition hQueryWindow 
FUNCTION qg_lSelectNextQueryCondition returns logical
  ( phEditor as handle,
    plNext   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lUniqueQuery hQueryWindow 
FUNCTION qg_lUniqueQuery returns logical
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* ***********************  Control Definitions  ********************** */

/* Define the widget handle for the window                              */
DEFINE VAR hQueryWindow AS WIDGET-HANDLE NO-UNDO.

/* Menu Definitions                                                     */
DEFINE SUB-MENU m_File 
       MENU-ITEM mi_SaveQueryScenario LABEL "Save query scenario"
       MENU-ITEM mi_LoadQueryScenario LABEL "Load query scenario"
       RULE
       MENU-ITEM mi_Exit        LABEL "Exit"          .

DEFINE SUB-MENU m_Edit 
       MENU-ITEM mi_CopyQueryText LABEL "Copy query text"
       MENU-ITEM mi_InsertQueryText LABEL "Insert query text"
       RULE
       MENU-ITEM mi_CopyQueryScenario LABEL "Copy query scenario"
       MENU-ITEM mi_PasteQueryScenario LABEL "Paste query scenario".

DEFINE SUB-MENU m_Tools 
       MENU-ITEM mi_ExecuteQuery LABEL "Execute query"  ACCELERATOR "F2"
       RULE
       MENU-ITEM mi_AddPersistentTempTable LABEL "Add persistent temp table" ACCELERATOR "F9"
       MENU-ITEM mi_AddSnapshot LABEL "Add snpapshot"  ACCELERATOR "F10"
       RULE
       MENU-ITEM mi_ResetAll    LABEL "Reset"          ACCELERATOR "F12".

DEFINE SUB-MENU m_Options 
       MENU-ITEM mi_InsertMode  LABEL "Insert mode"   
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_OpenQueryWindowPersistentTT LABEL "Open query window for persistent temp-tables"
              TOGGLE-BOX
       MENU-ITEM mi_OpenQueryWindowSnapshotTT LABEL "Open query window for snapshots"
              TOGGLE-BOX.

DEFINE SUB-MENU m_Window 
       MENU-ITEM mi_SlimMode    LABEL "Slim mode"     
              TOGGLE-BOX
       MENU-ITEM mi_RestoreDefaultWindowSize LABEL "Restore default window size"
       RULE
       MENU-ITEM mi_ShowQueryWindow LABEL "Show query window" ACCELERATOR "CTRL-F7"
       MENU-ITEM mi_CloseAllQueryWindows LABEL "Close all query windows"
       RULE
       MENU-ITEM mi_ShowRecordWindow LABEL "Show record window" ACCELERATOR "CTRL-F8"
       MENU-ITEM mi_CloseAllRecordWindows LABEL "Close all record windows"
       RULE
       MENU-ITEM mi_SessionTriggers LABEL "Session triggers".

DEFINE SUB-MENU m_Help 
       MENU-ITEM mi_About       LABEL "About Query Generator".

DEFINE MENU MENU-BAR-hQueryWindow MENUBAR
       SUB-MENU  m_File         LABEL "File"          
       SUB-MENU  m_Edit         LABEL "Edit"          
       SUB-MENU  m_Tools        LABEL "Tools"         
       SUB-MENU  m_Options      LABEL "Options"       
       SUB-MENU  m_Window       LABEL "Window"        
       SUB-MENU  m_Help         LABEL "Help"          .

DEFINE MENU POPUP-MENU-brDatabase 
       MENU-ITEM mi_CopyDatabaseName LABEL "Copy name"     
       MENU-ITEM mi_CopyPhysicalName LABEL "Copy physical name"
       RULE
       MENU-ITEM mi_LoadDataDefinitions LABEL "Load data definitions (.df)"
       RULE
       MENU-ITEM mi_DataDictionary LABEL "Data Dictionary"
       MENU-ITEM mi_DataAdministration LABEL "Data Administration".

DEFINE SUB-MENU m_SelectedFields 
       MENU-ITEM mi_CopyFieldAssignStatement LABEL "Copy assign statement"
       MENU-ITEM mi_CopyFieldAssignments LABEL "Copy field assignments"
       MENU-ITEM mi_CopyPutStatement LABEL "Copy put statement"
       RULE
       MENU-ITEM mi_CopyFieldNamesCommaSeparated LABEL "Copy names (comma separated)"
       MENU-ITEM mi_CopyFieldNamesSpaceSeparated LABEL "Copy names (space separated)"
       MENU-ITEM mi_CopyFieldNamesLineSeparated LABEL "Copy names (line separated)"
       RULE
       MENU-ITEM mi_SessionTriggerAddFieldsAssign LABEL "Add session triggers (assign)"
       MENU-ITEM mi_SessionTriggerRemoveFieldsAssign LABEL "Remove session triggers (assign)"
       RULE
       MENU-ITEM mi_FindFieldIndex LABEL "Find index for selected fields"
       MENU-ITEM mi_FindFieldTables LABEL "Find tables containing selected fields".

DEFINE MENU POPUP-MENU-brField 
       MENU-ITEM mi_CopyFieldName LABEL "Copy name"     
       MENU-ITEM mi_CopyFullFieldName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_SelectAllFields LABEL "Selected all"  
       SUB-MENU  m_SelectedFields LABEL "Selected fields"
       RULE
       MENU-ITEM mi_CopyFieldInitialValue LABEL "Copy initial value"
       MENU-ITEM mi_CopyFieldFormat LABEL "Copy format"   
       MENU-ITEM mi_CopyFieldLabel LABEL "Copy label"    
       MENU-ITEM mi_CopyFieldColumnLabel LABEL "Copy column label"
       MENU-ITEM mi_CopyFieldDomain LABEL "Copy Domain"   
       RULE
       MENU-ITEM mi_SessionTriggerFieldAssign LABEL "Add session trigger (assign)"
       RULE
       MENU-ITEM mi_FilterDataypes LABEL "Dataype filter".

DEFINE MENU POPUP-MENU-brIndex 
       MENU-ITEM mi_CopyIndexName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_CopyIndexFields LABEL "Copy fields"   
       RULE
       MENU-ITEM mi_ModifyIndexQueryFields LABEL "Modify query fields".

DEFINE SUB-MENU m_TableCreateTrigger 
       MENU-ITEM mi_CopyTableCreateTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableCreateTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableWriteTrigger 
       MENU-ITEM mi_CopyTableWriteTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableWriteTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableDeleteTrigger 
       MENU-ITEM mi_CopyTableDeleteTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableDeleteTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableCompanyInclude 
       MENU-ITEM mi_CopyTableCompanyInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableCompanyInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableCompanyIncludeReference LABEL "Copy include reference".

DEFINE SUB-MENU m_TableKeyInclude 
       MENU-ITEM mi_CopyTableKeyInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableKeyInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableKeyIncludeReference LABEL "Copy include reference".

DEFINE SUB-MENU m_TableFillInclude 
       MENU-ITEM mi_CopyTableFillInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableFillInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableFillIncludeReference LABEL "Copy include reference".

DEFINE MENU POPUP-MENU-brTable 
       MENU-ITEM mi_CopyTableName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_CopyTableDefineBuffer LABEL "Copy ~"define buffer~""
       RULE
       SUB-MENU  m_TableCreateTrigger LABEL "Create trigger"
       SUB-MENU  m_TableWriteTrigger LABEL "Write trigger" 
       SUB-MENU  m_TableDeleteTrigger LABEL "Delete trigger"
       RULE
       SUB-MENU  m_TableCompanyInclude LABEL "Company include"
       SUB-MENU  m_TableKeyInclude LABEL "Key include"   
       SUB-MENU  m_TableFillInclude LABEL "Fill include"  
       RULE
       MENU-ITEM mi_SessionTriggerCreate LABEL "Add session trigger (create)"
       MENU-ITEM mi_SessionTriggerWrite LABEL "Add session trigger (write)"
       MENU-ITEM mi_SessionTriggerDelete LABEL "Add session trigger (delete)"
       RULE
       MENU-ITEM mi_AddSnapshotBtn LABEL "Add snapshot"  
       MENU-ITEM mi_RemoveTable LABEL "Remove table"  
       RULE
       MENU-ITEM mi_ShowHiddenTables LABEL "Show hidden tables"
              TOGGLE-BOX.

DEFINE MENU POPUP-MENU-btnCopyToClipboard 
       MENU-ITEM mi_InsertModeBtn LABEL "Insert mode"   
              TOGGLE-BOX.


/* Definitions of the field level widgets                               */
DEFINE BUTTON btnBlock1 
     LABEL "1" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock2 
     LABEL "2" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock3 
     LABEL "3" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock4 
     LABEL "4" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer1 
     LABEL "1" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer2 
     LABEL "2" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer3 
     LABEL "3" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer4 
     LABEL "4" 
     SIZE 7 BY 1.

DEFINE BUTTON btnClearBlockName 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear blockname".

DEFINE BUTTON btnClearBufferPattern 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Reset buffername".

DEFINE BUTTON btnClearFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear field filter".

DEFINE BUTTON btnClearFieldLabelFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear field label filter".

DEFINE BUTTON btnClearIndexFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear index field filter".

DEFINE BUTTON btnClearIndexFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear index filter".

DEFINE BUTTON btnClearTableFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear table field filter".

DEFINE BUTTON btnClearTableFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear table filter".

DEFINE BUTTON btnConnectDB 
     LABEL "Connect" 
     SIZE 19 BY 1 TOOLTIP "Connect to existing database".

DEFINE BUTTON btnCopyToClipboard DEFAULT 
     LABEL "Copy" 
     SIZE 20 BY 2 TOOLTIP "Copy query text to clipboard".

DEFINE BUTTON btnDecreaseIndentation 
     LABEL "<<" 
     SIZE 7 BY 2 TOOLTIP "Decrease indentation".

DEFINE BUTTON btnDisconnectDB 
     LABEL "Disconnect" 
     SIZE 19 BY 1 TOOLTIP "Disconnect selected database".

DEFINE BUTTON btnExecuteQuery 
     LABEL "Execute" 
     SIZE 20 BY 2 TOOLTIP "Execute current query (F2)".

DEFINE BUTTON btnIncreaseIndentation 
     LABEL ">>" 
     SIZE 7 BY 2 TOOLTIP "Increase indentation".

DEFINE BUTTON btnRefresh 
     LABEL "Refresh" 
     SIZE 19 BY 1 TOOLTIP "Reload schema information for all connected databases".

DEFINE BUTTON btnResetAll 
     LABEL "Reset" 
     SIZE 10 BY 2 TOOLTIP "Reset everything to default values (F12)".

DEFINE BUTTON btnResetIndentation 
     LABEL "|" 
     SIZE 7 BY 2 TOOLTIP "Reset indentation".

DEFINE VARIABLE gcFieldFilter AS CHARACTER 
     LABEL "Field filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for fields that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcFieldLabelFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 5
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for fields that match given label pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcIndexFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for indices that contain fields matching given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcIndexFilter AS CHARACTER 
     LABEL "Index filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for indices that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcTableFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for tables that contain fields matching given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcTableFilter AS CHARACTER 
     LABEL "Table filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for tables that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcQueryText AS CHARACTER 
     VIEW-AS EDITOR NO-WORD-WRAP SCROLLBAR-HORIZONTAL SCROLLBAR-VERTICAL
     SIZE 93 BY 14.5
     FONT 0 NO-UNDO.

DEFINE VARIABLE gcBlockName AS CHARACTER FORMAT "X(60)":U 
     LABEL "Block" 
     VIEW-AS FILL-IN 
     SIZE 60 BY 1 NO-UNDO.

DEFINE VARIABLE gcBufferName AS CHARACTER FORMAT "X(256)":U 
     LABEL "Buffer" 
     VIEW-AS FILL-IN 
     SIZE 60 BY 1 NO-UNDO.

DEFINE VARIABLE gcDatabaseDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Database" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcFieldDummy AS CHARACTER FORMAT "X(256)":U 
     LABEL "Field" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcIndexDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Index" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcTableDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Table" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gdIndexUsage AS DECIMAL FORMAT "zz9%":U INITIAL 0 
      VIEW-AS TEXT 
     SIZE 6 BY 1 TOOLTIP "Index Usage" NO-UNDO.

DEFINE VARIABLE giDisplayMode AS INTEGER INITIAL 2 
     VIEW-AS RADIO-SET HORIZONTAL
     RADIO-BUTTONS 
          "Fields", 1,
"Indices", 2
     SIZE 30 BY 1 NO-UNDO.

DEFINE VARIABLE giOnErrorPhrase AS INTEGER 
     VIEW-AS RADIO-SET VERTICAL
     RADIO-BUTTONS 
          "on error undo, leave", 1,
"on error undo, next", 2,
"on error undo, retry", 3,
"on error undo, throw", 4
     SIZE 28 BY 4 NO-UNDO.

DEFINE VARIABLE giQueryRange AS INTEGER 
     VIEW-AS RADIO-SET VERTICAL
     RADIO-BUTTONS 
          "find", 1,
"find first", 2,
"find last", 3
     SIZE 15 BY 3 NO-UNDO.

DEFINE VARIABLE giQueryType AS INTEGER 
     VIEW-AS RADIO-SET HORIZONTAL EXPAND 
     RADIO-BUTTONS 
          "find first", 1,
"for each", 2,
"can-find", 3
     SIZE 45 BY 2 NO-UNDO.

DEFINE VARIABLE glExclusiveLock AS LOGICAL 
     VIEW-AS RADIO-SET VERTICAL
     RADIO-BUTTONS 
          "no-lock", no,
"exclusive-lock", yes
     SIZE 20 BY 2 NO-UNDO.

DEFINE VARIABLE glCompanyViaClass AS LOGICAL INITIAL no 
     LABEL "" 
     VIEW-AS TOGGLE-BOX
     size 40 by 1 tooltip "Use {&K_CLASS_COMPANY_STATEMENT} instead of pa-Firma" no-undo.

DEFINE VARIABLE glDefineBlock AS LOGICAL INITIAL no 
     LABEL "define block" 
     VIEW-AS TOGGLE-BOX
     SIZE 21 BY 1 NO-UNDO.

DEFINE VARIABLE glDefineBuffer AS LOGICAL INITIAL no 
     LABEL "define buffer" 
     VIEW-AS TOGGLE-BOX
     SIZE 17 BY 1 NO-UNDO.

DEFINE VARIABLE glDoBlock AS LOGICAL INITIAL no 
     LABEL "do" 
     VIEW-AS TOGGLE-BOX
     SIZE 7 BY 1 NO-UNDO.

DEFINE VARIABLE glFinallyBlock AS LOGICAL INITIAL no 
     LABEL "finally block" 
     VIEW-AS TOGGLE-BOX
     SIZE 15 BY 1 NO-UNDO.

DEFINE VARIABLE glIfStatement AS LOGICAL INITIAL no 
     LABEL "if statement" 
     VIEW-AS TOGGLE-BOX
     SIZE 16 BY 1 NO-UNDO.

DEFINE VARIABLE glNoError AS LOGICAL INITIAL no 
     LABEL "no error" 
     VIEW-AS TOGGLE-BOX
     SIZE 11.83 BY 1 NO-UNDO.

DEFINE VARIABLE glNot AS LOGICAL INITIAL no 
     LABEL "not" 
     VIEW-AS TOGGLE-BOX
     SIZE 7 BY 1 NO-UNDO.

DEFINE VARIABLE glRetryBlock AS LOGICAL INITIAL no 
     LABEL "retry block" 
     VIEW-AS TOGGLE-BOX
     SIZE 15 BY 1 NO-UNDO.

/* Query definitions                                                    */
&ANALYZE-SUSPEND
DEFINE QUERY brDatabase FOR 
      ttDatabase SCROLLING.

DEFINE QUERY brField FOR 
      ttField SCROLLING.

DEFINE QUERY brIndex FOR 
      ttIndex SCROLLING.

DEFINE QUERY brTable FOR 
      ttTable SCROLLING.
&ANALYZE-RESUME

/* Browse definitions                                                   */
DEFINE BROWSE brDatabase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brDatabase hQueryWindow _FREEFORM
  QUERY brDatabase NO-LOCK DISPLAY
      ttDatabase.DatabaseName width 12
      ttDatabase.PhysicalName
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 80 BY 5.

DEFINE BROWSE brField
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brField hQueryWindow _FREEFORM
  QUERY brField NO-LOCK DISPLAY
      ttField.FieldName
      ttField.DataType
      ttField.FieldExtent
      ttField.FieldDecimals
      ttField.FieldInitialValue width 7
      ttField.FieldFormat
      ttField.FieldLabel
      ttField.FieldColumnLabel
      ttField.IsMandatory
      ttField.Domain
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN MULTIPLE SIZE 100 BY 12.

DEFINE BROWSE brIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brIndex hQueryWindow _FREEFORM
  QUERY brIndex NO-LOCK DISPLAY
      ttIndex.IsPrimary
      ttIndex.IndexName
      ttIndex.IsUnique
      ttIndex.IndexFields
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 12.

DEFINE BROWSE brTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brTable hQueryWindow _FREEFORM
  QUERY brTable NO-LOCK DISPLAY
      ttTable.TableName
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 10 NO-EMPTY-SPACE.


/* ************************  Frame Definitions  *********************** */

DEFINE FRAME fQuery
     gdIndexUsage AT ROW 32 COL 223 COLON-ALIGNED NO-LABEL
     btnClearFieldLabelFilter AT ROW 20 COL 111
     gcFieldLabelFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     gcDatabaseDummy AT ROW 1.5 COL 16 COLON-ALIGNED
     gcTableDummy AT ROW 8 COL 16 COLON-ALIGNED
     gcFieldDummy AT ROW 21 COL 16 COLON-ALIGNED
     gcIndexDummy AT ROW 21 COL 16 COLON-ALIGNED
     brDatabase AT ROW 1.5 COL 18
     btnConnectDB AT ROW 1.5 COL 99
     btnDisconnectDB AT ROW 2.5 COL 99
     btnRefresh AT ROW 5.5 COL 99
     gcTableFilter AT ROW 7 COL 16 COLON-ALIGNED
     btnClearTableFilter AT ROW 7 COL 60
     gcTableFieldFilter AT ROW 7 COL 67 COLON-ALIGNED NO-LABEL
     btnClearTableFieldFilter AT ROW 7 COL 111
     brTable AT ROW 8 COL 18
     giDisplayMode AT ROW 18.5 COL 18 NO-LABEL
     gcFieldFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearFieldFilter AT ROW 20 COL 60
     brField AT ROW 21 COL 18
     gcIndexFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearIndexFilter AT ROW 20 COL 60
     gcIndexFieldFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     btnClearIndexFieldFilter AT ROW 20 COL 111
     brIndex AT ROW 21 COL 18
     gcBufferName AT ROW 1.5 COL 128 COLON-ALIGNED
     btnClearBufferPattern AT ROW 1.5 COL 190
     btnBuffer1 AT ROW 1.5 COL 199
     btnBuffer2 AT ROW 1.5 COL 207
     btnBuffer3 AT ROW 1.5 COL 215
     btnBuffer4 AT ROW 1.5 COL 223
     glDefineBuffer AT ROW 3 COL 130
     glCompanyViaClass AT ROW 3 COL 178
     glExclusiveLock AT ROW 4.5 COL 130 NO-LABEL
     glNoError AT ROW 4.5 COL 178
     glIfStatement AT ROW 5.5 COL 178
     glNot AT ROW 5.5 COL 199
     glDoBlock AT ROW 5.5 COL 207
     giOnErrorPhrase AT ROW 7 COL 130 NO-LABEL
     giQueryRange AT ROW 7 COL 178 NO-LABEL
     gcBlockName AT ROW 11.5 COL 128 COLON-ALIGNED
     btnClearBlockName AT ROW 11.5 COL 190
     btnBlock1 AT ROW 11.5 COL 199
     btnBlock2 AT ROW 11.5 COL 207
     btnBlock3 AT ROW 11.5 COL 215
     btnBlock4 AT ROW 11.5 COL 223
     glDefineBlock AT ROW 13 COL 130
     glRetryBlock AT ROW 13 COL 160
     glFinallyBlock AT ROW 13 COL 178
     giQueryType AT ROW 16 COL 130 NO-LABEL
     btnCopyToClipboard AT ROW 16 COL 178
     btnExecuteQuery AT ROW 16 COL 199
     btnResetAll AT ROW 16 COL 220
     btnIncreaseIndentation AT ROW 18.5 COL 223
     btnDecreaseIndentation AT ROW 20.5 COL 223
     btnResetIndentation AT ROW 22.5 COL 223
     gcQueryText AT ROW 18.5 COL 130 NO-LABEL
    WITH 1 DOWN NO-BOX KEEP-TAB-ORDER OVERLAY 
         SIDE-LABELS NO-UNDERLINE THREE-D 
         AT COL 1 ROW 1
         SIZE 232 BY 32.5
         DEFAULT-BUTTON btnCopyToClipboard DROP-TARGET.


/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Type: Window
   Allow: Basic,Browse,DB-Fields,Window,Query
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS

/* *************************  Create Window  ************************** */

&ANALYZE-SUSPEND _CREATE-WINDOW
IF SESSION:DISPLAY-TYPE = "GUI":U THEN
  CREATE WINDOW hQueryWindow ASSIGN
         HIDDEN             = YES
         TITLE              = ""
         HEIGHT             = 32.5
         WIDTH              = 231
         MAX-HEIGHT         = 320
         MAX-WIDTH          = 320
         VIRTUAL-HEIGHT     = 320
         VIRTUAL-WIDTH      = 320
         RESIZE             = yes
         SCROLL-BARS        = no
         STATUS-AREA        = no
         BGCOLOR            = ?
         FGCOLOR            = ?
         KEEP-FRAME-Z-ORDER = yes
         THREE-D            = yes
         MESSAGE-AREA       = no
         SENSITIVE          = yes.
ELSE {&WINDOW-NAME} = CURRENT-WINDOW.

ASSIGN {&WINDOW-NAME}:MENUBAR    = MENU MENU-BAR-hQueryWindow:HANDLE.
/* END WINDOW DEFINITION                                                */
&ANALYZE-RESUME



/* ***********  Runtime Attributes and AppBuilder Settings  *********** */

&ANALYZE-SUSPEND _RUN-TIME-ATTRIBUTES
/* SETTINGS FOR WINDOW hQueryWindow
  VISIBLE,,RUN-PERSISTENT                                               */
/* SETTINGS FOR FRAME fQuery
   FRAME-NAME Custom                                                    */
/* BROWSE-TAB brDatabase gcIndexDummy fQuery */
/* BROWSE-TAB brTable btnClearTableFieldFilter fQuery */
/* BROWSE-TAB brField btnClearFieldFilter fQuery */
/* BROWSE-TAB brIndex btnClearIndexFieldFilter fQuery */
ASSIGN 
       FRAME fQuery:PRIVATE-DATA     = 
                "WidthFactor=1,HeightFactor=1,SlimModeWidget=yes".

ASSIGN 
       brDatabase:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brDatabase:HANDLE
       brDatabase:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,SlimModeWidget=yes"
       brDatabase:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brDatabase:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brField:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brField:HANDLE
       brField:NUM-LOCKED-COLUMNS IN FRAME fQuery     = 1
       brField:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brField:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brField:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brIndex:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brIndex:HANDLE
       brIndex:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brIndex:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brIndex:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brTable:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brTable:HANDLE
       brTable:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,SlimModeWidget=yes"
       brTable:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brTable:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       btnBlock1:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock2:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock3:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock4:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer1:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer2:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer3:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer4:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearBlockName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearBufferPattern:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearFieldLabelFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearIndexFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearIndexFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearTableFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearTableFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       btnConnectDB:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnCopyToClipboard:POPUP-MENU IN FRAME fQuery       = MENU POPUP-MENU-btnCopyToClipboard:HANDLE
       btnCopyToClipboard:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.2".

ASSIGN 
       btnDecreaseIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnDisconnectDB:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnExecuteQuery:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.7,WidthFactor=0.2".

ASSIGN 
       btnIncreaseIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnRefresh:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnResetAll:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.9,WidthFactor=0.1".

ASSIGN 
       btnResetIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       gcBlockName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.5".

ASSIGN 
       gcBufferName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.5".

/* SETTINGS FOR FILL-IN gcDatabaseDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcFieldDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       gcFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcFieldLabelFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

/* SETTINGS FOR FILL-IN gcIndexDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcIndexDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       gcIndexFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcIndexFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcQueryText:READ-ONLY IN FRAME fQuery        = TRUE
       gcQueryText:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,HeightFactor=1,WidthFactor=0.5".

/* SETTINGS FOR FILL-IN gcTableDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcTableDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "SlimModeWidget=yes".

ASSIGN 
       gcTableFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcTableFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gdIndexUsage:READ-ONLY IN FRAME fQuery        = TRUE
       gdIndexUsage:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,RowFactor=1".

ASSIGN 
       giDisplayMode:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       giOnErrorPhrase:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giQueryRange:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giQueryType:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glCompanyViaClass:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineBuffer:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDoBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glExclusiveLock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glFinallyBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glIfStatement:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glNoError:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glNot:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glRetryBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

IF SESSION:DISPLAY-TYPE = "GUI":U AND VALID-HANDLE(hQueryWindow)
THEN hQueryWindow:HIDDEN = no.

/* _RUN-TIME-ATTRIBUTES-END */
&ANALYZE-RESUME


/* Setting information for Queries and Browse Widgets fields            */

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brDatabase
/* Query rebuild information for BROWSE brDatabase
     _START_FREEFORM
OPEN QUERY brDatabase FOR EACH ttDatabase WHERE true
  NO-LOCK
  BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brDatabase */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brField
/* Query rebuild information for BROWSE brField
     _START_FREEFORM
OPEN QUERY brField FOR EACH ttField WHERE true
and ttField.DatabaseName = ttDatabase.DatabaseName
and ttField.TableName = ttTable.TableName
and ttField.FieldFilterMatches = yes
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brField */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brIndex
/* Query rebuild information for BROWSE brIndex
     _START_FREEFORM
OPEN QUERY brIndex FOR EACH ttIndex WHERE true
  AND ttIndex.DatabaseName = ttDatabase.DatabaseName
  and ttIndex.TableName = ttTable.TableName
  AND ttIndex.IndexFilterMatches = yes
  AND ttIndex.IndexFieldFilterMatches = yes
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brIndex */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brTable
/* Query rebuild information for BROWSE brTable
     _START_FREEFORM
OPEN QUERY brTable FOR EACH ttTable WHERE true
  AND ttTable.DatabaseName = ttDatabase.DatabaseName
  AND ttTable.TableFilterMatches = yes
  AND ttTable.TableFieldFilterMatches = yes
  AND (glShowHiddenTables
    OR (  not can-do('sys*':U, ttTable.TableName)
      and not can-do('_*':U, ttTable.TableName)))
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brTable */
&ANALYZE-RESUME

 



/* ************************  Control Triggers  ************************ */

&Scoped-define SELF-NAME hQueryWindow
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL hQueryWindow hQueryWindow
ON end-error OF hQueryWindow
or endkey of {&WINDOW-NAME} anywhere do:
  /* This case occurs when the user presses the "Esc" key.
     In a persistently run window, just ignore this.  If we did not, the
     application would exit. */
  if this-procedure:persistent then return no-apply.
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL hQueryWindow hQueryWindow
ON window-close OF hQueryWindow
do:

  define buffer bttQueryWindow  for temp-table ttQueryWindow.
  define buffer bttRecordWindow for temp-table ttRecordWindow.
  define buffer bttTable        for temp-table ttTable.

  for each bttQueryWindow
    on error undo, next:
    
    if valid-handle(bttQueryWindow.WindowHandle) then
      apply 'window-close':U to bttQueryWindow.WindowHandle.
    
  end. /* for each bttQueryWindow */
  
  for each bttRecordWindow
    on error undo, next:
    
    if valid-handle(bttRecordWindow.WindowHandle) then
      apply 'window-close':U to bttRecordWindow.WindowHandle.
    
  end. /* for each bttRecordWindow */
  
  if    OEIDEIsRunning
    and glIDECanSaveSetting then
  do:
    
    /* gcTableFilter history */
    if gcTableFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcTableFilter':U,
                            gcTableFilter:list-items in frame {&FRAME-NAME}) no-error.
    
    /* gcTableFieldFilter history */
    if gcTableFieldFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcTableFieldFilter':U,
                            gcTableFieldFilter:list-items in frame {&FRAME-NAME}) no-error.
    
    /* gcIndexFilter history */
    if gcIndexFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcIndexFilter':U,
                            gcIndexFilter:list-items in frame {&FRAME-NAME}) no-error.
    
    /* gcIndexFieldFilter history */
    if gcIndexFieldFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcIndexFieldFilter':U,
                            gcIndexFieldFilter:list-items in frame {&FRAME-NAME}) no-error.
    
    /* gcFieldFilter history */
    if gcFieldFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcFieldFilter':U,
                            gcFieldFilter:list-items in frame {&FRAME-NAME}) no-error.
    
    /* gcFieldLabelFilter history */
    if gcFieldLabelFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcFieldLabelFilter':U,
                            gcFieldLabelFilter:list-items in frame {&FRAME-NAME}) no-error.
    
    /* Initial gcBufferName */
    run qg_SaveIDESetting('FieldInitial_gcBufferName':U,
                          gcBufferPattern) no-error.
    
    /* Initial glDefineBuffer */
    run qg_SaveIDESetting('FieldInitial_glDefineBuffer':U,
                          string(input frame {&FRAME-NAME} glDefineBuffer, 'true/false':U)) no-error.
    
    /* Initial glCompanyViaClass */
    run qg_SaveIDESetting('FieldInitial_glCompanyViaClass':U,
                          string(input frame {&FRAME-NAME} glCompanyViaClass, 'true/false':U)) no-error.
    
    /* Initial glExclusiveLock */
    run qg_SaveIDESetting('FieldInitial_glExclusiveLock':U,
                          string(input frame {&FRAME-NAME} glExclusiveLock, 'true/false':U)) no-error.
    
    /* Initial glNoError */
    run qg_SaveIDESetting('FieldInitial_glNoError':U,
                          string(input frame {&FRAME-NAME} glNoError, 'true/false':U)) no-error.
    
    /* Initial glIfStatement */
    run qg_SaveIDESetting('FieldInitial_glIfStatement':U,
                          string(input frame {&FRAME-NAME} glIfStatement, 'true/false':U)) no-error.
    
    /* Initial glNot */
    run qg_SaveIDESetting('FieldInitial_glNot':U,
                          string(input frame {&FRAME-NAME} glNot, 'true/false':U)) no-error.
    
    /* Initial glDoBlock */
    run qg_SaveIDESetting('FieldInitial_glDoBlock':U,
                          string(input frame {&FRAME-NAME} glDoBlock, 'true/false':U)) no-error.
    
    /* Initial giOnErrorPhrase */
    run qg_SaveIDESetting('FieldInitial_giOnErrorPhrase':U,
                          string(input frame {&FRAME-NAME} giOnErrorPhrase)) no-error.
    
    /* Initial gcBlockName */
    run qg_SaveIDESetting('FieldInitial_gcBlockName':U,
                          gcBlockPattern) no-error.
    
    /* Initial glDefineBlock */
    run qg_SaveIDESetting('FieldInitial_glDefineBlock':U,
                          string(input frame {&FRAME-NAME} glDefineBlock, 'true/false':U)) no-error.
    
    /* Initial glRetryBlock */
    run qg_SaveIDESetting('FieldInitial_glRetryBlock':U,
                          string(input frame {&FRAME-NAME} glRetryBlock, 'true/false':U)) no-error.
    
    /* Initial glFinallyBlock */
    run qg_SaveIDESetting('FieldInitial_glFinallyBlock':U,
                          string(input frame {&FRAME-NAME} glFinallyBlock, 'true/false':U)) no-error.
    
    /* Initial giQueryType */
    run qg_SaveIDESetting('FieldInitial_giQueryType':U,
                          string(input frame {&FRAME-NAME} giQueryType)) no-error.
    
    /* Open query window for persistent temp-tables */
    run qg_SaveIDESetting('Options_OpenQueryWindowForPersistentTT':U,
                          string(menu-item mi_OpenQueryWindowPersistentTT:checked in menu m_Options, 'true/false':U)) no-error.
    
    /* Open query window for snapshot temp-tables */
    run qg_SaveIDESetting('Options_OpenQueryWindowForSnapshotTT':U,
                          string(menu-item mi_OpenQueryWindowSnapshotTT:checked in menu m_Options, 'true/false':U)) no-error.
    
    /*--------------------------------------------------------------------------*/
    /* Session-Trigger settings                                                 */
    /*--------------------------------------------------------------------------*/
  
    run qg_SaveIDESetting('Options_SessionTriggerShowMessage':U,
                          string(glSessionTriggerShowMessage, 'true/false':U)) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerWriteLog':U,
                          string(glSessionTriggerWriteLog, 'true/false':U)) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerLogFileName':U,
                          gcSessionTriggerLogFileName) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerIndexValues':U,
                          string(glSessionTriggerIndexValues, 'true/false':U)) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerStackTrace':U,
                          string(glSessionTriggerStackTrace, 'true/false':U)) no-error.
    
  end. /* if    OEIDEIsRunning ... */
  
  for each bttTable
    where bttTable.PhysicalTable = no
    on error undo, next:
    
    if    bttTable.Snapshot
      and valid-handle(bttTable.TableHandle) then
      delete object bttTable.TableHandle.
    
  end. /* for each bttTable */
  
  if gcTTWidgetPool > '':U then
    delete widget-pool gcTTWidgetPool no-error.
  
  if valid-handle(ghSessionTriggersWindow) then
    apply 'window-close':U to ghSessionTriggersWindow.
  
  run qg_RemoveAllSessionTriggers.
  
  /* This event will close the window and terminate the procedure.  */
  apply "CLOSE":U to this-procedure.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL hQueryWindow hQueryWindow
ON window-resized OF hQueryWindow
do:

  assign
    hQueryWindow:width-chars  = max(gdMinWidth, hQueryWindow:width-chars)
    hQueryWindow:height-chars = max(gdMinHeight, hQueryWindow:height-chars)
    .

  run qg_AdjustWidgetsSizeAndPos(frame {&FRAME-NAME}:handle,
                                 hQueryWindow:width-chars - gdOriginalWidth,
                                 hQueryWindow:height-chars - gdOriginalHeight).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME fQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on CTRL-INS of frame fQuery anywhere
do:

  apply 'choose' to btnCopyToClipboard in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
ON drop-file-notify OF FRAME fQuery
do:

  define variable cFileName as character no-undo.
  
  cFileName = frame fQuery:get-dropped-file(1).
  
  if cFileName matches '*.qsc':U then
    run qg_LoadQueryScenario(cFileName).
  
  finally:
    
    frame fQuery:end-file-drop().
    
  end finally.
    
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F10 of frame fQuery anywhere
do:

  run qg_SetQueryType({&K_QUERYTYPE_CANFIND}).
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F11 of frame fQuery anywhere
do:

  run qg_SetSlimMode(yes).
  
  assign
    hQueryWindow:width-chars  = {&K_WINDOW_MIN_WIDTH_SLIM}
    hQueryWindow:height-chars = {&K_WINDOW_MIN_HEIGHT_SLIM}
    .

  apply 'window-resized':U to hQueryWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F12 of frame fQuery anywhere
do:

  apply 'choose':U to menu-item mi_RestoreDefaultWindowSize in menu m_Window.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F3 of frame fQuery anywhere
do:

  apply 'entry':U to brDatabase in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F4 of frame fQuery anywhere
do:

  if    valid-handle(focus)
    and focus:name = 'gcTableFilter':U then
    apply 'entry':U to brTable in frame {&FRAME-NAME}.
  
  else  
    apply 'entry':U to gcTableFilter in frame {&FRAME-NAME}.
  
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F5 of frame fQuery anywhere
do:

  if    valid-handle(focus)
    and focus:name = 'gcFieldFilter':U then
    apply 'entry':U to brField in frame {&FRAME-NAME}.
    
  else
  do:
    run qg_SetDisplayMode({&K_DISPLAYMODE_FIELD}).
    apply 'entry':U to gcFieldFilter in frame {&FRAME-NAME}.
  end. /* else: if    valid-handle(focus) ... */
  
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F6 of frame fQuery anywhere
do:

  if    valid-handle(focus)
    and focus:name = 'gcIndexFilter':U then
    apply 'entry':U to brIndex in frame {&FRAME-NAME}.
    
  else
  do:
    run qg_SetDisplayMode({&K_DISPLAYMODE_INDEX}).
    apply 'entry':U to gcIndexFilter in frame {&FRAME-NAME}.
  end. /* else: if    valid-handle(focus) ... */
  
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F7 of frame fQuery anywhere
do:

  apply 'entry':U to gcBufferName in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F8 of frame fQuery anywhere
do:

  run qg_SetQueryType({&K_QUERYTYPE_FINDFIRST}).
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F9 of frame fQuery anywhere
do:

  run qg_SetQueryType({&K_QUERYTYPE_FOREACH}).
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brDatabase
&Scoped-define SELF-NAME brDatabase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brDatabase hQueryWindow
ON CTRL-C OF brDatabase IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyDatabaseName in menu POPUP-MENU-brDatabase.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brDatabase hQueryWindow
ON value-changed OF brDatabase IN FRAME fQuery
do:

  run qg_RefreshTableBrowse.
  
  run qg_WidgetState('*':U).

  run qg_SetWorkingDatabase.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brField
&Scoped-define SELF-NAME brField
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON CTRL-A OF brField IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_SelectAllFields in menu POPUP-MENU-brField.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON CTRL-C OF brField IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyFieldName in menu POPUP-MENU-brField.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON default-action OF brField IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_FindFieldIndex in sub-menu m_SelectedFields.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON value-changed OF brField IN FRAME fQuery
do:
  
  run qg_FillQueryRange.
  run qg_UpdateQueryText.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brIndex
&Scoped-define SELF-NAME brIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brIndex hQueryWindow
ON CTRL-C OF brIndex IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyIndexName in menu POPUP-MENU-brIndex.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brIndex hQueryWindow
ON default-action OF brIndex IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_ModifyIndexQueryFields in menu POPUP-MENU-brIndex.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brIndex hQueryWindow
ON value-changed OF brIndex IN FRAME fQuery
do:

  if giDisplayMode = {&K_DISPLAYMODE_INDEX} then
  do:
    
    run qg_FillQueryRange.
    run qg_UpdateQueryText.
    
  end. /* if giDisplayMode = {&K_DISPLAYMODE_INDEX} */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brTable
&Scoped-define SELF-NAME brTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brTable hQueryWindow
ON CTRL-C OF brTable IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyTableName in menu POPUP-MENU-brTable.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brTable hQueryWindow
ON default-action OF brTable IN FRAME fQuery
do:

  if available ttTable then
  do:
    
    gcTableFilter = ttTable.TableName.
    gcTableFilter:delete(gcTableFilter) in frame {&FRAME-NAME}.
    
    display unless-hidden
      gcTableFilter
      with frame {&FRAME-NAME}.
    
    apply 'value-changed':U to gcTableFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcTableFilter:handle in frame {&FRAME-NAME}).
    
  end. /* if available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brTable hQueryWindow
ON value-changed OF brTable IN FRAME fQuery
do:

  if    available ttTable
    and not ttTable.DetailsLoaded then
    run qg_AddTableDetails(ttDatabase.DatabaseName,
                           ttTable.TableName).
  
  gcFieldDatatypeFilter = '*':U.
  
  run qg_RefreshIndexBrowse.
  run qg_RefreshFieldBrowse.
  
  run qg_UpdateBufferName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock1
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock1 hQueryWindow
ON choose OF btnBlock1 IN FRAME fQuery /* 1 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_1}).
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock2
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock2 hQueryWindow
ON choose OF btnBlock2 IN FRAME fQuery /* 2 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_2}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock3
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock3 hQueryWindow
ON choose OF btnBlock3 IN FRAME fQuery /* 3 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_3}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock4
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock4 hQueryWindow
ON choose OF btnBlock4 IN FRAME fQuery /* 4 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_4}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer1
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer1 hQueryWindow
ON choose OF btnBuffer1 IN FRAME fQuery /* 1 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_1}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer2
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer2 hQueryWindow
ON choose OF btnBuffer2 IN FRAME fQuery /* 2 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_2}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer3
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer3 hQueryWindow
ON choose OF btnBuffer3 IN FRAME fQuery /* 3 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_3}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer4
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer4 hQueryWindow
ON choose OF btnBuffer4 IN FRAME fQuery /* 4 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_4}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearBlockName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearBlockName hQueryWindow
ON choose OF btnClearBlockName IN FRAME fQuery
do:
  
  run qg_SetBlockPattern('':U).
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearBufferPattern
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearBufferPattern hQueryWindow
ON choose OF btnClearBufferPattern IN FRAME fQuery
do:

  run qg_SetBufferPattern('':U, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearFieldFilter hQueryWindow
ON choose OF btnClearFieldFilter IN FRAME fQuery
do:

  gcFieldFilter = '':U.
  
  display unless-hidden
    gcFieldFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcFieldFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearFieldLabelFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearFieldLabelFilter hQueryWindow
ON choose OF btnClearFieldLabelFilter IN FRAME fQuery
do:

  gcFieldLabelFilter = '':U.
  
  display unless-hidden
    gcFieldLabelFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcFieldLabelFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearIndexFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearIndexFieldFilter hQueryWindow
ON choose OF btnClearIndexFieldFilter IN FRAME fQuery
do:
  
  gcIndexFieldFilter = '':U.
  
  display unless-hidden
    gcIndexFieldFilter
    with frame {&FRAME-NAME}.
  
  apply 'value-changed':U to gcIndexFieldFilter in frame {&FRAME-NAME}.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearIndexFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearIndexFilter hQueryWindow
ON choose OF btnClearIndexFilter IN FRAME fQuery
do:

  gcIndexFilter = '':U.
  
  display unless-hidden
    gcIndexFilter
    with frame {&FRAME-NAME}.
  
  apply 'value-changed':U to gcIndexFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearTableFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearTableFieldFilter hQueryWindow
ON choose OF btnClearTableFieldFilter IN FRAME fQuery
do:

  gcTableFieldFilter = '':U.
  
  display unless-hidden
    gcTableFieldFilter
    with frame {&FRAME-NAME}.
  
  apply 'value-changed':U to gcTableFieldFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearTableFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearTableFilter hQueryWindow
ON choose OF btnClearTableFilter IN FRAME fQuery
do:

  gcTableFilter = '':U.
  
  display unless-hidden
    gcTableFilter
    with frame {&FRAME-NAME}.
  
  apply 'value-changed':U to gcTableFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnConnectDB
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnConnectDB hQueryWindow
ON choose OF btnConnectDB IN FRAME fQuery /* Connect */
do:

define variable lPar01    as logical   no-undo.
define variable cPar02    as character no-undo. /* physical name */
define variable cPar03    as character no-undo. /* logical name */
define variable cPar04    as character no-undo. /* db type */
define variable lPar05    as logical   no-undo.
define variable cPar06    as character no-undo. 
define variable cPar07    as character no-undo. 
define variable cPar08    as character no-undo. 
define variable cPar09    as character no-undo. 
define variable cPar10    as character no-undo. 
define variable cPar11    as character no-undo. 
define variable cPar12    as character no-undo. 
define variable cPar13    as character no-undo. 
define variable cPar14    as character no-undo. 

define buffer bttDatabase for temp-table ttDatabase.

assign
  lPar01 = yes
  cPar04 = 'PROGRESS':U
  lPar05 = no.
  .

run adecomm/_dbconnx.p(lPar01,
                       input-output cPar02,
                       input-output cPar03,
                       input-output cPar04,
                       input-output lPar05,
                       input-output cPar06,
                       input-output cPar07,
                       input-output cPar08,
                       input-output cPar09,
                       input-output cPar10,
                       input-output cPar11,
                       input-output cPar12,
                       input-output cPar13,
                             output cPar14).

if    cPar02 <> ?
  and cPar03 <> ? then
do:
  
  run qg_AddDatabase(cPar03).
  {&OPEN-QUERY-brDatabase}
  
  find bttDatabase
    where bttDatabase.DatabaseName = cPar03
    no-error.
  
  reposition brDatabase to rowid rowid(bttDatabase).
  
  apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.
  
end. /* if    cPar02 <> ? ... */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnCopyToClipboard
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnCopyToClipboard hQueryWindow
ON choose OF btnCopyToClipboard IN FRAME fQuery /* Copy */
do:

  if glInsertMode then
    run qg_InsertQueryText.
    
  else
    clipboard:value = gcQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnDecreaseIndentation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnDecreaseIndentation hQueryWindow
ON choose OF btnDecreaseIndentation IN FRAME fQuery /* << */
do:

  giIndentation = max(0, giIndentation - 2).
  
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnDisconnectDB
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnDisconnectDB hQueryWindow
ON choose OF btnDisconnectDB IN FRAME fQuery /* Disconnect */
do:
  
  define variable cDatabase as character no-undo.
  
  define variable lOk       as logical   no-undo.
  
  cDatabase = (if available ttDatabase then
                 ttDatabase.DatabaseName
               else
                 '':U).
  
  if connected(cDatabase) then
  do:
    
    message /* code checked by mth */
      substitute('Are you sure you want to disconnect database &1':T,
                 cDatabase) skip
      view-as alert-box
      question
      buttons ok-cancel
      update lOk.
    
    if not lOk then
      leave.
      
    disconnect value(cDatabase).
  
  end. /* if connected(cDatabase) */
  
  run qg_RemoveDatabase(cDatabase).
  {&OPEN-QUERY-brDatabase}
  
  process events.
  
  run qg_CloseInvalidQueryWindows.

  apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnExecuteQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnExecuteQuery hQueryWindow
ON choose OF btnExecuteQuery IN FRAME fQuery /* Execute */
do:

  define variable cDatabase  as character no-undo.
  define variable cTable     as character no-undo.
  define variable cQueryText as character no-undo.
  
  if    available ttDatabase
    and available ttTable then
  do:
    
    assign
      cDatabase  = ttDatabase.DatabaseName
      cTable     = ttTable.TableName
      cQueryText = substitute('for each &1~n&2~n':U,
                              cTable,
                              qg_cCreateWhereClause(cDatabase,
                                                    cTable,
                                                    cTable,
                                                    qg_cCurrentFieldList(),
                                                    yes,
                                                    {&K_VALUE_MODE_DEFAULT_VALUE},
                                                    no,
                                                    2))
      .

    run qg_ExecQuery(cDatabase,
                     cTable,
                     cQueryText,
                     ?).
    
  end. /* if    available ttDatabase */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnIncreaseIndentation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnIncreaseIndentation hQueryWindow
ON choose OF btnIncreaseIndentation IN FRAME fQuery /* >> */
do:

  giIndentation = giIndentation + 2.
  
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnRefresh
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnRefresh hQueryWindow
ON choose OF btnRefresh IN FRAME fQuery /* Refresh */
do:

  run qg_LoadCache(?).
  run qg_CloseInvalidQueryWindows.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnResetAll
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnResetAll hQueryWindow
ON choose OF btnResetAll IN FRAME fQuery /* Reset */
do:

  run qg_SetDefaultValues.
  
  apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnResetIndentation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnResetIndentation hQueryWindow
ON choose OF btnResetIndentation IN FRAME fQuery /* | */
do:

  giIndentation = {&K_DEFAULT_INDENTATION}.
  
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcBlockName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBlockName hQueryWindow
ON end-error OF gcBlockName IN FRAME fQuery /* Block */
do:

  apply 'choose':U to btnClearBlockName in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBlockName hQueryWindow
ON value-changed OF gcBlockName IN FRAME fQuery /* Block */
do:

  run qg_ProcessBlockNameChange.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcBufferName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBufferName hQueryWindow
ON end-error OF gcBufferName IN FRAME fQuery /* Buffer */
do:

  apply 'choose':U to btnClearBufferPattern in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBufferName hQueryWindow
ON value-changed OF gcBufferName IN FRAME fQuery /* Buffer */
do:

  run qg_ProcessBufferNameChange.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON end-error OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  apply 'choose':U to btnClearFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON leave OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  run qg_FixCase(gcFieldFilter:handle in frame {&FRAME-NAME}).
  
  if brField:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcFieldFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON return OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  if available ttField then
  do:
    
    gcFieldFilter = ttField.FieldName.
    
    display unless-hidden
      gcFieldFilter
      with frame {&FRAME-NAME}.
    
    apply 'value-changed':U to gcFieldFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcFieldFilter:handle in frame {&FRAME-NAME}).
    
  end. /* if available ttField */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON value-changed OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  run qg_RefreshFieldBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcFieldLabelFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldLabelFilter hQueryWindow
ON end-error OF gcFieldLabelFilter IN FRAME fQuery
do:

  apply 'choose':U to btnClearFieldLabelFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldLabelFilter hQueryWindow
ON leave OF gcFieldLabelFilter IN FRAME fQuery
do:

  run qg_FixCase(gcFieldLabelFilter:handle in frame {&FRAME-NAME}).
  
  if brField:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcFieldLabelFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldLabelFilter hQueryWindow
ON value-changed OF gcFieldLabelFilter IN FRAME fQuery
do:

  run qg_RefreshFieldBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcIndexFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFieldFilter hQueryWindow
ON end-error OF gcIndexFieldFilter IN FRAME fQuery
do:

  apply 'choose':U to btnClearIndexFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFieldFilter hQueryWindow
ON leave OF gcIndexFieldFilter IN FRAME fQuery
do:

  run qg_FixCase(gcIndexFieldFilter:handle in frame {&FRAME-NAME}).
  
  if brIndex:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcIndexFieldFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFieldFilter hQueryWindow
ON value-changed OF gcIndexFieldFilter IN FRAME fQuery
do:

  run qg_RefreshIndexBrowse.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcIndexFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON end-error OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  apply 'choose':U to btnClearIndexFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON leave OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  run qg_FixCase(gcIndexFilter:handle in frame {&FRAME-NAME}).
  
  if brIndex:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcIndexFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON return OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  if available ttIndex then
  do:
    
    gcIndexFilter = ttIndex.IndexName.
    
    display unless-hidden
      gcIndexFilter
      with frame {&FRAME-NAME}.
    
    apply 'value-changed':U to gcIndexFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcIndexFilter:handle in frame {&FRAME-NAME}).
    
  end. /* if available ttIndex */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON value-changed OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  run qg_RefreshIndexBrowse.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcTableFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFieldFilter hQueryWindow
ON end-error OF gcTableFieldFilter IN FRAME fQuery
do:

  apply 'choose':U to btnClearTableFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFieldFilter hQueryWindow
ON leave OF gcTableFieldFilter IN FRAME fQuery
do:

  run qg_FixCase(gcTableFieldFilter:handle in frame {&FRAME-NAME}).
  
  if brTable:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcTableFieldFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFieldFilter hQueryWindow
ON value-changed OF gcTableFieldFilter IN FRAME fQuery
do:

  run qg_RefreshTableBrowse.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcTableFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON end-error OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  apply 'choose':U to btnClearTableFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON leave OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  run qg_FixCase(gcTableFilter:handle in frame {&FRAME-NAME}).
  
  if brTable:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcTableFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON return OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  if available ttTable then
  do:
    
    gcTableFilter = ttTable.TableName.
    
    display unless-hidden
      gcTableFilter
      with frame {&FRAME-NAME}.
    
    apply 'value-changed':U to gcTableFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcTableFilter:handle in frame {&FRAME-NAME}).
    
  end. /* if available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON value-changed OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  run qg_RefreshTableBrowse.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giDisplayMode
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giDisplayMode hQueryWindow
ON value-changed OF giDisplayMode IN FRAME fQuery
do:
  
  giDisplayMode = input frame {&FRAME-NAME} giDisplayMode.
  
  run qg_SetDisplayMode(giDisplayMode).
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giOnErrorPhrase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giOnErrorPhrase hQueryWindow
ON value-changed OF giOnErrorPhrase IN FRAME fQuery
do:
  
  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giQueryRange
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giQueryRange hQueryWindow
ON value-changed OF giQueryRange IN FRAME fQuery
do:
  
  btnExecuteQuery:sensitive in frame {&FRAME-NAME}  /* code checked by mth */
      = (giQueryType = {&K_QUERYTYPE_FOREACH}).
  
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giQueryType
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giQueryType hQueryWindow
ON value-changed OF giQueryType IN FRAME fQuery
do:

  run qg_FillQueryRange.
  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glCompanyViaClass
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glCompanyViaClass hQueryWindow
ON value-changed OF glCompanyViaClass IN FRAME fQuery
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glDefineBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glDefineBlock hQueryWindow
ON value-changed OF glDefineBlock IN FRAME fQuery /* define block */
do:
  
  run qg_UpdateQueryText.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glDefineBuffer
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glDefineBuffer hQueryWindow
ON value-changed OF glDefineBuffer IN FRAME fQuery /* define buffer */
do:
  
  assign
    glDefineBuffer   = (if glSlimMode then
                          {&K_DEFAULT_DEFINE_BUFFER}
                        else
                          input frame {&FRAME-NAME} glDefineBuffer).
    gcBufferBaseName = qg_cGetBufferBaseName(   glDefineBuffer
                                             or (  gcBufferPattern > '':U
                                               and gcBufferPattern <> '&1':U)).
  
  run qg_UpdateBufferName.
  
  run qg_UpdateQueryText.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glDoBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glDoBlock hQueryWindow
ON value-changed OF glDoBlock IN FRAME fQuery /* do */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glExclusiveLock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glExclusiveLock hQueryWindow
ON value-changed OF glExclusiveLock IN FRAME fQuery
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glFinallyBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glFinallyBlock hQueryWindow
ON value-changed OF glFinallyBlock IN FRAME fQuery /* finally block */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glIfStatement
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glIfStatement hQueryWindow
ON value-changed OF glIfStatement IN FRAME fQuery /* if statement */
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glNoError
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glNoError hQueryWindow
ON value-changed OF glNoError IN FRAME fQuery /* no error */
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glNot
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glNot hQueryWindow
ON value-changed OF glNot IN FRAME fQuery /* not */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glRetryBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glRetryBlock hQueryWindow
ON value-changed OF glRetryBlock IN FRAME fQuery /* retry block */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_About
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_About hQueryWindow
ON choose OF MENU-ITEM mi_About /* About Query Generator */
do:

  run qg_About.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AddPersistentTempTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AddPersistentTempTable hQueryWindow
ON choose OF MENU-ITEM mi_AddPersistentTempTable /* Add persistent temp table */
do:

  run qg_AddPersistentTempTable.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AddSnapshot
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AddSnapshot hQueryWindow
ON choose OF MENU-ITEM mi_AddSnapshot /* Add snpapshot */
do:

  define variable hBuffer as handle no-undo.
  
  if available ttTable then
  do on error undo, throw:
    
    if ttTable.PhysicalTable then
      create buffer hBuffer for table substitute('&1.&2':U,
                                                 ttTable.DatabaseName,
                                                 ttTable.TableName).
    
    else if valid-handle(ttTable.TableHandle) then
      create buffer hBuffer for table ttTable.TableHandle.
    
    if valid-handle(hBuffer) then
      run qg_AddTableSnapshot(hBuffer, '':U, {&WINDOW-NAME}).
    
    finally:
      
      if valid-handle(hBuffer) then
        delete object hBuffer.
      
    end finally.
    
  end. /* if    available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AddSnapshotBtn
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AddSnapshotBtn hQueryWindow
ON choose OF MENU-ITEM mi_AddSnapshotBtn /* Add snapshot */
do:

  apply 'choose':U to menu-item mi_AddSnapshot in menu m_Tools.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CloseAllQueryWindows
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CloseAllQueryWindows hQueryWindow
ON choose OF MENU-ITEM mi_CloseAllQueryWindows /* Close all query windows */
do:

  define buffer bttQueryWindow for ttQueryWindow.
  
  for each bttQueryWindow
    on error undo, throw:
    
    if valid-handle(bttQueryWindow.WindowHandle) then
      apply 'window-close':U to bttQueryWindow.WindowHandle.
    
    else
      delete bttQueryWindow.
    
  end. /* for each bttQueryWindow */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CloseAllRecordWindows
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CloseAllRecordWindows hQueryWindow
ON choose OF MENU-ITEM mi_CloseAllRecordWindows /* Close all record windows */
do:

  define buffer bttRecordWindow for ttRecordWindow.
  
  for each bttRecordWindow
    on error undo, throw:
    
    if valid-handle(bttRecordWindow.WindowHandle) then
      apply 'window-close':U to bttRecordWindow.WindowHandle.
    
    else
      delete bttRecordWindow.
    
  end. /* for each bttQueryWindow */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyDatabaseName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyDatabaseName hQueryWindow
ON choose OF MENU-ITEM mi_CopyDatabaseName /* Copy name */
do:

  if available ttDatabase then
    clipboard:value = ttDatabase.DatabaseName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldAssignments
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldAssignments hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldAssignments /* Copy field assignments */
do:
  
  if glInsertMode then
    run qg_InsertFieldAssigments.
      
  else
    clipboard:value = qg_cFieldAssignments(no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldAssignStatement
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldAssignStatement hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldAssignStatement /* Copy assign statement */
do:

  if glInsertMode then
    run qg_InsertFieldAssignStatement.
      
  else
    clipboard:value = qg_cFieldAssignStatement(no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldColumnLabel
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldColumnLabel hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldColumnLabel /* Copy column label */
do:

  if available ttField then
    clipboard:value = ttField.FieldColumnLabel.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldDomain
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldDomain hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldDomain /* Copy Domain */
do:

  if available(ttField) then
    clipboard:value = ttField.Domain.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldFormat
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldFormat hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldFormat /* Copy format */
do:

  if available(ttField) then
    clipboard:value = ttField.FieldFormat.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldInitialValue
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldInitialValue hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldInitialValue /* Copy initial value */
do:
  if available ttField then
    clipboard:value = ttField.FieldInitialValue.
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldLabel
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldLabel hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldLabel /* Copy label */
do:

  if available ttField then
    clipboard:value = ttField.FieldLabel.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldName hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldName /* Copy name */
do:

  if available(ttField) then
    clipboard:value = ttField.FieldName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldNamesCommaSeparated
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldNamesCommaSeparated hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldNamesCommaSeparated /* Copy names (comma separated) */
do:
  
  define variable lOk as logical   no-undo.
  
  gcBufferName = (if glSlimMode then
                    substitute({&K_DEFAULT_BUFFER_PATTERN},
                               qg_cGetBufferBaseName(no))
                  else
                    input frame {&FRAME-NAME} gcBufferName).
  
  message /* code checked by mth */
    'Do you want to include the buffer name?':T skip
    view-as alert-box
      question
      buttons yes-no
      update lOk.
  
  clipboard:value = qg_cGetSelectedFields((if lOk then
                                             gcBufferName
                                           else
                                             ?),
                                          ',':U,
                                          no).
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldNamesLineSeparated
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldNamesLineSeparated hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldNamesLineSeparated /* Copy names (line separated) */
do:

  define variable lOk as logical   no-undo.
  
  gcBufferName = (if glSlimMode then
                    substitute({&K_DEFAULT_BUFFER_PATTERN},
                               qg_cGetBufferBaseName(no))
                  else
                    input frame {&FRAME-NAME} gcBufferName).
  
  message /* code checked by mth */
    'Do you want to include the buffer name?':T skip
    view-as alert-box
      question
      buttons yes-no
      update lOk.
  
  clipboard:value = qg_cGetSelectedFields((if lOk then
                                             gcBufferName
                                           else
                                             ?),
                                          '~n':U,
                                          no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldNamesSpaceSeparated
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldNamesSpaceSeparated hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldNamesSpaceSeparated /* Copy names (space separated) */
do:

  define variable lOk as logical   no-undo.
  
  gcBufferName = (if glSlimMode then
                    substitute({&K_DEFAULT_BUFFER_PATTERN},
                               qg_cGetBufferBaseName(no))
                  else
                    input frame {&FRAME-NAME} gcBufferName).
  
  message /* code checked by mth */
    'Do you want to include the buffer name?':T skip
    view-as alert-box
      question
      buttons yes-no
      update lOk.
  
  clipboard:value = qg_cGetSelectedFields((if lOk then
                                             gcBufferName
                                           else
                                             ?),
                                          ' ':U,
                                          no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFullFieldName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFullFieldName hQueryWindow
ON choose OF MENU-ITEM mi_CopyFullFieldName /* Copy name */
do:

  if available(ttField) then
    assign
      gcBufferName    = (if glSlimMode then
                           substitute({&K_DEFAULT_BUFFER_PATTERN},
                                      qg_cGetBufferBaseName(no))
                         else
                           input frame {&FRAME-NAME} gcBufferName)
      clipboard:value = substitute('&1.&2':U,
                                   gcBufferName,
                                   ttField.FieldName)
      .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyIndexFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyIndexFields hQueryWindow
ON choose OF MENU-ITEM mi_CopyIndexFields /* Copy fields */
do:

  if available ttIndex then
    clipboard:value = ttIndex.IndexFields.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyIndexName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyIndexName hQueryWindow
ON choose OF MENU-ITEM mi_CopyIndexName /* Copy name */
do:

  if available ttIndex then
    clipboard:value = ttIndex.IndexName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyPhysicalName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyPhysicalName hQueryWindow
ON choose OF MENU-ITEM mi_CopyPhysicalName /* Copy physical name */
do:

  if available ttDatabase then
    clipboard:value = ttDatabase.PhysicalName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyPutStatement
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyPutStatement hQueryWindow
ON choose OF MENU-ITEM mi_CopyPutStatement /* Copy put statement */
do:

  if glInsertMode then
    run qg_InsertPutStatement.
      
  else
    clipboard:value = qg_cPutStatement(no).
  

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_CopyQueryScenario /* Copy query scenario */
do:

  run qg_SaveQueryScenario(?).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyQueryText
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyQueryText hQueryWindow
ON choose OF MENU-ITEM mi_CopyQueryText /* Copy query text */
do:

  clipboard:value = gcQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableCompanyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableCompanyInclude hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableCompanyInclude /* Copy include name */
do:

  clipboard:value = (if    available ttTable
                       and ttTable.CompanyInclude > '':U then
                       ttTable.CompanyInclude
                     else
                       '':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableCompanyIncludeReference
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableCompanyIncludeReference hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableCompanyIncludeReference /* Copy include reference */
do:

  define variable cIncludeReferenceText as character no-undo.
  
  if    available ttTable
    and ttTable.CompanyInclude > '':U then
    cIncludeReferenceText = substitute('~{firma/&1 &2~}&3':U,
                                       ttTable.CompanyInclude,
                                       qg_cTaggedValue((if glCompanyViaClass then
                                                          '{&K_CLASS_COMPANY_STATEMENT}':U
                                                        else
                                                          'pa-Firma':U),
                                                        glInsertMode),
                                           (if glInsertMode then
                                             '$~{cursor~}':U
                                            else
                                              '':U)).
    
  if glInsertMode then
    run qg_IDE_InsertText(cIncludeReferenceText).
    
  else
    clipboard:value = cIncludeReferenceText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableCreateTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableCreateTrigger hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableCreateTrigger /* Copy trigger name */
do:

  if    available ttTable
    and ttTable.CreateTriggerProcName > '':U then
    clipboard:value = ttTable.CreateTriggerProcName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableDefineBuffer
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableDefineBuffer hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableDefineBuffer /* Copy "define buffer" */
do:

  if available ttTable then
  do:
    
    if glInsertMode then
      run qg_InsertBufferDefinition.
    
    else
      assign
        gcBufferName    = (if glSlimMode then
                             substitute({&K_DEFAULT_BUFFER_PATTERN},
                                        qg_cGetBufferBaseName(no))
                           else
                             input frame {&FRAME-NAME} gcBufferName)
        clipboard:value = substitute('define buffer &1 for &2.':U,
                                     gcBufferName,
                                     ttTable.TableName)
        .
    
  end. /* if available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableDeleteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableDeleteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableDeleteTrigger /* Copy trigger name */
do:

  if    available ttTable
    and ttTable.DeleteTriggerProcName > '':U then
    clipboard:value = ttTable.DeleteTriggerProcName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableFillInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableFillInclude hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableFillInclude /* Copy include name */
do:

  clipboard:value = (if    available ttTable
                       and ttTable.FillInclude > '':U then
                       ttTable.FillInclude
                     else
                       '':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableFillIncludeReference
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableFillIncludeReference hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableFillIncludeReference /* Copy include reference */
do:

  define variable cFillInclude          as character no-undo.
  define variable cIncludeReferenceText as character no-undo.
  
  if    available ttTable
    and ttTable.FillInclude > '':U then
  do:
    
    cFillInclude = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                    ttTable.FillInclude) no-error.
    
    if cFillInclude > '':U then
      assign
        gcBufferName          = (if glSlimMode then
                                   substitute({&K_DEFAULT_BUFFER_PATTERN},
                                              qg_cGetBufferBaseName(no))
                                 else
                                   input frame {&FRAME-NAME} gcBufferName)
        cIncludeReferenceText = substitute('~{&1~n  &&Buffer = "&2"~n~}&3':U,
                                           cFillInclude,
                                           qg_cTaggedValue(gcBufferName, glInsertMode),
                                           (if glInsertMode then
                                             '$~{cursor~}':U
                                            else
                                              '':U))
        .
    
  end. /* if    available ttTable */
  
  if glInsertMode then
    run qg_IDE_InsertText(cIncludeReferenceText).
    
  else
    clipboard:value = cIncludeReferenceText.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableKeyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableKeyInclude hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableKeyInclude /* Copy include name */
do:

  clipboard:value = (if    available ttTable
                       and ttTable.KeyInclude > '':U then
                       ttTable.KeyInclude
                     else
                       '':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableKeyIncludeReference
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableKeyIncludeReference hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableKeyIncludeReference /* Copy include reference */
do:
  
  define variable cKeyInclude           as character no-undo.
  define variable cIncludeReferenceText as character no-undo.

  
  if    available ttTable
    and ttTable.KeyInclude > '':U then
  do:
    
    cKeyInclude = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                   ttTable.KeyInclude) no-error.
    
    if cKeyInclude > '':U then
      assign
        gcBufferName          = (if glSlimMode then
                                   substitute({&K_DEFAULT_BUFFER_PATTERN},
                                              qg_cGetBufferBaseName(no))
                                 else
                                   input frame {&FRAME-NAME} gcBufferName)
        cIncludeReferenceText = substitute('~{&1 &&Tabelle = "&2"~}&3':U,
                                           cKeyInclude,
                                           qg_cTaggedValue(gcBufferName, glInsertMode),
                                           (if glInsertMode then
                                             '$~{cursor~}':U
                                            else
                                              '':U))
        .
      
  end. /* if    available ttTable */

  if glInsertMode then
    run qg_IDE_InsertText(cIncludeReferenceText).
    
  else
    clipboard:value = cIncludeReferenceText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableName hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableName /* Copy name */
do:

  if available ttTable then
      clipboard:value = (if glSlimMode then
                           substitute({&K_DEFAULT_BUFFER_PATTERN},
                                      qg_cGetBufferBaseName(no))
                         else
                           input frame {&FRAME-NAME} gcBufferName).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableWriteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableWriteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableWriteTrigger /* Copy trigger name */
do:

  if    available ttTable
    and ttTable.WriteTriggerProcName > '':U then
    clipboard:value = ttTable.WriteTriggerProcName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_DataAdministration
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_DataAdministration hQueryWindow
ON choose OF MENU-ITEM mi_DataAdministration /* Data Administration */
do:

  run qg_SetWorkingDatabase.
  run _admin.p.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_DataDictionary
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_DataDictionary hQueryWindow
ON choose OF MENU-ITEM mi_DataDictionary /* Data Dictionary */
do:

  run qg_SetWorkingDatabase.
  run adedict/_dictg.p.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ExecuteQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ExecuteQuery hQueryWindow
ON choose OF MENU-ITEM mi_ExecuteQuery /* Execute query */
do:

  define variable hFocusWidget as handle    no-undo.
  
  hFocusWidget = focus.
  
  if valid-handle(hFocusWidget) then
  do:
    
    /* Fire leave trigger but keep focus in active widget. */
    apply 'leave':U to hFocusWidget.
    apply 'entry':U to hFocusWidget.
    
  end. /* if valid-handle(hFocusWidget) */
  
  apply 'choose':U to btnExecuteQuery in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_Exit
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_Exit hQueryWindow
ON choose OF MENU-ITEM mi_Exit /* Exit */
do:
  
  apply 'window-close':U to hQueryWindow.
  
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_FilterDataypes
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_FilterDataypes hQueryWindow
ON choose OF MENU-ITEM mi_FilterDataypes /* Dataype filter */
do:

  run qg_UpdateFieldDataypeFilter.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_FindFieldIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_FindFieldIndex hQueryWindow
ON choose OF MENU-ITEM mi_FindFieldIndex /* Find index for selected fields */
do:

  if available ttField then
  do:
    
    gcIndexfieldFilter = qg_cGetSelectedFields(?, ',':U, yes).
    
    display unless-hidden
      gcIndexFieldFilter
      with frame {&FRAME-NAME}.
    
    run qg_SetDisplayMode({&K_DISPLAYMODE_INDEX}).
    
    apply 'value-changed':U to gcIndexFieldFilter in frame {&FRAME-NAME}.
    
  end. /* if available ttIndex */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_FindFieldTables
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_FindFieldTables hQueryWindow
ON choose OF MENU-ITEM mi_FindFieldTables /* Find tables containing selected fields */
do:

  if available ttField then
  do:
    
    gcTableFieldFilter = qg_cGetSelectedFields(?, ',':U, yes).
    
    display unless-hidden
      gcTableFieldFilter
      with frame {&FRAME-NAME}.
    
    apply 'value-changed':U to gcTableFieldFilter in frame {&FRAME-NAME}.
    
  end. /* if available ttIndex */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_InsertMode
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_InsertMode hQueryWindow
ON value-changed OF MENU-ITEM mi_InsertMode /* Insert mode */
do:

  glInsertMode = menu-item mi_InsertMode:checked in menu m_Options.
  run qg_WidgetState('*':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_InsertModeBtn
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_InsertModeBtn hQueryWindow
ON value-changed OF MENU-ITEM mi_InsertModeBtn /* Insert mode */
do:

  glInsertMode = menu-item mi_InsertModeBtn:checked in menu POPUP-MENU-btnCopyToClipboard.
  run qg_WidgetState('*':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_InsertQueryText
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_InsertQueryText hQueryWindow
ON choose OF MENU-ITEM mi_InsertQueryText /* Insert query text */
do:

  run qg_InsertQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_LoadDataDefinitions
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_LoadDataDefinitions hQueryWindow
ON choose OF MENU-ITEM mi_LoadDataDefinitions /* Load data definitions (.df) */
do:

  run qg_LoadDataDefinitions(hQueryWindow).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_LoadQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_LoadQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_LoadQueryScenario /* Load query scenario */
do:

  define variable lOk as logical   no-undo.

  system-dialog get-file gcQRScenarioFileName
    title             gcTitlePrefix + 'Load query scenario ...':U
    filters           'Query scenario (*.qsc)':U '*.qsc':U
    default-extension '.qsc':U
    ask-overwrite
    use-filename
    update lOk
    in window hQueryWindow
    .
  
  if not lOk then
    return.
  
  run qg_LoadQueryScenario(gcQRScenarioFileName).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ModifyIndexQueryFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ModifyIndexQueryFields hQueryWindow
ON choose OF MENU-ITEM mi_ModifyIndexQueryFields /* Modify query fields */
do:

  if available ttIndex then
  do:
    
    run qg_SetDisplayMode({&K_DISPLAYMODE_FIELD}).
    run qg_SelectFieldList(ttIndex.IndexFieldList).
    
    apply 'value-changed':U to brField in frame {&FRAME-NAME}.
    
  end. /* if available ttIndex */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableCompanyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableCompanyInclude hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableCompanyInclude /* Open include file */
do:

  define variable cFilename    as character no-undo.
  
  if    available ttTable
    and ttTable.CompanyInclude > '':U then
  do:
    
    cFilename = search(substitute('firma/&1':U,
                                  ttTable.CompanyInclude)).
    
    if cFilename > '':U then
      run qg_OpenFile(cFilename).
    
  end. /* if    available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableCreateTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableCreateTrigger hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableCreateTrigger /* Open trigger procedure */
do:

  define variable cFilename as character no-undo.
  
  if    available ttTable
    and ttTable.CreateTrigger > '':U then
  do:
    
    cFilename = search(ttTable.CreateTrigger).
    
    if cFilename > '':U then
      run qg_OpenFile(cFilename).
    
  end. /* if    available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableDeleteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableDeleteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableDeleteTrigger /* Open trigger procedure */
do:

  define variable cFilename as character no-undo.
  
  if    available ttTable
    and ttTable.DeleteTrigger > '':U then
  do:
    
    cFilename = search(ttTable.DeleteTrigger).
    
    if cFilename > '':U then
      run qg_OpenFile(cFilename).
    
  end. /* if    available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableFillInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableFillInclude hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableFillInclude /* Open include file */
do:

  define variable cIncludeName as character no-undo.
  define variable cFilename    as character no-undo.
  
  if    available ttTable
    and ttTable.CompanyInclude > '':U then
  do:
    
    cIncludeName = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                    ttTable.FillInclude) no-error.
    
    cFilename = search(cIncludeName).
    
    if cFilename > '':U then
      run qg_OpenFile(cFilename).
    
  end. /* if    available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableKeyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableKeyInclude hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableKeyInclude /* Open include file */
do:

  define variable cIncludeName as character no-undo.
  define variable cFilename    as character no-undo.
  
  if    available ttTable
    and ttTable.KeyInclude > '':U then
  do:
    
    cIncludeName = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                    ttTable.KeyInclude) no-error.
    
    cFilename = search(cIncludeName).
    
    if cFilename > '':U then
      run qg_OpenFile(cFilename).
    
  end. /* if    available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableWriteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableWriteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableWriteTrigger /* Open trigger procedure */
do:

  define variable cFilename as character no-undo.
  
  if    available ttTable
    and ttTable.WriteTrigger > '':U then
  do:
    
    cFilename = search(ttTable.WriteTrigger).
    
    if cFilename > '':U then
      run qg_OpenFile(cFilename).
    
  end. /* if    available ttTable */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_PasteQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_PasteQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_PasteQueryScenario /* Paste query scenario */
do:

  run qg_LoadQueryScenario(?).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_RemoveTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_RemoveTable hQueryWindow
ON choose OF MENU-ITEM mi_RemoveTable /* Remove table */
do:

  if    available ttDatabase
    and available ttTable
    and not ttTable.PhysicalTable then
  do:
    
    run qg_RemoveTable(ttTable.DatabaseName, ttTable.TableName).
    
    if can-find(first ttTable
                  where ttTable.DatabaseName = ttDatabase.DatabaseName) then
    do:
      
      {&OPEN-QUERY-brTable}
      
      process events.
      
      apply 'value-changed':U to brTable in frame {&FRAME-NAME}.
      
    end. /* if can-find(first ttTable */
    
    else
    do:
      
      run qg_RemoveDatabase(ttDatabase.DatabaseName).
      {&OPEN-QUERY-brDatabase}
      
      process events.
      
      apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.
      
    end. /* else: if can-find(first ttTable */
    
  end. /* if    available ttDatabase */
  
  run qg_CloseInvalidQueryWindows.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ResetAll
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ResetAll hQueryWindow
ON choose OF MENU-ITEM mi_ResetAll /* Reset */
do:

  apply 'choose':U to btnResetAll in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_RestoreDefaultWindowSize
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_RestoreDefaultWindowSize hQueryWindow
ON choose OF MENU-ITEM mi_RestoreDefaultWindowSize /* Restore default window size */
do:

  assign
    hQueryWindow:window-state = {&K_WINDOW_NORMAL}
    hQueryWindow:width-chars  = gdOriginalWidth
    hQueryWindow:height-chars = gdOriginalHeight
    .
  
  apply 'window-resized':U to hQueryWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SaveQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SaveQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_SaveQueryScenario /* Save query scenario */
do:

  define variable lOk as logical   no-undo.

  system-dialog get-file gcQRScenarioFileName
    title             gcTitlePrefix + 'Save query scenario as ...':U
    filters           'Query scenario (*.qsc)':U '*.qsc':U
    default-extension '.qsc':U
    ask-overwrite
    save-as
    use-filename
    update lOk
    in window hQueryWindow
    .
  
  if not lOk then
    return.
  
  run qg_SaveQueryScenario(gcQRScenarioFileName).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SelectAllFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SelectAllFields hQueryWindow
ON choose OF MENU-ITEM mi_SelectAllFields /* Selected all */
do:

  if query brField:num-results > 0 then
  do:
    
    browse brField:select-all().
    browse brField:scroll-to-selected-row(1).
    
  end. /* if brField:num-results > 0 */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerAddFieldsAssign
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerAddFieldsAssign hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerAddFieldsAssign /* Add session triggers (assign) */
DO:

  define variable i               as integer   no-undo.
  define variable cSelectedFields as character no-undo.
  
  define buffer bttField for temp-table ttField.
  
  if available ttField then
  do:
    
    cSelectedFields = qg_cGetSelectedFields(?,
                                            ',':U,
                                            no).
    
    do i = 1 to num-entries(cSelectedFields):
      
      find bttField
        where bttField.DatabaseName = ttField.DatabaseName
          and bttField.TableName    = ttField.TableName
          and bttField.FieldName    = entry(i, cSelectedFields)
        no-error.
      
      if    available bttField
        and bttField.FieldExtent = 0 then
        run qg_AddSessionTrigger('assign':U,
                                 bttField.DatabaseName,
                                 bttField.TableName,
                                 bttField.FieldName).
      
    end. /* do i = 1 to num-entries(cSelectedFields) */
    
  end. /* if available ttField */

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerCreate
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerCreate hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerCreate /* Add session trigger (create) */
DO:

  if available ttTable then
  do:
    
    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'create':U
                    and ttSessionTrigger.DatabaseName = ttTable.DatabaseName
                    and ttSessionTrigger.TableName    = ttTable.TableName
                    and ttSessionTrigger.FieldName    = '':U) then
      run qg_RemoveSessionTrigger('create':U,
                                  ttTable.DatabaseName,
                                  ttTable.TableName,
                                  '':U).
    
    else
      run qg_AddSessionTrigger('create':U,
                               ttTable.DatabaseName,
                               ttTable.TableName,
                               '':U).
    
  end. /* if available ttTable */

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerDelete
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerDelete hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerDelete /* Add session trigger (delete) */
DO:

  if available ttTable then
  do:
    
    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'delete':U
                    and ttSessionTrigger.DatabaseName = ttTable.DatabaseName
                    and ttSessionTrigger.TableName    = ttTable.TableName
                    and ttSessionTrigger.FieldName    = '':U) then
      run qg_RemoveSessionTrigger('delete':U,
                                  ttTable.DatabaseName,
                                  ttTable.TableName,
                                  '':U).
    
    else
      run qg_AddSessionTrigger('delete':U,
                               ttTable.DatabaseName,
                               ttTable.TableName,
                               '':U).
    
  end. /* if available ttTable */

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerFieldAssign
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerFieldAssign hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerFieldAssign /* Add session trigger (assign) */
DO:

  if    available ttField
    and ttField.FieldExtent = 0 then
  do:
    
    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'assign':U
                    and ttSessionTrigger.DatabaseName = ttField.DatabaseName
                    and ttSessionTrigger.TableName    = ttField.TableName
                    and ttSessionTrigger.FieldName    = ttField.FieldName) then
      run qg_RemoveSessionTrigger('assign':U,
                                  ttField.DatabaseName,
                                  ttField.TableName,
                                  ttField.FieldName).
    
    else
      run qg_AddSessionTrigger('assign':U,
                               ttField.DatabaseName,
                               ttField.TableName,
                               ttField.FieldName).
    
  end. /* if available ttField */
  
END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerRemoveFieldsAssign
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerRemoveFieldsAssign hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerRemoveFieldsAssign /* Remove session triggers (assign) */
DO:

  define variable i               as integer   no-undo.
  define variable cSelectedFields as character no-undo.
  
  if available ttField then
  do:
    
    cSelectedFields = qg_cGetSelectedFields(?,
                                            ',':U,
                                            no).
    
    do i = 1 to num-entries(cSelectedFields):
      
      run qg_RemoveSessionTrigger('assign':U,
                                  ttField.DatabaseName,
                                  ttField.TableName,
                                  entry(i, cSelectedFields)).
      
    end. /* do i = 1 to num-entries(cSelectedFields) */
    
  end. /* if available ttField */

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggers
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggers hQueryWindow
ON choose OF MENU-ITEM mi_SessionTriggers /* Session triggers */
do:

  run qg_OpenSessionTriggerWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerWrite
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerWrite hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerWrite /* Add session trigger (write) */
DO:

  if available ttTable then
  do:
    
    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'write':U
                    and ttSessionTrigger.DatabaseName = ttTable.DatabaseName
                    and ttSessionTrigger.TableName    = ttTable.TableName
                    and ttSessionTrigger.FieldName    = '':U) then
      run qg_RemoveSessionTrigger('write':U,
                                  ttTable.DatabaseName,
                                  ttTable.TableName,
                                  '':U).
    
    else
      run qg_AddSessionTrigger('write':U,
                               ttTable.DatabaseName,
                               ttTable.TableName,
                               '':U).
    
  end. /* if available ttTable */

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ShowHiddenTables
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ShowHiddenTables hQueryWindow
ON value-changed OF MENU-ITEM mi_ShowHiddenTables /* Show hidden tables */
do:

  glShowHiddenTables = menu-item mi_ShowHiddenTables:checked in menu POPUP-MENU-brTable.
  
  run qg_RefreshTableBrowse.
  run qg_WidgetState('*':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ShowQueryWindow
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ShowQueryWindow hQueryWindow
ON choose OF MENU-ITEM mi_ShowQueryWindow /* Show query window */
do:

  run qg_ShowQueryWindow(hQueryWindow).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ShowRecordWindow
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ShowRecordWindow hQueryWindow
ON choose OF MENU-ITEM mi_ShowRecordWindow /* Show record window */
do:

  run qg_ShowRecordWindow(hQueryWindow).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SlimMode
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SlimMode hQueryWindow
ON value-changed OF MENU-ITEM mi_SlimMode /* Slim mode */
do:
  
  run qg_SetSlimMode(not glSlimMode).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Edit
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Edit hQueryWindow
ON menu-drop OF MENU m_Edit /* Edit */
do:

  define variable lQueryWindows as logical   no-undo.
  
  assign
    lQueryWindows = can-find(first ttQueryWindow)
    menu-item mi_InsertQueryText:sensitive in menu m_Edit /* code checked by mth */
        =     OEIDEIsRunning
          and glIDECanInsert
    menu-item mi_CopyQueryScenario:sensitive in menu m_Edit /* code checked by mth */
        = lQueryWindows
    menu-item mi_PasteQueryScenario:sensitive in menu m_Edit /* code checked by mth */
        = lookup('PRO_TEXT':U, clipboard:available-formats) > 0
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_File
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_File hQueryWindow
ON menu-drop OF MENU m_File /* File */
do:
  
  define variable lQueryWindows as logical   no-undo.
  
  assign
    lQueryWindows = can-find(first ttQueryWindow)
    menu-item mi_SaveQueryScenario:sensitive in menu m_File /* code checked by mth */
        = lQueryWindows
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Options
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Options hQueryWindow
ON menu-drop OF MENU m_Options /* Options */
do:

  assign
    menu-item mi_InsertMode:checked in menu m_Options
        = glInsertMode
    menu-item mi_InsertMode:sensitive in menu m_Options /* code checked by mth */
        =     OEIDEIsRunning
          and glIDECanInsert
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Tools
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Tools hQueryWindow
ON menu-drop OF MENU m_Tools /* Tools */
do:

  assign
    menu-item mi_AddSnapshot:sensitive in menu m_Tools /* code checked by mth 20.01.2015 */
      =     available(ttTable)
        and not ttTable.Snapshot
    menu-item mi_AddPersistentTempTable:sensitive in menu m_Tools /* code checked by mth 20.01.2015 */
      = (proversion >= '11.2':U)
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Window
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Window hQueryWindow
ON menu-drop OF MENU m_Window /* Window */
do:

  define variable lQueryWindow  as logical   no-undo.
  define variable lRecordWindow as logical   no-undo.
  
  assign
    lQueryWindow  = can-find(first ttQueryWindow)
    menu-item mi_ShowQueryWindow:sensitive in menu m_Window /* code checked by mth */
        = lQueryWindow
    menu-item mi_CloseAllQueryWindows:sensitive in menu m_Window /* code checked by mth */
        = lQueryWindow
    lRecordWindow = can-find(first ttRecordWindow)
    menu-item mi_ShowRecordWindow:sensitive in menu m_Window /* code checked by mth */
        = lRecordWindow
    menu-item mi_CloseAllRecordWindows:sensitive in menu m_Window /* code checked by mth */
        = lRecordWindow
    menu-item mi_SlimMode:checked in menu m_Window
        = glSlimMode
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brDatabase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brDatabase hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brDatabase
do:
  
  run qg_UpdateDatabasePopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brField
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brField hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brField
do:

  run qg_UpdateFieldPopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brIndex hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brIndex
do:

  run qg_UpdateIndexPopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brTable hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brTable
do:

  run qg_UpdateTablePopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-btnCopyToClipboard
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-btnCopyToClipboard hQueryWindow
ON menu-drop OF MENU POPUP-MENU-btnCopyToClipboard
do:

  assign
    menu-item mi_InsertModeBtn:checked in menu POPUP-MENU-btnCopyToClipboard
        = glInsertMode
    menu-item mi_InsertModeBtn:sensitive in menu POPUP-MENU-btnCopyToClipboard /* code checked by mth */
        =     OEIDEIsRunning
          and glIDECanInsert
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brDatabase
&UNDEFINE SELF-NAME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _MAIN-BLOCK hQueryWindow 


/* ***************************  Main Block  *************************** */

/* Set CURRENT-WINDOW: this will parent dialog-boxes and frames.        */
assign CURRENT-WINDOW                = {&WINDOW-NAME} 
       THIS-PROCEDURE:CURRENT-WINDOW = {&WINDOW-NAME}.

/* The CLOSE event can be used from inside or outside the procedure to  */
/* terminate it.                                                        */
on close of this-procedure
  run disable_UI.

/* Best default for GUI applications is...                              */
pause 0 before-hide.

/* Now enable the interface and wait for the exit condition.            */
/* (NOTE: handle ERROR and END-KEY so cleanup code will always fire.    */
MAIN-BLOCK:
do on error   undo MAIN-BLOCK, leave MAIN-BLOCK
   on end-key undo MAIN-BLOCK, retry MAIN-BLOCK:
  
  if not retry then
  do:
    
    run enable_UI.
    
    run qg_Initialize.
  
  end. /* if not retry */
  
  if not this-procedure:persistent then
  do:
    
    wait-for close of this-procedure.
    
    /* If this procedure was used as the startup procedure for this session   */
    /* then source-procedure is not set. In this case we can quit the session */
    /* to avoid to be dropped to the procedure editor window.                 */

    if not valid-handle(source-procedure) then
      quit.
    
  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE disable_UI hQueryWindow  _DEFAULT-DISABLE
PROCEDURE disable_UI :
/*------------------------------------------------------------------------------
  Purpose:     DISABLE the User Interface
  Parameters:  <none>
  Notes:       Here we clean-up the user-interface by deleting
               dynamic widgets we have created and/or hide 
               frames.  This procedure is usually called when
               we are ready to "clean-up" after running.
------------------------------------------------------------------------------*/
  /* Delete the WINDOW we created */
  IF SESSION:DISPLAY-TYPE = "GUI":U AND VALID-HANDLE(hQueryWindow)
  THEN DELETE WIDGET hQueryWindow.
  IF THIS-PROCEDURE:PERSISTENT THEN DELETE PROCEDURE THIS-PROCEDURE.
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE enable_UI hQueryWindow  _DEFAULT-ENABLE
PROCEDURE enable_UI :
/*------------------------------------------------------------------------------
  Purpose:     ENABLE the User Interface
  Parameters:  <none>
  Notes:       Here we display/view/enable the widgets in the
               user-interface.  In addition, OPEN all queries
               associated with each FRAME and BROWSE.
               These statements here are based on the "Other 
               Settings" section of the widget Property Sheets.
------------------------------------------------------------------------------*/
  DISPLAY gdIndexUsage gcFieldLabelFilter gcFieldDummy gcTableFilter 
          gcTableFieldFilter giDisplayMode gcFieldFilter gcIndexFilter 
          gcIndexFieldFilter gcBufferName glDefineBuffer glCompanyViaClass 
          glExclusiveLock glNoError glIfStatement glNot glDoBlock 
          giOnErrorPhrase giQueryRange gcBlockName glDefineBlock glRetryBlock 
          glFinallyBlock giQueryType gcQueryText 
      WITH FRAME fQuery IN WINDOW hQueryWindow.
  ENABLE gdIndexUsage btnClearFieldLabelFilter gcFieldLabelFilter gcFieldDummy 
         brDatabase btnConnectDB btnDisconnectDB btnRefresh gcTableFilter 
         btnClearTableFilter gcTableFieldFilter btnClearTableFieldFilter 
         brTable giDisplayMode gcFieldFilter btnClearFieldFilter brField 
         gcIndexFilter btnClearIndexFilter gcIndexFieldFilter 
         btnClearIndexFieldFilter brIndex gcBufferName btnClearBufferPattern 
         btnBuffer1 btnBuffer2 btnBuffer3 btnBuffer4 glDefineBuffer 
         glCompanyViaClass glExclusiveLock glNoError glIfStatement glNot 
         glDoBlock giOnErrorPhrase giQueryRange gcBlockName btnClearBlockName 
         btnBlock1 btnBlock2 btnBlock3 btnBlock4 glDefineBlock glRetryBlock 
         glFinallyBlock giQueryType btnCopyToClipboard btnExecuteQuery 
         btnResetAll btnIncreaseIndentation btnDecreaseIndentation 
         btnResetIndentation gcQueryText 
      WITH FRAME fQuery IN WINDOW hQueryWindow.
  {&OPEN-BROWSERS-IN-QUERY-fQuery}
  VIEW hQueryWindow.
END PROCEDURE.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_About hQueryWindow 
PROCEDURE qg_About :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show about dialog.                                                         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define image imgQueryGenerator
  transparent
  size 1 by 1.

define variable cVersion as character no-undo
  format 'x(255)':U
  view-as text
  size 30 by 1.

define variable cInfoText as character no-undo
  view-as editor
  scrollbar-vertical
  size 75 by 7.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fAbout
  imgQueryGenerator at row 1.5 col 3
  cVersion at row 1.5 col 6 no-label
  cInfoText at row 2.5 col 3 no-label
  btnOk at row 10.5 col 31
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 80 by 12.44
    title gcTitlePrefix + 'About query generator':T
    default-button btnOk.

on window-close of frame fAbout
  apply 'end-error' to self.

assign
  cVersion  = substitute('Query Generator Version &1':U,
                         {&K_Version})
  cInfoText =            'The Query Generator is a tool for lazy developeres. It ...':T
              + '~n':U
              + '~n':U + '... provides fast and easy access to database schema information':T
              + '~n':U + '... helps to integrate database queries into your code with little typing effort':T
              + '~n':U + '... displays table contents in a convenient and supporting manner':T
              + '~n':U
              + '~n':U + 'This Program is provided with absolutely no warranty. Use it at your own risk.':T
              + '~n':U
              + '~n':U + 'If you want to report a bug or provide feedback please contact manuel.thiemann@proalpha.de.':T
  .

if gcIconDir > '':U then
  cInfoText =   cInfoText
              + '~n':U
              + '~n':U + 'The icons are part of the "Free FatCow-Farm Fresh Icons" (http://www.fatcow.com/free-icons). These icon sets are licensed under a Creative Commons Attribution 3.0 License (http://creativecommons.org/licenses/by/3.0/us).':T
              .

assign
  frame fAbout:height-pixels                      = frame fAbout:height-pixels + 32
  imgQueryGenerator:height-pixels in frame fAbout = 32
  imgQueryGenerator:width-pixels in frame fAbout  = 32
  cVersion:x in frame fAbout                      = cVersion:x in frame fAbout + 32
  cVersion:height-pixels in frame fAbout          = 32
  cInfoText:y in frame fAbout                     = cInfoText:y in frame fAbout + 32
  cInfoText:box       in frame fAbout = no
  cInfoText:word-wrap in frame fAbout = yes
  cInfoText:read-only in frame fAbout = yes
  btnOk:y in frame fAbout                         = btnOk:y in frame fAbout + 32
  .

if gcIconDir = '':U then
  imgQueryGenerator:load-image('adeicon/sqlexp.ico':U) no-error.

else
  imgQueryGenerator:load-image(substitute('&1/32/query_wizard.ico':U,
                                          gcIconDir)) no-error.

update unless-hidden
  imgQueryGenerator
  cVersion
  cInfoText
  btnOk
  with frame fAbout.

end procedure. /* qg_About */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddDatabase hQueryWindow 
PROCEDURE qg_AddDatabase :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add database to cache.                                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = logical name of database that should be   */
/*                                  added.                                    */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hTableBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase  for temp-table ttDatabase.
define buffer b2ttDatabase for temp-table ttDatabase.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttDatabase.

assign
  bttDatabase.DatabaseName    = ldbname(pcDatabase)
  bttDatabase.PhysicalName    = trim(pdbname(pcDatabase), '/\':U)
  bttDatabase.DirectoryName   = (if r-index(bttDatabase.PhysicalName, '\':U) > r-index(bttDatabase.PhysicalName, '/':U) then
                                   substring(bttDatabase.PhysicalName, 1, r-index(bttDatabase.PhysicalName, '\':U))
                                 else
                                   substring(bttDatabase.PhysicalName, 1, r-index(bttDatabase.PhysicalName, '/':U)))
  bttDatabase.DirectoryName   = replace(bttDatabase.DirectoryName, '/':U, '\':U)
  bttDatabase.PhysicalDB      = yes
  bttDatabase.DisplayPriority = 1000.
  .

/* Check if this database contains repository information. */

create buffer hTableBuffer for table substitute('&1._File':U, bttDatabase.DatabaseName).

hTableBuffer:find-first(substitute('where &1._File._File-Name = "DRC_Table"':U,
                                   bttDatabase.DatabaseName),
                        no-lock) no-error.

bttDatabase.BasisDB = hTableBuffer:available.

if bttDatabase.BasisDB then
do:
  
  bttDatabase.BasisDBName = bttDatabase.DatabaseName.
  
  if bttDatabase.DirectoryName > '':U then
  do:
    
    for each b2ttDatabase
      where b2ttDatabase.DirectoryName = bttDatabase.DirectoryName
        and b2ttDatabase.BasisDBName  = '':U
      on error undo, throw:
      
      b2ttDatabase.BasisDBName = b2ttDatabase.DatabaseName.
      
    end. /* for each b2ttDatabase */
    
  end. /* if b2ttDatabase.DirectoryName > '':U */
  
end. /* if bttDatabase.BasisDB */

else
do:
  
  if bttDatabase.DirectoryName > '':U then
  do:
    
    find first b2ttDatabase
      where b2ttDatabase.DirectoryName = bttDatabase.DirectoryName
        and b2ttDatabase.BasisDB       = yes
      no-lock no-error.
    
    if available b2ttDatabase then
      bttDatabase.BasisDBName = b2ttDatabase.DatabaseName.
    
  end. /* if bttDatabase.DirectoryName > '':U */
  
end. /* else: if bttDatabase.BasisDB */

if bttDatabase.DatabaseName = 'temp-db':U then
  bttDatabase.TempDB = yes.

else
do:
  
  hTableBuffer:find-first(substitute('where &1._File._File-Name begins "TD_"':U,
                                     bttDatabase.DatabaseName),
                          no-lock) no-error.

  bttDatabase.TempDB = hTableBuffer:available.
  
end. /* if bttDatabase.DatabaseName = 'temp-db':U */

finally:
  
  delete object hTableBuffer no-error.
  
  hide frame fStatus.
  
end finally.
  
end procedure. /* qg_AddDatabase */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddFieldHistoryEntry hQueryWindow 
PROCEDURE qg_AddFieldHistoryEntry :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Adds current value of given combo-box to it's value list.                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWidget                       = Combo-box widget.                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWidget as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cValue as character no-undo.
define variable i      as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cValue = phWidget:input-value no-error.
phWidget:delete(cValue) no-error.

if length(cValue) > 3 then
do:
  phWidget:add-first(cValue).
  phWidget:screen-value = cValue.
end. /* if length(cValue) > 3 */

do i = phWidget:num-items to {&K_MAX_FIELD_HISTORY_ENTRIES} + 1 by -1:
  phWidget:delete(i).
end. /* do i = {&K_MAX_FIELD_HISTORY_ENTRIES} */

/* This causes flickering
if    OEIDEIsRunning
  and glIDECanSaveSetting
  and phWidget:list-items <> ? then
  run qg_SaveIDESetting(substitute('FieldHistory_&1':U, phWidget:name),
                        phWidget:list-items) no-error.
*/

end procedure. /* qg_AddFieldHistoryEntry */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddIndices hQueryWindow 
PROCEDURE qg_AddIndices :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add Indices of given Table to cache.                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = Database that contains the Table of the   */
/*                                  indices that should be added.             */
/* pcTable                        = Table that contains the indices that      */
/*                                  should be added.                          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.
define input parameter pcTable    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFileBuffer          as handle    no-undo.
define variable hFieldBuffer         as handle    no-undo.

define variable cIndexQueryText      as character no-undo.
define variable hIndexQuery          as handle    no-undo.
define variable hIndexBuffer         as handle    no-undo.

define variable cIndexFieldQueryText as character no-undo.
define variable hIndexFieldQuery     as handle    no-undo.
define variable hIndexFieldBuffer    as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndex      for temp-table ttIndex.
define buffer bttIndexField for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    pcDatabase > '':U
  and pcTable    > '':U then
do:
  
  create buffer hFileBuffer       for table substitute('&1._File':U, pcDatabase).
  create buffer hIndexBuffer      for table substitute('&1._Index':U, pcDatabase).
  create buffer hIndexFieldBuffer for table substitute('&1._Index-Field':U, pcDatabase).
  create buffer hFieldBuffer      for table substitute('&1._Field':U, pcDatabase).
  
  hFileBuffer:find-first(substitute('where _File._File-Name = &1':U,
                                    quoter(pcTable)),
                         no-lock) no-error.
  
  if not hFileBuffer:available then
    leave.
  
  assign
    cIndexQueryText      =            'for each _Index':U
                           + '~n':U + '  where _Index._File-recid = &1':U
                           + '~n':U + '  no-lock':U
    cIndexFieldQueryText =            'for each _Index-Field':U
                           + '~n':U + '  where _Index-Field._Index-recid = &1':U
                           + '~n':U + '  no-lock':U
    .
  
  create query hIndexQuery.
  create query hIndexFieldQuery.
  
  hIndexQuery:set-buffers(hIndexBuffer).
  hIndexFieldQuery:set-buffers(hIndexFieldBuffer).
  
  hIndexQuery:query-prepare(substitute(cIndexQueryText, quoter(hFileBuffer:recid))).
  hIndexQuery:query-open().
  
  hIndexQuery:get-first().
  
  do while not hIndexQuery:query-off-end:
    
    create bttIndex.
    
    assign
      bttIndex.DatabaseName = pcDatabase
      bttIndex.TableName    = pcTable
      bttIndex.IndexName    = hIndexBuffer::_Index-Name
      bttIndex.IsPrimary    = (hIndexBuffer:recid = hFileBuffer::_Prime-Index)
      bttIndex.IsUnique     = hIndexBuffer::_Unique
      .
    
    hIndexFieldQuery:query-prepare(substitute(cIndexFieldQueryText, quoter(hIndexBuffer:recid))).
    hIndexFieldQuery:query-open().
    
    hIndexFieldQuery:get-first().
    
    do while not hIndexFieldQuery:query-off-end:
      
      hFieldBuffer:find-first(substitute('where recid(_Field) = &1':U,
                                         quoter(hIndexFieldBuffer::_Field-recid)),
                              no-lock) no-error.
      
      if not hFieldBuffer:available then
        next.
      
      create bttIndexField.
    
      assign
        bttIndexField.DatabaseName  = pcDatabase
        bttIndexField.TableName     = pcTable
        bttIndexField.IndexName     = hIndexBuffer::_Index-Name
        bttIndexField.FieldName     = hFieldBuffer::_Field-Name
        bttIndexField.IndexSequence = hIndexFieldBuffer::_Index-Seq
        bttIndexField.DataType      = hFieldBuffer::_Data-Type
        bttIndexField.SortAscending = hIndexFieldBuffer::_Ascending
        bttIndex.IndexFieldList     = substitute('&1,&2':U,
                                                 bttIndex.IndexFieldList,
                                                 bttIndexField.FieldName)
        bttIndex.IndexFields        = substitute('&1 &2&3':U,
                                                 bttIndex.IndexFields,
                                                 string(bttIndexField.SortAscending, '+/-':U),
                                                 bttIndexField.FieldName)
        .
      
      hIndexFieldQuery:get-next().
      
    end. /* do while not hIndexFieldQuery:query-off-end */
    
    assign
      bttIndex.IndexFieldList = trim(bttIndex.IndexFieldList, ',':U)
      bttIndex.IndexFields    = trim(bttIndex.IndexFields)
      .
    
    hIndexQuery:get-next().
    
  end. /* do while not hIndexQuery:query-off-end */
  
end. /* if pcDBName > '':U */

finally:
  
  if valid-handle (hFileBuffer) then
    delete object hFileBuffer.
  
  if valid-handle(hIndexQuery) then
    delete object hIndexQuery.
  
  if valid-handle (hIndexBuffer) then
    delete object hIndexBuffer.
  
  if valid-handle(hIndexFieldQuery) then
    delete object hIndexFieldQuery.
  
  if valid-handle (hIndexFieldBuffer) then
    delete object hIndexFieldBuffer.
  
  if valid-handle (hFieldBuffer) then
    delete object hFieldBuffer.
  
end finally.
  
end procedure. /* qg_AddIndices */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddPersistentTempTable hQueryWindow 
PROCEDURE qg_AddPersistentTempTable :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add persistent temp-table entry.                                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i              as integer   no-undo.

define variable hTempTable     as handle    no-undo.
define variable cProcedureName as character no-undo.

define query brPersistentProcedureBrowse
  for ttPersistentProcedure
  scrolling.

define browse brPersistentProcedureBrowse
  query brPersistentProcedureBrowse no-lock
    display
      ttPersistentProcedure.ProcedureName
      with no-assign size 70 by 18.5.

define query brPersistentTempTableBrowse
  for ttPersistentTempTable
  scrolling.

define browse brPersistentTempTableBrowse
  query brPersistentTempTableBrowse no-lock
    display
      ttPersistentTempTable.TableName
      with no-assign size 70 by 18.5 no-empty-space.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

define buffer bttPersistentProcedure for ttPersistentProcedure.
define buffer bttPersistentTempTable for ttPersistentTempTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

&IF proversion >= '11.2':U &THEN

  define frame fSelectPersistentTempTable
    brPersistentProcedureBrowse at row 1.5 col 3
    brPersistentTempTableBrowse at row 1.5 col 75
    btnOk at row 21 col 54
    btnCancel at row 21 col 74
    with 1 down keep-tab-order overlay
      view-as dialog-box 
      side-labels no-underline three-d 
      size 147 by 22.94
      title gcTitlePrefix + 'Select persistent temp-table':T
      default-button btnOk
      cancel-button btnCancel.
  
  on window-close of frame fSelectPersistentTempTable
    apply 'end-error' to self.

  on 'value-changed':U of brPersistentProcedureBrowse in frame fSelectPersistentTempTable
  do:
    
    open query brPersistentTempTableBrowse
      for each ttPersistentTempTable
        where ttPersistentTempTable.ProcedureName = ttPersistentProcedure.ProcedureName
        no-lock
        use-index TableName.
    
  end. /* on 'value-changed':U of brPersistentProcedureBrowse in frame fSelectPersistentTempTable */
  
  on 'default-action':U of brPersistentTempTableBrowse in frame fSelectPersistentTempTable
    apply 'go':U to frame fSelectPersistentTempTable.
  
  /* Create list of all available temp-tables. */
  
  empty temp-table ttPersistentProcedure.
  empty temp-table ttPersistentTempTable.
  
  do i = 1 to Progress.Database.TempTableInfo:TempTableCount:
    
    /* Sometimes this invocation fails with an progress runtime error         */
    /* "Invalid value specified for Progress.Database.TempTableInfo:          */
    /* GetTableInfoByPosition (15246)" even though we queried TempTableCount  */
    /* just one line above. To avoid that we call GetTableInfoByPosition with */
    /* no-error and continue with the next entry in case of an error.         */
    
    Progress.Database.TempTableInfo:GetTableInfoByPosition
      (i, output hTempTable, output cProcedureName) no-error.
    
    if error-status:error then
      next.
    
    /* Ignore before tables. */
    
    if valid-handle(hTempTable:after-table) then
      next.
    
    /* Add procedure entry if needed. */
    
    if not can-find(first ttPersistentProcedure
                      where ttPersistentProcedure.ProcedureName = cProcedureName) then
    do:
      
      create bttPersistentProcedure.
      
      bttPersistentProcedure.ProcedureName = cProcedureName.
      
    end. /* if not can-find(first ttPersistentProcedure */
    
    /* Add table entry. */
    
    if not can-find(first bttPersistentTempTable
                      where bttPersistentTempTable.ProcedureName = cProcedureName
                        and bttPersistentTempTable.TableHandle   = hTempTable) then
    do:
      
      create bttPersistentTempTable.
      
      assign
        bttPersistentTempTable.ProcedureName = cProcedureName
        bttPersistentTempTable.TableHandle   = hTempTable
        bttPersistentTempTable.TableName     = hTempTable:name
        .
      
    end. /* if not can-find(first bttPersistentTempTable */
    
  end. /* do i = 1 to Progress.Database.TempTableInfo:TempTableCount */
  
  run qg_InitBrowse(browse brPersistentProcedureBrowse:handle).
  run qg_InitBrowse(browse brPersistentTempTableBrowse:handle).
  
  display unless-hidden
    brPersistentProcedureBrowse
    with frame fSelectPersistentTempTable
      in window {&WINDOW-NAME}. 
  
  open query brPersistentProcedureBrowse
    for each ttPersistentProcedure
      no-lock.
  
  if gcPersitentTTProcedure > '':U then
  do:
    
    find bttPersistentProcedure
      where bttPersistentProcedure.ProcedureName = gcPersitentTTProcedure
      no-error.
    
    if available bttPersistentProcedure then
      reposition brPersistentProcedureBrowse to rowid rowid(bttPersistentProcedure) no-error.
    
  end. /* if gcPersitentTTProcedure > '':U */
  
  apply 'value-changed':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.
  
  update unless-hidden
    brPersistentProcedureBrowse
    brPersistentTempTableBrowse
    btnOk
    btnCancel
    with frame fSelectPersistentTempTable
      in window {&WINDOW-NAME}. 
  
  if available ttPersistentTempTable then
  do:
    
    gcPersitentTTProcedure = ttPersistentTempTable.ProcedureName.
    
    run qg_AddTableHandle(ttPersistentTempTable.TableHandle,
                          ttPersistentTempTable.TableHandle,
                          no,
                          {&K_PERSISTENT_TT_DBNAME},
                          {&K_PERSISTENT_TT_PYSICALNAME}).
    
    if menu-item mi_OpenQueryWindowPersistentTT:checked in menu m_Options then
      run qg_ExecQuery({&K_PERSISTENT_TT_DBNAME},
                       ttPersistentTempTable.TableHandle:name,
                       substitute('for each &1':U,
                                  ttPersistentTempTable.TableHandle:name),
                       ?).
    
  end. /* if available ttPersistentTempTable */
  
&ENDIF

end procedure. /* qg_AddPersistentTempTable */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddRecentQuery hQueryWindow 
PROCEDURE qg_AddRecentQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Creeate a new menu item for the current query to the recent queries sub-   */
/* menu.                                                                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText     as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow   for temp-table ttQueryWindow.
define buffer bttRecentQueries for temp-table ttRecentQueries.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cQueryText         = bttQueryWindow.QueryTextEditorHandle:input-value.
  giRecentQueriesSeq = giRecentQueriesSeq + 1.

find first bttRecentQueries
  where bttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
    and bttRecentQueries.QueryText    = cQueryText
  no-error.

if available bttRecentQueries then
  bttRecentQueries.Order = giRecentQueriesSeq.

else
do:
  
  create bttRecentQueries.
  
  assign
    bttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
    bttRecentQueries.QueryText    = cQueryText
    bttRecentQueries.Order        = giRecentQueriesSeq
    bttRecentQueries.QueryLabel   = qg_cQueryLabel(cQueryText)
    .
  
end. /* if not can-find(first ttRecentQueries */

end procedure. /* qg_AddRecentQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddSessionTrigger hQueryWindow 
PROCEDURE qg_AddSessionTrigger :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add session trigger for given event and table/field.                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcTriggerEvent                 = Trigger event that should be added.       */
/* pcDatabaseName                 = Database of table for trigger event.      */
/* pcTableName                    = Table for trigger event.                  */
/* pcFieldName                    = Field for trigger event.                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcTriggerEvent as character no-undo.
define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.
define input parameter pcFieldName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cTriggerFileName as character no-undo.
define variable hProcedure       as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if pcFieldName = ? then
  pcFieldName = '':U.

/* Every session trigger may be defined only once. */

if can-find(first ttSessionTrigger
              where ttSessionTrigger.TriggerEvent = pcTriggerEvent
                and ttSessionTrigger.DatabaseName = pcDatabaseName
                and ttSessionTrigger.TableName    = pcTableName
                and ttSessionTrigger.FieldName    = pcFieldName) then
  leave.

/* Get next free filename. */

do while yes:

  assign
    giSessionTriggerSeq = giSessionTriggerSeq + 1.
    cTriggerFileName    = substitute('&1/qg_SessionTrigger_&2.p':U,
                                     trim(session:temp-directory, '/\':U),
                                     string(giSessionTriggerSeq)).
    file-info:file-name = cTriggerFileName
    .
  
  if file-info:full-pathname = ? then
    leave.
  
end. /* do while yes */

/* Write temporary procedure file. */

output stream strSeTrigger to value(cTriggerFileName).

put stream strSeTrigger unformatted
  'define variable ghQueryGenerator as handle    no-undo.':U skip
  substitute('ghQueryGenerator = handle(~'&1~':U).':U,
             string(this-procedure)) skip
  ' ':U skip
  .

case pcTriggerEvent:
  
  when 'create':U then
    put stream strSeTrigger unformatted
      substitute('on &1 of &2.&3':U,
                 pcTriggerEvent,
                 pcDatabaseName,
                 pcTableName) skip
      substitute('  run qg_SessionTriggerCreate in ghQueryGenerator (&1, (buffer &2.&3:handle)).':U,
                 string(giSessionTriggerSeq),
                 pcDatabaseName,
                 pcTableName) skip
      .
  
  when 'delete':U then
    put stream strSeTrigger unformatted
      substitute('on &1 of &2.&3':U,
                 pcTriggerEvent,
                 pcDatabaseName,
                 pcTableName) skip
      substitute('  run qg_SessionTriggerDelete in ghQueryGenerator (&1, (buffer &2.&3:handle)).':U,
                 string(giSessionTriggerSeq),
                 pcDatabaseName,
                 pcTableName) skip
      .
  
  when 'assign':U then
    put stream strSeTrigger unformatted
      substitute('define variable &3_old like &1.&2.&3 no-undo.':U,
                 pcDatabaseName,
                 pcTableName,
                 pcFieldName) skip
      ' ':U skip
      substitute('on &1 of &2.&3.&4 old value &4_old':U,
                 pcTriggerEvent,
                 pcDatabaseName,
                 pcTableName,
                 pcFieldName) skip
      substitute('  run qg_SessionTriggerAssign in ghQueryGenerator (&1, (buffer &2.&3:handle), string(&4_old)).':U,
                 string(giSessionTriggerSeq),
                 pcDatabaseName,
                 pcTableName,
                 pcFieldName) skip
      .

  when 'write':U then
    put stream strSeTrigger unformatted
      substitute('on &1 of &2.&3 old buffer &3_old':U,
                 pcTriggerEvent,
                 pcDatabaseName,
                 pcTableName) skip
      substitute('  run qg_SessionTriggerWrite in ghQueryGenerator (&1, (buffer &2.&3:handle), (buffer &3_old:handle)).':U,
                 string(giSessionTriggerSeq),
                 pcDatabaseName,
                 pcTableName) skip
      .
  
end case. /* case pcTriggerEvent */

output stream strSeTrigger close.

/* Run temporary procedure persistent and create temp-table entry. */

run value(cTriggerFileName) persistent set hProcedure no-error.

if not valid-handle(hProcedure) then
do:
  
  message /* code checked by mth 30.07.2015 */
    (if pcTriggerEvent = 'assign':U then
       substitute('The session trigger procedure for "&1" of "&2.&3.&4" could not be started!':T,
                  pcTriggerEvent,
                  pcDatabaseName,
                  pcTableName,
                  pcFieldName)
     else
       substitute('The session trigger procedure for "&1" of "&2.&3" could not be started!':T,
                  pcTriggerEvent,
                  pcDatabaseName,
                  pcTableName)) skip
    view-as alert-box
    error
    buttons ok.
  
  if cTriggerFileName > '':U then
    os-delete value(cTriggerFileName).
  
end. /* if not valid-handle(hProcedure) */

else
do:

  create bttSessionTrigger.
  
  assign
    bttSessionTrigger.Id              = giSessionTriggerSeq
    bttSessionTrigger.TriggerEvent    = pcTriggerEvent
    bttSessionTrigger.DatabaseName    = pcDatabaseName
    bttSessionTrigger.TableName       = pcTableName
    bttSessionTrigger.FieldName       = pcFieldName
    bttSessionTrigger.TriggerFileName = cTriggerFileName
    bttSessionTrigger.ProcedureHandle = hProcedure
    .
  
  validate bttSessionTrigger.
  
  if valid-handle(ghSessionTriggersWindow) then
  do:
    
    run qg_SessionTriggersOpenQuery.
    
    ghSessionTriggersBrowse:query:reposition-to-rowid(rowid(bttSessionTrigger)).
    
  end. /* if valid-handle(ghSessionTriggersWindow) */
  
end. /* else: if not valid-handle(hProcedure) */

catch oError as progress.lang.error:
  
  message /* code checked by mth 30.07.2015 */
    (if pcTriggerEvent = 'assign':U then
       substitute('The session trigger for "&1" of "&2.&3.&4" could not be added!':T,
                  pcTriggerEvent,
                  pcDatabaseName,
                  pcTableName,
                  pcFieldName)
     else
       substitute('The session trigger for "&1" of "&2.&3" could not be added!':T,
                  pcTriggerEvent,
                  pcDatabaseName,
                  pcTableName)) skip
    view-as alert-box
    error
    buttons ok.
  
  if valid-handle(hProcedure) then
    delete object hProcedure.
  
  if cTriggerFileName > '':U then
    os-delete value(cTriggerFileName).
  
  if available bttSessionTrigger then
    delete bttSessionTrigger.
  
  undo, throw oError.
  
end catch.

finally:
  
  output stream strSeTrigger close.
  
end finally.

end procedure. /* qg_AddSessionTrigger */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddSnapshot hQueryWindow 
PROCEDURE qg_AddSnapshot :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add snapshot for given database object (table, temp-table or dataset).     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phDBObject                     = Database object for that the snapshot     */
/*                                  should be added.                          */
/* pcSnapshotName                 = Name for the snapshot. For tables or      */
/*                                  temp-tables this will be the name of the  */
/*                                  temp-table clone. For datasets this will  */
/*                                  the database name.                        */
/* pcWhere                        = Where condition for the records that      */
/*                                  should be copied (not used for datasets). */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phDBObject     as handle    no-undo.
define input parameter pcSnapshotName as character no-undo.
define input parameter pcWhere        as character no-undo.

define variable cTimestamp            as character no-undo.
define variable cSnapshotName         as character no-undo.
define variable iNumReplacements      as integer   no-undo.
define variable cStatusText           as character no-undo.

define variable i           as integer   no-undo.
define variable hDBObject   as handle    no-undo.
define variable hTable      as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phDBObject) then
  leave.

cTimestamp = replace(string(time, 'HH:MM:SS':U),
                     ':':U,
                     '':U).

run qg_SubstituteChar(pcSnapshotName,
                      '#':U,
                      cTimestamp,
                      output cSnapshotName,
                      output iNumReplacements).

if phDBObject:type = 'DATASET':U then
do:
  
  if iNumReplacements > 0 then
  do:
    
    i = 0.
    
    do while can-find(first ttDatabase
                        where ttDatabase.DatabaseName = cSnapshotName):
      
      i = i + 1.
      
      run qg_SubstituteChar(pcSnapshotName,
                            '#':U,
                            substitute('&1-&2':U, cTimestamp, string(i)),
                            output cSnapshotName,
                            output iNumReplacements).
      
    end. /* do while can-find(first ttDatabase */
    
  end. /* if iNumReplacements > 0 */
  
  do i = 1 to phDBObject:num-buffers:
    
    hDBObject = phDBObject:get-buffer-handle(i).
    
    cStatusText = substitute('Adding snapshot &2 / &3':T,
                             cSnapshotName,
                             hDBObject:name).
    
    /* Create temp-table like parameter table. */
    
    run qg_CreateTableClone(hDBObject,
                            hDBObject:name,
                            ?,
                            cStatusText,
                            output hTable).
    
    /* Add snapshot. */
    
    run qg_AddTableHandle(hTable,
                          hDBObject,
                          yes,
                          cSnapshotName,
                          {&K_SNAPSHOT_PYSICALNAME}).

    
  end. /* do i = 1 to phDBObject:num-buffers */
  
end. /* if phDBObject:type = 'DATASET':U */

else
do:
  
  if iNumReplacements > 0 then
  do:
    
    i = 0.
    
    do while can-find(first ttTable
                        where ttTable.DatabaseName = {&K_SNAPSHOT_DBNAME}
                          and ttTable.TableName    = cSnapshotName):
        
        i = i + 1.
        
        run qg_SubstituteChar(pcSnapshotName,
                              '#':U,
                              substitute('&1-&2':U, cTimestamp, string(i)),
                              output cSnapshotName,
                              output iNumReplacements).
      
    end. /* do while can-find(first ttTable */
    
  end. /* if iNumReplacements > 0 */
  
  cStatusText = substitute('Adding snapshot &1':T, cSnapshotName).
  
  /* Create temp-table like parameter table. */
  
  run qg_CreateTableClone(phDBObject,
                          cSnapshotName,
                          pcWhere,
                          cStatusText,
                          output hTable).
  
  /* Add snapshot. */
  
  run qg_AddTableHandle(hTable,
                        phDBObject,
                        yes,
                        {&K_SNAPSHOT_DBNAME},
                        {&K_SNAPSHOT_PYSICALNAME}).
  
  if menu-item mi_OpenQueryWindowSnapshotTT:checked in menu m_Options then
    run qg_ExecQuery({&K_SNAPSHOT_DBNAME},
                     cSnapshotName,
                     substitute('for each &1':U, cSnapshotName),
                     ?).
  
end. /* else: if phDBObject:type = 'DATASET':U */

finally:
  
  hide frame fStatus.
  
end finally.

end procedure. /* qg_AddSnapshot */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableDetails hQueryWindow 
PROCEDURE qg_AddTableDetails :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Load additional information for the given table.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabaseName                 = Name of the database that contains the    */
/*                                  table.                                    */
/* pcTableName                    = Table name for which to load the          */
/*                                  additional information.                   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cBasisDBName      as character no-undo.
define variable cRepTableName     as character no-undo.

define variable cQueryText        as character no-undo.
define variable hQuery            as handle    no-undo.

define variable hRepTableBuffer   as handle    no-undo.
define variable hRepFieldBuffer   as handle    no-undo.
define variable hRepDomainBuffer  as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for temp-table ttDatabase.
define buffer bttTable    for temp-table ttTable.
define buffer bttField    for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

if not available bttDatabase then
  leave.

find first bttTable
  where bttTable.TableName = pcTableName
  no-error.

if not available bttTable then
  leave.

if bttDatabase.BasisDBName = '':U then
  leave.

else
  cBasisDBName = bttDatabase.BasisDBName.

if not connected(cBasisDBName) then
  leave.

/* Add indices if necessary. */

if not can-find(first ttIndex
                  where ttIndex.DatabaseName = bttTable.DatabaseName
                    and ttIndex.TableName    = bttTable.TableName) then
  run qg_AddIndices(bttTable.DatabaseName, bttTable.TableName).

/* Add proALPHA repository information. */

cRepTableName = pcTableName.

if    bttDatabase.TempDB
  and cRepTableName begins 'TD_':U then
  overlay(cRepTableName, 1, 3) = 'TT_':U. 

create buffer hRepTableBuffer for table substitute('&1.DRC_Table':U,
                                                   cBasisDBName) no-error.

if not valid-handle(hRepTableBuffer) then
  leave.

hRepTableBuffer:find-first(substitute('where DRC_Table.DRC_Table_ID = "&1"':U,
                                      cRepTableName)) no-error.

if not hRepTableBuffer:available then
  leave.

create query hQuery.

create buffer hRepFieldBuffer  for table substitute('&1.DRC_Field':U, cBasisDBName) no-error.
create buffer hRepDomainBuffer for table substitute('&1.DRC_Domain':U, cBasisDBName) no-error.

hQuery:set-buffers(hRepFieldBuffer,
                   hRepDomainBuffer).

assign
  bttTable.InternalIdentifier = hRepTableBuffer::InternalIdentifier
  bttTable.CompanyInclude     = hRepTableBuffer::CompanyInclude
  bttTable.KeyInclude         = hRepTableBuffer::KeyInclude
  cQueryText                  =            'for each DRC_Field':U
                                + '~n':U + '  where DRC_Field.DRC_Table_Obj = "&1"':U
                                + '~n':U + '  no-lock,':U
                                + '~n':U + 'first DRC_Domain left outer-join':U
                                + '~n':U + '  where DRC_Domain.DRC_Domain_Obj = DRC_Field.DRC_Domain_Obj':U
                                + '~n':U + '  no-lock':U
  cQueryText                  = substitute(cQueryText,
                                           hRepTableBuffer::DRC_Table_Obj)
  .

hQuery:query-prepare(cQueryText).
hQuery:query-open().

hQuery:get-first().

do while not hQuery:query-off-end:
  
  find first bttField
    where bttField.DatabaseName = pcDatabaseName
      and bttField.TableName    = pcTableName
      and bttField.FieldName    = hRepFieldBuffer::DRC_Field_ID
    no-error.
  
  if available bttField then
  do:
    
    bttField.Domain = (if hRepDomainBuffer:available then
                         hRepDomainBuffer::DRC_Domain_ID
                       else
                         '':U).
    
  end. /* if available bttField */
  
  hQuery:get-next().
  
end. /* do while not hQuery:query-off-end */

bttTable.DetailsLoaded = yes.

finally:
  
  if valid-handle(hQuery) then
    delete object hQuery.
  
  if valid-handle(hRepDomainBuffer) then
    delete object hRepDomainBuffer.
  
  if valid-handle(hRepFieldBuffer) then
    delete object hRepFieldBuffer.
  
  if valid-handle(hRepTableBuffer) then
    delete object hRepTableBuffer.

end finally.
  
end procedure. /* qg_AddTableDetails */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableHandle hQueryWindow 
PROCEDURE qg_AddTableHandle :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Create a temp-table like given table/buffer handle, copy all its contents  */
/* and add its schema information to the cache.                               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phTable                        = Table for wich a snapshot should be cre-  */
/*                                  ated.                                     */
/* pcDatabaseName                 = Database name for the table.              */
/* pcPhysicalName                 = Physical name for the table.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phTable         as handle    no-undo.
define input parameter phOriginalTable as handle    no-undo.
define input parameter plSnapshot      as logical   no-undo.
define input parameter pcDatabaseName  as character no-undo.
define input parameter pcPhysicalName  as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer    as handle    no-undo.
define variable hField     as handle    no-undo.

define variable i          as integer   no-undo.
define variable j          as integer   no-undo.

define variable cIndexInfo as character no-undo.

define variable lNewDB     as logical   no-undo.
define variable rCurrentDB as rowid     no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase   for temp-table ttDatabase.
define buffer bttTable      for temp-table ttTable.
define buffer bttField      for temp-table ttField.
define buffer bttIndex      for temp-table ttIndex.
define buffer bttIndexField for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phTable) then
  leave.

/* Add database. */

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

if not available bttDatabase then
do:
  
  lNewDB = yes.
  
  create bttDatabase.
  
  assign
    bttDatabase.DatabaseName    = pcDatabaseName
    bttDatabase.PhysicalName    = pcPhysicalName
    bttDatabase.DirectoryName   = '':U
    bttDatabase.TempDB          = yes
    bttDatabase.BasisDB         = no
    bttDatabase.BasisDBName     = '':U
    bttDatabase.PhysicalDB      = no
    .
  
  case bttDatabase.DatabaseName:
    
    when {&K_PERSISTENT_TT_PYSICALNAME} then
      bttDatabase.DisplayPriority = 2000.
    
    when {&K_SNAPSHOT_DBNAME} then
      bttDatabase.DisplayPriority = 3000.
    
    otherwise 
      bttDatabase.DisplayPriority = 4000.
    
  end case. /* bttDatabase.DatabaseName */
  
  validate bttDatabase.
  
end. /* if not available bttDatabase */

phTable:private-data = qg_cParamListWriteCharacter(phTable:private-data,
                                                   'DatabaseName':U,
                                                   pcDatabaseName,
                                                   ',':U).

/* Add table. */

find bttTable
  where bttTable.DatabaseName = bttDatabase.DatabaseName
    and bttTable.TableName    = phTable:name
  no-error.

if available bttTable then
  run qg_RemoveTable(bttTable.DatabaseName,
                     bttTable.TableName).

create bttTable.

assign
  bttTable.DatabaseName        = bttDatabase.DatabaseName
  bttTable.TableName           = phTable:name
  bttTable.DetailsLoaded       = yes
  bttTable.PhysicalTable       = no
  bttTable.TableHandle         = phTable
  bttTable.OriginalTableHandle = phOriginalTable
  bttTable.Snapshot            = plSnapshot
  .

validate bttTable.

hBuffer = phTable:default-buffer-handle.

/* Add fields. */
do i = 1 to hBuffer:num-fields:
  
  hField = hBuffer:buffer-field(i).
  
  create bttField.
  
  assign
    bttField.DatabaseName      = bttTable.DatabaseName
    bttField.TableName         = bttTable.TableName
    bttField.FieldName         = hField:name
    bttField.DataType          = hField:data-type
    bttField.FieldFormat       = hField:format
    bttField.FieldExtent       = hField:extent
    bttField.FieldDecimals     = (if bttField.DataType = 'DECIMAL':U then
                                    hField:decimals
                                  else
                                    ?)
    bttField.FieldInitialValue = trim(hField:initial)
    bttField.FieldLabel        = hField:label
    bttField.FieldColumnLabel  = hField:column-label
    bttField.IsMandatory       = hField:mandatory
    bttField.FieldViewAs       = hField:view-as
    .
  
  validate bttField.
  
end. /* do i = 1 to hBuffer:num-fields */

/* Add Indices. */
i = 1.

do while hBuffer:index-information(i) <> ?:

  cIndexInfo = hBuffer:index-information(i).
  
  create bttIndex.
  
  assign
    bttIndex.DatabaseName = bttTable.DatabaseName
    bttIndex.TableName    = bttTable.TableName
    bttIndex.IndexName    = entry(1, cIndexInfo)
    bttIndex.IsUnique     = logical(entry(2, cIndexInfo), '1/0':U)
    bttIndex.IsPrimary    = logical(entry(3, cIndexInfo), '1/0':U)
    .
  
  validate bttIndex.
  
  /* Add index fields. */
  
  do j = 5 to num-entries(cIndexInfo) by 2:
    
    if entry(j, cIndexInfo) = '':U then
      next.
    
    create bttIndexField.
    
    assign
      bttIndexField.DatabaseName  = bttIndex.DatabaseName
      bttIndexField.TableName     = bttIndex.TableName
      bttIndexField.IndexName     = bttIndex.IndexName
      bttIndexField.IndexSequence = j - 5
      bttIndexField.FieldName     = entry(j, cIndexInfo)
      bttIndexField.SortAscending = logical(entry(j + 1, cIndexInfo), '0/1':U)
      .  
    
    validate bttIndexField.
    
    assign
      bttIndex.IndexFieldList = substitute('&1,&2':U,
                                           bttIndex.IndexFieldList,
                                           bttIndexField.FieldName)
      bttIndex.IndexFields    = substitute('&1 &2&3':U,
                                           bttIndex.IndexFields,
                                           string(bttIndexField.SortAscending, '+/-':U),
                                           bttIndexField.FieldName)
      .
    
    validate bttIndex.
    
  end. /* do iFieldCounter = 5 to num-entries(cIndexInfo) by 2 */
  
  assign
    bttIndex.IndexFieldList = trim(bttIndex.IndexFieldList, ',':U)
    bttIndex.IndexFields    = trim(bttIndex.IndexFields)
    .
  
  validate bttIndex.
  
  i = i + 1.

end. /* do while phBuffer:index-information(i) <> ? */

/* Refresh and reposition database and table browse. */

if lNewDB then
do:

  rCurrentDB = rowid(ttDatabase).

  {&OPEN-QUERY-brDatabase}

  if rCurrentDB <> ? then
    reposition brDatabase to rowid rCurrentDB no-error.
  
end. /* if lNewDB */

if    available ttDatabase
  and ttDatabase.DatabaseName = pcDatabaseName then
  apply 'value-changed':U to browse brDatabase.

process events.

end procedure. /* qg_AddTableHandle */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTables hQueryWindow 
PROCEDURE qg_AddTables :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add Tables of given Database to cache.                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = Database that contains the tables that    */
/*                                  should be added.                          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cTableQueryText        as character no-undo.
define variable cFieldQueryText        as character no-undo.
define variable hTableQuery            as handle    no-undo.
define variable hFieldQuery            as handle    no-undo.

define variable cTableName             as character no-undo.

define variable hFileBuffer            as handle    no-undo.
define variable hFieldBuffer           as handle    no-undo.

define variable cTriggerQueryText      as character no-undo.
define variable hTriggerQuery          as handle    no-undo.
define variable cTriggerEvent          as character no-undo.

define variable hFileTrigBuffer        as handle    no-undo.


/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for temp-table ttDatabase.
define buffer bttTable    for temp-table ttTable.
define buffer bttField    for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

display unless-hidden
  substitute('Loading database &1 ...':T,
             pcDatabase)
    @ gcStatusText60
  with frame fStatus
    no-labels
    overlay
    color messages
    centered
    view-as dialog-box
    width 65
    .
process events.

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabase
  no-error.

if not available bttDatabase then
  leave.

create query hTableQuery.
create query hTriggerQuery.
create query hFieldQuery.

assign
  hTableQuery:forward-only   = yes
  hTriggerQuery:forward-only = yes
  hFieldQuery:forward-only   = yes
  .

create buffer hFileBuffer     for table substitute('&1._File':U, pcDatabase).
create buffer hFileTrigBuffer for table substitute('&1._File-Trig':U, pcDatabase).
create buffer hFieldBuffer    for table substitute('&1._Field':U, pcDatabase).

hTableQuery:set-buffers(hFileBuffer).
hTriggerQuery:set-buffers(hFileTrigBuffer).
hFieldQuery:set-buffers(hFieldBuffer).

/* For some odd reason the queries are much faster, when no fields option is  */
/* present - thus the fields option has been removed. Joins somehow perform   */
/* very bad on dynamic queries as well. For this reason a separate query is   */
/* used for every table.                                                      */

assign
  cTableQueryText   =            'for each _File':U
                      + '~n':U + '  no-lock':U
  cFieldQueryText   =            'for each _Field':U
                      + '~n':U + '  where _Field._File-recid = &1':U
                      + '~n':U + '  no-lock':U
  cTriggerQueryText =            'for each _File-Trig':U
                      + '~n':U + '  where _File-Trig._File-Recid = &1':U
                      + '~n':U + '  no-lock':U
  .

hTableQuery:query-prepare(cTableQueryText).
hTableQuery:query-open().

hTableQuery:get-first().

do while not hTableQuery:query-off-end:
  
  create bttTable.
  
  assign
    bttTable.DatabaseName  = pcDatabase
    bttTable.TableName     = hFileBuffer::_File-Name
    cTableName             = bttTable.TableName
    bttTable.FillInclude   = substitute('&1.fld':U,
                                        hFileBuffer::_Dump-name)
    bttTable.PhysicalTable = yes
    .
  
  hTriggerQuery:query-prepare(substitute(cTriggerQueryText, string(hFileBuffer:recid))).
  hTriggerQuery:query-open().
  
  hTriggerQuery:get-first().
  
  do while not hTriggerQuery:query-off-end:
    
    cTriggerEvent = hFileTrigBuffer::_Event.
    
    case cTriggerEvent:
      
      when 'CREATE':U then
        assign
          bttTable.CreateTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.CreateTriggerProcName = substring(bttTable.CreateTrigger,
                                                     max(r-index(bttTable.CreateTrigger, '/':U),
                                                         r-index(bttTable.CreateTrigger, '\':U)) + 1)
          .
      
      when 'WRITE':U then
        assign
          bttTable.WriteTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.WriteTriggerProcName = substring(bttTable.WriteTrigger,
                                                     max(r-index(bttTable.WriteTrigger, '/':U),
                                                         r-index(bttTable.WriteTrigger, '\':U)) + 1)
          .
      
      when 'DELETE':U then
        assign
          bttTable.DeleteTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.DeleteTriggerProcName = substring(bttTable.DeleteTrigger,
                                                     max(r-index(bttTable.DeleteTrigger, '/':U),
                                                         r-index(bttTable.DeleteTrigger, '\':U)) + 1)
          .
      
    end case. /* case hFileTrigBuffer::_Event */
    
    hTriggerQuery:get-next().
    
  end. /* do while not hTriggerQuery:query-off-end */
  
  hFieldQuery:query-prepare(substitute(cFieldQueryText, string(hFileBuffer:recid))).
  hFieldQuery:query-open().
  
  hFieldQuery:get-first().
  
  do while not hFieldQuery:query-off-end:
    
    create bttField.
    
    assign
      bttField.DatabaseName      = pcDatabase
      bttField.TableName         = hFileBuffer::_File-Name
      bttField.FieldName         = hFieldBuffer::_Field-Name
      bttField.DataType          = hFieldBuffer::_Data-Type
      bttField.FieldExtent       = hFieldBuffer::_Extent
      bttField.FieldInitialValue = hFieldBuffer::_Initial
      bttField.FieldLabel        = (if hFieldBuffer::_Label = ? then
                                      '':U
                                    else
                                      hFieldBuffer::_Label)
      bttField.FieldColumnLabel  = (if hFieldBuffer::_Col-label = ? then
                                      '':U
                                    else
                                      hFieldBuffer::_Col-label)
      bttField.FieldDecimals     = hFieldBuffer::_Decimals
      bttField.FieldFormat       = hFieldBuffer::_Format
      bttField.IsMandatory       = hFieldBuffer::_Mandatory
      bttField.FieldViewAs       = hFieldBuffer::_View-As
      .
    
    hFieldQuery:get-next().
    
  end. /* do while not hFieldQuery:query-off-end */
  
  hTableQuery:get-next().
  
end. /* do while not hTableQuery:query-off-end */

finally:
  
  if valid-handle(hTableQuery) then
    delete object hTableQuery.
  
  if valid-handle (hFileBuffer) then
    delete object hFileBuffer.
  
  if valid-handle(hTriggerQuery) then
    delete object hTriggerQuery.
  
  if valid-handle (hFileTrigBuffer) then
    delete object hFileTrigBuffer.
  
  if valid-handle(hFieldQuery) then
    delete object hFieldQuery.
  
  if valid-handle (hFieldBuffer) then
    delete object hFieldBuffer.
  
end finally.
  
end procedure. /* qg_AddTables */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableSnapshot hQueryWindow 
PROCEDURE qg_AddTableSnapshot :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Shows a snapshot name dialog and creates the snapshot.                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBuffer                       = Buffer handle of the table for which a    */
/*                                  Snapshot should be created.               */
/* pcWhere                        = Where condition for the records that      */
/*                                  should be copied.                         */
/* phParentWindow                 = Parent window for the dialog.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBuffer       as handle    no-undo.
define input parameter pcWhere        as character no-undo.
define input parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cSnapshotName as character no-undo
  format 'x(32)':U
  view-as fill-in
  size 65 by 1.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fSnapshot
    'Please enter snapshot name:':T view-as text size 45 by 1 at col 3 row 1.5
    cSnapshotName at row 2.5 col 3 no-label
    btnOk at row 4.5 col 16
    btnCancel at row 4.5 col 36
  with 1 down keep-tab-order overlay
    view-as dialog-box
    side-labels no-underline three-d 
    size 71 by 6.44
    title gcTitlePrefix + 'Add snapshot':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSnapshot
  apply 'end-error' to self.
  
cSnapshotName = substitute('&1_&2':U,
                           phBuffer:table,
                           replace(string(time, 'HH:MM:SS':U),
                                   ':':U,
                                   '':U)).

update unless-hidden
  cSnapshotName
  btnOk
  btnCancel
  with frame fSnapshot
    in window phParentWindow.

run qg_AddSnapshot(phBuffer,
                   cSnapshotName,
                   pcWhere).

end procedure. /* qg_AddTableSnapshot */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AdjustWidgetsSizeAndPos hQueryWindow 
PROCEDURE qg_AdjustWidgetsSizeAndPos :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Adjust widget size and position.                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWidget                       = Widget handle.                            */
/* pdWidthDelta                   = Width delta.                              */
/* pdHeightDelta                  = Height delta.                             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWidget      as handle    no-undo.
define input parameter pdWidthDelta  as decimal   no-undo.
define input parameter pdHeightDelta as decimal   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hChild            as handle    no-undo.

define variable dOriginalCol      as decimal   no-undo.
define variable dOriginalRow      as decimal   no-undo.
define variable dOriginalWidth    as decimal   no-undo.
define variable dOriginalHeight   as decimal   no-undo.

define variable dColFactor        as decimal   no-undo.
define variable dRowFactor        as decimal   no-undo.
define variable dWidthFactor      as decimal   no-undo.
define variable dHeightFactor     as decimal   no-undo.

define variable lSlimModeWidget   as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if can-query(phWidget, 'private-data':U) then
do:
  
  assign
    dOriginalCol    = qg_dParamListReadValue(phWidget:private-data, 'OriginalCol':U, ',':U)
    dOriginalRow    = qg_dParamListReadValue(phWidget:private-data, 'OriginalRow':U, ',':U)
    dOriginalWidth  = qg_dParamListReadValue(phWidget:private-data, 'OriginalWidth':U, ',':U)
    dOriginalHeight = qg_dParamListReadValue(phWidget:private-data, 'OriginalHeight':U, ',':U)
    dColFactor      = qg_dParamListReadValue(phWidget:private-data, 'ColFactor':U, ',':U)
    dRowFactor      = qg_dParamListReadValue(phWidget:private-data, 'RowFactor':U, ',':U)
    dWidthFactor    = qg_dParamListReadValue(phWidget:private-data, 'WidthFactor':U, ',':U)
    dHeightFactor   = qg_dParamListReadValue(phWidget:private-data, 'HeightFactor':U, ',':U)
    .
  
  if glSlimMode then
  do:
    
    lSlimModeWidget = qg_lParamListReadValue(phWidget:private-data, 'SlimModeWidget':U, ',':U).
    
    if lSlimModeWidget then
      assign
        dColFactor   = dColFactor * 2
        dWidthFactor = dWidthFactor * 2
        .
    
    else
      if not phWidget:name = ? then
        assign
          dOriginalCol = 1
          dOriginalRow = 1
          dColFactor   = 0
          dRowFactor   = 0
          .
    
  end. /* if glSlimMode */
  
  /* Adjust widget size and position. */
  
  assign
    phWidget:col          = dOriginalCol + (pdWidthDelta * dColFactor)
        when can-set(phWidget, 'col':U)
    phWidget:row          = dOriginalRow + (pdHeightDelta * dRowFactor)
        when can-set(phWidget, 'row':U)
    phWidget:width-chars  = dOriginalWidth + (pdWidthDelta * dWidthFactor)
        when can-set(phWidget, 'width-chars':U)
    phWidget:height-chars = dOriginalHeight + (pdHeightDelta * dHeightFactor)
        when can-set(phWidget, 'height-chars':U)
    .
  
  /* Adjust side label position. */
  
  if    can-query(phWidget, 'side-label-handle':U)
    and valid-handle(phWidget:side-label-handle)
    and can-query(phWidget:side-label-handle, 'private-data':U) then
  do:
    
    assign
      dOriginalCol                   = qg_dParamListReadValue(phWidget:side-label-handle:private-data, 'OriginalCol':U, ',':U)
      dOriginalRow                   = qg_dParamListReadValue(phWidget:side-label-handle:private-data, 'OriginalRow':U, ',':U)
      phWidget:side-label-handle:col = dOriginalCol + (pdWidthDelta * dColFactor)
          when can-set(phWidget:side-label-handle, 'col':U)
      phWidget:side-label-handle:row = dOriginalRow + (pdHeightDelta * dRowFactor)
          when can-set(phWidget:side-label-handle, 'row':U)
      .
      
    end. /*  */
    
end. /* if can-query(phWidget, 'private-data':U) */
  
/* Adjust children size and position recursively. */

if    can-query(phWidget, 'first-child':U)
  and can-query(phWidget, 'next-sibling':U) then
do:
  
  hChild = phWidget:first-child.
  
  do while valid-handle(hChild):
    
    run qg_AdjustWidgetsSizeAndPos(hChild,
                                   pdWidthDelta,
                                   pdHeightDelta).
    
    hChild = hChild:next-sibling.
    
  end. /* do while valid-handle */
  
end. /* if    can-query(phWidget, 'first-child':U) */

assign
  phWidget:virtual-width-chars  = phWidget:width-chars
    when can-set(phWidget, 'virtual-width-chars':U)
  phWidget:virtual-height-chars = phWidget:height-chars
      when can-set(phWidget, 'virtual-height-chars':U)
  .

end procedure. /* qg_AdjustWidgetsSizeAndPos */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CloseInvalidQueryWindows hQueryWindow 
PROCEDURE qg_CloseInvalidQueryWindows :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Close all query windows without buffers (because its db has been dis-      */
/* connected or the temp-table has been deletetd).                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i       as integer   no-undo.
define variable hQuery  as handle    no-undo.
define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase    for temp-table ttDatabase.
define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryWindow
  on error undo, throw:
  
  hQuery = bttQueryWindow.QueryHandle.
  
  if   not valid-handle(hQuery)
    or hQuery:num-buffers = 0 then
    apply 'window-close':U to bttQueryWindow.WindowHandle.
  
  else
  do:
    
    do i = 1 to hQuery:num-buffers:
      
      hBuffer = hQuery:get-buffer-handle(i).
      
      find bttDatabase
        where bttDatabase.DatabaseName = hBuffer:dbname
        no-error.
      
      if    available(bttDatabase)
        and bttDatabase.PhysicalDB
        and not can-find(first ttTable
                           where ttTable.DatabaseName = bttDatabase.DatabaseName) then
        run qg_AddTables(bttDatabase.DatabaseName).

      if    not can-find(first ttTable
                           where ttTable.DatabaseName = hBuffer:dbname
                             and ttTable.TableName    = hBuffer:table)
        and not can-find(first ttTable
                           where ttTable.TableHandle = hBuffer:table-handle) then
      do:
        
        apply 'window-close':U to bttQueryWindow.WindowHandle.
        leave.
        
      end. /* if    not can-find(first ttTable ... */
      
    end. /* do i = 1 to hQuery:num-buffers */
    
  end. /* if   not valid-handle(hQuery) */
  
end. /* for each bttQueryWindow */

end procedure. /* qg_CloseInvalidQueryWindows */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CloseWindow hQueryWindow 
PROCEDURE qg_CloseWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Close given window.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* This procedure is inteded to be used as a persistent trigger procedure     */
/* for dynamically created windows.                                           */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window that should be closed.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(phWindow) then
  apply 'window-close':U to phWindow.

end procedure. /* qg_CloseWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ConfirmRecordChanges hQueryWindow 
PROCEDURE qg_ConfirmRecordChanges :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show a confirmation dialog to confirm any changes to a record.             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcTitle                        = Title string for the dialog.              */
/* pcText                         = Text to display on the dialog.            */
/* phOldBuffer                    = Buffer handle of the buffer before any    */
/*                                  changes.                                  */
/* phNewBuffer                    = Buffer handle of the buffer that contains */
/*                                  the changes.                              */
/* phParentWindow                 = Parent window to show the dialog.         */
/* oplOk                          = Output flag. True if the user clicked the */
/*                                  ok button - otherwise false.              */
/* oplDisableTriggers             = Output flag. True if the user chose to    */
/*                                  disable the triggers - otherwise false.   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter pcTitle             as character no-undo.
define input        parameter pcText              as character no-undo.
define input        parameter phOldBuffer         as handle    no-undo.
define input        parameter phNewBuffer         as handle    no-undo.
define input        parameter plCanEnableTriggers as logical   no-undo.
define input        parameter plRawValues         as logical   no-undo.
define input        parameter phParentWindow      as handle    no-undo.

define       output parameter oplOk               as logical   no-undo.
define input-output parameter ioplDisableTriggers as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                 as integer   no-undo.

define variable hOldField         as handle    no-undo.
define variable clOldFieldValue   as longchar  no-undo.
define variable hNewField         as handle    no-undo.
define variable clNewFieldValue   as longchar  no-undo.
define variable cFieldList        as character no-undo.
define variable cFieldName        as character no-undo.
define variable iIndex            as integer   no-undo.

define variable cText as character no-undo
  format 'x(150)':U
  view-as text
  size 156 by 1.

define query brRecordBrowse
  for ttRecordfieldChanges
  scrolling.

define browse brRecordBrowse
  query brRecordBrowse no-lock
    display
      ttRecordfieldChanges.FieldName
      ttRecordfieldChanges.FieldExtent
      ttRecordfieldChanges.OldDisplayValue
      ttRecordfieldChanges.CurrentDisplayValue
      with no-assign size 156 by 18.

define variable lDisableTriggers as logical no-undo
  format 'yes/no':U
  label 'disable triggers':T
  view-as toggle-box
  size 50 by 1.

define rectangle reDisableTriggers
  no-fill
  edge-pixels 2
  graphic-edge
  size 156 by 2
  .

define button btnOk
  label 'Save':T4
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T6
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordfieldChanges for temp-table ttRecordfieldChanges.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fConfirmRecordChanges
  cText at row 1.5 col 3 no-label
  brRecordBrowse at row 3 col 3
  reDisableTriggers at row 21.5 col 3
  lDisableTriggers at row 22 col 5
  btnOk at row 24.5 col 61
  btnCancel at row 24.5 col 81
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 161 by 26.44
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fConfirmRecordChanges
  apply 'end-error' to self.

cFieldList = qg_cBufferCompare(phOldBuffer, phNewBuffer).

if num-entries(cFieldList) = 0 then
  leave.

empty temp-table ttRecordfieldChanges.

do i = 1 to num-entries(cFieldList):
  
  assign
    cFieldName = qg_cExtractFieldName(entry(i, cFieldList))
    iIndex     = qg_iExtractIndex(entry(i, cFieldList))
    hOldField  = phOldBuffer:buffer-field(cFieldName)
    hNewField  = phNewBuffer:buffer-field(cFieldName)
    .
  
  create bttRecordfieldChanges.
  
  assign
    bttRecordfieldChanges.FieldName   = cFieldName
    bttRecordfieldChanges.FieldExtent = iIndex
    .
    
  if lookup(hNewField:data-type, 'CLOB,BLOB':U) = 0 then
  do:
    
    if plRawValues  then
      assign
        bttRecordfieldChanges.OldDisplayValue     = hOldField:buffer-value(iIndex)
        bttRecordfieldChanges.CurrentDisplayValue = hNewField:buffer-value(iIndex)
        .
    
    else
      assign
        bttRecordfieldChanges.OldDisplayValue     = hOldField:string-value(iIndex)
        bttRecordfieldChanges.CurrentDisplayValue = hNewField:string-value(iIndex)
        .
    
  end. /* if lookup(hNewField:data-type, 'CLOB,BLOB':U) = 0 */
  
  else
  do:
    
    copy-lob hOldField:buffer-value(iIndex) to clOldFieldValue.
    copy-lob hNewField:buffer-value(iIndex) to clNewFieldValue.
      
    assign
      bttRecordfieldChanges.OldDisplayValue     = substring(clOldFieldValue, 1, 255)
      bttRecordfieldChanges.CurrentDisplayValue = substring(clnewFieldValue, 1, 255)
      .
    
  end. /* else: if lookup(hNewField:data-type, 'CLOB,BLOB':U) = 0 */
  
  validate bttRecordfieldChanges.
  
end. /* do i = 1 to num-entries(cFieldList) */

run qg_InitBrowse(browse brRecordBrowse:handle).

assign
  cText                                                                    = pcText
  frame fConfirmRecordChanges:title                                        = gcTitlePrefix + pcTitle
  lDisableTriggers                                                         = ioplDisableTriggers
  brRecordBrowse:num-locked-columns in frame fConfirmRecordChanges         = 3
  ttRecordfieldChanges.OldDisplayValue:width     in browse brRecordBrowse  = 50
  ttRecordfieldChanges.CurrentDisplayValue:width in browse brRecordBrowse  = 50
  .

if    lDisableTriggers
  and not plCanEnableTriggers then
  assign
    lDisableTriggers:bgcolor  in frame fConfirmRecordChanges = 12
    reDisableTriggers:filled  in frame fConfirmRecordChanges = yes
    reDisableTriggers:bgcolor in frame fConfirmRecordChanges = 12
    .


open query brRecordBrowse
  for each ttRecordFieldChanges
    no-lock.

display unless-hidden
  lDisableTriggers
  with frame fConfirmRecordChanges
    in window phParentWindow. 

update unless-hidden
  cText
  brRecordBrowse
  lDisableTriggers when plCanEnableTriggers
  btnOk
  btnCancel
  with frame fConfirmRecordChanges
    in window phParentWindow. 

assign
  oplOk               = yes
  ioplDisableTriggers = input frame fConfirmRecordChanges lDisableTriggers
  .

end procedure. /* qg_ConfirmRecordChanges */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ConfirmTriggerChanges hQueryWindow 
PROCEDURE qg_ConfirmTriggerChanges :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show a confirmation dialog to confirm deletion to a record.                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcTitle                        = Title string for the dialog.              */
/* pcText                         = Text to display on the dialog.            */
/* plCanEnableTriggers            = If false the "disable triggers" toggle    */
/*                                  box is disabled.                          */
/* phParentWindow                 = Parent window to show the dialog.         */
/* oplOk                          = Output flag. True if the user clicked the */
/*                                  ok button - otherwise false.              */
/* ioplDisableTriggers            = Output flag. True if the user chose to    */
/*                                  disable the triggers - otherwise false.   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter pcTitle             as character no-undo.
define input        parameter pcText              as character no-undo.
define input        parameter pcButtonLabel       as character no-undo.
define input        parameter plCanEnableTriggers as logical   no-undo.
define input        parameter phParentWindow      as handle    no-undo.

define       output parameter oplOk               as logical   no-undo.
define input-output parameter ioplDisableTriggers as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cText as character no-undo
  format 'x(100)':U
  view-as text
  size 100 by 1.

define variable lDisableTriggers as logical no-undo
  format 'yes/no':U
  label 'disable triggers':T
  view-as toggle-box
  size 20 by 1.

define rectangle reDisableTriggers
  no-fill
  edge-pixels 2
  graphic-edge
  size 105 by 2
  .

define button btnOk
  label 'Ok':T6
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T6
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fConfirmTriggerChanges
  cText at row 1.5 col 3 no-label
  reDisableTriggers at row 3 col 3
  lDisableTriggers at row 3.5 col 5
  btnOk at row 6 col 36
  btnCancel at row 6 col 56
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 110 by 7.94
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fConfirmTriggerChanges
  apply 'end-error' to self.

assign
  frame fConfirmTriggerChanges:title          = gcTitlePrefix + pcTitle
  lDisableTriggers                            = ioplDisableTriggers
  btnOk:label in frame fConfirmTriggerChanges = pcButtonLabel
  cText                                       = pcText
  .

if    lDisableTriggers
  and not plCanEnableTriggers then
  assign
    lDisableTriggers:bgcolor  in frame fConfirmTriggerChanges = 12
    reDisableTriggers:filled  in frame fConfirmTriggerChanges = yes
    reDisableTriggers:bgcolor in frame fConfirmTriggerChanges = 12
    .

display unless-hidden
  lDisableTriggers
  with frame fConfirmTriggerChanges
    in window phParentWindow. 

update unless-hidden
  cText
  lDisableTriggers when plCanEnableTriggers
  btnOk
  btnCancel
  with frame fConfirmTriggerChanges
    in window phParentWindow. 

assign
  oplOk               = yes
  ioplDisableTriggers = input frame fConfirmTriggerChanges lDisableTriggers
  .

end procedure. /* qg_ConfirmTriggerChanges */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CopyFieldValue hQueryWindow 
PROCEDURE qg_CopyFieldValue :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy given buffer field value.                                             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBuffer                       = Buffer that contains the record and field */
/*                                  that should be copied to clipboard.       */
/* pcFieldName                    = Field name of the field that should be    */
/*                                  copied to clipboard.                      */
/* piIndex                        = Extent index of the Field.                */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBuffer    as handle    no-undo.
define input parameter pcFieldName as character no-undo.
define input parameter piIndex     as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    valid-handle(phBuffer)
  and phBuffer:available then
  clipboard:value = phBuffer:buffer-field(pcFieldName):buffer-value(piIndex).

end procedure. /* qg_CopyFieldValue */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateBuffer hQueryWindow 
PROCEDURE qg_CreateBuffer :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Create a record for given buffer.                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBuffer                       = Buffer for the new record.                */
/* plDisableTriggers              = Flag to indicate if create triggers       */
/*                                  should be disabled.                       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBuffer          as handle    no-undo.
define input parameter plDisableTriggers as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if plDisableTriggers then
  phBuffer:disable-load-triggers(no).

phBuffer:buffer-create().

end procedure. /* qg_CreateBuffer */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateBufferButtonMenu hQueryWindow 
PROCEDURE qg_CreateBufferButtonMenu :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Create popup menu for buffer name buttons.                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phButton                       = Button handle.                            */
/* pcBufferPattern                = Buffer pattern for this button.           */
/* pcLabelPattern                 = Buffer label pattern for this button.     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phButton        as handle    no-undo.

define input parameter pcBufferPattern as character no-undo.
define input parameter pcLabelPattern  as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i     as integer   no-undo.
define variable hTemp as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create menu hTemp
  assign
    name       = substitute('m_&1PopupMenu':U, phButton:name)
    popup-only = yes
    sensitive  = yes
    .

phButton:popup-menu = hTemp.

do i = 1 to {&K_NUM_BUFFER_PATTERN_INDICES}:
  
  create menu-item hTemp
    assign
      name         = substitute('mi_&1_&2':U, phButton:name, string(i))
      parent       = phButton:popup-menu
      label        = qg_cSubstituteChar(pcLabelPattern, '#':U, string(i))
      sensitive    = yes
    triggers:
      on choose
        persistent run qg_SetBufferPattern in target-procedure
                         (pcBufferPattern, i).
    end triggers
    .
  
end. /*  */

end procedure. /* qg_CreateBufferButtonMenu */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateTableClone hQueryWindow 
PROCEDURE qg_CreateTableClone :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Create a temp table like given table and copy over all records.            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* Can not be a function due to use of "process events" which might not be    */
/* allowed in a user defined function (Progrerss error 5622).                 */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phTable                        = Table handle or buffer handle of table    */
/*                                  that should be cloned.                    */
/* pcTableName                    = New table name that should be used for    */
/*                                  the clone.                                */
/* pcWhere                        = Where condition of records that should be */
/*                                  copied (or blank for all records).        */
/* pcStatusText                   = Status text that should be used for the   */
/*                                  progress status dialog.                   */
/* ophTable                       = Handle of the new temp-table clone.       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter phTable      as handle    no-undo.
define input  parameter pcTableName  as character no-undo.
define input  parameter pcWhere      as character no-undo.
define input  parameter pcStatusText as character no-undo.
define output parameter ophTable     as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hQuery        as handle    no-undo.
define variable hSourceBuffer as handle    no-undo.
define variable hTargetBuffer as handle    no-undo.

define variable cQueryText    as character no-undo.

define variable i             as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    pcStatusText > '':U then
do:
  
  display unless-hidden
    substitute('&1 ...':T, pcStatusText)
      @ gcStatusText120
    with frame fStatus
      no-labels
      overlay
      color messages
      centered
      view-as dialog-box
      width 125
      .
  process events.
  
end. /* if    pcStatusText > '':U */

/* Create temp-table like parameter table. */

create temp-table ophTable in widget-pool qg_cTTWidgetPool().
ophTable:create-like(phTable).
ophTable:temp-table-prepare(pcTableName).

/* Copy parameter table to new temp-table. */

create query hQuery.

create buffer hSourceBuffer for table phTable buffer-name phTable:name.
create buffer hTargetBuffer for table ophTable.

hQuery:add-buffer(hSourceBuffer).

assign
  pcWhere    = trim(pcWhere)
  cQueryText = (if pcWhere begins 'for':U then
                  pcWhere
                else if pcWhere begins 'where':U then
                  substitute('for each &1 &2':U,
                             hSourceBuffer:name,
                             pcWhere)
                else if pcWhere > '':U then
                  substitute('for each &1 where &2':U,
                             hSourceBuffer:name,
                             pcWhere)
                else
                  substitute('for each &1':U,
                             hSourceBuffer:name))
  .

hQuery:query-prepare(cQueryText).
hQuery:query-open().

hQuery:get-first().

do while not hQuery:query-off-end:
  
  i = i + 1.
  
  if    pcStatusText > '':U
    and i mod 5000   = 0 then
  do:
    
    display unless-hidden
      substitute('&1 (&2 records) ...':T,
                 pcStatusText,
                 trim(string(i, {&K_MAX_INT64_FORMAT})))
        @ gcStatusText120
      with frame fStatus
        no-labels
        overlay
        color messages
        centered
        view-as dialog-box
        width 125
        .
    process events.
    
  end. /* if    pcStatusText > '':U */
  
  hTargetBuffer:buffer-create().
  hTargetBuffer:buffer-copy(hSourceBuffer).
  hTargetBuffer:buffer-validate().
  
  hQuery:get-next().
  
end. /* do while not hQuery:query-off-end */

finally:
  
  if valid-handle(hQuery) then
    delete object hQuery.
  
  if valid-handle(hSourceBuffer) then
    delete object hSourceBuffer.
  
  if valid-handle(hTargetBuffer) then
    delete object hTargetBuffer.
  
end finally.

end procedure. /* qg_CreateTableClone */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DeleteTextLines hQueryWindow 
PROCEDURE qg_DeleteTextLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Inserts given Text after line of given offset index.                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcLine                         = Text that should be inserted.             */
/* piOffset                       = offset of the line after that the text    */
/*                                  should be inserted.                       */
/* pcText                         = Text in which the line should be inser-   */
/*                                  ted.                                      */
/* opiLine                        = Line number of the inserted line.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter piOffsetStart as integer   no-undo.
define input        parameter piOffsetEnd   as integer   no-undo.
define input-output parameter pcText        as character no-undo.
define       output parameter opiLine       as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i               as integer   no-undo.
define variable iOffset         as integer   no-undo init 1.
define variable iLineEndOffset  as integer   no-undo.

define variable iStartOffset    as integer   no-undo.
define variable iEndOffset      as integer   no-undo.

define variable iLineCount      as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if length(pcText) = 0 then
  opiLine = 1.

else
do:
  
  do i = 1 to num-entries(pcText, '~n':U):
    
    iLineEndOffset = iOffset + length(entry(i, pcText, '~n':U)).
    
    if    iOffset        <= piOffsetStart
      and iLineEndOffset >= piOffsetStart then
      assign
        iStartOffset = iOffset
        opiLine      = i
        .
    
    if    iOffset        <= piOffsetEnd
      and iLineEndOffset >= piOffsetEnd then
    do:
      
      iEndOffset = iLineEndOffset + length('~n':U).
      leave.
      
    end. /* if iOffset <= piOffsetEnd */
    
    iOffset = iLineEndOffset + length('~n':U). 
    
  end. /* do i = 1 to num-entries(pcText, '~n':U) */
  
  if    iStartOffset > 0
    and iEndOffset  >= iStartOffset then
  do:
    
    assign
      pcText     = substitute('&1&2':U,
                              substring(pcText, 1, iStartOffset - 1),
                              substring(pcText, iEndOffset))
      iLineCount = max(1, num-entries(pcText, '~n':U))
      .
    
    if opiLine > iLineCount then
      opiLine = iLineCount.
    
    if    opiLine = iLineCount
      and opiLine > 1
      and length(entry(opiLine, pcText, '~n':U)) = 0 then
      opiLine = opiLine - 1.
    
  end. /* if    iStartOffset > 0 */
  
end. /* if length(pcText) = 0 */

end procedure. /* qg_DeleteTextLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DeleteWidgetTree hQueryWindow 
PROCEDURE qg_DeleteWidgetTree :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Delete a tree of widgets with a parent child relation recursively.         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phParent                       = Handle of the Widget that should be       */
/*                                  deleted.                                  */
/* plDeleteParent                 = Delete given parent as well.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phParent       as handle    no-undo.
define input parameter plDeleteParent as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i          as integer   no-undo.
define variable hChild     as handle    no-undo.
define variable hNextChild as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(phParent) then
do:
  
  if can-query(phParent, 'first-child':U) then
  do:
    
    hChild = phParent:first-child.
    
    do while valid-handle(hChild):
      
      hNextChild = hChild:next-sibling.
      
      run qg_DeleteWidgetTree(hChild, yes).
      
      hChild = hNextChild.
      
    end. /* do while valid-handle(hChild) */
    
  end. /* if can-query(phParent, 'first-child':U) */
  
  if phParent:type = 'QUERY' then
  do i = 1 to phParent:num-buffers:
    run qg_DeleteWidgetTree(phParent:get-buffer-handle(i), yes).
  end. /* do i = 1 to phParent:num-buffers */
  
  if phParent:type = 'BROWSE' then
    run qg_DeleteWidgetTree(phParent:query, yes).
  
  if can-query(phParent, 'popup-menu':U) then
    run qg_DeleteWidgetTree(phParent:popup-menu, yes).
  
  if plDeleteParent then
    delete object phParent no-error.
  
end. /* if valid-handle(phParent) */

end procedure. /* qg_DeleteWidgetTree */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DuplicateTextLines hQueryWindow 
PROCEDURE qg_DuplicateTextLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Duplicate text lines.                                                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piOffsetStart                  = Selection Start.                          */
/* piOffsetEnd                    = Selection end.                            */
/* plDown                         = If yes then duplicate downwards.          */
/*                                  Otherwise duplicate upwards.              */
/* pcText                         = Text in which the line should be          */
/*                                  duplicated.                               */
/* opiLine                        = Line number of the duplicated lines.      */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter piOffsetStart as integer   no-undo.
define input        parameter piOffsetEnd   as integer   no-undo.
define input        parameter plDown        as logical   no-undo.
define input-output parameter pcText        as character no-undo.
define       output parameter opiLine       as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i               as integer   no-undo.
define variable iOffset         as integer   no-undo init 1.
define variable iLineEndOffset  as integer   no-undo.

define variable iStartOffset    as integer   no-undo.
define variable iEndOffset      as integer   no-undo.

define variable cLines          as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

do i = 1 to num-entries(pcText, '~n':U):
  
  iLineEndOffset = iOffset + length(entry(i, pcText, '~n':U)).
  
  if    iOffset        <= piOffsetStart
    and iLineEndOffset >= piOffsetStart then
  do:
    
    iStartOffset = iOffset.
    
    if not plDown then
      opiLine = i.
    
  end. /* if    iOffset        <= piOffsetStart ... */
  
  if    iOffset        <= piOffsetEnd
    and iLineEndOffset >= piOffsetEnd then
  do:
    
    iEndOffset = iLineEndOffset + length('~n':U).
    
    if plDown then
      opiLine = i.
    
    leave.
    
  end. /* if iOffset <= piOffsetEnd */
  
  iOffset = iLineEndOffset + length('~n':U). 
  
end. /* do i = 1 to num-entries(pcText, '~n':U) */

if    iStartOffset > 0
  and iEndOffset  >= iStartOffset then
do:
  
  assign
    cLines     = substring(pcText, iStartOffset, iEndOffset - iStartOffset).
    pcText     =   substring(pcText, 1, iEndOffset - 1)
                 + (if iEndOffset > length(pcText)
                      and not pcText matches '*~n':U then
                      '~n':U
                    else
                      '':U)
                 + cLines
                 + substring(pcText, iEndOffset)
                 .
  
  if plDown then
    opiLine = opiLine + 1.
  
end. /* if    iStartOffset > 0 */
  
end procedure. /* qg_DuplicateTextLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_EditFieldValue hQueryWindow 
PROCEDURE qg_EditFieldValue :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Shows a dialog to edit the value of a single table field.                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phField                        = Field handle of the field that should be  */
/*                                  edited.                                   */
/* piIndex                        = Extent index of the field value that      */
/*                                  should be edited.                         */
/* plEditMode                     = If yes then editmode is enabled.          */
/* plRawValue                     = Indicates whether format should be        */
/*                                  applied. If no format should be applied   */
/*                                  then an editor widget will be used        */
/*                                  regardless of the field datatype.         */
/* phParentWindow                 = Parent window handle for the dialog.      */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter pcFieldName as character no-undo.
define input        parameter pcDataType     as character no-undo.
define input        parameter pcFormat       as character no-undo.
define input        parameter pcViewAs       as character no-undo.
define input        parameter plEditor       as logical   no-undo.
define input        parameter plEditMode     as logical   no-undo.
define input-output parameter ioplcValue     as longchar  no-undo.
define input        parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lEditor      as logical   no-undo.
define variable hFieldWidget as handle    no-undo.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fEditFieldValue
    btnOk at row 3.5 col 21
    btnCancel at row 3.5 col 41
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 81 by 5.44
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fEditFieldValue
  apply 'end-error' to self.

lEditor = (   plEditor
           or pcDataType       = 'CLOB':U
           or ( pcDataType     = 'character':U
            and pcViewAs matches '*editor*':U)).

if not lEditor then
do:
  
  create fill-in hFieldWidget
    assign
      name            = 'xFieldWidget':U
      frame           = frame fEditFieldValue:handle
      data-type       = pcDataType
      format          = pcFormat
      width           = 76
      height          = 1
      row             = 1.5
      col             = 3
      sensitive       = yes
      .
  
end. /* if not lEditor */

else
do:
  
  create editor hFieldWidget
    assign
      name                 = 'xFieldWidget':U
      frame                = frame fEditFieldValue:handle
      width                = 126
      height               = 15
      row                  = 1.5
      col                  = 3
      word-wrap            = no
      scrollbar-horizontal = yes
      scrollbar-vertical   = yes
      sensitive            = yes
      return-inserted      = yes
      .
  
  assign
    frame fEditFieldValue:height             = frame fEditFieldValue:height + 14
    frame fEditFieldValue:width              = frame fEditFieldValue:width + 50
    btnOk:row     in frame fEditFieldValue   = btnOk:row in frame fEditFieldValue + 14
    btnOk:col     in frame fEditFieldValue   = btnOk:col in frame fEditFieldValue + 25
    btnCancel:row in frame fEditFieldValue   = btnCancel:row in frame fEditFieldValue + 14
    btnCancel:col in frame fEditFieldValue   = btnCancel:col in frame fEditFieldValue + 25
    .

end. /* else: if not lEditor */

hFieldWidget:screen-value = (if lEditor then
                               ioplcValue
                             else
                              string(ioplcValue)).

if plEditMode then
  frame fEditFieldValue:title = substitute('&1Edit Value (&2)':T,
                                           gcTitlePrefix,
                                           pcFieldName).

else
  assign
    btnCancel:label in frame fEditFieldValue = 'Close':T
    btnCancel:col   in frame fEditFieldValue = btnCancel:col - 10
    btnOk:hidden    in frame fEditFieldValue = yes
    frame fEditFieldValue:title              = substitute('&1Value details (&2)':T,
                                                          gcTitlePrefix,
                                                          pcFieldName)
    hFieldWidget:read-only                   = yes
    .

/* We do not use the update statement because we would not be able to set the */
/* focus to the input widget. Instead we use display and wait-for.            */
assign
  btnOk:sensitive     in frame fEditFieldValue = yes /* code checked by mth */
  btnCancel:sensitive in frame fEditFieldValue = yes /* code checked by mth */
  .

display unless-hidden
  btnOk
  btnCancel
  with frame fEditFieldValue
    in window phParentWindow. 

if plEditMode then
  apply 'entry':U to hFieldWidget.

wait-for go of frame fEditFieldValue.

if plEditMode then
  ioplcValue = (if pcDataType = 'CLOB':U then
                  hFieldWidget:input-value
                else
                  string(hFieldWidget:input-value)).


finally:
  if valid-handle(hFieldWidget) then
    delete object hFieldWidget.
end finally.

end procedure. /* qg_EditFieldValue */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_EditRecord hQueryWindow 
PROCEDURE qg_EditRecord :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Shows a dialog that contains all fields and values of the given record and */
/* offers the option to edit field values.                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBuffer                       = Buffer handle of the record that should   */
/*                                  be edited.                                */
/* piEditAction                   = Action that should be performed:          */
/*                                  - {&K_EDITACTION_EDIT}                    */
/*                                  - {&K_EDITACTION_CREATE}                  */
/*                                  - {&K_EDITACTION_DUPLICATE}               */
/* plEditMode                     = If yes then editmode is enabled.          */
/* phParentWindow                 = Parent window for the dialog.             */
/* pcFieldList                    = List/order of browse fields               */
/* oprRowid                       = Rowid of the edited or created record.    */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter phBuffer       as handle    no-undo.
define input  parameter piEditAction   as integer   no-undo.
define input  parameter plEditMode     as logical   no-undo.
define input  parameter phParentWindow as handle    no-undo.
define input  parameter pcFieldList    as character no-undo.
define output parameter oprRowid       as rowid     no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hLockBuffer      as handle    no-undo.
define variable hTempTable       as handle    no-undo.
define variable hTempTableBuffer as handle    no-undo.

define variable lOk              as logical   no-undo.
define variable lDisableTriggers as logical   no-undo.

define variable lBrowseFields as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Browse fields':T, yes,
      'All fields':T, no
    horizontal
  size 35 by 1.

define variable lRawValues as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Formatted values':T, no,
      'Raw values':T, yes
    horizontal
  size 40 by 1.

define query brRecordBrowse
  for ttRecordField
  scrolling.

define browse brRecordBrowse
  query brRecordBrowse no-lock
    display
      ttRecordField.FieldName
      ttRecordField.FieldExtent
      ttRecordField.FieldLabel
      ttRecordField.CurrentDisplayValue label 'Value':T
      with no-assign size 156 by 19.5.

if plEditMode then
  define button btnOk
    label 'Ok':T2
    size 20 by 1.14
    auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define menu m_PopupMenu
  menu-item mi_CopyFieldValue
    label "Copy value"
  rule
  menu-item mi_EditFieldValue
    label 'Edit value':T
    .

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable       for temp-table ttTable.
define buffer bttField       for temp-table ttField.

define buffer bttRecordField for temp-table ttRecordField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fEditRecord
  lBrowseFields at row 1.5 col 3 no-label
  lRawValues at row 1.5 col 3 no-label
  brRecordBrowse at row 3 col 3
  btnOk at row 23.5 col 61
  btnCancel at row 23.5 col 81
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 161 by 25.44
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fEditRecord
  apply 'end-error' to self.

on value-changed of lBrowseFields in frame fEditRecord
do:
  
  if lBrowseFields:hidden in frame fEditRecord then
    lBrowseFields = no.
  
  else
    assign
      lBrowseFields  = input frame fEditRecord lBrowseFields
      glBrowseFields = lBrowseFields.
  
  if lBrowseFields then
    open query brRecordBrowse
      for each ttRecordField
        where ttRecordField.WindowHandle = ?
          and ttRecordField.Order > 0
        no-lock
        by Order.
  
  else
    open query brRecordBrowse
      for each ttRecordField
        where ttRecordField.WindowHandle = ?
        no-lock
        by FieldName.
  
end. /* on 'value-changed':U of lBrowseFields in frame fEditRecord */

on value-changed of lRawValues in frame fEditRecord
do:
  
  define variable clValue as longchar  no-undo.
  
  define buffer bttRecordField for ttRecordField.
  
  assign
    lRawValues  = input frame fEditRecord lRawValues
    glRawValues = lRawValues
    .
  
  for each bttRecordField
    on error undo, throw:
    
    run qg_UpdateRecordFieldDisplayValue((buffer bttRecordField:handle),
                                          lRawValues,
                                          255). 
    
  end. /* for each bttRecordField */
  
  if query brRecordBrowse:num-results > 0 then
    browse brRecordBrowse:refresh().
  
end. /* on 'value-changed' of lRawValues in frame fEditRecord */

on value-changed of brRecordBrowse in frame fEditRecord
do:
  
  if available ttRecordField then
    menu-item mi_CopyFieldValue:label in menu m_PopupMenu = substitute('Copy value (&1)':T,
                                                                       (if length(ttRecordField.CurrentDisplayValue) < 100 then
                                                                          ttRecordField.CurrentDisplayValue
                                                                        else
                                                                          substitute('&1 ...':U,
                                                                                     substring(ttRecordField.CurrentDisplayValue, 1, 96)))).
  
  else
    menu-item mi_CopyFieldValue:label in menu m_PopupMenu = 'Copy value':T.
  
end. /* on 'value-changed':U of brRecordBrowse in frame fEditRecord */

on choose of menu-item mi_CopyFieldValue in menu m_PopupMenu
do:
  
  define variable clValue as longchar  no-undo.
  
  if not available ttRecordField then
    message /* code checked by mth */
      'No field is selected':T skip
      view-as alert-box
      error
      buttons ok.
    
  else
  do:
    
    lRawValues = input frame fEditRecord lRawValues.
    
    if lRawValues then
      copy-lob ttRecordField.CurrentUnformattedValue to clValue.
    
    else
      copy-lob ttRecordField.CurrentFormattedValue to clValue.
    
    clipboard:value = clValue.
      
  end. /* else: if not available ttRecordField */
  
end. /* on choose of menu-item mi_CopyFieldValue in menu m_PopupMenu */

on choose of menu-item mi_EditFieldValue in menu m_PopupMenu
do:
  
  define variable hField  as handle    no-undo.
  define variable clValue as longchar  no-undo.
  
  if not available ttRecordField then
    message /* code checked by mth */
      'No field is selected!':T
      view-as alert-box
      error
      buttons ok
      in window phParentWindow.

  
  else
  do:
    
    hField = hTempTableBuffer:buffer-field(ttRecordField.FieldName).
    
    if hField:data-type = 'BLOB':U then
      message /* code checked by mth */
        'BLOB fields may not be edited!':T skip
        view-as alert-box
        error
        buttons ok.
      
    else
    do:
      
      if hField:data-type = 'CLOB':U then
        copy-lob hField:buffer-value(ttRecordField.FieldExtent) to clValue.
      
      else
        clValue = string(hField:buffer-value(ttRecordField.FieldExtent)).
      
      run qg_EditFieldValue(hField:name,
                            hField:data-type,
                            hField:format,
                            hField:view-as,
                            input frame fEditRecord lRawValues,
                            plEditMode,
                            input-output clValue,
                            phParentWindow).
      
      if plEditMode then
      do:
        
        if hField:data-type = 'CLOB':U then
          copy-lob clValue to hField:buffer-value(ttRecordField.FieldExtent).
        
        else
          hField:Buffer-value(ttRecordField.FieldExtent) = string(clValue).
        
      end. /* if plEditMode */
      
      /* Update values in ttRecordField */
      run qg_UpdateRecordField(hField,
                               ttRecordField.FieldExtent,
                               (buffer ttRecordField:handle)).
      
      run qg_UpdateRecordFieldDisplayValue((buffer ttRecordField:handle),
                                           input frame fEditRecord lRawValues,
                                           255). 
      
      if query brRecordBrowse:num-results > 0 then
        browse brRecordBrowse:refresh().
      
    end. /* if bttField.DataType = 'BLOB':U */
    
  end. /* else: if not available ttRecordField */
  
end. /* on choose of menu-item mi_EditFieldValue in menu m_PopupMenu */

on default-action of brRecordBrowse in frame fEditRecord
  apply 'choose':U to menu-item mi_EditFieldValue in menu m_PopupMenu.

on ' ':U of brRecordBrowse in frame fEditRecord
  apply 'choose':U to menu-item mi_EditFieldValue in menu m_PopupMenu.

on ctrl-c of brRecordBrowse in frame fEditRecord
  apply 'choose':U to menu-item mi_CopyFieldValue in menu m_PopupMenu.

Main:
do
  transaction
  on error  undo, throw
  on endkey undo, leave:
  
  if not plEditMode then
    assign
      btnOk:hidden in frame fEditRecord                     = yes
      btnCancel:label in frame fEditRecord                  = 'Close':T5
      btnCancel:col in frame fEditRecord                    = 71
      menu-item mi_EditFieldValue:label in menu m_PopupMenu = 'Value details':T
      .
  
  create buffer hLockBuffer for table phBuffer.
  
  find bttTable
    where bttTable.DatabaseName = hLockBuffer:dbname
      and bttTable.TableName    = hLockBuffer:table
    no-error.
  
  if   piEditAction = {&K_EDITACTION_CREATE}
    or piEditAction = {&K_EDITACTION_DUPLICATE} then
  do:
    
    lDisableTriggers =     available bttTable
                       and bttTable.CreateTrigger         > '':U
                       and search(bttTable.CreateTrigger) = ?.
    
    run qg_ConfirmTriggerChanges(substitute('Confirm creation of &1 record':T,
                                            hLockBuffer:table),
                                 substitute('Please confirm creation of &1 record':T,
                                            hLockBuffer:table),
                                 'Create':T,
                                 (    available bttTable
                                  and search(bttTable.CreateTrigger) <> ?),
                                 phParentWindow,
                                       output lOk,
                                 input-output lDisableTriggers).
    
    if not lOk then
      undo Main, leave Main.
    
    run qg_CreateBuffer(hLockBuffer,
                        lDisableTriggers).
    
  end. /* if   piEditAction = {&K_EDITACTION_CREATE} ... */

  else if piEditAction = {&K_EDITACTION_EDIT}
    and   plEditMode then
    hLockBuffer:find-by-rowid(phBuffer:rowid, exclusive-lock).
  
  else
    hLockBuffer:find-by-rowid(phBuffer:rowid, no-lock).
  
  /* Set dialog title. */
  
  case piEditAction:
    
    when {&K_EDITACTION_CREATE} then
      frame fEditRecord:title = substitute('&1Create &2 record (&3)':T,
                                           gcTitlePrefix,
                                           hLockBuffer:table,
                                           hLockBuffer:rowid).
    
    when {&K_EDITACTION_DUPLICATE} then
      frame fEditRecord:title = substitute('&1Duplicate &2 record (&3)':T,
                                           gcTitlePrefix,
                                           hLockBuffer:table,
                                           hLockBuffer:rowid).
    
    otherwise
    do:
      
      if plEditMode then
        frame fEditRecord:title = substitute('&1Edit &2 record (&3)':T,
                                             gcTitlePrefix,
                                             hLockBuffer:table,
                                             hLockBuffer:rowid).
      
      else
        frame fEditRecord:title = substitute('&1&2 record details (&3)':T,
                                             gcTitlePrefix,
                                             hLockBuffer:table,
                                             hLockBuffer:rowid).
      
    end. /* otherwise */
    
  end case. /* piEditAction */
  
  /* Create temp-table and copy buffer-values. */
  
  create temp-table hTempTable.
  
  hTempTable:create-like-sequential(hLockBuffer).
  hTempTable:temp-table-prepare(substitute('tt&1':U,
                                           hLockBuffer:table)).
  
  hTempTableBuffer = hTempTable:default-buffer-handle.
  
  hTempTableBuffer:buffer-create().
  
  if piEditAction = {&K_EDITACTION_DUPLICATE} then
    hTempTableBuffer:buffer-copy(phBuffer,
                                 substitute('&1_Obj':U,
                                            phBuffer:table)).
  
  else
    hTempTableBuffer:buffer-copy(hLockBuffer).
  
  if pcFieldList = ? then
    assign
      lBrowseFields                             = no
      lBrowseFields:hidden in frame fEditRecord = yes
      .
  
  else
    assign
      lBrowseFields                       = glBrowseFields
      lRawValues:col in frame fEditRecord = lRawValues:col in frame fEditRecord + 45
      .
  
  lRawValues = glRawValues.
  
  /* Fill field temp-table with display values. */
  
  run qg_UpdateRecordFieldTempTable(hTempTableBuffer,
                                    ?,
                                    pcFieldList).
  
  /* Display has to happen before we apply 'value-changed' to avoid an error  */
  /* message due to an invalid screen-value.                                  */
  
  display unless-hidden
    lBrowseFields
    lRawValues
    with frame fEditRecord
      in window phParentWindow. 
  
  apply 'value-changed' to lRawValues in frame fEditRecord.
  apply 'value-changed' to lBrowseFields in frame fEditRecord.
  
  assign
    brRecordBrowse:popup-menu         in frame fEditRecord = menu m_PopupMenu:handle
    brRecordBrowse:num-locked-columns in frame fEditRecord = 3
    .
  
  run qg_InitBrowse(browse brRecordBrowse:handle).
  
  update unless-hidden
    lBrowseFields
    lRawValues
    brRecordBrowse
    btnOk
    btnCancel
    with frame fEditRecord
      in window phParentWindow. 
  
  if plEditMode then
  do:
    
    if not hLockBuffer:buffer-compare(hTempTableBuffer,
                                      'binary':U) then
    do:
      
      lDisableTriggers =     available bttTable
                         and bttTable.WriteTrigger         > '':U
                         and search(bttTable.WriteTrigger) = ?.  
      
      run qg_ConfirmRecordChanges(substitute('Confirm changes to &1 record &2':T,
                                             hLockBuffer:table,
                                             string(hLockBuffer:rowid)),
                                  'WARNING: The current record has been changed. Below you will find a list of all changes you made. Please carefully review and confirm your changes!':T,
                                  hLockBuffer,
                                  hTempTableBuffer,
                                  (    available bttTable
                                   and search(bttTable.WriteTrigger) <> ?),
                                  lRawValues,
                                  phParentWindow,
                                        output lOk,
                                  input-output lDisableTriggers).
      
      if lOk then
      do:
        
        if lDisableTriggers then
          hLockBuffer:disable-load-triggers(no).
        
        hLockBuffer:buffer-copy(hTempTableBuffer).
        hLockBuffer:buffer-validate().
        
      end. /* if lOk */
      
    end. /* if not buffer-compare(hLockBuffer, */
    
    oprRowid = hLockBuffer:rowid.
    
  end. /* if plEditMode */
  
  finally:
    
    if valid-handle(hLockBuffer) then
    do:
      
      hLockBuffer:buffer-release().
      
      delete object hLockBuffer.
      
    end. /* if valid-handle(hLockBuffer) */
    
    if valid-handle(hTempTable) then
      delete object hTempTable no-error.
    
  end finally.
  
end. /* Main */

end procedure. /* qg_EditRecord */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExecQuery hQueryWindow 
PROCEDURE qg_ExecQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open a new query window and execute the current query.                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabaseName                 = Database name for query buffer.           */
/* pcTableName                    = Table name for query buffer.              */
/* pcQueryText                    = Initial query text for this query window. */
/* piQuerySeq                     = Query sequence to use for this window. If */
/*                                  empty then a new id will be generated.    */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName   as character no-undo.
define input parameter pcTableName      as character no-undo.
define input parameter pcQueryText      as character no-undo.
define input parameter piQuerySeq       as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer                    as handle    no-undo.
define variable hQuery                     as handle    no-undo.

define variable cWindowTitle               as character no-undo.

define variable hWindow                    as handle    no-undo.
define variable hFrame                     as handle    no-undo.

define variable hMenuBar                   as handle    no-undo.
define variable hFileMenu                  as handle    no-undo.


define variable hQueryTextEditor           as handle    no-undo.
define variable hToggleFieldBrowseButton   as handle    no-undo.
define variable hFieldSelectionBuffer      as handle    no-undo.
define variable hFieldSelectionQuery       as handle    no-undo.
define variable cFieldSelectionQueryText   as character no-undo.
define variable hFieldSelectionBrowse      as handle    no-undo.
define variable hExecuteButton             as handle    no-undo.
define variable hEditButton                as handle    no-undo.
&IF {&K_EDITMODE_ENABLED} &THEN
  define variable hDeleteButton            as handle    no-undo.
  define variable hCreateButton            as handle    no-undo.
  define variable hDuplicateButton         as handle    no-undo.
&ENDIF
define variable hSplitterButton1           as handle    no-undo.
define variable hQueryBrowser              as handle    no-undo.

define variable hTemp                      as handle    no-undo.
define variable hShowAllMenuItem           as handle    no-undo.
define variable hCopyObjectIdSubMenu       as handle    no-undo.
define variable hShowObjectIdRecordSubMenu as handle    no-undo.
define variable hShowObjectIdRecordRule    as handle    no-undo.
define variable hQueryTextSubMenu          as handle    no-undo.

define variable i                          as integer   no-undo.
define variable hField                     as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable       for temp-table ttTable.
define buffer bttField       for temp-table ttField.

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttTable
  where bttTable.DatabaseName = pcDatabaseName
    and bttTable.TableName    = pcTableName
  no-error.

if   not available bttTable
  or (  not bttTable.PhysicalTable
    and not valid-handle(bttTable.TableHandle)) then
  leave.

if piQuerySeq = ? then
  assign
    giQuerySeq = giQuerySeq + 1
    piQuerySeq = giQuerySeq
    .

else
do:
  
  if can-find(ttQueryWindow
                where ttQueryWindow.QuerySeq = piQuerySeq) then
  do:
    
    message /* code checked by mth */
      substitute('The query id &1 is already in use. Query window could not be opened!':T,
                 piQuerySeq) skip
      view-as alert-box error
      buttons ok.
    
    return error.
    
  end. /* if can-find(ttQueryWindow */
  
  giQuerySeq = max(piQuerySeq, giQuerySeq). 
  
end. /* if piQuerySeq = ? */

if not bttTable.PhysicalTable then
  create buffer hBuffer for table bttTable.TableHandle. /* code checked by mth 30.07.2015 */

else
  create buffer hBuffer for table substitute('&1.&2':U, /* code checked by mth 30.07.2015 */
                                             bttTable.DatabaseName,
                                             bttTable.TableName).

hBuffer:private-data = qg_cParamListWriteCharacter(hBuffer:private-data,
                                                   'DatabaseName':U,
                                                   pcDatabaseName,
                                                   ',':U).

create query hQuery.
hQuery:set-buffers(hBuffer).

cWindowTitle = substitute('[&1] Query - &2.&3':T,
                          piQuerySeq,
                          pcDatabaseName,
                          pcTableName).

/* Create dynamic widgets. */

create window hWindow
  assign
    hidden         = yes
    width          = 150
    max-width      = 1024
    height         = 18
    max-height     = 1024
    scroll-bars    = no
    status-area    = no
    three-d        = yes
    message-area   = no
    sensitive      = yes
    title          = substitute('&1&2':U, gcTitlePrefix, cWindowTitle)
    .

/*
create menu hMenuBar.

create sub-menu hFileMenu
  assign
    name      = 'mFile':U
    label     = 'File':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name      = 'miExit':U
    label     = 'Exit':T
    sensitive = yes
    parent    = hFileMenu
    .

hWindow:menu-bar = hMenuBar.
*/

create frame hFrame
  assign
    name           = 'fQuery':U
    box            = no
    three-d        = yes
    width          = 235
    virtual-width  = 235
    height         = 32
    virtual-height = 32
    sensitive      = yes
    parent         = hWindow
    .

create editor hQueryTextEditor
  assign
    name                 = 'cQueryText':U
    frame                = hFrame
    width                = 162
    height               = 6
    row                  = 1
    col                  = 1
    word-wrap            = no
    font                 = 0
    large                = yes
    auto-indent          = yes
    scrollbar-horizontal = yes
    scrollbar-vertical   = yes
    sensitive            = yes
    .

assign
  cFieldSelectionQueryText = 'for each ttField':U
  cFieldSelectionQueryText = substitute('&1~n  where ttField.DatabaseName = "&2"':U,
                                        cFieldSelectionQueryText,
                                        pcDatabaseName)
  cFieldSelectionQueryText = substitute('&1~n    and ttField.TableName    = "&2"':U,
                                        cFieldSelectionQueryText,
                                        pcTableName)
  .

create buffer hFieldSelectionBuffer for table 'ttField':U. /* code checked by mth 30.07.2015 */

create query hFieldSelectionQuery.
hFieldSelectionQuery:set-buffers(hFieldSelectionBuffer).

qg_lQueryOpen(hFieldSelectionQuery, cFieldSelectionQueryText, hWindow).

create button hToggleFieldBrowseButton
  assign
    name                 = 'btnToggleFieldBrowse':U
    frame                = hFrame
    width                = 3
    height               = 6
    row                  = 1
    col                  = 163
    label                = '>':T
    tooltip              = 'Hide field List':T
    flat-button          = yes
    sensitive            = yes
    .

create browse hFieldSelectionBrowse
  assign
    name                   = 'brFieldSelection':U
    frame                  = hFrame
    width                  = 50
    height                 = 6
    row                    = 1
    col                    = 183
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
    multiple               = yes
    no-empty-space         = yes
    .

create button hExecuteButton
  assign
    name                 = 'btnExecute':U
    frame                = hFrame
    width                = 20
    height               = 2
    row                  = 1
    col                  = 215
    label                = 'Execute':T
    tooltip              = 'Execute current query and refresh browse (F2)':T
    sensitive            = yes
    .

create button hEditButton
  assign
    name      = 'btnEdit':U
    frame     = hFrame
    width     = 20
    height    = 1
    row       = 3
    col       = 215
    &IF {&K_EDITMODE_ENABLED} &THEN
      label   = 'Edit Record':T
      tooltip = 'Edit currently selected record.':T
    &ELSE
      label   = 'Record':T
      tooltip = 'Show record details for currently selected record':T
    &ENDIF
    sensitive = yes
    .
&IF {&K_EDITMODE_ENABLED} &THEN
  
  create button hDeleteButton
    assign
      name      = 'btnDelete':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 4
      col       = 215
      label     = 'Delete Record':T
      tooltip   = 'Delete currently selected record':T
      sensitive = yes
      .
  
  create button hCreateButton
    assign
      name      = 'btnCreate':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 5
      col       = 215
      label     = 'Create Record':T
      tooltip   = 'Create new record':T
      sensitive = yes
      .
  
  create button hDuplicateButton
    assign
      name      = 'btnDuplicate':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 6
      col       = 215
      label     = 'Duplicate Record':T
      tooltip   = 'Create new record by duplicating currently selected record':T
      sensitive = yes
      .
  
&ENDIF

create button hSplitterButton1
  assign
    name        = 'btnSplitter1':U
    frame       = hFrame
    width       = 10
    height      = 0.25
    row         = 7
    col         = 1
    label       = '':U
    no-focus    = yes
    flat-button = yes
    movable     = yes
    sensitive   = yes
    .

create browse hQueryBrowser
  assign
    name                 = 'brQuery':U
    frame                = hFrame
    width                = 10
    height               = 10
    row                  = 7.25
    col                  = 1
    read-only            = yes
    row-markers          = no
    .

/* Add popup menus. */

create menu hTemp
  assign
    name       = 'm_QueryTextPopupMenu':U
    popup-only = yes
    sensitive  = yes
  triggers:
    on menu-drop
      persistent run qg_QueryWindowQueryTextEditorPopupMenuDrop in target-procedure
                       (hWindow).
  end triggers.

hQueryTextEditor:popup-menu = hTemp.

create menu-item hShowAllMenuItem
  assign
    name         = 'mi_ShowAll':U
    parent       = hQueryTextEditor:popup-menu
    label        = 'Show all':T
    sensitive    = yes
    .

create menu-item hTemp
  assign
    name      = 'm_ShowIndex':U
    parent    = hQueryTextEditor:popup-menu
    label     = 'Show index':T
    sensitive = yes
  triggers:
    on choose
      persistent run qg_QueryWindowShowIndex in target-procedure
                       (hWindow,
                        pcDatabaseName,
                        pcTableName).
  end triggers.

create menu-item hTemp
  assign
    name      = 'm_SortByIndex':U
    parent    = hQueryTextEditor:popup-menu
    label     = 'Sort by Index':T
    sensitive = yes
  triggers:
    on choose
      persistent run qg_QueryWindowSortByIndex in target-procedure
                       (hWindow,
                        pcDatabaseName,
                        pcTableName).
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryTextEditor:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_InsertExternalFieldReference':U
    parent       = hQueryTextEditor:popup-menu
    label        = 'Insert external field reference':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowInsertExternalReference in target-procedure
                       (hWindow,
                        hQueryTextEditor,
                        yes).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_InsertExternalTableReference':U
    parent       = hQueryTextEditor:popup-menu
    label        = 'Insert external table reference':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowInsertExternalReference in target-procedure
                       (hWindow,
                        hQueryTextEditor,
                        no).
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryTextEditor:popup-menu
    .

create menu-item hTemp
  assign
    name        = 'mi_BeautifyQueryText':U
    parent      = hQueryTextEditor:popup-menu
    label       = 'Beautify query text':T
    sensitive   = yes
  triggers:
    on choose persistent run qg_QueryWindowBeautify in target-procedure
                               (hWindow).
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryTextEditor:popup-menu
    .

create menu-item hTemp
  assign
    name        = 'mi_RecentQueries':U
    parent      = hQueryTextEditor:popup-menu
    label       = 'Recent queries':T
    sensitive   = yes
  triggers:
    on choose persistent run qg_QueryWindowRecentQueries in target-procedure
                               (hWindow).
  end triggers.

create menu hTemp
  assign
    name       = 'm_PopupMenu':U
    popup-only = yes
    sensitive  = yes
  triggers:
    on menu-drop
      persistent run qg_QueryWindowQueryBrowsePopupMenuDrop in target-procedure
                      (hWindow).
  end triggers.

hQueryBrowser:popup-menu = hTemp.

create sub-menu hCopyObjectIdSubMenu
  assign
    name      = 'm_CopyObjectId':U
    parent    = hQueryBrowser:popup-menu
    label     = 'Copy object id':T
    sensitive = yes
    .

create menu-item hTemp
  assign
    name         = 'mi_CopyRecid':U
    parent       = hQueryBrowser:popup-menu
    label        = 'Copy recid':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowCopyRecid in target-procedure
                       (hBuffer,
                        yes).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CopyRowid':U
    parent       = hQueryBrowser:popup-menu
    label        = 'Copy rowid':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowCopyRecid in target-procedure
                       (hBuffer,
                        no).
  end triggers
  .

create menu-item hShowObjectIdRecordRule
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowser:popup-menu
    .

create sub-menu hShowObjectIdRecordSubMenu
  assign
    name      = 'm_ShowObjectIdRecord':U
    parent    = hQueryBrowser:popup-menu
    label     = 'Object id records':T
    sensitive = yes
    .

do i = 1 to 2:
  
  /* In first run only add the tables own object id. In second run add all
     other object ids. */
  for each bttField
    where  (i = 1
        and bttField.DatabaseName = pcDatabaseName
        and bttField.TableName    = pcTableName
        and bttField.FieldName    = substitute('&1_obj':U, pcTableName))
        and bttField.FieldExtent  = 0
      or   (i = 2
        and bttField.DatabaseName = pcDatabaseName
        and bttField.TableName    = pcTableName
        and bttField.FieldName    matches '*_obj':U
        and bttField.FieldName   <> substitute('&1_obj':U, pcTableName))
        and bttField.FieldExtent  = 0
    on error undo, throw:
  
    hField = hBuffer:buffer-field(bttField.FieldName).
    
    create menu-item hTemp
      assign
        name         = substitute('mi_Copy&1FieldValue':U, bttField.FieldName)
        parent       = hCopyObjectIdSubMenu
        label        = substitute('Copy &1':T, bttField.FieldName)
        private-data = bttField.FieldName
        sensitive    = yes
      triggers:
        on choose
          persistent run qg_CopyFieldValue in target-procedure
                           (hBuffer,
                            bttField.FieldName,
                            0).
      end triggers
      .
    if    i = 1
      and can-find(first ttField
                     where ttField.DatabaseName = pcDatabaseName
                       and ttField.TableName    = pcTableName
                       and ttField.FieldName   matches '*_obj':U
                       and ttField.FieldName   <> bttField.FieldName) then
      create menu-item hTemp
        assign
          subtype = 'RULE':U
          parent  = hCopyObjectIdSubMenu
          .
    
    else if i = 2 then
      create menu-item hTemp
        assign
          name         = substitute('mi_Show&1Record':U, bttField.FieldName)
          parent       = hShowObjectIdRecordSubMenu
          label        = substitute('&1 record':T, bttField.FieldName)
          private-data = bttField.FieldName
          sensitive    = yes
        triggers:
          on choose
            persistent run qg_ShowObjectIdRecord in target-procedure
                             (hBuffer,
                              bttField.FieldName,
                              hWindow).
        end triggers
      .
    
  end. /* for each bttField */
  
end. /* do i = 1 to hBuffer:num-fields() */

/* Remove sub menus without menu items. */
if not valid-handle(hCopyObjectIdSubMenu:first-child) then
  delete object hCopyObjectIdSubMenu.

if not valid-handle(hShowObjectIdRecordSubMenu:first-child) then
do:
  delete object hShowObjectIdRecordSubMenu.
  delete object hShowObjectIdRecordRule.
end. /* if not valid-handle(hShowObjectIdRecordSubMenu:first-child) */

create menu-item hShowObjectIdRecordRule
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowser:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_OpenRecordWindow':U
    parent       = hQueryBrowser:popup-menu
    label        = 'Record details':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_OpenRecordWindow in target-procedure
                       (hBuffer).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CopyRecordValuesRaw':U
    parent       = hQueryBrowser:popup-menu
    label        = 'Copy record values':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowCopyRecordValues in target-procedure
                       (hWindow).
  end triggers
  .

create menu-item hShowObjectIdRecordRule
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowser:popup-menu
    .

create menu-item hTemp
  assign
    name      = 'mi_AddSnapshot':U
    parent    = hQueryBrowser:popup-menu
    label     = 'Add snapshot':T
    sensitive = yes
  triggers:
    on choose
      persistent run qg_QueryWindowAddSnapshot in target-procedure
                       (hWindow).
  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowser:popup-menu
    .

create sub-menu hQueryTextSubMenu
  assign
    name      = 'm_QueryText':U
    parent    = hQueryBrowser:popup-menu
    label     = 'Query text':T
    sensitive = yes
    .

create menu-item hTemp
  assign
    name         = 'mi_ShowQueryText':U
    parent       = hQueryTextSubMenu
    label        = 'Show query text':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowShowQueryText in target-procedure
                       (hWindow).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CopyQueryText':U
    parent       = hQueryTextSubMenu
    label        = 'Copy query text':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowCopyQueryText in target-procedure
                       (hWindow).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_ExecCurrentQueryText':U
    parent       = hQueryTextSubMenu
    label        = 'Execute query text':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowExecCurrentQuery in target-procedure
                       (hWindow,
                        pcDatabaseName,
                        pcTableName).
  end triggers
  .

run qg_InitBrowse(hQueryBrowser).

create menu hTemp
  assign
    name       = 'm_PopupMenu':U
    popup-only = yes
    sensitive  = yes
    .

hFieldSelectionBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_MoveToFirstColumn':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Move to first column':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (hWindow,
                        yes).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_MoveToLastColumn':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Move to last column':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (hWindow,
                        no).
  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hFieldSelectionBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_AddCondition':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Add condition':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowQueryTextEditorAddCondition in target-procedure
                       (hWindow).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_AddSortPhrase':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Add sort option':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowAddSortOption in target-procedure
                       (hWindow,
                        no).
  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_AddSortPhrase':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Add sort option (descending)':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowAddSortOption in target-procedure
                       (hWindow,
                        yes).
  end triggers
  .

run qg_InitBrowse(hFieldSelectionBrowse).

/* Define persistent ui-triggers. */

on window-resized of hWindow
  persistent run qg_QueryWindowResize in target-procedure
                   (hWindow).

on window-close of hWindow
  persistent run qg_QueryWindowClose in target-procedure
                   (hWindow).

on end-error of hWindow anywhere
  persistent run qg_MoveToTop in target-procedure.

on choose of hShowAllMenuItem
  persistent run qg_QueryWindowShowAll in target-procedure
                   (hWindow,
                    pcTableName).
                      
on choose of hToggleFieldBrowseButton
  persistent run qg_QueryWindowToggleFieldList in target-procedure
                   (hWindow).

on choose of hExecuteButton
  persistent run qg_QueryWindowExecute in target-procedure
                   (hWindow).

on choose of hEditButton
  persistent run qg_QueryWindowEdit in target-procedure
                   (hQueryBrowser,
                    hBuffer,
                    {&K_EDITACTION_EDIT},
                    hWindow).

&IF {&K_EDITMODE_ENABLED} &THEN
  
  on choose of hDeleteButton
    persistent run qg_QueryWindowDelete in target-procedure
                     (hQueryBrowser,
                      hBuffer,
                      hWindow).
  
  on choose of hCreateButton
    persistent run qg_QueryWindowEdit in target-procedure
                     (hQueryBrowser,
                      hBuffer,
                      {&K_EDITACTION_CREATE},
                      hWindow).
  
  on choose of hDuplicateButton
    persistent run qg_QueryWindowEdit in target-procedure 
                     (hQueryBrowser,
                      hBuffer,
                      {&K_EDITACTION_DUPLICATE},
                      hWindow).
  
&ENDIF

on f2 of hWindow anywhere /* Execute */
  persistent run qg_QueryWindowExecute in target-procedure 
                   (hWindow).

on f3 of hWindow anywhere /* Show all */
  persistent run qg_QueryWindowShowAll in target-procedure
                   (hWindow,
                    pcTableName).

on f4 of hWindow anywhere /* Show index */
  persistent run qg_QueryWindowShowIndex in target-procedure
                   (hWindow,
                    pcDatabaseName,
                    pcTableName).

on f5 of hWindow anywhere /* Recent queries */
  persistent run qg_QueryWindowRecentQueries in target-procedure
                   (hWindow).

on f8 of hWindow anywhere /* record details */
  persistent run qg_OpenRecordWindow in target-procedure
                   (hBuffer).

on f10 of hWindow anywhere /* Add snapshot */
  persistent run qg_QueryWindowAddSnapshot in target-procedure
                   (hWindow).

on shift-alt-cursor-up of hWindow anywhere /* Dock up */
  persistent run qg_QueryWindowDock in target-procedure
                   (hWindow,
                    {&K_DIRECTION_UP}).

on shift-alt-cursor-down of hWindow anywhere /* Dock down */
  persistent run qg_QueryWindowDock in target-procedure
                   (hWindow,
                    {&K_DIRECTION_DOWN}).

on shift-alt-cursor-left of hWindow anywhere /* Dock left */
  persistent run qg_QueryWindowDock in target-procedure
                   (hWindow,
                    {&K_DIRECTION_LEFT}).

on shift-alt-cursor-right of hWindow anywhere /* Dock right */
  persistent run qg_QueryWindowDock in target-procedure
                   (hWindow,
                    {&K_DIRECTION_RIGHT}).

on shift-f8 of hWindow anywhere /* Toggle field list */
  persistent run qg_QueryWindowToggleFieldList in target-procedure
                   (hWindow).

on shift-f2 of hWindow anywhere /* Set focus to query text editor */
  persistent run qg_QueryWindowSetFocus in target-procedure
                   (hQueryTextEditor).

on shift-f3 of hWindow anywhere /* Set focus to field list browse */
  persistent run qg_QueryWindowSetFocus in target-procedure
                   (hFieldSelectionBrowse).

on shift-f4 of hWindow anywhere /* Set focus to query browse */
  persistent run qg_QueryWindowSetFocus in target-procedure
                   (hQueryBrowser).

on shift-f9 of hWindow anywhere /* Set size small */
  persistent run qg_QueryWindowSetSize in target-procedure
                   (hWindow,
                    {&K_QUERY_SIZE_MODE_SMALL}).

on shift-f10 of hWindow anywhere /* Set size smaller */
  persistent run qg_QueryWindowSetSize in target-procedure
                   (hWindow,
                    {&K_QUERY_SIZE_MODE_SMALLER}).

on shift-f11 of hWindow anywhere /* Set size minimum */
  persistent run qg_QueryWindowSetSize in target-procedure
                   (hWindow,
                    {&K_QUERY_SIZE_MODE_MINIMUM}).

on shift-f12 of hWindow anywhere /* Set size default */
  persistent run qg_QueryWindowSetSize in target-procedure
                   (hWindow,
                    {&K_QUERY_SIZE_MODE_DEFAULT}).

on ctrl-f7 of hWindow anywhere /* Show query window */
  persistent run qg_ShowQueryWindow in target-procedure
                   (hWindow).

on ctrl-f8 of hWindow anywhere /* Show record window */
  persistent run qg_ShowRecordWindow in target-procedure
                   (hWindow).

on ctrl-w of hWindow anywhere /* Close window */
  persistent run qg_CloseWindow in target-procedure
                   (hWindow).

on end-move of hSplitterButton1
  persistent run qg_QueryWindowResize in target-procedure
                   (hWindow).

on ctrl-d of hQueryTextEditor
  persistent run qg_QueryWindowQueryTextEditorDeleteLines in target-procedure
                   (hWindow).

on alt-up of hQueryTextEditor
  persistent run qg_QueryWindowQueryTextEditorMoveLines in target-procedure
                   (hWindow,
                    no).

on alt-down of hQueryTextEditor
  persistent run qg_QueryWindowQueryTextEditorMoveLines in target-procedure
                   (hWindow,
                    yes).

on ctrl-alt-cursor-up of hQueryTextEditor
  persistent run qg_QueryWindowQueryTextEditorDuplicateLines in target-procedure
                   (hWindow,
                    no).

on ctrl-alt-cursor-down of hQueryTextEditor
  persistent run qg_QueryWindowQueryTextEditorDuplicateLines in target-procedure
                   (hWindow,
                    yes).

on ctrl-ins of hQueryTextEditor
  persistent run qg_QueryWindowInsertExternalReference in target-procedure
                   (hWindow,
                    hQueryTextEditor,
                    yes).

on ctrl-shift-ins of hQueryTextEditor
  persistent run qg_QueryWindowInsertExternalReference in target-procedure
                   (hWindow,
                    hQueryTextEditor,
                    no).

on tab of hQueryTextEditor
  persistent run qg_QueryWindowSelectNextCondition in target-procedure
                   (hWindow,
                    yes).

on shift-tab of hQueryTextEditor
  persistent run qg_QueryWindowSelectNextCondition in target-procedure
                   (hWindow,
                    no).

on ctrl-enter of hQueryTextEditor
  persistent run qg_QueryWindowSelectNextCondition in target-procedure
                   (hWindow,
                    ?).

on mouse-extend-click of hQueryTextEditor
  persistent run qg_QueryWindowSelectNextCondition in target-procedure
                   (hWindow,
                    ?).

on ctrl-tab of hQueryTextEditor
  persistent run qg_QueryWindowSetFocus in target-procedure
                   (hFieldSelectionBrowse).

on ctrl-b of hQueryTextEditor
  persistent run qg_QueryWindowBeautify in target-procedure
                   (hWindow).

on default-action of hFieldSelectionBrowse
  persistent run qg_QueryWindowFieldSelectionBrowseDefaultAction in target-procedure
                   (hWindow).

on ctrl-ins of hFieldSelectionBrowse
  persistent run qg_QueryWindowQueryTextEditorAddCondition in target-procedure
                   (hWindow).

on ctrl-home of hFieldSelectionBrowse
  persistent run qg_QueryWindowMoveColumn in target-procedure
                   (hWindow,
                    yes).

on ctrl-end of hFieldSelectionBrowse
  persistent run qg_QueryWindowMoveColumn in target-procedure
                   (hWindow,
                    no).

on ctrl-page-up of hFieldSelectionBrowse
  persistent run qg_QueryWindowAddSortOption in target-procedure
                   (hWindow,
                    no).

on ctrl-page-down of hFieldSelectionBrowse
  persistent run qg_QueryWindowAddSortOption in target-procedure
                   (hWindow,
                    yes).

on value-changed of hQueryBrowser
  persistent run qg_QueryWindowUpdateAll in target-procedure
                   ('':U).

on default-action of hQueryBrowser
  persistent run qg_QueryWindowQueryBrowseDefaultAction in target-procedure
                   (hWindow).

on ctrl-c of hQueryBrowser
  persistent run qg_QueryWindowCopyRecordValues in target-procedure
                       (hWindow).

on ' ':U of hQueryBrowser
  persistent run qg_QueryWindowEdit in target-procedure
                   (hQueryBrowser,
                    hBuffer,
                    {&K_EDITACTION_EDIT},
                    hWindow).

assign
  hFrame:hidden        = no
  hWindow:private-data = qg_cParamListWriteCharacter(hWindow:private-data,
                                                     'WindowTitle':U,
                                                     hWindow:title,
                                                     ',':U)
  hWindow:hidden       = no
  .

if gcIconDir = '':U then
  hWindow:load-icon('adeicon/startdbs.ico':U) no-error.

else
do:
  
  hWindow:load-icon(substitute('&1/32/table_go.ico':U,
                               gcIconDir)) no-error.
  
  hWindow:load-small-icon(substitute('&1/16/table_go.ico':U,
                                     gcIconDir)) no-error.
  
end. /* if gcIconDir = '':U */

if gcCursorHand > '':U then
  hToggleFieldBrowseButton:load-mouse-pointer(gcCursorHand).

hSplitterButton1:load-mouse-pointer ('SIZE-N':U).

apply 'window-resized':U to hWindow.

hFieldSelectionBrowse:query = hFieldSelectionQuery.
hFieldSelectionBrowse:add-like-column('ttField.FieldName':U).

if    not bttTable.DetailsLoaded then
  run qg_AddTableDetails(bttTable.DatabaseName,
                         bttTable.TableName).

create bttQueryWindow.

assign
  bttQueryWindow.WindowHandle                = hWindow
  bttQueryWindow.QuerySeq                    = piQuerySeq
  bttQueryWindow.QueryHandle                 = hQuery
  bttQueryWindow.QueryTextEditorHandle       = hQueryTextEditor
  bttQueryWindow.QueryBrowseHandle           = hQueryBrowser
  bttQueryWindow.FieldSelectionBrowseHandle  = hFieldSelectionBrowse
  bttQueryWindow.WindowTitle                 = cWindowTitle
  .

validate bttQueryWindow.

run qg_QueryWindowSetQueryText(hQueryTextEditor, pcQueryText).

hQueryBrowser:query = hQuery.
hQueryBrowser:add-columns-from(hBuffer).

apply 'choose' to hExecuteButton.
apply 'entry':U to hQueryTextEditor.

end procedure. /* qg_ExecQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExecRecentQuery hQueryWindow 
PROCEDURE qg_ExecRecentQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Execute a recent query.                                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcQueryText                    = Query text that should be executed.       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.
define input parameter pcQueryText as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

run qg_AddRecentQuery(bttQueryWindow.WindowHandle).

run qg_QueryWindowSetQueryText(bttQueryWindow.QueryTextEditorHandle,
                               pcQueryText).

run qg_QueryWindowExecute(bttQueryWindow.WindowHandle).

end procedure. /* qg_ExecRecentQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExecuteCommand hQueryWindow 
PROCEDURE qg_ExecuteCommand :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Execute command (used for Developer Studio interaction).                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcParamList                    PKS                                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcParamList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cCommand   as character no-undo.
define variable cTableName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for ttDatabase.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cCommand = qg_cParamListReadValue(pcParamList,
                                  'command':U,
                                  {&K_PARAM_SPLITTER}).

case cCommand:
  
  when 'insert_query':U then
    run qg_InsertQueryText.
  
  when 'insert_buffer_definition':U then
    run qg_InsertBufferDefinition.
  
  when 'insert_assign_statement':U then
    run qg_InsertFieldAssignStatement.
  
  when 'insert_field_assignment':U then
    run qg_InsertFieldAssigments.
  
  when 'select_table':U then
  do:
    
    cTableName = qg_cParamListReadValue(pcParamList,
                                        'table_name':U,
                                        {&K_PARAM_SPLITTER}).
    
    if cTableName > '':U then
    do:
      
      /* Make sure, that cache for all Databases is loaded. */
      
      for each bttDatabase
        where bttDatabase.PhysicalDB = yes
          and not can-find(first ttTable
                             where ttTable.DatabaseName = bttDatabase.DatabaseName)
        on error undo, throw:
        
        run qg_AddTables(bttDatabase.DatabaseName).
        
      end. /* for each bttDatabase */
      
      run qg_SelectTable(cTableName).
      
    end. /* if cTableName > '':U */
    
  end. /* when 'set_table':U */
  
end case. /* cCommand */

end procedure. /* qg_ExecuteCommand */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExportBrowse hQueryWindow 
PROCEDURE qg_ExportBrowse :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Export all records of the given browse query.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowse                       = browse that should be exported.           */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowse           as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                 as integer   no-undo.
define variable iRecordCount      as int64     no-undo.

define variable hQuery            as handle    no-undo.

define variable cColumnName       as character no-undo.
define variable hColumn           as handle    no-undo.
define variable hColumns          as handle    no-undo extent.
define variable cValue            as character no-undo.
define variable clLine            as longchar  no-undo.
define variable lFirstLine        as logical   no-undo init yes.
define variable lBuffername       as logical   no-undo.

define variable cAvailableColumns as character no-undo.

define variable rCurrentRecord    as rowid     no-undo extent.

define variable lExportToClipboard as logical   no-undo
  label '':U
  view-as radio-set
    radio-buttons 
      'Export to clipboard':T, yes,
      'Export to file':T, no
  size 40 by 2
  .

define variable cExportFilename as character no-undo
  label 'Export file':T
  format 'x(1024)':U
  view-as fill-in
  size 80 by 1.

define button btnFileDialog
  label '...':T
  size 7 by 1.

define variable cSelectedColumns as character no-undo
  label 'Columns':T
  format 'x(30000)':U
  view-as fill-in
  size 80 by 1
  .

define button btnColumns
  label '...':T
  size 7 by 1.

define variable cSeparator as character no-undo init ';':U
  label 'Separator':T
  format 'x(1)':U
  view-as fill-in
  size 5 by 1.

define variable lQuoteValues as logical   no-undo init yes
  label 'Quote values':T
  view-as toggle-box
  size 16 by 1
  .

define variable lExportHeader as logical   no-undo init yes
  label 'Header':T
  view-as toggle-box
  size 12 by 1.

define variable lLabelHeader as logical   no-undo
  label 'Header':T
  view-as radio-set horizontal expand
    radio-buttons
      'Labels':T, yes,
      'Fieldnames':T, no
      
    size 28 by 1
  .

define variable lIncludeBuffername as logical   no-undo
  label 'Include buffername':T
  view-as toggle-box
  size 25 by 1.

define button btnOk
  label 'Export':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fExport
  lExportToClipboard at row 1.5 col 12 colon-aligned no-label
  cExportFilename at row 4 col 12 colon-aligned
  btnFileDialog at row 4 col 92 colon-aligned
  cSelectedColumns at row 5.5 col 12 colon-aligned
  btnColumns at row 5.5 col 92 colon-aligned
  lExportHeader at row 7 col 12 colon-aligned
  lLabelHeader at row 7 col 30 colon-aligned no-label
  lIncludeBuffername at row 7 col 66 colon-aligned
  cSeparator at row 8.5 col 12 colon-aligned
  lQuoteValues at row 8.5 col 30 colon-aligned
  btnOk at row 10.5 col 31
  btnCancel at row 10.5 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 103 by 12.44
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fExport
  apply 'end-error' to self.

on value-changed of lExportToClipboard in frame fExport
do:
  
  assign
    lExportToClipboard                         = input frame fExport lExportToClipboard
    cExportFilename:sensitive in frame fExport = not lExportToClipboard /* code checked by mth 30.07.2015 */
    btnFileDialog:sensitive in frame fExport   = not lExportToClipboard /* code checked by mth 30.07.2015 */
    .
  
end. /* on value-changed of lExportToClipboard in frame fExport */

on choose of btnFileDialog in frame fExport
do:
  
  define variable lOk       as logical   no-undo.
  define variable cFilename as character no-undo.
  
  cFilename = input frame fExport cExportFilename.
  
  system-dialog get-file cFilename
    title             gcTitlePrefix + 'Save file as ...':U
    filters           'Comma-separated values (*.csv)':U '*.csv':U
    default-extension '.csv':U
    ask-overwrite
    save-as
    use-filename
    update lOk
    in window phBrowse:window
    .
    
  if lOk then
  do:
    
    cExportFilename = cFilename.
    
    display unless-hidden
      cExportFilename
      with frame fExport
        in window phBrowse:window.
    
  end. /* if lOk */
  
end. /* on choose of btnFileDialog in frame fExport */

on choose of btnColumns in frame fExport
do:
  
  run qg_SelectionDialog(cAvailableColumns,
                         input-output cSelectedColumns,
                         'Select columns':T,
                         phBrowse:window,
                         yes).
  
  display unless-hidden
    cSelectedColumns
    with frame fExport.
  
end. /* on choose of btnColumns in frame fExport */

on 'value-changed':U of lExportHeader in frame fExport
do:
  
  lLabelHeader:sensitive in frame fExport /* code checked by mth */
      = input frame fExport lExportHeader.
  
  apply 'value-changed':U to lLabelHeader in frame fExport.
  
end. /* on 'value-changed':U of lExportHeader in frame fExport */

on 'value-changed':U of lLabelHeader in frame fExport
  lIncludeBuffername:sensitive in frame fExport /* code checked by mth */
      =     input frame fExport lExportHeader
        and not input frame fExport lLabelHeader.

assign
  lBuffername        = (phBrowse:query:num-buffers > 1)
  cAvailableColumns  = qg_cBrowseColumnList(phBrowse,
                                            lBuffername,
                                            yes,
                                            no)
  cSelectedColumns   = qg_cBrowseColumnList(phBrowse,
                                            lBuffername,
                                            no,
                                            no)
  cExportFilename    = (if gcExportFilename > '':U then
                          gcExportFilename
                        else
                          substitute('&1\&2.csv':U,
                                     right-trim(right-trim(session:temp-directory, '\':U), '/':U),
                                     phBrowse:query:get-buffer-handle(1):name))
  .

assign
  frame fExport:title                         = gcTitlePrefix + 'Export records':U
  cSelectedColumns:read-only in frame fExport = yes
  .

update unless-hidden
  lExportToClipboard
  cExportFilename
  btnFileDialog
  cSelectedColumns
  btnColumns
  lExportHeader
  lLabelHeader
  lIncludeBuffername
  cSeparator
  lQuoteValues
  btnOk
  btnCancel
  with frame fExport
    in window phBrowse:window.

display unless-hidden
  'Exporting Browse lines ...':T
    @ gcStatusText60
  with frame fStatus
    no-labels
    overlay
    color messages
    centered
    view-as dialog-box
    width 65
    in window phBrowse:window
    .

process events.

/* Get all export columns */
extent(hColumns) = num-entries(cSelectedColumns).

do i = 1 to phBrowse:num-columns:
  
  assign
    hColumn     = phBrowse:get-browse-column(i)
    cColumnName = qg_cColumnFieldName(hColumn,
                                      lBuffername)
    .
  
  if lookup(cColumnName, cSelectedColumns) > 0 then
    hColumns[lookup(cColumnName, cSelectedColumns)] = hColumn.
  
end. /* do i = 1 to phBrowse:num-columns */

if lExportToClipboard then
  output stream strExport to 'clipboard':U.

else
  output stream strExport to value(cExportFilename).

clLine = '':U.

/* Expport header. */
if lExportHeader then
do:
  
  do i = 1 to extent(hColumns):
    
    assign
      cValue  = (if lLabelHeader then
                   hColumns[i]:label
                 else
                   qg_cColumnFieldName(hColumns[i],
                                       lIncludeBuffername))
      clLine  = substitute('&1&2&3':U,
                           clLine,
                           (if i = 1 then
                              '':U
                            else
                              cSeparator),
                           (if lQuoteValues then
                              quoter(cValue)
                            else
                              cValue))
      .
    
  end. /* do i = 1 to extent(hColumns) */
  
  clLine = substitute('&1~n':U,
                      clLine).
  
  run qg_WriteExportLine(clLine).
  
end. /* if lExportHeader */

/* Export browser content. */
hQuery = phBrowse:query.

extent(rCurrentRecord) = hQuery:num-buffers.

do i = 1 to hQuery:num-buffers:
  rCurrentRecord[i] = hQuery:get-buffer-handle(i):rowid.
end. 

hQuery:get-first().

do while not hQuery:query-off-end:
  
  assign
    iRecordCount = iRecordCount + 1
    clLine       = '':U
    .
  
  if iRecordCount mod 5000 = 0 then
  do:
    
    display unless-hidden
      substitute('Exporting Browse lines &1 ...':T,
                 trim(string(iRecordCount, {&K_MAX_INT64_FORMAT})))
        @ gcStatusText60
      with frame fStatus
        no-labels
        overlay
        color messages
        centered
        view-as dialog-box
        width 65
        in window phBrowse:window
        .
    
    process events.
    
  end. /* if iRecordCount mod 5000 = 0 */
  
  do i = 1 to extent(hColumns):
    
    assign
      cValue  = hColumns[i]:buffer-field:buffer-value(hColumns[i]:index)
      clLine  = substitute('&1&2&3':U,
                           clLine,
                           (if i = 1 then
                              '':U
                            else
                              cSeparator),
                           (if lQuoteValues then
                              quoter(cValue)
                            else
                              cValue))
    .
    
  end. /* do i = 1 to extent(hColumns) */
  
  if not lFirstLine then
    clLine     = substitute('~n&1':U,
                            clLine).
    
  else
    lFirstLine = no.
  
  run qg_WriteExportLine(clLine).
  
  hQuery:get-next().
  
end. /* do while not hQuery:query-off-end */

hide frame fStatus.

message /* code checked by mth */
  substitute('&1 records have been exported':T,
             iRecordCount) skip
  view-as alert-box
  information
  buttons ok
  in window phBrowse:window.

gcExportFilename = cExportFilename.

hQuery:reposition-to-rowid(rCurrentRecord).

finally:
  output stream strExport close.
end finally.
  
end procedure. /* qg_ExportBrowse */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_FillQueryRange hQueryWindow 
PROCEDURE qg_FillQueryRange :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set radio buttons for queryrange radio-set according to selected query     */
/* type.                                                                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabase     as character no-undo.
define variable cTable        as character no-undo.
define variable cIndex        as character no-undo.

define variable cFieldList    as character no-undo.

define variable i             as integer   no-undo.
define variable cRadioButtons as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cDatabase     = (if available ttDatabase then
                     ttDatabase.DatabaseName
                   else
                     '':U)
  cTable        = (if available ttTable then
                     ttTable.TableName
                   else
                     '':U)
  cIndex        = (if available(ttIndex) then
                     ttIndex.IndexName
                   else
                     '':U)
  giQueryType   = (if glSlimMode then
                     {&K_DEFAULT_QUERY_TYPE}
                   else
                     input frame {&FRAME-NAME} giQueryType)
  giDisplayMode = input frame {&FRAME-NAME} giDisplayMode
  cRadioButtons = giQueryRange:radio-buttons in frame {&FRAME-NAME}
  .

do i = giQueryRange:num-buttons in frame {&FRAME-NAME} to 1 by -1:
  giQueryRange:delete(entry(i * 2 - 1, cRadioButtons)) in frame {&FRAME-NAME}.
end. /* do i = num-entries(giQueryRange:num-items) to 1 by -1 */

case giQueryType:
  
  when {&K_QUERYTYPE_FINDFIRST} then
  do:
    
    giQueryRange:add-last('find':T, {&K_QUERYRANGE_DEFAULT}) in frame {&FRAME-NAME}.
    giQueryRange:add-last('find first':T, {&K_QUERYRANGE_FIRST}) in frame {&FRAME-NAME}.
    giQueryRange:add-last('find last':T, {&K_QUERYRANGE_LAST}) in frame {&FRAME-NAME}.
    
  end. /* {&K_QUERYTYPE_FINDFIRST} */
  
  when {&K_QUERYTYPE_FOREACH} then
  do:
    
    giQueryRange:add-last('for each':T, {&K_QUERYRANGE_DEFAULT}) in frame {&FRAME-NAME}.
    giQueryRange:add-last('for first':T, {&K_QUERYRANGE_FIRST}) in frame {&FRAME-NAME}.
    giQueryRange:add-last('for last':T, {&K_QUERYRANGE_LAST}) in frame {&FRAME-NAME}.
    
  end. /* {&K_QUERYTYPE_FOREACH} */
  
  when {&K_QUERYTYPE_CANFIND} then
  do:
    
    giQueryRange:add-last('can-find':T, {&K_QUERYRANGE_DEFAULT}) in frame {&FRAME-NAME}.
    giQueryRange:add-last('can-find first':T, {&K_QUERYRANGE_FIRST}) in frame {&FRAME-NAME}.
    giQueryRange:add-last('can-find last':T, {&K_QUERYRANGE_LAST}) in frame {&FRAME-NAME}.
    
  end. /* {&K_QUERYTYPE_CANFIND} */
  
end case. /* giQueryType */


if giDisplayMode = {&K_DISPLAYMODE_FIELD} then
  cFieldList = qg_cCurrentFieldList().

giQueryRange = ( if giQueryType = {&K_QUERYTYPE_FOREACH} then
                   {&K_QUERYRANGE_DEFAULT}
                 else
                   if (    giQueryType = {&K_QUERYTYPE_FINDFIRST}
                       and {&K_ALWAYS_USE_FIND_FIRST} )
                      or ( giQueryType = {&K_QUERYTYPE_CANFIND}
                       and {&K_ALWAYS_USE_CANFIND_FIRST} )
                      or ( giDisplayMode = {&K_DISPLAYMODE_FIELD}
                        and (num-entries(cFieldList) = 0
                          or not qg_lUniqueQuery(cDatabase,
                                                 cTable,
                                                 cFieldList)))
                      or (  giDisplayMode = {&K_DISPLAYMODE_INDEX}
                        and (not available ttIndex
                          or not ttIndex.IsUnique)) then
                     {&K_QUERYRANGE_FIRST}
                   else
                     {&K_QUERYRANGE_DEFAULT} ).

/* Display statement causes unexpected focus behaviour so just set
   screen-value instead. */
giQueryRange:screen-value in frame {&FRAME-NAME} = string(giQueryRange).
/*
display unless-hidden
  giQueryRange
  with frame {&FRAME-NAME}.
*/

end procedure. /* qg_FillQueryRange */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_FixCase hQueryWindow 
PROCEDURE qg_FixCase :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Fix case of content in given widget.                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWidget                       = Widget whose content should be fixed.     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWidget as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName as character no-undo.
define variable cTableName    as character no-undo.

define variable i                as integer   no-undo.
define variable j                as integer   no-undo.
define variable cWidgetValue           as character no-undo.
define variable cEntry           as character no-undo.
define variable lTempDB          as logical   no-undo.
define variable cChar            as character no-undo.
define variable cEntryPrefix     as character no-undo.
define variable cEntrySuffix     as character no-undo.
define variable cReferenceString as character no-undo.
define variable cNewEntry        as character no-undo.
define variable lQuotes          as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable for temp-table ttTable.
define buffer bttField for temp-table ttField.
define buffer bttIndex for temp-table ttIndex.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cWidgetValue  = phWidget:input-value
  cDatabaseName = (if available ttDatabase then
                     ttDatabase.DatabaseName
                   else
                     '':U)
  lTempDB       = (    available ttDatabase
                   and ttDatabase.TempDB)
  cTableName    = (if available ttTable then
                     ttTable.TableName
                   else
                     '':U)
  .

do i = 1 to num-entries(cWidgetValue):
  
  assign
    cEntry       = trim(entry(i, cWidgetValue))
    lQuotes      = (cWidgetValue matches '"*"':U)
    cEntryPrefix = '':U
    cEntrySuffix = '':U
    .
  
  if lQuotes then
    cEntry = trim(cEntry, '"':U).
  
  else
  do:
    
    /* Extract prefix. */
    j = 1.
    
    do while j <= length(cEntry):
      
      cChar = substring(cEntry, j, 1).
      
      if   cChar = '*':U
        or cChar = '.':U
        or cChar = '!':U then
        cEntryPrefix = cEntryPrefix + cChar.
      
      else
        leave.
      
      j = j + 1.
      
    end. /* do while yes */
    
    cEntry = substring(cEntry, length(cEntryPrefix) + 1).
    
    /* Extract suffix. */
    j = length(cEntry).
    
    do while j >= 1:
      
      cChar = substring(cEntry, j, 1).
      
      if   cChar = '*':U
        or cChar = '.':U
        or cChar = '!':U then
        cEntrySuffix = cEntrySuffix + cChar.
      
      else
        leave.
      
      j = j - 1.
      
    end. /* do while yes */
    
    cEntry = substring(cEntry, 1, length(cEntry) - length(cEntrySuffix)).
    
  end. /* if lQuotes */
  
  /* If entry contains wildcards do nothing. */
  if   length(cEntry)       = 0
    or index(cEntry, '*':U) > 0
    or index(cEntry, '.':U) > 0
    or index(cEntry, '!':U) > 0 then
    next.
  
  cReferenceString = '':U.
  
  case phWidget:name:
    
    when 'gcTableFilter':U then
    do:
      
      do j = 0 to integer(lTempDB):
        
        if    j = 1
          and cEntry begins 'tt':U then
          cEntry = substitute('td&1':U, substring(cEntry, 3)).
        
        find first bttTable
          where bttTable.DatabaseName = cDatabaseName
            and bttTable.TableName    = cEntry
          no-error.
        
        if not lQuotes then
        do:
          
          if not available bttTable then
            find first bttTable
              where bttTable.DatabaseName   = cDatabaseName
                and bttTable.TableName begins cEntry
              no-error.
          
          if not available bttTable then
            find first bttTable
              where bttTable.DatabaseName    = cDatabaseName
                and bttTable.TableName matches substitute('*&1*':U, cEntry)
                no-error.
          
        end. /* if not lQuotes */
        
        if available bttTable then
          leave.
        
      end. /* do j = 0 to integer(lTempDB) */
      
      if available bttTable then
        cReferenceString = bttTable.TableName.
        
      
    end. /* when 'gcTableFilter':U */
    
    when 'gcTableFieldFilter':U then
    do:
      
      find first bttField
        where bttField.DatabaseName = cDatabaseName
          and bttField.FieldName    = cEntry
        no-error.
      
      if not lQuotes then
      do:
        
        if not available bttField then
          find first bttField
            where bttField.DatabaseName   = cDatabaseName
              and bttField.FieldName begins cEntry
            no-error.
        
        if not available bttField then
          find first bttField
            where bttField.DatabaseName    = cDatabaseName
              and bttField.FieldName matches substitute('*&1*':U, cEntry)
              no-error.
        
      end. /* if not lQuotes */
      
      if available bttField then
        cReferenceString = bttField.FieldName.
      
    end. /* when 'gcTableFieldFilter':U */
    
    when 'gcFieldFilter':U
      or when 'gcIndexFieldFilter':U then
    do:
      
      find first bttField
        where bttField.DatabaseName = cDatabaseName
          and bttField.TableName    = cTableName
          and bttField.FieldName    = cEntry
        no-error.
      
      if not lQuotes then
      do:
        
        if not available bttField then
          find first bttField
            where bttField.DatabaseName   = cDatabaseName
              and bttField.TableName      = cTableName
              and bttField.FieldName begins cEntry
            no-error.
        
        if not available bttField then
          find first bttField
            where bttField.DatabaseName    = cDatabaseName
              and bttField.TableName       = cTableName
              and bttField.FieldName matches substitute('*&1*':U, cEntry)
              no-error.
        
      end. /* if not lQuotes */
      
      if available bttField then
        cReferenceString = bttField.FieldName.
      
    end. /* when 'gcFieldFilter':U */
    
    when 'gcFieldLabelFilter':U then
    do:
      
      find first bttField
        where bttField.DatabaseName = cDatabaseName
          and bttField.TableName    = cTableName
          and bttField.FieldLabel   = cEntry
        no-error.
      
      if not lQuotes then
      do:
        
        if not available bttField then
          find first bttField
            where bttField.DatabaseName    = cDatabaseName
              and bttField.TableName       = cTableName
              and bttField.FieldLabel begins cEntry
            no-error.
        
        if not available bttField then
          find first bttField
            where bttField.DatabaseName     = cDatabaseName
              and bttField.TableName        = cTableName
              and bttField.FieldLabel matches substitute('*&1*':U, cEntry)
              no-error.
        
      end. /* if not lQuotes */
      
      if available bttField then
        cReferenceString = bttField.FieldLabel.
      
    end. /* when 'gcFieldLabelFilter':U */
    
    when 'gcIndexFilter':U then
    do:
      
      find first bttIndex
        where bttIndex.DatabaseName = cDatabaseName
          and bttIndex.TableName    = cTableName
          and bttIndex.IndexName    = cEntry
        no-error.
      
      if not lQuotes then
      do:
        
        if not available bttIndex then
          find first bttIndex
            where bttIndex.DatabaseName   = cDatabaseName
              and bttIndex.TableName      = cTableName
              and bttIndex.IndexName begins cEntry
            no-error.
        
        if not available bttIndex then
          find first bttIndex
            where bttIndex.DatabaseName    = cDatabaseName
              and bttIndex.TableName       = cTableName
              and bttIndex.IndexName matches substitute('*&1*':U, cEntry)
              no-error.
        
      end. /* if not lQuotes */
      
      if available bttIndex then
        cReferenceString = bttIndex.IndexName.
      
    end. /* when 'gcIndexFilter':U */
    
  end case. /* phWidget */
  
  if cReferenceString > '':U then
    assign
      cNewEntry              = substring(cReferenceString,
                                         index(cReferenceString, cEntry),
                                         length(cEntry))
      entry(i, cWidgetValue) = (if lQuotes then
                                  quoter(cNewEntry)
                                else
                                  substitute('&1&2&3':U,
                                             cEntryPrefix,
                                             cNewEntry,
                                             cEntrySuffix))
        .
  
end. /* do i = 1 to num-entries(cWidgetValue) */

phWidget:screen-value = cWidgetValue.

end procedure. /* qg_FixCase */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetEditorSelectionInfo hQueryWindow 
PROCEDURE qg_GetEditorSelectionInfo :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Write given string to the export file.                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* Stream strExport must be open before you call this procedure.              */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pclLine                        = Text line that should be written.         */
/* opiSelectionStart              = Selection Start.                          */
/* opiSelectionEnd                = Selection End.                            */
/* opiSelectionStartLine          = Line number of selection start.           */
/* opiSelectionEndLine            = Line number of selection end.             */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter phEditor              as handle    no-undo.

define output parameter opiSelectionStart     as integer   no-undo.
define output parameter opiSelectionEnd       as integer   no-undo.
define output parameter opiSelectionStartLine as integer   no-undo.
define output parameter opiSelectionEndLine   as integer   no-undo.


/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cEditorText         as character no-undo.
define variable cLine               as character no-undo.

define variable i                   as integer   no-undo.
define variable iOffset             as integer   no-undo.
define variable iLength             as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cEditorText           = phEditor:input-value
  opiSelectionStart     = (if phEditor:selection-start = ? then
                             phEditor:cursor-offset
                           else
                             phEditor:selection-start)
  opiSelectionEnd       = (if phEditor:selection-end = ? then
                             phEditor:cursor-offset
                           else
                             phEditor:selection-end - 1)
  .

do i = 1 to num-entries(cEditorText, '~n':U):
  
  assign
    cLine   = entry(i, cEditorText, '~n':U)
    iLength = length(cLine)
    iOffset = phEditor:convert-to-offset(i, 1)
    .
  
  if    iOffset           <= opiSelectionStart
    and iOffset + iLength >= opiSelectionStart then
    opiSelectionStartLine = i.
  
  if    iOffset           <= opiSelectionEnd
    and iOffset + iLength >= opiSelectionEnd then
    opiSelectionEndLine = i.
  
end. /* do i = 1 to num-entries(cEditorText, '~n':U) */

end procedure. /* qg_GetEditorSelectionInfo */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetExternalReference hQueryWindow 
PROCEDURE qg_GetExternalReference :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show selection dialog for external reference.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* pcTableName                    = Table name for reference suggestion.      */
/* pcFieldName                    = Field name for reference suggestion.      */
/* plFieldReference               = Flag to indicate wether a field reference */
/*                                  or a table refenece should be entered.    */
/* pcQueryWindowList              = List of query windows that may be used as */
/*                                  Reference source.                         */
/* phParentWindow                 = Parent window for the dialog.             */
/* opcReferenceText               = contains the selected external reference. */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter pcTableName       as character no-undo.
define input  parameter pcFieldName       as character no-undo.
define input  parameter plFieldReference  as logical   no-undo.
define input  parameter pcQueryWindowList as character no-undo.
define input  parameter phParentWindow    as handle    no-undo.
define output parameter opcReferenceText  as character no-undo init ?.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                    as integer   no-undo.
define variable hField               as handle    no-undo.
define variable cTableSoundex        as character no-undo.
define variable cQueryBufferSoundex  as character no-undo.
define variable rQueryBuffer         as rowid     no-undo extent 8.

define variable lRecidReference as logical no-undo init yes
  view-as radio-set
    horizontal expand
    radio-buttons
      'Recid':U, yes,
      'rowid':U, no
    size 30 by 1.

define query brQueryBufferBrowse
  for ttQueryBuffer
  scrolling.

define browse brQueryBufferBrowse
  query brQueryBufferBrowse no-lock
    display
      ttQueryBuffer.QuerySeq
      ttQueryBuffer.BufferName
      with no-assign size 70 by 17 no-empty-space.

define query brQueryBufferFieldBrowse
  for ttQueryBufferField
  scrolling.

define browse brQueryBufferFieldBrowse
  query brQueryBufferFieldBrowse no-lock
    display
      ttQueryBufferField.DisplayName
      with no-assign size 70 by 18.5 no-empty-space.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttQueryBuffer for temp-table ttQueryBuffer.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fSelectExternalReference
  lRecidReference at row 1.5 col 3 no-label
  brQueryBufferBrowse at row 3 col 3
  brQueryBufferFieldBrowse at row 1.5 col 75
  btnOk at row 20.5 col 54
  btnCancel at row 20.5 col 74
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 147 by 22.44
    title gcTitlePrefix + 'Select external buffer field':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectExternalReference
  apply 'end-error' to self.

on 'value-changed':U of brQueryBufferBrowse in frame fSelectExternalReference
do:
  
  define variable hBufferfield as handle    no-undo.
  define variable i            as integer   no-undo.
  define variable j            as integer   no-undo.
  
  define variable rMatch       as rowid     no-undo extent 4.
  
  define buffer bttQueryBufferField for temp-table ttQueryBufferField.
  
  if not plFieldReference then
    leave.
  
  empty temp-table ttQueryBufferField.
  
  if available ttQueryBuffer then
  do:
    
    do i = 1 to ttQueryBuffer.BufferHandle:num-fields:
      
      hBufferField = ttQueryBuffer.BufferHandle:buffer-field(i).
      
      do j = integer(hBufferField:extent > 0) to hBufferField:extent:
        
        create bttQueryBufferField.
        
        assign
          bttQueryBufferField.FieldHandle = hBufferField
          bttQueryBufferField.FieldName   = bttQueryBufferField.FieldHandle:name
          bttQueryBufferField.FieldIndex  = j
          bttQueryBufferField.DisplayName = substitute('&1&2':U,
                                                       bttQueryBufferField.FieldName,
                                                       (if j = 0 then
                                                          '':U
                                                        else
                                                          substitute('[&1]':U,
                                                                     string(bttQueryBufferField.FieldIndex))))
          .
        
        validate bttQueryBufferField.
        
        if pcFieldName > '':U then
        do:
          
          if    rMatch[1]                     = ?
            and bttQueryBufferField.FieldName = pcFieldName then
            rMatch[1] = rowid(bttQueryBufferField).
          
          else if rMatch[2]                          = ?
            and   bttQueryBufferField.FieldName begins pcFieldName then
            rMatch[2] = rowid(bttQueryBufferField).
          
          else if rMatch[3]                           = ?
            and   pcFieldName                    matches '*_Obj':U
            and   bttQueryBufferField.FieldName       = substitute('&1_Obj':U,
                                                                   ttQueryBuffer.BufferHandle:table) then
            rMatch[3] = rowid(bttQueryBufferField).
          
          else if rMatch[4]                           = ?
            and   pcFieldName                    matches '*_Obj':U
            and   bttQueryBufferField.FieldName matches '*_Obj':U then
            rMatch[4] = rowid(bttQueryBufferField).
          
        end. /* if pcFieldName > '':U */
        
      end. /* do j = integer(hBufferField:extent > 0) to hBufferField:extent */
      
    end. /* do i = 1 to ttQueryBuffer.BufferHandle:num-fields */
          
  end. /* if available ttQueryBuffer */
  
  open query brQueryBufferFieldBrowse
    for each ttQueryBufferField
      no-lock.
  
  do i = 1 to extent(rMatch):
    
    if rMatch[i] <> ? then
    do:
      reposition brQueryBufferFieldBrowse to rowid rMatch[i] no-error.
      leave.
    end. /* if rMatch[i] <> ? */
    
  end. /* do i = 1 to extent(rMatch) */
  
end. /* on 'value-changed':U of brQueryBufferBrowse in frame fSelectExternalReference */

on 'default-action':U of brQueryBufferBrowse in frame fSelectExternalReference
do:
  
  if not plFieldReference then
    apply 'go':U to frame fSelectExternalReference.
  
end. /* on 'default-action':U of brQueryBufferBrowse in frame fSelectExternalReference */

on 'default-action':U of brQueryBufferFieldBrowse in frame fSelectExternalReference
  apply 'go':U to frame fSelectExternalReference.

empty temp-table ttQueryBuffer.

for each bttQueryWindow
  on error undo, throw:
  
  if    not valid-handle(bttQueryWindow.WindowHandle)
     or not can-do(pcQueryWindowList, string(bttQueryWindow.WindowHandle)) then
    next.
  
  do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
    
    create bttQueryBuffer.
    
    assign
      bttQueryBuffer.QuerySeq     = bttQueryWindow.QuerySeq
      bttQueryBuffer.BufferHandle = bttQueryWindow.QueryHandle:get-buffer-handle(i)
      bttQueryBuffer.BufferName   = bttQueryBuffer.BufferHandle:name
      .
    
  end. /* do i = 1 to bttQueryWindow.QueryHandle:num-buffers */
  
end. /* for each bttQueryWindow */

/* If no buffers are available nothing has to be done. */
if not can-find(first bttQueryBuffer) then
  leave.

if not plFieldReference then
  assign
    brQueryBufferFieldBrowse:hidden in frame fSelectExternalReference
        = yes
    brQueryBufferBrowse:height in frame fSelectExternalReference
        = brQueryBufferBrowse:height in frame fSelectExternalReference - 5
    frame fSelectExternalReference:width
        = frame fSelectExternalReference:width - 72
    frame fSelectExternalReference:virtual-width
        = frame fSelectExternalReference:virtual-width - 72
    frame fSelectExternalReference:height
        = frame fSelectExternalReference:height - 5
    frame fSelectExternalReference:virtual-height
        = frame fSelectExternalReference:virtual-height - 5
    frame fSelectExternalReference:title
        = gcTitlePrefix + 'Select external buffer':T
    btnOk:col in frame fSelectExternalReference
        = btnOk:col in frame fSelectExternalReference - 36
    btnOk:row in frame fSelectExternalReference
        = btnOk:row in frame fSelectExternalReference - 5
    btnCancel:col in frame fSelectExternalReference
        = btnCancel:col in frame fSelectExternalReference - 36
    btnCancel:row in frame fSelectExternalReference
        = btnCancel:row in frame fSelectExternalReference - 5
    .

else
do:
  
  assign
    lRecidReference:hidden in frame fSelectExternalReference
        = yes
    brQueryBufferBrowse:row in frame fSelectExternalReference
        = brQueryBufferBrowse:row in frame fSelectExternalReference - 1.5
    brQueryBufferBrowse:height in frame fSelectExternalReference
        = brQueryBufferBrowse:height in frame fSelectExternalReference + 1.5
    .
  
  /* Find first table with matching field. */
  
  if pcFieldName > '':U then
  do:
    
    cTableSoundex = qg_cSoundexCode(pcTableName).
    
    QueryBuffer:
    for each bttQueryBuffer
      on error undo, throw:
      
      hField = bttQueryBuffer.BufferHandle:buffer-field(pcFieldName) no-error.
      
      if not valid-handle(hField) then
        next QueryBuffer.
      
      cQueryBufferSoundex = qg_cSoundexCode(bttQueryBuffer.BufferHandle:table).
      
      /* Try different things to match table name. */
      if    rQueryBuffer[1] = ?
        and bttQueryBuffer.BufferHandle:table begins pcTableName then
        rQueryBuffer[1] = rowid(bttQueryBuffer).
    
      if    rQueryBuffer[2] = ?
        and cTableSoundex   = cQueryBufferSoundex then
        rQueryBuffer[2] = rowid(bttQueryBuffer).
    
      if    rQueryBuffer[3] = ?
        and bttQueryBuffer.BufferHandle:table matches substitute('*&1*':U, substring(pcTableName, index(pcTableName, '_':U) + 1)) then
        rQueryBuffer[3] = rowid(bttQueryBuffer).
    
      if    rQueryBuffer[4] = ?
        and cTableSoundex begins substring(cQueryBufferSoundex, 1, 3) then
        rQueryBuffer[4] = rowid(bttQueryBuffer).
    
      if    rQueryBuffer[5] = ?
        and bttQueryBuffer.BufferHandle:table matches substitute('*&1*':U, pcTableName) then
        rQueryBuffer[5] = rowid(bttQueryBuffer).
    
      if    rQueryBuffer[6] = ?
        and cTableSoundex begins substring(cQueryBufferSoundex, 1, 2) then
        rQueryBuffer[6] = rowid(bttQueryBuffer).
    
      if    rQueryBuffer[7] = ?
        and cTableSoundex begins substring(cQueryBufferSoundex, 1, 1) then
        rQueryBuffer[7] = rowid(bttQueryBuffer).
        
      if rQueryBuffer[8] = ? then
        rQueryBuffer[8] = rowid(bttQueryBuffer).
        
    end. /* bttQueryBuffer */
    
  end. /* if pcFieldName > '':U */
  
end. /* if not plFieldReference */

run qg_InitBrowse(browse brQueryBufferBrowse:handle).
run qg_InitBrowse(browse brQueryBufferFieldBrowse:handle).

display unless-hidden
  brQueryBufferBrowse
  with frame fSelectExternalReference
    in window phParentWindow. 

open query brQueryBufferBrowse
  for each ttQueryBuffer
    no-lock.

if plFieldReference then
do:
  
  do i = 1 to extent(rQueryBuffer):
    
    if rQueryBuffer[i] <> ? then
    do:
      reposition brQueryBufferBrowse to rowid rQueryBuffer[i] no-error.
      leave.
    end. /* if rQueryBuffer <> ? */
    
  end. /* do i = 1 to extent(rQueryBuffer) */
  
end. /* if plFieldReference */

apply 'value-changed':U to brQueryBufferBrowse in frame fSelectExternalReference.

update unless-hidden
  lRecidReference
  brQueryBufferBrowse
  brQueryBufferFieldBrowse
  btnOk
  btnCancel
  with frame fSelectExternalReference
    in window phParentWindow. 

if available ttQueryBuffer then
  opcReferenceText = (if plFieldReference then
                        substitute('$~{&1:&2.&3&4~}':U,
                                   string(ttQueryBuffer.QuerySeq),
                                          ttQueryBuffer.BufferName,
                                          ttQueryBufferField.FieldName,
                                          (if ttQueryBufferField.FieldIndex > 0 then
                                             substitute('[&1]':U,
                                                        string(ttQueryBufferField.FieldIndex))
                                           else
                                             '':U))
                      else
                        if lRecidReference then
                                    substitute('$~{&1:recid(&2)~}':U,
                                               ttQueryBuffer.QuerySeq,
                                               ttQueryBuffer.BufferName)
                      else
                        substitute('$~{&1:rowid(&2)~}':U,
                                             ttQueryBuffer.QuerySeq,
                                             ttQueryBuffer.BufferName)).

end procedure. /* qg_GetExternalReference */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetOffsetLine hQueryWindow 
PROCEDURE qg_GetOffsetLine :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Get line number for given offset.                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcText                         = Text that contains the line.              */
/* piOffset                       = Offset for which the line number should   */
/*                                  be determined.                            */
/* opiLine                        = Line number of offset.                    */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter pcText   as character no-undo.
define input  parameter piOffset as integer   no-undo extent.
define output parameter opiLine  as integer   no-undo extent.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i           as integer   no-undo.
define variable j           as integer   no-undo.

define variable iLineLength as integer   no-undo.
define variable iOffset     as integer   no-undo init 1.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

extent(opiLine) = extent(piOffset).

do i = 1 to num-entries(pcText, '~n':U):
  
  iLineLength = length(entry(i, pcText, '~n':U)).
  
  do j = 1 to extent(piOffset):
    
    if    piOffset[j] >= iOffset
      and piOffset[j]  < iOffset + iLineLength + length('~n':U) then
      opiLine[j] = i.
    
  end. /*do j = 1 to extent(piOffset)  */
  
  iOffset = iOffset + iLineLength + length('~n':U).
  
end. /* do i = 1 to num-entries(pcText) */

end procedure. /* qg_GetOffsetLine */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetWindowRect hQueryWindow 
PROCEDURE qg_GetWindowRect :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Get screen rectangle of window.                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window handle.                            */
/* opiWindowX1                    = X1 coordinate of window.                  */
/* opiWindowY1                    = Y1 coordinate of window.                  */
/* opiWindowX2                    = X2 coordinate of window.                  */
/* opiWindowY2                    = Y2 coordinate of window.                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter phWindow       as handle    no-undo.

define output parameter opiWindowX1 as integer   no-undo.
define output parameter opiWindowY1 as integer   no-undo.
define output parameter opiWindowX2 as integer   no-undo.
define output parameter opiWindowY2 as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iHwnd                 as integer no-undo.
define variable mRect                 as memptr no-undo.
define variable iResult               as integer no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if phWindow:type = 'DIALOG-BOX':U then
  iHwnd = phWindow:hwnd.

else
  run GetParent(phWindow:hwnd,
                output iHwnd).

if iHwnd <> 0 then
do:

  set-size(mRect) = 16.
  
  run GetWindowRect(iHwnd,
                    output mRect,
                    output iResult).
  
  assign
    opiWindowX1 = get-long(mRect, 1)
    opiWindowY1 = get-long(mRect, 5)
    opiWindowX2 = get-long(mRect, 9)
    opiWindowY2 = get-long(mRect, 13)
    .
  
end. /* if iHwnd <> 0 */

end procedure. /* qg_GetWindowRect */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_IDE_InsertText hQueryWindow 
PROCEDURE qg_IDE_InsertText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert given text into ide editor.                                         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcText                         = Text that should be inserted.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcText as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cReturnValue     as character no-undo.

define variable iIDEWindowHandle as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if (    OEIDEIsRunning
    and glIDECanInsert
    and glInsertMode) then
do:
  
  run qg_IDE_SendRequest({&K_EDITOR_INSERT_REQUEST_HANDLER},
                         pcText,
                         output cReturnValue).
  
  if cReturnValue <> ? then
  do:
    
    iIDEWindowHandle = qg_iParamListReadValue(cReturnValue,
                                              'IDEWindowHandle':U,
                                              {&K_PARAM_SPLITTER}).
    
    if iIDEWindowHandle > 0 then
      run SetForegroundWindow(iIDEWindowHandle).
    
  end. /* if cReturnValue <> ? */
  
end. /* if (    OEIDEIsRunning ... */

end procedure. /* qg_IDE_InsertText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_IDE_SendRequest hQueryWindow 
PROCEDURE qg_IDE_SendRequest :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Send given Reqest to ide.                                                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* This has to be a procedure (may not be a function) due to progress error   */
/* 2780.                                                                      */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcHandlerName                  = Name of the request handler for the re-   */
/*                                  quest that should be sent.                */
/* pcParmeter                     = String parameter value for the request.   */
/* opcReturnValue                 = Output return value.                      */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter pcHandlerName  as character no-undo.
define input  parameter pcParameter    as character no-undo.
define output parameter opcReturnValue as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hSocketClient as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if   not OEIDEIsRunning
  or not valid-handle(hOEIDEService) then
  return ?.

hSocketClient = dynamic-function ('getSocketClient':U in hOEIDEService).

if valid-handle(hSocketClient) then
  run SendWaitRequest in hSocketClient (qg_iGetHandlerId(pcHandlerName),
                                        pcParameter,
                                        output opcReturnValue).

end procedure. /* qg_IDE_SendRequest */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InitBrowse hQueryWindow 
PROCEDURE qg_InitBrowse :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Init given Browse (set properties, add popup menu items ...)               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowse                       = Browse that should be initialized.        */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowse as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hPopupMenu as handle    no-undo.
define variable hDummy     as handle    no-undo.
define variable lPrevMenu  as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  phBrowse:sensitive        = yes /* code checked by mth */
  phBrowse:column-resizable = yes
  phBrowse:column-movable   = yes
  phBrowse:separators       = {&K_SHOW_GRID_ON_BROWSE}
  .

hPopupMenu = phBrowse:popup-menu.

if not valid-handle(hPopupMenu) then
  create menu hPopupMenu
    assign
      name       = 'm_PopupMenu':U
      popup-only = yes
      sensitive  = yes
      .

else
  lPrevMenu = yes.

if   phBrowse:name = 'brQuery':U 
  or {&K_SELECT_COLUMN_ON_BROWSE}
  or {&K_EXPORT_ON_BROWSE}
  or {&K_RECORD_COUNT_ON_BROWSE} then
do:
  
  if lPrevMenu then
    create menu-item hDummy
      assign
        subtype = 'RULE':U
        parent  = hPopupMenu
        .
  
  if   phBrowse:name = 'brQuery':U
    or {&K_SELECT_COLUMN_ON_BROWSE} then
    create menu-item hDummy
      assign
        name         = 'mi_SelectColumnsMenuItem':U
        parent       = hPopupMenu
        label        = 'Select columns':T
        sensitive    = yes
      triggers:
        on choose
          persistent run qg_SelectBrowseColumns in target-procedure
                           (phBrowse).
      end triggers
      .
  
  if   phBrowse:name = 'brQuery':U
    or {&K_EXPORT_ON_BROWSE} then
    create menu-item hDummy
      assign
        name         = 'mi_Export':U
        parent       = hPopupMenu
        label        = 'Export records':T
        sensitive    = yes
      triggers:
        on choose
          persistent run qg_ExportBrowse in target-procedure
                           (phBrowse).
      end triggers
      .
  
  if   phBrowse:name = 'brQuery':U
    or {&K_RECORD_COUNT_ON_BROWSE} then
    create menu-item hDummy
      assign
        name         = 'mi_RecordCount':U
        parent       = hPopupMenu
        label        = 'Record count':T
        sensitive    = yes
      triggers:
        on choose
          persistent run qg_ShowBrowseRecordCount in target-procedure
                           (phBrowse).
      end triggers
      .
  
  lPrevMenu = yes.
  
end. /* if   {&K_SELECT_COLUMN_ON_BROWSE} */

if   {&K_TOGGLE_GRID_ON_BROWSE}
  or phBrowse:name = 'brQuery':U then
do:
  
  if lPrevMenu then
    create menu-item hDummy
      assign
        subtype = 'RULE':U
        parent  = hPopupMenu
        .
  
  create menu-item hDummy
    assign
      name        = 'mi_ShowGrid':U
      label       = 'Show grid':T
      toggle-box  = yes
      checked     = {&K_SHOW_GRID_ON_BROWSE}
      sensitive   = yes
      parent      = hPopupMenu
    triggers:
      on value-changed
        persistent run qg_ShowBrowseGrid in target-procedure
                         (phBrowse, hDummy).
    end triggers
    .
  
  lPrevMenu = yes.
  
end. /* if {&K_TOGGLE_GRID_ON_BROWSE} */

phBrowse:popup-menu = hPopupMenu.

on ctrl-l of phBrowse
  persistent run qg_SelectBrowseColumns in target-procedure
                   (phBrowse).

on ctrl-e of phBrowse
  persistent run qg_ExportBrowse in target-procedure
                   (phBrowse).

on ctrl-r of phBrowse
  persistent run qg_ShowBrowseRecordCount in target-procedure
                   (phBrowse).

end procedure. /* qg_InitBrowse */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_Initialize hQueryWindow 
PROCEDURE qg_Initialize :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Initialize.                                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cSessionTitle    as character no-undo init ?.
define variable cProcName        as character no-undo.

define variable cEnvironment     as character no-undo.
define variable oDCCAppConfigSvc as class Progress.Lang.Object no-undo.

define variable iStrSize         as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cProcName           = replace(this-procedure:name, '\':U, '/':U)
  file-info:file-name = substitute('&1/../icons':U, cProcName)
  .

if file-info:full-pathname = ? then
  file-info:file-name = substitute('&1/../../icons':U, cProcName).

if file-info:full-pathname > '':U then
  gcIconDir = file-info:full-pathname.

if gcIconDir = '':U then
  hQueryWindow:load-icon(substitute('adeicon/sqlexp.ico':U)) no-error.

else
do:
  
  hQueryWindow:load-icon(substitute('&1/32/query_wizard.ico':U,
                                      gcIconDir)) no-error.
  
  hQueryWindow:load-small-icon(substitute('&1/16/query_wizard.ico':U,
                                          gcIconDir)) no-error.
  
end. /* if gcIconDir = '':U */

gcCursorHand = qg_cReadRegistryValue({&K_WIN_CONST_HKEY_CURRENT_USER},
                                     'Control Panel\Cursors':U,
                                     'Hand':U).

if gcCursorHand > '':U then
  run ExpandEnvironmentStringsA(gcCursorHand,
                                output gcCursorHand,
                                length(gcCursorHand),
                                output iStrSize).

if OEIDEIsRunning then
  gcIDEProjectName = getProjectName().

/* Try to get the session title. */
&IF keyword-all('dynamic-property':U) <> ? &THEN
  
  cSessionTitle = dynamic-property('pACConnectionSvc':U,
                                   'prpcSessionTitle':U) no-error.
  
  &IF   keyword-all('dynamic-invoke':U) <> ?
    and keyword-all('valid-object':U)   <> ? &THEN
    
    if   cSessionTitle       = ?
      or trim(cSessionTitle) = '':U then
    do:
      
      cEnvironment = dynamic-invoke('pACStartupSvc',
                                    'cParameterValue':U,
                                    'Environment':U) no-error.
      
      if    not error-status:error
        and cEnvironment > '':U then
      do:
        
        oDCCAppConfigSvc = dynamic-property('adm.config.cls.DCCAppConfigSvc', 'prpoInstance') no-error.
        
        if    not error-status:error
          and valid-object(oDCCAppConfigSvc) then
        do:
        
          cSessionTitle = trim(dynamic-invoke(oDCCAppConfigSvc,
                                              'cParamValByRefParamVal':U,
                                              'DB_Environment_desc':U,
                                              cEnvironment)) no-error.
          
        end. /* if    not error-status:error */
        
      end. /* if    not error-status:error */
      
    &ENDIF
    
  end. /* if   cSessionTitle       = ? */
  
&ENDIF

if cSessionTitle = ? then
  cSessionTitle = dynamic-function('pa_cConfgParameterValue':U in target-procedure,
                                   'SessionTitle':U) no-error.

if cSessionTitle > '':U then
  gcTitlePrefix = substitute('&1 - ':U,
                             cSessionTitle).

else if gcIDEProjectName > '':U then
  gcTitlePrefix = substitute('&1 - ':U,
                             gcIDEProjectName).

hQueryWindow:title = trim(substitute('&1Query Generator v&2':U,
                                     gcTitlePrefix,
                                     {&K_Version})).

menu-item mi_OpenQueryWindowPersistentTT:checked in menu m_Options = yes.

run qg_InitBrowse(browse brDatabase:handle).
run qg_InitBrowse(browse brTable:handle).
run qg_InitBrowse(browse brIndex:handle).
run qg_InitBrowse(browse brField:handle).

if {&K_HIDE_QUERYRANGE} then
  giQueryRange:hidden in frame {&FRAME-NAME} = yes. 

run qg_SetDefaultValues.

assign
  glSessionTriggerShowMessage = {&K_SESSIONTRIGGER_SHOWMESSAGE} 
  glSessionTriggerWriteLog    = {&K_SESSIONTRIGGER_WRITELOG} 
  gcSessionTriggerLogFileName = {&K_SESSIONTRIGGER_LOGFILENAME} 
  glSessionTriggerIndexValues = {&K_SESSIONTRIGGER_INDEXVALUES} 
  glSessionTriggerStackTrace  = {&K_SESSIONTRIGGER_STACKTRACE} 
  .

if gcSessionTriggerLogFileName = '':U then
  gcSessionTriggerLogFileName = substitute('&1\session-triggers.log':U,
                                           trim(session:temp-dir, '/\':U)).

/* Assign buffer prefix button labels. */

assign
  glCompanyViaClass:label in frame {&FRAME-NAME} = '{&K_CLASS_COMPANY_STATEMENT}':U
  btnBuffer1:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_1}, '#':U, '':U)
  btnBuffer1:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_1} = '':U)
  btnBuffer2:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_2}, '#':U, '':U)
  btnBuffer2:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_2} = '':U)
  btnBuffer3:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_3}, '#':U, '':U)
  btnBuffer3:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_3} = '':U)
  btnBuffer4:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_4}, '#':U, '':U)
  btnBuffer4:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_4} = '':U)
  btnBlock1:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_1}
  btnBlock1:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_1} = '':U)
  btnBlock2:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_2}
  btnBlock2:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_2} = '':U)
  btnBlock3:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_3}
  btnBlock3:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_3} = '':U)
  btnBlock4:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_4}
  btnBlock4:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_4} = '':U)
  .

&IF {&K_NUM_BUFFER_PATTERN_INDICES} > 0 &THEN

  run qg_CreateBufferButtonMenu(btnBuffer1:handle,
                                {&K_BUFFER_PATTERN_1},
                                {&K_BUFFER_PATTERN_LABEL_1}).
  
  run qg_CreateBufferButtonMenu(btnBuffer2:handle,
                                {&K_BUFFER_PATTERN_2},
                                {&K_BUFFER_PATTERN_LABEL_2}).
  
  run qg_CreateBufferButtonMenu(btnBuffer3:handle,
                                {&K_BUFFER_PATTERN_3},
                                {&K_BUFFER_PATTERN_LABEL_3}).
  
  run qg_CreateBufferButtonMenu(btnBuffer4:handle,
                                {&K_BUFFER_PATTERN_4},
                                {&K_BUFFER_PATTERN_LABEL_4}).

&ENDIF

/* Set display mode. */
run qg_SetDisplayMode({&K_DISPLAYMODE_INDEX}).

assign
  btnClearTableFilter:height in frame {&FRAME-NAME}      = gcTableFilter:height in frame {&FRAME-NAME}
  gcTableFilter:delimiter in frame {&FRAME-NAME}         = chr(1)
  btnClearTableFieldFilter:height in frame {&FRAME-NAME} = gcTableFieldFilter:height in frame {&FRAME-NAME}
  gcTableFieldFilter:delimiter in frame {&FRAME-NAME}    = chr(1)
  btnClearFieldFilter:height in frame {&FRAME-NAME}      = gcFieldFilter:height in frame {&FRAME-NAME}
  gcFieldFilter:delimiter in frame {&FRAME-NAME}         = chr(1)
  btnClearFieldLabelFilter:height in frame {&FRAME-NAME} = gcFieldLabelFilter:height in frame {&FRAME-NAME}
  gcFieldLabelFilter:delimiter in frame {&FRAME-NAME}    = chr(1)
  btnClearIndexFilter:height in frame {&FRAME-NAME}      = gcIndexFilter:height in frame {&FRAME-NAME}
  gcIndexFilter:delimiter in frame {&FRAME-NAME}         = chr(1)
  btnClearIndexFieldFilter:height in frame {&FRAME-NAME} = gcIndexFieldFilter:height in frame {&FRAME-NAME}
  gcIndexFieldFilter:delimiter in frame {&FRAME-NAME}    = chr(1)
  .

assign
  hQueryWindow:max-width-pixels      = session:width-pixels
  hQueryWindow:virtual-width-pixels  = hQueryWindow:max-width-pixels
  hQueryWindow:max-height-pixels     = session:height-pixels
  hQueryWindow:virtual-height-pixels = hQueryWindow:max-height-pixels
  .

run qg_InitWidgetConstraints(frame {&FRAME-NAME}:handle).

assign
  gdOriginalWidth  = hQueryWindow:width-chars
  gdOriginalHeight = hQueryWindow:height-chars
  .

if {&K_SET_SLIM_MODE_ON_STARTUP} then
  run qg_SetSlimMode(yes).

/* Init temp-tables and selection-list widgets. */
run qg_LoadCache(?).

/* Subscribe to snapshot events. */

subscribe
  to 'qgEvt_Snapshot':U
  anywhere
  run-procedure 'qg_AddSnapshot':U.

apply 'entry':U to gcTableFilter in frame {&FRAME-NAME}.

end procedure. /* qg_Initialize */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InitWidgetConstraints hQueryWindow 
PROCEDURE qg_InitWidgetConstraints :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Adds widget size and position information to its private data. Children    */
/* of given handle are added recursively.                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWidget                       = Widget handle.                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWidget as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hChild as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if can-query(phWidget, 'private-data':U) then
do:
  
  assign
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalCol':U,
                                                      phWidget:col,
                                                      ',':U)
      when can-query(phWidget, 'col':U)
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalRow':U,
                                                      phWidget:row,
                                                      ',':U)
      when can-query(phWidget, 'row':U)
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalWidth':U,
                                                      phWidget:width-chars,
                                                      ',':U)
      when can-query(phWidget, 'width':U)
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalHeight':U,
                                                      phWidget:height-chars,
                                                      ',':U)
      when can-query(phWidget, 'height':U)
    .

  /* Adjust side label position. */
  if    can-query(phWidget, 'side-label-handle':U)
    and valid-handle(phWidget:side-label-handle)
    and can-query(phWidget:side-label-handle, 'private-data':U) then
    assign
      phWidget:side-label-handle:private-data = qg_cParamListWriteDecimal(phWidget:side-label-handle:private-data,
                                                                          'OriginalCol':U,
                                                                          phWidget:side-label-handle:col,
                                                                          ',':U)
        when can-query(phWidget:side-label-handle, 'col':U)
      phWidget:side-label-handle:private-data = qg_cParamListWriteDecimal(phWidget:side-label-handle:private-data,
                                                                          'OriginalRow':U,
                                                                          phWidget:side-label-handle:row,
                                                                          ',':U)
        when can-query(phWidget:side-label-handle, 'row':U)
        .
  
end. /* if can-query(phWidget, 'private-data':U) */

if    can-query(phWidget, 'first-child':U)
  and can-query(phWidget, 'next-sibling':U) then
do:
  
  hChild = phWidget:first-child.

  do while valid-handle(hChild):
    run qg_InitWidgetConstraints(hChild).
    hChild = hChild:next-sibling.
  end. /* do while valid-handle */
  
end. /* if    can-query(phWidget, 'first-child':U) */

end procedure. /* qg_InitWidgetConstraints */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertBufferDefinition hQueryWindow 
PROCEDURE qg_InsertBufferDefinition :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert buffer definition for current table into ide.                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if glInsertMode then
  run qg_IDE_InsertText(substitute('define buffer $~{&1~} $~{cursor}for &2.':U,
                                   (if glSlimMode then
                                      substitute({&K_DEFAULT_BUFFER_PATTERN},
                                                 qg_cGetBufferBaseName(no))
                                    else
                                      input frame {&FRAME-NAME} gcBufferName),
                                   ttTable.TableName)).

end procedure. /* qg_InsertBufferDefinition */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertFieldAssigments hQueryWindow 
PROCEDURE qg_InsertFieldAssigments :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert field assignments into ide.                                         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cAssigments as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cAssigments = qg_cFieldAssignments(yes).

if cAssigments > '':U then
  run qg_IDE_InsertText(cAssigments).

end procedure. /* qg_InsertFieldAssigments */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertFieldAssignStatement hQueryWindow 
PROCEDURE qg_InsertFieldAssignStatement :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert field assign statement into ide.                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cAssignStatement as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cAssignStatement = qg_cFieldAssignStatement(yes).

if cAssignStatement > '':U then
  run qg_IDE_InsertText(cAssignStatement).

end procedure. /* qg_InsertFieldAssignStatement */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertPutStatement hQueryWindow 
PROCEDURE qg_InsertPutStatement :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert field assign statement into ide.                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cPutStatement as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cPutStatement = qg_cPutStatement(yes).

if cPutStatement > '':U then
  run qg_IDE_InsertText(cPutStatement).

end procedure. /* qg_InsertPutStatement */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertQueryText hQueryWindow 
PROCEDURE qg_InsertQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert current query text.                                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    OEIDEIsRunning
  and glIDECanInsert
  and glInsertMode then
  run qg_IDE_InsertText(qg_cCreateQueryText(qg_cCurrentFieldList(), yes)).

end procedure. /* qg_InsertQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertTextLines hQueryWindow 
PROCEDURE qg_InsertTextLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Inserts given Text after line of given offset index.                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcLines                        = Text that should be inserted.             */
/* piOffset                       = offset of the line after that the text    */
/*                                  should be inserted.                       */
/* iopcText                       = Text in which the line should be inser-   */
/*                                  ted.                                      */
/* opiLine                        = Line number of the inserted line.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter pcLines  as character no-undo.
define input        parameter piOffset as integer   no-undo.
define input-output parameter iopcText as character no-undo.
define       output parameter opiLine  as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i       as integer   no-undo.
define variable iOffset as integer   no-undo init 1.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if length(iopcText) = 0 then
  assign
    opiLine  = 1
    iopcText = pcLines
    .

else
do:
  
  do i = 1 to num-entries(iopcText, '~n':U):
    
    if iOffset > piOffset then
      leave.
    
    iOffset = iOffset + length(entry(i, iopcText, '~n':U)) + length('~n':U). 
    
  end. /* do i = 1 to num-entries(iopcText, '~n':U) */
  
  if    iOffset - 1 > length(iopcText)
    and not iopcText matches '*~n':U then
    iopcText = substitute('&1~n':U, iopcText).
  
  assign
    opiLine = i
    iopcText  = substitute('&1&2&3':U,
                         substring(iopcText, 1, iOffset - 1),
                         (if pcLines matches('*~n':U) then
                            pcLines
                          else
                            substitute('&1~n':U, pcLines)),
                         substring(iopcText, iOffset)).
    .
    
end. /* else: if length(iopcText) = 0 */

end procedure. /* qg_InsertTextLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadCache hQueryWindow 
PROCEDURE qg_LoadCache :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Fill temp-tables for all connected Databases.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase   for temp-table ttDatabase.
define buffer bttTable      for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cDatabaseName = (if pcDatabaseName <> ? then
                   pcDatabaseName
                 else if available ttDatabase then
                   ttDatabase.DatabaseName
                 else
                   ?).

if pcDatabaseName > '':U then
  run qg_RemoveDatabase(pcDatabaseName).

else
do:
  
  for each bttDatabase
    where bttDatabase.PhysicalDB = yes
    on error undo, throw:
    
    run qg_RemoveDatabase(bttDatabase.DatabaseName).
    
  end. /* for each bttDatabase */
  
  /* Remove all invalid virtual tables. */
  
  for each bttTable
    where bttTable.PhysicalTable = no
      and not valid-handle(bttTable.TableHandle)
    on error undo, throw:
    
    run qg_RemoveTable(bttTable.DatabaseName, bttTable.TableName).
    
  end. /* for each bttTable */
  
  /* Remove all virtual databases without temp-tables. */
  
  for each bttDatabase
    where bttDatabase.PhysicalDB = no
      and not can-find(first ttTable
                         where ttTable.DatabaseName = bttDatabase.DatabaseName)
    on error undo, throw:
    
    run qg_RemoveDatabase(bttDatabase.DatabaseName).
    
  end. /* for each bttDatabase */
  
end. /* else: if pcDatabaseName > '':U then */

run qg_RefreshDatabaseBrowse(cDatabaseName).

end procedure. /* qg_LoadCache */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadDataDefinitions hQueryWindow 
PROCEDURE qg_LoadDataDefinitions :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Loads a df file.                                                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName as character no-undo.

define variable cOptions      as character no-undo.
define variable cWarnings     as character no-undo.

define variable cDataDefinitionFileName as character no-undo
  format 'x(255)':U
  label 'Filename':t
  view-as fill-in
  size 60 by 1.

define button btnFileDialog
  label '...':T
  size 7 by 1.

define variable lAddObjectsOnline as logical   no-undo
  format 'yes/no':U
  label 'Load new tables and sequences on-line':T
  view-as toggle-box
  size 50 by 1.

define variable lForceCommit as logical   no-undo
  format 'yes/no':U
  label 'Commit even with errors':T
  view-as toggle-box
  size 50 by 1.

define variable lForceIndexDeactivate as logical   no-undo
  format 'yes/no':U
  label 'Create new indexes inactive':T
  view-as toggle-box
  size 50 by 1.

define variable lForceSharedSchema as logical   no-undo
  format 'yes/no':U
  label 'Ignore multi-tenant properties':T
  view-as toggle-box
  size 50 by 1.

define button btnOk
  label 'Ok':T6
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T6
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for temp-table ttDatabase.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fDataDefintionsSettings
  cDataDefinitionFileName at row 1.5 col 12 colon-aligned
  btnFileDialog at row 1.5 col 72 colon-aligned
  lAddObjectsOnline at row 3 col 12 colon-aligned
  lForceCommit at row 4 col 12 colon-aligned
  lForceIndexDeactivate at row 5 col 12 colon-aligned
  lForceSharedSchema at row 6 col 12 colon-aligned
  btnOk at row 8 col 22
  btnCancel at row 8 col 42
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 83 by 9.94
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fDataDefintionsSettings
  apply 'end-error' to self.

on choose of btnFileDialog in frame fDataDefintionsSettings
do:
  
  define variable lOk       as logical   no-undo.
  define variable cFilename as character no-undo.
  
  cFilename = input frame fDataDefintionsSettings cDataDefinitionFileName.
  
  system-dialog get-file cFileName
    title             substitute('&1Select df file for database "&2" ...':U,
                                 gcTitlePrefix,
                                 cDatabaseName)
    filters           'Data definitions (*.df)':U '*.df':U
    default-extension '.df':U
    use-filename
    update lOk
    .
  
  if lOk then
  do:
    
    cDataDefinitionFileName = cFilename.
    
    display unless-hidden
      cDataDefinitionFileName
      with frame fDataDefintionsSettings
        in window phParentWindow.
    
  end. /* if lOk */
  
end. /* on choose of btnFileDialog in frame fDataDefintionsSettings */


if available ttDatabase then
do:
  
  cDatabaseName = ttDatabase.DatabaseName.
  
  frame fDataDefintionsSettings:title = substitute('&1Load data definition for database "&2"':U,
                                                   gcTitlePrefix,
                                                   cDatabaseName).
  
  update unless-hidden
    cDataDefinitionFileName
    btnFileDialog
    lAddObjectsOnline
    lForceCommit
    lForceIndexDeactivate
    lForceSharedSchema
    btnOk
    btnCancel
    with frame fDataDefintionsSettings
      in window phParentWindow. 
  
  assign
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'AddObjectsOnline':U)
        when lAddObjectsOnline
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'ForceCommit':U)
        when lForceCommit
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'ForceIndexDeactivate':U)
        when lForceIndexDeactivate
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'ForceSharedSchema':U)
        when lForceSharedSchema
    .
  
  run qg_SetWorkingDatabase.
  
  run prodict/load_df_silent.p (cDataDefinitionFileName, /* code checked by mth 30.07.2015 */
                                cOptions,
                                output cWarnings).
  
  /* Reload cache. */
  run qg_LoadCache(cDatabaseName).
  
  find bttDatabase
    where bttDatabase.DatabaseName = cDatabaseName
    no-error.
  
  if available bttDatabase then
  do:
    reposition brDatabase to rowid rowid(bttDatabase).
    apply 'value-changed':U to brDatabase in frame fQuery.
  end. /* if available bttDatabase */
  
end. /* if available ttDatabase.DatabaseName */
  
end procedure. /* qg_LoadDataDefinitions */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadIDESetting hQueryWindow 
PROCEDURE qg_LoadIDESetting :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Loads given setting for current project.                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* This has to be a procedure (may not be a function) due to progress error   */
/* 2780.                                                                      */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcSettingName                  = Name of the setting that should be        */
/*                                  loaded.                                   */
/* opcSettingValue                = Output of setting value.                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter pcSettingName   as character no-undo.
define output parameter opcSettingValue as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cParamString  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    OEIDEIsRunning
  and glIDECanLoadSetting then
do:
  
  assign
    cParamString = qg_cParamListWriteCharacter(cParamString,
                                               'ProjectName':U,
                                               (if gcIDEProjectName <> ? then
                                                  gcIDEProjectName
                                                else
                                                  '':U),
                                               {&K_PARAM_SPLITTER})
    cParamString = qg_cParamListWriteCharacter(cParamString,
                                               'ParameterName':U,
                                               pcSettingName,
                                               {&K_PARAM_SPLITTER})
    .
  
  run qg_IDE_SendRequest({&K_LOAD_PLUGIN_SETTING_HANDLER},
                         cParamString,
                         output opcSettingValue).
  
end. /* if    OEIDEIsRunning ... */

end procedure. /* qg_LoadIDESetting */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadQueryScenario hQueryWindow 
PROCEDURE qg_LoadQueryScenario :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Load a previously stored query scenario.                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcFileName                     = Filename that contains the scenario. If ? */
/*                                  the scenario will be loaded from          */
/*                                  clipboard.                                */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcFileName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lOk                  as logical   no-undo.
define variable clText               as longchar  no-undo.

define variable cTargetQueryText     as character no-undo.

define variable hSplitter1           as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow           for temp-table ttQueryWindow.
define buffer bttRecentQueries         for temp-table ttRecentQueries.

define buffer bttQueryWindowExport     for temp-table ttQueryWindowExport.
define buffer btt2QueryWindowExport    for temp-table ttQueryWindowExport.
define buffer bttQueryBufferExport     for temp-table ttQueryBufferExport.
define buffer bttRecentQueryExport     for temp-table ttRecentQueryExport.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if pcFileName <> ? then
  dataset dsQueryWindowExport:read-xml('File':U,
                                        pcFileName,
                                        'empty':U,
                                        ?,
                                        no).
  
else if lookup('PRO_TEXT':U, clipboard:available-formats) > 0 then
do:
  
  clText = qg_lcClipboardValue().
  
  if clText > '':U then
    dataset dsQueryWindowExport:read-xml('longchar':U,
                                          clText,
                                          'empty':U,
                                          ?,
                                          no).
    
end. /* else: if pcFileName <> ? */

else
  return.

if can-find(first ttQueryWindow) then
do:
  
  message /* code checked by mth */
    'Do you want to close all currenty open query windows?':U
    view-as alert-box question
    buttons yes-no-cancel
    update lOk
    in window hQueryWindow
    .
  
  if lOk = ? then
    return.
  
  else if lOk then
  do:
    
    for each bttQueryWindow
      on error undo, throw:
      
      if valid-handle(bttQueryWindow.WindowHandle) then
        apply 'window-close':U to bttQueryWindow.WindowHandle.
      
    end. /* for each bttQueryWindow */
    
  end. /* else if lOk */
  
end. /* if can-find(first ttQueryWindow) */

/* Generate new seqence numbers. */
for each bttQueryWindowExport
  on error undo, throw:
  
  assign
    giQuerySeq                       = giQuerySeq + 1
    bttQueryWindowExport.NewQuerySeq = giQuerySeq
    .
  
end. /* bttQueryWindowExport */

/* Now update external references in the query texts. */
for each bttQueryWindowExport
  on error undo, throw:
  
  /* Fix external references. */
  
  cTargetQueryText = qg_cFixQuerySeq(bttQueryWindowExport.QueryText,
                                     bttQueryWindowExport.QuerySeq).
  
  /* Open query window. */
  
  find first bttQueryBufferExport
    where bttQueryBufferExport.QuerySeq = bttQueryWindowExport.QuerySeq
    no-error.
  
  if available bttQueryBufferExport then
  do:
    
    run qg_ExecQuery(bttQueryBufferExport.DatabaseName,
                     bttQueryBufferExport.TableName,
                     cTargetQueryText,
                     bttQueryWindowExport.NewQuerySeq).
    
    find bttQueryWindow
      where bttQueryWindow.QuerySeq = bttQueryWindowExport.NewQuerySeq
      no-error.
    
    if available bttQueryWindow then
    do:
      
      if num-entries(bttQueryWindowExport.BrowseColumns) > 0 then
        run qg_SetBrowseColumns(bttQueryWindow.QueryBrowseHandle,
                                bttQueryWindowExport.BrowseColumns).
      
      assign
        bttQueryWindow.WindowHandle:width-chars  = bttQueryWindowExport.WindowWidth
            when bttQueryWindowExport.WindowWidth > 0
        bttQueryWindow.WindowHandle:height-chars = bttQueryWindowExport.WindowHeight
            when bttQueryWindowExport.WindowHeight > 0
        bttQueryWindow.WindowHandle:column       = bttQueryWindowExport.WindowColumn
            when bttQueryWindowExport.WindowColumn > 0
        bttQueryWindow.WindowHandle:row          = bttQueryWindowExport.WindowRow
            when bttQueryWindowExport.WindowRow > 0
        bttQueryWindow.WindowHandle:window-state = (if bttQueryWindowExport.WindowState = {&K_WINDOW_MAXIMIZED_STR} then
                                                      {&K_WINDOW_MAXIMIZED}
                                                    else if bttQueryWindowExport.WindowState = {&K_WINDOW_MINIMIZED_STR} then
                                                      {&K_WINDOW_MINIMIZED}
                                                    else
                                                      {&K_WINDOW_NORMAL})
        .
      
      if bttQueryWindowExport.Splitter1Pos > 0 then
        assign
          hSplitter1     = qg_hGetWidgetByName(bttQueryWindow.WindowHandle,
                                               'btnSplitter1':U)
          hSplitter1:row = bttQueryWindowExport.Splitter1Pos
          .
      
      if bttQueryWindowExport.HideFieldList then
        run qg_QueryWindowToggleFieldList(bttQueryWindow.WindowHandle).
      
      else
        apply 'window-resized':U to bttQueryWindow.WindowHandle.
      
      /* Create Query history entries. */
      
      for each bttRecentQueryExport
        where bttRecentQueryExport.QuerySeq = bttQueryWindowExport.QuerySeq
        on error undo, throw:
        
        /* Fix external references */
        
        cTargetQueryText = qg_cFixQuerySeq(bttRecentQueryExport.QueryText,
                                           bttRecentQueryExport.QuerySeq).
        
        /* Add history entry */

        find bttRecentQueries
          where bttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
            and bttRecentQueries.QueryText    = cTargetQueryText
          no-error.
        
        if not available(bttRecentQueries) then
        do:
          
          create bttRecentQueries.
          
          assign
            giRecentQueriesSeq            = giRecentQueriesSeq + 1
            bttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
            bttRecentQueries.QueryText    = cTargetQueryText
            bttRecentQueries.QueryLabel   = qg_cQueryLabel(cTargetQueryText)
            . 
          
          validate bttRecentQueries.
          
        end. /* if not available(bttRecentQueries) */
        
        assign
          giRecentQueriesSeq     = giRecentQueriesSeq + 1
          bttRecentQueries.Order = giRecentQueriesSeq
          .
        
        validate bttRecentQueries.
        
      end. /* for each bttRecentQueryExport */
      
    end. /* if available bttQueryWindow */
    
  end. /* if available bttQueryBufferExport */
  
end. /* bttQueryWindowExport */

end procedure. /* qg_LoadQueryScenario */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_MoveTextLines hQueryWindow 
PROCEDURE qg_MoveTextLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Inserts given Text after line of given offset index.                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcLine                         = Text that should be inserted.             */
/* piOffset                       = offset of the line after that the text    */
/*                                  should be inserted.                       */
/* iopcText                       = Text in which the line should be inser-   */
/*                                  ted.                                      */
/* opiLine                        = Line number of the inserted line.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter piOffsetStart as integer   no-undo.
define input        parameter piOffsetEnd   as integer   no-undo.
define input        parameter plDown        as logical   no-undo.
define input-output parameter iopcText      as character no-undo.
define       output parameter opiLine       as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i               as integer   no-undo.
define variable iOffset         as integer   no-undo init 1.
define variable iLineEndOffset  as integer   no-undo.

define variable iStartOffset    as integer   no-undo.
define variable iEndOffset      as integer   no-undo.

define variable lLineBreak      as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

do i = 1 to num-entries(iopcText, '~n':U):
  
  iLineEndOffset = iOffset + length(entry(i, iopcText, '~n':U)).
  
  if    iOffset        <= piOffsetStart
    and iLineEndOffset >= piOffsetStart then
    assign
      iStartOffset = iOffset
      opiLine      = i
      .
  
  if    iOffset        <= piOffsetEnd
    and iLineEndOffset >= piOffsetEnd then
  do:
    
    iEndOffset = iLineEndOffset + length('~n':U).
    leave.
    
  end. /* if iOffset <= piOffsetEnd */
  
  iOffset = iLineEndOffset + length('~n':U). 
  
end. /* do i = 1 to num-entries(iopcText, '~n':U) */

if    iStartOffset > 0
  and iEndOffset  >= iStartOffset then
do:
  
  if plDown then
  do:
    
    iOffset = index(iopcText, '~n':U, iEndOffset).
    
    if    iOffset    = 0
      and iEndOffset < length(iopcText) + 1 then
      iOffset = length(iopcText) + 1.
    
    lLineBreak = (length(iopcText) >= iOffset).
    
  end. /* if plDown */
  
  else
  do:
    
    if iStartOffset - length('~n':U) > 1 then
      iOffset = r-index(iopcText, '~n':U, iStartOffset - length('~n':U) - 1).
    
    if    iOffset      = 0
      and iStartOffset > 1 then
      iOffset = 1.
    
    if iOffset > 1 then
      iOffset = iOffset + length('~n':U).
    
    lLineBreak = (length(iopcText) >= iEndOffset).
    
  end. /* if plDown */
  
  if iOffset > 0 then
  do:
    
    if    plDown
      and iOffset > iEndOffset then
      assign
        iOffset = iOffset + length('~n':U)
        iopcText  = substitute('&1&2~n&3&4&5':U,
                               substring(iopcText, 1, iStartOffset - 1),
                               right-trim(substring(iopcText,
                                                    iEndOffset,
                                                    iOffset - iEndOffset),
                                          '~n':U),
                               right-trim(substring(iopcText,
                                                    iStartOffset,
                                                    iEndOffset - iStartOffset),
                                          '~n':U),
                               (if lLineBreak then
                                  '~n':U
                                else
                                  '':U),
                               substring(iopcText, iOffset))
        opiLine = opiLine + 1
        .
    
    else
      if    not plDown
        and iOffset < iStartOffset then
      assign
        iopcText  = substitute('&1&2~n&3&4&5':U,
                               substring(iopcText, 1, iOffset - 1),
                               right-trim(substring(iopcText,
                                                    iStartOffset,
                                                    iEndOffset - iStartOffset),
                                          '~n':U),
                               right-trim(substring(iopcText,
                                                   iOffset,
                                                   iStartOffset - iOffset),
                                         '~n':U),
                               (if lLineBreak then
                                  '~n':U
                                else
                                  '':U),
                               substring(iopcText, iEndOffset))
        opiLine = opiLine - 1
        .
    
  end. /* if iOffset > 0 */
  
end. /* if    iStartOffset > 0 */

end procedure. /* qg_MoveTextLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_MoveToTop hQueryWindow 
PROCEDURE qg_MoveToTop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Bring main window to front.                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

/* Make sure the main window isn't minimized. */
if    hQueryWindow:window-state <> {&K_WINDOW_NORMAL}
  and hQueryWindow:window-state <> {&K_WINDOW_MAXIMIZED} then
  hQueryWindow:window-state = {&K_WINDOW_NORMAL}.

process events.
hQueryWindow:move-to-top().
apply 'entry':U to gcTableFilter in frame {&FRAME-NAME}.

return no-apply.

end procedure. /* qg_MoveToTop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_OpenFile hQueryWindow 
PROCEDURE qg_OpenFile :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open given file in external editor.                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcFilename                     = Filename.                                 */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcFilename as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    OEIDEIsRunning
  and gcIDEProjectName > '':U then
  openEditor(gcIDEProjectName,
             pcFilename,
             ?,
             ?).

else
  os-command no-wait value(pcFilename).

end procedure. /* qg_OpenFile */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_OpenRecordWindow hQueryWindow 
PROCEDURE qg_OpenRecordWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open record window.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phRecordBuffer                 = Record buffer handle that contains the    */
/*                                  values that should be displayed.          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phRecordBuffer as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName  as character no-undo.
define variable cWindowTitle   as character no-undo.

define variable hRecordBuffer  as handle    no-undo.

define variable hWindow        as handle    no-undo.
define variable hFrame         as handle    no-undo.
define variable hBuffer        as handle    no-undo.
define variable hQuery         as handle    no-undo.
define variable hBrowse        as handle    no-undo.

define variable hTemp          as handle    no-undo.
define variable hRawValues     as handle    no-undo.
define variable hRefreshButton as handle    no-undo.

define variable iIndex         as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.
define buffer bttRecordField  for temp-table ttRecordField. 

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cDatabaseName = qg_cParamListReadValue(phRecordBuffer:private-data,
                                       'DatabaseName':U,
                                       ',':U).

if   cDatabaseName       = ?
  or trim(cDatabaseName) = '':U then
  cDatabaseName = phRecordBuffer:dbname.

/* Make a copy of the given buffer. */

create buffer hRecordBuffer for table phRecordBuffer.
hRecordBuffer:find-by-rowid(phRecordBuffer:rowid, no-lock) no-error.

if not hRecordBuffer:available then
do:
  
  delete object hRecordBuffer.
  leave.
  
end. /* if not hRecordBuffer:available */

cWindowTitle = substitute('Record - &1.&2':T, cDatabaseName, hRecordBuffer:table).

/* Create Window. */

create window hWindow
  assign
    hidden         = yes
    width          = 91
    max-width      = 1024
    height         = 15.44
    max-height     = 1024
    scroll-bars    = no
    status-area    = no
    three-d        = yes
    message-area   = no
    sensitive      = yes
    title          = substitute('&1':U,
                                gcTitlePrefix,
                                cWindowTitle)
    .

create frame hFrame
  assign
    name           = 'fRecord':U
    box            = no
    three-d        = yes
    width          = 91
    virtual-width  = 91
    height         = 25.44
    virtual-height = 25.44
    sensitive      = yes
    parent         = hWindow
    .

create buffer hBuffer for table 'ttRecordField':U. /* code checked by mth 30.07.2015 */

create query hQuery.
hQuery:set-buffers(hBuffer).

create browse hBrowse
  assign
    name                   = 'brRecord':U
    frame                  = hFrame
    width                  = 91
    height                 = 18.44
    row                    = 3
    col                    = 1
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
    multiple               = no
    no-empty-space         = yes
  triggers:
    on default-action
      persistent run qg_RecordWindowFieldDetails in target-procedure
                       (hWindow).
  end triggers.

create radio-set hRawValues
  assign
    name          = 'lRawValues':U
    frame         = hFrame
    width         = 40
    height        = 1
    row           = 1.5
    col           = 3
    sensitive     = yes
    radio-buttons = 'Formatted values,no,Raw values,yes':T
    horizontal    = yes
  triggers:
    on value-changed
      persistent run qg_RecordWindowUpdateValues in target-procedure
                      (hWindow).
  end triggers
    .

create button hRefreshButton
  assign
    name      = 'btnRefresh':U
    frame     = hFrame
    width     = 20
    height    = 1
    row       = 1.5
    col       = 68
    label     = 'Refresh':T
    sensitive = yes
  triggers:
    on choose
      persistent run qg_RecordWindowRefresh in target-procedure
                       (hWindow).
  end triggers
    .

/* Create browse popup menu. */

create menu hTemp
  assign
    name       = 'm_RecordBrowsePopupMenu':U
    popup-only = yes
    sensitive  = yes
    .

hBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_CopyValue':U
    parent       = hBrowse:popup-menu
    label        = 'Copy value':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_RecordWindowCopyValue in target-procedure
                       (hWindow).
  end triggers
    .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_FieldDetails':U
    parent       = hBrowse:popup-menu
    label        = 'Field details':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_RecordWindowFieldDetails in target-procedure
                       (hWindow).
  end triggers
    .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_SelectFields':U
    parent       = hBrowse:popup-menu
    label        = 'Select fields':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_RecordWindowSelectFields in target-procedure
                       (hWindow).
  end triggers.

on window-resized of hWindow
  persistent run qg_RecordWindowResize in target-procedure
                   (hWindow).

on window-close of hWindow
  persistent run qg_RecordWindowClose in target-procedure
                   (hWindow).

on f5 of hWindow anywhere /* Copy value */
  persistent run qg_RecordWindowRefresh in target-procedure
                   (hWindow).

on end-error of hWindow anywhere
  persistent run qg_MoveToTop in target-procedure.

on ctrl-f7 of hWindow anywhere /* Show query window */
  persistent run qg_ShowQueryWindow in target-procedure
                   (hWindow).

on ctrl-f8 of hWindow anywhere /* Show record window */
  persistent run qg_ShowRecordWindow in target-procedure
                   (hWindow).

on ctrl-w of hWindow anywhere /* Close window */
  persistent run qg_CloseWindow in target-procedure
                   (hWindow).

on ' ':U of hBrowse /* Value details */
  persistent run qg_RecordWindowFieldDetails in target-procedure
                   (hWindow).

on ctrl-c of hBrowse /* Copy value */
  persistent run qg_RecordWindowCopyValue in target-procedure
                   (hWindow).

hBrowse:query = hQuery.

hBrowse:add-like-column('ttRecordField.FieldName':U).
hBrowse:add-like-column('ttRecordField.FieldExtent':U).
hBrowse:add-like-column('ttRecordField.FieldLabel':U).
hBrowse:add-like-column('ttRecordField.CurrentDisplayValue':U).

/* Hide label column. */
hBrowse:get-browse-column(3):visible = no.

run qg_InitBrowse(hBrowse).

create bttRecordWindow.

assign
  bttRecordWindow.BufferHandle = hRecordBuffer
  bttRecordWindow.WindowHandle = hWindow
  bttRecordWindow.BrowseHandle = hBrowse
  bttRecordWindow.QueryHandle  = hQuery
  bttRecordWindow.DatabaseName = cDatabaseName
  bttRecordWindow.WindowTitle  = cWindowTitle
  .

/* Fill temp-table. */
run qg_UpdateRecordFieldTempTable(bttRecordWindow.BufferHandle,
                                  bttRecordWindow.WindowHandle,
                                  '':U).

/* Create field List */

for each bttRecordField
  where bttRecordField.WindowHandle = bttRecordWindow.WindowHandle
  by bttRecordField.FieldName
  by bttRecordField.FieldExtent
  on error undo, throw:
  
  do iIndex = integer(bttRecordField.FieldExtent > 0) to bttRecordField.FieldExtent:
    
    bttRecordWindow.FieldList = substitute('&1,&2':U,
                                           bttRecordWindow.FieldList,
                                           (if iIndex = 0 then
                                              bttRecordField.FieldName
                                            else
                                              substitute('&1[&2]':U,
                                                         bttRecordField.FieldName,
                                                         string(iIndex)))).
    
  end. /* do iIndex = integer(bttRecordField.FieldExtent > 0) to bttRecordField.FieldExtent */
  
end. /* for each bttRecordField */

assign
  bttRecordWindow.FieldList         = trim(bttRecordWindow.FieldList, ',':U)
  bttRecordWindow.SelectedFieldList = bttRecordWindow.FieldList
  .

if gcIconDir = '':U then
  hWindow:load-icon('adeicon/dict%.ico':U) no-error.
  
else
do:

  hWindow:load-icon(substitute('&1/32/table_analysis.ico':U,
                               gcIconDir)) no-error.

  hWindow:load-small-icon(substitute('&1/16/table_analysis.ico':U,
                                     gcIconDir)) no-error.

end. /* if gcIconDir = '':U */

assign
  hFrame:hidden  = no
  hWindow:hidden = no
  .

run qg_RecordWindowOpenQuery(bttRecordWindow.WindowHandle).
run qg_RecordWindowUpdateValues(bttRecordWindow.WindowHandle).

run qg_RecordWindowUpdateWindowTitle(hWindow).

apply 'window-resized':U to hWindow.
apply 'entry':U to hBrowse.

end procedure. /* qg_OpenRecordWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_OpenSessionTriggerWindow hQueryWindow 
PROCEDURE qg_OpenSessionTriggerWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open session trigger window (or acitivate it if its already runnung).      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame               as handle    no-undo.
define variable hBuffer              as handle    no-undo.
define variable hQuery               as handle    no-undo.
define variable hChooseLogFileButton as handle    no-undo.
define variable hOpenLogFileButton   as handle    no-undo.
define variable hDeleteLogFileButton as handle    no-undo.

define variable hTemp                as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggersWindow) then
  apply 'entry':U to ghSessionTriggersWindow.

else
do:
  
  create window ghSessionTriggersWindow
    assign
      hidden         = yes
      width          = 104
      max-width      = 1024
      height         = 20.5
      max-height     = 1024
      scroll-bars    = no
      status-area    = no
      three-d        = yes
      message-area   = no
      sensitive      = yes
          max-button     = no
      title          = gcTitlePrefix + 'Session triggers':U
      .
  
  create frame hFrame
    assign
      name           = 'fSessionTriggers':U
      box            = no
      three-d        = yes
      width          = 104
      virtual-width  = 104
      height         = 20.5
      virtual-height = 20.5
      sensitive      = yes
      parent         = ghSessionTriggersWindow
      .
  
  create toggle-box ghSessionTriggerShowMessage
    assign
      name      = 'lShowMessage':U
      frame     = hFrame
      width     = 30
      height    = 1
      row       = 1.5
      col       = 3
      label     = 'Show message':T
      sensitive = yes
    triggers:
      on value-changed
        persistent run qg_SessionTriggersShowMessageChanged in target-procedure.
    end triggers
    .
  
  create toggle-box ghSessionTriggerWriteLog
    assign
      name      = 'lWriteLog':U
      frame     = hFrame
      width     = 15
      height    = 1
      row       = ghSessionTriggerShowMessage:row + 1
      col       = ghSessionTriggerShowMessage:col
      label     = 'Write logfile':T
      sensitive = yes
    triggers:
      on value-changed
        persistent run qg_SessionTriggersWriteLogChanged in target-procedure.
    end triggers
    .
  
  create fill-in ghSessionTriggerLogFileName
    assign
      name      = 'cFileName':U
      frame     = hFrame
      data-type = 'character':U
      format    = 'x(1024)':U
      width     = 30
      height    = 1
      row       = ghSessionTriggerWriteLog:row + 1.5
      col       = ghSessionTriggerWriteLog:col + 12
      sensitive = yes
    triggers:
      on value-changed
        persistent run qg_SessionTriggersLogFileNameChanged in target-procedure.
    end triggers
    .
  
  create text hTemp
    assign
      format        = 'x(9)':U
      screen-value  = 'Filename:':U
      frame         = hFrame
      width         = font-table:get-text-width-chars('Filename:':U)
      row           = ghSessionTriggerLogFileName:row
      height        = 1
      col           = 1
      .
  
  assign
    hTemp:col = ghSessionTriggerLogFileName:col - hTemp:width - 1
    ghSessionTriggerLogFileName:side-label-handle = hTemp.
  
  create button hChooseLogFileButton
    assign
      name                 = 'btnChooseLogFile':U
      frame                = hFrame
      width                = 7
      height               = 1
      row                  = ghSessionTriggerLogFileName:row
      col                  =   ghSessionTriggerLogFileName:col
                             + ghSessionTriggerLogFileName:width
      label                = '...':T
      tooltip              = 'Choose log file':T
      sensitive            = yes
    triggers:
      on choose
        persistent run qg_SessionTriggersChooseLogFileChoose in target-procedure.
    end triggers
    .
  
  create button hOpenLogFileButton
    assign
      name                 = 'btnOpenLogFile':U
      frame                = hFrame
      width                = 10
      height               = 1
      row                  = hChooseLogFileButton:row
      col                  =   hChooseLogFileButton:col
                             + hChooseLogFileButton:width
                             + 1
      label                = 'Open':T
      tooltip              = 'Open log file with default application':T
      sensitive            = yes
    triggers:
      on choose
        persistent run qg_SessionTriggersOpenLogFile in target-procedure.
    end triggers
    .
  
  create button hDeleteLogFileButton
    assign
      name                 = 'btnDeleteLogFile':U
      frame                = hFrame
      width                = 10
      height               = 1
      row                  = hOpenLogFileButton:row
      col                  =   hOpenLogFileButton:col
                             + hOpenLogFileButton:width
      label                = 'Delete':T
      tooltip              = 'Delete log file':T
      sensitive            = yes
    triggers:
      on choose
        persistent run qg_SessionTriggersDeleteLogFile in target-procedure.
    end triggers
    .
  
  create toggle-box ghSessionTriggerIndexValues
    assign
      name      = 'lIndexValues':U
      frame     = hFrame
      width     = 30
      height    = 1
      row       = ghSessionTriggerLogFileName:row + 1.5
      col       = ghSessionTriggerWriteLog:col
      label     = 'Show index values':T
      sensitive = yes
    triggers:
      on value-changed
        persistent run qg_SessionTriggersShowIndexValuesChanged in target-procedure.
    end triggers
    .
  
  create toggle-box ghSessionTriggerStackTrace
    assign
      name      = 'lStackTrace':U
      frame     = hFrame
      width     = 30
      height    = 1
      row       = ghSessionTriggerIndexValues:row
      col       = ghSessionTriggerIndexValues:col + 30
      label     = 'Show stack trace':T
      sensitive = yes
    triggers:
      on value-changed
        persistent run qg_SessionTriggersShowStackTraceChanged in target-procedure.
    end triggers
    .
  
  create buffer hBuffer for table 'ttSessionTrigger':U. /* code checked by mth 30.07.2015 */
  
  create query hQuery.
  hQuery:set-buffers(hBuffer).
  
  create browse ghSessionTriggersBrowse
    assign
      name                   = 'brSessionTrigger':U
      frame                  = hFrame
      width                  = 100
      height                 = 14
      row                    = 7
      col                    = 3
      read-only              = yes
      row-markers            = no
      allow-column-searching = no
      multiple               = no
      no-empty-space         = yes
    /*
    triggers:
      on default-action
        persistent run qg_RecordWindowFieldDetails in target-procedure
                         (hWindow).
    end triggers
    */
    .
  
  create menu hTemp
    assign
      name       = 'm_SessionTriggersBrowsePopupMenu':U
      popup-only = yes
      sensitive  = yes
      .
  
  ghSessionTriggersBrowse:popup-menu = hTemp.
  
  create menu-item hTemp
    assign
      name         = 'mi_RemoveSessionTrigger':U
      parent       = ghSessionTriggersBrowse:popup-menu
      label        = 'Remove session trigger':T
      sensitive    = yes
    triggers:
      on choose
        persistent run qg_SessionTriggersRemoveSessionTrigger in target-procedure.
    end triggers
    .
  
  create menu-item hTemp
    assign
      name         = 'mi_RemoveAllSessionTriggers':U
      parent       = ghSessionTriggersBrowse:popup-menu
      label        = 'Remove all session triggers':T
      sensitive    = yes
    triggers:
      on choose
        persistent run qg_SessionTriggersRemoveAllSessionTriggers in target-procedure.
    end triggers
    .
  
  on window-close of ghSessionTriggersWindow
    persistent run qg_SessionTriggersWindowClose in target-procedure.
  
  on window-resized of ghSessionTriggersWindow
    persistent run qg_SessionTriggersWindowResized in target-procedure.
  
  on del of ghSessionTriggersBrowse
    persistent run qg_SessionTriggersRemoveSessionTrigger in target-procedure.
  
  ghSessionTriggersBrowse:query = hQuery.
  
  ghSessionTriggersBrowse:add-like-column('ttSessionTrigger.DatabaseName':U).
  ghSessionTriggersBrowse:add-like-column('ttSessionTrigger.TableName':U).
  ghSessionTriggersBrowse:add-like-column('ttSessionTrigger.FieldName':U).
  ghSessionTriggersBrowse:add-like-column('ttSessionTrigger.TriggerEvent':U).
  
  ghSessionTriggersBrowse:get-browse-column(1):width = 10.
  
  run qg_InitBrowse(ghSessionTriggersBrowse).
  
  if gcIconDir = '':U then
    ghSessionTriggersWindow:load-icon('adeicon/icfdev.ico':U) no-error.
    
  else
  do:
  
    ghSessionTriggersWindow:load-icon(substitute('&1/32/script_lightning.ico':U,
                                      gcIconDir)) no-error.
    
    ghSessionTriggersWindow:load-small-icon(substitute('&1/16/script_lightning.ico':U,
                                            gcIconDir)) no-error.
  
  end. /* if gcIconDir = '':U */
  
  assign
    hFrame:hidden                  = no
    ghSessionTriggersWindow:hidden = no
    ghSessionTriggerShowMessage:screen-value = string(glSessionTriggerShowMessage)
    ghSessionTriggerWriteLog:screen-value    = string(glSessionTriggerWriteLog)
    ghSessionTriggerLogFileName:screen-value = string(gcSessionTriggerLogFileName)
    ghSessionTriggerIndexValues:screen-value = string(glSessionTriggerIndexValues)
    ghSessionTriggerStackTrace:screen-value  = string(glSessionTriggerStackTrace)
    .
  
  run qg_SessionTriggersOpenQuery.
  
  apply 'value-changed':U to ghSessionTriggerWriteLog.
  apply 'window-resized':U to ghSessionTriggersWindow.
  apply 'entry':U to ghSessionTriggersBrowse.
  
end. /* else: if valid-handle(ghSessionTriggersWindow) then */

end procedure. /* qg_OpenSessionTriggerWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ParseQueryConditions hQueryWindow 
PROCEDURE qg_ParseQueryConditions :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Find conditions in given query text. The result will be stored in           */
/* ttQueryCondition.                                                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcQueryText                    = Query text that should be parsed.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcQueryText as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lConditionRight  as logical   no-undo.

define variable iOffset          as integer   no-undo.
define variable iTokenId         as integer   no-undo.
define variable iParentId        as integer   no-undo.

define variable iMaxOffset       as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer b2ttQueryAST      for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

empty temp-table ttQueryCondition.

run qg_QueryParserParseQuery(pcQueryText).

find first bttQueryAST
  where bttQueryAST.NodeType    = {&K_QP_NODE_TYPE_TOKEN}
    and bttQueryAST.TokenStart >= iOffset
    and bttQueryAST.TokenType  <> {&K_QP_TOKEN_TYPE_COMMENT}
  no-error.

do while available bttQueryAST:
  
  if    ( bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
      and bttQueryAST.TokenText = 'WHERE':U )
     or ( bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_OPERATOR}
      and lookup(bttQueryAST.TokenText, 'WHERE,AND,OR':U) > 0 ) then
  do:
    
    assign
      lConditionRight = no
      iOffset         = bttQueryAST.TokenEnd
      .
    
    /*------------------------------------------------------------------------*/
    /* Left side                                                              */
    /*------------------------------------------------------------------------*/
    
    /* Try to detect the correct parent id. */
    
    run qg_QueryParserFindToken(bttQueryAST.ParentId,
                                bttQueryAST.TokenEnd,
                                {&K_QP_TOKEN_TYPE_OPERATOR},
                                {&K_QP_COMPARATOR_OPERATORS},
                                output iTokenId,
                                output iParentId).
    
    if iParentId = ? then
      run qg_QueryParserFindToken(bttQueryAST.ParentId,
                                  bttQueryAST.TokenEnd,
                                  {&K_QP_TOKEN_TYPE_OPERATOR},
                                  'AND,OR':U,
                                  output iTokenId,
                                  output iParentId).
    
    if iParentId = ? then
      run qg_QueryParserFindToken(bttQueryAST.ParentId,
                                  bttQueryAST.TokenEnd,
                                  {&K_QP_TOKEN_TYPE_KEYWORD},
                                  'WHERE':U,
                                  output iTokenId,
                                  output iParentId).
    
    if iParentId = ? then
      run qg_QueryParserFindToken(bttQueryAST.ParentId,
                                  bttQueryAST.TokenEnd,
                                  ?,        /* any token type */
                                  '!(,*':U, /* first token that is not a opening parenthese */
                                  output iTokenId,
                                  output iParentId).
    
    if iParentId = ? then
      iParentId = bttQueryAST.ParentId.
    
    /* Get condition min offset. */
    
    find first b2ttQueryAST
      where b2ttQueryAST.ParentId    = iParentId
        and b2ttQueryAST.TokenStart >= iOffset
        and b2ttQueryAST.TokenType  <> {&K_QP_TOKEN_TYPE_COMMENT}
      use-index ParentId
      no-error.
    
    if available b2ttQueryAST then
      iOffset = b2ttQueryAST.TokenStart.
    
    /* Get condition max offset. */
    
    find last b2ttQueryAST
      where b2ttQueryAST.ParentId    = iParentId
        and b2ttQueryAST.TokenStart >= iOffset
        and b2ttQueryAST.TokenType  <> {&K_QP_TOKEN_TYPE_COMMENT}
      use-index ParentId
      no-error.
    
    if available b2ttQueryAST then
    do:
      
      iMaxOffset = b2ttQueryAST.TokenEnd.
      
      create bttQueryCondition.
      
      for each b2ttQueryAST
        where b2ttQueryAST.NodeType    = {&K_QP_NODE_TYPE_TOKEN}
          and b2ttQueryAST.TokenStart >= iOffset
          and b2ttQueryAST.TokenEnd   <= iMaxOffset
          and b2ttQueryAST.TokenType  <> {&K_QP_TOKEN_TYPE_COMMENT}
        by b2ttQueryAST.TokenStart by b2ttQueryAST.TokenEnd
        on error undo, throw:
        
        if    b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_PUNCTUATION}
           or ( b2ttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
            and lookup(b2ttQueryAST.TokenText, {&K_QP_CONDITION_BREAK_KEYWORDS}) > 0)
           or ( b2ttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_OPERATOR}
            and b2ttQueryAST.ParentId  = iParentId
            and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0 ) then
          leave.
        
        if bttQueryCondition.LeftStartPos = 0 then
          bttQueryCondition.LeftStartPos = b2ttQueryAST.TokenStart.
        
        if    b2ttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_OPERATOR}
          and lookup(b2ttQueryAST.TokenText, {&K_QP_COMPARATOR_OPERATORS}) > 0 then
        do:
          
          assign
            bttQueryCondition.ComparatorStartPos = b2ttQueryAST.TokenStart
            bttQueryCondition.ComparatorEndPos   = b2ttQueryAST.TokenEnd
            lConditionRight                      = yes
            .
          
          leave.
          
        end. /* if    b2ttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_OPERATOR} ... */
        
        bttQueryCondition.LeftEndPos = b2ttQueryAST.TokenEnd.
        
      end. /* for each b2ttQueryAST */
      
      assign
        bttQueryCondition.LeftEndPos       = max(bttQueryCondition.LeftStartPos,
                                                 bttQueryCondition.LeftEndPos)
        bttQueryCondition.ComparatorEndPos = max(bttQueryCondition.ComparatorStartPos,
                                                 bttQueryCondition.ComparatorEndPos)
        iOffset                            = max(iOffset,
                                                 bttQueryCondition.LeftEndPos,
                                                 bttQueryCondition.ComparatorEndPos)
        .
      
      /* Get right side */
      
      if lConditionRight then
      do:
        
        for each b2ttQueryAST
          where b2ttQueryAST.NodeType    = {&K_QP_NODE_TYPE_TOKEN}
            and b2ttQueryAST.TokenStart >= iOffset
            and b2ttQueryAST.TokenEnd   <= iMaxOffset
            and b2ttQueryAST.TokenType  <> {&K_QP_TOKEN_TYPE_COMMENT}
          use-index ParentId
          by b2ttQueryAST.TokenStart by b2ttQueryAST.TokenEnd
          on error undo, throw:
          
          if    b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_PUNCTUATION}
             or ( b2ttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
              and lookup(b2ttQueryAST.TokenText, {&K_QP_CONDITION_BREAK_KEYWORDS}) > 0)
             or ( b2ttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_OPERATOR}
              and b2ttQueryAST.ParentId  = iParentId
              and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0 ) then
            leave.
          
          if bttQueryCondition.RightStartPos = 0 then
            bttQueryCondition.RightStartPos = b2ttQueryAST.TokenStart.
          
          bttQueryCondition.RightEndPos = b2ttQueryAST.TokenEnd.
          
        end. /* for each b2ttQueryAST */
        
        if bttQueryCondition.RightStart = 0 then
          bttQueryCondition.RightStart = (if not can-find(first ttQueryAST
                                                            where ttQueryAST.NodeType = {&K_QP_NODE_TYPE_TOKEN}
                                                              and ttQueryAST.TokenStart <= bttQueryCondition.ComparatorEndPos + 1
                                                              and ttQueryAST.TokenEnd   >= bttQueryCondition.ComparatorEndPos + 1) then
                                            bttQueryCondition.ComparatorEndPos + 1
                                          else
                                            bttQueryCondition.ComparatorEndPos).
        
        assign
          bttQueryCondition.RightEndPos = max(bttQueryCondition.RightStartPos,
                                              bttQueryCondition.RightEndPos)
          iOffset                       = max(iOffset,
                                              bttQueryCondition.RightEndPos)
          lConditionRight               = no
          .
        
      end. /* if lConditionRight */
      
      assign
        bttQueryCondition.StartPos = bttQueryCondition.LeftStartPos
        bttQueryCondition.EndPos   = max(bttQueryCondition.LeftEndPos,
                                         bttQueryCondition.ComparatorEndPos,
                                         bttQueryCondition.RightEndPos)
        .
      
    end. /* if    bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_OPERATOR} */
  
  end. /* if available b2ttQueryAST */
  
  find next bttQueryAST
    where bttQueryAST.NodeType    = {&K_QP_NODE_TYPE_TOKEN}
      and bttQueryAST.TokenStart >= iOffset
      and bttQueryAST.TokenType  <> {&K_QP_TOKEN_TYPE_COMMENT}
    no-error.
  
end. /* for each bttQueryAST */
  
end procedure. /* qg_ParseQueryConditions */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ParseQueryLinks hQueryWindow 
PROCEDURE qg_ParseQueryLinks :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Parse query text for external references.                                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcQueryText                    = Query text that should be parsed.         */
/* piTargetSeq                    = Sequence number of the query window that  */
/*                                  the query text belongs to.                */
/* phTempTable                    = Handle of the temp-table that will be     */
/*                                  used to store the parses.                 */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcQueryText as character no-undo.
define input parameter piTargetSeq as integer   no-undo.
define input parameter phTempTable as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hTempTableBuffer as handle    no-undo.
define variable hQuery           as handle    no-undo.

define variable cRefText        as character no-undo.
define variable cTokenFieldText as character no-undo.
define variable iTokenStartPos  as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create buffer hTempTableBuffer for table phTempTable.

if phTempTable:has-records then
do:
  
  /* Delete all entries to given target sequence number. */
  
  create query hQuery.
  hQuery:add-buffer(hTempTableBuffer).
  
  hQuery:query-prepare(substitute('for each &1 where &1.TargetSeq = &2':U,
                                  hTempTableBuffer:name,
                                  quoter(piTargetSeq))).
  
  hQuery:query-open().
  hQuery:get-first().
  
  do while not hQuery:query-off-end:
    
    hTempTableBuffer:buffer-delete().
    hQuery:get-next().
    
  end. /* do while not hQuery:query-off-end */
  
end. /* if phTempTable:has-records */

/* Find external references. */

assign
  giQueryParserSeq = 0
  gcQPQueryText    = pcQueryText
  giQPOffset       = 1
  giQPTokenStart   = 1
  giQPTokenEnd     = 0
  gcQPToken        = '':U
  giQPTokenType    = {&K_QP_TOKEN_TYPE_UNDEFINED}
  .

run qg_QueryParserGetNextToken.

do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF}:
  
  if    giQPTokenType = {&K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE}
    and num-entries(gcQPToken, ':':U) = 2 then
  do:
    
    hTempTableBuffer:buffer-create().
    
    assign
      hTempTableBuffer::StartPos  = giQPTokenStart
      hTempTableBuffer::EndPos    = giQPTokenEnd
      hTempTableBuffer::TargetSeq = piTargetSeq
      cRefText                    = substring(gcQPToken, 3, length(gcQPToken) - 3)
      hTempTableBuffer::SourceSeq = integer(entry(1, cRefText, ':':U))
      cTokenFieldText             = entry(2, cRefText, ':':U)
      .
    
    if   trim(cTokenFieldText) matches 'recid(*)':U
      or trim(cTokenFieldText) matches 'rowid(*)':U then
      assign
        iTokenStartPos               = index(cTokenFieldText, '(':U)
        hTempTableBuffer::BufferName = trim(substring(cTokenFieldText,
                                                      iTokenStartPos + 1,
                                                        index(cTokenFieldText,
                                                              ')':U,
                                                              iTokenStartPos)
                                                      - 1
                                                      - iTokenStartPos))
        hTempTableBuffer::FieldName  = substitute('$&1':U,
                                                  trim(substring(cTokenFieldText,
                                                                 1,
                                                                 iTokenStartPos - 1)))
        .
      
    else if num-entries(cTokenFieldText, '.':U) = 2 then
      assign
        hTempTableBuffer::BufferName = entry(1, cTokenFieldText, '.':U)
        cTokenFieldText              = entry(2, cTokenFieldText, '.':U)
        iTokenStartPos               = index(cTokenFieldText, '[':U)
        hTempTableBuffer::FieldIndex = (if iTokenStartPos = 0 then
                                          0
                                        else
                                          integer(substring(cTokenFieldText,
                                                            iTokenStartPos + 1,
                                                              index(cTokenFieldText,
                                                                    ']':U,
                                                                    iTokenStartPos)
                                                            - 1
                                                            - iTokenStartPos)))
        hTempTableBuffer::FieldName  = (if iTokenStartPos = 0 then
                                          cTokenFieldText
                                        else
                                          substring(cTokenFieldText,
                                                    1,
                                                    iTokenStartPos - 1))
        .
    
    hTempTableBuffer:buffer-validate().
    
  end. /* if giQPTokenType = {&K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE} */
  
  giQPOffset = giQPTokenEnd.
  
  run qg_QueryParserGetNextToken.
  
end. /* do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF} */

finally:
  
  if valid-handle(hQuery) then
    delete object hQuery no-error.
  
  if valid-handle(hTempTableBuffer) then
    delete object hTempTableBuffer no-error.
  
end finally.
  
end procedure. /* qg_ParseQueryLinks */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ProcessBlockNameChange hQueryWindow 
PROCEDURE qg_ProcessBlockNameChange :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Necessary processing when blockname changed.                               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  gcBufferName   = (if glSlimMode then
                      substitute({&K_DEFAULT_BUFFER_PATTERN},
                                 qg_cGetBufferBaseName(no))
                    else
                      input frame {&FRAME-NAME} gcBufferName)
  gcBlockName    = (if glSlimMode then
                      substitute({&K_DEFAULT_BLOCK_PATTERN},
                                 gcBufferName)
                    else
                      input frame {&FRAME-NAME} gcBlockName)
  .

if    not glSlimMode
  and gcBufferName > '':U then
  gcBlockPattern = replace(gcBlockName,
                           gcBufferName,
                           '&1':U).
  
run qg_WidgetState('!gcBlockName,*':U).
run qg_UpdateQueryText.

end procedure. /* qg_ProcessBlockNameChange */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ProcessBufferNameChange hQueryWindow 
PROCEDURE qg_ProcessBufferNameChange :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Necessary processing when buffername changed.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  gcBufferName     = (if glSlimMode then
                        substitute({&K_DEFAULT_BUFFER_PATTERN},
                                   qg_cGetBufferBaseName(no))
                      else
                        input frame {&FRAME-NAME} gcBufferName)
  gcBufferBaseName = qg_cGetBufferBaseName(   glDefineBuffer
                                           or (  gcBufferPattern  > '':U
                                             and gcBufferPattern <> '&1':U))
  .

if    not glSlimMode
  and gcBufferBaseName > '':U then
  gcBufferPattern = replace(gcBufferName,
                            gcBufferBaseName,
                            '&1':U).

run qg_UpdateBlockName.
run qg_UpdateQueryText.

end procedure. /* qg_ProcessBufferNameChange */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryParserAddLeaf hQueryWindow 
PROCEDURE qg_QueryParserAddLeaf :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add leaf node.                                                             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piParentId                     = Id of the parent node.                    */
/* piLevel                        = Level of the node.                        */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piParentId as integer   no-undo.
define input parameter piLevel    as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryAST for ttQueryAST.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttQueryAST.

assign
  giQueryParserSeq       = giQueryParserSeq + 1
  bttQueryAST.Id         = giQueryParserSeq 
  bttQueryAST.ParentId   = piParentId
  bttQueryAST.TokenStart = giQPTokenStart
  bttQueryAST.TokenEnd   = giQPTokenEnd
  bttQueryAST.NodeType   = {&K_QP_NODE_TYPE_TOKEN}
  bttQueryAST.TokenText  = gcQPToken
  bttQueryAST.TokenType  = giQPTokenType
  bttQueryAST.Level      = piLevel
  .

validate bttQueryAST.

giQPOffset = giQPTokenEnd.

end procedure. /* qg_QueryParserAddLeaf */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryParserFindToken hQueryWindow 
PROCEDURE qg_QueryParserFindToken :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Find given token.                                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piParentId                     = Parent id.                                */
/* piOffset                       = Offset.                                   */
/* piTokenType                    = Token type.                               */
/* pcTokenText                    = Token text                                */
/* opiTokenId                     = Token id (? if none has been found).      */
/* opiParentId                    = Parent Node (? if none has been found).   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter piParentId  as integer   no-undo.
define input  parameter piOffset    as integer   no-undo.
define input  parameter piTokenType as integer   no-undo.
define input  parameter pcTokenText as character no-undo.
define output parameter opiTokenId  as integer   no-undo init ?.
define output parameter opiParentId as integer   no-undo init ?.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryAST for ttQueryAST.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryAST
  where bttQueryAST.ParentId   = piParentId
    and bttQueryAST.TokenStart > piOffset
  by bttQueryAST.TokenStart by bttQueryAST.TokenEnd
  on error undo, throw:
  
  if    bttQueryAST.NodeType = {&K_QP_NODE_TYPE_TOKEN}
    and ( piTokenType = ?
       or bttQueryAST.TokenType = piTokenType )
    and ( pcTokenText = ?
       or can-do(pcTokenText, bttQueryAST.TokenText) ) then
  do:
    
    assign
      opiTokenId  = bttQueryAST.Id
      opiParentId = bttQueryAST.ParentId
      .
    
    leave.
    
  end. /* if   pcTokenText           = ? */
  
  else
  do:
    
    run qg_QueryParserFindToken(bttQueryAST.Id,
                                piOffset,
                                piTokenType,
                                pcTokenText,
                                output opiTokenId,
                                output opiParentId).
    
    if opiTokenId <> ? then
      leave.
    
  end. /* if   pcTokenText           = ? */
  
end. /* for each bttQueryAST */

end procedure. /* qg_QueryParserFindToken */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryParserGetNextToken hQueryWindow 
PROCEDURE qg_QueryParserGetNextToken :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Get next token of query text.                                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iOffset       as integer   no-undo.

define variable cChar         as character no-undo extent 2.

define variable cStringChar   as character no-undo.
define variable lEscape       as logical   no-undo.

define variable iCommentLevel as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  iOffset  = giQPOffset
  cChar[1] = substring(gcQPQueryText, iOffset, 1).

/*----------------------------------------------------------------------------*/
/* Remove white spaces                                                        */
/*----------------------------------------------------------------------------*/

do while index(' ~t~n':U, cChar[1]) > 0:
  
  assign
    iOffset  = iOffset + 1
    cChar[1] = substring(gcQPQueryText, iOffset, 1)
    .
  
end. /* do while index(' ~t~n':U, cChar[1]) > 0 */

/*----------------------------------------------------------------------------*/
/* Determin token type                                                        */
/*----------------------------------------------------------------------------*/

assign
  giQPTokenStart = iOffset
  gcQPToken      = cChar[1]
  .

if length(cChar[1]) = 0 then
  giQPTokenType = {&K_QP_TOKEN_TYPE_EOF}.

else if index('~'"':U, cChar[1]) > 0 then
  giQPTokenType = {&K_QP_TOKEN_TYPE_STRING}.

else if cChar[1] = '/':U then
  assign
    cChar[2]      = substring(gcQPQueryText, iOffset + 1, 1)
    giQPTokenType = (if cChar[2] = '*':U then
                       {&K_QP_TOKEN_TYPE_COMMENT}
                     else
                       {&K_QP_TOKEN_TYPE_OPERATOR})
    .

else if index('-.':U, cChar[1]) > 0 then
  assign
    cChar[2]      = substring(gcQPQueryText, iOffset + 1, 1)
    giQPTokenType = (if    cChar[1] <> cChar[2]
                       and index('0123456789.':U, cChar[2]) > 0 then
                       {&K_QP_TOKEN_TYPE_NUMBER}
                     else if cChar[1] = '.':U then
                       {&K_QP_TOKEN_TYPE_PUNCTUATION}
                     else
                       {&K_QP_TOKEN_TYPE_OPERATOR})
    .
else if cChar[1] = '~{':U then
  assign
    cChar[2]      = substring(gcQPQueryText, iOffset + 1, 1)
    giQPTokenType = (if cChar[2] = '&':U then
                       {&K_QP_TOKEN_TYPE_PREPROCESSOR}
                     else
                       {&K_QP_TOKEN_TYPE_BRACE_OPEN})
    .

else if cChar[1] = '}':U then
  giQPTokenType = {&K_QP_TOKEN_TYPE_BRACE_CLOSE}.

else if cChar[1] = '[':U then
  giQPTokenType = {&K_QP_TOKEN_TYPE_BRACKET_OPEN}.

else if cChar[1] = ']':U then
  giQPTokenType = {&K_QP_TOKEN_TYPE_BRACKET_CLOSE}.

else if cChar[1] = '(':U then
  giQPTokenType = {&K_QP_TOKEN_TYPE_PARENTHESE_OPEN}.

else if cChar[1] = ')':U then
  giQPTokenType = {&K_QP_TOKEN_TYPE_PARENTHESE_CLOSE}.

else if index(':,':U, cChar[1]) > 0 then
  giQPTokenType = {&K_QP_TOKEN_TYPE_PUNCTUATION}.

else if index('0123456789':U, cChar[1]) > 0 then
  giQPTokenType = {&K_QP_TOKEN_TYPE_NUMBER}.

else if cChar[1] = '$':U then
  assign
    cChar[2]      = substring(gcQPQueryText, iOffset + 1, 1)
    giQPTokenType = (if cChar[2] = '~{':U then
                       {&K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE}
                     else
                       {&K_QP_TOKEN_TYPE_UNDEFINED})
    .

else if index('+*=<>':U, cChar[1]) > 0 then
  giQPTokenType = {&K_QP_TOKEN_TYPE_OPERATOR}.

else if index('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_':U, cChar[1]) > 0 then
  giQPTokenType = {&K_QP_TOKEN_TYPE_IDENTIFIER}.

else
  giQPTokenType = {&K_QP_TOKEN_TYPE_UNDEFINED}.

/*----------------------------------------------------------------------------*/
/* Read token                                                                 */
/*----------------------------------------------------------------------------*/

case giQPTokenType:
  
  when {&K_QP_TOKEN_TYPE_STRING} then
  do:
    
    assign
      cStringChar = cChar[1]
      iOffset     = iOffset + 1
      cChar[1]    = substring(gcQPQueryText, iOffset, 1)
      .
    
    /* Get complete string */
    
    do while length(cChar[1]) > 0:
      
      assign
        gcQPToken = gcQPToken + cChar[1]
        iOffset   = iOffset + 1.
        .
      
      if lEscape then
        lEscape = no.
      
      else
      do:
        
        if cChar[1] = '~~':U then
          lEscape = yes.
        
        else if cChar[1] = cStringChar then
        do:
          
          cChar[2] = substring(gcQPQueryText, iOffset, 1).
          
          if cChar[2] = cStringChar then
            lEscape = yes.
          
          else
            leave.
            
        end. /* else if cChar[1] = cStringChar */
        
      end. /* if lEscape */
      
      cChar[1] = substring(gcQPQueryText, iOffset, 1).
      
    end. /* do while length(cChar[1]) > 0 */
    
    /* Add translation attribute to string token. */
    
    assign
      cChar[1] = substring(gcQPQueryText, iOffset, 1)
      cChar[2] = substring(gcQPQueryText, iOffset + 1, 1)
      .
    
    if    cChar[1] = ':':U
      and index('RLCTU':U, cChar[2])  > 0 then
    do:
      
      assign
        gcQPToken = gcQPToken + cChar[1] + cChar[2]
        iOffset   = iOffset + 2.
        .
      
      do while yes:
        
        cChar[1] = substring(gcQPQueryText, iOffset, 1).
        
        if index('1234567890':U, cChar[1]) = 0 then
          leave.
        
        assign
          gcQPToken = gcQPToken + cChar[1]
          iOffset   = iOffset + 1.
          .
        
      end. /* do while yes */
      
    end. /* if cChar[1] = ':':U */
    
  end. /* when {&K_QP_TOKEN_TYPE_STRING} */
  
  when {&K_QP_TOKEN_TYPE_COMMENT} then
  do:
    
    assign
      iCommentLevel = 1
      iOffset       = iOffset + 1
      cChar[1]      = substring(gcQPQueryText, iOffset, 1)
      .
    
    do while length(cChar[1]) > 0:
      
      assign
        gcQPToken = gcQPToken + cChar[1].
        iOffset   = iOffset + 1
        .
      
      if cChar[1] = '/':U then
      do:
        
        cChar[2] = substring(gcQPQueryText, iOffset, 1).
        
        if cChar[2] = '*':U then
        do:
          
          assign
            iCommentLevel = iCommentLevel + 1
            gcQPToken     = gcQPToken + cChar[2]
            iOffset       = iOffset + 1
            .
          
          next.
          
        end. /* if cChar[2] = '*':U */
        
      end. /* if cChar[1] '/':U */
      
      else if cChar[1] = '*':U then
      do:
        
        cChar[2] = substring(gcQPQueryText, iOffset, 1).
        
        if cChar[2] = '/':U then
        do:
          
          assign
            iCommentLevel = iCommentLevel - 1
            gcQPToken     = gcQPToken + cChar[2]
            iOffset       = iOffset + 1
            .
          
          if iCommentLevel = 0 then
            leave.
          
          else
            next.
          
        end. /* if cChar[2] = '/':U */
        
      end. /* else if cChar[1] = '*':U */
      
      cChar[1] = substring(gcQPQueryText, iOffset, 1).
      
    end. /* do while length(cChar[1]) > 0 */
    
  end. /* when {&K_QP_TOKEN_TYPE_COMMENT} */
  
  when {&K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE} then
  do:
    
    assign
      iOffset  = iOffset + 1
      cChar[1] = substring(gcQPQueryText, iOffset, 1)
      .
    
    do while length(cChar[1]) > 0:
      
      assign
        gcQPToken = gcQPToken + cChar[1]
        iOffset   = iOffset + 1.
        .
      
      if cChar[1] = '}':U then
        leave.
      
      cChar[1] = substring(gcQPQueryText, iOffset, 1).
      
    end. /* do while length(cChar[1]) > 0 */
    
  end. /* when {&K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE} */
  
  when      {&K_QP_TOKEN_TYPE_NUMBER}
    or when {&K_QP_TOKEN_TYPE_IDENTIFIER} then
  do:
    
    iOffset = iOffset + 1.
    
    do while yes:
      
      cChar[1] = substring(gcQPQueryText, iOffset, 1).
      
      if length(cChar[1]) = 0 then
        leave.
      
      if index(' ~t~n()[]~{}<>=,+*':U, cChar[1]) > 0 then
        leave.
      
      else
        if index('.:':U, cChar[1]) > 0 then
        do:
          
          cChar[2] = substring(gcQPQueryText, iOffset + 1, 1).
          
          if   index(' ~t~n':U, cChar[2]) > 0
            or length(cChar[2]) = 0 then
            leave.
          
        end. /* else if index('.:':U, cChar[1]) > 0 ... */
      
      case giQPTokenType:
        
        when {&K_QP_TOKEN_TYPE_NUMBER} then
        do:
          
          if cChar[1] = '/':U then
          do:
            
            if index('-.':U, gcQPToken) = 0 then
              giQPTokenType = {&K_QP_TOKEN_TYPE_DATE}.
            
          end. /* if cChar[1] = '/':U */
          
        end. /* when {&K_QP_TOKEN_TYPE_NUMBER} */
        
        when {&K_QP_TOKEN_TYPE_DATE} then
        do:
          
          if index('123456789/':U, cChar[1]) = 0 then
            leave.
          
        end. /* when {&K_QP_TOKEN_TYPE_DATE} */
        
      end case. /* giQPTokenType */
      
      assign
        gcQPToken = gcQPToken + cChar[1].
        iOffset   = iOffset + 1
        .
      
    end. /* do while length(cChar[1]) > 0 */
    
  end. /* when {&K_QP_TOKEN_TYPE_NUMBER} */
  
  when {&K_QP_TOKEN_TYPE_OPERATOR} then 
  do:
    
    iOffset = iOffset + 1.
    
    if cChar[1] = '<':U then
    do:
      
      cChar[2] = substring(gcQPQueryText, iOffset, 1).
      
      if index('>=':U, cChar[2]) > 0 then
        assign
          gcQPToken = gcQPToken + cChar[2]
          iOffset   = iOffset + 1
          .
      
    end. /* if cChar[1] = '<':U */
    
    else if cChar[1] = '>':U then
    do:
      
      cChar[2] = substring(gcQPQueryText, iOffset, 1).
      
      if cChar[2] = '=':U then
        assign
          gcQPToken = gcQPToken + cChar[2]
          iOffset   = iOffset + 1
          .
      
    end. /* if cChar[1] = '>':U */
    
  end. /* when {&K_QP_TOKEN_TYPE_OPERATOR} */
  
  otherwise
    iOffset = iOffset + 1.
  
end case. /* case giQPTokenType */

if giQPTokenType = {&K_QP_TOKEN_TYPE_IDENTIFIER} then
do:
  
  if lookup(gcQPToken, 'AND,OR,NOT,EQ,LT,LE,GE,GT,NE,BEGINS,MATCHES,CONTAINS,MODULO':U) > 0 then
    giQPTokenType = {&K_QP_TOKEN_TYPE_OPERATOR}.
  
  else if keyword(gcQPToken) <> ? then
    giQPTokenType = {&K_QP_TOKEN_TYPE_KEYWORD}.
  
end. /* if giQPTokenType = {&K_QP_TOKEN_TYPE_IDENTIFIER} */

giQPTokenEnd = iOffset.

end procedure. /* qg_QueryParserGetNextToken */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryParserParseBracket hQueryWindow 
PROCEDURE qg_QueryParserParseBracket :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Parse bracket node.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/* For easier handling later on two subnodes will be created for bracket      */
/* nodes. One will contain all contents including the brackets and one will   */
/* contain only the contents within the brackets but excluding the brackets.  */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piParentId                     = Id of the parent node.                    */
/* piLevel                        = Level of the node                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piParentId as integer   no-undo.
define input parameter piLevel    as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iTokenType as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryAST  for temp-table ttQueryAST.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    giQPTokenType <> {&K_QP_TOKEN_TYPE_BRACE_OPEN}
  and giQPTokenType <> {&K_QP_TOKEN_TYPE_BRACKET_OPEN}
  and giQPTokenType <> {&K_QP_TOKEN_TYPE_PARENTHESE_OPEN}
  and giQPTokenType <> {&K_QP_TOKEN_TYPE_PREPROCESSOR} then
  leave.

iTokenType = giQPTokenType.

/* Add bracket node. */

create bttQueryAST.

assign
  giQueryParserSeq       = giQueryParserSeq + 1
  bttQueryAST.Id         = giQueryParserSeq
  bttQueryAST.ParentId   = piParentId
  bttQueryAST.TokenStart = giQPTokenStart
  bttQueryAST.Level      = piLevel
  bttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_UNDEFINED}
  bttQueryAST.NodeType   = {&K_QP_NODE_TYPE_NODE}
  .

validate bttQueryAST.

run qg_QueryParserAddLeaf(bttQueryAST.Id, piLevel).

run qg_QueryParserGetNextToken.

do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF}:
  
  run qg_QueryParserParseTokens(bttQueryAST.Id, piLevel + 1).
  
  if     (iTokenType    = {&K_QP_TOKEN_TYPE_BRACE_OPEN}
      and giQPTokenType = {&K_QP_TOKEN_TYPE_BRACE_CLOSE})
    or   (iTokenType    = {&K_QP_TOKEN_TYPE_BRACKET_OPEN}
      and giQPTokenType = {&K_QP_TOKEN_TYPE_BRACKET_CLOSE})
    or   (iTokenType    = {&K_QP_TOKEN_TYPE_PARENTHESE_OPEN}
      and giQPTokenType = {&K_QP_TOKEN_TYPE_PARENTHESE_CLOSE})
    or   (iTokenType    = {&K_QP_TOKEN_TYPE_PREPROCESSOR}
      and giQPTokenType = {&K_QP_TOKEN_TYPE_BRACE_CLOSE}) then
  do:
    
    run qg_QueryParserAddLeaf(bttQueryAST.Id, piLevel).
    leave.
    
  end. /* if     (iTokenType    = {&K_QP_TOKEN_TYPE_BRACE_OPEN} */
  
  run qg_QueryParserAddLeaf(bttQueryAST.Id, piLevel).
  run qg_QueryParserGetNextToken.
  
end. /* do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF} */

/* Complete bracket node information. */

bttQueryAST.TokenEnd  = giQPTokenEnd.

if    bttQueryAST.TokenStart > 0
  and bttQueryAST.TokenEnd   > bttQueryAST.TokenStart then
  bttQueryAST.TokenText = substring(gcQPQueryText,
                                    bttQueryAST.TokenStart,
                                    bttQueryAST.TokenEnd - bttQueryAST.TokenStart)
  .

end procedure. /* qg_QueryParserParseBracket */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryParserParseIfStatement hQueryWindow 
PROCEDURE qg_QueryParserParseIfStatement :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Parse bracket node.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piParentId                     = Id of the parent node.                    */
/* piLevel                        = Level of the node                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piParentId as integer   no-undo.
define input parameter piLevel    as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryAST  for temp-table ttQueryAST.
define buffer b2ttQueryAST for temp-table ttQueryAST.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    giQPTokenType <> {&K_QP_TOKEN_TYPE_KEYWORD}
   or gcQPToken     <> 'IF':U then
  leave.

/* Add if statement node. */

create bttQueryAST.

assign
  giQueryParserSeq       = giQueryParserSeq + 1
  bttQueryAST.Id         = giQueryParserSeq
  bttQueryAST.ParentId   = piParentId
  bttQueryAST.TokenStart = giQPTokenStart
  bttQueryAST.Level      = piLevel
  bttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_UNDEFINED}
  bttQueryAST.NodeType   = {&K_QP_NODE_TYPE_NODE}
  .

validate bttQueryAST.

run qg_QueryParserAddLeaf(bttQueryAST.Id, piLevel).

run qg_QueryParserGetNextToken.

do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF}:
  
  run qg_QueryParserParseTokens(bttQueryAST.Id, piLevel + 1).
  
  if    piParentId        > 0
    and ( giQPTokenType   = {&K_QP_TOKEN_TYPE_BRACE_CLOSE}
       or giQPTokenType   = {&K_QP_TOKEN_TYPE_BRACKET_CLOSE}
       or giQPTokenType   = {&K_QP_TOKEN_TYPE_PARENTHESE_CLOSE}
       or ( giQPTokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
        and lookup(gcQPToken, {&K_QP_CONDITION_BREAK_KEYWORDS}) > 0 ) ) then
    leave.
  
  run qg_QueryParserAddLeaf(bttQueryAST.Id, piLevel).
  run qg_QueryParserGetNextToken.
  
end. /* do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF} */

/* Complete if statement node information. */

find last b2ttQueryAST
  where b2ttQueryAST.ParentId = bttQueryAST.Id
  use-index ParentId
  no-error.

bttQueryAST.TokenEnd = (if available b2ttQueryAST then
                          b2ttQueryAST.TokenEnd
                        else
                          b2ttQueryAST.TokenStart).

if    bttQueryAST.TokenStart > 0
  and bttQueryAST.TokenEnd   > bttQueryAST.TokenStart then
  bttQueryAST.TokenText = substring(gcQPQueryText,
                                    bttQueryAST.TokenStart,
                                    bttQueryAST.TokenEnd - bttQueryAST.TokenStart)
  .

end procedure. /* qg_QueryParserParseIfStatement */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryParserParseQuery hQueryWindow 
PROCEDURE qg_QueryParserParseQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Parse query text. The result will be stored in ttQueryAST.                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcQueryText                    = Query text that should be parsed.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcQueryText as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

empty temp-table ttQueryAST.

assign
  giQueryParserSeq = 0
  gcQPQueryText    = pcQueryText
  giQPOffset       = 1
  giQPTokenStart   = 1
  giQPTokenEnd     = 0
  gcQPToken        = '':U
  giQPTokenType    = {&K_QP_TOKEN_TYPE_UNDEFINED}
  .

run qg_QueryParserGetNextToken.
run qg_QueryParserParseTokens(0, 0).

end procedure. /* qg_QueryParserParseQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryParserParseTokens hQueryWindow 
PROCEDURE qg_QueryParserParseTokens :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Parse Tokens.                                                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piParentId                     = Id of the parent node.                    */
/* piLevel                        = Level of the tokens.                      */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piParentId as integer   no-undo.
define input parameter piLevel    as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryAST  for temp-table ttQueryAST.
define buffer b2ttQueryAST for temp-table ttQueryAST.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

create bttQueryAST.

assign
  giQueryParserSeq       = giQueryParserSeq + 1
  bttQueryAST.Id         = giQueryParserSeq
  bttQueryAST.ParentId   = piParentId
  bttQueryAST.TokenStart = giQPTokenStart
  bttQueryAST.Level      = piLevel
  bttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_UNDEFINED}
  bttQueryAST.NodeType   = {&K_QP_NODE_TYPE_NODE}
  .

validate b2ttQueryAST.

do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF}:
  
  if    piParentId        > 0
    and ( giQPTokenType   = {&K_QP_TOKEN_TYPE_BRACE_CLOSE}
       or giQPTokenType   = {&K_QP_TOKEN_TYPE_BRACKET_CLOSE}
       or giQPTokenType   = {&K_QP_TOKEN_TYPE_PARENTHESE_CLOSE}
       or ( giQPTokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
        and ( lookup(gcQPToken, 'THEN,ELSE':U)              > 0 )
           or lookup(gcQPToken, {&K_QP_CONDITION_BREAK_KEYWORDS}) > 0 ) ) then
    leave.
  
  else
    if   giQPTokenType = {&K_QP_TOKEN_TYPE_BRACE_OPEN}
      or giQPTokenType = {&K_QP_TOKEN_TYPE_BRACKET_OPEN}
      or giQPTokenType = {&K_QP_TOKEN_TYPE_PARENTHESE_OPEN}
      or giQPTokenType = {&K_QP_TOKEN_TYPE_PREPROCESSOR} then
      run qg_QueryParserParseBracket(bttQueryAST.Id, piLevel).
  
  else
    if    giQPTokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
      and gcQPToken     = 'IF':U then
      run qg_QueryParserParseIfStatement(bttQueryAST.Id, piLevel).
      
  else
    run qg_QueryParserAddLeaf(bttQueryAST.Id, piLevel).
    
  run qg_QueryParserGetNextToken.
  
end. /* do while giQPTokenType <> {&K_QP_TOKEN_TYPE_EOF} */

/* Complete node information. */

find last b2ttQueryAST
  where b2ttQueryAST.ParentId = bttQueryAST.Id
  use-index ParentId
  no-error.

bttQueryAST.TokenEnd = (if available b2ttQueryAST then
                          b2ttQueryAST.TokenEnd
                        else
                          bttQueryAST.TokenStart).

if    bttQueryAST.TokenStart > 0
  and bttQueryAST.TokenEnd   > bttQueryAST.TokenStart then
  bttQueryAST.TokenText = substring(gcQPQueryText,
                                    bttQueryAST.TokenStart,
                                    bttQueryAST.TokenEnd - bttQueryAST.TokenStart)
  .

end procedure. /* qg_QueryParserParseTokens */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowAddSnapshot hQueryWindow 
PROCEDURE qg_QueryWindowAddSnapshot :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add snapshot of current query.                                             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow        as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

run qg_AddTableSnapshot(hBuffer,
                        bttQueryWindow.QueryHandle:prepare-string,
                        bttQueryWindow.WindowHandle).

apply 'entry' to bttQueryWindow.WindowHandle.

end procedure. /* qg_QueryWindowAddSnapshot */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowAddSortFields hQueryWindow 
PROCEDURE qg_QueryWindowAddSortFields :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add sort phrase for given field list.                                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcSortFieldList                = List of fields to insert.                 */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow        as handle    no-undo.
define input parameter pcSortFieldList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i            as integer   no-undo.

define variable cEditorText  as character no-undo.
define variable iCursorPos   as integer   no-undo.
define variable iCursorLine  as integer   no-undo.
define variable cLine        as character no-undo.
define variable iFirstByLine as integer   no-undo.
define variable iLastByLine  as integer   no-undo.

define variable iSelectionStart       as integer   no-undo.
define variable iSelectionEnd         as integer   no-undo.

define variable cInsertText  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cEditorText = bttQueryWindow.QueryTextEditorHandle:input-value
  iCursorLine = bttQueryWindow.QueryTextEditorHandle:cursor-line
  iCursorPos  = bttQueryWindow.QueryTextEditorHandle:cursor-offset
  .

do i = 1 to num-entries(cEditorText, '~n':U):
  
  cLine = entry(i, cEditorText, '~n':U).
  
  if   cLine matches '* by *':U
    or cLine matches 'by *':U then
  do:
    
    if iFirstByLine = 0 then
      iFirstByLine = i.
    
    iLastByLine = i.
    
  end. /* if cLine matches '*by *':U */
  
end. /* do i = 1 to num-entries(cEditorText, '~n':U) */

if   iFirstByLine = 0
  or iLastByLine  = 0 then
  iCursorLine = bttQueryWindow.QueryTextEditorHandle:num-lines - 1.

else if iCursorLine < iFirstByLine - 1 then
  iCursorLine = iLastByLine.

if    iCursorLine  > 0
  and iCursorLine <= num-entries(cEditorText, '~n':U) then
do:
  
  cLine = entry(iCursorLine, cEditorText, '~n':U).
  
  if    trim(cLine) = '':U
    and iCursorLine < bttQueryWindow.QueryTextEditorHandle:num-lines then
  do:
    bttQueryWindow.QueryTextEditorHandle:cursor-line = iCursorLine.
    bttQueryWindow.QueryTextEditorHandle:delete-line().
    iCursorLine = max(iCursorLine - 1, 1).
  end. /* if    trim(cLine) = '':U */
  
end. /* if    iCursorLine  > 0 */

do i = 1 to num-entries(pcSortFieldList):
  
  cInsertText = substitute('  by &1~n':U,
                           entry(i, pcSortFieldList)).
  
  iCursorLine = iCursorLine + 1.
    
  if iCursorLine <= bttQueryWindow.QueryTextEditorHandle:num-lines then
    bttQueryWindow.QueryTextEditorHandle:cursor-line = iCursorLine.
  
  else
  do:
    
    bttQueryWindow.QueryTextEditorHandle:move-to-eof().
    bttQueryWindow.QueryTextEditorHandle:insert-string('~n':U).
    
  end. /* else: if iCursorLine <= bttQueryWindow.QueryTextEditorHandle:num-lines */
  
  bttQueryWindow.QueryTextEditorHandle:insert-string(cInsertText).
  bttQueryWindow.QueryTextEditorHandle:cursor-line = iCursorLine.
  
  if i = 1 then
    iSelectionStart = bttQueryWindow.QueryTextEditorHandle:cursor-offset.
  
  iSelectionEnd = bttQueryWindow.QueryTextEditorHandle:cursor-offset + length(cInsertText) - 1.

end. /* do i = 1 to phFieldSelectionBrowse:num-selected-rows */

bttQueryWindow.QueryTextEditorHandle:set-selection(iSelectionStart, iSelectionEnd).
apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.

end procedure. /* qg_QueryWindowAddSortFields */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowAddSortOption hQueryWindow 
PROCEDURE qg_QueryWindowAddSortOption :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected fields as sort phrase.                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plDescending                   = Add sort option as descending sort.       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow     as handle    no-undo.
define input parameter plDescending as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                      as integer   no-undo.

define variable hFieldSelectionBuffer  as handle    no-undo.
define variable cSortFieldList         as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFieldSelectionBuffer = bttQueryWindow.FieldSelectionBrowseHandle:query:get-buffer-handle(1).

do i = 1 to bttQueryWindow.FieldSelectionBrowseHandle:num-selected-rows:
  
  bttQueryWindow.FieldSelectionBrowseHandle:fetch-selected-row (i).
  cSortFieldList = substitute('&1,&2.&3&4':U,
                              cSortFieldList,
                              hFieldSelectionBuffer::TableName,
                              hFieldSelectionBuffer::FieldName,
                              (if plDescending then
                                 ' descending':U
                               else
                                 '':U)).
  
end. /* do i = 1 to phFieldSelectionBrowse:num-selected-rows */

cSortFieldList = trim(cSortFieldList, ',':U).

if num-entries(cSortFieldList, ',':U) > 0 then
  run qg_QueryWindowAddSortFields(phWindow,
                                  cSortFieldList).

end procedure. /* qg_QueryWindowAddSortOption */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowBeautify hQueryWindow 
PROCEDURE qg_QueryWindowBeautify :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Beautify query text.                                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cQueryText = bttQueryWindow.QueryTextEditorHandle:input-value
  cQueryText = qg_cBeautifyQueryText(cQueryText)
  bttQueryWindow.QueryTextEditorHandle:screen-value = cQueryText
  .

end procedure. /* qg_QueryWindowBeautify */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowClose hQueryWindow 
PROCEDURE qg_QueryWindowClose :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Close query window (and clean up dynamically created widgets).             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* phQuery                        = Query of the Query window.                */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow   for ttQueryWindow.
define buffer bttQueryLink     for temp-table ttQueryLink.
define buffer bttRecentQueries for temp-table ttRecentQueries.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if available bttQueryWindow then
do:
  
  for each bttRecentQueries
    where bttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:
    
    delete bttRecentQueries.
    
  end. /* for each bttRecentQueries */
  
  for each bttQueryLink
    where bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq
    on error undo, throw:
    
    delete bttQueryLink.
    
  end. /* for each bttQueryLink */
  
  delete bttQueryWindow.
  
end. /* if available bttQueryWindow */

/* Clean up all dynamically created objects. */
run qg_DeleteWidgetTree(phWindow, yes).

run qg_QueryWindowUpdateAll('':U).

end procedure. /* qg_QueryWindowClose */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCopyQueryText hQueryWindow 
PROCEDURE qg_QueryWindowCopyQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy actual query text with resolved external tokens to clipboard.         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

clipboard:value = bttQueryWindow.QueryHandle:prepare-string.

end procedure. /* qg_QueryWindowCopyQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCopyRecid hQueryWindow 
PROCEDURE qg_QueryWindowCopyRecid :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy recid/rowid of the current query window record.                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBuffer                       = Buffer that contains the record.          */
/* plRecid                        = If yes then the recid will be copied. If  */
/*                                  no then the rowid will be copied.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBuffer as handle    no-undo.
define input parameter plRecid  as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if phBuffer:available then
  clipboard:value = (if plRecid then
                       string(phBuffer:recid)
                     else
                       string(phBuffer:rowid)).

end procedure. /* qg_QueryWindowCopyRecid */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowCopyRecordValues hQueryWindow 
PROCEDURE qg_QueryWindowCopyRecordValues :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy record values.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plRawValues                    = Copy raw values.                          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cFieldName          as character no-undo.
define variable iMaxFieldNameLength as integer   no-undo.
define variable i                   as integer   no-undo.
define variable hQueryBrowse        as handle    no-undo.
define variable hColumn             as handle    no-undo.
define variable hField              as handle    no-undo.
define variable clFieldValue        as longchar  no-undo.

define variable clText              as longchar  no-undo.

define variable lRawValues as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Raw values':T, yes,
      'Formatted values':T, no
  size 30 by 2.

define button btnOk
  label 'Ok':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fCopyRecordValues
  lRawValues at row 1.5 col 10 no-label
  btnOk at row 4.5 col 5
  btnCancel at row 4.5 col 25
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 49 by 6.5
    title gcTitlePrefix + 'Copy record values':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fCopyRecordValues
  apply 'end-error' to self.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

lRawValues = glCopyRawValues.

update unless-hidden
  lRawValues
  btnOk
  btnCancel
  with frame fCopyRecordValues
    in window bttQueryWindow.WindowHandle. 

glCopyRawValues = lRawValues.

hQueryBrowse = bttQueryWindow.QueryBrowseHandle.

/* First get the length of the longest field name. */
do i = 1 to hQueryBrowse:num-columns:
  
  assign
    hColumn     = hQueryBrowse:get-browse-column(i)
    cFieldName  = qg_cColumnFieldName(hColumn, no).
    hField      = hColumn:buffer-field
    .
  
  if   not hColumn:visible
    or hField:data-type = 'BLOB':U then
    next.
  
  cFieldName = qg_cColumnFieldName(hQueryBrowse:get-browse-column(i), no).
  
  if length(cFieldName) > iMaxFieldNameLength then
    iMaxFieldNameLength = length(cFieldName).
  
end. /* do i = 1 to hQueryBrowse:num-columns */

do i = 1 to hQueryBrowse:num-columns:
  
  assign
    hColumn     = hQueryBrowse:get-browse-column(i)
    cFieldName  = qg_cColumnFieldName(hColumn, no).
    hField      = hColumn:buffer-field
    .
  
  if   not hColumn:visible
    or hField:data-type = 'BLOB':U then
    next.
  
  if hField:data-type = 'CLOB':U then
  do:
    
    copy-lob hField:buffer-value(hColumn:index) to clFieldValue.
    clFieldValue = quoter(clFieldValue).
    
  end. /* if hField:data-type = 'CLOB':U then */
  
  else if lookup(hField:data-type, 'CHARACTER,LONGCHAR':U) > 0 then
    clFieldValue = quoter((if lRawValues then
                             hField:buffer-value(hColumn:index)
                           else
                             hField:string-value(hColumn:index))).
  
  else
    clFieldValue = (if lRawValues then
                      hField:buffer-value(hColumn:index)
                    else
                      hField:string-value(hColumn:index)).
  
  clText = substitute('&1~n&2&3: &4':U,
                      clText,
                      cFieldName,
                      fill(' ':U, iMaxFieldNameLength - length(cFieldName)),
                      clFieldValue) no-error.
  
end. /* do i = 1 to hQueryBrowse:num-columns */

clipboard:value = trim(clText, '~n':U).

end procedure. /* qg_QueryWindowCopyRecordValues */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowDelete hQueryWindow 
PROCEDURE qg_QueryWindowDelete :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Delete current record.                                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowser                      = Browser that contains the record that     */
/*                                  should be deleted.                        */
/* phBuffer                       = Buffer that contains the record that      */
/*                                  should be deleted.                        */
/* phParentWindow                 = Parent Window for the confirmation        */
/*                                  dialog.                                   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowser      as handle    no-undo.
define input parameter phBuffer       as handle    no-undo.
define input parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lOk              as logical   no-undo.
define variable lDisableTriggers as logical   no-undo.

define variable hLockBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

Main:
do transaction
  on error undo, throw:
  
  if not phBuffer:available then
  do:
    
    message /* code checked by mth */
      'No record is selected!':T
      view-as alert-box
      error
      buttons ok
      in window phParentWindow.
    
    leave.
  
  end. /* if not phBuffer:available */
  
  create buffer hLockBuffer for table phBuffer.
  
  find bttTable
    where bttTable.DatabaseName = hLockBuffer:dbname
      and bttTable.TableName    = hLockBuffer:table
    no-error.
  
  hLockBuffer:find-by-rowid(phBuffer:rowid, exclusive-lock).
  
  lDisableTriggers =     available bttTable
                     and bttTable.DeleteTrigger         > '':U
                     and search(bttTable.DeleteTrigger) = ?.
  
  run qg_ConfirmTriggerChanges(substitute('Confirm deletion of &1 record (&2)':T,
                                          hLockBuffer:table,
                                          string(hLockBuffer:rowid)),
                               'WARNING: You are about to delete the current record. Please confirm deletion of this record!':T,
                               'Delete':T,
                               (    available bttTable
                                and search(bttTable.DeleteTrigger) <> ?),
                               phParentWindow,
                                     output lOk,
                               input-output lDisableTriggers).
  
  if lOk then
  do:
    
    if lDisableTriggers then
      hLockBuffer:disable-load-triggers(no).
    
    hLockBuffer:buffer-delete().
    
    qg_lQueryOpen(phBrowser:query, ?, phParentWindow).
    
  end. /* if lOk */
  
  finally:
    
    if valid-handle(hLockBuffer) then
      delete object hLockBuffer.
    
  end finally.
  
end. /* Main */

end procedure. /* qg_QueryWindowDelete */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowDock hQueryWindow 
PROCEDURE qg_QueryWindowDock :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Dock query window to closest other query window.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* piDirection                    = Direction to search for other query       */
/*                                  windows.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.
define input parameter piDirection as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hWindow       as handle    no-undo.

define variable iX1 as integer   no-undo.
define variable iY1 as integer   no-undo.
define variable iX2 as integer   no-undo.
define variable iY2 as integer   no-undo.

define variable iX1Temp as integer   no-undo.
define variable iY1Temp as integer   no-undo.
define variable iX2Temp as integer   no-undo.
define variable iY2Temp as integer   no-undo.

define variable dDistance      as decimal   no-undo.
define variable dDockDistanceX as decimal   no-undo init ?.
define variable dDockDistanceY as decimal   no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer b2ttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/* The size that progress returns for window:width-pixels and window:height-  */
/* pixels does not include the borders. So in order to get the true window    */
/* size and position we need the windows api.                                 */

run qg_GetWindowRect(phWindow,
                     output iX1,
                     output iY1,
                     output iX2,
                     output iY2).

for each b2ttQueryWindow
  on error undo, throw:
  
  hWindow = b2ttQueryWindow.WindowHandle.
  
  if    not valid-handle(hWindow)
     or hWindow = bttQueryWindow.WindowHandle then
    next.
  
  run qg_GetWindowRect(hWindow,
                       output iX1Temp,
                       output iY1Temp,
                       output iX2Temp,
                       output iY2Temp).
  
  if    ( ( piDirection = {&K_DIRECTION_UP}
         or piDirection = {&K_DIRECTION_DOWN} )
      and iX1 <= iX2Temp
      and iX2 >= iX1Temp )
     or ( ( piDirection = {&K_DIRECTION_LEFT}
         or piDirection = {&K_DIRECTION_RIGHT} )
      and iY1 <= iY2Temp
      and iY2 >= iY1Temp ) then
  do:
    
    case piDirection:
      
      when {&K_DIRECTION_UP} then
      do:
        
        dDistance = iY1 - iY2Temp.
        
        if    dDistance > 0
          and ( dDockDistanceY = ?
             or dDistance      < dDockDistanceY ) then
          assign
            dDockDistanceX = iX1 - iX1Temp
            dDockDistanceY = dDistance
            .
        
      end. /* when {&K_DIRECTION_UP} */
      
      when {&K_DIRECTION_DOWN} then
      do:
        
        dDistance = iY2 - iY1Temp.
        
        if    dDistance < 0
          and ( dDockDistanceY = ?
             or dDistance      > dDockDistanceY ) then
          assign
            dDockDistanceX = iX1 - iX1Temp
            dDockDistanceY = dDistance
            .
        
      end. /* when {&K_DIRECTION_DOWN} */
      
      when {&K_DIRECTION_LEFT} then
      do:
        
        dDistance = iX1 - iX2Temp.
        
        if    dDistance > 0
          and ( dDockDistanceX = ?
             or dDistance      < dDockDistanceX ) then
          assign
            dDockDistanceX = dDistance
            dDockDistanceY = iY1 - iY1Temp
            .
        
      end. /* when {&K_DIRECTION_LEFT} */
      
      when {&K_DIRECTION_RIGHT} then
      do:
        
        dDistance = iX2 - iX1Temp.
        
        if    dDistance < 0
          and ( dDockDistanceX = ?
             or dDistance      > dDockDistanceX ) then
          assign
            dDockDistanceX = dDistance
            dDockDistanceY = iY1 - iY1Temp
            .
        
      end. /* when {&K_DIRECTION_RIGHT} */
      
    end case. /* piDirection */
    
  end. /* if    ( ( piDirection = {&K_DIRECTION_UP} */
  
end. /* for each b2ttQueryWindow */

if    dDockDistanceX <> ?
  and dDockDistanceY <> ? then
  assign
    bttQueryWindow.WindowHandle:x = bttQueryWindow.WindowHandle:x - dDockDistanceX
    bttQueryWindow.WindowHandle:y = bttQueryWindow.WindowHandle:y - dDockDistanceY
    .

end procedure. /* qg_QueryWindowDock */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowEdit hQueryWindow 
PROCEDURE qg_QueryWindowEdit :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Edit current record.                                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowser                      = Browser that contains the record that     */
/*                                  should be edited.                         */
/* phBuffer                       = Buffer that contains the record that      */
/*                                  should be edited.                         */
/* piEditAction                   = Action that should be performed:          */
/*                                  - {&K_EDITACTION_EDIT}                    */
/*                                  - {&K_EDITACTION_CREATE}                  */
/*                                  - {&K_EDITACTION_DUPLICATE}               */
/* phParentWindow                 = Parent window for the edit dialog.        */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowser      as handle    no-undo.
define input parameter phBuffer       as handle    no-undo.
define input parameter piEditAction   as integer   no-undo.
define input parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable rRowid as rowid     no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if   ( piEditAction = {&K_EDITACTION_EDIT}
    or piEditAction = {&K_EDITACTION_DUPLICATE})
  and not phBuffer:available then
do:
  
  message /* code checked by mth */
    'No record is selected!':T
    view-as alert-box
    error
    buttons ok
    in window phParentWindow.
  
  leave.
  
end. /* if not phBuffer:available */

run qg_EditRecord(phBuffer,
                  piEditAction,
                  {&K_EDITMODE_ENABLED},
                  phParentWindow,
                  qg_cBrowseColumnList(phBrowser,
                                       no,
                                       no,
                                       no),
                  output rRowid).

&IF {&K_EDITMODE_ENABLED} &THEN

  case piEditAction:
    
    when {&K_EDITACTION_EDIT} then
      phBrowser:refresh().
      
    otherwise
    do:
      
      qg_lQueryOpen(phBrowser:query, ?, phParentWindow).

      if rRowid <> ? then
        phBrowser:query:reposition-to-rowid(rRowid) no-error.
      
/*      phBrowser:scroll-to-current-row().*/
      
    end. /* otherwise */
    
  end case. /* piEditAction */
  
&ENDIF

end procedure. /* qg_QueryWindowEdit */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowExecCurrentQuery hQueryWindow 
PROCEDURE qg_QueryWindowExecCurrentQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Executes the current query text in a new query window.                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcDatabaseName                 = Database name for query buffer.           */
/* pcTableName                    = Table name for query buffer.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow       as handle    no-undo.
define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow     for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.QueryHandle:prepare-string > '':U then
  run qg_ExecQuery(pcDatabaseName,
                   pcTableName,
                   bttQueryWindow.QueryHandle:prepare-string,
                   ?).

end procedure. /* qg_QueryWindowExecCurrentQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowExecute hQueryWindow 
PROCEDURE qg_QueryWindowExecute :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Execute query of given query window.                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cWindowTitle   as character no-undo.
define variable hExecuteButton as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if   not available bttQueryWindow
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

assign
  cWindowTitle   = phWindow:title
  phWindow:title = substitute('&1 (executing ...)':U,
                              qg_cParamListReadValue(phWindow:private-data,
                                                     'WindowTitle':U,
                                                     ',':U))
  .

hExecuteButton = qg_hGetWidgetByName(bttQueryWindow.WindowHandle, 'btnExecute':U).

if valid-handle(hExecuteButton) then
  hExecuteButton:sensitive = no. /* code checked by mth 30.07.2015 */

if bttQueryWindow.QueryTextEditorHandle:private-data <> bttQueryWindow.QueryTextEditorHandle:input-value then
do:
  
  bttQueryWindow.QueryTextEditorHandle:private-data = bttQueryWindow.QueryTextEditorHandle:input-value.
  
  run qg_ParseQueryLinks(bttQueryWindow.QueryTextEditorHandle:private-data,
                         bttQueryWindow.QuerySeq,
                         temp-table ttQueryLink:handle).
  
end. /* if bttQueryWindow.QueryTextEditorHandle:private-data <> bttQueryWindow.QueryTextEditorHandle:input-value */

run qg_QueryWindowUpdateAll(string(bttQueryWindow.WindowHandle)).


if bttQueryWindow.QueryHandle:num-results > 0 then
  apply 'entry':U to bttQueryWindow.QueryBrowseHandle.

finally:
  
  if    valid-handle(phWindow)
    and cWindowTitle > '':U then
    phWindow:title = cWindowTitle.
  
  if valid-handle(hExecuteButton) then
    hExecuteButton:sensitive = yes. /* code checked by mth */
  
end finally.

end procedure. /* qg_QueryWindowExecute */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowFieldSelectionBrowseDefaultAction hQueryWindow 
PROCEDURE qg_QueryWindowFieldSelectionBrowseDefaultAction :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Default action trigger of field selection browse.                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iKeyState             as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.FieldSelectionBrowseHandle:deselect-rows().
bttQueryWindow.FieldSelectionBrowseHandle:select-focused-row().

run GetKeyState({&K_WIN_CONST_VK_CTRL},
                output iKeyState).

if iKeyState < 0 then
  run qg_QueryWindowMoveColumn(bttQueryWindow.WindowHandle,
                               yes).

else
  run qg_QueryWindowQueryTextEditorAddCondition(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowFieldSelectionBrowseDefaultAction */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowInsertExternalReference hQueryWindow 
PROCEDURE qg_QueryWindowInsertExternalReference :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Insert external value token into query text.                               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* phEditor                       = Handle of editor into which the external  */
/*                                  reference should be inserted.             */
/* plFieldReference               = Flag to indicate wether a field reference */
/*                                  or a table reference should be inserted.  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow         as handle    no-undo.
define input parameter phEditor         as handle    no-undo.
define input parameter plFieldReference as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i                    as integer   no-undo.
define variable j                    as integer   no-undo.

define variable iStartPos            as integer   no-undo.
define variable iFieldRefPos         as integer   no-undo.
define variable iMaxFieldPos         as integer   no-undo.
define variable hQuery               as handle    no-undo.
define variable hBuffer              as handle    no-undo.
define variable hField               as handle    no-undo.
define variable cReferenceText       as character no-undo init ?.
define variable cEditorText          as character no-undo.
define variable iSelectionStart      as integer   no-undo.
define variable iSelectionEnd        as integer   no-undo.

define variable cTableName           as character no-undo init ?.
define variable cFieldName           as character no-undo init ?.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow      for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*---------------------------------------------------------------o-------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if plFieldReference then
do:
  
  assign
    hQuery      = bttQueryWindow.QueryHandle
    cEditorText = phEditor:input-value
    iStartPos   = max(r-index(cEditorText,
                              '=':U,
                              phEditor:cursor-offset),
                      r-index(cEditorText,
                              '<':U,
                              phEditor:cursor-offset),
                      r-index(cEditorText,
                              '>':U,
                              phEditor:cursor-offset))
    iStartPos   = (if iStartPos = 0 then
                     phEditor:cursor-offset
                   else
                     iStartPos)
    .
  
  /* Try to guess the field name for wich an external reference should be     */
  /* inserted.                                                                */
  
  do i = 1 to hQuery:num-buffers:
    
    hBuffer = hQuery:get-buffer-handle(i).
    
    do j = 1 to hBuffer:num-fields:
      
      hField = hBuffer:buffer-field(j).
      
      iFieldRefPos = r-index(cEditorText,
                             substitute('&1.&2':U, hBuffer:name, hField:name),
                             iStartPos).
      
      if    iFieldRefPos > 0
        and iFieldRefPos > iMaxFieldPos then
        assign
          cTableName   = hBuffer:table
          cFieldName   = hField:name
          iMaxFieldPos = iFieldRefPos
          .
      
    end. /* do j = 1 to hBuffer:num-fields */
    
  end. /* do i = 1 to hQuery:num-buffers */
  
end. /* if plFieldReference */

run qg_GetExternalReference(cTableName,
                            cFieldName,
                            plFieldReference,
                            substitute('!&1,*':U, bttQueryWindow.WindowHandle),
                            bttQueryWindow.WindowHandle,
                            output cReferenceText).

if cReferenceText > '':U then
do:
  
  assign
    iSelectionStart = (if phEditor:selection-start <> ? then
                         phEditor:selection-start
                       else
                         phEditor:cursor-offset)
    iSelectionEnd   = (if phEditor:selection-end <> ? then
                         phEditor:selection-end
                       else
                         phEditor:cursor-offset)
    .
  
  if cEditorText > '':U then
  do:
  
    if    iSelectionStart > 1
      and index('~'"':U, substring(cEditorText, iSelectionStart - 1, 1)) > 0 then
      iSelectionStart = iSelectionStart - 1.
    
    if index('~'"':U, substring(cEditorText, iSelectionEnd, 1)) > 0 then
      iSelectionEnd = iSelectionEnd + 1.
    
    if    iSelectionStart > 0
      and iSelectionEnd  >= iSelectionStart then
      phEditor:set-selection(iSelectionStart, iSelectionEnd).
  
  end. /* if cEditorText > '':U */
  
  if phEditor:selection-text > '':U then
    phEditor:replace-selection-text(cReferenceText).
  else
    phEditor:insert-string(cReferenceText).
  
end. /* cReferenceText */

end procedure. /* qg_QueryWindowInsertExternalReference */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowMoveColumn hQueryWindow 
PROCEDURE qg_QueryWindowMoveColumn :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Move field column to first column.                                         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plFirst                        = If yes the field will be moved to the     */
/*                                  first column. Otherwise it will be moved  */
/*                                  to the last column.                       */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plFirst  as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFieldSelectionBuffer as handle    no-undo.
define variable hQueryBuffer          as handle    no-undo.
define variable hField                as handle    no-undo.
define variable hColumn               as handle    no-undo.
define variable iSelection            as integer   no-undo.
define variable iIndex                as integer   no-undo.
define variable iColumn               as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hFieldSelectionBuffer = bttQueryWindow.FieldSelectionBrowseHandle:query:get-buffer-handle(1)
  hQueryBuffer          = bttQueryWindow.QueryBrowseHandle:query:get-buffer-handle(1)
  .

if plFirst then
do:

  do iSelection = bttQueryWindow.FieldSelectionBrowseHandle:num-selected-rows to 1 by -1:
    
    bttQueryWindow.FieldSelectionBrowseHandle:fetch-selected-row (iSelection).
    hField = hQueryBuffer:buffer-field(hFieldSelectionBuffer::FieldName).
    
    do iIndex = hField:extent to integer(hField:extent > 0) by -1: 
    
      do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:
        
        hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(iColumn).
        
        if    hColumn:buffer-field = hField
          and hColumn:index = iIndex then
        do:
          
          bttQueryWindow.QueryBrowseHandle:move-column(iColumn, 1).
          leave.
          
        end. /* if    hColumn:buffer-field = hField ... */
        
      end. /* do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns */
      
    end. /* do iIndex = integer(hField:extent > 0) to hfield:extent */
    
  end. /* do iSelection = bttQueryWindow.FieldSelectionBrowseHandle:num-selected-rows to 1 by -1 */

end. /* if plFirst */

else
do:
  
  do iSelection = 1 to bttQueryWindow.FieldSelectionBrowseHandle:num-selected-rows:
    
    bttQueryWindow.FieldSelectionBrowseHandle:fetch-selected-row (iSelection).
    hField = hQueryBuffer:buffer-field(hFieldSelectionBuffer::FieldName).
    
    do iIndex = hField:extent to integer(hField:extent > 0) by -1: 
    
      do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:
        
        hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(iColumn).
        
        if    hColumn:buffer-field = hField
          and hColumn:index = iIndex then
        do:
          
          bttQueryWindow.QueryBrowseHandle:move-column(iColumn, bttQueryWindow.QueryBrowseHandle:num-columns).
          leave.
          
        end. /* if    hColumn:buffer-field = hField ... */
        
      end. /* do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns */
      
    end. /* do iIndex = integer(hField:extent > 0) to hfield:extent */
    
  end. /* do iSelection = bttQueryWindow.FieldSelectionBrowseHandle:num-selected-rows to 1 by -1 */
  
end. /* else: if plFirst */

end procedure. /* qg_QueryWindowMoveColumn */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowseDefaultAction hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowseDefaultAction :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Default action trigger of query browse.                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer   as handle    no-undo.
define variable iKeyState as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

if not valid-handle(hBuffer) then
  leave.

run GetKeyState({&K_WIN_CONST_VK_CTRL},
                output iKeyState).

if iKeyState < 0 then
  run qg_OpenRecordWindow(hBuffer).

else
  run qg_QueryWindowEdit(bttQueryWindow.QueryBrowseHandle,
                         hBuffer,
                         {&K_EDITACTION_EDIT},
                         bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowQueryBrowseDefaultAction */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryBrowsePopupMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowQueryBrowsePopupMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Menu drop event trigger for context menu of the query text editor widget.  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer                as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

end procedure. /* qg_QueryWindowQueryBrowsePopupMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorAddCondition hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorAddCondition :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected field(s) as condition(s) to the current query text.           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor               as handle    no-undo.
define variable cQueryText            as character no-undo.
define variable iOffset               as integer   no-undo.
define variable iLineEndOffset        as integer   no-undo.

define variable hBuffer               as handle    no-undo.
define variable hFieldSelectionBrowse as handle    no-undo.
define variable hFieldSelectionBuffer as handle    no-undo.
define variable hField                as handle    no-undo.
define variable i                     as integer   no-undo.
define variable cDatabaseName         as character no-undo.
define variable cFieldList            as character no-undo.
define variable lWhere                as logical   no-undo.
define variable cInsertText           as character no-undo.

define variable iLine                 as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/*----------------------------------------------------------------------------*/
/* Get selection info                                                         */
/*----------------------------------------------------------------------------*/

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  iOffset    = (if hEditor:selection-end = ? then
                  hEditor:cursor-offset
                else
                  hEditor:selection-end - 1)
  .

/*----------------------------------------------------------------------------*/
/* Analyze selection and query text                                           */
/*----------------------------------------------------------------------------*/

iLineEndOffset = index(cQueryText, '~n':U, iOffset).

if iLineEndOffset > 0 then
  iOffset = iLineEndOffset.

run qg_ParseQueryConditions(cQueryText).

/* Don't insert after certain progress keywords. */

find first bttQueryAST
  where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
    and bttQueryAST.TokenStart <= iOffset
    and lookup(bttQueryAST.TokenText, 'BREAK,BY,NO-LOCK,SHARE-LOCK,EXCLUSIVE-LOCK,USE-INDEX':U) > 0
  no-error.

if available bttQueryAST then
do:
  
  iLineEndOffset = r-index(cQueryText, '~n':U, bttQueryAST.TokenStart).
  
  if iLineEndOffset > 0 then
    iOffset = iLineEndOffset.
  
end. /* if available bttQueryAST */

/* Switch where to end if necessary. */

find last bttQueryCondition
  where bttQueryCondition.RightStartPos <= iOffset
    and bttQueryCondition.RightEndPos   >= iOffset
  no-error.

if available bttQueryCondition then
  iOffset = bttQueryCondition.RightEndPos.

lWhere = not can-find(first ttQueryAST
                        where ttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_KEYWORD}
                          and ttQueryAST.TokenText  = 'WHERE':U
                          and ttQueryAST.TokenStart < iOffset).

if lWhere then
do:
  
  find first bttQueryAST
    where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and bttQueryAST.TokenText   = 'WHERE':U
      and bttQueryAST.TokenStart >= iOffset
    no-error.
  
  if available bttQueryAST then
    overlay(cQueryText,
            bttQueryAST.TokenStart,
            bttQueryAST.TokenEnd - bttQueryAST.TokenStart) = 'and':U.
  
end. /* if lWhere */

/*----------------------------------------------------------------------------*/
/* Generate line text.                                                        */
/*----------------------------------------------------------------------------*/

assign
  hBuffer               = bttQueryWindow.QueryBrowseHandle:query:get-buffer-handle(1)
  hFieldSelectionBrowse = bttQueryWindow.FieldSelectionBrowseHandle
  hFieldSelectionBuffer = hFieldSelectionBrowse:query:get-buffer-handle(1)
  .

do i = 1 to hFieldSelectionBrowse:num-selected-rows:
  
  hFieldSelectionBrowse:fetch-selected-row (i).
  
  assign
    hField      = hBuffer:buffer-field(hFieldSelectionBuffer::FieldName)
    cFieldList  = substitute('&1,&2':U, cFieldList, hField:name).
    .
  
end. /* do i = 1 to bttQueryWindow.FieldSelectionBrowseHandle:num-selected-rows */

if not valid-handle(hBuffer:table-handle) then
  cDatabaseName = hBuffer:dbname.

else
do:
  
  cDatabaseName = qg_cParamListReadValue(hBuffer:table-handle:private-data,
                                         'DatabaseName':U,
                                         ',':U).
  
  if cDatabaseName = '':U then
    cDatabaseName = hBuffer:dbname.
  
end. /* if not valid-handle(hBuffer:table-handle) */

assign
  cFieldList  = trim(cFieldList, ',':U)
  cInsertText = qg_cCreateWhereClause(cDatabaseName,
                                      hBuffer:table,
                                      hBuffer:table,
                                      cFieldList,
                                      lWhere,
                                      {&K_VALUE_MODE_DEFAULT_VALUE},
                                      no,
                                      0)
  .

/*----------------------------------------------------------------------------*/
/* Insert text lines.                                                         */
/*----------------------------------------------------------------------------*/

run qg_InsertTextLines(cInsertText,
                       iOffset,
                       input-output cQueryText,
                             output iLine).

/*----------------------------------------------------------------------------*/
/* Update editor                                                              */
/*----------------------------------------------------------------------------*/

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + max(0, num-entries(cInsertText, '~n':U) - 1)).

apply 'entry':U to hEditor.

end procedure. /* qg_QueryWindowQueryTextEditorAddCondition */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorDeleteLines hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorDeleteLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Delete selected lines.                                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.

define variable iLine                     as integer   no-undo.

define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.
define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hEditor     = bttQueryWindow.QueryTextEditorHandle
  cQueryText  = hEditor:input-value
  .

/*----------------------------------------------------------------------------*/
/* Fix connective operator                                                    */
/*----------------------------------------------------------------------------*/

run qg_ParseQueryConditions(cQueryText).

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

if    iSelectionStartLine > 0
  and iSelectionEndLine   > 0 then
do:
  
  assign
    iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                          1)
    iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                          length(entry(iSelectionEndLine,
                                                                       cQueryText,
                                                                       '~n':U)))
    .

  find first bttQueryAST
    where bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
      and bttQueryAST.TokenText = 'WHERE':U
    no-error.
  
  if    available bttQueryAST
    and bttQueryAST.TokenStart >= iSelectionStartLineOffset
    and bttQueryAST.TokenEnd   <= iSelectionEndLineOffset then
  do:
    
    find first bttQueryAST
      where bttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_OPERATOR}
        and bttQueryAST.TokenStart > iSelectionEndLineOffset
        and lookup(bttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= bttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= bttQueryAST.TokenEnd)

      no-error.
    
    if available bttQueryAST then
      cQueryText = substitute('&1where&2':U,
                              substring(cQueryText,
                                        1,
                                        bttQueryAST.TokenStart - 1),
                              substring(cQueryText,
                                        bttQueryAST.TokenEnd)).
      
  end. /* if    bttQueryAST.TokenStart >= iSelectionStartLineOffset */

  /*--------------------------------------------------------------------------*/
  /* Delete line                                                              */
  /*--------------------------------------------------------------------------*/
  
  run qg_DeleteTextLines(iSelectionStart,
                         iSelectionEnd,
                         input-output cQueryText,
                               output iLine).
  
  /*--------------------------------------------------------------------------*/
  /* Beautify query text                                                      */
  /*--------------------------------------------------------------------------*/
  
  cQueryText = qg_cBeautifyQueryText(cQueryText).
  
  assign
    hEditor:screen-value = cQueryText
    hEditor:cursor-line  = iLine
    .
  
end. /* if    iSelectionStartLine > 0 */

end procedure. /* qg_QueryWindowQueryTextEditorDeleteLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorDuplicateLines hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorDuplicateLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected field(s) as condition(s) to the current query text.           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* phBuffer                       = Buffer that contains the field.           */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plDown   as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iLine                     as integer   no-undo.
define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.
define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.
define variable iSelectedLines            as integer   no-undo.

define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.

define variable i                         as integer   no-undo.
define variable iOffset                   as integer   no-undo init 1.
define variable iLineEndOffset            as integer   no-undo.

define variable iRelativeOffset           as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/*----------------------------------------------------------------------------*/
/* Get selection info                                                         */
/*----------------------------------------------------------------------------*/

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  .

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

/*----------------------------------------------------------------------------*/
/* Analyze selection and query text                                           */
/*----------------------------------------------------------------------------*/

assign
  iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                        1)
  iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                        length(entry(iSelectionStartLine,
                                                                     cQueryText,
                                                                     '~n':U))) + 1
  .

run qg_ParseQueryConditions(cQueryText).

find first bttQueryAST
  where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
    and bttQueryAST.TokenStart >= iSelectionStartLineOffset
    and bttQueryAST.TokenEnd   <= iSelectionEndLineOffset
    and bttQueryAST.TokenText   = 'WHERE':U
  use-index TokenType
  no-error.

if available bttQueryAST then
  iRelativeOffset = bttQueryAST.TokenStart - iSelectionStartLineOffset.

/*----------------------------------------------------------------------------*/
/* Move text lines                                                            */
/*----------------------------------------------------------------------------*/

run qg_DuplicateTextLines(iSelectionStart,
                          iSelectionEnd,
                          plDown,
                          input-output cQueryText,
                                output iLine).

/*----------------------------------------------------------------------------*/
/* Fix duplicted lines                                                        */
/*----------------------------------------------------------------------------*/

if available bttQueryAST then
do:
  
  /* Get line offset. */
  
  assign
    iSelectionStartLineOffset = 0
    iSelectionEndLineOffset   = 0
    .
  
  do i = 1 to num-entries(cQueryText, '~n':U):
    
    iLineEndOffset = iOffset + length(entry(i, cQueryText, '~n':U)).
    
    if i = iLine then
      iSelectionStartLineOffset = iOffset.
    
    if i = iLine + iSelectionEndLine - iSelectionStartLine then
    do:
      
      iSelectionEndLineOffset = iLineEndOffset.
      leave.
      
    end. /* if i = iLine + iSelectedLines - 1 */
    
    iOffset = iLineEndOffset + length('~n':U).
    
  end. /* do i = 1 to num-entries(cQueryText, '~n':U) */
  
  iOffset = (if plDown then
               iSelectionStartLineOffset
             else
               iSelectionEndLineOffset + length('~n':U)).
  
  /* Replace "where" by "and". */
  
  if iOffset > 0 then
    overlay(cQueryText,
            iOffset + iRelativeOffset,
            length(bttQueryAST.TokenText)) = 'and':U.
  
end. /* if available bttQueryAST */

/*----------------------------------------------------------------------------*/
/* Update editor                                                              */
/*----------------------------------------------------------------------------*/

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + iSelectionEndLine - iSelectionStartLine).

apply 'entry':U to hEditor.

end procedure. /* qg_QueryWindowQueryTextEditorDuplicateLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorMoveLines hQueryWindow 

PROCEDURE qg_QueryWindowQueryTextEditorMoveLines :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add selected field(s) as condition(s) to the current query text.           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plDown                         = If yes the lines will be moved down.      */
/*                                  Otherwise the lines will be moved up.     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plDown   as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iLine                     as integer   no-undo.
define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.
define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.

define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.
define variable iNextLineOffset           as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer b1ttQueryAST      for temp-table ttQueryAST.
define buffer b2ttQueryAST      for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/*----------------------------------------------------------------------------*/
/* Get selection info                                                         */
/*----------------------------------------------------------------------------*/

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  .

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

/*----------------------------------------------------------------------------*/
/* Analyze selection and query text                                           */
/*----------------------------------------------------------------------------*/

assign
  iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                        1)
  iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                        length(entry(iSelectionStartLine,
                                                                     cQueryText,
                                                                     '~n':U))) + 1
  .

run qg_ParseQueryConditions(cQueryText).

if plDown then
do:
  
  find first b1ttQueryAST
    where b1ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and b1ttQueryAST.TokenStart >= iSelectionStartLineOffset
      and b1ttQueryAST.TokenEnd   <= iSelectionEndLineOffset
      and b1ttQueryAST.TokenText   = 'WHERE':U
    no-error.
  
  if available b1ttQueryAST then
  do:
    
    iNextLineOffset = index(cQueryText,
                            '~n':U,
                            iSelectionEndLineOffset + length('~n':U)).
    
    if iNextLineOffset = 0 then
      iNextLineOffset = length(cQueryText) + 1.
    
    find first b2ttQueryAST
      where b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_OPERATOR}
        and b2ttQueryAST.TokenStart >= iSelectionEndLineOffset
        and b2ttQueryAST.TokenEnd   <= iNextLineOffset
        and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= b2ttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= b2ttQueryAST.TokenEnd)
      no-error.
    
  end. /* if available b1ttQueryAST */
  
end. /* if plDown */

else
do:
  
  iNextLineOffset = r-index(cQueryText,
                            '~n':U,
                            maximum(1, iSelectionStartLineOffset - length('~n':U) - 1)).
  
  if iNextLineOffset = 0 then
    iNextLineOffset = 1.
    
  find first b1ttQueryAST
    where b1ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and b1ttQueryAST.TokenStart >= iNextLineOffset
      and b1ttQueryAST.TokenEnd   <= iSelectionStartLineOffset
      and b1ttQueryAST.TokenText   = 'WHERE':U
    no-error.
  
  if available b1ttQueryAST then
    find first b2ttQueryAST
      where b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_OPERATOR}
        and b2ttQueryAST.TokenStart >= iSelectionStartLineOffset
        and b2ttQueryAST.TokenEnd   <= iSelectionEndLineOffset
        and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= b2ttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= b2ttQueryAST.TokenEnd)
      no-error.
    
end. /* else: if plDown */

if    available b1ttQueryAST
  and available b2ttQueryAST then
  assign
    cQueryText =   substring(cQueryText,
                             1,
                             b1ttQueryAST.TokenStart - 1)
                 + lc(b2ttQueryAST.TokenText)
                 + substring(cQueryText,
                             b1ttQueryAST.TokenEnd,
                             b2ttQueryAST.TokenStart - b1ttQueryAST.TokenEnd)
                 + lc(b1ttQueryAST.TokenText)
                 + substring(cQueryText, b2ttQueryAST.TokenEnd)
    iSelectionStart = iSelectionStart - 5 + length(b2ttQueryAST.TokenText)
        when iSelectionStart > b1ttQueryAST.TokenEnd
    iSelectionStart = iSelectionStart - 5 + length(b1ttQueryAST.TokenText)
        when iSelectionStart > b2ttQueryAST.TokenEnd
    iSelectionEnd = iSelectionEnd - 5 + length(b2ttQueryAST.TokenText)
        when iSelectionEnd > b1ttQueryAST.TokenEnd
    iSelectionEnd = iSelectionEnd - 5 + length(b1ttQueryAST.TokenText)
        when iSelectionEnd > b2ttQueryAST.TokenEnd
    .

/*----------------------------------------------------------------------------*/
/* Move text lines                                                            */
/*----------------------------------------------------------------------------*/

run qg_MoveTextLines(iSelectionStart,
                     iSelectionEnd,
                     plDown,
                     input-output cQueryText,
                           output iLine).

/*----------------------------------------------------------------------------*/
/* Update editor                                                              */
/*----------------------------------------------------------------------------*/

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + iSelectionEndLine - iSelectionStartLine).

apply 'entry':U to hEditor.

end procedure. /* qg_QueryWindowQueryTextEditorMoveLines */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowQueryTextEditorPopupMenuDrop hQueryWindow 
PROCEDURE qg_QueryWindowQueryTextEditorPopupMenuDrop :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Menu drop event trigger for context menu of the query text editor widget.  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hInsertExternalFieldReference as handle    no-undo.
define variable hInsertExternalTableReference as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hInsertExternalFieldReference           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                                                'mi_InsertExternalFieldReference':U)
  hInsertExternalFieldReference:sensitive /* code checked by mth */
      = can-find(first ttQueryWindow
                   where ttQueryWindow.QuerySeq <> bttQueryWindow.QuerySeq)
  hInsertExternalTableReference           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                                                'mi_InsertExternalTableReference':U)
  hInsertExternalTableReference:sensitive /* code checked by mth */
      = hInsertExternalFieldReference:sensitive
  .

end procedure. /* qg_QueryWindowQueryTextEditorPopupMenuDrop */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowRecentQueries hQueryWindow 
PROCEDURE qg_QueryWindowRecentQueries :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show dialog with recently executed queries.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window that contains the widgets.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iOrderLabel as integer   no-undo.

define query brRecentQueriesBrowse
  for ttRecentQueries
  scrolling.

define browse brRecentQueriesBrowse
  query brRecentQueriesBrowse no-lock
    display
      ttRecentQueries.OrderLabel format 'zzzzz9  ':U label 'Ord':U
      ttRecentQueries.QueryLabel format 'x(255)':U label 'Query':U
      with no-assign size 146 by 10.5.

define variable cQueryText as character no-undo
  view-as editor
  no-word-wrap
  scrollbar-horizontal
  scrollbar-vertical
  size 146 by 10
  font 0.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow   for temp-table ttQueryWindow.
define buffer bttRecentQueries for temp-table ttRecentQueries.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

define frame fSelectRecentQuery
  brRecentQueriesBrowse at row 1.5 col 3
  cQueryText at row 12.5 col 3 no-label
  btnOk at row 23.5 col 56
  btnCancel at row 23.5 col 76
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select recent query':U
    side-labels no-underline three-d 
    size 151 by 25.44
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectRecentQuery
  apply 'end-error' to self.

on value-changed of brRecentQueriesBrowse in frame fSelectRecentQuery
do:
  
  if available ttRecentQueries then
    cQueryText = ttRecentQueries.QueryText.
  
  else
    cQueryText = '':U.
  
  display unless-hidden
    cQueryText
    with frame fSelectRecentQuery.
  
end. /* on 'value-changed':U of browse brRecentQueriesBrowse in window fSelectRecentQuery */

on default-action of brRecentQueriesBrowse in frame fSelectRecentQuery
  apply 'go':U to frame fSelectRecentQuery.

/* Refresh display order numbers. */

for each bttRecentQueries
  where bttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
  by Order
  on error undo, throw:
  
  assign
    iOrderLabel                 = iOrderLabel + 1
    bttRecentQueries.OrderLabel = iOrderLabel
    .
  
end. /* for each bttRecentQueries */

open query brRecentQueriesBrowse
  for each ttRecentQueries
    where ttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
    by Order descending.

run qg_InitBrowse(browse brRecentQueriesBrowse:handle).

cQueryText:read-only in frame fSelectRecentQuery = yes.

if query brRecentQueriesBrowse:num-results > 0 then
do:
  
  display unless-hidden
    brRecentQueriesBrowse
    with frame fSelectRecentQuery
      in window bttQueryWindow.WindowHandle. 
  
  brRecentQueriesBrowse:select-row(1) in frame fSelectRecentQuery.
  apply 'value-changed':U to brRecentQueriesBrowse in frame fSelectRecentQuery.
  
end. /* if query brRecentQueriesBrowse:num-results > 0 */

update unless-hidden
  brRecentQueriesBrowse
  cQueryText
  btnOk
  btnCancel
  with frame fSelectRecentQuery
    in window bttQueryWindow.WindowHandle. 

if available ttRecentQueries then
do:
  
  run qg_ExecRecentQuery in target-procedure
                           (bttQueryWindow.WindowHandle,
                            ttRecentQueries.QueryText).
  
  apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.
  
end. /* if available ttRecentQueries */

end procedure. /* qg_QueryWindowRecentQueries */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowResize hQueryWindow 
PROCEDURE qg_QueryWindowResize :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Resize widgets to match the current window size.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window that contains the widgets.         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame       as handle    no-undo.
define variable hFieldGroup  as handle    no-undo.
define variable hWidget      as handle    no-undo.

define variable hSplitter1   as handle    no-undo.
define variable hFieldBrowse as handle    no-undo.

define variable dNewRow      as decimal   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  hSplitter1       = qg_hGetWidgetByName(phWindow, 'btnSplitter1':U)
  hFieldBrowse     = qg_hGetWidgetByName(phWindow, 'brFieldSelection':U)
  hSplitter1:row   = (if hFieldBrowse:hidden then
                        hSplitter1:row
                      else
                        max(4, hSplitter1:row))
  phWindow:height  = max(hSplitter1:row + hSplitter1:height + 3, phWindow:height)
  phWindow:width   = (if hFieldBrowse:hidden then
                        max(50, phWindow:width)
                      else
                        max(100, phWindow:width))
  no-error.

hFrame = phWindow:first-child.

do while valid-handle(hFrame):
  
  if hFrame:name = 'fQuery':U then
    assign
      hFrame:width          = max(1, phWindow:width)
      hFrame:virtual-width  = max(1, phWindow:width)
      hFrame:height         = max(1, phWindow:height)
      hFrame:virtual-height = max(1, phWindow:height)
      hSplitter1:width      = phWindow:width
      hSplitter1:row        = min(phWindow:height - 2,
                                  max((if hFieldBrowse:hidden then
                                         3
                                       else
                                         4),
                                       hSplitter1:row))
      no-error.
  
  hFieldGroup = hFrame:first-child.
  
  do while valid-handle(hFieldGroup):
    
    hWidget = hFieldGroup:first-child.
    
    do while valid-handle(hWidget):
    
      case hWidget:name:
        
        when 'brQuery':U then
          assign
            hWidget:width  = max(1, phWindow:width)
            dNewRow        = hSplitter1:row + hSplitter1:height
            hWidget:height = max(1, phWindow:height - dNewRow + 1)
            hWidget:row    = dNewRow
            no-error.
          
        when 'cQueryText':U then
          assign
            hWidget:width  = (if hFieldBrowse:hidden then
                                max(1, phWindow:width - 23)
                              else
                                max(1, phWindow:width - 73))
            hWidget:height = hSplitter1:row - 1
            .
        
        when 'btnToggleFieldBrowse':U then
          assign
            hWidget:col    = (if hFieldBrowse:hidden then
                                max(1, phWindow:width - 22)
                              else
                                max(1, phWindow:width - 72))
            hWidget:height = hSplitter1:row - 1
            .
        
        when 'brFieldSelection':U then
          if not hWidget:hidden then
            assign
              hWidget:height = hSplitter1:row - 1
              hWidget:col    = max(1, phWindow:width - 69)
              no-error.
        
        when 'btnExecute':U then
          assign
            hWidget:col = max(1, phWindow:width - 19)
            no-error.
        
        when 'btnColumns':U then
          assign
            hWidget:col = max(1, phWindow:width - 19)
            no-error.
        
        when 'btnEdit':U then
          assign
            hWidget:col = max(1, phWindow:width - 19)
            no-error.
        
        when 'btnDelete':U then
          assign
            hWidget:col = max(1, phWindow:width - 19)
            no-error.
        
        when 'btnCreate':U then
          assign
            hWidget:col = max(1, phWindow:width - 19)
            no-error.
        
        when 'btnDuplicate':U then
          assign
            hWidget:col = max(1, phWindow:width - 19)
            no-error.
        
      end. /* case hWidget:name */
  
      hWidget = hWidget:next-sibling.
      
    end. /* do while valid-handle(hWidget) */
    
    hFieldGroup = hFieldGroup:next-sibling.
    
  end. /* do while valid-handle(hFieldGroup) */
  
  /* Since widgets might be moved after the frame has been resized there will */
  /* somtimes be unnessesary scrollbars. As a workaround this can be avoided  */
  /* by setting the width attribute a second time.                            */
  
  if hFrame:name = 'fQuery':U then
    hFrame:width = hFrame:width no-error.
  
  hFrame = hFrame:next-sibling.
  
end. /* do while valid-handle(hFrame) */

end procedure. /* qg_QueryWindowResize */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSelectNextCondition hQueryWindow 
PROCEDURE qg_QueryWindowSelectNextCondition :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Select next condition in query text editor.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* plNext                         = If yes the next condition will be         */
/*                                  selected otherwise the previous condition */
/*                                  will be selected.                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter plNext   as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/


/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext) then
do:
  
  if plNext = yes then
    bttQueryWindow.QueryTextEditorHandle:cursor-offset = 1.
  
  else if plNext = no then
    bttQueryWindow.QueryTextEditorHandle:move-to-eof().
  
  qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext).
  
end. /* if not qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext) */

return no-apply.

end procedure. /* qg_QueryWindowSelectNextCondition */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetFocus hQueryWindow 
PROCEDURE qg_QueryWindowSetFocus :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set focus to given widget.                                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWidget                       = Widget that should receive focus          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWidget as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if phWidget:name = 'cQueryText':U then
do:
  
  phWidget:cursor-offset = 1.
  qg_lSelectNextQueryCondition(phWidget, yes).
  
end. /* if phWidget:name = 'cQueryText':U */

apply 'entry':U to phWidget.

end procedure. /* qg_QueryWindowSetFocus */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetQueryText hQueryWindow 
PROCEDURE qg_QueryWindowSetQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set query text to given editor and place cursor to the first value.        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phEditor                       = Editor widget.                            */
/* pcQueryText                    = Query text.                               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phEditor    as handle    no-undo.
define input parameter pcQueryText as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  phEditor:screen-value  = pcQueryText
  phEditor:cursor-offset = 1
  .

qg_lSelectNextQueryCondition(phEditor, yes).

end procedure. /* qg_QueryWindowSetQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSetSize hQueryWindow 
PROCEDURE qg_QueryWindowSetSize :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set Query window to a predefined size.                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* piSize                         = Size code to use.                         */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.
define input parameter piSize   as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hSplitter1      as handle    no-undo.
define variable hFieldBrowse    as handle    no-undo.

define variable dSplitterMinRow as decimal   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hSplitter1      = qg_hGetWidgetByName(phWindow, 'btnSplitter1':U)
  hFieldBrowse    = qg_hGetWidgetByName(phWindow, 'brFieldSelection':U)
  dSplitterMinRow = (if hFieldBrowse:hidden then
                       3
                     else
                       4)
  .

case piSize:
  
  when {&K_QUERY_SIZE_MODE_DEFAULT} then
    assign
      hSplitter1:row                     = 7
      bttQueryWindow.WindowHandle:width  = 235
      bttQueryWindow.WindowHandle:height = 32
      no-error.
  
  when {&K_QUERY_SIZE_MODE_SMALL} then
  do:
    
    if    bttQueryWindow.WindowHandle:width  = 150
      and bttQueryWindow.WindowHandle:height = 18 then
    do:

      if hSplitter1:row < 7 then
        hSplitter1:row = truncate(hSplitter1:row, 0) + 1.

      else
        hSplitter1:row = dSplitterMinRow.

    end. /* if    bttQueryWindow.WindowHandle:width  = 150 */
    
    assign
      hSplitter1:row                     = (if hSplitter1:row > 7 then
                                              7
                                            else
                                              hSplitter1:row)
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = 18
      no-error.
      
    
  end. /* when {&K_QUERY_SIZE_MODE_SMALL} */

  when {&K_QUERY_SIZE_MODE_SMALLER} then
    assign
      hSplitter1:row                     = dSplitterMinRow
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = hSplitter1:row + hSplitter1:height + 3
      no-error.
      

  when {&K_QUERY_SIZE_MODE_MINIMUM} then
    assign
      hSplitter1:row                     = dSplitterMinRow
      bttQueryWindow.WindowHandle:width  = (if hFieldBrowse:hidden then
                                              50
                                            else
                                              100)
      bttQueryWindow.WindowHandle:height = hSplitter1:row + hSplitter1:height + 3
      no-error.
  
  otherwise
    leave.
  
end case. /* piSize */

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowSetSize */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowAll hQueryWindow 
PROCEDURE qg_QueryWindowShowAll :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show all query records (remove where clause).                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcTableName                    = Table name for the query.                 */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow    as handle    no-undo.
define input parameter pcTableName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.QueryTextEditorHandle:screen-value = substitute('for each &1':U,
                                                               pcTableName).

run qg_QueryWindowExecute(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowShowAll */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowChildWindows hQueryWindow 
PROCEDURE qg_QueryWindowShowChildWindows :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show all query windows that are linked to this query window.               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piSourceSeq                    = QuerySeq of the query window.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piSourceSeq as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttQueryLink
  where bttQueryLink.SourceSeq = piSourceSeq,
first bttQueryWindow
  where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
  on error undo, throw:
  
  run qg_QueryWindowShowChildWindows(bttQueryWindow.QuerySeq).
  
  if bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
    bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_NORMAL}.
  
  bttQueryWindow.WindowHandle:move-to-top().
  
end. /* for each bttQueryLink */

end procedure. /* qg_QueryWindowShowChildWindows */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowIndex hQueryWindow 
PROCEDURE qg_QueryWindowShowIndex :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Creates a dummy query for the given index and executes it.                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcDatabaseName                 = Database name for query.                  */
/* pcTableName                    = Table name for the query.                 */
/* pcFieldList                    = Field list for where condition of the     */
/*                                  query.                                    */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow       as handle    no-undo.
define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cIndexName as character no-undo.
define variable lOk        as logical   no-undo.
define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndex       for temp-table ttIndex.
define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

run qg_SelectIndex(pcDatabaseName,
                   pcTableName,
                   input-output cIndexName,
                         output lOk,
                   bttQueryWindow.WindowHandle).

if lOk then
do:
  
  find bttIndex
    where bttIndex.DatabaseName = pcDatabaseName
      and bttIndex.TableName    = pcTableName
      and bttIndex.IndexName    = cIndexName
    no-error.
  
  if available bttIndex then
  do:
    
    assign
      cQueryText                                        = substitute('for each &1':U,
                                                                     bttIndex.TableName)
      cQueryText                                        = substitute('&1~n&2~n':U,
                                                                     cQueryText,
                                                                     qg_cCreateWhereClause(bttIndex.DatabaseName,
                                                                                           bttIndex.TableName,
                                                                                           bttIndex.TableName,
                                                                                           bttIndex.IndexFieldList,
                                                                                           yes,
                                                                                           {&K_VALUE_MODE_DEFAULT_VALUE},
                                                                                           no,
                                                                                           2))
      .
    
    run qg_QueryWindowSetQueryText(bttQueryWindow.QueryTextEditorHandle,
                                   cQueryText).
    
    run qg_QueryWindowExecute(bttQueryWindow.WindowHandle).
    
    apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.
    
  end. /* if available bttIndex */
  
end. /* if lOk */

end procedure. /* qg_QueryWindowShowIndex */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowShowQueryText hQueryWindow 
PROCEDURE qg_QueryWindowShowQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show actual query text with resolved external tokens.                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo
  view-as editor
  no-word-wrap
  scrollbar-horizontal
  scrollbar-vertical
  size 146 by 14.5
  font 0.

define button btnClose
  label 'Close':T
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

define frame fQueryText
  cQueryText at row 1.5 col 3 no-labels
  btnClose at row 16.5 col 66
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 151 by 18.44
    title gcTitlePrefix + 'Query text of query browse':T
    default-button btnClose
    cancel-button btnClose.

on window-close of frame fQueryText
  apply 'end-error' to self.

assign
  cQueryText                               = bttQueryWindow.QueryHandle:prepare-string
  cQueryText:read-only in frame fQueryText = yes
  .

update unless-hidden
  cQueryText
  btnClose
  with frame fQueryText
    in window bttQueryWindow.WindowHandle.

end procedure. /* qg_QueryWindowShowQueryText */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowSortByIndex hQueryWindow 
PROCEDURE qg_QueryWindowSortByIndex :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add Sort options for a given index.                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcDatabaseName                 = Database name.                            */
/* pcTableName                    = Table name.                               */
/* pcIndexName                    = Index name.                               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow       as handle    no-undo.
define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cIndexName     as character no-undo.
define variable lOk            as logical   no-undo.
define variable cSortFieldList as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndexField for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

run qg_SelectIndex(pcDatabaseName,
                   pcTableName,
                   input-output cIndexName,
                         output lOk,
                   phWindow).

if lOk then
do:
  
  for each bttIndexField
    where bttIndexField.DatabaseName = pcDatabasename
      and bttIndexField.TableName    = pcTableName 
      and bttIndexField.IndexName    = cIndexName
    by DatabaseName by TableName by IndexName by IndexSequence
    on error undo, throw:
    
    cSortFieldList = substitute('&1,&2.&3&4':U,
                                cSortFieldList,
                                bttIndexField.TableName,
                                bttIndexField.FieldName,
                                (if bttIndexField.SortAscending then
                                   '':U
                                 else
                                   ' descending':U)).
    
  end. /* for each bttIndexField */

  cSortFieldList = trim(cSortFieldList, ',':U).
  
  if num-entries(cSortFieldList) > 0 then
    run qg_QueryWindowAddSortFields(phWindow,
                                    cSortFieldList).
  
end. /* if lOk */

end procedure. /* qg_QueryWindowSortByIndex */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowToggleFieldList hQueryWindow 
PROCEDURE qg_QueryWindowToggleFieldList :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Toggle field list visibility.                                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow   as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame                   as handle    no-undo.
define variable hToggleFieldBrowseButton as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

/* If the field selection browse should be displayed we first have to make    */
/* sure that it will fit into the frame to avoid errors.                      */

if bttQueryWindow.FieldSelectionBrowseHandle:hidden then
  assign
    hFrame                                           = qg_hGetWidgetByName(phWindow, 'fQuery':U)
    bttQueryWindow.WindowHandle:width                = max(100, bttQueryWindow.WindowHandle:width)
    hFrame:width                                     = bttQueryWindow.WindowHandle:width
    bttQueryWindow.FieldSelectionBrowseHandle:height = 3
    bttQueryWindow.FieldSelectionBrowseHandle:col    = max(1, bttQueryWindow.WindowHandle:width - 72)
    no-error.
  
/* Now we can toggle the hidden state. */

assign
  bttQueryWindow.FieldSelectionBrowseHandle:hidden = not bttQueryWindow.FieldSelectionBrowseHandle:hidden
  hToggleFieldBrowseButton                         = qg_hGetWidgetByName(phWindow, 'btnToggleFieldBrowse':U)
  hToggleFieldBrowseButton:label                   = (if bttQueryWindow.FieldSelectionBrowseHandle:hidden then
                                                        '<':T
                                                      else
                                                        '>':T)
  hToggleFieldBrowseButton:tooltip                 = (if bttQueryWindow.FieldSelectionBrowseHandle:hidden then
                                                        'Show field list':T
                                                      else
                                                        'Hide field List':T)
  .

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure. /* qg_QueryWindowToggleFieldList */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdate hQueryWindow 
PROCEDURE qg_QueryWindowUpdate :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Execute current query text of given query window.                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Window handle of the query window that    */
/*                                  should be updated.                        */
/* pcForceUpdateWindowList        = List of window handles that should be up- */
/*                                  dated even if the query text is un-       */
/*                                  changed.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow                as handle    no-undo.
define input parameter pcForceUpdateWindowList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cWindowTitle as character no-undo.
define variable cQueryText   as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

assign
  cWindowTitle   = phWindow:title
  phWindow:title = substitute('&1 (updating ...)':U,
                              qg_cParamListReadValue(phWindow:private-data,
                                                     'WindowTitle':U,
                                                     ',':U))
  .

cQueryText = qg_cSubstituteQueryLinkTokens(bttQueryWindow.WindowHandle).

if   can-do(pcForceUpdateWindowList, string(bttQueryWindow.WindowHandle))
  or cQueryText <> bttQueryWindow.QueryHandle:prepare-string then
do:
  
  qg_lQueryOpen(bttQueryWindow.QueryHandle,
                cQueryText,
                bttQueryWindow.WindowHandle).
  
  run qg_AddRecentQuery(bttQueryWindow.WindowHandle).
  
end. /* if   can-do(pcForceUpdateWindowList, string(bttQueryWindow.WindowHandle)) ... */

finally:
  
  if    valid-handle(phWindow)
    and cWindowTitle > '':U then
    phWindow:title = cWindowTitle.
  
end finally.

end procedure. /* qg_QueryWindowUpdate */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdateAll hQueryWindow 
PROCEDURE qg_QueryWindowUpdateAll :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Refresh all Query windows.                                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcForceUpdateWindowList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow            for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

/* Check for circular references and reset update flags. */
for each bttQueryWindow
  on error undo, throw:
  
  if not qg_lCheckLinkReference(bttQueryWindow.QuerySeq,
                                '':U) then
  do:
    
    message /* code checked by mth */
      substitute('Circular reference detected in Query window &1':T,
                 string(bttQueryWindow.QuerySeq)) skip
      view-as alert-box
      error
      buttons ok
      in window bttQueryWindow.WindowHandle.
    
    return error.
    
  end. /* if    valid-handle(bttQueryWindow.WindowHandle) */
  
  bttQueryWindow.Updated = no.
  
end. /* for each bttQueryWindow */

/* Refresh query windows. */

for each bttQueryWindow
  where not can-find(first ttQueryLink
                       where ttQueryLink.SourceSeq = bttQueryWindow.QuerySeq)
  on error undo, throw:
  
  if valid-handle(bttQueryWindow.WindowHandle) then
    run qg_QueryWindowUpdateRecursive(bttQueryWindow.WindowHandle,
                                      pcForceUpdateWindowList).
  
end. /* for each bttQueryWindow */

end procedure. /* qg_QueryWindowUpdateAll */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_QueryWindowUpdateRecursive hQueryWindow 
PROCEDURE qg_QueryWindowUpdateRecursive :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update all query windows that are linked to given query window.            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the Query window.               */
/* pcForceUpdateWindowList        = List of window handles that should be up- */
/*                                  dated even if the query text is un-       */
/*                                  changed.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow                as handle    no-undo.
define input parameter pcForceUpdateWindowList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer b2ttQueryWindow for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

if bttQueryWindow.Updated then
  leave.

for each bttQueryLink
  where bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq,
first b2ttQueryWindow
  where b2ttQueryWindow.QuerySeq = bttQueryLink.SourceSeq
  break by bttQueryLink.SourceSeq
  on error undo, throw:
  
  if first-of(bttQueryLink.SourceSeq) then
    run qg_QueryWindowUpdateRecursive(b2ttQueryWindow.WindowHandle,
                                      pcForceUpdateWindowList).
  
end. /* for each bttQueryLink */

run qg_QueryWindowUpdate(bttQueryWindow.WindowHandle,
                         pcForceUpdateWindowList).

bttQueryWindow.Updated = yes.

end procedure. /* qg_QueryWindowUpdateRecursive */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowClose hQueryWindow 
PROCEDURE qg_RecordWindowClose :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Close record window (and clean up dynamically created widgets).            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.
define buffer bttRecordField  for temp-table ttRecordField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

if valid-handle(bttRecordWindow.WindowHandle) then
do:
  
  run qg_DeleteWidgetTree(bttRecordWindow.WindowHandle, yes).
  
  delete object bttRecordWindow.BufferHandle.
  
end. /* if valid-handle(bttRecordWindow.WindowHandle */

for each bttRecordField
  where bttRecordField.WindowHandle = bttRecordWindow.WindowHandle
  on error undo, throw:
  
  delete bttRecordField.
  
end. /* for each bttRecordField */

delete bttRecordWindow.

end procedure. /* qg_RecordWindowClose */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowCopyValue hQueryWindow 
PROCEDURE qg_RecordWindowCopyValue :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Copy selected record field value.                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer    as handle    no-undo.
define variable hRawValues as handle    no-undo.
define variable lRawValues as logical   no-undo.
define variable clValue    as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

hBuffer = bttRecordWindow.QueryHandle:get-buffer-handle(1).

if not hBuffer:available then
  message /* code checked by mth */
    'No field is selected':T skip
    view-as alert-box
    error
    buttons ok.
  
else
do:
  
  assign
    hRawValues = qg_hGetWidgetByName(bttRecordWindow.WindowHandle, 'lRawValues':U)
    lRawValues = hRawValues:input-value
    .
  
  if lRawValues then
    copy-lob hBuffer::CurrentUnformattedValue to clValue.
  
  else
    copy-lob hBuffer::CurrentFormattedValue to clValue.
  
  clipboard:value = clValue.
    
end. /*  */
  

end procedure. /* qg_RecordWindowCopyValue */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowFieldDetails hQueryWindow 
PROCEDURE qg_RecordWindowFieldDetails :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show field details dialog for selected field.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer    as handle    no-undo.
define variable hField     as handle    no-undo.
define variable hRawValues as handle    no-undo.
define variable lRawValues as logical   no-undo.
define variable clValue    as longchar  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

hBuffer = bttRecordWindow.QueryHandle:get-buffer-handle(1).

if not hBuffer:available then
  message /* code checked by mth */
    'No field is selected':T skip
    view-as alert-box
    error
    buttons ok
    in window bttRecordWindow.WindowHandle.
  
else
do:
  
  assign
    hField     = bttRecordWindow.BufferHandle:buffer-field(hBuffer::FieldName)
    hRawValues = qg_hGetWidgetByName(bttRecordWindow.WindowHandle, 'lRawValues':U)
    lRawValues = hRawValues:input-value
    .
  
  if lRawValues then
    copy-lob from hBuffer::CurrentUnformattedValue to clValue.
  
  else
    copy-lob from hBuffer::CurrentFormattedValue to clValue.
    
  run qg_EditFieldValue(hField:name,
                        hField:data-type,
                        hField:format,
                        hField:view-as,
                        lRawValues,
                        no,
                        input-output clValue,
                        bttRecordWindow.WindowHandle).
  
end. /* else: if not hBuffer:available */

apply 'entry':U to bttRecordWindow.BrowseHandle.
  
end procedure. /* qg_RecordWindowFieldDetails */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowOpenQuery hQueryWindow 
PROCEDURE qg_RecordWindowOpenQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open query for record field browse.                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cQueryText as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

assign
  cQueryText =   'for each ttRecordField':U
               + '  where ttRecordField.WindowHandle = ~'&1~'':U
               + '    and ttRecordField.Order        > 0':U
               + '  use-index &2':U
  cQueryText = substitute(cQueryText,
                          string(bttRecordWindow.WindowHandle),
                          (if can-find(first ttRecordField
                                         where ttRecordField.WindowHandle = bttRecordWindow.WindowHandle
                                           and ttRecordField.Order        > 1) then
                             'Order':U
                           else
                             'Main':U))
  .

qg_lQueryOpen(bttRecordWindow.QueryHandle,
              cQueryText,
              bttRecordWindow.WindowHandle).

end procedure. /* qg_RecordWindowOpenQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowRefresh hQueryWindow 
PROCEDURE qg_RecordWindowRefresh :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Refresh record field browse with current database values.                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

/* Update fields. */

run qg_UpdateRecordFieldTempTable(bttRecordWindow.BufferHandle,
                                  bttRecordWindow.WindowHandle,
                                  bttRecordWindow.SelectedFieldList).

run qg_RecordWindowOpenQuery(bttRecordWindow.WindowHandle).
run qg_RecordWindowUpdateValues(bttRecordWindow.WindowHandle).

/* Update window title. */

run qg_RecordWindowUpdateWindowTitle(bttRecordWindow.WindowHandle).

end procedure. /* qg_RecordWindowRefresh */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowResize hQueryWindow 
PROCEDURE qg_RecordWindowResize :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Adjust all widgets size and position according to current window size.     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame      as handle    no-undo.
define variable hFieldGroup as handle    no-undo.
define variable hWidget     as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

assign
  phWindow:height  = max(6, phWindow:height)
  phWindow:width   = max(65, phWindow:width)
  .

hFrame = phWindow:first-child.

do while valid-handle(hFrame):
  
  case hFrame:name:
    
    when 'fRecord':U then
      assign
        hFrame:width          = max(1, phWindow:width)
        hFrame:virtual-width  = max(1, phWindow:width)
        hFrame:height         = max(1, phWindow:height)
        hFrame:virtual-height = max(1, phWindow:height)
        no-error.
      
  end. /* case hFrame:name */
  
  hFieldGroup = hFrame:first-child.
  
  do while valid-handle(hFieldGroup):
    
    hWidget = hFieldGroup:first-child.
    
    do while valid-handle(hWidget):
    
      case hWidget:name:
        
        when 'brRecord':U then
          assign
            hWidget:width  = max(1, phWindow:width)
            hWidget:height = max(1, phWindow:height - hWidget:row + 1)
            no-error.
        
        when 'btnRefresh':U then
          hWidget:col = max(1, phWindow:width - 20 - 1) no-error.
        
      end. /* case hWidget:name */
  
      hWidget = hWidget:next-sibling.
      
    end. /* do while valid-handle(hWidget) */
    
    hFieldGroup = hFieldGroup:next-sibling.
    
  end. /* do while valid-handle(hFieldGroup) */
  
  hFrame = hFrame:next-sibling.
  
end. /* do while valid-handle(hFrame) */

end procedure. /* qg_RecordWindowResize */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowSelectFields hQueryWindow 
PROCEDURE qg_RecordWindowSelectFields :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Select displayed fields.                                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cFieldName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.
define buffer bttRecordField  for temp-table ttRecordField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

run qg_SelectionDialog(bttRecordWindow.FieldList,
                       input-output bttRecordWindow.SelectedFieldList,
                       'Select fields':U,
                       bttRecordWindow.WindowHandle,
                       yes).

for each bttRecordField
  where bttRecordField.WindowHandle = bttRecordWindow.WindowHandle
  on error undo, throw:
  
  assign
    cFieldName           = (if bttRecordField.FieldExtent = 0 then
                              bttRecordField.FieldName
                            else
                              substitute('&1[&2]':U,
                                         bttRecordField.FieldName,
                                         string(bttRecordField.FieldExtent)))
    bttRecordField.Order = (if bttRecordWindow.SelectedFieldList > '':U then
                              lookup(cFieldName, bttRecordWindow.SelectedFieldList)
                            else
                              1)
    .
  
end. /* for each bttRecordField */

run qg_RecordWindowOpenQuery(bttRecordWindow.WindowHandle).
run qg_RecordWindowUpdateValues(bttRecordWindow.WindowHandle).

end procedure. /* qg_RecordWindowSelectFields */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowUpdateValues hQueryWindow 
PROCEDURE qg_RecordWindowUpdateValues :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Refresh displayed values of record field browse.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hRawValues as handle    no-undo.
define variable lRawValues as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.
define buffer bttRecordField  for temp-table ttRecordField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

assign
  hRawValues = qg_hGetWidgetByName(bttRecordWindow.WindowHandle, 'lRawValues':U)
  lRawValues = (   not valid-handle(hRawValues)
                or logical(hRawValues:input-value) <> no)
  .

for each bttRecordField
  where bttRecordField.WindowHandle = bttRecordWindow.WindowHandle
  on error undo, throw:
  
  run qg_UpdateRecordFieldDisplayValue((buffer bttRecordField:handle),
                                        lRawValues,
                                        255). 
  
end. /* for each bttRecordField */

if bttRecordWindow.QueryHandle:num-results > 0 then
  bttRecordWindow.BrowseHandle:refresh().

end procedure. /* qg_RecordWindowUpdateValues */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RecordWindowUpdateWindowTitle hQueryWindow 
PROCEDURE qg_RecordWindowUpdateWindowTitle :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update record window title.                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phWindow                       = Handle of the record window.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttRecordWindow
  where bttRecordWindow.WindowHandle = phWindow
  no-error.

if not available bttRecordWindow then
  leave.

assign
  bttRecordWindow.WindowTitle        = substitute('Record - &1.&2 (&3)':U,
                                                  bttRecordWindow.DatabaseName,
                                                  bttRecordWindow.BufferHandle:table,
                                                  qg_cGetPrimaryKeyValues(bttRecordWindow.BufferHandle, ' ':U, no))
  bttRecordWindow.WindowHandle:title = substitute('&1&2':U,
                                                  gcTitlePrefix,
                                                  bttRecordWindow.WindowTitle)
  .

end procedure. /* qg_RecordWindowUpdateWindowTitle */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RefreshDatabaseBrowse hQueryWindow 
PROCEDURE qg_RefreshDatabaseBrowse :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Fill temp-table ttDatabase if necessary and refresh browse brDatabase.     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcSelectedDatabaseName         = Name of the database that shuld be        */
/*                                  selected after refresh. If ? then the     */
/*                                  first database will be selected.          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcSelectedDatabaseName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i             as integer   no-undo.
define variable cDatabaseName as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for temp-table ttDatabase.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

do i = 1 to num-dbs:
  
  cDatabaseName = ldbname(i).
  
  if not can-find(first ttDatabase
                    where ttDatabase.DatabaseName = cDatabaseName) then
    run qg_AddDatabase(cDatabaseName).
  
end. /* do i = 1 to num-dbs */

{&OPEN-QUERY-brDatabase}

if pcSelectedDatabaseName <> ? then
do:
  
  find bttDatabase
    where bttDatabase.DatabaseName =  pcSelectedDatabaseName
    no-error.
  
  if available bttDatabase then
    reposition brDatabase to rowid rowid(bttDatabase).
  
end. /* if pcSelectedDatabaseName <> ? */

apply 'value-changed':U to brDatabase in frame fQuery.

end procedure. /* qg_RefreshDatabaseBrowse */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RefreshFieldBrowse hQueryWindow 
PROCEDURE qg_RefreshFieldBrowse :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Refresh content of the field browse.                                       */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabase         as character no-undo.
define variable cTable            as character no-undo.

define variable i                 as integer   no-undo.

define variable cFilterEntry      as character no-undo.
define variable cFieldFilter      as character no-undo.
define variable cFieldLabelFilter as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cDatabase           = (if available(ttDatabase) then
                           ttDatabase.DatabaseName
                         else
                           '':U)
  cTable              = (if available(ttTable) then
                           ttTable.TableName
                         else
                           '':U)
  gcFieldFilter      = input frame {&FRAME-NAME} gcFieldFilter
  gcFieldLabelFilter = input frame {&FRAME-NAME} gcFieldLabelFilter
  .

do i = 1 to num-entries(gcFieldFilter, ',':U):
  
  assign
    cFilterEntry = entry(i, gcFieldFilter, ',':U)
    cFieldFilter = substitute('&1,&2':U,
                              cFieldFilter,
                              qg_cFilterEntryMatchcode(cFilterEntry))
    .
  
end. /* do i = 1 to num-entries(gcFieldFilter, ',':U) */

cFieldFilter = (if cFieldFilter = '':U then
                  '*':U
                else
                  trim(cFieldFilter, ',':U)).

do i = 1 to num-entries(gcFieldLabelFilter, ',':U):
  
  assign
    cFilterEntry      = entry(i, gcFieldLabelFilter, ',':U)
    cFieldLabelFilter = substitute('&1,&2':U,
                                   cFieldLabelFilter,
                                   qg_cFilterEntryMatchcode(cFilterEntry))
    .
  
end. /* do i = 1 to num-entries(gcFieldFilter, ',':U) */

cFieldLabelFilter = (if cFieldLabelFilter = '':U then
                       '*':U
                     else
                       trim(cFieldLabelFilter, ',':U)).

for each bttField
  where bttField.DatabaseName = cDatabase
    and bttField.TableName    = cTable
  on error undo, throw:
  
  bttField.FieldFilterMatches =     can-do(cFieldFilter, bttField.FieldName)
                                and can-do(cFieldLabelFilter, bttField.FieldLabel)
                                and can-do(gcFieldDatatypeFilter, bttField.DataType).
  
end. /* for each ttField */

{&OPEN-QUERY-brField}

apply 'value-changed':U to brField in frame {&FRAME-NAME}.

end procedure. /* qg_RefreshFieldBrowse */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RefreshIndexBrowse hQueryWindow 
PROCEDURE qg_RefreshIndexBrowse :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Fill index selection-list widget with all cached inidces of the currently  */
/* selected table.                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabase         as character no-undo.
define variable cTable            as character no-undo.

define variable cFilterEntry      as character no-undo.
define variable cIndexFilter      as character no-undo.
define variable cIndexFieldFilter as character no-undo.

define variable i                 as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndex      for temp-table ttIndex.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cDatabase          = (if available ttDatabase then
                          ttDatabase.DatabaseName
                        else
                          '':U)
  cTable             = (if available ttTable then
                          ttTable.TableName
                        else
                          '':U)
  gcIndexFilter      = input frame {&FRAME-NAME} gcIndexFilter
  gcIndexFieldFilter = input frame {&FRAME-NAME} gcIndexFieldFilter
  .

do i = 1 to num-entries(gcIndexFilter, ',':U):
  
  assign
    cFilterEntry = entry(i, gcIndexFilter, ',':U)
    cIndexFilter = substitute('&1,&2':U,
                              cIndexFilter,
                              qg_cFilterEntryMatchcode(cFilterEntry))
    .
  
end. /* do i = 1 to num-entries(gcIndexFilter, ',':U) */

cIndexFilter = (if cIndexFilter = '':U then
                  '*':U
                else
                  trim(cIndexFilter, ',':U)).

do i = 1 to num-entries(gcIndexFieldFilter):
  
  assign
    cFilterEntry      = entry(i, gcIndexFieldFilter, ',':U)
    cIndexFieldFilter = substitute('&1,&2':U,
                                   cIndexFieldFilter,
                                   qg_cFilterEntryMatchcode(cFilterEntry))
    .
  
end. /* do i = 1 to num-entries(cIndexFieldFilter) */

cIndexFieldFilter = (if cIndexFieldFilter = '':U then
                       '*':U
                     else
                       trim(cIndexFieldFilter, ',':U)).

for each bttIndex
  where bttIndex.DatabaseName = cDatabase
    and bttIndex.TableName    = cTable
  on error undo, throw:
  
  assign
    bttIndex.IndexFilterMatches      = can-do(cIndexFilter, bttIndex.IndexName)
    bttIndex.IndexFieldFilterMatches = yes
    .
  
  do i = 1 to num-entries(cIndexFieldFilter):
    
    assign
      cFilterEntry                     = entry(i, cIndexFieldFilter, ',':U)
      bttIndex.IndexFieldFilterMatches =     bttIndex.IndexFieldFilterMatches
                                         and can-find(first ttIndexField
                                                        where ttIndexField.DatabaseName = cDatabase
                                                          and ttIndexField.TableName    = bttIndex.TableName
                                                          and ttIndexField.IndexName    = bttIndex.IndexName
                                                          and can-do(cFilterEntry, ttIndexField.FieldName))
      .
    
    if not bttIndex.IndexFieldFilterMatches then
      leave.
    
  end. /* do i = 1 to num-entries(cIndexFieldFilter) */
    
end. /* for each bttIndex */

{&OPEN-QUERY-brIndex}

find first bttIndex
  where bttIndex.DatabaseName            = cDatabase
    and bttIndex.TableName               = cTable
    and bttIndex.IsPrimary               = yes
    and bttIndex.IndexFilterMatches      = yes
    and bttIndex.IndexFieldFilterMatches = yes
  no-error.

if available(bttIndex) then
  reposition brIndex to rowid rowid(bttIndex).

apply 'value-changed':U to brIndex in frame {&FRAME-NAME}.

end procedure. /* qg_RefreshIndexBrowse */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RefreshTableBrowse hQueryWindow 
PROCEDURE qg_RefreshTableBrowse :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Fill table selection-list widget with all cached tables of the currently   */
/* selected database.                                                         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName     as character no-undo.

define variable i                 as integer   no-undo.
define variable cFilterEntry      as character no-undo.
define variable cTableFilter      as character no-undo.
define variable cTableFieldFilter as character no-undo.

define variable cTableNames       as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for ttDatabase.
define buffer bttTable    for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cDatabaseName      = (if available ttDatabase then
                          ttDatabase.DatabaseName
                        else
                          '':U)
  gcTableFilter      = input frame {&FRAME-NAME} gcTableFilter
  gcTableFieldFilter = input frame {&FRAME-NAME} gcTableFieldFilter
  .

find first bttDatabase
  where bttDatabase.DatabaseName = cDatabasename
  no-error.

if    available(bttDatabase)
  and bttDatabase.PhysicalDB
  and not can-find(first ttTable
                     where ttTable.DatabaseName = bttDatabase.DatabaseName) then
  run qg_AddTables(bttDatabase.DatabaseName).

/* Tune table filter. */
do i = 1 to num-entries(gcTableFilter):
  
  assign
    cFilterEntry = entry(i, gcTableFilter, ',':U)
    cTableFilter = substitute('&1,&2':U,
                              cTableFilter,
                              qg_cFilterEntryMatchcode(cFilterEntry))
    .
  
end. /* do i = 1 to num-entries(gcTableFilter) */

cTableFilter = (if cTableFilter = '':U then
                  '*':U
                else
                  trim(cTableFilter, ',':U)).

/* Tune table field filter. */
do i = 1 to num-entries(gcTableFieldFilter):
  
  assign
    cFilterEntry      = entry(i, gcTableFieldFilter, ',':U)
    cTableFieldFilter = substitute('&1,&2':U,
                                   cTableFieldFilter,
                                   qg_cFilterEntryMatchcode(cFilterEntry))
    .
  
end. /* do i = 1 to num-entries(gcTableFieldFilter) */

cTableFieldFilter = (if cTableFieldFilter = '':U then
                       '*':U
                     else
                       trim(cTableFieldFilter, ',':U)).

/* Check ttTable for filter matches und update flags. */
for each bttTable
  where bttTable.DatabaseName = cDatabaseName
  on error undo, throw:
  
  cTableNames = bttTable.TableName.
  
  if    available ttDatabase
    and ttDatabase.TempDB
    and bttTable.TableName begins 'td':U then
    cTableNames = substitute('&1,tt&2':U,
                             cTableNames,
                             substring(cTableNames, 3)).
  
  bttTable.TableFilterMatches = no.
  
  do i = 1 to num-entries(cTableNames):
    
    if can-do(cTableFilter, entry(i, cTableNames)) then
    do:
      bttTable.TableFilterMatches = yes. 
      leave.
    end. /* if can-do(cTableFilter, entry(i, cTableNames)) */
    
  end. /* do i = 1 to num-entries(cTableNames) */
  
  bttTable.TableFieldFilterMatches = yes.
  
  do i = 1 to num-entries(cTableFieldFilter):
    
    assign
      cFilterEntry                     = entry(i, cTableFieldFilter, ',':U)
      bttTable.TableFieldFilterMatches =       bttTable.TableFieldFilterMatches
                                         and can-find(first ttField
                                                        where ttField.DatabaseName = cDatabaseName
                                                          and ttField.TableName    = bttTable.TableName
                                                          and can-do(cFilterEntry, ttField.FieldName))
      .
    
    if not bttTable.TableFieldFilterMatches then
      leave.
    
  end. /* do i = 1 to num-entries(cTableFieldFilter) */
  
end. /* for each bttTable */

{&OPEN-QUERY-brTable}

apply 'value-changed':U to brTable in frame {&FRAME-NAME}.

end procedure. /* qg_RefreshTableBrowse */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveAllSessionTriggers hQueryWindow 
PROCEDURE qg_RemoveAllSessionTriggers :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove all session triggers.                                               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttSessionTrigger
  on error undo, throw:
  
  if valid-handle(bttSessionTrigger.ProcedureHandle) then
    delete object bttSessionTrigger.ProcedureHandle.
  
  os-delete value(bttSessionTrigger.TriggerFileName).
  
  delete bttSessionTrigger.
  
end. /* for each bttSessionTrigger */

if valid-handle(ghSessionTriggersWindow) then
  run qg_SessionTriggersOpenQuery.

end procedure. /* qg_RemoveAllSessionTriggers */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveDatabase hQueryWindow 
PROCEDURE qg_RemoveDatabase :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove given database from cache.                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = logical name of database that should be   */
/*                                  removed.                                  */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase  for temp-table ttDatabase.
define buffer b2ttDatabase for temp-table ttDatabase.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find first bttDatabase
  where bttDatabase.DatabaseName = pcDatabase
  no-error.

if available bttDatabase then
do:
  
  if bttDatabase.BasisDB then
  do:
    
    for each b2ttDatabase
      where b2ttDatabase.BasisDBName = bttDatabase.DatabaseName
      on error undo, throw:
      
      b2ttDatabase.BasisDBName = '':U.
      
    end. /* for each b2ttDatabase */
    
  end. /* if bttDatabase.BasisDB */
  
  run qg_RemoveTables(bttDatabase.DatabaseName).
  
  delete bttDatabase.
  
end. /* if available bttDatabase */

end procedure. /* qg_RemoveDatabase */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveIndices hQueryWindow 
PROCEDURE qg_RemoveIndices :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove all indices of given table from cache.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = Database that contains the Table of the   */
/*                                  indices that should be removed.           */
/* pcTable                        = Table that contains the indices that      */
/*                                  should be removed.                        */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.
define input parameter pcTable    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttIndex      for temp-table ttIndex.
define buffer bttIndexField for temp-table ttIndexField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttIndex
  where bttIndex.DatabaseName = pcDatabase
    and bttIndex.TableName    = pcTable
  on error undo, throw:

  for each bttIndexField
    where bttIndexField.DatabaseName = bttIndex.DatabaseName
      and bttIndexField.TableName    = bttIndex.TableName
      and bttIndexField.IndexName    = bttIndex.IndexName
    on error undo, throw:
  
    delete bttIndexField.
    
  end. /* for each bttIndexField */
  
  delete bttIndex.
  
end. /* for each bttIndex */

end procedure. /* qg_RemoveIndices */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveSessionTrigger hQueryWindow 
PROCEDURE qg_RemoveSessionTrigger :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove given session trigger.                                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcTriggerEvent                 = Trigger event of the session trigger that */
/*                                  should be removed.                        */
/* pcDatabaseName                 = Database name of the session trigger that */
/*                                  should be removed.                        */
/* pcTableName                    = Table name of the session trigger that    */
/*                                  should be removed.                        */
/* pcFieldName                    = Field name of the session trigger that    */
/*                                  should be removed.                        */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcTriggerEvent as character no-undo.
define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.
define input parameter pcFieldName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable rCurrentRecord as rowid     no-undo.

define variable hBrowseBuffer  as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggersWindow) then
  assign
    hBrowseBuffer  = ghSessionTriggersBrowse:query:get-buffer-handle(1)
    rCurrentRecord = hBrowseBuffer:rowid
    .

for each bttSessionTrigger
  where bttSessionTrigger.TriggerEvent = pcTriggerEvent
    and bttSessionTrigger.DatabaseName = pcDatabaseName
    and bttSessionTrigger.TableName    = pcTableName
    and bttSessionTrigger.FieldName    = pcFieldName
  on error undo, throw:
  
  if    valid-handle(ghSessionTriggersWindow)
    and rowid(bttSessionTrigger) = rCurrentRecord then
  do:
    
    ghSessionTriggersBrowse:query:get-next().
    
    if not hBrowseBuffer:available then
    do:
      
      ghSessionTriggersBrowse:query:reposition-to-rowid(rCurrentRecord).
      ghSessionTriggersBrowse:query:get-prev().
      
    end. /* if not hBrowseBuffer:available */
    
    if hBrowseBuffer:available then
      rCurrentRecord = hBrowseBuffer:rowid.
    
  end. /* if    valid-handle(ghSessionTriggersWindow) */
  
  if valid-handle(bttSessionTrigger.ProcedureHandle) then
    delete object bttSessionTrigger.ProcedureHandle.
  
  os-delete value(bttSessionTrigger.TriggerFileName).
  
  delete bttSessionTrigger.
  
end. /* for each bttSessionTrigger */

if valid-handle(ghSessionTriggersWindow) then
do:
  
  run qg_SessionTriggersOpenQuery.
  
  if rCurrentRecord <> ? then
    ghSessionTriggersBrowse:query:reposition-to-rowid(rCurrentRecord) no-error.
  
end. /* if valid-handle(ghSessionTriggersWindow) */

end procedure. /* qg_RemoveSessionTrigger */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveTable hQueryWindow 
PROCEDURE qg_RemoveTable :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove given Table from Cache.                                             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabaseName                 = Database name of Table.                   */
/* pcTableName                    = Table name                                */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable for temp-table ttTable.
define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find first bttTable
  where bttTable.DatabaseName = pcDatabaseName
    and bttTable.TableName    = pcTableName
  no-error.

if not available(bttTable) then
  leave.

/* Remove indices. */

run qg_RemoveIndices(bttTable.DatabaseName,
                     bttTable.TableName).

/* Remove fields. */

for each bttField
  where bttField.DatabaseName = bttTable.DatabaseName
    and bttField.TableName    = bttTable.TableName
  on error undo, throw:
  
  delete bttField.
  
end. /* for each bttField */

/* Delete the dynamically created temp-table. */

if    bttTable.Snapshot
  and valid-handle(bttTable.TableHandle) then 
  delete object bttTable.TableHandle.

/* And finally delete the table entry. */

delete bttTable.

end procedure. /* qg_RemoveTable */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_RemoveTables hQueryWindow 
PROCEDURE qg_RemoveTables :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove all tables of the given database from cache.                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabase                     = Database that contains the tables that    */
/*                                  should be removed.                        */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcDatabase as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

for each bttTable
  where bttTable.DatabaseName = pcDatabase
  on error undo, throw:
  
  run qg_RemoveTable(bttTable.DatabaseName,
                     bttTable.TableName).
  
end. /* for each bttTable */

end procedure. /* qg_RemoveTables */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SaveIDESetting hQueryWindow 
PROCEDURE qg_SaveIDESetting :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Save given setting for currently active project.                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcSettingName                  = Setting that should be saved.             */
/* pcSettingValue                 = Value that should be saved.               */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcSettingName  as character no-undo.
define input parameter pcSettingValue as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cParamString as character no-undo.
define variable cDummy       as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    OEIDEIsRunning
  and glIDECanSaveSetting then
do:

  assign
    cParamString = qg_cParamListWriteCharacter(cParamString,
                                               'ProjectName':U,
                                               /*  */
                                               (if gcIDEProjectName <> ? then
                                                  gcIDEProjectName
                                                else
                                                  '':U),
                                               {&K_PARAM_SPLITTER})
    cParamString = qg_cParamListWriteCharacter(cParamString,
                                               'ParameterName':U,
                                               pcSettingName,
                                               {&K_PARAM_SPLITTER})
    cParamString = qg_cParamListWriteCharacter(cParamString,
                                               'ParameterValue':U,
                                               pcSettingValue,
                                               {&K_PARAM_SPLITTER})
    .
  
  run qg_IDE_SendRequest({&K_SAVE_PLUGIN_SETTING_HANDLER},
                         cParamString,
                         output cDummy).
  
end. /* if    OEIDEIsRunning ... */

end procedure. /* qg_SaveIDESetting */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SaveQueryScenario hQueryWindow 
PROCEDURE qg_SaveQueryScenario :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Save all currently running quey windows.                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcFileName                     = Filename to save the scenario. If ? the   */
/*                                  scenario will be copied to clipboard.     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcFileName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName as character no-undo.

define variable i             as integer   no-undo.

define variable hBuffer       as handle    no-undo.
define variable clText        as longchar  no-undo.

define variable cBufferList   as character no-undo.

define variable hSplitter1    as handle    no-undo.

define query brQueryWindowBrowse
  for ttQueryWindowExport
  scrolling.

define browse brQueryWindowBrowse
  query brQueryWindowBrowse no-lock
    display
      ttQueryWindowExport.WindowSelected view-as toggle-box
      ttQueryWindowExport.QuerySeq
      ttQueryWindowExport.BufferList
      with no-assign size 100 by 12.

define variable lExportWindowState as logical no-undo
  init yes
  label 'Save window state':T
  view-as toggle-box
  size 50 by 1.

define variable lExportQueryHistory as logical no-undo
  init no
  label 'Save query history':T
  view-as toggle-box
  size 50 by 1.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define menu m_PopupMenu
  menu-item mi_Select
    label "Select"
  rule
  menu-item mi_SelectAll
    label "Select all"
  menu-item mi_DeselectAll
    label 'Deselect all':T
    .

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow       for temp-table ttQueryWindow.
define buffer bttRecentQueries     for temp-table ttRecentQueries.

define buffer bttQueryWindowExport for temp-table ttQueryWindowExport.
define buffer bttQueryBufferExport for temp-table ttQueryBufferExport.
define buffer bttRecentQueryExport for temp-table ttRecentQueryExport.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fSelectQueryWindows
  brQueryWindowBrowse at row 1.5 col 3
  lExportWindowState at row 14 col 3
  lExportQueryHistory at row 14 col 30
  btnOk at row 16 col 33
  btnCancel at row 16 col 53
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 105 by 17.94
    title gcTitlePrefix + 'Save query scenario':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectQueryWindows
  apply 'end-error' to self.

on 'menu-drop':U of menu m_PopupMenu
do:
  
  if available ttQueryWindowExport then
    menu-item mi_Select:label in menu m_PopupMenu
      = (if ttQueryWindowExport.WindowSelected then
           'Deselect':T
         else
           'Select':T).
  
end. /* on 'menu-drop':U of menu m_PopupMenu */

on choose of menu-item mi_Select in menu m_PopupMenu
do:

  if available ttQueryWindowExport then
  do:
    
    ttQueryWindowExport.WindowSelected = not ttQueryWindowExport.WindowSelected.
    
    if query brQueryWindowBrowse:num-results > 0 then
      browse brQueryWindowBrowse:refresh().
    
  end. /* if available ttQueryWindowExport */
  
  btnOk:sensitive in frame fSelectQueryWindows /* code checked by mth */
      = can-find(first ttQueryWindowExport
                   where ttQueryWindowExport.WindowSelected = yes).
  
end. /* on choose of menu-item mi_Select in menu m_PopupMenu */

on default-action of brQueryWindowBrowse in frame fSelectQueryWindows
  apply 'choose':U to menu-item mi_Select in menu m_PopupMenu.

on choose of menu-item mi_SelectAll in menu m_PopupMenu
do:
  
  define buffer bttQueryWindowExport for temp-table ttQueryWindowExport.
  
  for each bttQueryWindowExport
    where bttQueryWindowExport.WindowSelected = no
    on error undo, throw:
    
    bttQueryWindowExport.WindowSelected = yes.
    
  end. /* for each bttQueryWindowExport */ 
  
  if query brQueryWindowBrowse:num-results > 0 then
    browse brQueryWindowBrowse:refresh().
  
  btnOk:sensitive in frame fSelectQueryWindows /* code checked by mth */
      = can-find(first ttQueryWindowExport
                   where ttQueryWindowExport.WindowSelected = yes).
  
end. /* on choose of menu-item mi_SelectAll in menu m_PopupMenu */

on choose of menu-item mi_DeselectAll in menu m_PopupMenu
do:
  
  define buffer bttQueryWindowExport for temp-table ttQueryWindowExport.
  
  for each bttQueryWindowExport
    where bttQueryWindowExport.WindowSelected = yes
    on error undo, throw:
    
    bttQueryWindowExport.WindowSelected = no.
    
  end. /* for each bttQueryWindowExport */ 
  
  if query brQueryWindowBrowse:num-results > 0 then
    browse brQueryWindowBrowse:refresh().
  
  btnOk:sensitive in frame fSelectQueryWindows /* code checked by mth */
      = can-find(first ttQueryWindowExport
                   where ttQueryWindowExport.WindowSelected = yes).
  
end. /* on choose of menu-item mi_DeselectAll in menu m_PopupMenu */

dataset dsQueryWindowExport:empty-dataset().

for each bttQueryWindow
  on error undo, throw:
  
  if not valid-handle(bttQueryWindow.WindowHandle) then
    next.
  
  create bttQueryWindowExport.
  
  assign
    bttQueryWindowExport.QuerySeq       = bttQueryWindow.QuerySeq
    bttQueryWindowExport.QueryText      = bttQueryWindow.QueryTextEditorHandle:private-data
    bttQueryWindowExport.BrowseColumns  = qg_cBrowseColumnList(bttQueryWindow.QueryBrowseHandle,
                                                               yes,
                                                               no,
                                                               yes)
    bttQueryWindowExport.WindowWidth    = bttQueryWindow.WindowHandle:width-chars
    bttQueryWindowExport.WindowHeight   = bttQueryWindow.WindowHandle:height-chars
    bttQueryWindowExport.WindowColumn   = bttQueryWindow.WindowHandle:column
    bttQueryWindowExport.WindowRow      = bttQueryWindow.WindowHandle:row
    bttQueryWindowExport.WindowState    = (if bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MAXIMIZED} then
                                             {&K_WINDOW_MAXIMIZED_STR}
                                           else if bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
                                             {&K_WINDOW_MINIMIZED_STR}
                                           else
                                             {&K_WINDOW_NORMAL_STR})
    bttQueryWindowExport.HideFieldList  = bttQueryWindow.FieldSelectionBrowseHandle:hidden
    hSplitter1                          = qg_hGetWidgetByName(bttQueryWindow.WindowHandle, 'btnSplitter1':U)
    bttQueryWindowExport.Splitter1Pos   = hSplitter1:row
    cBufferList                         = '':U
    .
  
  do i = 1 to bttQueryWindow.QueryHandle:num-buffers:
      
    hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i).
      
    if not valid-handle(hBuffer:table-handle) then
      cDatabaseName = hBuffer:dbname.
    
    else
    do:
      
      cDatabaseName = qg_cParamListReadValue(hBuffer:table-handle:private-data,
                                             'DatabaseName':U,
                                             ',':U).
      
      if cDatabaseName = '':U then
        cDatabaseName = hBuffer:dbname.
      
    end. /* if not valid-handle(phBuffer:table-handle) */

    create bttQueryBufferExport.
    
    assign
      bttQueryBufferExport.QuerySeq       = bttQueryWindowExport.QuerySeq
      bttQueryBufferExport.BufferId       = i
      bttQueryBufferExport.DatabaseName   = cDatabaseName
      bttQueryBufferExport.TableName      = hBuffer:table
      bttQueryBufferExport.BufferName     = hBuffer:name
      cBufferList                         = substitute('&1,&2':U,
                                                       cBufferList,
                                                       hBuffer:name)
      .
    
    validate bttQueryBufferExport.
    
  end. /* do i = 1 to bttQueryWindow:QueryHandle:num-buffers */
  
  bttQueryWindowExport.BufferList = trim(cBufferList, ',':U).
  
  validate bttQueryWindowExport.
  
end. /* for each bttQueryWindow */

brQueryWindowBrowse:popup-menu in frame fSelectQueryWindows = menu m_PopupMenu:handle.
run qg_InitBrowse(browse brQueryWindowBrowse:handle).

if pcFilename = ? then
  assign
    frame fSelectQueryWindows:title
        = gcTitlePrefix + 'Copy query scenario':T
    lExportWindowState:label in frame fSelectQueryWindows
        = 'Copy window state':T
    lExportQueryHistory:label in frame fSelectQueryWindows
        = 'Copy query history':T
    .

display unless-hidden
  brQueryWindowBrowse
  with frame fSelectQueryWindows
    in window hQueryWindow. 

open query brQueryWindowBrowse
  for each ttQueryWindowExport
    no-lock.

update unless-hidden
  brQueryWindowBrowse
  lExportWindowState
  lExportQueryHistory
  btnOk
  btnCancel
  with frame fSelectQueryWindows
    in window hQueryWindow. 

for each bttQueryWindowExport,
first bttQueryWindow
  where bttQueryWindow.QuerySeq = bttQueryWindowExport.QuerySeq
  on error undo, throw:
  
  if bttQueryWindowExport.WindowSelected = no then
  do:
    
    /* Delete all Window records that have not been selected. */
    
    for each bttQueryBufferExport
      where bttQueryBufferExport.QuerySeq = bttQueryWindowExport.QuerySeq
      on error undo, throw:
      
      delete bttQueryBufferExport.
      
    end. /* for each bttQueryBufferExport */
    
    delete bttQueryWindowExport.
    
  end. /* if bttQueryWindowExport.WindowSelected = no */
  
  else if input frame fSelectQueryWindows lExportQueryHistory then
  do:
    
    /* Add Recent query entries if according option has been selected. */
    
    for each bttRecentQueries
      where bttRecentQueries.WindowHandle = bttQueryWindow.WindowHandle
      on error undo, throw:
      
      create bttRecentQueryExport.
      
      assign
        bttRecentQueryExport.QuerySeq  = bttQueryWindow.QuerySeq
        bttRecentQueryExport.Order     = bttRecentQueries.Order
        bttRecentQueryExport.QueryText = bttRecentQueries.QueryText
        .
      
    end. /* for each bttRecentQueries */
    
  end. /* if bttQueryWindowExport.WindowSelected = no */
  
end. /* for each bttQueryWindowExport */

if can-find(first ttQueryWindowExport) then
do:
  
  assign
    buffer ttQueryWindowExport:buffer-field('WindowState':U):serialize-hidden   = not lExportWindowState
    buffer ttQueryWindowExport:buffer-field('BrowseColumns':U):serialize-hidden = not lExportWindowState
    buffer ttQueryWindowExport:buffer-field('WindowWidth':U):serialize-hidden   = not lExportWindowState
    buffer ttQueryWindowExport:buffer-field('WindowHeight':U):serialize-hidden  = not lExportWindowState
    buffer ttQueryWindowExport:buffer-field('WindowColumn':U):serialize-hidden  = not lExportWindowState
    buffer ttQueryWindowExport:buffer-field('WindowRow':U):serialize-hidden     = not lExportWindowState
    buffer ttQueryWindowExport:buffer-field('HideFieldList':U):serialize-hidden = not lExportWindowState
    buffer ttQueryWindowExport:buffer-field('Splitter1Pos':U):serialize-hidden  = not lExportWindowState
    .
  
  if pcFileName <> ? then
    dataset dsQueryWindowExport:write-xml('File':U,
                                          pcFileName,
                                          yes).
  
  else
  do:
    
    dataset dsQueryWindowExport:write-xml('longchar':U,
                                          clText,
                                          yes).
    
    clipboard:value = clText.
    
  end. /* else: if plFile */
  
end. /* if can-find(first ttQueryWindowExport) */
  
end procedure. /* qg_SaveQueryScenario */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SelectBrowseColumns hQueryWindow 
PROCEDURE qg_SelectBrowseColumns :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Select Order and visibility of columns in the given browse.                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowse                       = Browse for which columns should be        */
/*                                  selected.                                 */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowse as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cAvailableColumns as character no-undo.
define variable cSelectedColumns  as character no-undo.

define variable lBuffernames      as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

lBuffernames = (phBrowse:query:num-buffers > 1).

assign
  cSelectedColumns  = qg_cBrowseColumnList(phBrowse,
                                           lBuffernames,
                                           no,
                                           no)
  cAvailableColumns = qg_cBrowseColumnList(phBrowse,
                                           lBuffernames,
                                           yes,
                                           no)
  .

run qg_SelectionDialog(cAvailableColumns,
                       input-output cSelectedColumns,
                       'Select columns':T,
                       phBrowse:window,
                       yes).

run qg_SetBrowseColumns(phBrowse,
                        cSelectedColumns).

end procedure. /* qg_SelectBrowseColumns */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SelectFieldList hQueryWindow 
PROCEDURE qg_SelectFieldList :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Filters and selects a list of fields in the field browser.                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcFieldList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i           as integer   no-undo.

define variable cFieldEntry as character no-undo.
define variable rRowidEntry as rowid     no-undo.
define variable cRowidList  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

gcFieldFilter = '':U.

do i = 1 to num-entries(pcFieldList):
  
  cFieldEntry = entry(i, pcFieldList).
  
  find first bttField
    where bttField.DatabaseName = ttDatabase.DatabaseName
      and bttField.TableName    = ttTable.TableName
      and bttField.FieldName    = cFieldEntry
    no-error.
  
  if available bttField then
    assign
      cRowidList    = substitute('&1,&2':U,
                                 cRowidList,
                                 string(rowid(bttField)))
      gcFieldFilter = substitute('&1,"&2"':U,
                                 gcFieldFilter,
                                 cFieldEntry)
      .
  
end. /* do i = 1 to num-entries(pcFieldList) */

gcFieldFilter = trim(gcFieldFilter, ',':U).

display unless-hidden
  gcFieldFilter
  with frame {&FRAME-NAME}.

run qg_RefreshFieldBrowse.

do i = 1 to num-entries(cRowidList):
  
  rRowidEntry = to-rowid(entry(i, cRowidList)).
  
  reposition brField to rowid rRowidEntry no-error.
  
  if rowid(ttField) = rRowidEntry then
    browse brField:select-focused-row().
  
end. /* do i = 1 to num-entries(cRowidList) */

end procedure. /* qg_SelectFieldList */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SelectIndex hQueryWindow 
PROCEDURE qg_SelectIndex :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Shows a selection dialog with all indices of given table.                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcDatabaseName                 = Database name of the table.               */
/* pcTableName                    = Table name.                               */
/* iopcIndexName                  = Index name the user selected. If an index */
/*                                  name is passed to this procedure then     */
/*                                  given index will be preselected.          */
/* oplOk                          = Flag to indicate if the user approved     */
/*                                  the dialog.                               */
/* phParentWindow                 = Handle of the parent window for the       */
/*                                  dialog.                                   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter pcDatabaseName as character no-undo.
define input        parameter pcTableName    as character no-undo.
define input-output parameter iopcIndexName  as character no-undo.
define       output parameter oplOk          as logical   no-undo.
define input        parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttTable  for temp-table ttTable.
define buffer bttIndex  for temp-table ttIndex.
define buffer b2ttIndex for temp-table ttIndex.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

/* Define widgets. */

define query brSelectIndex
  for bttIndex
  scrolling.

define browse brSelectIndex
  query brSelectIndex no-lock
    display
      bttIndex.IsPrimary
      bttIndex.IndexName
      bttIndex.IsUnique
      bttIndex.IndexFields
      with no-assign size 146 by 21 no-empty-space.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

/* Define frame. */

define frame fSelectIndex
  brSelectIndex at row 1.5 col 3
  btnOk at row 23.5 col 56
  btnCancel at row 23.5 col 76
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select Index':U
    side-labels no-underline three-d 
    size 151 by 25.44
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectIndex
  apply 'end-error' to self.

on default-action of browse brSelectIndex
  apply 'go':U to frame fSelectIndex.

run qg_InitBrowse(browse brSelectIndex:handle).

find bttTable
  where bttTable.DatabaseName = pcDatabaseName
    and bttTable.TableName    = pcTableName
  no-error.

if not available bttTable then
  leave.

open query brSelectIndex
  for each bttIndex
    where bttIndex.DatabaseName = pcDatabaseName
      and bttIndex.TableName    = pcTableName.

if iopcIndexName > '':U then
  find first b2ttIndex
    where b2ttIndex.DatabaseName = pcDatabaseName
      and b2ttIndex.TableName    = pcTableName
      and b2ttIndex.IndexName    = iopcIndexName
    no-error.

else
  find first b2ttIndex
    where b2ttIndex.DatabaseName = pcDatabaseName
      and b2ttIndex.TableName    = pcTableName
      and b2ttIndex.IsPrimary    = yes
    no-error.

if available b2ttIndex then
  reposition brSelectIndex to rowid rowid(b2ttIndex).

update unless-hidden
  brSelectIndex
  btnOk
  btnCancel
  with frame fSelectIndex
    in window phParentWindow. 

if available bttIndex then
  assign
    iopcIndexName = bttIndex.IndexName
    oplOk         = yes
    .

end procedure. /* qg_SelectIndex */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SelectionDialog hQueryWindow 
PROCEDURE qg_SelectionDialog :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show a selection dialog.                                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcAvailableItems               = All items that are available (including   */
/*                                  selected ones)                            */
/* pcSelectedItems                = Items that are selected.                  */
/* pcTitle                        = Title for the dialog box.                 */
/* phParentWindow                 = Parent window for the dialog.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input        parameter pcAvailableItems   as character no-undo.
define input-output parameter pcSelectedItems    as character no-undo.
define input        parameter pcTitle            as character no-undo.
define input        parameter phParentWindow     as handle    no-undo.
define input        parameter plShowOrderButtons as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i as integer   no-undo.

define variable cAvailableColumns as character no-undo
  view-as selection-list
    multiple sort scrollbar-horizontal scrollbar-vertical
  size 50 by 16.

define variable cSelectedColumns as character no-undo
  view-as selection-list
    multiple scrollbar-horizontal scrollbar-vertical
  size 50 by 16.

define button btnAdd
  label '>':U
  size 10 by 1.5.

define button btnAddAll
  label '>>':U
  size 10 by 1.5.

define button btnRemove
  label '<':U
  size 10 by 1.5.

define button btnRemoveAll
  label '<<':U
  size 10 by 1.5.

define button btnTop
  label 'Top':U
  size 10 by 1.5.

define button btnUp
  label 'Up':U
  size 10 by 1.5.

define button btnDown
  label 'Down':U
  size 10 by 1.5.

define button btnBottom
  label 'Bottom':U
  size 10 by 1.5.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T6
  size 20 by 1.14
  auto-end-key.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define frame fColumns
  cAvailableColumns at row 1.5 col 3 no-labels
  btnAdd at row 1.5 col 55
  btnAddAll at row 3 col 55
  btnRemove at row 5 col 55
  btnRemoveAll at row 6.5 col 55
  btnTop at row 10.5 col 55
  btnUp at row 12.5 col 55
  btnDown at row 14 col 55
  btnBottom at row 16 col 55
  btnOk at row 18.5 col 40
  btnCancel at row 18.5 col 60
  cSelectedColumns at row 1.5 col 67 no-labels
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 119 by 20.44
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fColumns
  apply 'end-error' to self.

on choose of btnAdd in frame fColumns
do:
  
  define variable i         as integer   no-undo.
  define variable cItemList as character no-undo.
  define variable cItem     as character no-undo.
  
  cItemList = cAvailableColumns:screen-value in frame fColumns.
  
  do i = 1 to num-entries(cItemList):
    cItem = entry(i, cItemList).
    cAvailableColumns:delete(cItem).
    cSelectedColumns:add-last(cItem).
  end. /* do i = 1 to num-entries(cItemList) */
  
  cSelectedColumns:screen-value in frame fColumns = cItemList.
  
end. /* on choose of button btnAdd */

on choose of btnAddAll in frame fColumns
do:
  
  define variable i         as integer   no-undo.
  define variable cItem     as character no-undo.
  
  do i = 1 to cAvailableColumns:num-items in frame fColumns:
    cItem = cAvailableColumns:entry(i) in frame fColumns.
    cAvailableColumns:delete(cItem).
    cSelectedColumns:add-last(cItem).
    i = i - 1.
  end. /* do i = 1 to num-entries(cItemList) */
  
end. /* on choose of button btnAdd */

on choose of btnRemove in frame fColumns
do:
  
  define variable i         as integer   no-undo.
  define variable cItemList as character no-undo.
  define variable cItem     as character no-undo.
  
  cItemList = cSelectedColumns:screen-value  in frame fColumns.
  
  do i = 1 to num-entries(cItemList):
    
    cItem = entry(i, cItemList).
    
    if cSelectedColumns:is-selected(cItem) in frame fColumns then
    do:
      cSelectedColumns:delete(cItem).
      cAvailableColumns:add-last(cItem).
    end. /* if cSelectedColumn:is-selected(i) in frame fColumns */
    
  end. /* do i = cSelectedColumn:num-items to 1 by -1 in frame fColumns */
  
  cAvailableColumns:screen-value in frame fColumns = cItemList.
  
end. /* on choose of button btnRemove */

on choose of btnRemoveAll in frame fColumns
do:
  
  define variable i     as integer   no-undo.
  define variable cItem as character no-undo.
  
  do i = cSelectedColumns:num-items in frame fColumns to 1 by -1:
    cItem = cSelectedColumns:entry(i) in frame fColumns.
    cSelectedColumns:delete(cItem).
    cAvailableColumns:add-last(cItem).
  end. /* do i = cSelectedColumn:num-items to 1 by -1 in frame fColumns */
  
end. /* on choose of button btnRemove */

on 'mouse-select-dblclick':U of cAvailableColumns in frame fColumns
  apply 'choose':U to btnAdd in frame fColumns.

on 'mouse-select-dblclick':U of cSelectedColumns in frame fColumns
  apply 'choose':U to btnRemove in frame fColumns.

on choose of btnTop in frame fColumns
do:
  
  define variable i         as integer   no-undo.
  define variable cItemList as character no-undo.
  define variable cItem     as character no-undo.
  
  cItemList = cSelectedColumns:screen-value in frame fColumns.
  
  do i = num-entries(cItemList) to 1 by -1:
    cItem = entry(i, cItemList).
    cSelectedColumns:delete(cItem) in frame fColumns.
    cSelectedColumns:add-first(cItem) in frame fColumns.
  end. /* do i = 1 to num-entries(cItemList) */
  
  cSelectedColumns:screen-value in frame fColumns = cItemList.
  
end. /* on choose of button btnRemove */

on choose of btnUp in frame fColumns
do:
  
  define variable i         as integer   no-undo.
  define variable cItemList as character no-undo.
  define variable iIndex    as integer   no-undo.
  define variable cItem     as character no-undo.
  
  cItemList = cSelectedColumns:screen-value in frame fColumns.
  
  do i = 1 to num-entries(cItemList):
    
    cItem = entry(i, cItemList).
    iIndex = cSelectedColumns:lookup(cItem) in frame fColumns.
    
    if iIndex > i then
    do:
      cSelectedColumns:delete(iIndex) in frame fColumns.
      cSelectedColumns:insert(cItem, iIndex - 1) in frame fColumns.
    end. /* if iIndex > 1 */
    
  end. /* do i = 1 to num-entries(cItemList) */
  
  cSelectedColumns:screen-value in frame fColumns = cItemList.
  
end. /* on choose of button btnRemove */

on choose of btnDown in frame fColumns
do:
  
  define variable i         as integer   no-undo.
  define variable cItemList as character no-undo.
  define variable iIndex    as integer   no-undo.
  define variable iMaxIndex as integer   no-undo.
  define variable cItem     as character no-undo.
  
  assign
    cItemList = cSelectedColumns:screen-value in frame fColumns
    iMaxIndex = cSelectedColumns:num-items in frame fColumns
    .
  
  do i = num-entries(cItemList) to 1 by -1:
    
    assign
      cItem  = entry(i, cItemList)
      iIndex = cSelectedColumns:lookup(cItem) in frame fColumns
      .
    
    if iIndex < iMaxIndex - num-entries(cItemList) + i then
    do:
      cSelectedColumns:delete(iIndex) in frame fColumns.
      cSelectedColumns:insert(cItem, iIndex + 1) in frame fColumns.
    end. /* iIndex <= cSelectedColumns:num-items in frame fColumns - i */
    
  end. /* do i = num-entries(cItemList) to 1 by -1 */
  
  cSelectedColumns:screen-value in frame fColumns = cItemList.
  
end. /* on choose of button btnRemove */

on choose of btnBottom in frame fColumns
do:
  
  define variable i         as integer   no-undo.
  define variable cItemList as character no-undo.
  define variable cItem as character no-undo.
  
  cItemList = cSelectedColumns:screen-value in frame fColumns
    .
  
  do i = 1 to num-entries(cItemList):
    cItem = entry(i, cItemList).
    cSelectedColumns:delete(cItem) in frame fColumns.
    cSelectedColumns:add-last(cItem) in frame fColumns.
  end. /* do i = 1 to num-entries(cItemList) */
  
  cSelectedColumns:screen-value in frame fColumns = cItemList.
  
end. /* on choose of button btnRemove */

frame fColumns:title = gcTitlePrefix + pcTitle.

if not plShowOrderButtons then
  assign
    btnTop:hidden                           = yes
    btnUp:hidden                            = yes
    btnDown:hidden                          = yes
    btnBottom:hidden                        = yes
    cSelectedColumns:sort in frame fColumns = yes
    .

display unless-hidden
  cAvailableColumns
  cSelectedColumns
  with frame fColumns
    in window phParentWindow.

do i = 1 to num-entries(pcAvailableItems):
  if lookup(entry(i, pcAvailableItems), pcSelectedItems) = 0 then
    cAvailableColumns:add-last(entry(i, pcAvailableItems)) in frame fColumns.
end. /* do i = 1 to num-entries(pcSelectedItems) */

do i = 1 to num-entries(pcSelectedItems):
  cSelectedColumns:add-last(entry(i, pcSelectedItems)) in frame fColumns.
end. /* do i = 1 to num-entries(pcSelectedItems) */

update unless-hidden
  cAvailableColumns
  btnAdd
  btnAddAll
  btnRemove
  btnRemoveAll
  cSelectedColumns
  btnTop
  btnUp
  btnDown
  btnBottom
  btnOk
  btnCancel
  with frame fColumns
    in window phParentWindow.

pcSelectedItems = '':U.

do i = 1 to cSelectedColumns:num-items in frame fColumns:
  pcSelectedItems = substitute('&1,&2':U,
                                 pcSelectedItems,
                                 cSelectedColumns:entry(i) in frame fColumns).
end. /* do i = 1 to cSelectedColumns:num-items in frame fColumns */

pcSelectedItems = trim(pcSelectedItems, ',':U).

end procedure. /* qg_SelectionDialog */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SelectionDialog hQueryWindow 
PROCEDURE qg_SelectTable :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Select given Table.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcTableName as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabaseName           as character no-undo.
define variable cTableName              as character no-undo.

define variable iTableNameLength        as integer   no-undo.
define variable iLongestTableNameLength as integer   no-undo.

define variable i                       as integer   no-undo.
define variable cSuffix                 as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for temp-table ttDatabase.
define buffer bttTable    for temp-table ttTable.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

pcTableName = trim(pcTableName).

/* First priority: exact table match in active database. */

if available ttDatabase then
do:
  
  find bttTable
    where bttTable.DatabaseName = ttDatabase.DatabaseName
      and bttTable.TableName    = pcTableName
    no-error.
  
  if    not available bttTable
    and ttDatabase.TempDB
    and pcTableName begins 'tt':U then
    find bttTable
      where bttTable.DatabaseName = ttDatabase.DatabaseName
        and bttTable.TableName    = substitute('td&1':U, substring(pcTableName, 3))
      no-error.
  
  if available bttTable then
    assign
      cDatabaseName = bttTable.DatabaseName
      cTableName    = bttTable.TableName
      .
  
end. /* if available ttDatabase */

/* Second priority: exact table match in any database. */

if cTableName = '':U then
do:
  
  for each bttDatabase
    on error undo, throw:
    
    find bttTable
      where bttTable.DatabaseName = bttDatabase.DatabaseName
        and bttTable.TableName    = pcTableName
      no-error.
    
    if    not available bttTable
      and bttDatabase.TempDB
      and pcTableName begins 'tt':U then
      find bttTable
        where bttTable.DatabaseName = bttDatabase.DatabaseName
          and bttTable.TableName    = substitute('td&1':U, substring(pcTableName, 3))
        no-error.
    
    if available bttTable then
      assign
        cDatabaseName = bttTable.DatabaseName
        cTableName    = bttTable.TableName
        .
        
  end. /* for each bttDatabase */
  
end. /* if cTableName = '':U */

/* Third priority: shortest wildcard table match in active database. */

if    cTableName = '':U
  and available ttDatabase then
do:
  
  for each bttTable
    where bttTable.DatabaseName = ttDatabase.DatabaseName
      and pcTableName     matches substitute('*&1*':U, bttTable.TableName)
    on error undo, throw:
    
    iTableNameLength = length(bttTable.TableName).
    
    if   iLongestTableNameLength = 0
      or iTableNameLength > iLongestTableNameLength then
      assign
        iLongestTableNameLength = iTableNameLength
        cDatabaseName           = bttTable.DatabaseName
        cTableName              = bttTable.TableName
        .

  end. /* for each bttTable */
  
  if    ttDatabase.TempDB
    and pcTableName begins 'tt':U then
  do:
    
    for each bttTable
      where bttTable.DatabaseName = ttDatabase.DatabaseName
        and pcTableName     matches substitute('*td&1*':U, substring(pcTableName, 3))
      on error undo, throw:
      
      iTableNameLength = length(bttTable.TableName).
      
      if   iLongestTableNameLength = 0
        or iTableNameLength > iLongestTableNameLength then
        assign
          iLongestTableNameLength = iTableNameLength
          cDatabaseName           = bttTable.DatabaseName
          cTableName              = bttTable.TableName
          .
  
    end. /* for each bttTable */
    
  end. /* if ttDatabase.TempDB */
  
end. /* if    cTableName = '':U */

/* Fourth priority: shortest wildcard table match in any database. */

if cTableName = '':U then
do:
  
  for each bttDatabase
    on error undo, throw:
    
    for each bttTable
      where bttTable.DatabaseName = bttDatabase.DatabaseName
        and pcTableName     matches substitute('*&1*':U, bttTable.TableName)
      on error undo, throw:
      
      iTableNameLength = length(bttTable.TableName).
      
      if   iLongestTableNameLength = 0
        or iTableNameLength > iLongestTableNameLength then
        assign
          iLongestTableNameLength = iTableNameLength
          cDatabaseName           = bttTable.DatabaseName
          cTableName              = bttTable.TableName
          .
  
    end. /* for each bttTable */
    
    if    ttDatabase.TempDB
      and pcTableName begins 'tt':U then
    do:
      
      for each bttTable
        where bttTable.DatabaseName = bttDatabase.DatabaseName
          and pcTableName     matches substitute('*td&1*':U, substring(pcTableName, 3))
        on error undo, throw:
        
        iTableNameLength = length(bttTable.TableName).
        
        if   iLongestTableNameLength = 0
          or iTableNameLength > iLongestTableNameLength then
          assign
            iLongestTableNameLength = iTableNameLength
            cDatabaseName           = bttTable.DatabaseName
            cTableName              = bttTable.TableName
            .
    
      end. /* for each bttTable */
      
    end. /* if    ttDatabase.TempDB */
    
  end. /*for each bttDatabase  */
  
end. /* if cTableName = '':U */

/* Select table (if necessary). */

if    cDatabaseName > '':U
  and cTableName    > '':U then
do:
  
  if   not available ttDatabase
    or ttDatabase.DatabaseName <> cDatabaseName then
  do:
    
    find bttDatabase
      where bttDatabase.DatabaseName = cDatabaseName
      no-error.
    
    if not available bttDatabase then
    leave.
      
    reposition brDatabase to rowid rowid(bttDatabase).
    apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.
    
  end. /* if   not available ttDatabase ... */
  
  if input frame {&FRAME-NAME} gcTableFilter <> cTableName then
  do:
    
    gcTableFilter = cTableName.
    
    do i = 1 to num-entries({&K_AUTOFILTER_OMIT_TABLE_SUFFIX}):
      
      cSuffix = entry(i, {&K_AUTOFILTER_OMIT_TABLE_SUFFIX}).
      
      if cTableName matches substitute('*&1':U, cSuffix) then
      do:
        
        gcTableFilter = substring(cTableName, 1, length(cTableName) - length(cSuffix)).
        leave.
        
      end. /* if cTableName matches substitute('*&1':U, cSuffix) */
      
    end. /* do i = 1 to num-entries({&K_AUTOFILTER_OMIT_TABLE_SUFFIX}) */
    
    gcTableFilter:screen-value in frame {&FRAME-NAME} = gcTableFilter.
    apply 'value-changed':U to gcTableFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcTableFilter:handle in frame {&FRAME-NAME}).
    
  end. /* if input frame {&FRAME-NAME} gcTableFilter <> quoter(cTableName) */
  
  if   not available ttTable
    or ttTable.TableName <> cTableName then
  do:
    
    find bttTable
      where bttTable.DatabaseName = cDatabaseName
        and bttTable.TableName    = cTableName
      no-error.
    
    if available bttTable then
    do:
      
      reposition brTable to rowid rowid(bttTable) no-error.
      apply 'value-changed':U to brTable in frame {&FRAME-NAME}.
      
    end. /* if available bttTable */
    
  end. /* if   not available ttTable ... */
  
end. /* if    cDatabaseName > '':U */

end procedure. /* qg_SelectTable */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggerAddLogEntry hQueryWindow 
PROCEDURE qg_SessionTriggerAddLogEntry :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Add session trigger log entry with given information.                      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcTitle                        = Title for session trigger event.          */
/* pcText                         = Text for session trigger event.           */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcTitle as character no-undo.
define input parameter pcText  as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

output stream strSeTrigger to value(gcSessionTriggerLogFileName) append.

put stream strSeTrigger unformatted
  substitute('~n~n*&1*~n* &2 &3*~n*&1*~n~n&4~n':U,
             fill('-':U, 78),
             pcTitle,
             fill(' ':U, 80 - length(pcTitle) - 4),
             pctext).

finally:
  
  output stream strSeTrigger close.
  
end finally.

end procedure. /* qg_SessionTriggerAddLogEntry */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggerAssign hQueryWindow 
PROCEDURE qg_SessionTriggerAssign :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Session trigger procedure for assign event.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piTriggerId                    = Session trigger id.                       */
/* phBuffer                       = Buffer handle.                            */
/* pcOldValue                     = Old value.                                */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piTriggerId as integer   no-undo.
define input parameter phBuffer    as handle    no-undo.
define input parameter pcOldValue  as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cTitle as character no-undo.
define variable cText  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttSessionTrigger
  where bttSessionTrigger.Id = piTriggerId
  no-error.

if not available bttSessionTrigger then
  leave.

assign
  cTitle = substitute('&1 &2 - &3.&4 (assign)':T, ~
                      string(today, '99.99.9999':U), ~
                      string(time, 'HH:MM:SS':U), ~
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName)
  cText  =            'Session-Trigger (assign) for table &1.&2.':T
           + '~n':U
           + '~n':U + 'Value of &1.&2.&3 has changed:':T
           + '~n':U + '-> old value: &4':T
           + '~n':U + '-> new value: &5':T
  cText  =   cText
           + '~n':U
           + '~n':U + 'Primary index of record:':T
           + '~n':U + '&6':U
    when glSessionTriggerIndexValues
  cText  =   cText
           + '~n':U
           + '~n':U + 'Stacktrace:':T
           + '~n':U + '&7':U
    when glSessionTriggerStackTrace
  cText  = substitute(cText,
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName,
                      bttSessionTrigger.FieldName,
                      quoter(pcOldValue),
                      quoter(phBuffer:buffer-field(bttSessionTrigger.FieldName):buffer-value),
                      qg_cIndexFieldValues(phBuffer, ?),
                      qg_cStacktrace())
  .

if glSessionTriggerShowMessage then
  message /* code checked by mth 30.07.2015 */
    cText
    view-as alert-box
    information
    title cTitle.

if glSessionTriggerWriteLog then
  run qg_SessionTriggerAddLogEntry(cTitle, cText).

end procedure. /* qg_SessionTriggerAssign */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggerCreate hQueryWindow 
PROCEDURE qg_SessionTriggerCreate :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Session trigger procedure for create event.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piTriggerId                    = Session trigger id.                       */
/* phBuffer                       = Buffer handle.                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piTriggerId as integer   no-undo.
define input parameter phBuffer    as handle    no-undo. /* code checked by mth 30.07.2015 */

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cTitle as character no-undo.
define variable cText  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttSessionTrigger
  where bttSessionTrigger.Id = piTriggerId
  no-error.

if not available bttSessionTrigger then
  leave.

assign
  cTitle = substitute('&1 &2 - &3.&4 (create)':T,
                      string(today, '99.99.9999':U),
                      string(time, 'HH:MM:SS':U),
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName)
  cText  = 'Session-Trigger (create) for table &1.&2.':T
  cText  =   cText
           + '~n':U
           + '~n':U + 'Stacktrace:':T
           + '~n':U + '&3':U
    when glSessionTriggerStackTrace
  cText  = substitute(cText,
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName,
                      qg_cStacktrace())
  .

if glSessionTriggerShowMessage then
  message /* code checked by mth 30.07.2015 */
    cText
    view-as alert-box
    information
    title cTitle.

if glSessionTriggerWriteLog then
  run qg_SessionTriggerAddLogEntry(cTitle, cText).

end procedure. /* qg_SessionTriggerCreate */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggerDelete hQueryWindow 
PROCEDURE qg_SessionTriggerDelete :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Session trigger procedure for delete event.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piTriggerId                    = Session trigger id.                       */
/* phBuffer                       = Buffer handle.                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piTriggerId as integer   no-undo.
define input parameter phBuffer    as handle    no-undo. /* code checked by mth 30.07.2015 */

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cTitle as character no-undo.
define variable cText  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttSessionTrigger
  where bttSessionTrigger.Id = piTriggerId
  no-error.

if not available bttSessionTrigger then
  leave.

assign
  cTitle = substitute('&1 &2 - &3.&4 (delete)':T, ~
                      string(today, '99.99.9999':U), ~
                      string(time, 'HH:MM:SS':U), ~
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName)
  cText  = 'Session-Trigger (delete) for table &1.&2.':T
  cText  =   cText
           + '~n':U
           + '~n':U + 'Primary index of record:':T
           + '~n':U + '&3':U
    when glSessionTriggerIndexValues
  cText  =   cText
           + '~n':U
           + '~n':U + 'Stacktrace:':T
           + '~n':U + '&4':U
    when glSessionTriggerStackTrace
  cText  = substitute(cText,
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName,
                      qg_cIndexFieldValues(phBuffer, ?),
                      qg_cStacktrace())
  .

if glSessionTriggerShowMessage then
  message /* code checked by mth 30.07.2015 */
    cText
    view-as alert-box
    information
    title cTitle.

if glSessionTriggerWriteLog then
  run qg_SessionTriggerAddLogEntry(cTitle, cText).

end procedure. /* qg_SessionTriggerDelete */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersChooseLogFileChoose hQueryWindow 
PROCEDURE qg_SessionTriggersChooseLogFileChoose :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show file open dialog for session trigger log file.                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cFileName as character no-undo.
define variable lOk       as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

cFileName = gcSessionTriggerLogFileName.

system-dialog get-file cFileName
  title             'Choose log file':U
  filters           'Log files (*.log)':U '*.log':U
  default-extension '.log':U
  ask-overwrite
  save-as
  use-filename
  update lOk
  in window ghSessionTriggersWindow
  .

if lOk then
do:
  
  ghSessionTriggerLogFileName:screen-value = cFileName.
  
  apply 'value-changed':U to ghSessionTriggerLogFileName.
  
end. /* if lOk */

end procedure. /* qg_SessionTriggersChooseLogFileChoose */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersDeleteLogFile hQueryWindow 
PROCEDURE qg_SessionTriggersDeleteLogFile :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Delete session trigger log file.                                           */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

os-delete value(gcSessionTriggerLogFileName).

end procedure. /* qg_SessionTriggersDeleteLogFile */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersLogFileNameChanged hQueryWindow 
PROCEDURE qg_SessionTriggersLogFileNameChanged :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for session trigger log file fill-in.                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggerLogFileName) then
  gcSessionTriggerLogFileName = ghSessionTriggerLogFileName:input-value.

end procedure. /* qg_SessionTriggersLogFileNameChanged */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersOpenLogFile hQueryWindow 
PROCEDURE qg_SessionTriggersOpenLogFile :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open session trigger log file with default application.                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

file-info:file-name = gcSessionTriggerLogFileName.

if file-info:full-pathname = ? then
  message /* code checked by mth 30.07.2015 */
    substitute('The file ~'&1~' does not exist!':T,
               gcSessionTriggerLogFileName) skip
    view-as alert-box
    error
    buttons ok
    in window ghSessionTriggersWindow.

else
  os-command no-wait value(gcSessionTriggerLogFileName).

end procedure. /* qg_SessionTriggersOpenLogFile */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersOpenQuery hQueryWindow 
PROCEDURE qg_SessionTriggersOpenQuery :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Open query for session trigger browse.                                     */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggersWindow) then
  qg_lQueryOpen(ghSessionTriggersBrowse:query,
                'for each ttSessionTrigger use-index TriggerObject':U,
                ghSessionTriggersWindow).

end procedure. /* qg_SessionTriggersOpenQuery */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersRemoveAllSessionTriggers hQueryWindow 
PROCEDURE qg_SessionTriggersRemoveAllSessionTriggers :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove all session triggers.                                               */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

run qg_RemoveAllSessionTriggers.

end procedure. /* qg_SessionTriggersRemoveAllSessionTriggers */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersRemoveSessionTrigger hQueryWindow 
PROCEDURE qg_SessionTriggersRemoveSessionTrigger :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Remove currently selected session trigger.                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hBuffer as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghSessionTriggersWindow) then
  leave.

hBuffer = ghSessionTriggersBrowse:query:get-buffer-handle(1).

if hBuffer:available then
  run qg_RemoveSessionTrigger(hBuffer::TriggerEvent,
                              hBuffer::DatabaseName,
                              hBuffer::TableName,
                              hBuffer::FieldName).

end procedure. /* qg_SessionTriggersRemoveSessionTrigger */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersShowIndexValuesChanged hQueryWindow 
PROCEDURE qg_SessionTriggersShowIndexValuesChanged :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for value changed event of session trigger show index    */
/* toggle-box.                                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggerIndexValues) then
  glSessionTriggerIndexValues = ghSessionTriggerIndexValues:input-value.

end procedure. /* qg_SessionTriggersShowIndexValuesChanged */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersShowMessageChanged hQueryWindow 
PROCEDURE qg_SessionTriggersShowMessageChanged :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for value changed event of session trigger show message  */
/* toggle-box.                                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggerShowMessage) then
  glSessionTriggerShowMessage = ghSessionTriggerShowMessage:input-value.

end procedure. /* qg_SessionTriggersShowMessageChanged */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersShowStackTraceChanged hQueryWindow 
PROCEDURE qg_SessionTriggersShowStackTraceChanged :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for value changed event of session trigger show stack    */
/* trace toggle-box.                                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggerStackTrace) then
  glSessionTriggerStackTrace = ghSessionTriggerStackTrace:input-value.

end procedure. /* qg_SessionTriggersShowStackTraceChanged */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersWindowClose hQueryWindow 
PROCEDURE qg_SessionTriggersWindowClose :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for window close event of session trigger window.        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggersWindow) then
  run qg_DeleteWidgetTree(ghSessionTriggersWindow, yes).

end procedure. /* qg_SessionTriggersWindowClose */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersWindowResized hQueryWindow 
PROCEDURE qg_SessionTriggersWindowResized :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for window resized event of session trigger window.      */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hFrame               as handle    no-undo.
define variable hChooseLogFileButton as handle    no-undo.
define variable hOpenLogFileButton   as handle    no-undo.
define variable hDeleteLogFileButton as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if not valid-handle(ghSessionTriggersWindow) then
  leave.

assign
  ghSessionTriggersWindow:width     = max(60, ghSessionTriggersWindow:width)
  ghSessionTriggersWindow:height    = max(10, ghSessionTriggersWindow:height)
  hFrame                            = qg_hGetWidgetByName(ghSessionTriggersWindow,
                                                          'fSessionTriggers':U)
  hFrame:width                      = ghSessionTriggersWindow:width
  hFrame:virtual-width              = ghSessionTriggersWindow:width
  hFrame:height                     = ghSessionTriggersWindow:height
  hFrame:virtual-height             = ghSessionTriggersWindow:height
  ghSessionTriggerLogFileName:width = hFrame:width - 44
  hChooseLogFileButton              = qg_hGetWidgetByName(ghSessionTriggersWindow,
                                                          'btnChooseLogFile':U)
  hChooseLogFileButton:col          =   ghSessionTriggerLogFileName:col
                                      + ghSessionTriggerLogFileName:width
  hOpenLogFileButton                = qg_hGetWidgetByName(ghSessionTriggersWindow,
                                                          'btnOpenLogFile':U)
  hOpenLogFileButton:col            =   hChooseLogFileButton:col
                                      + hChooseLogFileButton:width
                                      + 1
  hDeleteLogFileButton              = qg_hGetWidgetByName(ghSessionTriggersWindow,
                                                          'btnDeleteLogFile':U)
  hDeleteLogFileButton:col          =   hOpenLogFileButton:col
                                      + hOpenLogFileButton:width
  ghSessionTriggersBrowse:width     = hFrame:width - 4
  ghSessionTriggersBrowse:height    = hFrame:height - 6.5
  .

end procedure. /* qg_SessionTriggersWindowResized */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggersWriteLogChanged hQueryWindow 
PROCEDURE qg_SessionTriggersWriteLogChanged :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Trigger procedure for value changed event of session trigger write log     */
/* toggle-box.                                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hChooseLogFileButton as handle    no-undo.
define variable hOpenLogFileButton   as handle    no-undo.
define variable hDeleteLogFileButton as handle    no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if valid-handle(ghSessionTriggerWriteLog) then
  assign
    glSessionTriggerWriteLog              = ghSessionTriggerWriteLog:input-value
    ghSessionTriggerLogFileName:read-only = not glSessionTriggerWriteLog
    hChooseLogFileButton                  = qg_hGetWidgetByName(ghSessionTriggersWindow,
                                                                'btnChooseLogFile':U)
    hChooseLogFileButton:sensitive        = glSessionTriggerWriteLog /* code checked by mth 30.07.2015 */
    hOpenLogFileButton                    = qg_hGetWidgetByName(ghSessionTriggersWindow,
                                                                'btnOpenLogFile':U)
    hOpenLogFileButton:sensitive          = glSessionTriggerWriteLog /* code checked by mth 30.07.2015 */
    hDeleteLogFileButton                  = qg_hGetWidgetByName(ghSessionTriggersWindow,
                                                                'btnDeleteLogFile':U)
    hDeleteLogFileButton:sensitive        = glSessionTriggerWriteLog /* code checked by mth 30.07.2015 */
    .
  
end procedure. /* qg_SessionTriggersWriteLogChanged */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SessionTriggerWrite hQueryWindow 
PROCEDURE qg_SessionTriggerWrite :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Session trigger procedure for write event.                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piTriggerId                    = Session trigger id.                       */
/* phBuffer                       = Buffer handle.                            */
/* phOldBuffer                    = Old buffer handle.                        */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piTriggerId as integer   no-undo.
define input parameter phBuffer    as handle    no-undo.
define input parameter phOldBuffer as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cTitle     as character no-undo.
define variable cText      as character no-undo.

define variable cFieldList as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttSessionTrigger
  where bttSessionTrigger.Id = piTriggerId
  no-error.

if not available bttSessionTrigger then
  leave.

cFieldList = qg_cBufferCompare(phBuffer, phOldBuffer).

assign
  cTitle = substitute('&1 &2 - &3.&4 (write)':T, ~
                      string(today, '99.99.9999':U), ~
                      string(time, 'HH:MM:SS':U), ~
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName)
  cText  =            'Session-Trigger (write) for table &1.&2.':T
           + '~n':U
           + '~n':U + 'Changed fields:':T
           + '~n':U + qg_cFieldValues(phBuffer, phOldBuffer, cFieldList)
  cText  =   cText
           + '~n':U
           + '~n':U + 'Primary index of record:':T
           + '~n':U + '&3':U
    when glSessionTriggerIndexValues
  cText  =   cText
           + '~n':U
           + '~n':U + 'Stacktrace:':T
           + '~n':U + '&4':U
    when glSessionTriggerStackTrace
  cText  = substitute(cText,
                      bttSessionTrigger.DatabaseName,
                      bttSessionTrigger.TableName,
                      qg_cIndexFieldValues(phBuffer, ?),
                      qg_cStacktrace())
  .

if glSessionTriggerShowMessage then
  message /* code checked by mth 30.07.2015 */
    cText
    view-as alert-box
    information
    title cTitle.

if glSessionTriggerWriteLog then
  run qg_SessionTriggerAddLogEntry(cTitle, cText).

end procedure. /* qg_SessionTriggerWrite */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetBlockPattern hQueryWindow 
PROCEDURE qg_SetBlockPattern :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set block pattern und update input field.                                  */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcBlockPattern as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

gcBlockPattern = pcBlockPattern.

run qg_UpdateBlockName.

apply 'entry':U to gcBlockName in frame {&FRAME-NAME}.

end procedure. /* qg_SetBlockPattern */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetBrowseColumns hQueryWindow 
PROCEDURE qg_SetBrowseColumns :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set browse column visible state and order.                                 */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowse                       = Browse whose colums should be set.        */
/* pcColumnList                   = List of visible colums.                   */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowse     as handle    no-undo.
define input parameter pcColumnList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i            as integer   no-undo.
define variable j            as integer   no-undo.
define variable iColumnIndex as integer   no-undo.
define variable hColumn      as handle    no-undo.

define variable lBufferName  as logical   no-undo.
define variable cColumnName  as character no-undo.
define variable dColumnWidth as decimal   no-undo.
define variable cColumnList  as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

/* Change column order. */
do i = num-entries(pcColumnList) to 1 by -1:
  
  assign
    iColumnIndex = 0
    cColumnName  = entry(i, pcColumnList)
    dColumnWidth = ?
    .
  
  if num-entries(cColumnName, ':':U) > 1 then
  do:
    
    dColumnWidth = decimal(replace(entry(2, cColumnName, ':':U),
                                   '.':U,
                                   session:numeric-decimal-point)) no-error.
    cColumnName  = entry(1, cColumnName, ':':U).
    
  end. /* if num-entries(cColumnName, ':':U) > 1 */
  
  if num-entries(cColumnName, '.':U) > 1 then
    lBufferName = yes.
  
  /* Find column. */
  do j = 1 to phBrowse:num-columns:
    
    if qg_cColumnFieldName(phBrowse:get-browse-column(j),
                           lBufferName) = cColumnName then
    do:
      iColumnIndex = j.
      leave.
    end. /* if qg_cColumnFieldName(phBrowse:get-browse-column(j), */
    
  end. /* do j = 1 to browse brQuery:num-columns */
  
  if iColumnIndex > 0 then
  do:
    
    phBrowse:move-column(iColumnIndex, 1).
    
    if dColumnWidth > 0 then
      phBrowse:get-browse-column(1):width-chars = dColumnWidth.
    
    cColumnList = substitute('&1,&2':U,
                             cColumnList,
                             cColumnName).
    
  end. /* if iColumnIndex > 0 */
  
end. /* do i = 1 to num-entries() */

cColumnList = trim(cColumnList, ',':U).

/* Hide unselected columns. */
do i = 1 to phBrowse:num-columns:
  
  assign
    hColumn         = phBrowse:get-browse-column(i)
    hColumn:visible = (lookup(qg_cColumnFieldName(hColumn,
                                                  lBufferName),
                              cColumnList) <> 0)
    .
  
end. /* do i = 1 to num-entries() */

end procedure. /* qg_SetBrowseColumns */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetBufferPattern hQueryWindow 
PROCEDURE qg_SetBufferPattern :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Sets a buffer pattern for given index and updates the buffer name.         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcPattern                      = Buffer pattern that should be used.       */
/* piIndex                        = Index that should be used.                */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcPattern as character no-undo.
define input parameter piIndex   as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cIndex as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cIndex          = (if piIndex > 0 then
                       string(piIndex)
                     else
                       '':U)
  gcBufferPattern = qg_cSubstituteChar(pcPattern, '#':U, cIndex)
  .

run qg_UpdateBufferName.

apply 'entry':U to gcBufferName in frame {&FRAME-NAME}.

end procedure. /* qg_SetBufferPattern */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetDefaultValues hQueryWindow 
PROCEDURE qg_SetDefaultValues :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set default values.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

/* Assign default values. */
assign
  gcTableFilter      = '':U
  gcTableFieldFilter = '':U
  gcIndexFilter      = '':U
  gcIndexFieldFilter = '':U
  gcFieldFilter      = '':U
  gcFieldLabelFilter = '':U
  gcBufferPattern    = {&K_DEFAULT_BUFFER_PATTERN}
  glDefineBuffer     = {&K_DEFAULT_DEFINE_BUFFER}
  glNoError          = {&K_DEFAULT_NO_ERROR}
  glIfStatement      = {&K_DEFAULT_IF_STATEMENT}
  glNot              = {&K_DEFAULT_NOT}
  glDoBlock          = {&K_DEFAULT_DO_BLOCK}
  glExclusiveLock    = {&K_DEFAULT_EXCLUSIVE_LOCK}
  glCompanyViaClass  = {&K_DEFAULT_COMPANY_VIA_CLASS}
  giOnErrorPhrase    = {&K_DEFAULT_ON_ERROR_PHRASE}
  gcBlockPattern     = {&K_DEFAULT_BLOCK_PATTERN}
  glDefineBlock      = {&K_DEFAULT_DEFINE_BLOCK}
  glRetryBlock       = {&K_DEFAULT_RETRY_BLOCK}
  glFinallyBlock     = {&K_DEFAULT_FINALLY_BLOCK}
  giQueryType        = {&K_DEFAULT_QUERY_TYPE}
  giIndentation      = {&K_DEFAULT_INDENTATION}
  glInsertMode       =     OEIDEIsRunning
                       and glIDECanInsert
                       and {&K_DEFAULT_INSERT_MODE}
  .

display unless-hidden
  gcTableFilter
  gcTableFieldFilter
  gcIndexFilter
  gcIndexFieldFilter
  gcFieldFilter
  gcFieldLabelFilter
  glDefineBuffer
  glNoError
  glIfStatement
  glNot
  glDoBlock
  glExclusiveLock
  glCompanyViaClass
  giOnErrorPhrase
  glDefineBlock
  glRetryBlock
  glFinallyBlock
  giQueryType
  with frame {&FRAME-NAME}.

run qg_FillQueryRange.

end procedure. /* qg_SetDefaultValues */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetDisplayMode hQueryWindow 
PROCEDURE qg_SetDisplayMode :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set display mode.                                                          */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piDisplayMode                  = Display mode that should be set.          */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piDisplayMode as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if piDisplayMode = {&K_DISPLAYMODE_INDEX} then
do:
  
  assign
    gcIndexFilter:hidden in frame {&FRAME-NAME}            = no
    btnClearIndexFilter:hidden in frame {&FRAME-NAME}      = no
    gcIndexFieldFilter:hidden in frame {&FRAME-NAME}       = no
    btnClearIndexFieldFilter:hidden in frame {&FRAME-NAME} = no
    gcIndexDummy:hidden in frame {&FRAME-NAME}             = no
    brIndex:hidden in frame {&FRAME-NAME}                  = no
    gcFieldFilter:hidden in frame {&FRAME-NAME}            = yes
    btnClearFieldFilter:hidden in frame {&FRAME-NAME}      = yes
    gcFieldLabelFilter:hidden in frame {&FRAME-NAME}       = yes
    btnClearFieldLabelFilter:hidden in frame {&FRAME-NAME} = yes
    brField:hidden in frame {&FRAME-NAME}                  = yes
    gcFieldDummy:hidden in frame {&FRAME-NAME}             = yes.
    giDisplayMode                                          = {&K_DISPLAYMODE_INDEX}
    .
  
  display unless-hidden
    {&DISPLAYED-OBJECTS}
    with frame {&FRAME-NAME}.
  
  run qg_FillQueryRange.
  apply 'value-changed':U to brIndex in frame {&FRAME-NAME}.
  
end. /* if giDisplayMode = {&K_DISPLAYMODE_INDEX} */

else
do:
  
  assign
    gcIndexFilter:hidden in frame {&FRAME-NAME}            = yes
    btnClearIndexFilter:hidden in frame {&FRAME-NAME}      = yes
    gcIndexFieldFilter:hidden in frame {&FRAME-NAME}       = yes
    btnClearIndexFieldFilter:hidden in frame {&FRAME-NAME} = yes
    gcIndexDummy:hidden in frame {&FRAME-NAME}             = yes
    brIndex:hidden in frame {&FRAME-NAME}                  = yes
    gcFieldFilter:hidden in frame {&FRAME-NAME}            = no
    btnClearFieldFilter:hidden in frame {&FRAME-NAME}      = no
    gcFieldLabelFilter:hidden in frame {&FRAME-NAME}       = no
    btnClearFieldLabelFilter:hidden in frame {&FRAME-NAME} = no
    gcFieldDummy:hidden in frame {&FRAME-NAME}             = no
    brField:hidden in frame {&FRAME-NAME}                  = no
    giDisplayMode                                          = {&K_DISPLAYMODE_FIELD}
    .
  
  display unless-hidden
    {&DISPLAYED-OBJECTS}
    with frame {&FRAME-NAME}.
  
  run qg_FillQueryRange.
  apply 'value-changed':U to brField in frame {&FRAME-NAME}.
  
end. /* else: if giDisplayMode = {&K_DISPLAYMODE_INDEX} */

end procedure. /* qg_SetDisplayMode */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetExternalParameters hQueryWindow 
PROCEDURE qg_SetExternalParameters :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set external parameters.                                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcParamList                    = List of external parameters.              */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcParamList as character no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable iHandlerId    as integer   no-undo.
define variable cSettingValue as character no-undo. 

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

iHandlerId = qg_iParamListReadValue(pcParamList,
                                    {&K_EDITOR_INSERT_REQUEST_HANDLER},
                                    {&K_PARAM_SPLITTER}).

if iHandlerId > 0 then
  run qg_SetHandlerId({&K_EDITOR_INSERT_REQUEST_HANDLER},
                      iHandlerId).

iHandlerId = qg_iParamListReadValue(pcParamList,
                                    {&K_SAVE_PLUGIN_SETTING_HANDLER},
                                    {&K_PARAM_SPLITTER}).

if iHandlerId > 0 then
  run qg_SetHandlerId({&K_SAVE_PLUGIN_SETTING_HANDLER},
                      iHandlerId).

iHandlerId = qg_iParamListReadValue(pcParamList,
                                    {&K_LOAD_PLUGIN_SETTING_HANDLER},
                                    {&K_PARAM_SPLITTER}).

if iHandlerId > 0 then
  run qg_SetHandlerId({&K_LOAD_PLUGIN_SETTING_HANDLER},
                      iHandlerId).

run qg_WidgetState('*':U).

if    OEIDEIsRunning
  and glIDECanLoadSetting then
do:
  
  /* gcTableFilter history */
  run qg_LoadIDESetting('FieldHistory_gcTableFilter':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    gcTableFilter:list-items in frame {&FRAME-NAME} = cSettingValue.
  
  /* gcTableFieldFilter history */
  run qg_LoadIDESetting('FieldHistory_gcTableFieldFilter':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    gcTableFieldFilter:list-items in frame {&FRAME-NAME} = cSettingValue.
  
  /* gcIndexFilter history */
  run qg_LoadIDESetting('FieldHistory_gcIndexFilter':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    gcIndexFilter:list-items in frame {&FRAME-NAME} = cSettingValue.
  
  /* gcIndexFieldFilter history */
  run qg_LoadIDESetting('FieldHistory_gcIndexFilter':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    gcIndexFieldFilter:list-items in frame {&FRAME-NAME} = cSettingValue.
  
  /* gcFieldFilter history */
  run qg_LoadIDESetting('FieldHistory_gcFieldFilter':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    gcFieldFilter:list-items in frame {&FRAME-NAME} = cSettingValue.
  
  /* gcFieldLabelFilter history */
  run qg_LoadIDESetting('FieldHistory_gcFieldLabelFilter':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    gcFieldLabelFilter:list-items in frame {&FRAME-NAME} = cSettingValue.
  
  /* gcBufferName initial value */
  run qg_LoadIDESetting('FieldInitial_gcBufferName':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
  do:
    
    gcBufferPattern = cSettingValue.
    run qg_UpdateBufferName.
    
  end. /* if cSettingValue > '':U */
  
  /* glDefineBuffer initial value */
  run qg_LoadIDESetting('FieldInitial_glDefineBuffer':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glDefineBuffer = logical(cSettingValue, 'true/false':U).
  
  /* glCompanyViaClass initial value */
  run qg_LoadIDESetting('FieldInitial_glCompanyViaClass':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glCompanyViaClass = logical(cSettingValue, 'true/false':U).
  
  /* glExclusiveLock initial value */
  run qg_LoadIDESetting('FieldInitial_glExclusiveLock':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glExclusiveLock = logical(cSettingValue, 'true/false':U).
  
  /* glNoError initial value */
  run qg_LoadIDESetting('FieldInitial_glNoError':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glNoError = logical(cSettingValue, 'true/false':U).
  
  /* glIfStatement initial value */
  run qg_LoadIDESetting('FieldInitial_glIfStatement':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glIfStatement = logical(cSettingValue, 'true/false':U).
  
  /* glNot initial value */
  run qg_LoadIDESetting('FieldInitial_glNot':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glNot = logical(cSettingValue, 'true/false':U).
  
  /* glDoBlock initial value */
  run qg_LoadIDESetting('FieldInitial_glDoBlock':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glDoBlock = logical(cSettingValue, 'true/false':U).
  
  /* giOnErrorPhrase initial value */
  run qg_LoadIDESetting('FieldInitial_giOnErrorPhrase':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    giOnErrorPhrase = integer(cSettingValue).
  
  /* gcBlockName initial value */
  run qg_LoadIDESetting('FieldInitial_gcBlockName':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
  do:
    
    gcBlockPattern = cSettingValue.
    run qg_UpdateBlockName.
    
  end. /* if cSettingValue > '':U */
  
  /* glDefineBlock initial value */
  run qg_LoadIDESetting('FieldInitial_glDefineBlock':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glDefineBlock = logical(cSettingValue, 'true/false':U).
  
  /* glRetryBlock initial value */
  run qg_LoadIDESetting('FieldInitial_glRetryBlock':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glRetryBlock = logical(cSettingValue, 'true/false':U).
  
  /* glFinallyBlock initial value */
  run qg_LoadIDESetting('FieldInitial_glFinallyBlock':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    glFinallyBlock = logical(cSettingValue, 'true/false':U).
  
  /* giQueryType initial value */
  run qg_LoadIDESetting('FieldInitial_giQueryType':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    giQueryType = integer(cSettingValue).
  
  /* Open query window for persistent temp-tables */
  run qg_LoadIDESetting('Options_OpenQueryWindowForPersistentTT':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    menu-item mi_OpenQueryWindowPersistentTT:checked in menu m_Options = logical(cSettingValue, 'true/false':U).
  
  /* Open query window for snapshot temp-tables */
  run qg_LoadIDESetting('Options_OpenQueryWindowForSnapshotTT':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
    menu-item mi_OpenQueryWindowSnapshotTT:checked in menu m_Options = logical(cSettingValue, 'true/false':U).
  
  display unless-hidden
    glDefineBuffer
    glCompanyViaClass
    glExclusiveLock
    glNoError
    glIfStatement
    glNot
    glDoBlock
    giOnErrorPhrase
    glDefineBlock
    glRetryBlock
    glFinallyBlock
    giQueryType
    with frame {&FRAME-NAME}.
  
  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.
  
  /*--------------------------------------------------------------------------*/
  /* Session-Trigger settings                                                 */
  /*--------------------------------------------------------------------------*/
  
  run qg_LoadIDESetting('Options_SessionTriggerShowMessage':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
  do:
    
    glSessionTriggerShowMessage = logical(cSettingValue, 'true/false':U).
    
    if valid-handle(ghSessionTriggerShowMessage) then
      ghSessionTriggerShowMessage:screen-value = string(glSessionTriggerShowMessage).
    
  end. /* if cSettingValue > '':U */

  run qg_LoadIDESetting('Options_SessionTriggerWriteLog':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
  do:
    
    glSessionTriggerWriteLog = logical(cSettingValue, 'true/false':U).
    
    if valid-handle(ghSessionTriggerWriteLog) then
      ghSessionTriggerWriteLog:screen-value = string(glSessionTriggerWriteLog).
    
  end. /* if cSettingValue > '':U */

  run qg_LoadIDESetting('Options_SessionTriggerLogFileName':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
  do:
    
    gcSessionTriggerLogFileName = cSettingValue.
    
    if valid-handle(ghSessionTriggerLogFileName) then
      ghSessionTriggerLogFileName:screen-value = string(gcSessionTriggerLogFileName).
    
  end. /* if cSettingValue > '':U */

  run qg_LoadIDESetting('Options_SessionTriggerIndexValues':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
  do:
    
    glSessionTriggerIndexValues = logical(cSettingValue, 'true/false':U).
    
    if valid-handle(ghSessionTriggerIndexValues) then
      ghSessionTriggerIndexValues:screen-value = string(glSessionTriggerIndexValues).
    
  end. /* if cSettingValue > '':U */

  run qg_LoadIDESetting('Options_SessionTriggerStackTrace':U,
                        output cSettingValue).
  
  if cSettingValue > '':U then
  do:
    
    glSessionTriggerStackTrace = logical(cSettingValue, 'true/false':U).
    
    if valid-handle(ghSessionTriggerStackTrace) then
      ghSessionTriggerStackTrace:screen-value = string(glSessionTriggerStackTrace).
    
  end. /* if cSettingValue > '':U */

end. /* if glIDECanLoadSetting */

end procedure. /* qg_SetExternalParameters */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetHandlerId hQueryWindow 
PROCEDURE qg_SetHandlerId :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set handler id.                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcHandlerName                  = Handler name.                             */
/* piHandlerId                    = Handler Id                                */
/*                                                                            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcHandlerName as character no-undo.
define input parameter piHandlerId   as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttIDEHandler for temp-table ttIDEHandler.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

find bttIDEHandler
  where bttIDEHandler.HandlerName = pcHandlerName
  no-error.

if not available bttIDEHandler then
do:
  
  create bttIDEHandler.
  
  bttIDEHandler.HandlerName = pcHandlerName.
  
end. /* not available bttIDEHandler */

case bttIDEHandler.HandlerName:
  
  when {&K_EDITOR_INSERT_REQUEST_HANDLER} then
    assign
      glIDECanInsert =     piHandlerId <> ?
                       and piHandlerId  > 0
      glInsertMode   =     OEIDEIsRunning
                       and glIDECanInsert
                       and {&K_DEFAULT_INSERT_MODE}
      .
  
  when {&K_SAVE_PLUGIN_SETTING_HANDLER} then
    glIDECanSaveSetting =     piHandlerId <> ?
                          and piHandlerId  > 0.
  
  when {&K_LOAD_PLUGIN_SETTING_HANDLER} then
    glIDECanLoadSetting =     piHandlerId <> ?
                          and piHandlerId  > 0.
  
end case. /* bttIDEHandler.HandlerName */

bttIDEHandler.HandlerId = piHandlerId.

end procedure. /* qg_SetHandlerId */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetQueryType hQueryWindow 
PROCEDURE qg_SetQueryType :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set query type.                                                            */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* piQueryType                    = Query type that should be used.           */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter piQueryType as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

giQueryType = piQueryType.

display unless-hidden
  giQueryType
  with frame {&FRAME-NAME}.

run qg_FillQueryRange.
run qg_WidgetState('*':U).
run qg_UpdateQueryText.


end procedure. /* qg_SetQueryType */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetSlimMode hQueryWindow 
PROCEDURE qg_SetSlimMode :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set or unset slim mode.                                                    */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* plSlimMode                     = Indicates wether slim mode should be set  */
/*                                  or unset.                                 */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter plSlimMode as logical   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if plSlimMode <> glSlimMode then
do:
  
  if hQueryWindow:window-state = {&K_WINDOW_MAXIMIZED} then
    hQueryWindow:window-state = {&K_WINDOW_NORMAL}.
  
  glSlimMode = plSlimMode.
  
  if not glSlimMode then
  do:
    
    assign
      gdOriginalWidth          = gdOriginalWidth * {&K_SLIM_MODE_FACTOR}
      gdMinWidth               = {&K_WINDOW_MIN_WIDTH}
      gdMinHeight              = {&K_WINDOW_MIN_HEIGHT}
      hQueryWindow:width-chars = hQueryWindow:width-chars * {&K_SLIM_MODE_FACTOR}.
    
    apply 'window-resized':U to hQueryWindow.
    
  end. /* if not glSlimMode */
  
  do with frame {&FRAME-NAME}:
    
    assign
      gcBufferName:hidden           = glSlimMode
      btnClearBufferPattern:hidden  = glSlimMode
      btnBuffer1:hidden             = glSlimMode or ({&K_BUFFER_PATTERN_1} = '':U)
      btnBuffer2:hidden             = glSlimMode or ({&K_BUFFER_PATTERN_2} = '':U)
      btnBuffer3:hidden             = glSlimMode or ({&K_BUFFER_PATTERN_3} = '':U)
      btnBuffer4:hidden             = glSlimMode or ({&K_BUFFER_PATTERN_4} = '':U)
      glDefineBuffer:hidden         = glSlimMode
      glCompanyViaClass:hidden      = glSlimMode
      glExclusiveLock:hidden        = glSlimMode
      glNoError:hidden              = glSlimMode
      glIfStatement:hidden          = glSlimMode
      glNot:hidden                  = glSlimMode
      glDoBlock:hidden              = glSlimMode
      giOnErrorPhrase:hidden        = glSlimMode
      giQueryRange:hidden           = glSlimMode or {&K_HIDE_QUERYRANGE}
      gcBlockName:hidden            = glSlimMode
      btnClearBlockName:hidden      = glSlimMode
      btnBlock1:hidden              = glSlimMode or ({&K_BLOCK_PATTERN_1} = '':U)
      btnBlock2:hidden              = glSlimMode or ({&K_BLOCK_PATTERN_2} = '':U)
      btnBlock3:hidden              = glSlimMode or ({&K_BLOCK_PATTERN_3} = '':U)
      btnBlock4:hidden              = glSlimMode or ({&K_BLOCK_PATTERN_4} = '':U)
      glDefineBlock:hidden          = glSlimMode
      glRetryBlock:hidden           = glSlimMode
      glFinallyBlock:hidden         = glSlimMode
      glFinallyBlock:hidden         = glSlimMode
      giQueryType:hidden            = glSlimMode
      btnCopyToClipboard:hidden     = glSlimMode
      btnExecuteQuery:hidden        = glSlimMode
      btnResetAll:hidden            = glSlimMode
      gcQueryText:hidden            = glSlimMode
      btnIncreaseIndentation:hidden = glSlimMode
      btnDecreaseIndentation:hidden = glSlimMode
      btnResetIndentation:hidden    = glSlimMode
      gdIndexUsage:hidden           = glSlimMode
      .
    
  end. /* do with frame {&FRAME-NAME} */
  
  if glSlimMode then
  do:
    
    assign
      gdOriginalWidth          = gdOriginalWidth / {&K_SLIM_MODE_FACTOR}
      gdMinWidth               = {&K_WINDOW_MIN_WIDTH_SLIM}
      gdMinHeight              = {&K_WINDOW_MIN_HEIGHT_SLIM}
      hQueryWindow:width-chars = hQueryWindow:width-chars / {&K_SLIM_MODE_FACTOR}
      .
    
    apply 'window-resized':U to hQueryWindow.
    
  end. /* else: if not glSlimMode */
  
  run qg_UpdateBufferName.
  run qg_UpdateBlockName.
  
end. /* if plSlimMode <> glSlimMode */

end procedure. /* qg_SetSlimMode */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SetWorkingDatabase hQueryWindow 
PROCEDURE qg_SetWorkingDatabase :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Sets the working database to the currently selected database.              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    available ttDatabase
  and ttDatabase.PhysicalDB then
  create alias dictdb for database value(ttDatabase.DatabaseName).

end procedure. /* qg_SetWorkingDatabase */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ShowBrowseGrid hQueryWindow 
PROCEDURE qg_ShowBrowseGrid :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set "separators" property for given Browse.                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowse                       = Browse for which you want to set the      */
/*                                  property.                                 */
/* phMenuItem                     = Menu-item that contains the logical value */
/*                                  wether separators should be displayed or  */
/*                                  not.                                      */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowse   as handle    no-undo.
define input parameter phMenuItem as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

phBrowse:separators = phMenuItem:checked.

end procedure. /* qg_ShowBrowseGrid */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ShowBrowseRecordCount hQueryWindow 
PROCEDURE qg_ShowBrowseRecordCount :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show a message with the number of records in the given browse.             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBrowse                       = Browse that contains the records.         */
/* phParentWindow                 = Parent window for the message dialog.     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBrowse       as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

message /* code checked by mth */
  substitute('The browser currently contains &1 record&2.':T,
             trim(string(phBrowse:query:num-results, {&K_MAX_INT64_FORMAT})),
             (if phBrowse :query:num-results = 1 then
                '':U
              else
                's':U)) skip
  view-as alert-box
    information
    buttons ok
    in window phBrowse:window.

end procedure. /* qg_ShowBrowseRecordCount */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ShowObjectIdRecord hQueryWindow 
PROCEDURE qg_ShowObjectIdRecord :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show record details window for the given object id.                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phBuffer                       = Buffer that contains the object id field. */
/* pcFieldName                    = Fieldname of the object id field.         */
/* phParentWindow                 = Parent window for the dialog.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phBuffer       as handle    no-undo.
define input parameter pcFieldName    as character no-undo.

define input parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable hField          as handle    no-undo.
define variable cTableName      as character no-undo.
define variable cObjectId       as character no-undo.

define variable hRepTableBuffer as handle    no-undo.
define variable hObjBuffer      as handle    no-undo.

define variable rDummy          as rowid     no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttDatabase for ttDatabase.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if   not valid-handle(phBuffer)
  or not phBuffer:available then
  leave.

hField = phBuffer:buffer-field(pcFieldName).

if   hField:extent > 0 then
  leave.

cObjectId = hField:buffer-value(0).

if   cObjectId = ?
  or cObjectId = '':U then
  leave.

cTableName = substring(hField:name, 1, index(hField:name, '_Obj':U) - 1).

if phBuffer:dbname = {&K_PROGRESS_TTNAME} then
  find first bttDatabase
    where bttDatabase.BasisDBName > '':U
    no-error.

else
  find bttDatabase
    where bttDatabase.DatabaseName = phBuffer:dbname
    no-error.

if not available bttDatabase then
  leave.

create buffer hRepTableBuffer for table substitute('&1.DRC_Table':U,
                                                   bttDatabase.BasisDBName) no-error.

if not valid-handle(hRepTableBuffer) then
  leave.

hRepTableBuffer:find-unique(substitute('where DRC_Table.InternalIdentifier ="&1"':U,
                                       entry(1, cObjectId, ':':U)), no-lock) no-error.

if not hRepTableBuffer:available then
  leave.

create buffer hObjBuffer for table substitute('&1.&2':U,
                                              bttDatabase.DatabaseName,
                                              hRepTableBuffer::DRC_Table_ID) no-error.

if not valid-handle(hObjBuffer) then
  leave.

hObjBuffer:find-unique(substitute('where &1.&1_Obj = "&2"':U,
                                  hObjBuffer:table,
                                  cObjectId), no-lock) no-error.

if hObjBuffer:available then
  run qg_EditRecord(hObjBuffer,
                    {&K_EDITACTION_EDIT},
                    no,
                    phParentWindow,
                    ?,
                    output rDummy).

finally:
  
  if valid-handle(hRepTableBuffer) then
    delete object hRepTableBuffer.
  
  if valid-handle(hObjBuffer) then
    delete object hObjBuffer.
  
end finally.
  
end procedure. /* qg_ShowObjectIdRecord */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ShowQueryWindow hQueryWindow 
PROCEDURE qg_ShowQueryWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show a dialog to select a query window and bring it to front.              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phParentWindow                 = Parent window for the dialog.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lShowLinkedChildWindows as logical
  label 'Show linked child windows':T
  view-as toggle-box
  size 30 by 1
  no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttQueryWindow  for temp-table ttQueryWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define query brQueryWindow
  for bttQueryWindow
  scrolling.

define browse brQueryWindow
  query brQueryWindow no-lock
    display
      bttQueryWindow.WindowTitle
      with no-assign size 96 by 16.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fSelectQueryWindow
  brQueryWindow at row 1.5 col 3
  lShowLinkedChildWindows at row 18 col 3
  btnOk at row 20 col 31
  btnCancel at row 20 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select query window':U
    side-labels no-underline three-d 
    size 101 by 21.94
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectQueryWindow
  apply 'end-error' to self.

on default-action of brQueryWindow in frame fSelectQueryWindow
  apply 'go':U to frame fSelectQueryWindow.

if not can-find(first ttQueryWindow) then
  leave.

run qg_InitBrowse(browse brQueryWindow:handle).

open query brQueryWindow
  for each bttQueryWindow
    no-lock
    by bttQueryWindow.QuerySeq.

if query brQueryWindow:num-results > 0 then
do:
  
  display unless-hidden
    brQueryWindow
    with frame fSelectQueryWindow
      in window phParentWindow. 
  
  find bttQueryWindow
    where bttQueryWindow.WindowHandle = phParentWindow
    no-error.
  
  if available bttQueryWindow then
    reposition brQueryWindow to rowid rowid(bttQueryWindow).
  
  else
    brQueryWindow:select-row(1) in frame fSelectQueryWindow.
  
end. /* if query brQueryWindow:num-results > 0 */

lShowLinkedChildWindows = glShowLinkedChildWindows.

update unless-hidden
  brQueryWindow
  lShowLinkedChildWindows
  btnOk
  btnCancel
  with frame fSelectQueryWindow
    in window phParentWindow.

if    available bttQueryWindow
  and valid-handle(bttQueryWindow.WindowHandle) then
do:
  
  if lShowLinkedChildWindows then
    run qg_QueryWindowShowChildWindows(bttQueryWindow.QuerySeq).
  
  if bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
    bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_NORMAL}.
  
  bttQueryWindow.WindowHandle:move-to-top().
  apply 'entry':U to bttQueryWindow.QueryBrowseHandle.
  
  glShowLinkedChildWindows = lShowLinkedChildWindows.
  
end. /* if available bttQueryWindow */

end procedure. /* qg_ShowQueryWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ShowRecordWindow hQueryWindow 
PROCEDURE qg_ShowRecordWindow :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Show a dialog to select a record window and bring it to front.             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phParentWindow                 = Parent window for the dialog.             */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phParentWindow as handle    no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

define buffer bttRecordWindow for temp-table ttRecordWindow.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

define query brRecordWindow
  for bttRecordWindow
  scrolling.

define browse brRecordWindow
  query brRecordWindow no-lock
    display
      bttRecordWindow.WindowTitle
      with no-assign size 96 by 16.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fSelectRecordWindow
  brRecordWindow at row 1.5 col 3
  btnOk at row 18.5 col 31
  btnCancel at row 18.5 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select record window':U
    side-labels no-underline three-d 
    size 101 by 20.44
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectRecordWindow
  apply 'end-error' to self.

on default-action of brRecordWindow in frame fSelectRecordWindow
  apply 'go':U to frame fSelectRecordWindow.

if not can-find(first ttRecordWindow) then
  leave.

run qg_InitBrowse(browse brRecordWindow:handle).

open query brRecordWindow
  for each bttRecordWindow
    no-lock
    by bttRecordWindow.WindowTitle.

if query brRecordWindow:num-results > 0 then
do:
  
  display unless-hidden
    brRecordWindow
    with frame fSelectRecordWindow
      in window phParentWindow. 
  
  brRecordWindow:select-row(1) in frame fSelectRecordWindow.
  
end. /* if query brRecordWindow:num-results > 0 */

update unless-hidden
  brRecordWindow
  btnOk
  btnCancel
  with frame fSelectRecordWindow
    in window phParentWindow.

if available bttRecordWindow
  and valid-handle(bttRecordWindow.WindowHandle) then
do:
  
  if bttRecordWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
    bttRecordWindow.WindowHandle:window-state = {&K_WINDOW_NORMAL}.
  
  bttRecordWindow.WindowHandle:move-to-top().
  apply 'entry':U to bttRecordWindow.BrowseHandle.
  
end. /* if available bttQueryWindow */

end procedure. /* qg_ShowRecordWindow */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_SubstituteChar hQueryWindow 
PROCEDURE qg_SubstituteChar :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Substitutes all occurrences of given character. Double sequential          */
/* occurrences of the character will be changed to one character.             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcString                       = Text in that the characters should be     */
/*                                  substituted.                              */
/* pcFromChar                     = Character to replace.                     */
/* pcToChar                       = Replacement character.                    */
/* opcResultString                = Result string with replaced characters.   */
/* opiNumReplacements             = Number of replaced characters.            */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input  parameter pcString           as character no-undo.
define input  parameter pcFromChar         as character no-undo.
define input  parameter pcToChar           as character no-undo.
define output parameter opcResultString    as character no-undo. 
define output parameter opiNumReplacements as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable i         as integer   no-undo.
define variable iLength   as integer   no-undo.
define variable cChar     as character no-undo.
define variable cNextChar as character no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if index(pcString, pcFromChar) = 0 then
do:
  opcResultString = pcString.
  return.
end. /* if index(pcString, pcFromChar) = 0 */

/* Replace counter. */
iLength = length(pcString).

do i = 1 to iLength:
  
  assign
    cChar     = substring(pcString, i, 1)
    cNextChar = (if i < iLength then
                   substring(pcString, i + 1, 1)
                 else
                   '':U)
    .
  
  if cChar <> pcFromChar then
    opcResultString = opcResultString + cChar.
  
  else
  do:
    
    if cNextChar <> pcFromChar then
      assign
        opcResultString    = opcResultString + pcToChar
        opiNumReplacements = opiNumReplacements + 1
        .
    
    else
      assign
        opcResultString = opcResultString + cChar
        i       = i + 1
        .
    
  end. /* if cChar <> '#':U */
  
end. /* do i = 1 to length(pcString) */

end procedure. /* qg_SubstituteChar */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateBlockName hQueryWindow 
PROCEDURE qg_UpdateBlockName :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update block name.                                                         */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  gcBufferName = (if glSlimMode then
                    substitute({&K_DEFAULT_BUFFER_PATTERN},
                               qg_cGetBufferBaseName(no))
                  else
                    input frame {&FRAME-NAME} gcBufferName)
  gcBlockName  = substitute(gcBlockPattern, gcBufferName)
  .

display unless-hidden
  gcBlockName
  with frame {&FRAME-NAME}.

run qg_ProcessBlockNameChange.

assign
  btnBlock1:tooltip in frame {&FRAME-NAME} = substitute('Use blockname &1':U,
                                                        substitute({&K_BLOCK_PATTERN_1},
                                                                   gcBufferName))
  btnBlock2:tooltip in frame {&FRAME-NAME} = substitute('Use blockname &1':U,
                                                        substitute({&K_BLOCK_PATTERN_2},
                                                                   gcBufferName))
  btnBlock3:tooltip in frame {&FRAME-NAME} = substitute('Use blockname &1':U,
                                                        substitute({&K_BLOCK_PATTERN_3},
                                                                   gcBufferName))
  btnBlock4:tooltip in frame {&FRAME-NAME} = substitute('Use blockname &1':U,
                                                        substitute({&K_BLOCK_PATTERN_4},
                                                                   gcBufferName))
  .

end procedure. /* qg_UpdateBlockName */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateBufferName hQueryWindow 
PROCEDURE qg_UpdateBufferName :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update buffer name.                                                        */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  glDefineBuffer   = (if glSlimMode then
                        {&K_DEFAULT_DEFINE_BUFFER}
                      else
                        input frame {&FRAME-NAME} glDefineBuffer)
  gcBufferBaseName = qg_cGetBufferBaseName(   glDefineBuffer
                                           or (  gcBufferPattern > '':U
                                             and gcBufferPattern <> '&1':U))
  gcBufferName     = (if gcBufferPattern > '':U then
                        substitute(gcBufferPattern, gcBufferBaseName)
                      else
                        gcBufferBaseName)
  .

display unless-hidden
  gcBufferName
  with frame {&FRAME-NAME}.

run qg_ProcessBufferNameChange.

assign
  gcBufferBaseName                          = qg_cGetBufferBaseName(yes)
  btnBuffer1:tooltip in frame {&FRAME-NAME} = substitute('Use buffername &1':U,
                                                         substitute(qg_cSubstituteChar({&K_BUFFER_PATTERN_1},
                                                                                       '#':U,
                                                                                       '':U),
                                                                    gcBufferBaseName))
  btnBuffer2:tooltip in frame {&FRAME-NAME} = substitute('Use buffername &1':U,
                                                         substitute(qg_cSubstituteChar({&K_BUFFER_PATTERN_2},
                                                                                       '#':U,
                                                                                       '':U),
                                                                    gcBufferBaseName))
  btnBuffer3:tooltip in frame {&FRAME-NAME} = substitute('Use buffername &1':U,
                                                         substitute(qg_cSubstituteChar({&K_BUFFER_PATTERN_3},
                                                                                       '#':U,
                                                                                       '':U),
                                                                    gcBufferBaseName))
  btnBuffer4:tooltip in frame {&FRAME-NAME} = substitute('Use buffername &1':U,
                                                         substitute(qg_cSubstituteChar({&K_BUFFER_PATTERN_4},
                                                                                       '#':U,
                                                                                       '':U),
                                                                    gcBufferBaseName))
  .

end procedure. /* qg_UpdateBufferName */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateDatabasePopupMenu hQueryWindow 
PROCEDURE qg_UpdateDatabasePopupMenu :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update database popup menu.                                                */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if available ttDatabase then
  assign
    menu-item mi_CopyDatabaseName:label in menu POPUP-MENU-brDatabase
        = substitute('Copy name (&1)':U, ttDatabase.DatabaseName)
    menu-item mi_CopyDatabaseName:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = yes
    menu-item mi_CopyPhysicalName:label in menu POPUP-MENU-brDatabase
        = substitute('Copy name (&1)':U, ttDatabase.PhysicalName)
    menu-item mi_CopyPhysicalName:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = yes
    menu-item mi_LoadDataDefinitions:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = ttDatabase.PhysicalDB
    menu-item mi_DataDictionary:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = ttDatabase.PhysicalDB
    menu-item mi_DataAdministration:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = ttDatabase.PhysicalDB
    .

else
  assign
    menu-item mi_CopyDatabaseName:label in menu POPUP-MENU-brDatabase
        = 'Copy name':U
    menu-item mi_CopyDatabaseName:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = no
    menu-item mi_CopyPhysicalName:label in menu POPUP-MENU-brDatabase
        = 'Copy name':U
    menu-item mi_CopyPhysicalName:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = no
    menu-item mi_LoadDataDefinitions:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = no
    menu-item mi_DataDictionary:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */
        = no
    menu-item mi_DataAdministration:sensitive in menu POPUP-MENU-brDatabase /* code checked by mth 30.07.2015 */ 
        = no
    .

end procedure. /* qg_UpdateDatabasePopupMenu */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateEditor hQueryWindow 
PROCEDURE qg_UpdateEditor :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Set selecton for given editor to given lines.                              */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* phEditor                       = Editor for which the selection should be  */
/*                                  set.                                      */
/* pcEditorText                   = Editor text.                              */
/* piFirstSelectedLine            = First line to select.                     */
/* piLastSelectedLine             = Last line to select.                      */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter phEditor            as handle    no-undo.
define input parameter pcEditorText        as character no-undo.
define input parameter piFirstSelectedLine as integer   no-undo.
define input parameter piLastSelectedLine  as integer   no-undo.

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cEditorText     as character no-undo.
define variable i               as integer   no-undo.
define variable iOffset         as integer   no-undo init 1.
define variable iLineEndOffset  as integer   no-undo.
define variable iSelectionStart as integer   no-undo.
define variable iSelectionEnd   as integer   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if    piFirstSelectedLine  > 0
  and piLastSelectedLine  >= piFirstSelectedLine then
do:
  
  do i = 1 to num-entries(pcEditorText, '~n':U):
    
    iLineEndOffset = iOffset + length(entry(i, pcEditorText, '~n':U)).
    
    if i = piFirstSelectedLine then
      iSelectionStart = iOffset.
    
    if i = piLastSelectedLine then
    do:
      
      iSelectionEnd = iLineEndOffset.
      leave.
      
    end. /* if i = iLine + iSelectedLines - 1 */
    
    iOffset = iLineEndOffset + length('~n':U).
    
  end. /* do i = 1 to num-entries(cEditorText, '~n':U) */
  
end. /* if    piFirstSelectedLine > 0 ... */

phEditor:screen-value = pcEditorText.

if    iSelectionStart > 0
  and iSelectionEnd   > 0 then
  phEditor:set-selection(iSelectionStart, iSelectionEnd).

end procedure. /* qg_UpdateEditor */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateFieldDataypeFilter hQueryWindow 
PROCEDURE qg_UpdateFieldDataypeFilter :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Update datatype filter variable according to menu items state.             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable cDatabase               as character no-undo.
define variable cTable                  as character no-undo.

define variable cDataType               as character no-undo.
define variable cDatatTypesList         as character no-undo.
define variable cSelectedDatatTypesList as character no-undo.

/* Buffers -------------------------------------------------------------------*/

define buffer bttField for temp-table ttField.

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

assign
  cDatabase           = (if available(ttDatabase) then
                           ttDatabase.DatabaseName
                         else
                           '':U)
  cTable              = (if available(ttTable) then
                           ttTable.TableName
                         else
                           '':U)
  .

for each bttField
  where bttField.DatabaseName = cDatabase
    and bttField.TableName    = cTable
  break by bttField.DataType
  on error undo, throw:
  
  if first-of(bttField.DataType) then
  do:
    
    assign
      cDataType       = substitute('&1&2':U,
                                   caps(substring(bttField.DataType, 1, 1)),
                                   lc(substring(bttField.DataType, 2)))
      cDatatTypesList = substitute('&1,&2':U,
                                   cDatatTypesList,
                                   cDataType)
      .
    
    if can-do(gcFieldDatatypeFilter, cDataType) then
      cSelectedDatatTypesList   = substitute('&1,&2':U,
                                             cSelectedDatatTypesList,
                                             cDataType).
    
  end. /* if first-of(bttField.DataType) */
  
end. /* for each bttField */

assign
  cDatatTypesList         = trim(cDatatTypesList, ',':U)
  cSelectedDatatTypesList = trim(cSelectedDatatTypesList, ',':U)
  .

run qg_SelectionDialog(cDatatTypesList,
                       input-output cSelectedDatatTypesList,
                       'Select data types':U,
                       hQueryWindow,
                       no) no-error.

gcFieldDatatypeFilter = cSelectedDatatTypesList.

run qg_RefreshFieldBrowse.
  
end procedure. /* qg_UpdateFieldDataypeFilter */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateFieldPopupMenu hQueryWindow 
PROCEDURE qg_UpdateFieldPopupMenu :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Updates the label of various menu items.                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

define variable lSessionTrigger as logical   no-undo.

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if giDisplayMode = {&K_DISPLAYMODE_FIELD} then
do:
  
  if available(ttField) then
  do:
    
    assign
      menu-item mi_CopyFieldName:label in menu POPUP-MENU-brField
          = substitute('Copy name (&1)':T, ttField.FieldName)
      menu-item mi_CopyFullFieldName:label in menu POPUP-MENU-brField
          = substitute('Copy name (&1)':T, substitute('&1.&2':U,
                                                      (if glSlimMode then
                                                         substitute({&K_DEFAULT_BUFFER_PATTERN},
                                                                    qg_cGetBufferBaseName(no))
                                                       else
                                                         input frame {&FRAME-NAME} gcBufferName),
                                                      ttField.FieldName))
      menu-item mi_SessionTriggerFieldAssign:label in menu POPUP-MENU-brField
          = (if can-find(first ttSessionTrigger
                           where ttSessionTrigger.TriggerEvent = 'assign':U
                             and ttSessionTrigger.DatabaseName = ttField.DatabaseName
                             and ttSessionTrigger.TableName    = ttField.TableName
                             and ttSessionTrigger.FieldName    = ttField.FieldName) then
               'Remove session trigger (assign)':T
             else
               'Add session trigger (assign)':T)
      menu-item mi_CopyFieldInitialValue:label in menu POPUP-MENU-brField
          = (if trim(ttField.FieldInitialValue) > '':U then
               substitute('Copy initial value (&1)':T, ttField.FieldInitialValue)
             else
               'Copy initial value':T)
      menu-item mi_CopyFieldFormat:label in menu POPUP-MENU-brField
          = substitute('Copy format (&1)':T, ttField.FieldFormat)
      menu-item mi_CopyFieldLabel:label in menu POPUP-MENU-brField
          = (if trim(ttField.FieldLabel) > '':U then
               substitute('Copy label (&1)':T, ttField.FieldLabel)
             else
               'Copy label':T)
      menu-item mi_CopyFieldColumnLabel:label in menu POPUP-MENU-brField
          = (if trim(ttField.FieldColumnLabel) > '':U then
               substitute('Copy column label (&1)':T, ttField.FieldColumnLabel)
             else
               'Copy column label':T)
      menu-item mi_CopyFieldDomain:label in menu POPUP-MENU-brField
          = (if trim(ttField.Domain) > '':U then
               substitute('Copy domain (&1)':T, ttField.Domain)
             else
               'Copy domain':T)
      .
    
  end. /* if available(ttField) */
  
  else
    assign
      menu-item mi_CopyFieldName:label             in menu POPUP-MENU-brField = 'Copy name':T
      menu-item mi_CopyFullFieldName:label         in menu POPUP-MENU-brField = 'Copy full name':T
      menu-item mi_SessionTriggerFieldAssign:label in menu POPUP-MENU-brField = 'Add session trigger (assign)':T
      menu-item mi_CopyFieldInitialValue:label     in menu POPUP-MENU-brField = 'Copy initial value':T
      menu-item mi_CopyFieldFormat:label           in menu POPUP-MENU-brField = 'Copy format':T
      menu-item mi_CopyFieldLabel:label            in menu POPUP-MENU-brField = 'Copy label':T
      menu-item mi_CopyFieldColumnLabel:label      in menu POPUP-MENU-brField = 'Copy column label':T
      menu-item mi_CopyFieldDomain:label           in menu POPUP-MENU-brField = 'Copy domain':T
      .
  
  lSessionTrigger = (     available ttDatabase
                          and not ttDatabase.TempDB
                      and available ttTable
                      and ttTable.PhysicalTable ).
  
  assign
    menu-item mi_CopyFieldName:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        =     brField:num-selected-rows in frame {&FRAME-NAME} > 0
          and available(ttField)
    menu-item mi_CopyFullFieldName:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        =     brField:num-selected-rows in frame {&FRAME-NAME} > 0
          and available(ttField)
    menu-item mi_SessionTriggerFieldAssign:sensitive in menu POPUP-MENU-brField /* code checked by mth 30.07.2015 */
        =     lSessionTrigger
          and brField:num-selected-rows > 0
          and available ttField
          and ttField.FieldExtent = 0
    menu-item mi_SessionTriggerAddFieldsAssign:sensitive in sub-menu m_SelectedFields /* code checked by mth 30.07.2015 */
        =     lSessionTrigger
          and brField:num-selected-rows > 0
    menu-item mi_SessionTriggerRemoveFieldsAssign:sensitive in sub-menu m_SelectedFields /* code checked by mth 30.07.2015 */
        =     lSessionTrigger
          and brField:num-selected-rows > 0
    menu-item mi_CopyFieldInitialValue:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        =     brField:num-selected-rows in frame {&FRAME-NAME} > 0
          and available(ttField)
          and ttField.FieldInitialValue      <> ?
          and trim(ttField.FieldInitialValue) > '':U
    menu-item mi_CopyFieldFormat:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        =     brField:num-selected-rows in frame {&FRAME-NAME} > 0
          and available(ttField)
    menu-item mi_CopyFieldLabel:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        =     brField:num-selected-rows in frame {&FRAME-NAME} > 0
          and available(ttField)
          and ttField.FieldLabel      <> ?
          and trim(ttField.FieldLabel) > '':U
    menu-item mi_CopyFieldColumnLabel:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        =     brField:num-selected-rows in frame {&FRAME-NAME} > 0
          and available(ttField)
          and ttField.FieldColumnLabel      <> ?
          and trim(ttField.FieldColumnLabel) > '':U
    menu-item mi_CopyFieldDomain:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        =     brField:num-selected-rows in frame {&FRAME-NAME} > 0
          and available(ttField)
          and ttField.Domain      <> ?
          and trim(ttField.Domain) > '':U
    sub-menu m_SelectedFields:sensitive in menu POPUP-MENU-brField /* code checked by mth */
        = brField:num-selected-rows in frame {&FRAME-NAME} > 0
    .

end. /* if giDisplayMode = {&K_DISPLAYMODE_FIELD} then */

end procedure. /* qg_UpdateFieldPopupMenu */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateIndexPopupMenu hQueryWindow 
PROCEDURE qg_UpdateIndexPopupMenu :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Updates the label of various menu items.                                   */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Buffers -------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Processing                                                                 */
/*----------------------------------------------------------------------------*/

if available(ttIndex) then
  assign
    menu-item mi_CopyIndexName:label in menu POPUP-MENU-brIndex
        = substitute('Copy name (&1)':U, ttIndex.IndexName)
    menu-item mi_CopyIndexFields:label in menu POPUP-MENU-brIndex
        = substitute('Copy fields (&1)':U, ttIndex.IndexFields)
    .

else
  assign
    menu-item mi_CopyIndexName:label in menu POPUP-MENU-brIndex
        = 'Copy name':U
    menu-item mi_CopyIndexFields:label in menu POPUP-MENU-brIndex
        = 'Copy fields':U
    .

assign
  menu-item mi_CopyIndexName:sensitive in menu POPUP-MENU-brIndex /* code checked by mth */
      =     brIndex:num-selected-rows in frame {&FRAME-NAME} > 0
        and available(ttIndex)
  menu-item mi_CopyIndexFields:sensitive in menu POPUP-MENU-brIndex /* code checked by mth */
      =     brIndex:num-selected-rows in frame {&FRAME-NAME} > 0
        and available(ttIndex)
  menu-item mi_ModifyIndexQueryFields:sensitive in menu POPUP-MENU-brIndex /* code checked by mth */
      =     brIndex:num-selected-rows in frame {&FRAME-NAME} > 0
        and available(ttIndex)
  .


end procedure. /* qg_UpdateIndexPopupMenu */

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_UpdateQueryText hQueryWindow 
PROCEDURE qg_UpdateQueryText :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Create and display query text.                                             */
/*                                                                            */
/* Notes ---------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* <none>                                                                     */
/*                                                                            */
/* Examples ------------------------------------------------------------------*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Variables -----------------------------------------------------------------*/
/*---------------------------