/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProjectPlugin;
import com.proalpha.pds.checks.CheckFilter;
import com.proalpha.pds.checks.CheckTreeViewContentProvider;
import com.proalpha.pds.checks.CheckTreeViewLabelProvider;
import com.proalpha.pds.jaxb.DsDSConsistencyChecks;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaPreference;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class CheckTreeView
extends ViewPart {
    public static final String ID = "com.proalpha.pds.checks.CheckTreeView";
    private static final String CHECK_ALL_USERS = "<ALL>";
    private static final String CHECK_EMPTY_USER = "<EMPTY>";
    private DsDSConsistencyChecks currentChecks;
    private String currentUser = "<ALL>";
    private CheckFilter filter;
    private Form form;
    private String location;
    private HashMap<String, PaProject> nameOpenEdgeProjectMap = new HashMap();
    private Combo projectViewer;
    private FormToolkit toolkit;
    private Combo userViewer;
    private TreeViewer viewer;
    private File xmlFile;

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout(3, false));
        this.toolkit.decorateFormHeading(this.form);
        Label lblNewLabel = new Label(this.form.getBody(), 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 50;
        lblNewLabel.setLayoutData((Object)gridData);
        this.toolkit.adapt((Control)lblNewLabel, true, true);
        lblNewLabel.setText("Project");
        this.projectViewer = new Combo(this.form.getBody(), 12);
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        this.projectViewer.setLayoutData((Object)gd_combo);
        this.projectViewer.setItems(this.getCurrentProjectList());
        this.projectViewer.addSelectionListener(this.projectSelectedListener());
        this.toolkit.adapt((Composite)this.projectViewer);
        this.toolkit.paintBordersFor((Composite)this.projectViewer);
        Group group = new Group(this.form.getBody(), 0);
        group.setText("Location");
        RowLayout rl_group = new RowLayout(512);
        group.setLayout((Layout)rl_group);
        GridData gd_group = new GridData(16384, 4, false, false, 1, 2);
        gd_group.verticalIndent = -7;
        group.setLayoutData((Object)gd_group);
        this.toolkit.adapt((Composite)group);
        this.toolkit.paintBordersFor((Composite)group);
        Button serverButton = new Button((Composite)group, 16);
        serverButton.setText("Server");
        serverButton.setImage(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/server_earth.png")).createImage());
        serverButton.addSelectionListener(this.locationSelectedListener());
        this.toolkit.adapt((Control)serverButton, true, true);
        Button localButton = new Button((Composite)group, 16);
        localButton.setText("Local");
        localButton.setImage(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/text_tree.png")).createImage());
        localButton.addSelectionListener(this.locationSelectedListener());
        localButton.setSelection(true);
        this.toolkit.adapt((Control)localButton, true, true);
        Label lblNewLabel_1 = new Label(this.form.getBody(), 0);
        GridData gridData2 = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData2.widthHint = 50;
        lblNewLabel_1.setLayoutData((Object)gridData2);
        this.toolkit.adapt((Control)lblNewLabel_1, true, true);
        lblNewLabel_1.setText("User");
        this.userViewer = new Combo(this.form.getBody(), 12);
        this.userViewer.setVisibleItemCount(10);
        this.userViewer.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.userViewer.addSelectionListener(this.userSelectedListener());
        this.userViewer.setText(CHECK_ALL_USERS);
        this.toolkit.adapt((Composite)this.userViewer);
        this.toolkit.paintBordersFor((Composite)this.userViewer);
        this.location = "Local";
        this.form.setText("select an installed project to show the results of the consistency checks");
        this.form.update();
        this.viewer = new TreeViewer(this.form.getBody(), 0);
        this.viewer.setContentProvider((IContentProvider)new CheckTreeViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CheckTreeViewLabelProvider());
        this.viewer.addFilter((ViewerFilter)new UserViewFilter());
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, false, true, 3, 1));
        this.filter = new CheckFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new ExpandAllAction());
        toolBarManager.add((IAction)new CollapseAllAction());
    }

    private SelectionListener projectSelectedListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                if (selectedItem != null) {
                    IAVMClient runtime;
                    String selectedProjectName = ((Combo)selectedItem.getSource()).getText();
                    PaProject selectedProject = (PaProject)CheckTreeView.this.nameOpenEdgeProjectMap.get(selectedProjectName);
                    if (selectedProject != null && (runtime = selectedProject.getOeProject().getRuntime()) != null) {
                        CheckTreeView.this.checksXmlFile(selectedProject);
                    }
                }
                if (CheckTreeView.this.xmlFile != null) {
                    CheckTreeView.this.refreshChecks();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectedItem) {
            }
        };
    }

    private SelectionListener locationSelectedListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                PaProject proj;
                if (selectedItem != null && selectedItem.widget instanceof Button && ((Button)selectedItem.widget).getSelection() && CheckTreeView.this.projectViewer.getSelectionIndex() != -1 && (proj = (PaProject)CheckTreeView.this.nameOpenEdgeProjectMap.get(CheckTreeView.this.projectViewer.getItem(CheckTreeView.this.projectViewer.getSelectionIndex()))) != null) {
                    CheckTreeView.this.location = ((Button)selectedItem.widget).getText();
                    CheckTreeView.this.checksXmlFile(proj);
                }
                CheckTreeView.this.refreshChecks();
            }

            public void widgetDefaultSelected(SelectionEvent selectedItem) {
            }
        };
    }

    private SelectionListener userSelectedListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                if (selectedItem != null) {
                    CheckTreeView.this.currentUser = ((Combo)selectedItem.getSource()).getText();
                    CheckTreeView.this.filter.setSearchUser(CheckTreeView.this.currentUser);
                    CheckTreeView.this.viewer.expandAll();
                    CheckTreeView.this.refreshTree();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
    }

    public void checksXmlFile(PaProject selectedProject) {
        IOpenEdgeProject selectedProject2 = OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(selectedProject.getOeProject().getName());
        if (selectedProject2 != null) {
            this.xmlFile = this.getXMLFile(selectedProject2);
            this.displayCheckDate();
        }
    }

    public String[] getCurrentProjectList() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        String[] projectNames = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            IAVMClient runtime;
            IProject project = projects[i];
            projectNames[i] = project.getName();
            PaProject currProj = Activator.getDefault().getProjectManager().getPaProject(OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(project));
            if (currProj != null && (runtime = currProj.getOeProject().getRuntime()) != null) {
                this.nameOpenEdgeProjectMap.put(project.getName(), currProj);
            }
            ++i;
        }
        return projectNames;
    }

    public String[] getUsers() {
        TreeSet<String> users = new TreeSet<String>();
        List<DsDSConsistencyChecks.TtDSCheck> filteredList = this.currentChecks.getTtDSCheck();
        for (DsDSConsistencyChecks.TtDSCheck check : filteredList) {
            List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck> filteredCheck = check.getTtDSSubCheck();
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck filteredSubCheck : filteredCheck) {
                List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos> filteredRepoEntries;
                List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> filteredSrcEntries = filteredSubCheck.getTtDSLogEntrySrc();
                if (!filteredSrcEntries.isEmpty()) {
                    for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc filteredSrcEntry : filteredSrcEntries) {
                        if (filteredSrcEntry.getLastUser() == null || filteredSrcEntry.getLastUser().isEmpty()) continue;
                        users.add(filteredSrcEntry.getLastUser());
                    }
                }
                if ((filteredRepoEntries = filteredSubCheck.getTtDSLogEntryRepos()).isEmpty()) continue;
                for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos filteredRepoEntry : filteredRepoEntries) {
                    if (filteredRepoEntry.getLastUser() == null || filteredRepoEntry.getLastUser().isEmpty()) continue;
                    users.add(filteredRepoEntry.getLastUser());
                }
            }
        }
        users.add(CHECK_ALL_USERS);
        users.add(CHECK_EMPTY_USER);
        return (String[])users.stream().toArray(String[]::new);
    }

    private void displayCheckDate() {
        if (this.xmlFile != null && this.xmlFile.exists() && this.projectViewer.getSelectionIndex() != -1) {
            Date date = new Date();
            date.setTime(this.xmlFile.lastModified());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            String heading = MessageFormat.format("{0} ({1})", this.location, dateFormat.format(calendar.getTime()));
            this.form.setText(heading);
            this.form.update();
        }
    }

    private void refreshChecks() {
        if (this.xmlFile != null && this.xmlFile.exists()) {
            Unmarshaller unmarshaller = null;
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DsDSConsistencyChecks.class});
                unmarshaller = context.createUnmarshaller();
                if (unmarshaller != null) {
                    this.currentChecks = (DsDSConsistencyChecks)unmarshaller.unmarshal(this.xmlFile);
                }
            }
            catch (JAXBException e) {
                throw new IllegalStateException(e);
            }
            this.userViewer.setItems(this.getUsers());
            this.refreshTree();
        }
    }

    private void refreshTree() {
        Object[] expandedElements = null;
        List<DsDSConsistencyChecks.TtDSCheck> filteredList = this.currentChecks.getTtDSCheck();
        expandedElements = this.viewer.getExpandedElements();
        this.viewer.setInput(filteredList);
        this.viewer.refresh(true);
        if (expandedElements != null) {
            this.viewer.setExpandedElements(expandedElements);
        }
    }

    public void showBusy(boolean busy) {
        Cursor systemCursor = busy ? Display.getCurrent().getSystemCursor(1) : Display.getCurrent().getSystemCursor(0);
        this.viewer.getTree().setCursor(systemCursor);
    }

    public HashMap<String, PaProject> getProjectMap() {
        return this.nameOpenEdgeProjectMap;
    }

    public String getSelectedProject() {
        return this.projectViewer.getText();
    }

    public void setSelectedProject(PaProject paProject) {
        this.projectViewer.select(this.projectViewer.indexOf(paProject.getOeProject().getProject().getName()));
        this.checksXmlFile(paProject);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.refreshChecks();
        this.viewer.refresh(true);
    }

    public void setFocus() {
    }

    private File getXMLFile(IOpenEdgeProject currProj) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(currProj.getName());
        IPath pathToXMLFile = null;
        String fileName = "ConsistencyCheck.xml";
        if (this.location.equals("Local")) {
            if (currProj.getRuntime().getConfiguration() != null) {
                pathToXMLFile = currProj.getRuntime().getConfiguration().getTempDirectory();
            }
        } else {
            PaProject paProject = Activator.getDefault().getProjectManager().getPaProject(proj);
            List prefs = paProject.loadPaPrefs();
            for (PaPreference paPreference : prefs) {
                if (!paPreference.getKey().equals("ConsistencyChecksLocation")) continue;
                pathToXMLFile = new Path(paPreference.getValue());
            }
        }
        File resultFile = null;
        resultFile = pathToXMLFile != null ? pathToXMLFile.append(fileName).toFile() : new File("");
        return resultFile;
    }

    public class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/collapse_all.png")));
            this.setToolTipText("Collapse all");
        }

        public void run() {
            CheckTreeView.this.viewer.collapseAll();
        }
    }

    public class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/expand_all.gif")));
            this.setToolTipText("Expand all");
        }

        public void run() {
            CheckTreeView.this.viewer.expandAll();
        }
    }

    class UserViewFilter
    extends ViewerFilter {
        UserViewFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof DsDSConsistencyChecks.TtDSCheck) {
                List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck> subChecks = ((DsDSConsistencyChecks.TtDSCheck)element).getTtDSSubCheck();
                return !subChecks.isEmpty();
            }
            return true;
        }
    }
}

