/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.proalpha.pds.checks.CheckFilter;
import com.proalpha.pds.checks.CheckTreeView;
import com.proalpha.pds.checks.ConsistencyChecksImageProvider;
import com.proalpha.pds.checks.jaxb.DsDSConsistencyChecks;
import com.proalpha.pds.checks.util.AddToCodeCheckedBy;
import com.proalpha.pds.checks.util.SendCheckInfoEmail;
import java.io.File;
import java.net.URL;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SubCheckView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "com.proalpha.pds.checks.SubCheckView";
    private FormToolkit toolkit;
    private Form form;
    private Text lastUser;
    private Text reported;
    private Text objectID;
    private Text line;
    private Text module;
    private Text description;
    private TableViewer viewer;
    private Text codeFragment;
    private Hyperlink backgroundInfoUrl;
    private ConsistencyChecksImageProvider imageProvider = new ConsistencyChecksImageProvider();
    private String selectedProjectName;
    private CheckFilter filter;
    private Image mailImage;
    private Image codecheckedbyImage;

    public void dispose() {
        if (this.mailImage != null) {
            this.mailImage.dispose();
        }
        if (this.codecheckedbyImage != null) {
            this.codecheckedbyImage.dispose();
        }
        super.dispose();
    }

    private void clearDetailSection() {
        this.setLastUser("");
        this.setReported("");
        this.setObjectID("");
        this.setLine("");
        this.setModule("");
        this.setDescription("");
        this.setCodeFragment("");
        this.backgroundInfoUrl.setText("");
    }

    private void clearTableSection() {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().removeAll();
            this.viewer.setInput(null);
            this.viewer.refresh(true);
            this.setPartName("Consistency Subchecks");
            this.setTitleImage(this.imageProvider.getDefaultImage());
        }
    }

    private void createDetailSection() {
        Section sectionDetails = this.toolkit.createSection(this.form.getBody(), 258);
        sectionDetails.setText("Details");
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        sectionDetails.setLayout((Layout)layout);
        sectionDetails.setLayoutData((Object)new GridData(768));
        sectionDetails.setExpanded(true);
        Composite compositeDetails = this.toolkit.createComposite((Composite)sectionDetails);
        compositeDetails.setLayout((Layout)layout);
        sectionDetails.setClient((Control)compositeDetails);
        this.toolkit.createLabel(compositeDetails, "Last User");
        this.toolkit.createLabel(compositeDetails, "Reported");
        this.toolkit.createLabel(compositeDetails, "Line");
        this.toolkit.createLabel(compositeDetails, "Module");
        this.lastUser = this.toolkit.createText(compositeDetails, "");
        this.lastUser.setLayoutData((Object)new GridData(768));
        this.reported = this.toolkit.createText(compositeDetails, "");
        this.reported.setLayoutData((Object)new GridData(768));
        this.line = this.toolkit.createText(compositeDetails, "");
        this.line.setLayoutData((Object)new GridData(768));
        this.module = this.toolkit.createText(compositeDetails, "");
        this.module.setLayoutData((Object)new GridData(768));
        this.toolkit.createLabel(compositeDetails, "URL");
        this.toolkit.createLabel(compositeDetails, "");
        this.toolkit.createLabel(compositeDetails, "");
        this.toolkit.createLabel(compositeDetails, "");
        this.backgroundInfoUrl = this.toolkit.createHyperlink(compositeDetails, "", 66);
        this.backgroundInfoUrl.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent arg0) {
            }

            public void linkEntered(HyperlinkEvent arg0) {
            }

            public void linkActivated(HyperlinkEvent event) {
                if (!event.getLabel().isEmpty()) {
                    Program.launch((String)event.getLabel());
                }
            }
        });
        GridData urlGridData = new GridData(1808);
        urlGridData.horizontalSpan = 4;
        this.backgroundInfoUrl.setLayoutData((Object)urlGridData);
        this.toolkit.createLabel(compositeDetails, "Object");
        this.toolkit.createLabel(compositeDetails, "Description");
        this.toolkit.createLabel(compositeDetails, "Code Fragment");
        this.toolkit.createLabel(compositeDetails, "");
        this.objectID = this.toolkit.createText(compositeDetails, "", 66);
        GridData objectIDData = new GridData();
        objectIDData.horizontalSpan = 1;
        objectIDData.heightHint = 100;
        objectIDData.widthHint = 100;
        objectIDData.horizontalAlignment = 4;
        this.objectID.setLayoutData((Object)objectIDData);
        GridData descData = new GridData();
        descData.horizontalSpan = 1;
        descData.heightHint = 100;
        descData.horizontalAlignment = 4;
        this.description = this.toolkit.createText(compositeDetails, "", 578);
        this.description.setLayoutData((Object)descData);
        this.codeFragment = this.toolkit.createText(compositeDetails, "", 514);
        GridData codeFragmentData = new GridData();
        codeFragmentData.horizontalSpan = 2;
        codeFragmentData.heightHint = 100;
        codeFragmentData.horizontalAlignment = 4;
        this.codeFragment.setLayoutData((Object)codeFragmentData);
        this.codeFragment.setFont(JFaceResources.getFont((String)"Courier New"));
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        GridLayout formLayout = new GridLayout();
        formLayout.numColumns = 1;
        this.form.getBody().setLayout((Layout)formLayout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.update(true);
        this.createTableSection();
        this.createDetailSection();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void createTableSection() {
        Section tableSection = this.toolkit.createSection(this.form.getBody(), 4096);
        tableSection.setExpanded(true);
        tableSection.setLayout((Layout)new GridLayout());
        GridData sectionTableData = new GridData(1808);
        sectionTableData.minimumHeight = 100;
        tableSection.setLayoutData((Object)sectionTableData);
        Composite compositeTable = this.toolkit.createComposite((Composite)tableSection);
        compositeTable.setLayout((Layout)new GridLayout());
        compositeTable.setLayoutData((Object)new GridData(1808));
        tableSection.setClient((Control)compositeTable);
        this.viewer = new TableViewer(compositeTable, 66306);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)data);
        this.configureTable(table);
        table.addListener(3, event -> {
            TableItem item = table.getItem(new Point(event.x, event.y));
            if (item == null) {
                table.deselectAll();
                this.clearDetailSection();
            }
        });
        this.addContextMenu(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addDoubleClickListener(event -> {
            IProject selectedProject;
            TableViewer source = (TableViewer)event.getSource();
            IStructuredSelection selection = (IStructuredSelection)source.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc && this.selectedProjectName != null && (selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.selectedProjectName)) != null) {
                File projectFile = selectedProject.getRawLocation().makeAbsolute().toFile();
                String sourceFileName = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)firstElement).getSourceFileName();
                File fileToOpen = this.searchFile(new File(projectFile.toPath().toAbsolutePath() + "\\src"), sourceFileName);
                if (fileToOpen != null && fileToOpen.isFile()) {
                    int lineToJump = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)firstElement).getSourceFileLine() - 1;
                    this.openFileInEditor(lineToJump, fileToOpen);
                }
            }
        });
        this.viewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.updateDetailSection(((IStructuredSelection)selection).getFirstElement());
            }
        });
        this.filter = new CheckFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
    }

    private void openFileInEditor(int lineToJump, File fileToOpen) {
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            if (editor instanceof ITextEditor) {
                IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
                IDocument document = provider.getDocument((Object)editor.getEditorInput());
                int start = 0;
                if (lineToJump < 0) {
                    lineToJump = 0;
                }
                start = document.getLineOffset(lineToJump);
                ((ITextEditor)editor).selectAndReveal(start, 0);
            }
        }
        catch (BadLocationException | PartInitException e) {
            e.printStackTrace();
        }
    }

    private MenuItem addContextMenu(Table table) {
        Menu tableContextMenu = new Menu((Control)table);
        table.setMenu(tableContextMenu);
        MenuItem sendAsMailMenuItem = new MenuItem(tableContextMenu, 0);
        sendAsMailMenuItem.setText("Send as Mail");
        this.mailImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/mail.png")).createImage();
        sendAsMailMenuItem.setImage(this.mailImage);
        MenuItem addToCodeCheckedBy = new MenuItem(tableContextMenu, 0);
        addToCodeCheckedBy.setText("Add to codecheckedby.xml");
        this.codecheckedbyImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/bug_green.png")).createImage();
        addToCodeCheckedBy.setImage(this.codecheckedbyImage);
        sendAsMailMenuItem.addListener(13, event -> {
            SendCheckInfoEmail mail = new SendCheckInfoEmail();
            mail.send(this.viewer.getSelection(), this.selectedProjectName != null ? this.selectedProjectName : "Unknown project");
        });
        addToCodeCheckedBy.addListener(13, event -> {
            AddToCodeCheckedBy addToCCB = new AddToCodeCheckedBy();
            addToCCB.add(this.viewer.getSelection(), this.selectedProjectName);
        });
        table.addListener(35, event -> {
            if (table.getSelectionCount() <= 0) {
                event.doit = false;
            } else {
                for (Object object : (IStructuredSelection)this.viewer.getSelection()) {
                    if (object instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                        addToCodeCheckedBy.setEnabled(true);
                        break;
                    }
                    addToCodeCheckedBy.setEnabled(false);
                }
            }
        });
        return addToCodeCheckedBy;
    }

    private File searchFile(File file, String search) {
        if (file.isDirectory()) {
            File[] arr;
            File[] fileArray = arr = file.listFiles();
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                File found = this.searchFile(f, search);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        } else if (file.getName().equals(search)) {
            return file;
        }
        return null;
    }

    private void configureTable(Table table) {
        this.createLastUserColum(table);
        this.createReportedColumn(table);
        this.createObjectColumn(table);
        this.createLineColumn(table);
        this.createModuleColumn(table);
        this.createDescriptionColumn(table);
    }

    private void createObjectColumn(Table table) {
        TableColumn objectColumn = this.createTableColumn(table, "Object");
        TableViewerColumn objectViewerColumn = new TableViewerColumn(this.viewer, objectColumn);
        objectViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getSourceFileName();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getOwningID();
                }
                return resultText;
            }
        });
        objectColumn.addListener(13, this.createSortListener(table));
    }

    private void createLineColumn(Table table) {
        TableColumn lineColumn = this.createTableColumn(table, "Line");
        TableViewerColumn lineViewerColumn = new TableViewerColumn(this.viewer, lineColumn);
        lineViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = String.valueOf(((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getSourceFileLine());
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = "";
                }
                return resultText;
            }
        });
        lineColumn.addListener(13, this.createSortIntListener(table));
    }

    private void createModuleColumn(Table table) {
        TableColumn moduleColumn = this.createTableColumn(table, "Module");
        TableViewerColumn moduleViewerColumn = new TableViewerColumn(this.viewer, moduleColumn);
        moduleViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getModule();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getModule();
                }
                return resultText;
            }
        });
        moduleColumn.addListener(13, this.createSortListener(table));
    }

    private void createDescriptionColumn(Table table) {
        TableColumn descriptionColumn = this.createTableColumn(table, "Description");
        TableViewerColumn descriptionViewerColumn = new TableViewerColumn(this.viewer, descriptionColumn);
        descriptionViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getLogEntryDescription();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getLogEntryDescription();
                }
                return resultText;
            }
        });
        descriptionColumn.addListener(13, this.createSortListener(table));
    }

    private void createReportedColumn(Table table) {
        TableColumn reportedColumn = this.createTableColumn(table, "Reported");
        TableViewerColumn reportedViewerColumn = new TableViewerColumn(this.viewer, reportedColumn);
        reportedViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                GregorianCalendar calendar = null;
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    calendar = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getReportedFirst().toGregorianCalendar();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    calendar = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getReportedFirst().toGregorianCalendar();
                }
                if (calendar != null) {
                    dateFormat.setTimeZone(calendar.getTimeZone());
                    resultText = dateFormat.format(calendar.getTime());
                }
                return resultText;
            }
        });
        reportedColumn.addListener(13, this.createSortDateListener(table));
    }

    private void createLastUserColum(Table table) {
        TableColumn lastUserColumn = this.createTableColumn(table, "Last User");
        TableViewerColumn lastUserViewerColumn = new TableViewerColumn(this.viewer, lastUserColumn);
        lastUserViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getLastUser();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getLastUser();
                }
                return resultText;
            }
        });
        lastUserColumn.addListener(13, this.createSortListener(table));
    }

    private Listener createSortListener(final Table table) {
        return new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                TableColumn column = (TableColumn)e.widget;
                int direction = SubCheckView.this.getSortDirection(table, column);
                int index = this.getColumnIndex(table, column);
                if (index >= 0) {
                    Collator collator = Collator.getInstance(Locale.getDefault());
                    int i = 0;
                    while (i < items.length) {
                        String value1 = items[i].getText(index);
                        int j = 0;
                        while (j < i) {
                            String value2 = items[j].getText(index);
                            if (collator.compare(value1, value2) * direction <= 0) {
                                String[] itemValues = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5)};
                                Object itemData = items[i].getData();
                                items[i].dispose();
                                TableItem item = new TableItem(table, 0, j);
                                item.setText(itemValues);
                                item.setData(itemData);
                                items = table.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }

            private int getColumnIndex(Table table2, TableColumn column) {
                int index = 0;
                TableColumn[] tableColumnArray = table2.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnArray[n2];
                    if (tableColumn.getText().equals(column.getText())) {
                        return index;
                    }
                    ++index;
                    ++n2;
                }
                return -1;
            }
        };
    }

    private Listener createSortDateListener(final Table table) {
        return new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                TableColumn column = (TableColumn)e.widget;
                int direction = SubCheckView.this.getSortDirection(table, column);
                int index = table.indexOf(column);
                if (index >= 0) {
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    int i = 0;
                    while (i < items.length) {
                        Date value1;
                        try {
                            value1 = dateFormatter.parse(items[i].getText(index));
                        }
                        catch (ParseException e1) {
                            value1 = new Date();
                        }
                        int j = 0;
                        while (j < i) {
                            Date value2;
                            try {
                                value2 = dateFormatter.parse(items[j].getText(index));
                            }
                            catch (ParseException e1) {
                                value2 = new Date();
                            }
                            if (value1.compareTo(value2) * direction <= 0) {
                                String[] itemValues = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5)};
                                Object itemData = items[i].getData();
                                items[i].dispose();
                                TableItem item = new TableItem(table, 0, j);
                                item.setText(itemValues);
                                item.setData(itemData);
                                items = table.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        };
    }

    private Listener createSortIntListener(final Table table) {
        return new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                TableColumn column = (TableColumn)e.widget;
                int direction = SubCheckView.this.getSortDirection(table, column);
                int index = table.indexOf(column);
                if (index >= 0) {
                    int i = 0;
                    while (i < items.length) {
                        int value1 = Integer.parseInt(items[i].getText(index));
                        int j = 0;
                        while (j < i) {
                            int value2 = Integer.parseInt(items[j].getText(index));
                            if (Integer.compare(value1, value2) * direction <= 0) {
                                String[] itemValues = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5)};
                                Object itemData = items[i].getData();
                                items[i].dispose();
                                TableItem item = new TableItem(table, 0, j);
                                item.setText(itemValues);
                                item.setData(itemData);
                                items = table.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        };
    }

    private int getSortDirection(Table table, TableColumn column) {
        table.setSortColumn(column);
        int direction = table.getSortDirection();
        if (direction == 128) {
            table.setSortDirection(1024);
            direction = -1;
        } else if (direction == 1024) {
            table.setSortDirection(0);
            direction = 0;
        } else {
            table.setSortDirection(128);
            direction = 1;
        }
        return direction;
    }

    private TableColumn createTableColumn(Table table, String header) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(header);
        column.setWidth(100);
        column.setResizable(true);
        return column;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != null && selection != null) {
            if (!(part instanceof CheckTreeView) || this.viewer.getTable().isDisposed()) {
                IStructuredSelection structuredSelection;
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() > 1) {
                    this.clearDetailSection();
                }
                return;
            }
            this.clearDetailSection();
            this.clearTableSection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection;
                Object firstSelectedElement;
                if (part instanceof CheckTreeView) {
                    this.selectedProjectName = ((CheckTreeView)part).getSelectedProject();
                    this.filter.setSearchFilter(((CheckTreeView)part).getCurrentTeam(), ((CheckTreeView)part).getCurrentModule(), ((CheckTreeView)part).getCurrentShowCommonModulesStatus());
                }
                if ((firstSelectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck) {
                    this.updateTableSection((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck)firstSelectedElement);
                } else if (firstSelectedElement instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc || firstSelectedElement instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    this.updateDetailSection(firstSelectedElement);
                }
            }
        }
    }

    private void updateTableSection(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subcheck) {
        Boolean hasInput = Boolean.FALSE;
        Object viewerInput = null;
        if (!subcheck.getTtDSLogEntrySrc().isEmpty()) {
            viewerInput = subcheck.getTtDSLogEntrySrc().toArray();
            hasInput = Boolean.TRUE;
        } else if (!subcheck.getTtDSLogEntryRepos().isEmpty()) {
            viewerInput = subcheck.getTtDSLogEntryRepos();
            hasInput = Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(hasInput)) {
            this.viewer.getTable().removeAll();
            this.viewer.setInput(viewerInput);
            this.viewer.refresh(true);
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
            this.setUrl(subcheck.getBackgroundInfoURL());
            this.setPartName(subcheck.getDSSubCheckID());
            this.setTitleImage(this.imageProvider.getImage(subcheck));
        }
    }

    private void setUrl(String url) {
        this.backgroundInfoUrl.setText(url != null ? url : "");
    }

    private void setDescription(String text) {
        this.description.setText(text != null ? text : "");
    }

    public void setFocus() {
    }

    private void setLastUser(String text) {
        this.lastUser.setText(text != null ? text : "");
    }

    private void setLine(String text) {
        this.line.setText(text != null ? text : "");
    }

    private void setCodeFragment(String text) {
        this.codeFragment.setText(text != null ? text : "");
    }

    private void setModule(String text) {
        this.module.setText(text != null ? text : "");
    }

    private void setLogEntryReposDetails(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos entryRepos) {
        this.setLastUser(entryRepos.getLastUser());
        this.setReported(entryRepos.getReportedFirst());
        this.setObjectID(entryRepos.getOwningID().replace(", ", ",\n"));
        this.setLine("");
        this.setModule(entryRepos.getModule());
        this.setDescription(entryRepos.getLogEntryDescription());
        this.setCodeFragment("");
    }

    private void setLogEntrySrcDetails(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc entrySrc) {
        this.setLastUser(entrySrc.getLastUser());
        this.setReported(entrySrc.getReportedFirst());
        this.setObjectID(entrySrc.getSourceFileName());
        this.setLine(String.valueOf(entrySrc.getSourceFileLine()));
        this.setModule(entrySrc.getModule());
        this.setDescription(entrySrc.getLogEntryDescription());
        this.setCodeFragment(entrySrc.getStatement());
    }

    private void setObjectID(String text) {
        this.objectID.setText(text != null ? text : "");
    }

    private void setReported(String text) {
        this.reported.setText(text != null ? text : "");
    }

    private void setReported(XMLGregorianCalendar calendar) {
        if (calendar != null) {
            this.setReported(String.valueOf(calendar.getDay()) + "." + calendar.getMonth() + "." + calendar.getYear());
        } else {
            this.setReported("");
        }
    }

    private void updateDetailSection(Object entry) {
        if (entry instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
            this.setLogEntrySrcDetails((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)entry);
        } else if (entry instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
            this.setLogEntryReposDetails((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)entry);
        } else {
            this.clearDetailSection();
        }
    }
}

