/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchOperation;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBranchJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(FeatureBranchJob.class);
    private final FeatureBranchOperation op;

    public FeatureBranchJob(FeatureBranchOperation op) {
        super("Feature branch creation/checkout job");
        this.op = op;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.op.setProgressMonitor(monitor);
            this.op.execute();
            this.showResultDialog();
        }
        catch (InvocationTargetException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)e.getCause().getMessage(), (String)e.getCause().getLocalizedMessage());
                }
            });
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHECKOUT.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void showResultDialog() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String text = FeatureBranchJob.this.op == null ? "Something wicked happened: There is no result of the job" : (FeatureBranchJob.this.op.getResult().getStatus() == CheckoutResult.Status.OK ? "Branch " + FeatureBranchJob.this.op.getSettings().getTargetBranch() + " was successfully checked out" : "Error while creating/checking out branch " + FeatureBranchJob.this.op.getSettings().getTargetBranch());
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Feature branch activation", (String)text);
            }
        });
    }
}

