/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskActionListener
extends TaskActivationAdapter {
    private final Logger logger = LoggerFactory.getLogger(TaskActionListener.class);
    private WizardDialog wiz;
    FeatureBranchWizard fbw = null;
    private boolean firstStart = true;

    public void taskActivated(ITask task) {
        String taskId = task.getTaskKey();
        this.logger.debug("Task {} activated", (Object)taskId);
        if (!task.getConnectorKind().equals("jira")) {
            this.logger.debug("Task {} is not handled by JIRA. The feature branch wizard is skipped", (Object)taskId);
            return;
        }
        if (this.firstStart) {
            this.firstStart = false;
            return;
        }
        this.fbw = new FeatureBranchWizard(task);
        this.wiz = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.fbw);
        this.wiz.open();
    }

    public void taskDeactivated(ITask task) {
    }
}

