/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAndBinaryOperation {
    private final Logger logger = LoggerFactory.getLogger(DbAndBinaryOperation.class);
    private Repository repository;
    private String errMessage = new String();
    private int callExitValue;
    private SubMonitor monitor;

    public DbAndBinaryOperation(Repository repository) {
        this.repository = repository;
    }

    public void execute() throws InvocationTargetException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DbAndBinaryOperation.this.monitor.setWorkRemaining(3).worked(1);
                String GitDir = DbAndBinaryOperation.this.repository.getDirectory().getAbsolutePath();
                String parentDir = GitDir.substring(0, GitDir.lastIndexOf(File.separator));
                try {
                    try {
                        String line;
                        ProcessBuilder builder = new ProcessBuilder("python", "-u", "-m", "pa_update", "-a", "-s", "loadDiffInDB", "-t", parentDir, "-e", "dev");
                        builder.directory(new File(parentDir));
                        builder.redirectErrorStream(true);
                        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
                        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
                        Process p = builder.start();
                        DbAndBinaryOperation.this.logger.info("Start reconcile: Running '" + builder.command() + "' in " + parentDir);
                        Throwable throwable = null;
                        Throwable throwable2 = null;
                        try (InputStreamReader rOut = new InputStreamReader(p.getInputStream());){
                            BufferedReader inOut = new BufferedReader(rOut);
                            while ((line = inOut.readLine()) != null) {
                                DbAndBinaryOperation.this.logger.info(line);
                                int indexOfFourthSpace = StringUtils.ordinalIndexOf((String)line, (String)" ", (int)4);
                                if (indexOfFourthSpace <= -1) continue;
                                DbAndBinaryOperation.this.monitor.setTaskName(line.substring(indexOfFourthSpace));
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        DbAndBinaryOperation.this.monitor.worked(1);
                        DbAndBinaryOperation.this.callExitValue = p.waitFor();
                        if (DbAndBinaryOperation.this.callExitValue > 0) {
                            InputStreamReader rErr = new InputStreamReader(p.getErrorStream());
                            throwable2 = null;
                            Object var7_12 = null;
                            try (BufferedReader inErr = new BufferedReader(rErr);){
                                while ((line = inErr.readLine()) != null) {
                                    DbAndBinaryOperation.this.errMessage = DbAndBinaryOperation.this.errMessage.concat(line);
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                            DbAndBinaryOperation.this.logger.error("Error while running python package pa_update with exitcode {0} and {1}", (Object)DbAndBinaryOperation.this.callExitValue, (Object)DbAndBinaryOperation.this.errMessage);
                        }
                        DbAndBinaryOperation.this.monitor.worked(1);
                    }
                    catch (IOException e) {
                        DbAndBinaryOperation.this.callExitValue = 1;
                        DbAndBinaryOperation.this.errMessage = e.getMessage();
                        DbAndBinaryOperation.this.logger.error("Exception while running python package pa_update with exitcode {0} and {1}", (Object)DbAndBinaryOperation.this.callExitValue, (Object)e.getMessage());
                        DbAndBinaryOperation.this.monitor.done();
                    }
                    catch (InterruptedException e) {
                        DbAndBinaryOperation.this.logger.error("Error {} occured", (Throwable)e);
                        DbAndBinaryOperation.this.monitor.done();
                    }
                }
                finally {
                    DbAndBinaryOperation.this.monitor.done();
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
    }

    public void setProgressMonitor(SubMonitor monitor) {
        this.monitor = monitor;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public void setErrMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    public int getCallExitValue() {
        return this.callExitValue;
    }

    public void setCallExitValue(int callExitValue) {
        this.callExitValue = callExitValue;
    }
}

