/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchOperation;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBranchJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(FeatureBranchJob.class);
    private final FeatureBranchOperation operation;

    public FeatureBranchJob(FeatureBranchOperation operation) {
        super("Feature branch creation/checkout job");
        this.operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.operation.setProgressMonitor(monitor);
            this.operation.execute();
            this.showResultDialog();
        }
        catch (InvocationTargetException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)e.getCause().getMessage(), (String)e.getCause().getLocalizedMessage());
                }
            });
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHECKOUT.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void showResultDialog() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String text;
                if (FeatureBranchJob.this.operation == null) {
                    FeatureBranchJob.this.logger.error("Something wicked happened: There is no result of the job");
                    text = "Something wicked happened: There is no result of the job";
                } else {
                    CheckoutResult operationResult = FeatureBranchJob.this.operation.getResult();
                    if (operationResult != null && operationResult.getStatus() == CheckoutResult.Status.OK) {
                        FeatureBranchJob.this.logger.info("Branch {0} was successfully checked out", (Object)FeatureBranchJob.this.operation.getSettings().getTargetBranch());
                        text = String.format("Branch {0} was successfully checked out", FeatureBranchJob.this.operation.getSettings().getTargetBranch());
                    } else {
                        FeatureBranchJob.this.logger.error("Error while creating/checking out branch {0}", (Object)FeatureBranchJob.this.operation.getSettings().getTargetBranch());
                        text = String.format("Error while creating/checking out branch {0}", FeatureBranchJob.this.operation.getSettings().getTargetBranch());
                    }
                }
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Feature branch activation", (String)text);
            }
        });
    }
}

