/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.git.PaGit;
import com.proalpha.pds.gitutils.common.CheckoutOperation;
import com.proalpha.pds.gitutils.external.DbAndBinaryJob;
import com.proalpha.pds.gitutils.external.DbAndBinaryOperation;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBranchOperation {
    private final Logger logger = LoggerFactory.getLogger(FeatureBranchOperation.class);
    private FeatureBranchSettings settings;
    private IProgressMonitor monitor;
    private CheckoutOperation coOp;
    private DbAndBinaryOperation updateDbBinaryOp;

    public FeatureBranchSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FeatureBranchSettings settings) {
        this.settings = settings;
    }

    public FeatureBranchOperation(FeatureBranchSettings settings) {
        this.settings = settings;
        PaGit.init((Git)new Git(settings.getRepository()));
    }

    public void execute() throws InvocationTargetException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)FeatureBranchOperation.this.monitor, (String)"pA feature branch creation", (int)3);
                    PaGit.getInstance().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMonitor.newChild(1)));
                    FeatureBranchOperation.this.coOp = new CheckoutOperation(FeatureBranchOperation.this.settings.getRepository(), "origin", FeatureBranchOperation.this.settings.getSourceBranch(), FeatureBranchOperation.this.settings.getTargetBranch(), FeatureBranchOperation.this.settings.isUpdateSourceBranch(), FeatureBranchOperation.this.settings.isUpdateTargetBranch());
                    FeatureBranchOperation.this.coOp.setProgressMonitor(FeatureBranchOperation.this.monitor);
                    FeatureBranchOperation.this.coOp.run();
                    if (FeatureBranchOperation.this.settings.isUpdateDbAndArtifacts()) {
                        SubMonitor subMonitorArtifacts = SubMonitor.convert((IProgressMonitor)FeatureBranchOperation.this.monitor, (String)"database reconcile and artifact update", (int)1);
                        FeatureBranchOperation.this.updateDbBinaryOp = new DbAndBinaryOperation(FeatureBranchOperation.this.settings.getRepository());
                        FeatureBranchOperation.this.updateDbBinaryOp.setProgressMonitor(subMonitorArtifacts);
                        FeatureBranchOperation.this.updateDbBinaryOp.execute();
                    }
                }
                catch (InvocationTargetException e) {
                    FeatureBranchOperation.this.logger.error("An error {0} occured", (Throwable)e);
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
    }

    public ISchedulingRule getSchedulingRule() {
        if (this.settings != null) {
            return RuleUtil.getRule((Repository)this.settings.getRepository());
        }
        return null;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public CheckoutResult getResult() {
        if (this.coOp != null) {
            if (this.updateDbBinaryOp != null && this.updateDbBinaryOp.getCallExitValue() != 0) {
                DbAndBinaryJob.showResultDialog(this.updateDbBinaryOp);
            } else {
                return this.coOp.getResult();
            }
        }
        return null;
    }
}

