/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRepositoryPage
extends WizardPage {
    private final Logger logger = LoggerFactory.getLogger(SelectRepositoryPage.class);
    private FeatureBranchSettings settings;

    public SelectRepositoryPage(FeatureBranchSettings settings) {
        super(SelectRepositoryPage.class.getName());
        this.settings = settings;
        this.setTitle("Repository Selection");
        this.setMessage("Select a local repository, where the feature branch will be created", 1);
        this.setDescription("Desc Select the repository");
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group repositoryGroup = new Group(container, 0);
        repositoryGroup.setText("Repositories");
        repositoryGroup.setBackgroundMode(1);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)repositoryGroup);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)repositoryGroup);
        final CheckboxTableViewer repositoryViewer = CheckboxTableViewer.newCheckList((Composite)repositoryGroup, (int)2820);
        repositoryViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RepositoriesViewLabelProvider()));
        repositoryViewer.setContentProvider((IContentProvider)new RepositoriesViewContentProvider());
        repositoryViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        repositoryViewer.addCheckStateListener(new ICheckStateListener(){
            private boolean clean;

            public void checkStateChanged(CheckStateChangedEvent event) {
                this.clean = true;
                if (event.getChecked()) {
                    Repository rep = ((RepositoryNode)event.getElement()).getRepository();
                    repositoryViewer.setAllChecked(false);
                    repositoryViewer.setChecked(event.getElement(), true);
                    try {
                        Throwable throwable = null;
                        Object var4_7 = null;
                        try (final Git git = new Git(rep);){
                            SelectRepositoryPage.this.setMessage("Check repository status...", 1);
                            SelectRepositoryPage.this.getContainer().run(true, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) {
                                    try {
                                        clean = git.status().call().getUncommittedChanges().isEmpty();
                                    }
                                    catch (GitAPIException | NoWorkTreeException e) {
                                        SelectRepositoryPage.this.logger.error("Error while trying to get the state of the repository", e);
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (!this.clean) {
                        MessageDialog.openError((Shell)SelectRepositoryPage.this.getShell(), (String)"Dirty workspace", (String)"The workspace of this repository is dirty. You have to commit, stash, or undo your changes before you can create a new branch in this repository.");
                        SelectRepositoryPage.this.setPageComplete(false);
                    } else {
                        SelectRepositoryPage.this.setPageComplete(rep != null);
                        SelectRepositoryPage.this.settings.setRepository(rep);
                        SelectRepositoryPage.this.settings.deriveDefaults();
                        SelectRepositoryPage.this.setMessage("");
                    }
                } else {
                    SelectRepositoryPage.this.setMessage("Select a local repository, where the feature branch will be created", 1);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 40).applyTo(repositoryViewer.getControl());
        this.setPageComplete(false);
        this.setControl((Control)container);
    }
}

