/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.search;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.search.GitGrepContentProvider;
import com.proalpha.pds.gitutils.search.GitGrepLabelProvider;
import com.proalpha.pds.gitutils.search.GitGrepSearchResult;
import com.proalpha.pds.gitutils.search.GitGrepSearchResultElement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FilterUpdateEvent;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;

public class GitGrepSearchResultPage
extends Page
implements ISearchResultPage {
    private GitGrepLabelProvider paGitGrepLabelProvider;
    private GitGrepContentProvider paGitGrepContentProvider;
    private volatile boolean fIsUIUpdateScheduled = false;
    private volatile boolean fScheduleEnsureSelection = false;
    protected static final Match[] EMPTY_MATCH_ARRAY = new Match[0];
    private TableViewer fViewer;
    private StyledText textArea;
    private Composite fViewerContainer;
    private SashForm sashForm;
    private Control fBusyLabel;
    private PageBook fPagebook;
    private boolean fIsBusyShown;
    private ISearchResultViewPart fViewPart;
    private Set<Object> fBatchedUpdates = new HashSet<Object>();
    private boolean fBatchedClearAll = false;
    private Action openSearchDialog = new Action(){

        public ImageDescriptor getImageDescriptor() {
            return Activator.getImageDescriptor("src/images/search.gif");
        }

        public void run() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            NewSearchUI.openSearchDialog((IWorkbenchWindow)activeWorkbenchWindow, (String)"");
        }

        public String getToolTipText() {
            return "Open Search Dialog";
        }
    };
    private ISearchResultListener fListener = new ISearchResultListener(){

        public void searchResultChanged(SearchResultEvent e) {
            GitGrepSearchResultPage.this.handleSearchResultChanged(e);
        }
    };
    private IQueryListener fQueryListener;
    private GitGrepSearchResult fInput;
    private String fId;

    public void setID(String id) {
        this.fId = id;
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return "";
        }
        return result.getLabel();
    }

    protected void clear() {
        this.fViewer.refresh();
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.paGitGrepLabelProvider = new GitGrepLabelProvider();
        this.paGitGrepContentProvider = new GitGrepContentProvider();
        this.customizeTable(viewer);
        viewer.setContentProvider((IContentProvider)this.paGitGrepContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.paGitGrepLabelProvider);
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                GitGrepSearchResultElement el1 = (GitGrepSearchResultElement)e1;
                GitGrepSearchResultElement el2 = (GitGrepSearchResultElement)e2;
                return el1.compareTo(el2);
            }

            public void sort(Viewer viewer, Object[] elements) {
                super.sort(viewer, elements);
            }
        });
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.fQueryListener = this.createQueryListener();
        this.fPagebook = new PageBook(parent, 0);
        this.fPagebook.setLayoutData((Object)new GridData(1808));
        this.fBusyLabel = this.createBusyControl();
        this.fViewerContainer = new Composite((Composite)this.fPagebook, 0);
        this.fViewerContainer.setLayoutData((Object)new GridData(1808));
        this.fViewerContainer.setLayout((Layout)gridLayout);
        this.sashForm = new SashForm((Composite)this.fPagebook, 256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setLayout((Layout)gridLayout);
        this.createViewer((Composite)this.sashForm);
        this.createTextArea((Composite)this.sashForm);
        this.showBusyLabel(this.fIsBusyShown);
        NewSearchUI.addQueryListener((IQueryListener)this.fQueryListener);
    }

    private synchronized void scheduleUIUpdate() {
        if (!this.fIsUIUpdateScheduled) {
            this.fIsUIUpdateScheduled = true;
            new UpdateUIJob().schedule();
        }
    }

    private IQueryListener createQueryListener() {
        return new IQueryListener(){

            public void queryAdded(ISearchQuery query) {
            }

            public void queryRemoved(ISearchQuery query) {
            }

            public void queryStarting(final ISearchQuery query) {
                Runnable runnable1 = new Runnable(){

                    @Override
                    public void run() {
                        GitGrepSearchResultPage.this.updateBusyLabel();
                        AbstractTextSearchResult result = GitGrepSearchResultPage.this.getInput();
                        if (result == null || !result.getQuery().equals(query)) {
                            return;
                        }
                        GitGrepSearchResultPage.this.scheduleUIUpdate();
                    }
                };
                GitGrepSearchResultPage.this.asyncExec(runnable1);
            }

            public void queryFinished(ISearchQuery query) {
                GitGrepSearchResultPage.this.postEnsureSelection();
            }
        };
    }

    protected void postEnsureSelection() {
        this.fScheduleEnsureSelection = true;
        this.scheduleUIUpdate();
    }

    private void createViewer(Composite parent) {
        TableViewer viewer;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.fViewer = viewer = new TableViewer(parent, 66306);
        this.fViewer.getTable().setLayoutData((Object)gridData);
        this.configureTableViewer(viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GitGrepSearchResultElement selectedElement = this.getSelectedElement();
                String details = selectedElement.getBlock();
                String lineNumber = selectedElement.getLineNr();
                this.fillTextArea(details, lineNumber);
            }

            private void fillTextArea(String details, String lineNumber) {
                if (details == null || lineNumber == null) {
                    return;
                }
                Integer lineOffset = 0;
                if (details.contains(lineNumber)) {
                    lineOffset = details.indexOf(lineNumber);
                }
                GitGrepSearchResultPage.this.textArea.setText(details);
                GitGrepSearchResultPage.this.textArea.setTopIndex(GitGrepSearchResultPage.this.textArea.getLineAtOffset(lineOffset.intValue()));
                String patternStr = "\\D" + lineNumber + ":";
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(details);
                if (matcher.find()) {
                    int startSelection = matcher.start();
                    int endSelection = details.indexOf("\n", startSelection + 1);
                    GitGrepSearchResultPage.this.textArea.setSelection(startSelection, endSelection);
                    GitGrepSearchResultPage.this.textArea.setHorizontalIndex(0);
                }
            }

            private GitGrepSearchResultElement getSelectedElement() {
                IStructuredSelection selection = (IStructuredSelection)GitGrepSearchResultPage.this.fViewer.getSelection();
                if (selection.isEmpty()) {
                    return new GitGrepSearchResultElement();
                }
                GitGrepSearchResultElement selectedElement = (GitGrepSearchResultElement)selection.getFirstElement();
                return selectedElement;
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GitGrepSearchResultPage.this.fViewer = (TableViewer)event.getSource();
                IStructuredSelection el = (IStructuredSelection)GitGrepSearchResultPage.this.fViewer.getSelection();
                GitGrepSearchResultElement elem = (GitGrepSearchResultElement)el.getFirstElement();
                GitGrepSearchResultPage.this.showMessageDialog("Not implemented yet!", "Could not open file " + elem.getObjectName() + " in editor");
            }
        });
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        SearchView.createToolBarGroups((IToolBarManager)tbm);
        tbm.update(false);
        this.getViewPart().updateLabel();
    }

    private void showMessageDialog(String header, String body) {
        MessageDialog.openInformation(null, (String)header, (String)body);
    }

    private void createTextArea(Composite parent) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.textArea = new StyledText(parent, 66306);
        this.textArea.setLayoutData((Object)gridData);
        FontData defaultFont = new FontData("Consolas", 10, 0);
        Font font = new Font((Device)parent.getDisplay(), defaultFont);
        this.textArea.setFont(font);
    }

    private void customizeTable(TableViewer viewer) {
        TableViewerColumn columnObject = new TableViewerColumn(viewer, 0);
        TableViewerColumn columnContent = new TableViewerColumn(viewer, 0);
        TableViewerColumn columnLine = new TableViewerColumn(viewer, 0);
        columnObject.getColumn().setText("Objectname");
        columnObject.getColumn().setResizable(true);
        columnObject.getColumn().setWidth(110);
        columnContent.getColumn().setText("Line");
        columnContent.getColumn().setResizable(true);
        columnContent.getColumn().setWidth(50);
        columnLine.getColumn().setText("Content");
        columnLine.getColumn().setResizable(true);
        columnLine.getColumn().setWidth(700);
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        FontData defaultFont = new FontData("Consolas", 10, 0);
        Font font = new Font((Device)viewer.getTable().getDisplay(), defaultFont);
        viewer.getTable().setFont(font);
    }

    private Control createBusyControl() {
        Table busyLabel = new Table((Composite)this.fPagebook, 0);
        TableItem item = new TableItem(busyLabel, 0);
        item.setText("searching....");
        busyLabel.setLayoutData((Object)new GridData(768));
        return busyLabel;
    }

    private void updateBusyLabel() {
        boolean shouldShowBusy;
        AbstractTextSearchResult result = this.getInput();
        boolean bl = shouldShowBusy = result != null && NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery()) && result.getMatchCount() == 0;
        if (shouldShowBusy == this.fIsBusyShown) {
            return;
        }
        this.fIsBusyShown = shouldShowBusy;
        this.showBusyLabel(this.fIsBusyShown);
    }

    private void showBusyLabel(boolean shouldShowBusy) {
        if (shouldShowBusy) {
            this.fPagebook.showPage(this.fBusyLabel);
        } else {
            this.fPagebook.showPage((Control)this.sashForm);
        }
    }

    private void disposeViewer() {
        this.fViewer.getControl().dispose();
        this.fViewer = null;
    }

    private void connectViewer(AbstractTextSearchResult search) {
        this.fViewer.setInput((Object)search);
    }

    private void disconnectViewer() {
        this.fViewer.setInput(null);
    }

    public void dispose() {
        super.dispose();
        this.disposeViewer();
        NewSearchUI.removeQueryListener((IQueryListener)this.fQueryListener);
    }

    public void setFocus() {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public Control getControl() {
        return this.fPagebook;
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        if (newSearch != null && !(newSearch instanceof GitGrepSearchResult)) {
            return;
        }
        this.textArea.setText("");
        GitGrepSearchResult oldSearch = this.fInput;
        if (oldSearch != null) {
            this.disconnectViewer();
            oldSearch.removeListener(this.fListener);
        }
        this.fInput = (GitGrepSearchResult)newSearch;
        if (this.fInput != null) {
            this.fInput.addListener(this.fListener);
            this.connectViewer(this.fInput);
            if (viewState instanceof ISelection) {
                this.fViewer.setSelection((ISelection)viewState, true);
            }
            this.updateBusyLabel();
            this.scheduleUIUpdate();
        } else {
            this.getViewPart().updateLabel();
        }
    }

    public Object getUIState() {
        return this.fViewer.getSelection();
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    public AbstractTextSearchResult getInput() {
        return this.fInput;
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    protected ISearchResultViewPart getViewPart() {
        return this.fViewPart;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    protected void elementsChanged(Object[] objects) {
        this.clear();
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            this.postUpdate(((MatchEvent)e).getMatches());
        } else if (e instanceof RemoveAllEvent) {
            this.postClear();
        } else if (e instanceof FilterUpdateEvent) {
            this.postUpdate(((FilterUpdateEvent)e).getUpdatedMatches());
        }
    }

    protected void evaluateChangedElements(Match[] matches, Set<Object> changedElements) {
        int i = 0;
        while (i < matches.length) {
            changedElements.add(matches[i].getElement());
            ++i;
        }
    }

    private synchronized void postUpdate(Match[] matches) {
        this.evaluateChangedElements(matches, this.fBatchedUpdates);
        this.scheduleUIUpdate();
    }

    private synchronized void runBatchedUpdates() {
        this.elementsChanged(this.fBatchedUpdates.toArray());
        this.fBatchedUpdates.clear();
        this.updateBusyLabel();
    }

    private synchronized void postClear() {
        this.fBatchedClearAll = true;
        this.fBatchedUpdates.clear();
        this.scheduleUIUpdate();
    }

    private synchronized boolean hasMoreUpdates() {
        return this.fBatchedClearAll || this.fBatchedUpdates.size() > 0;
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchedClear() {
        GitGrepSearchResultPage gitGrepSearchResultPage = this;
        synchronized (gitGrepSearchResultPage) {
            if (!this.fBatchedClearAll) {
                return;
            }
            this.fBatchedClearAll = false;
            this.updateBusyLabel();
        }
        this.getViewPart().updateLabel();
        this.clear();
    }

    private void asyncExec(final Runnable runnable) {
        final Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay == null || !currentDisplay.equals(control.getDisplay())) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            } else {
                runnable.run();
            }
        }
    }

    private class UpdateUIJob
    extends UIJob {
        public UpdateUIJob() {
            super("Update Search Results View");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = GitGrepSearchResultPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return Status.OK_STATUS;
            }
            GitGrepSearchResultPage.this.runBatchedClear();
            GitGrepSearchResultPage.this.runBatchedUpdates();
            if (GitGrepSearchResultPage.this.hasMoreUpdates() || GitGrepSearchResultPage.this.isQueryRunning()) {
                this.schedule(1L);
            } else {
                GitGrepSearchResultPage.this.fIsUIUpdateScheduled = false;
                GitGrepSearchResultPage.this.updateBusyLabel();
                if (GitGrepSearchResultPage.this.fScheduleEnsureSelection) {
                    GitGrepSearchResultPage.this.fScheduleEnsureSelection = false;
                }
            }
            GitGrepSearchResultPage.this.fViewPart.updateLabel();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == GitGrepSearchResultPage.this;
        }
    }
}

