/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchJob;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchOperation;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import com.proalpha.pds.gitutils.mylyn.SelectBranchesPage;
import com.proalpha.pds.gitutils.mylyn.SelectRepositoryPage;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBranchWizard
extends Wizard {
    private final Logger logger = LoggerFactory.getLogger(FeatureBranchWizard.class);
    private final SelectRepositoryPage repPage;
    private final SelectBranchesPage branchesPage;
    private FeatureBranchSettings settings = new FeatureBranchSettings();

    public FeatureBranchWizard(ITask task) {
        this.settings.setTask(task);
        this.repPage = new SelectRepositoryPage(this.settings);
        this.branchesPage = new SelectBranchesPage(this.settings);
        super.setWindowTitle("proALPHA Feature Branch Generator");
    }

    public boolean performFinish() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        final ArrayList<IProject> openedProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && RepositoryProvider.getProvider((IProject)project).getID().equals("org.eclipse.egit.core.GitProvider")) {
                openedProjects.add(project);
            }
            ++n2;
        }
        Runnable closeProjects = new Runnable(){

            @Override
            public void run() {
                for (IProject iProject : openedProjects) {
                    try {
                        iProject.close((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        FeatureBranchWizard.this.logger.error("Error while closing project {}", (Object)iProject);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)closeProjects);
        FeatureBranchOperation op = new FeatureBranchOperation(this.settings);
        FeatureBranchJob job = new FeatureBranchJob(op);
        job.setUser(true);
        job.setRule(RuleUtil.getRule((Repository)this.settings.getRepository()));
        job.schedule();
        Runnable openProjects = new Runnable(){

            @Override
            public void run() {
                for (IProject iProject : openedProjects) {
                    try {
                        iProject.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        FeatureBranchWizard.this.logger.error("Error while opening project {}", (Object)iProject);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)openProjects);
        return true;
    }

    public void addPages() {
        super.addPage((IWizardPage)this.repPage);
        super.addPage((IWizardPage)this.branchesPage);
    }

    public void dispose() {
        super.dispose();
    }

    public FeatureBranchSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FeatureBranchSettings settings) {
        this.settings = settings;
    }
}

