/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchWizard;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskActionListener
extends TaskActivationAdapter {
    private final Logger logger = LoggerFactory.getLogger(TaskActionListener.class);
    private WizardDialog wiz;
    FeatureBranchWizard fbw = null;
    ITask oldActiveTask = null;
    private boolean oldTaskResume = false;

    public void taskActivated(ITask task) {
        ITaskActivityManager taskActivityManager = TasksUi.getTaskActivityManager();
        if (taskActivityManager != null) {
            boolean isOldTaskId = StringUtils.countMatches((String)task.getTaskKey(), (String)"-") > 1;
            String taskId = task.getTaskKey();
            this.logger.debug("Task {} activated", (Object)taskId);
            if (!task.getConnectorKind().equals("jira") && isOldTaskId) {
                this.logger.debug("Task {} is not handled by GIT. The feature branch wizard is skipped", (Object)taskId);
                return;
            }
            if (this.oldTaskResume && this.oldActiveTask.getTaskKey() == task.getTaskKey()) {
                return;
            }
            this.fbw = new FeatureBranchWizard(task);
            this.wiz = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.fbw);
            int dialogResult = this.wiz.open();
            if (dialogResult == 1) {
                if (this.oldActiveTask != null) {
                    taskActivityManager.activateTask(this.oldActiveTask);
                    this.logger.debug("Task {} reactivated because of cancellation", (Object)this.oldActiveTask.getTaskKey());
                    this.oldActiveTask = null;
                    this.oldTaskResume = false;
                } else {
                    this.logger.debug("Task {} deactivated because of cancellation", (Object)task.getTaskKey());
                    taskActivityManager.deactivateActiveTask();
                }
            } else if (dialogResult == 0) {
                this.logger.debug("Task {} saved", (Object)task.getTaskKey());
                this.oldActiveTask = task;
                this.oldTaskResume = true;
            }
        }
        String taskId = task.getTaskKey();
        this.logger.debug("Task {} activated", (Object)taskId);
        if (!task.getConnectorKind().equals("jira")) {
            this.logger.debug("Task {} is not handled by JIRA. The feature branch wizard is skipped", (Object)taskId);
            return;
        }
        this.fbw = new FeatureBranchWizard(task);
        this.wiz = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.fbw);
        this.wiz.open();
    }

    public void taskDeactivated(ITask task) {
    }
}

