/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.RunCommonPaProgram;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompileStagedHandler
extends AbstractHandler {
    private static final String COMPILER_FILES = "compiler.pro,compiler.str,compiler.inp";
    private String patempdir = "";
    private RunCommonPaProgram pabridge;
    private String paProjectName = "";
    private String compilerimpfile = "compiler.inp";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTools repositoryTools = new RepositoryTools(event);
        IOpenEdgeProject oeProject = repositoryTools.getOpenEdgeProject();
        this.setCompilerimpfile("stagedfiles.inp");
        if (!this.checkPreconditions(oeProject)) {
            return null;
        }
        List<String> checkList = repositoryTools.getStagedFiles();
        if (!checkList.isEmpty()) {
            try {
                if (!this.writeInputFile(checkList)) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"compile staged files", (String)"No files to compile found.");
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
            this.pabridge.startCompilerOpt(this.getCompilerInputFilename(), Boolean.valueOf(true));
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"compile staged files", (String)"No staged files found. compile will not be performed.");
        }
        return null;
    }

    private boolean checkPreconditions(IOpenEdgeProject oeProject) {
        if (!this.paProjectName.equals(oeProject.getProject().getName())) {
            this.pabridge = new RunCommonPaProgram(oeProject);
            if (this.pabridge.isproALPHAAvailable()) {
                this.patempdir = this.pabridge.getpAStartupParam("temp", "");
            } else {
                this.patempdir = "";
                return false;
            }
        }
        return this.deleteCompilerFiles();
    }

    private boolean deleteCompilerFiles() {
        File resultFile;
        List<String> fileList = Arrays.asList(COMPILER_FILES);
        for (String filename : fileList) {
            resultFile = new Path(this.patempdir).append(filename).toFile();
            if (!resultFile.isFile()) continue;
            try {
                Files.delete(resultFile.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        resultFile = new Path(this.patempdir).append(this.getCompilerimpfile()).toFile();
        if (resultFile.isFile()) {
            try {
                Files.delete(resultFile.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private boolean writeInputFile(List<String> checkList) throws IOException {
        Boolean haswritten = false;
        FileWriter fileWriter = new FileWriter(this.getCompilerInputFilename());
        PrintWriter printWriter = new PrintWriter(fileWriter);
        if (checkList.size() > 1000) {
            printWriter.println("*");
            printWriter.close();
            return true;
        }
        for (String filename : checkList) {
            if (filename.toLowerCase().endsWith(".pdi")) continue;
            haswritten = true;
            printWriter.println(filename);
        }
        printWriter.close();
        return haswritten;
    }

    private String getCompilerInputFilename() {
        File compimpfile = new Path(this.patempdir).append(this.getCompilerimpfile()).toFile();
        return compimpfile.toString();
    }

    public String getCompilerimpfile() {
        return this.compilerimpfile;
    }

    public void setCompilerimpfile(String compilerimpfile) {
        this.compilerimpfile = compilerimpfile;
    }
}

