/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGitConfig;
import com.proalpha.git.model.server.GitServerRepository;
import com.proalpha.git.util.PaBranchName;
import com.proalpha.git.util.bitbucket.BitbucketRestCallGetRepoList;
import com.proalpha.git.util.gitblit.GitBlitRpcCallGetRepoList;
import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.cherrypick.CherryPickWizard;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.Bundle;

public class CherryPickPage
extends WizardPage {
    private Repository srcRepository;
    private List<GitServerRepository> currRepos;
    private Combo txtSrcRepository;
    private Combo txtSrcBranch;
    private Text txtSrcFeature;
    private Text txtTargetBranch;
    private Text txtTargetFeature;
    private Button btnFetchCommits;
    private Button btnEditBranchname;

    public CherryPickPage(Repository repository) {
        super(CherryPickPage.class.getName());
        this.srcRepository = repository;
        this.setTitle("proALPHA CherryPick");
        this.setMessage("Select Repository and Branch which needs to get picked into your current repository", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        this.currRepos = this.getServerRepositories();
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpSource = new Group(container, 0);
        GridData gdGrpSource = new GridData(0x1000000, 128, true, false, 1, 1);
        gdGrpSource.heightHint = 85;
        gdGrpSource.widthHint = 450;
        grpSource.setLayoutData((Object)gdGrpSource);
        grpSource.setText("Source");
        Label lblRepository = new Label((Composite)grpSource, 0);
        lblRepository.setText("Repository:");
        lblRepository.setBounds(10, 22, 80, 15);
        Label lblBranch = new Label((Composite)grpSource, 0);
        lblBranch.setText("Branch:");
        lblBranch.setBounds(10, 49, 80, 15);
        Label lblFeature = new Label((Composite)grpSource, 0);
        lblFeature.setText("Feature:");
        lblFeature.setBounds(10, 76, 80, 15);
        this.txtSrcRepository = new Combo((Composite)grpSource, 2048);
        this.txtSrcRepository.setBounds(96, 19, 212, 21);
        this.txtSrcBranch = new Combo((Composite)grpSource, 2048);
        this.txtSrcBranch.setBounds(96, 46, 212, 21);
        Object[] repos = new String[this.currRepos.size()];
        int i = 0;
        while (i < this.currRepos.size()) {
            repos[i] = this.currRepos.get(i).getDisplayName();
            ++i;
        }
        Arrays.sort(repos);
        this.txtSrcRepository.setItems((String[])repos);
        this.txtSrcFeature = new Text((Composite)grpSource, 2048);
        this.txtSrcFeature.setBounds(96, 73, 162, 21);
        Button btnRefreshRepos = new Button((Composite)grpSource, 0);
        btnRefreshRepos.setToolTipText("Reload repositories from server");
        btnRefreshRepos.setImage(ResourceManager.getPluginImage("com.proalpha.pds.gitutils", "icons/refresh.gif"));
        btnRefreshRepos.setBounds(314, 18, 28, 23);
        this.setControl((Control)container);
        Group grpTarget = new Group(container, 0);
        GridData gdGrpTarget = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gdGrpTarget.widthHint = 450;
        gdGrpTarget.heightHint = 80;
        grpTarget.setLayoutData((Object)gdGrpTarget);
        grpTarget.setText("Target");
        Label label1 = new Label((Composite)grpTarget, 0);
        label1.setText("Repository:");
        label1.setBounds(10, 23, 80, 15);
        Label label2 = new Label((Composite)grpTarget, 0);
        label2.setText("Branch:");
        label2.setBounds(10, 50, 80, 15);
        Text txtTargetRepository = new Text((Composite)grpTarget, 0);
        txtTargetRepository.setBounds(96, 23, 347, 21);
        txtTargetRepository.setText(this.srcRepository.getDirectory().toString());
        txtTargetRepository.setEnabled(false);
        this.txtTargetBranch = new Text((Composite)grpTarget, 2048);
        this.txtTargetBranch.setBounds(96, 47, 212, 21);
        this.txtTargetBranch.setEnabled(false);
        this.btnEditBranchname = new Button((Composite)grpTarget, 32);
        this.btnEditBranchname.setBounds(314, 49, 129, 16);
        this.btnEditBranchname.setText("modify branch name");
        Label label3 = new Label((Composite)grpTarget, 0);
        label3.setText("Feature:");
        label3.setBounds(10, 74, 80, 15);
        this.txtTargetFeature = new Text((Composite)grpTarget, 2048);
        this.txtTargetFeature.setBounds(96, 71, 162, 21);
        new Label(container, 0);
        this.btnFetchCommits = new Button(container, 0);
        this.btnFetchCommits.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnFetchCommits.setText("Fetch Commits");
        this.btnFetchCommits.setEnabled(false);
        this.addSrcWidgetListeners();
        this.addTargetWidgetListeners();
        this.addButtonWidgetListeners();
        this.setPageComplete(false);
    }

    private void addSrcWidgetListeners() {
        this.txtSrcRepository.addModifyListener(modifyEvent -> this.checkRepoAndProposeBranches());
        this.txtSrcRepository.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source repository");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.txtSrcBranch.addModifyListener(modifyEvent -> {
            if (this.txtSrcBranch.getText().length() != 0 && this.checkBranch()) {
                this.txtSrcFeature.setText(this.getFeatureText(this.txtSrcBranch.getText()));
            }
        });
        this.txtSrcBranch.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source branch");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0 && CherryPickPage.this.checkBranch()) {
                    CherryPickPage.this.txtSrcFeature.setText(CherryPickPage.this.getFeatureText(CherryPickPage.this.txtSrcBranch.getText()));
                }
            }
        });
        this.txtSrcFeature.addModifyListener(modifyEvent -> {
            if (this.txtSrcBranch.getText().length() != 0) {
                this.checkBranch();
                this.txtTargetFeature.setText(this.txtSrcFeature.getText());
            }
        });
        this.txtSrcFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your feature to pick");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0 && CherryPickPage.this.txtSrcFeature.getText().length() != 0) {
                    CherryPickPage.this.btnFetchCommits.setEnabled(true);
                }
            }
        });
    }

    private void addTargetWidgetListeners() {
        this.txtTargetBranch.addModifyListener(modifyEvent -> {
            if (this.txtTargetBranch.getText().length() != 0) {
                IWizard wiz = this.getWizard();
                ((CherryPickWizard)wiz).setTargetBranch(this.txtTargetBranch.getText());
            }
        });
        this.txtTargetBranch.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your new branchname");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtTargetBranch.getText().length() != 0) {
                    CherryPickPage.this.txtTargetFeature.setText(CherryPickPage.this.getFeatureText(CherryPickPage.this.txtTargetBranch.getText()));
                }
            }
        });
        this.txtTargetFeature.addModifyListener(modifyEvent -> {
            if (this.txtTargetFeature.getText().length() != 0) {
                IWizard wiz = this.getWizard();
                ((CherryPickWizard)wiz).setTargetIssue(this.txtTargetFeature.getText());
            }
        });
        this.txtTargetFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose a target feature which is used for first line of commit message");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtTargetFeature.getText().length() == 0) {
                    CherryPickPage.this.txtTargetFeature.setText(CherryPickPage.this.getFeatureText(CherryPickPage.this.txtTargetBranch.getText()));
                }
                IWizard wiz = CherryPickPage.this.getWizard();
                ((CherryPickWizard)wiz).setTargetIssue(CherryPickPage.this.txtTargetFeature.getText());
            }
        });
    }

    private void addButtonWidgetListeners() {
        this.btnEditBranchname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.txtTargetBranch.setEnabled(CherryPickPage.this.btnEditBranchname.getSelection());
                if (!CherryPickPage.this.btnEditBranchname.getSelection()) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.btnFetchCommits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.fetchCommits();
            }
        });
    }

    protected void fetchCommits() {
        IWizard wiz = this.getWizard();
        ((CherryPickWizard)wiz).setSourceIssue(this.txtSrcFeature.getText());
        ((CherryPickWizard)wiz).setSourceBranch(this.txtSrcBranch.getText());
        ((CherryPickWizard)wiz).setTargetIssue(this.txtTargetFeature.getText());
        for (GitServerRepository actRepo : this.currRepos) {
            if (!actRepo.getDisplayName().equals(this.txtSrcRepository.getText())) continue;
            ((CherryPickWizard)wiz).setSourceRepoString(actRepo.getDisplayName());
            break;
        }
        Boolean commitsfound = ((CherryPickWizard)wiz).gatherCommits();
        if (!commitsfound.booleanValue()) {
            this.setMessage("No commits found!", 2);
        } else {
            this.setMessage("Commits found! Push 'Next' to view or 'Finish' to pick them", 1);
        }
        this.setPageComplete(commitsfound);
    }

    private List<GitServerRepository> getServerRepositories() {
        ArrayList serverRepositories;
        String gitServerPath = Activator.getDefault().getPreferenceStore().getString("PaGitBlitServerUrl");
        if (gitServerPath.contains("/gitblit")) {
            GitBlitRpcCallGetRepoList rpc = new GitBlitRpcCallGetRepoList(Activator.getDefault().getPreferenceStore().getString("PaGitBlitServerUrl"));
            rpc.execute();
            serverRepositories = (ArrayList)rpc.getRpcResponse();
        } else {
            BitbucketRestCallGetRepoList restcall = new BitbucketRestCallGetRepoList();
            restcall.setSubUrl("repos");
            restcall.execute();
            serverRepositories = (ArrayList)restcall.getRestResponse();
        }
        return serverRepositories;
    }

    private String getFeatureText(String branchText) {
        Pattern p = Pattern.compile("(.*\\.)?(" + PaGitConfig.getStringFromConfig((String)"issue_key_format") + ")$");
        Matcher m = p.matcher(branchText);
        if (m.find()) {
            return m.group(2);
        }
        return "";
    }

    private boolean checkBranch() {
        boolean foundIt = false;
        String branchText = this.txtSrcBranch.getText();
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (branchText.length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        for (GitServerRepository actRepo : this.currRepos) {
            if (actRepo.getDisplayName().equals(this.txtSrcRepository.getText())) {
                for (String actBranch : actRepo.getBranches()) {
                    if (!actBranch.equals(branchText)) continue;
                    foundIt = true;
                }
            }
            if (foundIt) break;
        }
        if (!foundIt) {
            this.setMessage("Branch not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            return false;
        }
        IWizard wiz = this.getWizard();
        ((CherryPickWizard)wiz).setSourceBranch(branchText);
        String targetBranch = branchText;
        try {
            targetBranch = this.txtSrcFeature.getText() != null && this.txtSrcFeature.getText() != "" ? String.valueOf(PaBranchName.getVersion((String)this.srcRepository.getBranch())) + "." + this.txtSrcFeature.getText() : String.valueOf(PaBranchName.getVersion((String)this.srcRepository.getBranch())) + ".";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.txtTargetBranch.setText(targetBranch);
        ((CherryPickWizard)wiz).setTargetBranch(targetBranch);
        this.btnFetchCommits.setEnabled(true);
        return true;
    }

    protected void checkRepoAndProposeBranches() {
        boolean foundIt = false;
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (this.txtSrcRepository.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        for (GitServerRepository actRepo : this.currRepos) {
            if (!actRepo.getDisplayName().equals(this.txtSrcRepository.getText())) continue;
            List actBranches = actRepo.getBranches();
            String[] branches = (String[])actBranches.stream().toArray(String[]::new);
            this.txtSrcBranch.setItems(branches);
            foundIt = true;
        }
        if (!foundIt) {
            this.setMessage("Repository not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            this.txtSrcBranch.setItems(new String[0]);
            return;
        }
        IWizard wiz = this.getWizard();
        ((CherryPickWizard)wiz).setSourceRepoString(this.txtSrcRepository.getText());
    }
}

