/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.util.PaIssueExplorer;
import com.proalpha.git.util.PaRepository;
import com.proalpha.pds.gitutils.Activator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatherCommitsOperation {
    private final Logger logger = LoggerFactory.getLogger(GatherCommitsOperation.class);
    private List<RevCommit> gatheredCommits;
    private String repository;
    private String branch;
    private String issue;

    public GatherCommitsOperation(String repository, String branch, String issue) {
        this.repository = repository;
        this.branch = branch;
        this.issue = issue;
    }

    public void run() throws InvocationTargetException {
        String repTemp = null;
        try {
            try {
                String remoteBranch = "";
                String gitServerPath = Activator.getDefault().getPreferenceStore().getString("PaGitBlitServerUrl");
                if (!gitServerPath.endsWith("/")) {
                    gitServerPath = String.valueOf(gitServerPath) + '/';
                }
                remoteBranch = gitServerPath.contains("/gitblit") ? String.valueOf(gitServerPath) + "r/" + this.repository : String.valueOf(gitServerPath) + "scm/" + this.repository;
                repTemp = PaRepository.connectRemoteBranch((String)remoteBranch, (String)this.branch, (String)(String.valueOf('_') + this.repository));
                this.logger.debug("Remotebranch created as: {}", (Object)repTemp);
                List commits = PaIssueExplorer.getCommitsOfIssue((String)repTemp, (String)this.issue);
                if (this.logger.isDebugEnabled()) {
                    for (RevCommit commit : commits) {
                        this.logger.debug("Found commit: {}, message: {}", (Object)commit.getName(), (Object)commit.getFullMessage());
                    }
                }
                this.gatheredCommits = commits;
            }
            catch (GitAPIException e) {
                throw new InvocationTargetException(e.getCause() != null ? e.getCause() : e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                PaRepository.disconnectRemote((String)(String.valueOf('_') + this.repository));
            }
            catch (IOException | GitAPIException e) {
                this.logger.error("Exception while disconnecting remote {}", repTemp, (Object)e);
            }
            throw throwable;
        }
        try {
            PaRepository.disconnectRemote((String)(String.valueOf('_') + this.repository));
        }
        catch (IOException | GitAPIException e) {
            this.logger.error("Exception while disconnecting remote {}", (Object)repTemp, (Object)e);
        }
    }

    public List<RevCommit> getOperationResult() {
        return this.gatheredCommits;
    }
}

