/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGit;
import com.proalpha.git.commands.PaIssueConveyanceCommand;
import com.proalpha.git.model.PaCherryPickResult;
import com.proalpha.git.util.PaRepository;
import com.proalpha.pds.gitutils.cherrypick.CherryPickSettings;
import com.proalpha.pds.paconnector.Activator;
import java.io.IOException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CherryPick {
    private final Logger logger = LoggerFactory.getLogger(CherryPick.class);
    private CherryPickSettings cherryPickSettings;
    private PaCherryPickResult cherryPickResult;
    private PaIssueConveyanceCommand cherryPickCommand;

    private CherryPick() {
    }

    public static CherryPick getInstance() {
        return CherryPickInstanceHolder.INSTANCE;
    }

    public CherryPickSettings getCherryPickSettings() {
        return this.cherryPickSettings;
    }

    public PaCherryPickResult getCherryPickResult() {
        return this.cherryPickResult;
    }

    public void setCherryPickResult(PaCherryPickResult cherryPickResult) {
        this.cherryPickResult = cherryPickResult;
    }

    public PaIssueConveyanceCommand getCherryPickCommand() {
        return this.cherryPickCommand;
    }

    public void createCherryPickCommand(CherryPickSettings settings) throws IOException, GitAPIException {
        this.cherryPickSettings = settings;
        String remoteBranch = "";
        String gitServerPath = Activator.getDefault().getPreferenceStore().getString("PaGitServerUrl");
        if (!gitServerPath.endsWith("/")) {
            gitServerPath = String.valueOf(gitServerPath) + '/';
        }
        remoteBranch = String.valueOf(gitServerPath) + "scm/" + this.cherryPickSettings.getSourceRepoString();
        String repTemp = PaRepository.connectRemoteBranch((String)remoteBranch, (String)this.cherryPickSettings.getSourceBranch(), (String)(String.valueOf('_') + this.cherryPickSettings.getSourceRepoString()));
        this.cherryPickCommand = PaGit.getInstance().paIssueConveyenceCommand().setIssue(this.cherryPickSettings.getSourceIssue()).setTargetIssue(this.cherryPickSettings.getTargetIssue()).setSourceRef(repTemp).setTargetRef("refs/heads/" + this.cherryPickSettings.getTargetBranch());
    }

    public void cancelCherryPick(boolean rollback) {
        try {
            if (rollback) {
                this.cherryPickCommand.rollback();
            }
            PaRepository.disconnectRemote((String)(String.valueOf('_') + this.cherryPickSettings.getSourceRepoString()));
        }
        catch (IOException | GitAPIException e) {
            this.logger.error("Exception while disconnecting remote {}", (Object)this.cherryPickCommand.getSourceRef(), (Object)e);
        }
        this.reinitialize();
    }

    public void reinitialize() {
        this.cherryPickSettings = null;
        this.cherryPickCommand = null;
        this.cherryPickResult = null;
    }

    /* synthetic */ CherryPick(CherryPick cherryPick) {
        this();
    }

    private static final class CherryPickInstanceHolder {
        static final CherryPick INSTANCE = new CherryPick(null);

        private CherryPickInstanceHolder() {
        }
    }
}

