/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.bitbucket;

import com.proalpha.pds.pagit.PaGitConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitbucketRestCall<T> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketRestCall.class);
    private final String baseUrl = PaGitConfig.getStringFromConfig("bitbucket.server");
    private final String path = PaGitConfig.getStringFromConfig("bitbucket.path");
    private final String accessToken = PaGitConfig.getStringFromConfig("bitbucket.bearer_token");
    private static final Integer PAGE_SIZE = 100;
    private T restResponse;
    private String subUrl;
    private Integer startEntry = 0;

    public T getRestResponse() {
        return this.restResponse;
    }

    public String getSubUrl() {
        return this.subUrl;
    }

    public void setSubUrl(String subUrl) {
        this.subUrl = subUrl;
    }

    public Integer getStartEntry() {
        return this.startEntry;
    }

    public void setStartEntry(Integer startEntry) {
        this.startEntry = startEntry;
    }

    public void execute() {
        URL url = this.buildUrl();
        try {
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                this.restResponse = this.parseRestResponse(con.getInputStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
    }

    private URL buildUrl() {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        sb.append(this.path);
        sb.append(this.subUrl);
        sb.append("?limit=");
        sb.append(PAGE_SIZE);
        sb.append("&start=");
        sb.append(this.startEntry);
        URL url = null;
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        return url;
    }

    protected abstract T parseRestResponse(InputStream var1) throws IOException;
}

