/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.openedge.pdt.project.OEPropertyStore;
import com.proalpha.pds.checks.CheckTreeView;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.gitutils.checks.ScanJob;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class UnstageHandler
extends AbstractHandler {
    private File resultFile;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTools repositoryTools = new RepositoryTools(event);
        final PaProject paProject = repositoryTools.getPaProject();
        List<String> checkList = repositoryTools.getUnstagedFiles();
        if (checkList.size() > 0 && this.checkPreconditions(paProject)) {
            ScanJob scanJob = new ScanJob("Scan unstaged objects for selected branch", paProject, checkList, this.resultFile);
            scanJob.addJobChangeListener(new IJobChangeListener(){

                public void done(IJobChangeEvent arg0) {
                    if (UnstageHandler.this.resultFile.exists()) {
                        try {
                            final IWorkbenchPage page = PlatformUI.getWorkbench().showPerspective("com.proalpha.pds.checks.proALPHAChecks", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CheckTreeView checkTreeView = (CheckTreeView)page.findView("com.proalpha.pds.checks.CheckTreeView");
                                    checkTreeView.setSelectedProject(paProject);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void awake(IJobChangeEvent arg0) {
                }

                public void aboutToRun(IJobChangeEvent arg0) {
                }

                public void running(IJobChangeEvent arg0) {
                }

                public void scheduled(IJobChangeEvent arg0) {
                }

                public void sleeping(IJobChangeEvent arg0) {
                }
            });
            scanJob.setUser(true);
            scanJob.schedule();
        }
        return null;
    }

    private boolean checkPreconditions(PaProject paProject) {
        if (!this.deleteOldCheckResults(paProject)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"StageHandler", (String)"The existing file with the check results could not be deleted. The checks could not be performed.");
            return false;
        }
        if (!this.isQueueServerAvailable(paProject)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"StageHandler", (String)"The queue server is not available. Please start the queue server.");
            return false;
        }
        return true;
    }

    private boolean deleteOldCheckResults(PaProject paProject) {
        try {
            OEPropertyStore oePropertyStore = new OEPropertyStore(paProject.getOeProject().getProject());
            String tempDir = "";
            if (oePropertyStore != null) {
                tempDir = oePropertyStore.getProperty("pvm_tempdir");
            }
            this.resultFile = new Path(tempDir).append("ConsistencyCheck.xml").toFile();
            if (!this.resultFile.exists()) {
                return Boolean.TRUE;
            }
            return this.resultFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    private boolean isQueueServerAvailable(PaProject paProject) {
        return paProject.isAvailable() && paProject.getBridge().isQueueServerAvailable();
    }
}

