/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.repository;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.repository.Dataset;
import com.proalpha.pds.paconnector.repository.DatasetImpl;
import com.proalpha.pds.paconnector.repository.Entity;
import com.proalpha.pds.paconnector.repository.EntityImpl;
import com.proalpha.pds.paconnector.repository.Instance;
import com.proalpha.pds.paconnector.repository.InstanceImpl;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;

class RepositoryDelegateImpl
extends RunProgramInPa
implements RepositoryDelegate {
    RunProgramInPa pabridge;

    public RepositoryDelegateImpl(IOpenEdgeProject oeProject) throws ProALPHANotAvailableException {
        super(oeProject);
        this.pabridge = new RunProgramInPa(oeProject);
    }

    @Override
    public boolean createRepositoryEntryForDataset(Dataset dataset) {
        return this.runExternalProcedure("adm/support/proc/ds_pds00.p", dataset.getName(), dataset.getDescription(), dataset.getFileName(), dataset.getBussinessEntityObject(), dataset.getDataAccessObject(), dataset.getDatabussinessEntityProxy(), dataset.getReadOnly(), dataset.getMasterDataValidation(), dataset.getGetChanges()).equals("ok");
    }

    @Override
    public boolean createRepositoryEntryForEntity(Entity entity) {
        if (this.pabridge.getProALPHAVersion().startsWith("5.2")) {
            return this.runExternalProcedure("adm/support/proc/ds_ent00.p", entity.getTempTableName(), entity.getDescription(), entity.getFileName(), entity.getHasBeforTable(), entity.getIsNoUndo(), entity.getIsReferenceOnly(), entity.getLikeDBTableNaem()).equals("ok");
        }
        return this.runSupportProcedure("ds_oea68.p", entity.getTempTableName(), entity.getDescription(), entity.getFileName(), entity.getHasBeforTable(), entity.getIsNoUndo(), entity.getIsReferenceOnly(), entity.getLikeDBTableNaem()).equals("ok");
    }

    @Override
    public boolean createRepositoryEntryforInstance(Instance instance) {
        return this.runSupportProcedure("ds_oea67.p", instance.getName(), instance.getDescription(), instance.getShortDescription(), instance.getParentClass()).equals("ok");
    }

    @Override
    public void dumpPdoToDisk(String objectName, String outputPath) {
        this.runSupportProcedure("ds_oea66.p", objectName, outputPath);
    }

    @Override
    public void fillRepositoryCache() {
        this.runSupportProcedure("ds_oea47.p", new String[0]);
    }

    @Override
    public Dataset getEmptyDataset() {
        return new DatasetImpl();
    }

    @Override
    public Entity getEmptyEntity() {
        return new EntityImpl();
    }

    @Override
    public Instance getEmptyInstance() {
        return new InstanceImpl();
    }

    @Override
    public void openPDOInRepository(String pdoName) {
        this.runSupportProcedure("ds_oea01.p", pdoName);
    }

    @Override
    public void refreshChache() {
        this.runSupportProcedure("ds_oea09.p", new String[0]);
    }

    @Override
    public RunProgramInPa getpabridge() {
        return this.pabridge;
    }
}

