/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.openedge.core.runtime.IPropath;
import com.openedge.core.runtime.ProgressCommand;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.utils.CharsetConverter;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunProgramInPa {
    private final Logger logger = LoggerFactory.getLogger(RunProgramInPa.class);
    private static final String S_SUBPATH = "adm/support/proc/";
    private static final int P_INTERNALCALL = 1;
    private static final int P_EXTERNALCALL = 2;
    private static final int P_FINDRECORD = 3;
    private static final int P_EXTERNALCALLPERSISTENT = 4;
    private static final int P_INTERNALFUNCTION = 1;
    private static final int P_INTERNALPROCEDURE = 2;
    private static final int P_UNDEFINEDMETHODTYPE = 0;
    private OEProject oeProject;
    private IPropath propath;
    private IPath bridgePath;
    private String codepage;
    private String proALPHAVersion;
    private boolean proALPHAAvailable = false;

    public RunProgramInPa(IOpenEdgeProject oeProject) {
        this.oeProject = (OEProject)oeProject;
        this.propath = oeProject.getPropath();
        this.bridgePath = this.propath.search("paoidebr.p", true);
        if (this.bridgePath != null) {
            try {
                this.codepage = this.runSupportProcedure("ds_oea36.p", new String[0]);
                this.proALPHAVersion = this.callFunctionInService("session", "pa_cOIDEProperty", "proALPHAVersion");
                this.setProALPHAAvailable(true);
            }
            catch (IllegalArgumentException e) {
                this.codepage = null;
            }
        } else {
            System.out.println("paoidebr.p not Found. Not a pA Project");
        }
    }

    private void setProALPHAAvailable(boolean available) {
        this.proALPHAAvailable = available;
    }

    public String getProALPHAVersion() {
        return this.proALPHAVersion;
    }

    public String callProcedureInService(String service, String procedureName, String ... parameters) {
        return this.run(1, 2, service, procedureName, parameters);
    }

    public String callFunctionInService(String service, String functionName, String ... parameters) {
        return this.run(1, 1, service, functionName, parameters);
    }

    public String runExternalProcedure(String procedure, String ... parameters) {
        return this.run(2, 0, procedure, "", parameters);
    }

    public String runExternalProcedurePersistent(String procedure, String ... parameters) {
        return this.run(4, 0, procedure, "", parameters);
    }

    public String recordField(String tableName, Hashtable<String, String> selection, String fieldName) {
        String[] parameters = new String[selection.size() * 2 + 2];
        parameters[0] = tableName;
        parameters[1] = fieldName;
        int k = 2;
        Enumeration<String> keys = selection.keys();
        Enumeration<String> values = selection.elements();
        int i = 0;
        while (i < selection.size()) {
            parameters[k++] = keys.nextElement();
            parameters[k++] = values.nextElement();
            ++i;
        }
        return this.run(3, 0, "", "", parameters);
    }

    private synchronized String run(int serviceType, int methodType, String program, String methodName, String ... parameters) {
        return this.run(serviceType, methodType, program, methodName, false, parameters);
    }

    private synchronized String run(int serviceType, int methodType, String program, String methodName, boolean toTop, String ... parameters) {
        if (this.bridgePath == null) {
            Throwable e = new Throwable("Bridge to pA not available. cancel action " + program);
            ExceptionUtils.showAndLogErrorMessage(Activator.getDefault(), e);
            return "";
        }
        String commandString = "ServiceType=" + serviceType + ",MethodType=" + methodType + ",Program=" + program + ",MethodName=" + methodName + ",NumberOfParameters=" + parameters.length;
        int i = 1;
        StringBuilder cmdStr = new StringBuilder(commandString);
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            cmdStr.append(",ParameterValue");
            cmdStr.append(i++);
            cmdStr.append("=");
            cmdStr.append(parameter);
            ++n2;
        }
        commandString = cmdStr.toString();
        if (this.codepage != null) {
            commandString = CharsetConverter.encode(this.codepage, commandString);
        }
        ProgressCommand cmd = new ProgressCommand(this.bridgePath.toOSString(), commandString, "EXTERNAL");
        this.oeProject.getRuntime().runProgressCommand(cmd);
        if (toTop) {
            this.oeProject.getRuntime().bringToTop();
        }
        try {
            cmd.waitforResult();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ExceptionUtils.showAndLogErrorMessage(Activator.getDefault(), e);
        }
        if (!cmd.isFinished()) {
            Throwable e = new Throwable("Openedge Command couldn't get finished!");
            ExceptionUtils.showAndLogErrorMessage(Activator.getDefault(), e);
        }
        if (cmd.getCompletionStatus() == 1) {
            String result = cmd.getResult();
            return result;
        }
        return "";
    }

    public String runSupportProcedure(String supportProcedure, String ... parameters) {
        String filePath = null;
        IPath iPath = this.propath.search(S_SUBPATH + supportProcedure, true);
        if (iPath != null && !iPath.isEmpty()) {
            filePath = iPath.toOSString();
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("In this version, this feature is not supported. (%s)", supportProcedure));
        }
        String retVal = this.runExternalProcedure(filePath, parameters);
        if (retVal.startsWith("PROGRESS runtime error ")) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("Support procedure " + supportProcedure + " returned\n" + retVal + "\n\nParameters given:\n");
            int i = 0;
            while (i < parameters.length) {
                errorMsg.append(String.valueOf(parameters[i]) + "\n");
                ++i;
            }
            throw new IllegalArgumentException(errorMsg.toString());
        }
        return retVal;
    }

    public String getpAStartupParam(String startupParam, String defaultValue) {
        String[] results;
        String[] stringArray = results = this.runSupportProcedure("ds_oea06.p", "", "%" + startupParam).split(",");
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            String result = stringArray[n2];
            if (result.split("=")[0].equals("2")) {
                if (result.split("=").length == 1 || !result.split("=")[1].contains(startupParam) && !result.split("=")[1].contains("Unknown")) {
                    return this.runSupportProcedure("ds_oea15.p", startupParam);
                }
                return defaultValue;
            }
            ++n2;
        }
        return defaultValue;
    }

    public boolean isproALPHAAvailable() {
        return this.proALPHAAvailable;
    }

    public IProject getProject() {
        return this.oeProject.getProject();
    }
}

