/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.repository;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.AbstractproALPHAConnector;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import java.io.File;
import java.util.Hashtable;

public class RepositoryInformationsImpl
extends AbstractproALPHAConnector
implements RepositoryInformations {
    public RepositoryInformationsImpl(IOpenEdgeProject oeproject) throws ProALPHANotAvailableException {
        super(oeproject);
    }

    public RepositoryInformationsImpl(RunProgramInPa paBridge) {
        super(paBridge);
    }

    @Override
    public Boolean exitsInstanceInRepository(String instanceName) {
        return this.runSupportProcedure("ds_oea12.p", instanceName).equals("yes");
    }

    @Override
    public Boolean exitsTableInRepository(String tableName) {
        return this.runSupportProcedure("ds_oea29.p", tableName).endsWith("yes");
    }

    @Override
    public String getAbsolutPath(String fileName) {
        String projectRoot = new File(".").getAbsolutePath();
        return this.runSupportProcedure("ds_oea02.p", projectRoot, fileName);
    }

    @Override
    public String getClassName(String classOID) {
        return this.runSupportProcedure("ds_oea11.p", classOID, "DRC_Class_ID");
    }

    @Override
    public String getClassInformation(String drcClassObj, String request) {
        return this.runSupportProcedure("ds_oea11.p", drcClassObj, request);
    }

    @Override
    public String getClassOBJ(String fileName) {
        return this.runSupportProcedure("ds_oea10.p", fileName, "DRC_Class_Obj");
    }

    @Override
    public String getInstanceID(String instanceObj) {
        return this.runSupportProcedure("ds_oea46.p", instanceObj, "DRC_Instance_ID");
    }

    @Override
    public String getInstanceObj(String fileName) {
        return this.runSupportProcedure("ds_oea48.p", fileName, "DRC_Instance_Obj");
    }

    @Override
    public String getClassGroupOf(String className) {
        return this.getClassInformation(className, "ClassGroupCode");
    }

    @Override
    public String getListOfTableFields(String tableName) {
        return this.runSupportProcedure("ds_oea28.p", tableName, "ListOfFieldNames");
    }

    @Override
    public String getListOFSubClasses(String rootClass) {
        return this.getClassInformation(rootClass, "ListOfSubClasses");
    }

    @Override
    public String getMessageText(String messageCode, String text) {
        return this.runSupportProcedure("ds_oea16.p", messageCode, text);
    }

    @Override
    public String getModule(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("ModulName", this.getProductName(fileName));
        selection.put("Kennbuchstabe", fileName.substring(1, 2));
        return this.getRecordField("D_UnterModul", selection, "UnterModulName");
    }

    @Override
    public String getModuleDescription(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("ModulName", this.getProductName(fileName));
        selection.put("UnterModulName", this.getModule(fileName));
        selection.put("Sprache", "###Language###");
        return this.getRecordField("D_UnterModulSpr", selection, "Bezeichnung");
    }

    @Override
    public String getProductDescription(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("ModulName", this.getProductName(fileName));
        selection.put("Sprache", "###Language###");
        return this.getRecordField("D_ModulSpr", selection, "Bezeichnung");
    }

    @Override
    public String getProductName(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("Kennbuchstabe", fileName.substring(0, 1));
        return this.getRecordField("D_Modul", selection, "ModulName");
    }

    @Override
    public String getProgramShortDesc(String fileName) {
        return this.runSupportProcedure("ds_oea10.p", fileName, "ShortDesc1");
    }

    @Override
    public String getRelativePath(String fileName) {
        return this.runSupportProcedure("ds_oea13.p", fileName);
    }

    @Override
    public String getTableCompanyInclude(String tableName) {
        return this.getTableInformation(tableName, "CompanyInclude");
    }

    @Override
    public String getTableInformation(String tableName, String request) {
        return this.runSupportProcedure("ds_oea28.p", tableName, request);
    }

    @Override
    public Object isInstanceOfClass(String instance, String className) {
        return this.runSupportProcedure("ds_oea52.p", instance, className);
    }

    @Override
    public boolean isObjectBlockable(String fileName) {
        return this.runSupportProcedure("ds_oea10.p", fileName, "blockable").equals("yes");
    }

    @Override
    public RunProgramInPa getPaBridge() {
        return this.getBridge();
    }
}

