/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharsetConverter {
    private static final Logger logger = LoggerFactory.getLogger(CharsetConverter.class);

    private CharsetConverter() {
    }

    public static String encode(String codepage, String str) {
        String retval;
        block4: {
            retval = str;
            try {
                if (codepage == null) break block4;
                if (Charset.isSupported(codepage)) {
                    retval = CharsetConverter.doEncoding(codepage, str);
                    break block4;
                }
                if (Charset.isSupported("cp" + codepage)) {
                    retval = CharsetConverter.doEncoding("cp" + codepage, str);
                    break block4;
                }
                throw new UnsupportedEncodingException(String.format("Codepage %s is not supported.", codepage));
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return retval;
    }

    private static String doEncoding(String codepage, String str) {
        return new String(Charset.forName(codepage).encode(str).array());
    }
}

