/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.utils;

import com.proalpha.pds.paconnector.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginRequirementsCheck {
    private final Logger logger = LoggerFactory.getLogger(PluginRequirementsCheck.class);
    private final String versionRegex = "([a-zA-Z0-9._-]+)\\s*([0-9]+(?:\\.[0-9]+){0,2}(?:\\.[a-zA-z0-9]+)?)(?:\\s+[a-zA-Z/].*?)?";
    HashMap<String, String> pyPackageVersions = new HashMap();
    HashMap<String, String> softwareVersions = new HashMap();

    public PluginRequirementsCheck() {
        this.softwareVersions.put("Python", "3.10.7");
        this.pyPackageVersions.put("pa-installer", "1.0.0");
        this.pyPackageVersions.put("pa-common", "1.0.169");
    }

    public void checkPluginRequirements(Boolean force) {
        if (force.booleanValue() || Activator.getDefault().getPreferenceStore().getBoolean("EnablePaPdsPythonPlugins")) {
            if (!this.checkPython().booleanValue()) {
                Activator.getDefault().getPreferenceStore().setValue("EnablePaPdsPythonPlugins", false);
                String message = String.format("Python is either not installed or has an insufficient version. The python components of the proALPHA PDS plugins have been deactivated!\n\nIf you want to use these components, please install python version %s or greater and reenable them in the PDS Preferences:\n\npA Settings -> Enable proALPHA PDS Python plugins", this.softwareVersions.get("Python"));
                Display.getDefault().asyncExec(() -> MessageDialog.openWarning(null, (String)"Missing proALPHA PDS Plugin Requirement", (String)message));
            } else if (!this.checkPythonPackages().booleanValue()) {
                String message = "Insufficient version of proALPHA python packages found. Functionality of PDS plugins may be limited!\nPlease either update the python packages by executing\n\npython -m pip install pa_common pa_installer --upgrade --upgrade-strategy=eager\n\nin a command line started with administrator rights or disable them in the PDS preferences:\n\npA Settings -> Enable proALPHA PDS Python plugins";
                Display.getDefault().asyncExec(() -> MessageDialog.openWarning(null, (String)"Missing proALPHA PDS Plugin Requirement", (String)"Insufficient version of proALPHA python packages found. Functionality of PDS plugins may be limited!\nPlease either update the python packages by executing\n\npython -m pip install pa_common pa_installer --upgrade --upgrade-strategy=eager\n\nin a command line started with administrator rights or disable them in the PDS preferences:\n\npA Settings -> Enable proALPHA PDS Python plugins"));
            }
        }
    }

    public Boolean checkPython() {
        Boolean checkResult = false;
        HashMap<String, String> pythonVersion = this.getVersionInfo(new ArrayList<String>(Arrays.asList("python", "--version")), "([a-zA-Z0-9._-]+)\\s*([0-9]+(?:\\.[0-9]+){0,2}(?:\\.[a-zA-z0-9]+)?)(?:\\s+[a-zA-Z/].*?)?");
        if (!pythonVersion.isEmpty()) {
            String currentVersion = pythonVersion.get("Python");
            String requiredVersion = this.softwareVersions.get("Python");
            checkResult = this.checkVersionStringGreaterOrEqual(currentVersion, requiredVersion, "\\.", true);
            this.logger.debug(String.format("Python installed in version %s and required in version %s", currentVersion, requiredVersion));
        }
        return checkResult;
    }

    public Boolean checkPythonPackages() {
        Boolean checkResult = false;
        HashMap<String, String> currentPythonModules = this.getVersionInfo(new ArrayList<String>(Arrays.asList("python", "-m", "pip", "list")), "([a-zA-Z0-9._-]+)\\s*([0-9]+(?:\\.[0-9]+){0,2}(?:\\.[a-zA-z0-9]+)?)(?:\\s+[a-zA-Z/].*?)?");
        if (!currentPythonModules.isEmpty()) {
            for (String pymodname : this.pyPackageVersions.keySet()) {
                String currentVersion = currentPythonModules.get(pymodname);
                String requiredVersion = this.pyPackageVersions.get(pymodname);
                checkResult = this.checkVersionStringGreaterOrEqual(currentVersion, requiredVersion, "\\.", true);
                this.logger.debug(String.format("Package %s installed in version %s and required in version %s", pymodname, currentVersion, requiredVersion));
                if (!checkResult.booleanValue()) break;
            }
        }
        return checkResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, String> getVersionInfo(List<String> command, String regex) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(regex, 8);
        builder.command(command);
        try {
            Process p;
            block16: {
                this.logger.info(String.format("Query version info. Calling '%s'", String.join((CharSequence)" ", builder.command())));
                p = builder.start();
                Throwable throwable = null;
                Object var8_10 = null;
                try {
                    InputStreamReader streamReaderStdOut = new InputStreamReader(p.getInputStream());
                    try {
                        try (BufferedReader buffStdOut = new BufferedReader(streamReaderStdOut);){
                            String line;
                            do {
                                Matcher m;
                                if ((line = buffStdOut.readLine()) == null || !(m = pattern.matcher(line.trim())).matches()) continue;
                                result.put(m.group(1).trim(), m.group(2).trim());
                                this.logger.debug(String.format("Added %s - %s to result", m.group(1).trim(), m.group(2).trim()));
                            } while (line != null);
                        }
                        if (streamReaderStdOut == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (streamReaderStdOut == null) throw throwable;
                        ((Reader)streamReaderStdOut).close();
                        throw throwable;
                    }
                    ((Reader)streamReaderStdOut).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            Integer processExitCode = p.waitFor();
            if (processExitCode == 0) return result;
            this.logger.error(String.format("Process exited with exitcode %d", processExitCode));
            return result;
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getStackTrace().toString());
            result.clear();
        }
        return result;
    }

    private Boolean checkVersionStringGreaterOrEqual(String currentVersion, String requiredVersion, String delimiter, Boolean checkLength) {
        Boolean checkResult = true;
        if (currentVersion == null) {
            checkResult = false;
        } else {
            String[] currentVersionArray = currentVersion.split(delimiter);
            String[] requiredVersionArray = requiredVersion.split(delimiter);
            if (checkLength.booleanValue() && currentVersionArray.length != requiredVersionArray.length) {
                checkResult = false;
            } else {
                Integer loopLength = Math.min(currentVersionArray.length, requiredVersionArray.length);
                Integer i = 0;
                while (i < loopLength) {
                    try {
                        Integer currentPart = Integer.parseInt(currentVersionArray[i]);
                        Integer requiredPart = Integer.parseInt(requiredVersionArray[i]);
                        if (currentPart > requiredPart) break;
                        if (currentPart < requiredPart) {
                            checkResult = false;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.logger.error(String.format("Cannot compare versions %s and %s as integers", currentVersion, requiredVersion));
                        checkResult = false;
                    }
                    i = i + 1;
                }
            }
        }
        return checkResult;
    }
}

