/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static void storeProperties(Properties properties, File outputFile) throws IOException {
        if (!outputFile.exists()) {
            File parentDir = outputFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            outputFile.createNewFile();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            properties.store(out, "");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Properties loadProperties(File file) throws IOException {
        Properties properties = new Properties();
        if (file == null) {
            throw new IllegalArgumentException("Properties file is null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("%s file does not exits or is null.", file.getAbsolutePath()));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream reader = new FileInputStream(file);){
            properties.load(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return properties;
    }
}

