/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf;

import com.proalpha.pds.projconf.configure.ConfigurePdsProject;
import com.proalpha.pds.projconf.importwizards.ReadDemasFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurePdsProjectTest {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurePdsProjectTest.class);
    private static final String RES_DIR = String.valueOf(System.getProperty("user.dir")) + "\\test\\resources";
    private ConfigurePdsProject testProject;
    private ReadDemasFile propertiesFile;

    @Before
    public void setUp() {
        this.propertiesFile = new ReadDemasFile(String.valueOf(RES_DIR) + "\\PDSconfig.properties");
        this.testProject = new ConfigurePdsProject(this.propertiesFile);
    }

    @After
    public void tearDown() {
        this.testProject = null;
    }

    @Test
    public void test() {
        try {
            this.testProject.installPaProject((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.toString());
        }
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        for (IProject p : projects) {
            System.out.println(p.getName());
            if (!p.getName().equals("proalpha-de-72b00-dev")) continue;
            Assert.assertEquals((Object)"proalpha-de-72b00-dev", (Object)p.getName());
            return;
        }
    }

    @Test
    public void checkRepositoryUrlIsSet() throws CoreException, IOException {
        this.testProject.configureMylyn("http://wei-vsjira01:8080", "proAlpha", this.propertiesFile.getJiraProject(), "testUser", "Mir zugewiesene Vorg\u00e4nge");
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<String> repositoryUrlSet = new HashSet<String>();
        for (TaskRepository taskRepository : repositories) {
            repositoryUrlSet.add(taskRepository.getRepositoryUrl());
        }
        String expected = "http://wei-vsjira01:8080";
        Assert.assertTrue((boolean)repositoryUrlSet.contains(expected));
    }

    @Test
    public void checkRepositoryLabelIsSet() throws CoreException, IOException {
        this.testProject.configureMylyn(this.propertiesFile.getJiraUrl(), "proAlpha", "proALPHA JIRA", "testUser", "Mir zugewiesene Vorg\u00e4nge");
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<String> repositoryLabelSet = new HashSet<String>();
        for (TaskRepository taskRepository : repositories) {
            repositoryLabelSet.add(taskRepository.getRepositoryLabel());
        }
        String expected = "proALPHA JIRA";
        Assert.assertTrue((boolean)repositoryLabelSet.contains(expected));
    }

    @Test
    public void checkRepositoryCategoryIsSet() {
        this.testProject.configureMylyn(this.propertiesFile.getJiraUrl(), "proAlpha", this.propertiesFile.getJiraProject(), "testUser", "Mir zugewiesene Vorg\u00e4nge");
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<String> repositoryCategorySet = new HashSet<String>();
        for (TaskRepository taskRepository : repositories) {
            repositoryCategorySet.add(taskRepository.getCategory());
        }
        String expected = "proAlpha";
        Assert.assertTrue((boolean)repositoryCategorySet.contains(expected));
    }

    @Test
    public void checkRepositoryCredentialsAreSet() {
        this.testProject.configureMylyn(this.propertiesFile.getJiraUrl(), "proAlpha", this.propertiesFile.getJiraProject(), "testUser", "Mir zugewiesene Vorg\u00e4nge");
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<AuthenticationCredentials> credentialsSet = new HashSet<AuthenticationCredentials>();
        for (TaskRepository taskRepository : repositories) {
            credentialsSet.add(taskRepository.getCredentials(AuthenticationType.REPOSITORY));
        }
        String expectedUsername = "testUser";
        String expectedPassword = "";
        if (credentialsSet.size() != 1) {
            Assert.fail((String)"There must be only one authentication credentials set!");
        }
        for (AuthenticationCredentials authenticationCredentials : credentialsSet) {
            Assert.assertEquals((Object)expectedUsername, (Object)authenticationCredentials.getUserName());
            Assert.assertEquals((Object)expectedPassword, (Object)authenticationCredentials.getPassword());
        }
    }

    @Test
    public void checkRepositoryIsAdded() {
        String repositoryUrl = "http://wei-vsjira01:8080";
        String category = "proAlpha";
        String userName = "testUser";
        String repositorySummary = "Mir zugewiesene Vorg\u00e4nge";
        this.testProject.configureMylyn(repositoryUrl, category, this.propertiesFile.getJiraProject(), userName, repositorySummary);
        TaskRepository expected = new TaskRepository("jira", repositoryUrl);
        expected.setCategory(category);
        expected.setRepositoryLabel(this.propertiesFile.getJiraProject());
        expected.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(expected);
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        for (TaskRepository actual : repositories) {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void checkRepositoryIsAddedOnlyOnce() {
        String category = "proAlpha";
        String userName = "testUser";
        String repositorySummary = "Mir zugewiesene Vorg\u00e4nge";
        this.testProject.configureMylyn(this.propertiesFile.getJiraUrl(), category, this.propertiesFile.getJiraProject(), userName, repositorySummary);
        TaskRepository expected = new TaskRepository("jira", this.propertiesFile.getJiraUrl());
        expected.setCategory(category);
        expected.setRepositoryLabel(this.propertiesFile.getJiraProject());
        expected.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(expected);
        TasksUi.getRepositoryManager().addRepository(expected);
        List repositories = TasksUi.getRepositoryManager().getAllRepositories();
        int repositoryCounter = 0;
        for (TaskRepository actual : repositories) {
            if (actual.getUrl() != this.propertiesFile.getJiraUrl()) continue;
            ++repositoryCounter;
        }
        int expectedRepositoryCounter = 1;
        Assert.assertEquals((long)expectedRepositoryCounter, (long)repositoryCounter);
    }

    @Test
    public void checkRepositoryQueryAddedMoreThenOnceThrowsException() {
        String category = "proAlpha";
        String userName = "testUser";
        String repositorySummary = "Mir zugewiesene Vorg\u00e4nge";
        this.testProject.configureMylyn(this.propertiesFile.getJiraUrl(), category, this.propertiesFile.getJiraProject(), userName, repositorySummary);
        TaskRepository repository = new TaskRepository("jira", this.propertiesFile.getJiraUrl());
        repository.setCategory(category);
        repository.setRepositoryLabel(this.propertiesFile.getJiraProject());
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(repository);
        RepositoryQuery repQuery = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(repository);
        repQuery.setSummary(repositorySummary);
        TasksUiPlugin.getTaskList().addQuery(repQuery);
        try {
            TasksUiPlugin.getTaskList().addQuery(repQuery);
        }
        catch (Exception actual) {
            Assert.assertTrue((boolean)(actual instanceof IllegalArgumentException));
        }
    }

    @Test
    public void checkRepositoryQuerySummaryIsSet() {
        String category = "proAlpha";
        String userName = "testUser";
        String expected = "Mir zugewiesene Vorg\u00e4nge";
        this.testProject.configureMylyn(this.propertiesFile.getJiraUrl(), category, this.propertiesFile.getJiraProject(), userName, expected);
        TaskRepository repository = new TaskRepository("jira", this.propertiesFile.getJiraUrl());
        repository.setCategory(category);
        repository.setRepositoryLabel(this.propertiesFile.getJiraProject());
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(repository);
        RepositoryQuery repQuery = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(repository);
        repQuery.setSummary(expected);
        TasksUiPlugin.getTaskList().addQuery(repQuery);
        Set repQueries = TasksUiPlugin.getTaskList().getRepositoryQueries(this.propertiesFile.getJiraUrl());
        for (RepositoryQuery repositoryQuery : repQueries) {
            Assert.assertEquals((Object)expected, (Object)repositoryQuery.getSummary());
        }
    }
}

