/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.utils;

import com.openedge.pdt.platform.PlatformSupport;
import com.openedge.pdt.platform.Proversion;
import com.proalpha.pds.projconf.utils.ProgressUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ProgressUtilsTest {
    private ProgressUtils progressUtils;
    @Mock
    private PlatformSupport platformSupport;
    @Mock
    private Proversion proversion;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.progressUtils = new ProgressUtils(this.platformSupport);
        Mockito.when((Object)this.platformSupport.getProversions()).thenReturn((Object)new Proversion[]{this.proversion});
    }

    @Test
    public void getProgressVersionReturnsNotNullAndNoEmptyString() {
        Mockito.when((Object)this.proversion.getVersion()).thenReturn((Object)"Testversion");
        Assert.assertFalse((String)"Empty version!", (boolean)this.proversion.getVersion().isEmpty());
        Assert.assertNotEquals((String)"Version is null!", null, (Object)this.proversion);
    }

    @Test
    public void getOpenEdgeEditorVersionReturnsNotNullAndNoEmptyString() {
        String openEdgeEditorVersion = this.progressUtils.getOpenEdgeEditorVersion();
        Assert.assertFalse((String)"Empty version!", (boolean)openEdgeEditorVersion.isEmpty());
        Assert.assertNotEquals((String)"Version is null!", null, (Object)openEdgeEditorVersion);
    }

    @Test
    public void getOpenEdgeVersionWithMinorReturns11_7() {
        Assert.assertEquals((String)"OEVersion with minor should be 11.7", (Object)"11.7", (Object)this.progressUtils.getOpenEdgeVersionWithMinor());
    }

    @Test
    public void getOpenEdgeVersionWithMicroReturns11_7_2() {
        Assert.assertEquals((String)"OEVersion with micro should be 11.7.2", (Object)"11.7.2", (Object)this.progressUtils.getOpenEdgeVersionWithMicro());
    }
}

