/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.generator.BalpGenerator;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.generator.OOABLInterfaceFileGenerator;
import com.proalpha.pds.generator.TriggerFileGenerator;
import com.proalpha.pds.generator.UserExitFileGenerator;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryFactory;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.userexit.UserExitDelegate;
import com.proalpha.pds.paconnector.userexit.UserExitFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import org.eclipse.core.resources.ResourcesPlugin;

public class GeneratorFactory {
    OEProject oeproject = (OEProject)ResourcesPlugin.getWorkspace().getRoot().getProject();
    RunProgramInPa bridge;
    static RepositoryDelegate repositoryDelegate;
    static RepositoryInformations repositoryInformations;
    static StartparameterReader startparameterReader;
    static UserExitDelegate userExitDelegate;

    public GeneratorFactory() {
        try {
            this.bridge = new RunProgramInPa((IOpenEdgeProject)this.oeproject);
            repositoryDelegate = RepositoryFactory.createRepositoryDelegate((OEProject)this.oeproject);
            repositoryInformations = RepositoryFactory.createRepositoryInformations((OEProject)this.oeproject);
            startparameterReader = ParameterFactory.createStartparameterReader((OEProject)this.oeproject);
            userExitDelegate = UserExitFactory.createUserExitDelegate((OEProject)this.oeproject, (StartparameterReader)startparameterReader);
        }
        catch (ProALPHANotAvailableException e) {
            e.printStackTrace();
        }
    }

    public static BalpGenerator createBalpGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        UserExitDelegate userExitDelegate = GeneratorFactory.getUserExitDelegate();
        StartparameterReader startparameterReader = GeneratorFactory.getStartparameterReader();
        return new BalpGenerator(datacontainer, userExitDelegate, startparameterReader);
    }

    public static OOABLExitFileGenerator createOOABLExitFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName) {
        RepositoryDelegate repositoryDelegate = GeneratorFactory.getRepositoryDelegate();
        RepositoryInformations repositoryInformations = GeneratorFactory.getRepositoryInformations();
        return new OOABLExitFileGenerator(datacontainer, templateGeneratorName, repositoryDelegate, repositoryInformations);
    }

    public static OOABLInterfaceFileGenerator createOOABLInterfaceFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName) {
        RepositoryDelegate repositoryDelegate = GeneratorFactory.getRepositoryDelegate();
        RepositoryInformations repositoryInformations = GeneratorFactory.getRepositoryInformations();
        return new OOABLInterfaceFileGenerator(datacontainer, templateGeneratorName, repositoryDelegate, repositoryInformations);
    }

    public static TriggerFileGenerator createTriggerFileGenerator(IGeneratorDataContainer datacontainer) {
        return new TriggerFileGenerator(datacontainer);
    }

    public static UserExitFileGenerator createUserExitFileGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        UserExitDelegate userExitDelegate = GeneratorFactory.getUserExitDelegate();
        return new UserExitFileGenerator(datacontainer, userExitDelegate);
    }

    private static RepositoryDelegate getRepositoryDelegate() {
        return repositoryDelegate;
    }

    private static RepositoryInformations getRepositoryInformations() {
        return repositoryInformations;
    }

    private static StartparameterReader getStartparameterReader() {
        return startparameterReader;
    }

    private static UserExitDelegate getUserExitDelegate() {
        return userExitDelegate;
    }
}

