/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.wizards.controller;

import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.repository.Dataset;
import com.proalpha.pds.templates.wizards.controller.paWizard;
import com.proalpha.pds.templates.wizards.wizardpages.DatasetDefinitionFilePropertyPage;
import com.proalpha.pds.templates.wizards.wizardpages.WizardpageFactory;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class DatasetDefinitionFile
extends paWizard
implements INewWizard {
    private DatasetDefinitionFilePropertyPage wizardPDSPropPage;

    public DatasetDefinitionFile() {
        try {
            this.setTemplateGenerator("pADatasetDefinitionFile");
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add("pds");
            this.setExtensionList(extensionList);
            this.setWizardTitle("proALPHA Dataset Definition File");
            this.setWizardDescription("This wizard creates a new proALPHA Dataset Definition File.");
            this.setCheckRepository(false);
            this.setParentClass("");
            this.setSupportRepositoryCreateButton(false);
            this.setThirdDigit("_");
            this.setCheckFileNameLength(true);
            this.setCheckLowerCase(true);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    @Override
    public void addPages() {
        try {
            this.wizardPDSPropPage = WizardpageFactory.createDatasetDefinitionFilePropertyPage();
            this.addPage((IWizardPage)this.wizardPDSPropPage);
        }
        catch (ProALPHANotAvailableException e) {
            throw new IllegalStateException(e);
        }
        super.addPages();
        this.wizardPDSPropPage.setWizardMainPage(this.wizardMainPage);
    }

    @Override
    protected boolean doFinish() {
        this.wizardSettings.putAll(this.wizardPDSPropPage.getSettings());
        if (this.wizardPDSPropPage.getCreateDataset()) {
            if (!this.getbridge().isproALPHAAvailable()) {
                this.wizardMainPage.setErrorMessage("pA not available");
                return false;
            }
            Dataset dataset = this.getRepositoryDelegate().getEmptyDataset();
            dataset.setName((String)this.wizardSettings.get("DatasetName"));
            dataset.setDescription((String)this.wizardSettings.get("Description"));
            dataset.setFileName((String)this.wizardSettings.get("FileName"));
            dataset.setBussinessEntityObject((String)this.wizardSettings.get("BusinessEntityObject"));
            dataset.setDataAccessObject((String)this.wizardSettings.get("DataAccessObject"));
            dataset.setDatabussinessEntityProxy((String)this.wizardSettings.get("BusinessEntityProxy"));
            dataset.setReadOnly((String)this.wizardSettings.get("ReadOnly"));
            dataset.setMasterDataValidation((String)this.wizardSettings.get("MasterDataValidation"));
            dataset.setGetChanges((String)this.wizardSettings.get("GetChanges"));
            if (!this.getRepositoryDelegate().createRepositoryEntryForDataset(dataset)) {
                this.wizardMainPage.setErrorMessage("Failed to create Repository Entry for Dataset \"" + this.wizardSettings.get("TableName") + "\"");
                return false;
            }
        }
        return super.doFinish();
    }
}

