/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.wizards.controller;

import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.templates.wizards.controller.paWizard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class OOABLForm
extends paWizard
implements INewWizard {
    private static final String CLASS_EXTENSION_CLS = "cls";
    private static final String OOABL_WIZARD_DESCRIPTION = "This wizard creates a new proALPHA OOABL Form File.";
    private static final String OOABL_WIZARD_TITLE = "proALPHA OOABL Form File";
    private static final String STD_CLASS_SUFFIX = "Std.";
    private static final String POINT_TO_CLASS_SUFFIX = ".";
    private static final String OOABL_STD_PARENTCLASS = "OOABL";
    private static final String STANDARD_LEVEL = "";
    private static final String C_DIGIT = "C";
    private String currentCustomLevel;
    private Boolean isGenerateUserExit;

    public OOABLForm() {
        try {
            ArrayList<String> ExtensionList = new ArrayList<String>();
            ExtensionList.add(CLASS_EXTENSION_CLS);
            this.setExtensionList(ExtensionList);
            this.setWizardTitle(OOABL_WIZARD_TITLE);
            this.setWizardDescription(OOABL_WIZARD_DESCRIPTION);
            this.setCheckRepository(true);
            this.setParentClass(OOABL_STD_PARENTCLASS);
            this.setSupportRepositoryCreateButton(true);
            this.setThirdDigit(C_DIGIT);
            this.setCheckFileNameLength(false);
            this.setCheckLowerCase(false);
            this.isGenerateUserExit = Boolean.FALSE;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    private Map<String, Object> cloneWizardSettings() {
        HashMap<String, Object> exitFileGeneratorSettings = new HashMap<String, Object>();
        for (Map.Entry entry : this.wizardSettings.entrySet()) {
            exitFileGeneratorSettings.put((String)entry.getKey(), entry.getValue());
        }
        return exitFileGeneratorSettings;
    }

    @Override
    protected boolean doFinish() {
        try {
            if (this.isGenerateUserExit.booleanValue()) {
                this.generateUserExitClassAndBalpEntry();
            } else {
                this.generatorMainClassAndStdClass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void generatorMainClassAndStdClass() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        if (fileName.endsWith("Std.cls")) {
            fileName = fileName.replace(STD_CLASS_SUFFIX, POINT_TO_CLASS_SUFFIX);
        }
        this.wizardSettings.put("FileName", fileName);
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel());
        this.setTemplateGenerator("pAOOABLClass");
        IGeneratorDataContainer datacontainer = DataContainerFactory.createDataContainer(this.cloneWizardSettings());
        OOABLExitFileGenerator oOABLClass = GeneratorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLForm");
        oOABLClass.generate();
        super.doFinish();
    }

    private void generateUserExitClassAndBalpEntry() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel());
        this.wizardSettings.put("CustomFileName", fileName);
        IGeneratorDataContainer datacontainer = DataContainerFactory.createDataContainer(this.wizardSettings);
        OOABLExitFileGenerator oOABLClass = GeneratorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdClass");
        oOABLClass.generateUserExitClassAndBalpEntry();
    }

    public void setCurrentCustomLevel(String currentCustomLevel) {
        this.currentCustomLevel = currentCustomLevel;
    }

    public String getCurrentCustomLevel() {
        if (this.currentCustomLevel != null && this.currentCustomLevel.length() > 0) {
            return this.currentCustomLevel;
        }
        return this.getStartparameterReader().getCurrentCustomLevel();
    }

    public void setIsGerateUserExit(Boolean value) {
        this.isGenerateUserExit = value;
    }
}

