/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.wizards.wizardpages;

import com.openedge.pdt.project.ui.ResourceSelectionDialog;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.wizards.wizardpages.IpaWizardPage;
import com.proalpha.pds.templates.wizards.wizardpages.WizardMainPage;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatasetDefinitionFilePropertyPage
extends WizardPage
implements IpaWizardPage {
    private Label label;
    private Button btnBEO;
    private Text businessEntityObjectText;
    private Button masterDataValidationToggle;
    private Button btnBEProxy;
    private Text businessEntityProxyText;
    private Button createRepositoryEntryToggle;
    private Button getChangesToggle;
    private Button readOnlyToggle;
    private Button recursiveStructureToggle;
    private Button btnDAO;
    private Text dataAccessObjectText;
    private Text dsNameText;
    private WizardMainPage wizardMainPage;
    private RepositoryInformations repositoryInformations;
    private RunProgramInPa bridge;

    public DatasetDefinitionFilePropertyPage(RepositoryDelegate repositoryDelegate, RepositoryInformations repositoryInformations) {
        super("DatasetDefinitionFilePropertyPage");
        this.setTitle("proALPHA Dataset Definition File");
        this.setDescription("Please enter Dataset Definition File specific Properties");
        this.repositoryInformations = repositoryInformations;
        this.bridge = this.repositoryInformations.getbridge();
        if (!this.bridge.isproALPHAAvailable()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Connect to version control failed", (String)"The version control is not available.");
            throw new IllegalStateException("Version control is not available");
        }
        repositoryDelegate.fillRepositoryCache();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        this.label = new Label(container, 0);
        this.label.setText("Dataset Name:");
        GridData ttNameTextLData = new GridData();
        ttNameTextLData.grabExcessHorizontalSpace = true;
        ttNameTextLData.horizontalAlignment = 4;
        ttNameTextLData.horizontalSpan = 2;
        this.dsNameText = new Text(container, 2052);
        this.dsNameText.setLayoutData((Object)ttNameTextLData);
        this.dsNameText.setToolTipText("Temp-Table Name");
        this.dsNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatasetDefinitionFilePropertyPage.this.dialogChanged();
            }
        });
        this.label = new Label(container, 0);
        this.label.setText("Business Entity Object:");
        GridData businessEntityObjectTextLData = new GridData();
        businessEntityObjectTextLData.grabExcessHorizontalSpace = true;
        businessEntityObjectTextLData.horizontalAlignment = 4;
        this.businessEntityObjectText = new Text(container, 2052);
        this.businessEntityObjectText.setLayoutData((Object)businessEntityObjectTextLData);
        this.businessEntityObjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatasetDefinitionFilePropertyPage.this.dialogChanged();
            }
        });
        this.btnBEO = new Button(container, 0x1000008);
        GridData btnBEOLData = new GridData();
        btnBEOLData.grabExcessHorizontalSpace = true;
        btnBEOLData.horizontalAlignment = 4;
        this.btnBEO.setLayoutData((Object)btnBEOLData);
        this.btnBEO.setText("Browse");
        this.btnBEO.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetDefinitionFilePropertyPage.this.handleBrowse(DatasetDefinitionFilePropertyPage.this.businessEntityObjectText);
            }
        });
        this.label = new Label(container, 0);
        this.label.setText("Data Access Object:");
        GridData DAOTextLData = new GridData();
        DAOTextLData.horizontalAlignment = 4;
        DAOTextLData.grabExcessHorizontalSpace = true;
        this.dataAccessObjectText = new Text(container, 2052);
        this.dataAccessObjectText.setLayoutData((Object)DAOTextLData);
        this.dataAccessObjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatasetDefinitionFilePropertyPage.this.dialogChanged();
            }
        });
        this.btnDAO = new Button(container, 0x1000008);
        GridData btnDAOLData = new GridData();
        btnDAOLData.horizontalAlignment = 4;
        btnDAOLData.grabExcessHorizontalSpace = true;
        this.btnDAO.setLayoutData((Object)btnDAOLData);
        this.btnDAO.setText("Browse");
        this.btnDAO.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetDefinitionFilePropertyPage.this.handleBrowse(DatasetDefinitionFilePropertyPage.this.dataAccessObjectText);
            }
        });
        this.label = new Label(container, 0);
        this.label.setText("Business Entity Proxy:");
        GridData businessEntityProxyTextLData = new GridData();
        businessEntityProxyTextLData.grabExcessHorizontalSpace = true;
        businessEntityProxyTextLData.horizontalAlignment = 4;
        this.businessEntityProxyText = new Text(container, 2052);
        this.businessEntityProxyText.setLayoutData((Object)businessEntityProxyTextLData);
        this.businessEntityProxyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatasetDefinitionFilePropertyPage.this.dialogChanged();
            }
        });
        this.btnBEProxy = new Button(container, 0x1000008);
        this.btnBEProxy.setText("Browse");
        GridData button1LData = new GridData();
        button1LData.horizontalAlignment = 4;
        button1LData.grabExcessHorizontalSpace = true;
        button1LData.heightHint = 23;
        this.btnBEProxy.setLayoutData((Object)button1LData);
        this.btnBEProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DatasetDefinitionFilePropertyPage.this.handleBrowse(DatasetDefinitionFilePropertyPage.this.businessEntityProxyText);
            }
        });
        this.label = new Label(container, 0);
        this.masterDataValidationToggle = new Button(container, 16416);
        GridData masterDataValidationToggleLData = new GridData();
        masterDataValidationToggleLData.horizontalAlignment = 4;
        masterDataValidationToggleLData.horizontalSpan = 2;
        masterDataValidationToggleLData.grabExcessHorizontalSpace = true;
        this.masterDataValidationToggle.setLayoutData((Object)masterDataValidationToggleLData);
        this.masterDataValidationToggle.setText("Master Data Validation");
        this.label = new Label(container, 0);
        this.recursiveStructureToggle = new Button(container, 16416);
        GridData recursiveStructureToggleLData = new GridData();
        recursiveStructureToggleLData.horizontalAlignment = 4;
        recursiveStructureToggleLData.grabExcessHorizontalSpace = true;
        recursiveStructureToggleLData.horizontalSpan = 2;
        this.recursiveStructureToggle.setLayoutData((Object)recursiveStructureToggleLData);
        this.recursiveStructureToggle.setText("Recursive Structure");
        this.label = new Label(container, 0);
        this.readOnlyToggle = new Button(container, 16416);
        GridData readOnlyToggleLData = new GridData();
        readOnlyToggleLData.horizontalAlignment = 4;
        readOnlyToggleLData.grabExcessHorizontalSpace = true;
        readOnlyToggleLData.horizontalSpan = 2;
        this.readOnlyToggle.setLayoutData((Object)readOnlyToggleLData);
        this.readOnlyToggle.setText("Read Only");
        this.label = new Label(container, 0);
        this.getChangesToggle = new Button(container, 16416);
        GridData getChangesToggleLData = new GridData();
        getChangesToggleLData.horizontalAlignment = 4;
        getChangesToggleLData.grabExcessHorizontalSpace = true;
        getChangesToggleLData.horizontalSpan = 2;
        this.getChangesToggle.setLayoutData((Object)getChangesToggleLData);
        this.getChangesToggle.setText("Get Changes");
        this.label = new Label(container, 0);
        this.createRepositoryEntryToggle = new Button(container, 16416);
        GridData createRepositoryEntryToggleLData = new GridData();
        createRepositoryEntryToggleLData.horizontalSpan = 2;
        this.createRepositoryEntryToggle.setLayoutData((Object)createRepositoryEntryToggleLData);
        this.createRepositoryEntryToggle.setText("Create Repository Entry");
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void handleBrowse(Text TextObject) {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), "Please select Object");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            TextObject.setText(dialog.getResource().getName());
        }
    }

    private void dialogChanged() {
        String daoTemp;
        String dsName = this.dsNameText.getText();
        String beo = this.businessEntityObjectText.getText();
        String dao = this.dataAccessObjectText.getText();
        String bep = this.businessEntityProxyText.getText();
        if (!dsName.startsWith("ds")) {
            this.updateStatus("Dataset Name should begin with 'ds'");
            return;
        }
        if (beo.equals("")) {
            this.updateStatus("Business Entity Object is empty");
            return;
        }
        if (!this.repositoryInformations.exitsInstanceInRepository(beo).booleanValue()) {
            this.updateStatus("Business Entity Object is unknown to Repository Manager");
            return;
        }
        if (!this.bridge.getProALPHAVersion().startsWith("5.1") && !this.repositoryInformations.isInstanceOfClass(beo, "Business Entity Object").equals("yes")) {
            this.updateStatus("Business Entity Object should be member of Class \"Business Entity Object\"");
            return;
        }
        if (dao.equals("") && this.repositoryInformations.exitsInstanceInRepository(daoTemp = String.valueOf(beo.substring(0, 2)) + "j" + beo.substring(3)).booleanValue()) {
            this.dataAccessObjectText.setText(daoTemp);
            dao = this.dataAccessObjectText.getText();
        }
        if (dao.equals("")) {
            this.updateStatus("Data Access Object is empty");
            return;
        }
        if (!this.repositoryInformations.exitsInstanceInRepository(dao).booleanValue()) {
            this.updateStatus("Data Access Object is unknown to Repository Manager");
            return;
        }
        if (!this.bridge.getProALPHAVersion().startsWith("5.1") && !this.repositoryInformations.isInstanceOfClass(dao, "Data Access Object").equals("yes")) {
            this.updateStatus("Data Access Object should be member of Class \"Data Access Object\"");
            return;
        }
        if (!bep.equals("")) {
            if (!this.repositoryInformations.exitsInstanceInRepository(bep).booleanValue()) {
                this.updateStatus("Business Entity Proxy is unknown to Repository Manager");
                return;
            }
            if (!this.bridge.getProALPHAVersion().startsWith("5.1") && !this.repositoryInformations.isInstanceOfClass(bep, "Business Entity Proxy").equals("yes")) {
                this.updateStatus("Business Entity Proxy should be member of Class \"Business Entity Proxy\"");
                return;
            }
        }
        this.wizardMainPage.setFileDescriptionText("Definition of Dataset " + dsName);
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void initialize() {
        this.dsNameText.setText("ds");
        this.masterDataValidationToggle.setSelection(true);
        this.readOnlyToggle.setSelection(false);
        this.recursiveStructureToggle.setSelection(false);
        this.getChangesToggle.setSelection(true);
        if (this.bridge.getProALPHAVersion().startsWith("5.1")) {
            this.createRepositoryEntryToggle.setVisible(false);
        } else {
            this.createRepositoryEntryToggle.setSelection(true);
        }
        if (this.bridge.getProALPHAVersion().startsWith("5.1") || this.bridge.getProALPHAVersion().startsWith("5.2")) {
            this.recursiveStructureToggle.setVisible(true);
        } else {
            this.recursiveStructureToggle.setVisible(false);
        }
    }

    public void setWizardMainPage(WizardMainPage wizardMainPage) {
        this.wizardMainPage = wizardMainPage;
    }

    @Override
    public HashMap<String, Object> getSettings() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        wizardSettings.put("DatasetName", this.getDSName());
        wizardSettings.put("BusinessEntityObject", this.getBusinessEntityObject());
        wizardSettings.put("DataAccessObject", this.getDataAccessObject());
        wizardSettings.put("BusinessEntityProxy", this.getBusinessEntityProxy());
        wizardSettings.put("MasterDataValidation", this.getMasterDataValidation() ? "true" : "false");
        wizardSettings.put("RecursiveStructure", this.getRecursiveStructure() ? "true" : "false");
        wizardSettings.put("ReadOnly", this.getReadOnly() ? "true" : "false");
        wizardSettings.put("GetChanges", this.getGetChanges() ? "true" : "false");
        return wizardSettings;
    }

    private String getBusinessEntityProxy() {
        if (this.businessEntityProxyText.getText().equals("")) {
            return "";
        }
        return String.valueOf(this.repositoryInformations.getRelativePath(this.businessEntityProxyText.getText())) + "/" + this.businessEntityProxyText.getText();
    }

    private boolean getGetChanges() {
        return this.getChangesToggle.getSelection();
    }

    private boolean getReadOnly() {
        return this.readOnlyToggle.getSelection();
    }

    private boolean getRecursiveStructure() {
        return this.recursiveStructureToggle.getSelection();
    }

    private boolean getMasterDataValidation() {
        return this.masterDataValidationToggle.getSelection();
    }

    private String getDataAccessObject() {
        return String.valueOf(this.repositoryInformations.getRelativePath(this.dataAccessObjectText.getText())) + "/" + this.dataAccessObjectText.getText();
    }

    private String getBusinessEntityObject() {
        return String.valueOf(this.repositoryInformations.getRelativePath(this.businessEntityObjectText.getText())) + "/" + this.businessEntityObjectText.getText();
    }

    private String getDSName() {
        return this.dsNameText.getText();
    }

    public boolean getCreateDataset() {
        return this.createRepositoryEntryToggle.getSelection();
    }
}

