/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.wizards.wizardpages;

import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.wizards.wizardpages.IpaWizardPage;
import com.proalpha.pds.templates.wizards.wizardpages.WizardMainPage;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TempTableDefinitionFilePropertyPage
extends WizardPage
implements IpaWizardPage {
    private Label label;
    private Button noundoToggle;
    private Button beforeTableToggle;
    private Button isReferenceOnly;
    private Text likeTableText;
    private Button likeDBTableToggle;
    private Text ttNameText;
    private WizardMainPage wizardMainPage;
    private final RepositoryInformations repositoryInformations;

    public TempTableDefinitionFilePropertyPage(RepositoryInformations repositoryInformations) {
        super("TempTableDefinitionFilePropertyPage");
        this.setTitle("proALPHA Temp-Table Definition File");
        this.setDescription("Please enter Temp-Table Definition File specific Properties");
        this.repositoryInformations = repositoryInformations;
        RunProgramInPa bridge = this.repositoryInformations.getbridge();
        if (!bridge.isproALPHAAvailable()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Connect to version control failed", (String)"The version control is not available.");
            throw new IllegalStateException("Version control is not available");
        }
    }

    public RepositoryInformations getRepositoryInformations() {
        return this.repositoryInformations;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.label = new Label(container, 0);
        this.label.setText("Temp-Table Name:");
        GridData ttNameTextLData = new GridData();
        ttNameTextLData.grabExcessHorizontalSpace = true;
        ttNameTextLData.horizontalAlignment = 4;
        this.ttNameText = new Text(container, 2052);
        this.ttNameText.setLayoutData((Object)ttNameTextLData);
        this.ttNameText.setToolTipText("Temp-Table Name");
        this.ttNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TempTableDefinitionFilePropertyPage.this.ttNameText.getText().length() > 2 && TempTableDefinitionFilePropertyPage.this.repositoryInformations.exitsTableInRepository(TempTableDefinitionFilePropertyPage.this.ttNameText.getText().substring(2)).booleanValue()) {
                    TempTableDefinitionFilePropertyPage.this.likeTableText.setText(TempTableDefinitionFilePropertyPage.this.repositoryInformations.getTableInformation(TempTableDefinitionFilePropertyPage.this.ttNameText.getText(), "DRC_Table_ID"));
                }
                TempTableDefinitionFilePropertyPage.this.dialogChanged();
            }
        });
        this.label = new Label(container, 0);
        this.noundoToggle = new Button(container, 16416);
        GridData noundoToggleLData = new GridData();
        noundoToggleLData.horizontalSpan = 2;
        this.noundoToggle.setText("no-undo");
        this.noundoToggle.setToolTipText("Define Temp-Table with the \"no-undo\" option?");
        this.label = new Label(container, 0);
        this.beforeTableToggle = new Button(container, 16416);
        GridData beforetabletoggeLData = new GridData();
        beforetabletoggeLData.horizontalSpan = 2;
        this.beforeTableToggle.setText("has Before Table");
        this.beforeTableToggle.setToolTipText("Define Temp-Table with the \"before-table\" option? (This should be used for Temp-Tables in ProDataSets only)");
        this.label = new Label(container, 0);
        this.isReferenceOnly = new Button(container, 16416);
        GridData isReferenceOnlyLData = new GridData();
        isReferenceOnlyLData.horizontalSpan = 2;
        this.isReferenceOnly.setText("reference-only");
        this.isReferenceOnly.setToolTipText("Define Temp-Table with the \"reference-only\" option?");
        this.label = new Label(container, 0);
        this.likeDBTableToggle = new Button(container, 16416);
        GridData liketoggleLData = new GridData();
        liketoggleLData.horizontalSpan = 2;
        this.likeDBTableToggle.setText("like Database Table");
        this.likeDBTableToggle.setToolTipText("Define Temp-Table \"like\" an already existing Database Table?");
        this.likeDBTableToggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TempTableDefinitionFilePropertyPage.this.likeTableText.setEnabled(TempTableDefinitionFilePropertyPage.this.likeDBTableToggle.getSelection());
                TempTableDefinitionFilePropertyPage.this.dialogChanged();
            }
        });
        this.label = new Label(container, 0);
        this.label.setText("Like Table:");
        GridData likeTableTextLData = new GridData();
        likeTableTextLData.grabExcessHorizontalSpace = true;
        likeTableTextLData.horizontalAlignment = 4;
        this.likeTableText = new Text(container, 2052);
        this.likeTableText.setLayoutData((Object)likeTableTextLData);
        this.likeTableText.setToolTipText("Name of the Database Table that is used in the \"like\" Definition");
        this.likeTableText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TempTableDefinitionFilePropertyPage.this.dialogChanged();
            }
        });
        this.label = new Label(container, 0);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void dialogChanged() {
        String ttName = this.ttNameText.getText();
        if (!ttName.startsWith("tt")) {
            this.updateStatus("Temp-Table Name should begin with 'tt'");
            return;
        }
        if (this.likeDBTableToggle.getSelection()) {
            if (this.likeTableText.getText().length() == 0) {
                this.updateStatus("Like Table has to be specified");
                return;
            }
            if (!this.repositoryInformations.exitsTableInRepository(this.likeTableText.getText()).booleanValue()) {
                this.updateStatus("Like Table does not exist");
                return;
            }
        }
        this.wizardMainPage.setFileDescriptionText("Definition of Temp-Table " + ttName);
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void initialize() {
        this.ttNameText.setText("tt");
        this.noundoToggle.setSelection(true);
        this.beforeTableToggle.setSelection(true);
        this.isReferenceOnly.setSelection(true);
        this.likeDBTableToggle.setSelection(true);
    }

    public String getTtName() {
        return this.ttNameText.getText();
    }

    public boolean getNoUndo() {
        return this.noundoToggle.getSelection();
    }

    public boolean getBeforeTable() {
        return this.beforeTableToggle.getSelection();
    }

    public boolean getReferenceOnly() {
        return this.isReferenceOnly.getSelection();
    }

    public String getLikeTable() {
        return this.likeTableText.getText();
    }

    public boolean getLikeDBTable() {
        return this.likeDBTableToggle.getSelection();
    }

    public void setWizardMainPage(WizardMainPage wizardMainPage) {
        this.wizardMainPage = wizardMainPage;
    }

    @Override
    public HashMap<String, Object> getSettings() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        wizardSettings.put("TempTableName", this.getTtName());
        wizardSettings.put("isNoUndo", this.getNoUndo() ? "true" : "false");
        wizardSettings.put("hasBeforeTable", this.getBeforeTable() ? "true" : "false");
        wizardSettings.put("isReferenceOnly", this.getReferenceOnly() ? "true" : "false");
        wizardSettings.put("isLikeDB", this.getLikeDBTable() ? "true" : "false");
        if (this.getLikeDBTable()) {
            wizardSettings.put("LikeDBTableName", this.getLikeTable());
        } else {
            wizardSettings.put("LikeDBTableName", "");
        }
        return wizardSettings;
    }
}

