/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.generator.BalpGenerator;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.generator.OOABLInterfaceFileGenerator;
import com.proalpha.pds.generator.TriggerFileGenerator;
import com.proalpha.pds.generator.UserExitFileGenerator;
import com.proalpha.pds.paconnector.ProjectHandler;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryFactory;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.userexit.UserExitDelegate;
import com.proalpha.pds.paconnector.userexit.UserExitFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import org.eclipse.core.resources.IProject;

public class GeneratorFactory {
    static IProject iproject;
    static OEProject currOEProject;
    static RunProgramInPa bridge;
    static RepositoryDelegate repositoryDelegate;
    static RepositoryInformations repositoryInformations;
    static StartparameterReader startparameterReader;
    static UserExitDelegate userExitDelegate;

    private GeneratorFactory() {
    }

    private static void InitBridge() {
        ProjectHandler currProj = new ProjectHandler();
        if (bridge == null || !bridge.getProject().equals((Object)currProj.getActiveProject())) {
            bridge = new RunProgramInPa((IOpenEdgeProject)currProj.getActiveOEProject());
        }
        currOEProject = currProj.getActiveOEProject();
    }

    public static BalpGenerator createBalpGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        UserExitDelegate userExitDelegate = GeneratorFactory.getUserExitDelegate();
        StartparameterReader startparameterReader = GeneratorFactory.getStartparameterReader();
        return new BalpGenerator(datacontainer, userExitDelegate, startparameterReader);
    }

    public static OOABLExitFileGenerator createOOABLExitFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName) {
        RepositoryDelegate repositoryDelegate = GeneratorFactory.getRepositoryDelegate();
        RepositoryInformations repositoryInformations = GeneratorFactory.getRepositoryInformations();
        return new OOABLExitFileGenerator(datacontainer, templateGeneratorName, repositoryDelegate, repositoryInformations);
    }

    public static OOABLInterfaceFileGenerator createOOABLInterfaceFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName) {
        RepositoryDelegate repositoryDelegate = GeneratorFactory.getRepositoryDelegate();
        RepositoryInformations repositoryInformations = GeneratorFactory.getRepositoryInformations();
        return new OOABLInterfaceFileGenerator(datacontainer, templateGeneratorName, repositoryDelegate, repositoryInformations);
    }

    public static TriggerFileGenerator createTriggerFileGenerator(IGeneratorDataContainer datacontainer) {
        return new TriggerFileGenerator(datacontainer);
    }

    public static UserExitFileGenerator createUserExitFileGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        UserExitDelegate userExitDelegate = GeneratorFactory.getUserExitDelegate();
        return new UserExitFileGenerator(datacontainer, userExitDelegate);
    }

    private static RepositoryDelegate getRepositoryDelegate() {
        if (repositoryDelegate == null) {
            GeneratorFactory.InitBridge();
            try {
                repositoryDelegate = RepositoryFactory.createRepositoryDelegate((OEProject)currOEProject);
            }
            catch (ProALPHANotAvailableException e) {
                e.printStackTrace();
            }
        }
        return repositoryDelegate;
    }

    private static RepositoryInformations getRepositoryInformations() {
        if (repositoryInformations == null) {
            GeneratorFactory.InitBridge();
            try {
                repositoryInformations = RepositoryFactory.createRepositoryInformations((OEProject)currOEProject);
            }
            catch (ProALPHANotAvailableException e) {
                e.printStackTrace();
            }
        }
        return repositoryInformations;
    }

    private static StartparameterReader getStartparameterReader() {
        if (startparameterReader == null) {
            try {
                GeneratorFactory.InitBridge();
                startparameterReader = ParameterFactory.createStartparameterReader((OEProject)currOEProject);
            }
            catch (ProALPHANotAvailableException e) {
                e.printStackTrace();
            }
        }
        return startparameterReader;
    }

    private static UserExitDelegate getUserExitDelegate() {
        if (userExitDelegate == null) {
            GeneratorFactory.InitBridge();
            try {
                userExitDelegate = UserExitFactory.createUserExitDelegate((OEProject)currOEProject, (StartparameterReader)GeneratorFactory.getStartparameterReader());
            }
            catch (ProALPHANotAvailableException e) {
                e.printStackTrace();
            }
        }
        return userExitDelegate;
    }
}

