/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.data;

import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.Activator;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.templates.helper.FileSystemUtils;
import com.proalpha.pds.templates.jaxb.TtUserExits;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

class GeneratorDataContainer
implements IGeneratorDataContainer {
    private Map<String, Object> wizardSettings = new HashMap<String, Object>();
    private IFile outputFile;
    private final StartparameterReader starparameterReader;
    private final RepositoryInformations repositoryInformations;
    private final RunProgramInPa bridge;

    public GeneratorDataContainer(Map<String, Object> data, RunProgramInPa bridge, StartparameterReader starparameterReader, RepositoryInformations repositoryInformations) {
        this.bridge = bridge;
        this.starparameterReader = starparameterReader;
        this.repositoryInformations = repositoryInformations;
        this.initializeDataContainer(data);
    }

    @Override
    public String getCustomLevel() {
        return this.getWizardSetting("CustomLevel");
    }

    @Override
    public Map<String, Object> getDataAsMap() {
        return this.wizardSettings;
    }

    @Override
    public String getDescription() {
        return this.getWizardSetting("Description");
    }

    @Override
    public String getFileName() {
        return this.getWizardSetting("FileName");
    }

    @Override
    public String getObjectInfo() {
        return this.getWizardSetting("ObjectInfo");
    }

    @Override
    public String getParentObject() {
        return this.getWizardSetting("ParentObject");
    }

    @Override
    public String getRelativePath() {
        return this.getWizardSetting("RelativePath");
    }

    @Override
    public String getTableName() {
        return this.getWizardSetting("TableName");
    }

    @Override
    public String getTriggerMode() {
        return this.getWizardSetting("TriggerMode");
    }

    @Override
    public String getVersion() {
        return this.getWizardSetting("Version");
    }

    private String getWizardSetting(String key) {
        return (String)this.wizardSettings.get(key);
    }

    private void initializeDataContainer(Map<String, Object> initializeData) {
        if (initializeData != null && initializeData.size() > 0) {
            this.wizardSettings.putAll(initializeData);
            if (this.wizardSettings.containsKey("FileName") && !this.wizardSettings.containsKey("RelativePath")) {
                this.setFileNameDependentAttrbutes(this.getFileName());
            }
        }
        this.setAuthor(this.starparameterReader.getAuthor());
        this.setShortcut(this.starparameterReader.getShortcut());
        this.setVersion(this.bridge.getProALPHAVersion());
        this.setSortCase(this.starparameterReader.getUserExitSortCase());
    }

    private void setFileNameDependentAttrbutes(String fileName) {
        this.setRelativePath(fileName);
        this.setProduct(this.repositoryInformations.getProductName(fileName));
        this.setProductDescription(this.repositoryInformations.getProductDescription(fileName));
        this.setModule(this.repositoryInformations.getModule(fileName));
        this.setModuleDescription(this.repositoryInformations.getModuleDescription(fileName));
    }

    private void setAuthor(String author) {
        this.setWizardSetting("Author", author);
    }

    @Override
    public void setBALPTemplateList(List<String> balpTemplateList) {
        this.wizardSettings.put("baltTemplateList", balpTemplateList);
    }

    @Override
    public void setCompanyInclude(String companyInclude) {
        this.setWizardSetting("CompanyInclude", companyInclude);
    }

    @Override
    public void setDescription(String description) {
        this.setWizardSetting("Description", description);
    }

    @Override
    public void setFileName(String fileName) {
        this.setWizardSetting("FileName", fileName);
        this.setFileNameDependentAttrbutes(fileName);
    }

    @Override
    public void setHasChangeLogEnglish(Boolean hasChangeLogEnglish) {
        this.setWizardSetting("ChangeLogEnglish", String.valueOf(hasChangeLogEnglish));
    }

    @Override
    public void setHasChangeLogGerman(Boolean hasChangeLogGerman) {
        this.setWizardSetting("ChangeLogGerman", String.valueOf(hasChangeLogGerman));
    }

    @Override
    public void setHasClassicLngTable(Boolean hasClassicLngTable) {
        this.setWizardSetting("hasClassicLngTable", String.valueOf(hasClassicLngTable));
    }

    @Override
    public void setHasCompanyField(Boolean hasCompanyField) {
        this.setWizardSetting("hasCompany", String.valueOf(hasCompanyField));
    }

    @Override
    public void setIsObjectID(Boolean isObjectID) {
        this.setWizardSetting("ObjID", String.valueOf(isObjectID));
    }

    @Override
    public void setMainClass(String mainClass) {
        this.setWizardSetting("MainClass", mainClass);
    }

    private void setModule(String module) {
        this.setWizardSetting("Module", module);
    }

    private void setModuleDescription(String moduleDescription) {
        this.setWizardSetting("ModuleDescription", moduleDescription);
    }

    @Override
    public void setParentObject(String parentClassName) {
        this.setWizardSetting("ParentObject", parentClassName);
    }

    private void setProduct(String productName) {
        this.setWizardSetting("Product", productName);
    }

    private void setProductDescription(String productDescription) {
        this.setWizardSetting("ProductDescription", productDescription);
    }

    @Override
    public void setQualifiedClassName(String qualifiedClassName) {
        this.setWizardSetting("QualifiedClassName", qualifiedClassName);
    }

    @Override
    public void setQualifiedClassParentClassName(String qualifiedParentClassName) {
        this.setWizardSetting("qualifiedParentClassName", qualifiedParentClassName);
    }

    private void setRelativePath(String fileName) {
        String relativePath = this.repositoryInformations.getRelativePath(fileName);
        this.setWizardSetting("RelativePath", relativePath);
    }

    private void setShortcut(String shortcut) {
        this.setWizardSetting("ShortCut", shortcut);
    }

    private void setSortCase(String sort) {
        this.setWizardSetting("sort", sort);
    }

    @Override
    public void setUserExitFiles(List<String> userExitList) {
        this.wizardSettings.put("userExitList", userExitList);
    }

    @Override
    public void setUserExits(List<TtUserExits.TtUserExitsRow> userExits) {
        this.wizardSettings.put("UserExits", userExits);
    }

    @Override
    public void setVersion(String proALPHAVersion) {
        this.setWizardSetting("Version", proALPHAVersion);
    }

    private void setWizardSetting(String key, String value) {
        this.wizardSettings.put(key, value);
    }

    @Override
    public void setXBaseName(String xbaseName) {
        this.setWizardSetting("XBaseName", xbaseName);
    }

    @Override
    public void setOutputFile(IFile file) {
        this.outputFile = file;
    }

    @Override
    public IFile getOutputFile() throws Exception {
        if (this.outputFile == null) {
            String container = this.getContainer();
            IFolder outputFolder = null;
            if (container != null) {
                outputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(container));
            }
            if (outputFolder == null) {
                outputFolder = this.starparameterReader.getWorkingDirectory();
            }
            this.outputFile = FileSystemUtils.createFileInWorkingDirectory(outputFolder, this.getRelativePath(), this.getFileName());
        }
        return this.outputFile;
    }

    private String getContainer() {
        return this.getWizardSetting("ContainerName");
    }

    @Override
    public Boolean isGenerationConfirmed() {
        try {
            return this.bridge.isproALPHAAvailable();
        }
        catch (Exception e) {
            String message = e.getMessage().length() > 0 ? e.getMessage() : "Could not confirm generation.";
            Status status = new Status(4, "com.proalpha.pds.templates", message);
            Activator.getDefault().getLog().log((IStatus)status);
            return Boolean.FALSE;
        }
    }

    @Override
    public void setCustomLevel(String customLevel) {
        this.setWizardSetting("CustomLevel", customLevel);
    }

    @Override
    public void setObjectInfo(String objectInfo) {
        this.setWizardSetting("ObjectInfo", objectInfo);
    }

    @Override
    public Map<String, Object> getWizardSettings() {
        return this.wizardSettings;
    }

    @Override
    public StartparameterReader getStarparameterReader() {
        return this.starparameterReader;
    }

    @Override
    public RepositoryInformations getRepositoryInformations() {
        return this.repositoryInformations;
    }

    @Override
    public void setTriggerMode(String triggerMode) {
        this.setWizardSetting("TriggerMode", triggerMode);
    }

    @Override
    public void setQualifiedClassStandardClassName(String qualifiedStandardClassName) {
        this.setWizardSetting("qualifiedStandardClassName", qualifiedStandardClassName);
    }

    @Override
    public void setTableName(String tableName) {
        this.setWizardSetting("TableName", tableName);
    }

    public Map<String, Object> cloneWizardSettings() {
        HashMap<String, Object> exitFileGeneratorSettings = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.wizardSettings.entrySet()) {
            exitFileGeneratorSettings.put(entry.getKey(), entry.getValue());
        }
        return exitFileGeneratorSettings;
    }

    @Override
    public String getSortCase() {
        return this.getWizardSetting("sort");
    }
}

