/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.data;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryFactory;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.data.GeneratorDataContainer;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataContainerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataContainerFactory.class);

    public IGeneratorDataContainer createDataContainer(IOpenEdgeProject activeProject) throws ProALPHANotAvailableException {
        return this.createDataContainer(activeProject, new HashMap<String, Object>());
    }

    public IGeneratorDataContainer createDataContainer(IOpenEdgeProject activeProject, Map<String, Object> settings) throws ProALPHANotAvailableException {
        GeneratorDataContainer generatorDataContainer;
        if (activeProject == null) {
            throw new ProALPHANotAvailableException("createDataContainer no active project");
        }
        try {
            RepositoryFactory repositoryFactory = new RepositoryFactory();
            RepositoryInformations repositoryInformations = repositoryFactory.createRepositoryInformations(activeProject);
            ParameterFactory parameterFactory = new ParameterFactory();
            StartparameterReader startparameterReader = parameterFactory.createStartparameterReader(repositoryInformations.getPaBridge());
            generatorDataContainer = new GeneratorDataContainer(settings, activeProject, repositoryInformations.getPaBridge(), startparameterReader, repositoryInformations);
        }
        catch (ProALPHANotAvailableException e) {
            generatorDataContainer = null;
            logger.error(e.getMessage(), (Throwable)e);
        }
        return generatorDataContainer;
    }
}

