/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.exception.ProALPHANotAvailableException;
import com.proalpha.pds.generator.BalpGenerator;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.generator.OOABLInterfaceFileGenerator;
import com.proalpha.pds.generator.TriggerFileGenerator;
import com.proalpha.pds.generator.UserExitFileGenerator;
import com.proalpha.pds.paconnector.ProjectHandler;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryFactory;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.userexit.UserExitDelegate;
import com.proalpha.pds.paconnector.userexit.UserExitFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorFactory {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorFactory.class);
    private IProject iproject;
    private OEProject currOEProject;
    private RunProgramInPa bridge;
    private RepositoryDelegate repositoryDelegate;
    private RepositoryInformations repositoryInformations;
    private StartparameterReader startparameterReader;
    private UserExitDelegate userExitDelegate;
    private UserExitFactory userExitFactory;

    private void initBridge(ProjectHandler handler) {
        this.currOEProject = handler.getActiveOEProject();
        if (!(this.bridge != null && this.bridge.getOEProject().getProject().equals((Object)this.currOEProject) || this.currOEProject == null)) {
            this.bridge = new RunProgramInPa((IOpenEdgeProject)this.currOEProject);
        }
    }

    public GeneratorFactory(ProjectHandler handler) {
        this.initBridge(handler);
        this.userExitFactory = new UserExitFactory();
    }

    public BalpGenerator createBalpGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        OEProject oeProject = (OEProject)datacontainer.getOEProject();
        UserExitDelegate userExitDelegate = this.getUserExitDelegate(oeProject);
        StartparameterReader startparameterReader = this.getStartparameterReader(oeProject);
        return new BalpGenerator(datacontainer, userExitDelegate, startparameterReader);
    }

    public OOABLExitFileGenerator createOOABLExitFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName) {
        OEProject oeProject = (OEProject)datacontainer.getOEProject();
        RepositoryDelegate repositoryDelegate = this.getRepositoryDelegate(oeProject);
        RepositoryInformations repositoryInformations = this.getRepositoryInformations(oeProject);
        return new OOABLExitFileGenerator(datacontainer, templateGeneratorName, repositoryDelegate, repositoryInformations);
    }

    public OOABLInterfaceFileGenerator createOOABLInterfaceFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName) {
        OEProject oeProject = (OEProject)datacontainer.getOEProject();
        RepositoryDelegate repositoryDelegate = this.getRepositoryDelegate(oeProject);
        RepositoryInformations repositoryInformations = this.getRepositoryInformations(oeProject);
        return new OOABLInterfaceFileGenerator(datacontainer, templateGeneratorName, repositoryDelegate, repositoryInformations);
    }

    public TriggerFileGenerator createTriggerFileGenerator(IGeneratorDataContainer datacontainer) {
        return new TriggerFileGenerator(datacontainer);
    }

    public UserExitFileGenerator createUserExitFileGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        UserExitDelegate userExitDelegate = this.getUserExitDelegate((OEProject)datacontainer.getOEProject());
        return new UserExitFileGenerator(datacontainer, userExitDelegate);
    }

    private RepositoryDelegate getRepositoryDelegate(OEProject project) {
        if (this.repositoryDelegate == null) {
            try {
                RepositoryFactory factory = new RepositoryFactory();
                this.repositoryDelegate = factory.createRepositoryDelegate((IOpenEdgeProject)project);
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.repositoryDelegate;
    }

    private RepositoryInformations getRepositoryInformations(OEProject project) {
        if (this.repositoryInformations == null) {
            try {
                RepositoryFactory factory = new RepositoryFactory();
                this.repositoryInformations = factory.createRepositoryInformations((IOpenEdgeProject)project);
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.repositoryInformations;
    }

    private StartparameterReader getStartparameterReader(OEProject project) {
        if (this.startparameterReader == null) {
            try {
                ParameterFactory parameterFactory = new ParameterFactory();
                this.startparameterReader = parameterFactory.createStartparameterReader(project);
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.startparameterReader;
    }

    private UserExitDelegate getUserExitDelegate(OEProject project) {
        if (this.userExitDelegate == null) {
            try {
                this.userExitDelegate = this.userExitFactory.createUserExitDelegate(project, this.getStartparameterReader(project));
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.userExitDelegate;
    }

    public IProject getIproject() {
        return this.iproject;
    }

    public void setIproject(IProject iproject) {
        this.iproject = iproject;
    }
}

